/* $Id: jmpost.h,v 1.2 1999/09/29 01:38:50 hideyuki Exp $ */

#ifndef JMPOST_H
#define JMPOST_H

#include <kanji.h>  /* <cpascal.h> */

#ifdef MP
const_string based_prog_name="MetaPost";
const char *JMPHELP[] = {
"Usage: jmpost [OPTION]... [MPNAME[.mp]] [COMMANDS]",
"   or: jmpost [OPTION]... \\FIRST-LINE",
"   or: jmpost [OPTION]... &MEM ARGS",
"  Run jMetaPost on MPNAME, usually creating MPNAME.NNN (and perhaps",
"  MPNAME.tfm), where NNN are the character numbers generated.",
"  Any remaining COMMANDS are processed as jMetaPost input,",
"  after MPNAME is read.",
"  If the first line of MPNAME is %&MEM, and MEM is an existing .mem file,",
"  use it. Else use `NAME.mem', where NAME is the program",
"  invocation name, most commonly `jmpost'.",
"",
"  Alternatively, if the first non-option argument begins with a backslash,",
"  interpret all non-option arguments as a line of jMetaPost input.",
"",
"  Alternatively, if the first non-option argument begins with a &, the",
"  next word is taken as the MEM to read, overriding all else.  Any",
"  remaining arguments are processed as above.",
"",
"  If no arguments or options are specified, prompt for input.",
"",
"-file-line-error-style   print file:line:error style messages",
"-ini                     be inijmpost, for dumping mems; this is implicitly",
"                          true if the program name is `inijmpost'",
"-interaction=STRING      set interaction mode (STRING=batchmode/nonstopmode/",
"                          scrollmode/errorstopmode)",
"-jobname=STRING          set the job name to STRING",
"-kanji=STRING            set Japanese encoding (STRING=euc|jis|sjis)",
"-kpathsea-debug=NUMBER   set path searching debugging flags according to",
"                          the bits of NUMBER",
"-mem=MEMNAME             use MEMNAME instead of program name or a %& line",
"-output-directory=DIR    use DIR as the directory to write files to",
"-progname=STRING         set program (and mem) name to STRING",
"-parse-first-line        parse of the first line of the input file",
"-recorder                enable filename recorder",
"-tex=TEXPROGRAM          use TEXPROGRAM for text labels.",
"-translate-file=TCXNAME  use the TCX file TCXNAME",
"-T, -troff               set the prologues variable, use `makempx -troff'",
"-help                    display this help and exit",
"-version                 output version information and exit",
NULL
};
#endif /* MP */

#if defined(PDVITOMP)
const_string based_prog_name="DVItoMP";
/* localization maintainers and bug report address */
const_string local_maintainer="Hideyuki Suzuki";

const char *PDVITOMPHELP[] = {
"Usage: pdvitomp [OPTION]... DVIFILE[.dvi] [MPXFILE[.mpx]]",
"  Translate DVIFILE to the MetaPost MPXFILE.",
"  Default MPXFILE is basename of DVIFILE extended with `.mpx'.",
"",
"-help                  display this help and exit",
"-version               output version information and exit",
"-kanji={jis|euc|sjis}  set Japanese encoding",
NULL
};
#endif /* PDVITOMP */

#endif /* JMPOST_H */
