/* PR c/102989 */
/* { dg-do run { target bitint } } */
/* { dg-options "-std=c23" } */
/* { dg-skip-if "" { ! run_expensive_tests }  { "*" } { "-O0" "-O2" } } */
/* { dg-skip-if "" { ! run_expensive_tests } { "-flto" } { "" } } */

#if __LDBL_MANT_DIG__ == 64
#if __BITINT_MAXWIDTH__ >= 135
__attribute__((noipa)) _BitInt(135)
testldbl_135 (long double d)
{
  return d;
}

__attribute__((noipa)) unsigned _BitInt(135)
testldblu_135 (long double d)
{
  return d;
}
#endif

#if __BITINT_MAXWIDTH__ >= 192
__attribute__((noipa)) _BitInt(192)
testldbl_192 (long double d)
{
  return d;
}

__attribute__((noipa)) unsigned _BitInt(192)
testldblu_192 (long double d)
{
  return d;
}
#endif

#if __BITINT_MAXWIDTH__ >= 575
__attribute__((noipa)) _BitInt(575)
testldbl_575 (long double d)
{
  return d;
}

__attribute__((noipa)) unsigned _BitInt(575)
testldblu_575 (long double d)
{
  return d;
}
#endif
#endif

#if __FLT128_MANT_DIG__ == 113
#if __BITINT_MAXWIDTH__ >= 135
__attribute__((noipa)) _BitInt(135)
testflt128_135 (_Float128 d)
{
  return d;
}

__attribute__((noipa)) unsigned _BitInt(135)
testflt128u_135 (_Float128 d)
{
  return d;
}
#endif

#if __BITINT_MAXWIDTH__ >= 192
__attribute__((noipa)) _BitInt(192)
testflt128_192 (_Float128 d)
{
  return d;
}

__attribute__((noipa)) unsigned _BitInt(192)
testflt128u_192 (_Float128 d)
{
  return d;
}
#endif

#if __BITINT_MAXWIDTH__ >= 575
__attribute__((noipa)) _BitInt(575)
testflt128_575 (_Float128 d)
{
  return d;
}

__attribute__((noipa)) unsigned _BitInt(575)
testflt128u_575 (_Float128 d)
{
  return d;
}
#endif
#endif

int
main ()
{
#if __LDBL_MANT_DIG__ == 64
#if __BITINT_MAXWIDTH__ >= 135
  static long double ldbl_135[] = {
    -0.96875L, -0.25L, -0.0L, 0.25L, 0.0L, 1.0L, -42.0L, 4294967295.25L,
    -8790480341948727187.25L, 27274375615880435204096.0L,
    -14925443517338257613013233930892304449536.0L,
    -21778071482940061661655974875633165533184.0L
  };
  static _BitInt(135) ldblr_135[] = {
    0wb, 0wb, 0wb, 0wb, 0wb, 1wb, -42wb, 4294967295wb,
    -8790480341948727187wb, 27274375615880435204096wb,
    -14925443517338257613013233930892304449536wb,
    -21778071482940061661655974875633165533183wb - 1wb
  };
  for (int i = 0; i < 12; ++i)
    if (testldbl_135 (ldbl_135[i]) != ldblr_135[i])
      __builtin_abort ();
  static long double ldblu_135[] = {
    -0.9921875L, -0.75L, -0.0L, 0.125L, 0.0L, 1.0L, 42.59375L, 4294967295.75L,
    176563931524327024.5L, 33864941055480177570480471932928.0L,
    25454535165593017203571842988709209178112.0L
  };
  static unsigned _BitInt(135) ldblur_135[] = {
    0uwb, 0uwb, 0uwb, 0uwb, 0uwb, 1uwb, 42uwb, 4294967295uwb,
    176563931524327024uwb, 33864941055480177570480471932928uwb,
    25454535165593017203571842988709209178112uwb
  };
  for (int i = 0; i < 11; ++i)
    if (testldblu_135 (ldblu_135[i]) != ldblur_135[i])
      __builtin_abort ();
#endif
#if __BITINT_MAXWIDTH__ >= 192
  static long double ldbl_192[] = {
    -1.0L, -0.998046875L, -0.5L, -0.0L, 0.625L, 0.0L, 1.0L, -42.0L, 4294967295.25L,
    -5824742198306330891.5L, 440458331210868742661519441920.0L,
    1835666805014205039814897225189119947560942436848001613824.0L,
    -3138550867693340381917894711603833208051177722232017256448.0L
  };
  static _BitInt(192) ldblr_192[] = {
    -1wb, 0wb, 0wb, 0wb, 0wb, 0wb, 1wb, -42wb, 4294967295wb,
    -5824742198306330891wb, 440458331210868742661519441920wb,
    1835666805014205039814897225189119947560942436848001613824wb,
    -3138550867693340381917894711603833208051177722232017256447wb - 1wb
  };
  for (int i = 0; i < 13; ++i)
    if (testldbl_192 (ldbl_192[i]) != ldblr_192[i])
      __builtin_abort ();
  static long double ldblu_192[] = {
    -0.99951171875L, -0.125L, -0.0L, __LDBL_MIN__, 0.0L, 1.0L, 42.125L, 4294967296.75L,
    2076918887405157419.75L, 20675944534182826922963677915852149395069559898112.0L,
    5501434424609388038261967254007295028886638351806353113088.0L
  };
  static unsigned _BitInt(192) ldblur_192[] = {
    0uwb, 0uwb, 0uwb, 0uwb, 0uwb, 1uwb, 42uwb, 4294967296uwb,
    2076918887405157419uwb, 20675944534182826922963677915852149395069559898112uwb,
    5501434424609388038261967254007295028886638351806353113088uwb
  };
  for (int i = 0; i < 11; ++i)
    if (testldblu_192 (ldblu_192[i]) != ldblur_192[i])
      __builtin_abort ();
#endif
#if __BITINT_MAXWIDTH__ >= 575
  static long double ldbl_575[] = {
    -1.00048828125L, -0.999755859375L, -0.0625L, -0.0L, 0.0001L, 0.0L, 1.0L, -28.0L, 4294967294.75L,
    -3665832965020207456.5L, 163698889538251840454153874702336.0L,
    32915174451748642699300864037265677114762093753017270154115822402734463611341115095984060833654391570465670441530007982951775959694729040694137686724336684263404019031998464.0L,
    -61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174784.0L
  };
  static _BitInt(575) ldblr_575[] = {
    -1wb, 0wb, 0wb, 0wb, 0wb, 0wb, 1wb, -28wb, 4294967294wb,
    -3665832965020207456wb, 163698889538251840454153874702336wb,
    32915174451748642699300864037265677114762093753017270154115822402734463611341115095984060833654391570465670441530007982951775959694729040694137686724336684263404019031998464wb,
    -61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb - 1wb
  };
  for (int i = 0; i < 13; ++i)
    if (testldbl_575 (ldbl_575[i]) != ldblr_575[i])
      __builtin_abort ();
  static long double ldblu_575[] = {
    -0.9998779296875L, -0.5L, -0.0L, 4.0L * __LDBL_MIN__, 0.0L, 1.0L, 38.125L, 4294967297.75L,
    1378703406647015633.75L, 611519358004879551476944320883148018860550235384446976.0L,
    115943866857281393364910134541262519802574312323472821552898049002204954780753923929784955305825114286696121504922573067409422635510048274769753298552619702526028834918105088.0L
  };
  static unsigned _BitInt(575) ldblur_575[] = {
    0uwb, 0uwb, 0uwb, 0uwb, 0uwb, 1uwb, 38uwb, 4294967297uwb,
    1378703406647015633uwb, 611519358004879551476944320883148018860550235384446976uwb,
    115943866857281393364910134541262519802574312323472821552898049002204954780753923929784955305825114286696121504922573067409422635510048274769753298552619702526028834918105088uwb
  };
  for (int i = 0; i < 11; ++i)
    if (testldblu_575 (ldblu_575[i]) != ldblur_575[i])
      __builtin_abort ();
#endif
#endif
#if __FLT128_MANT_DIG__ == 113
#if __BITINT_MAXWIDTH__ >= 135
  static _Float128 flt128_135[] = {
    -1.0F128, -0.999969482421875F128, -0.5F128, -0.0F128, 0.25F128, 0.0F128,
    1.0F128, -42.0F128, 4294967295.25F128,
    -622114258022893415468272077014949.5F128, 6846686534183872435237780851340978176.0F128,
    -18109992041001989671440396535501724581888.0F128,
    -21778071482940061661655974875633165533184.0F128
  };
  static _BitInt(135) flt128r_135[] = {
    -1wb, 0wb, 0wb, 0wb, 0wb, 0wb, 1wb, -42wb, 4294967295wb,
    -622114258022893415468272077014949wb, 6846686534183872435237780851340978176wb,
    -18109992041001989671440396535501724581888wb,
    -21778071482940061661655974875633165533183wb - 1wb
  };
  for (int i = 0; i < 13; ++i)
    if (testflt128_135 (flt128_135[i]) != flt128r_135[i])
      __builtin_abort ();
  static _Float128 flt128u_135[] = {
    -0.9999847412109375F128, -0.25F128, -0.0F128, 0.125F128, 0.0F128, 1.0F128,
    42.59375F128, 4294967295.75F128,
    3866883549893778868343627501393297.5F128, 1884508847679496004639718578196282112.0F128,
    40418154190724512480670668005754087145472.0F128
  };
  static unsigned _BitInt(135) flt128ur_135[] = {
    0uwb, 0uwb, 0uwb, 0uwb, 0uwb, 1uwb, 42uwb, 4294967295uwb,
    3866883549893778868343627501393297uwb, 1884508847679496004639718578196282112uwb,
    40418154190724512480670668005754087145472uwb
  };
  for (int i = 0; i < 11; ++i)
    if (testflt128u_135 (flt128u_135[i]) != flt128ur_135[i])
      __builtin_abort ();
#endif
#if __BITINT_MAXWIDTH__ >= 192
  static _Float128 flt128_192[] = {
    -0.99999237060546875F128, -0.75F128, -0.0F128, 0.625F128, 0.0F128, 1.0F128, -42.0F128, 4294967295.25F128,
    -2985198467222342042164811285508981.5F128, 431282768955649236431442335280406747022360576.0F128,
    1589969577168452878096502186670522088231011726426596442112.0F128,
    -3138550867693340381917894711603833208051177722232017256448.0F128
  };
  static _BitInt(192) flt128r_192[] = {
    0wb, 0wb, 0wb, 0wb, 0wb, 1wb, -42wb, 4294967295wb,
    -2985198467222342042164811285508981wb, 431282768955649236431442335280406747022360576wb,
    1589969577168452878096502186670522088231011726426596442112wb,
    -3138550867693340381917894711603833208051177722232017256447wb - 1wb
  };
  for (int i = 0; i < 12; ++i)
    if (testflt128_192 (flt128_192[i]) != flt128r_192[i])
      __builtin_abort ();
  static _Float128 flt128u_192[] = {
    -0.999996185302734375F128, -0.0625F128, -0.0F128, __FLT128_MIN__, 0.0F128, 1.0F128, 42.125F128, 4294967296.75F128,
    1198221816583045676753413578483973.75F128, 321058543109670204450967161534914741927936.0F128,
    4124250833671183507048495617931376186682553019928355536896.0F128
  };
  static unsigned _BitInt(192) flt128ur_192[] = {
    0uwb, 0uwb, 0uwb, 0uwb, 0uwb, 1uwb, 42uwb, 4294967296uwb,
    1198221816583045676753413578483973uwb, 321058543109670204450967161534914741927936uwb,
    4124250833671183507048495617931376186682553019928355536896uwb
  };
  for (int i = 0; i < 11; ++i)
    if (testflt128u_192 (flt128u_192[i]) != flt128ur_192[i])
      __builtin_abort ();
#endif
#if __BITINT_MAXWIDTH__ >= 575
  static _Float128 flt128_575[] = {
    -1.0000019073486328125F128, -0.9999980926513671875F128, -0.125F128, -0.0F128, 0.0001F128, 0.0F128, 1.0F128, -28.0F128, 4294967294.75F128,
    -4434536963340205213805292449887836.5F128, 7798956314177801818163892326325236647148010864640.0F128,
    -48379475169482975928082617475070980956970510451882414558095669485086407691242420689411465910847147042640064381848760072045866350077715681395831023828798188292450661613699072.0F128,
    -61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174784.0F128
  };
  static _BitInt(575) flt128r_575[] = {
    -1wb, 0wb, 0wb, 0wb, 0wb, 0wb, 1wb, -28wb, 4294967294wb,
    -4434536963340205213805292449887836wb, 7798956314177801818163892326325236647148010864640wb,
    -48379475169482975928082617475070980956970510451882414558095669485086407691242420689411465910847147042640064381848760072045866350077715681395831023828798188292450661613699072wb,
    -61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb - 1wb
  };
  for (int i = 0; i < 13; ++i)
    if (testflt128_575 (flt128_575[i]) != flt128r_575[i])
      __builtin_abort ();
  static _Float128 flt128u_575[] = {
    -0.99999904632568359375F128, -0.75F128, -0.0F128, 4.0F128 * __FLT128_MIN__, 0.0F128, 1.0F128, 38.125F128, 4294967297.75F128,
    1286565442597535616086070715374552.75F128, 2888274376848382435313359223769917404575136171432777745913780227423600640.0F128,
    101012352069182509789055890148950528106809264092697629422634347377509770791198015780931797016594366657511165718215124632216959526129296364564413818230848005073384975475146752.0F128
  };
  static unsigned _BitInt(575) flt128ur_575[] = {
    0uwb, 0uwb, 0uwb, 0uwb, 0uwb, 1uwb, 38uwb, 4294967297uwb,
    1286565442597535616086070715374552uwb, 2888274376848382435313359223769917404575136171432777745913780227423600640uwb,
    101012352069182509789055890148950528106809264092697629422634347377509770791198015780931797016594366657511165718215124632216959526129296364564413818230848005073384975475146752uwb
  };
  for (int i = 0; i < 11; ++i)
    if (testflt128u_575 (flt128u_575[i]) != flt128ur_575[i])
      __builtin_abort ();
#endif
#endif
}
