/*********************************************************************/
/* Copyright 2009, 2010 The University of Texas at Austin.           */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/*   1. Redistributions of source code must retain the above         */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer.                                                  */
/*                                                                   */
/*   2. Redistributions in binary form must reproduce the above      */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer in the documentation and/or other materials       */
/*      provided with the distribution.                              */
/*                                                                   */
/*    THIS  SOFTWARE IS PROVIDED  BY THE  UNIVERSITY OF  TEXAS AT    */
/*    AUSTIN  ``AS IS''  AND ANY  EXPRESS OR  IMPLIED WARRANTIES,    */
/*    INCLUDING, BUT  NOT LIMITED  TO, THE IMPLIED  WARRANTIES OF    */
/*    MERCHANTABILITY  AND FITNESS FOR  A PARTICULAR  PURPOSE ARE    */
/*    DISCLAIMED.  IN  NO EVENT SHALL THE UNIVERSITY  OF TEXAS AT    */
/*    AUSTIN OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT,    */
/*    INCIDENTAL,  SPECIAL, EXEMPLARY,  OR  CONSEQUENTIAL DAMAGES    */
/*    (INCLUDING, BUT  NOT LIMITED TO,  PROCUREMENT OF SUBSTITUTE    */
/*    GOODS  OR  SERVICES; LOSS  OF  USE,  DATA,  OR PROFI_SKYLAKEX;  OR    */
/*    BUSINESS INTERRUPTION) HOWEVER CAUSED  AND ON ANY THEORY OF    */
/*    LIABILITY, WHETHER  IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*    (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY WAY OUT    */
/*    OF  THE  USE OF  THIS  SOFTWARE,  EVEN  IF ADVISED  OF  THE    */
/*    POSSIBILITY OF SUCH DAMAGE.                                    */
/*                                                                   */
/* The views and conclusions contained in the software and           */
/* documentation are those of the authors and should not be          */
/* interpreted as representing official policies, either expressed   */
/* or implied, of The University of Texas at Austin.                 */
/*********************************************************************/

#include <stdio.h>
#include <string.h>
#include "common.h"

#ifdef BUILD_KERNEL
#include "kernel_SKYLAKEX.h"
#endif

#undef DEBUG

static void init_parameter(void);

gotoblas_t TABLE_NAME = {
  DTB_DEFAULT_ENTRIES ,

  GEMM_DEFAULT_OFFSET_A, GEMM_DEFAULT_OFFSET_B, GEMM_DEFAULT_ALIGN,

#ifdef BUILD_BFLOAT16
  0, 0, 0,
  SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N,
#ifdef SBGEMM_DEFAULT_UNROLL_MN
 SBGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N),
#endif

  SBGEMM_ALIGN_K,

  sbstobf16_k_SKYLAKEX, sbdtobf16_k_SKYLAKEX, sbf16tos_k_SKYLAKEX, dbf16tod_k_SKYLAKEX,

  samax_k_SKYLAKEX,  samin_k_SKYLAKEX,  smax_k_SKYLAKEX,  smin_k_SKYLAKEX,
  isamax_k_SKYLAKEX, isamin_k_SKYLAKEX, ismax_k_SKYLAKEX, ismin_k_SKYLAKEX,
  snrm2_k_SKYLAKEX,  sasum_k_SKYLAKEX, ssum_k_SKYLAKEX, scopy_k_SKYLAKEX, sbdot_k_SKYLAKEX,
  dsdot_k_SKYLAKEX,
  srot_k_SKYLAKEX,   saxpy_k_SKYLAKEX,  sscal_k_SKYLAKEX, sswap_k_SKYLAKEX,
  sbgemv_n_SKYLAKEX, sbgemv_t_SKYLAKEX, sger_k_SKYLAKEX,
  ssymv_L_SKYLAKEX, ssymv_U_SKYLAKEX,

  sbgemm_kernel_SKYLAKEX, sbgemm_beta_SKYLAKEX,
#if SBGEMM_DEFAULT_UNROLL_M != SBGEMM_DEFAULT_UNROLL_N
  sbgemm_incopy_SKYLAKEX, sbgemm_itcopy_SKYLAKEX,
#else
  sbgemm_oncopy_SKYLAKEX, sbgemm_otcopy_SKYLAKEX,
#endif
  sbgemm_oncopy_SKYLAKEX, sbgemm_otcopy_SKYLAKEX,

  strsm_kernel_LN_SKYLAKEX, strsm_kernel_LT_SKYLAKEX, strsm_kernel_RN_SKYLAKEX, strsm_kernel_RT_SKYLAKEX,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_SKYLAKEX, strsm_iunncopy_SKYLAKEX, strsm_iutucopy_SKYLAKEX, strsm_iutncopy_SKYLAKEX,
  strsm_ilnucopy_SKYLAKEX, strsm_ilnncopy_SKYLAKEX, strsm_iltucopy_SKYLAKEX, strsm_iltncopy_SKYLAKEX,
#else
  strsm_ounucopy_SKYLAKEX, strsm_ounncopy_SKYLAKEX, strsm_outucopy_SKYLAKEX, strsm_outncopy_SKYLAKEX,
  strsm_olnucopy_SKYLAKEX, strsm_olnncopy_SKYLAKEX, strsm_oltucopy_SKYLAKEX, strsm_oltncopy_SKYLAKEX,
#endif
  strsm_ounucopy_SKYLAKEX, strsm_ounncopy_SKYLAKEX, strsm_outucopy_SKYLAKEX, strsm_outncopy_SKYLAKEX,
  strsm_olnucopy_SKYLAKEX, strsm_olnncopy_SKYLAKEX, strsm_oltucopy_SKYLAKEX, strsm_oltncopy_SKYLAKEX,
  strmm_kernel_RN_SKYLAKEX, strmm_kernel_RT_SKYLAKEX, strmm_kernel_LN_SKYLAKEX, strmm_kernel_LT_SKYLAKEX,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_SKYLAKEX, strmm_iunncopy_SKYLAKEX, strmm_iutucopy_SKYLAKEX, strmm_iutncopy_SKYLAKEX,
  strmm_ilnucopy_SKYLAKEX, strmm_ilnncopy_SKYLAKEX, strmm_iltucopy_SKYLAKEX, strmm_iltncopy_SKYLAKEX,
#else
  strmm_ounucopy_SKYLAKEX, strmm_ounncopy_SKYLAKEX, strmm_outucopy_SKYLAKEX, strmm_outncopy_SKYLAKEX,
  strmm_olnucopy_SKYLAKEX, strmm_olnncopy_SKYLAKEX, strmm_oltucopy_SKYLAKEX, strmm_oltncopy_SKYLAKEX,
#endif
  strmm_ounucopy_SKYLAKEX, strmm_ounncopy_SKYLAKEX, strmm_outucopy_SKYLAKEX, strmm_outncopy_SKYLAKEX,
  strmm_olnucopy_SKYLAKEX, strmm_olnncopy_SKYLAKEX, strmm_oltucopy_SKYLAKEX, strmm_oltncopy_SKYLAKEX,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_SKYLAKEX, ssymm_iltcopy_SKYLAKEX,
#else
  ssymm_outcopy_SKYLAKEX, ssymm_oltcopy_SKYLAKEX,
#endif
  ssymm_outcopy_SKYLAKEX, ssymm_oltcopy_SKYLAKEX,

#ifndef NO_LAPACK
  sneg_tcopy_SKYLAKEX, slaswp_ncopy_SKYLAKEX,
#else
  NULL,NULL,
#endif
#ifdef SMALL_MATRIX_OPT
  sbgemm_small_matrix_permit_SKYLAKEX,
  sbgemm_small_kernel_nn_SKYLAKEX, sbgemm_small_kernel_nt_SKYLAKEX, sbgemm_small_kernel_tn_SKYLAKEX, sbgemm_small_kernel_tt_SKYLAKEX,
  sbgemm_small_kernel_b0_nn_SKYLAKEX, sbgemm_small_kernel_b0_nt_SKYLAKEX, sbgemm_small_kernel_b0_tn_SKYLAKEX, sbgemm_small_kernel_b0_tt_SKYLAKEX,
#endif
#endif

#if ( BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  0, 0, 0,
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N,
#ifdef SGEMM_DEFAULT_UNROLL_MN
 SGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif
#endif

#ifdef HAVE_EXCLUSIVE_CACHE
  1,
#else
  0,
#endif

#if (BUILD_SINGLE==1 ) || (BUILD_COMPLEX==1)
  samax_k_SKYLAKEX,  samin_k_SKYLAKEX,  smax_k_SKYLAKEX,  smin_k_SKYLAKEX,
#endif
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  isamax_k_SKYLAKEX,
#endif 
#if (BUILD_SINGLE==1 ) || (BUILD_COMPLEX==1)
  isamin_k_SKYLAKEX, ismax_k_SKYLAKEX, ismin_k_SKYLAKEX,
  snrm2_k_SKYLAKEX,  sasum_k_SKYLAKEX,
#endif 
#if BUILD_SINGLE == 1  
  ssum_k_SKYLAKEX,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  scopy_k_SKYLAKEX, sdot_k_SKYLAKEX,
//  dsdot_k_SKYLAKEX,
  srot_k_SKYLAKEX,   saxpy_k_SKYLAKEX,  
#endif
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  sscal_k_SKYLAKEX,
#endif 
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  sswap_k_SKYLAKEX,
  sgemv_n_SKYLAKEX,  sgemv_t_SKYLAKEX,
#endif
#if BUILD_SINGLE == 1
  sger_k_SKYLAKEX,
#endif
#if BUILD_SINGLE == 1  
  ssymv_L_SKYLAKEX, ssymv_U_SKYLAKEX,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
#ifdef ARCH_X86_64
  sgemm_direct_SKYLAKEX,
  sgemm_direct_performant_SKYLAKEX,	
#endif

  sgemm_kernel_SKYLAKEX, sgemm_beta_SKYLAKEX,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  sgemm_incopy_SKYLAKEX, sgemm_itcopy_SKYLAKEX,
#else
  sgemm_oncopy_SKYLAKEX, sgemm_otcopy_SKYLAKEX,
#endif
  sgemm_oncopy_SKYLAKEX, sgemm_otcopy_SKYLAKEX,
#endif

#if BUILD_SINGLE == 1 || BUILD_DOUBLE == 1 || BUILD_COMPLEX == 1
#ifdef SMALL_MATRIX_OPT
  sgemm_small_matrix_permit_SKYLAKEX,
  sgemm_small_kernel_nn_SKYLAKEX, sgemm_small_kernel_nt_SKYLAKEX, sgemm_small_kernel_tn_SKYLAKEX, sgemm_small_kernel_tt_SKYLAKEX,
  sgemm_small_kernel_b0_nn_SKYLAKEX, sgemm_small_kernel_b0_nt_SKYLAKEX, sgemm_small_kernel_b0_tn_SKYLAKEX, sgemm_small_kernel_b0_tt_SKYLAKEX,
#endif
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX == 1)
  strsm_kernel_LN_SKYLAKEX, strsm_kernel_LT_SKYLAKEX, strsm_kernel_RN_SKYLAKEX, strsm_kernel_RT_SKYLAKEX,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_SKYLAKEX, strsm_iunncopy_SKYLAKEX, strsm_iutucopy_SKYLAKEX, strsm_iutncopy_SKYLAKEX,
  strsm_ilnucopy_SKYLAKEX, strsm_ilnncopy_SKYLAKEX, strsm_iltucopy_SKYLAKEX, strsm_iltncopy_SKYLAKEX,
#else
  strsm_ounucopy_SKYLAKEX, strsm_ounncopy_SKYLAKEX, strsm_outucopy_SKYLAKEX, strsm_outncopy_SKYLAKEX,
  strsm_olnucopy_SKYLAKEX, strsm_olnncopy_SKYLAKEX, strsm_oltucopy_SKYLAKEX, strsm_oltncopy_SKYLAKEX,
#endif
  strsm_ounucopy_SKYLAKEX, strsm_ounncopy_SKYLAKEX, strsm_outucopy_SKYLAKEX, strsm_outncopy_SKYLAKEX,
  strsm_olnucopy_SKYLAKEX, strsm_olnncopy_SKYLAKEX, strsm_oltucopy_SKYLAKEX, strsm_oltncopy_SKYLAKEX,
#endif
#if (BUILD_SINGLE==1)
  strmm_kernel_RN_SKYLAKEX, strmm_kernel_RT_SKYLAKEX, strmm_kernel_LN_SKYLAKEX, strmm_kernel_LT_SKYLAKEX,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_SKYLAKEX, strmm_iunncopy_SKYLAKEX, strmm_iutucopy_SKYLAKEX, strmm_iutncopy_SKYLAKEX,
  strmm_ilnucopy_SKYLAKEX, strmm_ilnncopy_SKYLAKEX, strmm_iltucopy_SKYLAKEX, strmm_iltncopy_SKYLAKEX,
#else
  strmm_ounucopy_SKYLAKEX, strmm_ounncopy_SKYLAKEX, strmm_outucopy_SKYLAKEX, strmm_outncopy_SKYLAKEX,
  strmm_olnucopy_SKYLAKEX, strmm_olnncopy_SKYLAKEX, strmm_oltucopy_SKYLAKEX, strmm_oltncopy_SKYLAKEX,
#endif
  strmm_ounucopy_SKYLAKEX, strmm_ounncopy_SKYLAKEX, strmm_outucopy_SKYLAKEX, strmm_outncopy_SKYLAKEX,
  strmm_olnucopy_SKYLAKEX, strmm_olnncopy_SKYLAKEX, strmm_oltucopy_SKYLAKEX, strmm_oltncopy_SKYLAKEX,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_SKYLAKEX, ssymm_iltcopy_SKYLAKEX,
#else
  ssymm_outcopy_SKYLAKEX, ssymm_oltcopy_SKYLAKEX,
#endif
  ssymm_outcopy_SKYLAKEX, ssymm_oltcopy_SKYLAKEX,
#ifndef NO_LAPACK
  sneg_tcopy_SKYLAKEX, slaswp_ncopy_SKYLAKEX,
#else
  NULL,NULL,
#endif
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  0, 0, 0,
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N,
#ifdef DGEMM_DEFAULT_UNROLL_MN
 DGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif
#endif


#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  damax_k_SKYLAKEX,  damin_k_SKYLAKEX,  dmax_k_SKYLAKEX,  dmin_k_SKYLAKEX,
  idamax_k_SKYLAKEX, idamin_k_SKYLAKEX, idmax_k_SKYLAKEX, idmin_k_SKYLAKEX,
  dnrm2_k_SKYLAKEX, dasum_k_SKYLAKEX,
#endif  
#if  (BUILD_DOUBLE==1)  
  dsum_k_SKYLAKEX,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  dcopy_k_SKYLAKEX, ddot_k_SKYLAKEX,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)  
  dsdot_k_SKYLAKEX,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  drot_k_SKYLAKEX,
  daxpy_k_SKYLAKEX,
  dscal_k_SKYLAKEX, 
  dswap_k_SKYLAKEX,
  dgemv_n_SKYLAKEX,  dgemv_t_SKYLAKEX,
#endif
#if  (BUILD_DOUBLE==1)  
  dger_k_SKYLAKEX,
  dsymv_L_SKYLAKEX,  dsymv_U_SKYLAKEX,
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  dgemm_kernel_SKYLAKEX, dgemm_beta_SKYLAKEX,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dgemm_incopy_SKYLAKEX, dgemm_itcopy_SKYLAKEX,
#else
  dgemm_oncopy_SKYLAKEX, dgemm_otcopy_SKYLAKEX,
#endif
  dgemm_oncopy_SKYLAKEX, dgemm_otcopy_SKYLAKEX,
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
#ifdef SMALL_MATRIX_OPT
  dgemm_small_matrix_permit_SKYLAKEX,
  dgemm_small_kernel_nn_SKYLAKEX, dgemm_small_kernel_nt_SKYLAKEX, dgemm_small_kernel_tn_SKYLAKEX, dgemm_small_kernel_tt_SKYLAKEX,
  dgemm_small_kernel_b0_nn_SKYLAKEX, dgemm_small_kernel_b0_nt_SKYLAKEX, dgemm_small_kernel_b0_tn_SKYLAKEX, dgemm_small_kernel_b0_tt_SKYLAKEX,
#endif
#endif
#if  (BUILD_DOUBLE==1)   
  dtrsm_kernel_LN_SKYLAKEX, dtrsm_kernel_LT_SKYLAKEX, dtrsm_kernel_RN_SKYLAKEX, dtrsm_kernel_RT_SKYLAKEX,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrsm_iunucopy_SKYLAKEX, dtrsm_iunncopy_SKYLAKEX, dtrsm_iutucopy_SKYLAKEX, dtrsm_iutncopy_SKYLAKEX,
  dtrsm_ilnucopy_SKYLAKEX, dtrsm_ilnncopy_SKYLAKEX, dtrsm_iltucopy_SKYLAKEX, dtrsm_iltncopy_SKYLAKEX,
#else
  dtrsm_ounucopy_SKYLAKEX, dtrsm_ounncopy_SKYLAKEX, dtrsm_outucopy_SKYLAKEX, dtrsm_outncopy_SKYLAKEX,
  dtrsm_olnucopy_SKYLAKEX, dtrsm_olnncopy_SKYLAKEX, dtrsm_oltucopy_SKYLAKEX, dtrsm_oltncopy_SKYLAKEX,
#endif
  dtrsm_ounucopy_SKYLAKEX, dtrsm_ounncopy_SKYLAKEX, dtrsm_outucopy_SKYLAKEX, dtrsm_outncopy_SKYLAKEX,
  dtrsm_olnucopy_SKYLAKEX, dtrsm_olnncopy_SKYLAKEX, dtrsm_oltucopy_SKYLAKEX, dtrsm_oltncopy_SKYLAKEX,
  dtrmm_kernel_RN_SKYLAKEX, dtrmm_kernel_RT_SKYLAKEX, dtrmm_kernel_LN_SKYLAKEX, dtrmm_kernel_LT_SKYLAKEX,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrmm_iunucopy_SKYLAKEX, dtrmm_iunncopy_SKYLAKEX, dtrmm_iutucopy_SKYLAKEX, dtrmm_iutncopy_SKYLAKEX,
  dtrmm_ilnucopy_SKYLAKEX, dtrmm_ilnncopy_SKYLAKEX, dtrmm_iltucopy_SKYLAKEX, dtrmm_iltncopy_SKYLAKEX,
#else
  dtrmm_ounucopy_SKYLAKEX, dtrmm_ounncopy_SKYLAKEX, dtrmm_outucopy_SKYLAKEX, dtrmm_outncopy_SKYLAKEX,
  dtrmm_olnucopy_SKYLAKEX, dtrmm_olnncopy_SKYLAKEX, dtrmm_oltucopy_SKYLAKEX, dtrmm_oltncopy_SKYLAKEX,
#endif
  dtrmm_ounucopy_SKYLAKEX, dtrmm_ounncopy_SKYLAKEX, dtrmm_outucopy_SKYLAKEX, dtrmm_outncopy_SKYLAKEX,
  dtrmm_olnucopy_SKYLAKEX, dtrmm_olnncopy_SKYLAKEX, dtrmm_oltucopy_SKYLAKEX, dtrmm_oltncopy_SKYLAKEX,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dsymm_iutcopy_SKYLAKEX, dsymm_iltcopy_SKYLAKEX,
#else
  dsymm_outcopy_SKYLAKEX, dsymm_oltcopy_SKYLAKEX,
#endif
  dsymm_outcopy_SKYLAKEX, dsymm_oltcopy_SKYLAKEX,

#ifndef NO_LAPACK
  dneg_tcopy_SKYLAKEX, dlaswp_ncopy_SKYLAKEX,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  qamax_k_SKYLAKEX,  qamin_k_SKYLAKEX,  qmax_k_SKYLAKEX,  qmin_k_SKYLAKEX,
  iqamax_k_SKYLAKEX, iqamin_k_SKYLAKEX, iqmax_k_SKYLAKEX, iqmin_k_SKYLAKEX,
  qnrm2_k_SKYLAKEX,  qasum_k_SKYLAKEX,  qsum_k_SKYLAKEX, qcopy_k_SKYLAKEX, qdot_k_SKYLAKEX,
  qrot_k_SKYLAKEX,   qaxpy_k_SKYLAKEX,  qscal_k_SKYLAKEX, qswap_k_SKYLAKEX,
  qgemv_n_SKYLAKEX,  qgemv_t_SKYLAKEX,  qger_k_SKYLAKEX,
  qsymv_L_SKYLAKEX,  qsymv_U_SKYLAKEX,

  qgemm_kernel_SKYLAKEX, qgemm_beta_SKYLAKEX,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qgemm_incopy_SKYLAKEX, qgemm_itcopy_SKYLAKEX,
#else
  qgemm_oncopy_SKYLAKEX, qgemm_otcopy_SKYLAKEX,
#endif
  qgemm_oncopy_SKYLAKEX, qgemm_otcopy_SKYLAKEX,
  qtrsm_kernel_LN_SKYLAKEX, qtrsm_kernel_LT_SKYLAKEX, qtrsm_kernel_RN_SKYLAKEX, qtrsm_kernel_RT_SKYLAKEX,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrsm_iunucopy_SKYLAKEX, qtrsm_iunncopy_SKYLAKEX, qtrsm_iutucopy_SKYLAKEX, qtrsm_iutncopy_SKYLAKEX,
  qtrsm_ilnucopy_SKYLAKEX, qtrsm_ilnncopy_SKYLAKEX, qtrsm_iltucopy_SKYLAKEX, qtrsm_iltncopy_SKYLAKEX,
#else
  qtrsm_ounucopy_SKYLAKEX, qtrsm_ounncopy_SKYLAKEX, qtrsm_outucopy_SKYLAKEX, qtrsm_outncopy_SKYLAKEX,
  qtrsm_olnucopy_SKYLAKEX, qtrsm_olnncopy_SKYLAKEX, qtrsm_oltucopy_SKYLAKEX, qtrsm_oltncopy_SKYLAKEX,
#endif
  qtrsm_ounucopy_SKYLAKEX, qtrsm_ounncopy_SKYLAKEX, qtrsm_outucopy_SKYLAKEX, qtrsm_outncopy_SKYLAKEX,
  qtrsm_olnucopy_SKYLAKEX, qtrsm_olnncopy_SKYLAKEX, qtrsm_oltucopy_SKYLAKEX, qtrsm_oltncopy_SKYLAKEX,
  qtrmm_kernel_RN_SKYLAKEX, qtrmm_kernel_RT_SKYLAKEX, qtrmm_kernel_LN_SKYLAKEX, qtrmm_kernel_LT_SKYLAKEX,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrmm_iunucopy_SKYLAKEX, qtrmm_iunncopy_SKYLAKEX, qtrmm_iutucopy_SKYLAKEX, qtrmm_iutncopy_SKYLAKEX,
  qtrmm_ilnucopy_SKYLAKEX, qtrmm_ilnncopy_SKYLAKEX, qtrmm_iltucopy_SKYLAKEX, qtrmm_iltncopy_SKYLAKEX,
#else
  qtrmm_ounucopy_SKYLAKEX, qtrmm_ounncopy_SKYLAKEX, qtrmm_outucopy_SKYLAKEX, qtrmm_outncopy_SKYLAKEX,
  qtrmm_olnucopy_SKYLAKEX, qtrmm_olnncopy_SKYLAKEX, qtrmm_oltucopy_SKYLAKEX, qtrmm_oltncopy_SKYLAKEX,
#endif
  qtrmm_ounucopy_SKYLAKEX, qtrmm_ounncopy_SKYLAKEX, qtrmm_outucopy_SKYLAKEX, qtrmm_outncopy_SKYLAKEX,
  qtrmm_olnucopy_SKYLAKEX, qtrmm_olnncopy_SKYLAKEX, qtrmm_oltucopy_SKYLAKEX, qtrmm_oltncopy_SKYLAKEX,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qsymm_iutcopy_SKYLAKEX, qsymm_iltcopy_SKYLAKEX,
#else
  qsymm_outcopy_SKYLAKEX, qsymm_oltcopy_SKYLAKEX,
#endif
  qsymm_outcopy_SKYLAKEX, qsymm_oltcopy_SKYLAKEX,

#ifndef NO_LAPACK
  qneg_tcopy_SKYLAKEX, qlaswp_ncopy_SKYLAKEX,
#else
  NULL, NULL,
#endif

#endif

#if (BUILD_COMPLEX)
  0, 0, 0,
  CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N,
#ifdef CGEMM_DEFAULT_UNROLL_MN
 CGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N),
#endif
#if (BUILD_COMPLEX)
  camax_k_SKYLAKEX, camin_k_SKYLAKEX,
#endif
#if (BUILD_COMPLEX)
  icamax_k_SKYLAKEX, 
#endif
#if (BUILD_COMPLEX)
  icamin_k_SKYLAKEX,
  cnrm2_k_SKYLAKEX, casum_k_SKYLAKEX, csum_k_SKYLAKEX,
#endif
#if (BUILD_COMPLEX)
  ccopy_k_SKYLAKEX, cdotu_k_SKYLAKEX, cdotc_k_SKYLAKEX,
#endif
#if (BUILD_COMPLEX)
 csrot_k_SKYLAKEX,
#endif
#if (BUILD_COMPLEX)
  caxpy_k_SKYLAKEX,
  caxpyc_k_SKYLAKEX, 
  cscal_k_SKYLAKEX, 
  cswap_k_SKYLAKEX,

  cgemv_n_SKYLAKEX, cgemv_t_SKYLAKEX, cgemv_r_SKYLAKEX, cgemv_c_SKYLAKEX,
  cgemv_o_SKYLAKEX, cgemv_u_SKYLAKEX, cgemv_s_SKYLAKEX, cgemv_d_SKYLAKEX,
#endif
#if (BUILD_COMPLEX)
  cgeru_k_SKYLAKEX, cgerc_k_SKYLAKEX, cgerv_k_SKYLAKEX, cgerd_k_SKYLAKEX,
  csymv_L_SKYLAKEX, csymv_U_SKYLAKEX,
  chemv_L_SKYLAKEX, chemv_U_SKYLAKEX, chemv_M_SKYLAKEX, chemv_V_SKYLAKEX,
#endif
#if (BUILD_COMPLEX)
  cgemm_kernel_n_SKYLAKEX, cgemm_kernel_l_SKYLAKEX, cgemm_kernel_r_SKYLAKEX, cgemm_kernel_b_SKYLAKEX,
  cgemm_beta_SKYLAKEX,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  cgemm_incopy_SKYLAKEX, cgemm_itcopy_SKYLAKEX,
#else
  cgemm_oncopy_SKYLAKEX, cgemm_otcopy_SKYLAKEX,
#endif
  cgemm_oncopy_SKYLAKEX, cgemm_otcopy_SKYLAKEX,

#ifdef SMALL_MATRIX_OPT
  cgemm_small_matrix_permit_SKYLAKEX,
  cgemm_small_kernel_nn_SKYLAKEX, cgemm_small_kernel_nt_SKYLAKEX, cgemm_small_kernel_nr_SKYLAKEX, cgemm_small_kernel_nc_SKYLAKEX,
  cgemm_small_kernel_tn_SKYLAKEX, cgemm_small_kernel_tt_SKYLAKEX, cgemm_small_kernel_tr_SKYLAKEX, cgemm_small_kernel_tc_SKYLAKEX,
  cgemm_small_kernel_rn_SKYLAKEX, cgemm_small_kernel_rt_SKYLAKEX, cgemm_small_kernel_rr_SKYLAKEX, cgemm_small_kernel_rc_SKYLAKEX,
  cgemm_small_kernel_cn_SKYLAKEX, cgemm_small_kernel_ct_SKYLAKEX, cgemm_small_kernel_cr_SKYLAKEX, cgemm_small_kernel_cc_SKYLAKEX,
  cgemm_small_kernel_b0_nn_SKYLAKEX, cgemm_small_kernel_b0_nt_SKYLAKEX, cgemm_small_kernel_b0_nr_SKYLAKEX, cgemm_small_kernel_b0_nc_SKYLAKEX,
  cgemm_small_kernel_b0_tn_SKYLAKEX, cgemm_small_kernel_b0_tt_SKYLAKEX, cgemm_small_kernel_b0_tr_SKYLAKEX, cgemm_small_kernel_b0_tc_SKYLAKEX,
  cgemm_small_kernel_b0_rn_SKYLAKEX, cgemm_small_kernel_b0_rt_SKYLAKEX, cgemm_small_kernel_b0_rr_SKYLAKEX, cgemm_small_kernel_b0_rc_SKYLAKEX,
  cgemm_small_kernel_b0_cn_SKYLAKEX, cgemm_small_kernel_b0_ct_SKYLAKEX, cgemm_small_kernel_b0_cr_SKYLAKEX, cgemm_small_kernel_b0_cc_SKYLAKEX,
#endif

  ctrsm_kernel_LN_SKYLAKEX, ctrsm_kernel_LT_SKYLAKEX, ctrsm_kernel_LR_SKYLAKEX, ctrsm_kernel_LC_SKYLAKEX,
  ctrsm_kernel_RN_SKYLAKEX, ctrsm_kernel_RT_SKYLAKEX, ctrsm_kernel_RR_SKYLAKEX, ctrsm_kernel_RC_SKYLAKEX,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrsm_iunucopy_SKYLAKEX,  ctrsm_iunncopy_SKYLAKEX,  ctrsm_iutucopy_SKYLAKEX,  ctrsm_iutncopy_SKYLAKEX,
  ctrsm_ilnucopy_SKYLAKEX,  ctrsm_ilnncopy_SKYLAKEX,  ctrsm_iltucopy_SKYLAKEX,  ctrsm_iltncopy_SKYLAKEX,
#else
  ctrsm_ounucopy_SKYLAKEX,  ctrsm_ounncopy_SKYLAKEX,  ctrsm_outucopy_SKYLAKEX,  ctrsm_outncopy_SKYLAKEX,
  ctrsm_olnucopy_SKYLAKEX,  ctrsm_olnncopy_SKYLAKEX,  ctrsm_oltucopy_SKYLAKEX,  ctrsm_oltncopy_SKYLAKEX,
#endif
  ctrsm_ounucopy_SKYLAKEX,  ctrsm_ounncopy_SKYLAKEX,  ctrsm_outucopy_SKYLAKEX,  ctrsm_outncopy_SKYLAKEX,
  ctrsm_olnucopy_SKYLAKEX,  ctrsm_olnncopy_SKYLAKEX,  ctrsm_oltucopy_SKYLAKEX,  ctrsm_oltncopy_SKYLAKEX,
#endif
#endif
#if (BUILD_COMPLEX)

  ctrmm_kernel_RN_SKYLAKEX,  ctrmm_kernel_RT_SKYLAKEX,  ctrmm_kernel_RR_SKYLAKEX,  ctrmm_kernel_RC_SKYLAKEX,
  ctrmm_kernel_LN_SKYLAKEX,  ctrmm_kernel_LT_SKYLAKEX,  ctrmm_kernel_LR_SKYLAKEX,  ctrmm_kernel_LC_SKYLAKEX,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrmm_iunucopy_SKYLAKEX,  ctrmm_iunncopy_SKYLAKEX,  ctrmm_iutucopy_SKYLAKEX,  ctrmm_iutncopy_SKYLAKEX,
  ctrmm_ilnucopy_SKYLAKEX,  ctrmm_ilnncopy_SKYLAKEX,  ctrmm_iltucopy_SKYLAKEX,  ctrmm_iltncopy_SKYLAKEX,
#else
  ctrmm_ounucopy_SKYLAKEX,  ctrmm_ounncopy_SKYLAKEX,  ctrmm_outucopy_SKYLAKEX,  ctrmm_outncopy_SKYLAKEX,
  ctrmm_olnucopy_SKYLAKEX,  ctrmm_olnncopy_SKYLAKEX,  ctrmm_oltucopy_SKYLAKEX,  ctrmm_oltncopy_SKYLAKEX,
#endif
  ctrmm_ounucopy_SKYLAKEX,  ctrmm_ounncopy_SKYLAKEX,  ctrmm_outucopy_SKYLAKEX,  ctrmm_outncopy_SKYLAKEX,
  ctrmm_olnucopy_SKYLAKEX,  ctrmm_olnncopy_SKYLAKEX,  ctrmm_oltucopy_SKYLAKEX,  ctrmm_oltncopy_SKYLAKEX,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  csymm_iutcopy_SKYLAKEX,  csymm_iltcopy_SKYLAKEX,
#else
  csymm_outcopy_SKYLAKEX,  csymm_oltcopy_SKYLAKEX,
#endif
  csymm_outcopy_SKYLAKEX,  csymm_oltcopy_SKYLAKEX,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  chemm_iutcopy_SKYLAKEX,  chemm_iltcopy_SKYLAKEX,
#else
  chemm_outcopy_SKYLAKEX,  chemm_oltcopy_SKYLAKEX,
#endif
  chemm_outcopy_SKYLAKEX,  chemm_oltcopy_SKYLAKEX,

  0, 0, 0,

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N, MAX(CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N),
#else
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N, MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif


  cgemm3m_kernel_SKYLAKEX,

  cgemm3m_incopyb_SKYLAKEX,  cgemm3m_incopyr_SKYLAKEX,
  cgemm3m_incopyi_SKYLAKEX,  cgemm3m_itcopyb_SKYLAKEX,
  cgemm3m_itcopyr_SKYLAKEX,  cgemm3m_itcopyi_SKYLAKEX,
  cgemm3m_oncopyb_SKYLAKEX,  cgemm3m_oncopyr_SKYLAKEX,
  cgemm3m_oncopyi_SKYLAKEX,  cgemm3m_otcopyb_SKYLAKEX,
  cgemm3m_otcopyr_SKYLAKEX,  cgemm3m_otcopyi_SKYLAKEX,

  csymm3m_iucopyb_SKYLAKEX,  csymm3m_ilcopyb_SKYLAKEX,
  csymm3m_iucopyr_SKYLAKEX,  csymm3m_ilcopyr_SKYLAKEX,
  csymm3m_iucopyi_SKYLAKEX,  csymm3m_ilcopyi_SKYLAKEX,
  csymm3m_oucopyb_SKYLAKEX,  csymm3m_olcopyb_SKYLAKEX,
  csymm3m_oucopyr_SKYLAKEX,  csymm3m_olcopyr_SKYLAKEX,
  csymm3m_oucopyi_SKYLAKEX,  csymm3m_olcopyi_SKYLAKEX,

  chemm3m_iucopyb_SKYLAKEX,  chemm3m_ilcopyb_SKYLAKEX,
  chemm3m_iucopyr_SKYLAKEX,  chemm3m_ilcopyr_SKYLAKEX,
  chemm3m_iucopyi_SKYLAKEX,  chemm3m_ilcopyi_SKYLAKEX,

  chemm3m_oucopyb_SKYLAKEX,  chemm3m_olcopyb_SKYLAKEX,
  chemm3m_oucopyr_SKYLAKEX,  chemm3m_olcopyr_SKYLAKEX,
  chemm3m_oucopyi_SKYLAKEX,  chemm3m_olcopyi_SKYLAKEX,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif
#endif

#if (BUILD_COMPLEX)
#ifndef NO_LAPACK
  cneg_tcopy_SKYLAKEX,
  
   claswp_ncopy_SKYLAKEX,
#else
  NULL, NULL,
#endif

#endif

#if BUILD_COMPLEX16 == 1
  0, 0, 0,
  ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N,
#ifdef ZGEMM_DEFAULT_UNROLL_MN
 ZGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N),
#endif

  zamax_k_SKYLAKEX, zamin_k_SKYLAKEX, izamax_k_SKYLAKEX, izamin_k_SKYLAKEX,
  znrm2_k_SKYLAKEX, zasum_k_SKYLAKEX, zsum_k_SKYLAKEX, zcopy_k_SKYLAKEX,
  zdotu_k_SKYLAKEX, zdotc_k_SKYLAKEX, zdrot_k_SKYLAKEX,
  zaxpy_k_SKYLAKEX, zaxpyc_k_SKYLAKEX, zscal_k_SKYLAKEX, zswap_k_SKYLAKEX,

  zgemv_n_SKYLAKEX, zgemv_t_SKYLAKEX, zgemv_r_SKYLAKEX, zgemv_c_SKYLAKEX,
  zgemv_o_SKYLAKEX, zgemv_u_SKYLAKEX, zgemv_s_SKYLAKEX, zgemv_d_SKYLAKEX,
  zgeru_k_SKYLAKEX, zgerc_k_SKYLAKEX, zgerv_k_SKYLAKEX, zgerd_k_SKYLAKEX,
  zsymv_L_SKYLAKEX, zsymv_U_SKYLAKEX,
  zhemv_L_SKYLAKEX, zhemv_U_SKYLAKEX, zhemv_M_SKYLAKEX, zhemv_V_SKYLAKEX,

  zgemm_kernel_n_SKYLAKEX, zgemm_kernel_l_SKYLAKEX, zgemm_kernel_r_SKYLAKEX, zgemm_kernel_b_SKYLAKEX,
  zgemm_beta_SKYLAKEX,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zgemm_incopy_SKYLAKEX, zgemm_itcopy_SKYLAKEX,
#else
  zgemm_oncopy_SKYLAKEX, zgemm_otcopy_SKYLAKEX,
#endif
  zgemm_oncopy_SKYLAKEX, zgemm_otcopy_SKYLAKEX,

#ifdef SMALL_MATRIX_OPT
  zgemm_small_matrix_permit_SKYLAKEX,
  zgemm_small_kernel_nn_SKYLAKEX, zgemm_small_kernel_nt_SKYLAKEX, zgemm_small_kernel_nr_SKYLAKEX, zgemm_small_kernel_nc_SKYLAKEX,
  zgemm_small_kernel_tn_SKYLAKEX, zgemm_small_kernel_tt_SKYLAKEX, zgemm_small_kernel_tr_SKYLAKEX, zgemm_small_kernel_tc_SKYLAKEX,
  zgemm_small_kernel_rn_SKYLAKEX, zgemm_small_kernel_rt_SKYLAKEX, zgemm_small_kernel_rr_SKYLAKEX, zgemm_small_kernel_rc_SKYLAKEX,
  zgemm_small_kernel_cn_SKYLAKEX, zgemm_small_kernel_ct_SKYLAKEX, zgemm_small_kernel_cr_SKYLAKEX, zgemm_small_kernel_cc_SKYLAKEX,
  zgemm_small_kernel_b0_nn_SKYLAKEX, zgemm_small_kernel_b0_nt_SKYLAKEX, zgemm_small_kernel_b0_nr_SKYLAKEX, zgemm_small_kernel_b0_nc_SKYLAKEX,
  zgemm_small_kernel_b0_tn_SKYLAKEX, zgemm_small_kernel_b0_tt_SKYLAKEX, zgemm_small_kernel_b0_tr_SKYLAKEX, zgemm_small_kernel_b0_tc_SKYLAKEX,
  zgemm_small_kernel_b0_rn_SKYLAKEX, zgemm_small_kernel_b0_rt_SKYLAKEX, zgemm_small_kernel_b0_rr_SKYLAKEX, zgemm_small_kernel_b0_rc_SKYLAKEX,
  zgemm_small_kernel_b0_cn_SKYLAKEX, zgemm_small_kernel_b0_ct_SKYLAKEX, zgemm_small_kernel_b0_cr_SKYLAKEX, zgemm_small_kernel_b0_cc_SKYLAKEX,
#endif

  ztrsm_kernel_LN_SKYLAKEX, ztrsm_kernel_LT_SKYLAKEX, ztrsm_kernel_LR_SKYLAKEX, ztrsm_kernel_LC_SKYLAKEX,
  ztrsm_kernel_RN_SKYLAKEX, ztrsm_kernel_RT_SKYLAKEX, ztrsm_kernel_RR_SKYLAKEX, ztrsm_kernel_RC_SKYLAKEX,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrsm_iunucopy_SKYLAKEX,  ztrsm_iunncopy_SKYLAKEX,  ztrsm_iutucopy_SKYLAKEX,  ztrsm_iutncopy_SKYLAKEX,
  ztrsm_ilnucopy_SKYLAKEX,  ztrsm_ilnncopy_SKYLAKEX,  ztrsm_iltucopy_SKYLAKEX,  ztrsm_iltncopy_SKYLAKEX,
#else
  ztrsm_ounucopy_SKYLAKEX,  ztrsm_ounncopy_SKYLAKEX,  ztrsm_outucopy_SKYLAKEX,  ztrsm_outncopy_SKYLAKEX,
  ztrsm_olnucopy_SKYLAKEX,  ztrsm_olnncopy_SKYLAKEX,  ztrsm_oltucopy_SKYLAKEX,  ztrsm_oltncopy_SKYLAKEX,
#endif
  ztrsm_ounucopy_SKYLAKEX,  ztrsm_ounncopy_SKYLAKEX,  ztrsm_outucopy_SKYLAKEX,  ztrsm_outncopy_SKYLAKEX,
  ztrsm_olnucopy_SKYLAKEX,  ztrsm_olnncopy_SKYLAKEX,  ztrsm_oltucopy_SKYLAKEX,  ztrsm_oltncopy_SKYLAKEX,

  ztrmm_kernel_RN_SKYLAKEX,  ztrmm_kernel_RT_SKYLAKEX,  ztrmm_kernel_RR_SKYLAKEX,  ztrmm_kernel_RC_SKYLAKEX,
  ztrmm_kernel_LN_SKYLAKEX,  ztrmm_kernel_LT_SKYLAKEX,  ztrmm_kernel_LR_SKYLAKEX,  ztrmm_kernel_LC_SKYLAKEX,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrmm_iunucopy_SKYLAKEX,  ztrmm_iunncopy_SKYLAKEX,  ztrmm_iutucopy_SKYLAKEX,  ztrmm_iutncopy_SKYLAKEX,
  ztrmm_ilnucopy_SKYLAKEX,  ztrmm_ilnncopy_SKYLAKEX,  ztrmm_iltucopy_SKYLAKEX,  ztrmm_iltncopy_SKYLAKEX,
#else
  ztrmm_ounucopy_SKYLAKEX,  ztrmm_ounncopy_SKYLAKEX,  ztrmm_outucopy_SKYLAKEX,  ztrmm_outncopy_SKYLAKEX,
  ztrmm_olnucopy_SKYLAKEX,  ztrmm_olnncopy_SKYLAKEX,  ztrmm_oltucopy_SKYLAKEX,  ztrmm_oltncopy_SKYLAKEX,
#endif
  ztrmm_ounucopy_SKYLAKEX,  ztrmm_ounncopy_SKYLAKEX,  ztrmm_outucopy_SKYLAKEX,  ztrmm_outncopy_SKYLAKEX,
  ztrmm_olnucopy_SKYLAKEX,  ztrmm_olnncopy_SKYLAKEX,  ztrmm_oltucopy_SKYLAKEX,  ztrmm_oltncopy_SKYLAKEX,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zsymm_iutcopy_SKYLAKEX,  zsymm_iltcopy_SKYLAKEX,
#else
  zsymm_outcopy_SKYLAKEX,  zsymm_oltcopy_SKYLAKEX,
#endif
  zsymm_outcopy_SKYLAKEX,  zsymm_oltcopy_SKYLAKEX,
#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zhemm_iutcopy_SKYLAKEX,  zhemm_iltcopy_SKYLAKEX,
#else
  zhemm_outcopy_SKYLAKEX,  zhemm_oltcopy_SKYLAKEX,
#endif
  zhemm_outcopy_SKYLAKEX,  zhemm_oltcopy_SKYLAKEX,

  0, 0, 0,
#if (USE_GEMM3M)
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N, MAX(ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N),
#else
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N, MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif


  zgemm3m_kernel_SKYLAKEX,

  zgemm3m_incopyb_SKYLAKEX,  zgemm3m_incopyr_SKYLAKEX,
  zgemm3m_incopyi_SKYLAKEX,  zgemm3m_itcopyb_SKYLAKEX,
  zgemm3m_itcopyr_SKYLAKEX,  zgemm3m_itcopyi_SKYLAKEX,
  zgemm3m_oncopyb_SKYLAKEX,  zgemm3m_oncopyr_SKYLAKEX,
  zgemm3m_oncopyi_SKYLAKEX,  zgemm3m_otcopyb_SKYLAKEX,
  zgemm3m_otcopyr_SKYLAKEX,  zgemm3m_otcopyi_SKYLAKEX,

  zsymm3m_iucopyb_SKYLAKEX,  zsymm3m_ilcopyb_SKYLAKEX,
  zsymm3m_iucopyr_SKYLAKEX,  zsymm3m_ilcopyr_SKYLAKEX,
  zsymm3m_iucopyi_SKYLAKEX,  zsymm3m_ilcopyi_SKYLAKEX,
  zsymm3m_oucopyb_SKYLAKEX,  zsymm3m_olcopyb_SKYLAKEX,
  zsymm3m_oucopyr_SKYLAKEX,  zsymm3m_olcopyr_SKYLAKEX,
  zsymm3m_oucopyi_SKYLAKEX,  zsymm3m_olcopyi_SKYLAKEX,

  zhemm3m_iucopyb_SKYLAKEX,  zhemm3m_ilcopyb_SKYLAKEX,
  zhemm3m_iucopyr_SKYLAKEX,  zhemm3m_ilcopyr_SKYLAKEX,
  zhemm3m_iucopyi_SKYLAKEX,  zhemm3m_ilcopyi_SKYLAKEX,

  zhemm3m_oucopyb_SKYLAKEX,  zhemm3m_olcopyb_SKYLAKEX,
  zhemm3m_oucopyr_SKYLAKEX,  zhemm3m_olcopyr_SKYLAKEX,
  zhemm3m_oucopyi_SKYLAKEX,  zhemm3m_olcopyi_SKYLAKEX,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  zneg_tcopy_SKYLAKEX, zlaswp_ncopy_SKYLAKEX,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N, MAX(XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N),

  xamax_k_SKYLAKEX, xamin_k_SKYLAKEX, ixamax_k_SKYLAKEX, ixamin_k_SKYLAKEX,
  xnrm2_k_SKYLAKEX, xasum_k_SKYLAKEX, xsum_k_SKYLAKEX, xcopy_k_SKYLAKEX,
  xdotu_k_SKYLAKEX, xdotc_k_SKYLAKEX, xqrot_k_SKYLAKEX,
  xaxpy_k_SKYLAKEX, xaxpyc_k_SKYLAKEX, xscal_k_SKYLAKEX, xswap_k_SKYLAKEX,

  xgemv_n_SKYLAKEX, xgemv_t_SKYLAKEX, xgemv_r_SKYLAKEX, xgemv_c_SKYLAKEX,
  xgemv_o_SKYLAKEX, xgemv_u_SKYLAKEX, xgemv_s_SKYLAKEX, xgemv_d_SKYLAKEX,
  xgeru_k_SKYLAKEX, xgerc_k_SKYLAKEX, xgerv_k_SKYLAKEX, xgerd_k_SKYLAKEX,
  xsymv_L_SKYLAKEX, xsymv_U_SKYLAKEX,
  xhemv_L_SKYLAKEX, xhemv_U_SKYLAKEX, xhemv_M_SKYLAKEX, xhemv_V_SKYLAKEX,

  xgemm_kernel_n_SKYLAKEX, xgemm_kernel_l_SKYLAKEX, xgemm_kernel_r_SKYLAKEX, xgemm_kernel_b_SKYLAKEX,
  xgemm_beta_SKYLAKEX,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xgemm_incopy_SKYLAKEX, xgemm_itcopy_SKYLAKEX,
#else
  xgemm_oncopy_SKYLAKEX, xgemm_otcopy_SKYLAKEX,
#endif
  xgemm_oncopy_SKYLAKEX, xgemm_otcopy_SKYLAKEX,

  xtrsm_kernel_LN_SKYLAKEX, xtrsm_kernel_LT_SKYLAKEX, xtrsm_kernel_LR_SKYLAKEX, xtrsm_kernel_LC_SKYLAKEX,
  xtrsm_kernel_RN_SKYLAKEX, xtrsm_kernel_RT_SKYLAKEX, xtrsm_kernel_RR_SKYLAKEX, xtrsm_kernel_RC_SKYLAKEX,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrsm_iunucopy_SKYLAKEX,  xtrsm_iunncopy_SKYLAKEX,  xtrsm_iutucopy_SKYLAKEX,  xtrsm_iutncopy_SKYLAKEX,
  xtrsm_ilnucopy_SKYLAKEX,  xtrsm_ilnncopy_SKYLAKEX,  xtrsm_iltucopy_SKYLAKEX,  xtrsm_iltncopy_SKYLAKEX,
#else
  xtrsm_ounucopy_SKYLAKEX,  xtrsm_ounncopy_SKYLAKEX,  xtrsm_outucopy_SKYLAKEX,  xtrsm_outncopy_SKYLAKEX,
  xtrsm_olnucopy_SKYLAKEX,  xtrsm_olnncopy_SKYLAKEX,  xtrsm_oltucopy_SKYLAKEX,  xtrsm_oltncopy_SKYLAKEX,
#endif
  xtrsm_ounucopy_SKYLAKEX,  xtrsm_ounncopy_SKYLAKEX,  xtrsm_outucopy_SKYLAKEX,  xtrsm_outncopy_SKYLAKEX,
  xtrsm_olnucopy_SKYLAKEX,  xtrsm_olnncopy_SKYLAKEX,  xtrsm_oltucopy_SKYLAKEX,  xtrsm_oltncopy_SKYLAKEX,

  xtrmm_kernel_RN_SKYLAKEX,  xtrmm_kernel_RT_SKYLAKEX,  xtrmm_kernel_RR_SKYLAKEX,  xtrmm_kernel_RC_SKYLAKEX,
  xtrmm_kernel_LN_SKYLAKEX,  xtrmm_kernel_LT_SKYLAKEX,  xtrmm_kernel_LR_SKYLAKEX,  xtrmm_kernel_LC_SKYLAKEX,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrmm_iunucopy_SKYLAKEX,  xtrmm_iunncopy_SKYLAKEX,  xtrmm_iutucopy_SKYLAKEX,  xtrmm_iutncopy_SKYLAKEX,
  xtrmm_ilnucopy_SKYLAKEX,  xtrmm_ilnncopy_SKYLAKEX,  xtrmm_iltucopy_SKYLAKEX,  xtrmm_iltncopy_SKYLAKEX,
#else
  xtrmm_ounucopy_SKYLAKEX,  xtrmm_ounncopy_SKYLAKEX,  xtrmm_outucopy_SKYLAKEX,  xtrmm_outncopy_SKYLAKEX,
  xtrmm_olnucopy_SKYLAKEX,  xtrmm_olnncopy_SKYLAKEX,  xtrmm_oltucopy_SKYLAKEX,  xtrmm_oltncopy_SKYLAKEX,
#endif
  xtrmm_ounucopy_SKYLAKEX,  xtrmm_ounncopy_SKYLAKEX,  xtrmm_outucopy_SKYLAKEX,  xtrmm_outncopy_SKYLAKEX,
  xtrmm_olnucopy_SKYLAKEX,  xtrmm_olnncopy_SKYLAKEX,  xtrmm_oltucopy_SKYLAKEX,  xtrmm_oltncopy_SKYLAKEX,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xsymm_iutcopy_SKYLAKEX,  xsymm_iltcopy_SKYLAKEX,
#else
  xsymm_outcopy_SKYLAKEX,  xsymm_oltcopy_SKYLAKEX,
#endif
  xsymm_outcopy_SKYLAKEX,  xsymm_oltcopy_SKYLAKEX,
#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xhemm_iutcopy_SKYLAKEX,  xhemm_iltcopy_SKYLAKEX,
#else
  xhemm_outcopy_SKYLAKEX,  xhemm_oltcopy_SKYLAKEX,
#endif
  xhemm_outcopy_SKYLAKEX,  xhemm_oltcopy_SKYLAKEX,

  0, 0, 0,
#if (USE_GEMM3M)
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  xgemm3m_kernel_SKYLAKEX,

  xgemm3m_incopyb_SKYLAKEX,  xgemm3m_incopyr_SKYLAKEX,
  xgemm3m_incopyi_SKYLAKEX,  xgemm3m_itcopyb_SKYLAKEX,
  xgemm3m_itcopyr_SKYLAKEX,  xgemm3m_itcopyi_SKYLAKEX,
  xgemm3m_oncopyb_SKYLAKEX,  xgemm3m_oncopyr_SKYLAKEX,
  xgemm3m_oncopyi_SKYLAKEX,  xgemm3m_otcopyb_SKYLAKEX,
  xgemm3m_otcopyr_SKYLAKEX,  xgemm3m_otcopyi_SKYLAKEX,

  xsymm3m_iucopyb_SKYLAKEX,  xsymm3m_ilcopyb_SKYLAKEX,
  xsymm3m_iucopyr_SKYLAKEX,  xsymm3m_ilcopyr_SKYLAKEX,
  xsymm3m_iucopyi_SKYLAKEX,  xsymm3m_ilcopyi_SKYLAKEX,
  xsymm3m_oucopyb_SKYLAKEX,  xsymm3m_olcopyb_SKYLAKEX,
  xsymm3m_oucopyr_SKYLAKEX,  xsymm3m_olcopyr_SKYLAKEX,
  xsymm3m_oucopyi_SKYLAKEX,  xsymm3m_olcopyi_SKYLAKEX,

  xhemm3m_iucopyb_SKYLAKEX,  xhemm3m_ilcopyb_SKYLAKEX,
  xhemm3m_iucopyr_SKYLAKEX,  xhemm3m_ilcopyr_SKYLAKEX,
  xhemm3m_iucopyi_SKYLAKEX,  xhemm3m_ilcopyi_SKYLAKEX,

  xhemm3m_oucopyb_SKYLAKEX,  xhemm3m_olcopyb_SKYLAKEX,
  xhemm3m_oucopyr_SKYLAKEX,  xhemm3m_olcopyr_SKYLAKEX,
  xhemm3m_oucopyi_SKYLAKEX,  xhemm3m_olcopyi_SKYLAKEX,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  xneg_tcopy_SKYLAKEX, xlaswp_ncopy_SKYLAKEX,
#else
  NULL, NULL,
#endif

#endif

  init_parameter,

  SNUMOPT, DNUMOPT, QNUMOPT,
#if BUILD_SINGLE == 1
  saxpby_k_SKYLAKEX,
#endif
#if BUILD_DOUBLE  == 1
  daxpby_k_SKYLAKEX,
#endif
#if BUILD_COMPLEX == 1
  caxpby_k_SKYLAKEX,
#endif
#if BUILD_COMPLEX16== 1
  zaxpby_k_SKYLAKEX,
#endif

#if BUILD_SINGLE == 1
  somatcopy_k_cn_SKYLAKEX, somatcopy_k_ct_SKYLAKEX, somatcopy_k_rn_SKYLAKEX, somatcopy_k_rt_SKYLAKEX,
#endif
#if BUILD_DOUBLE== 1
  domatcopy_k_cn_SKYLAKEX, domatcopy_k_ct_SKYLAKEX, domatcopy_k_rn_SKYLAKEX, domatcopy_k_rt_SKYLAKEX,
#endif
#if BUILD_COMPLEX == 1
  comatcopy_k_cn_SKYLAKEX, comatcopy_k_ct_SKYLAKEX, comatcopy_k_rn_SKYLAKEX, comatcopy_k_rt_SKYLAKEX,
  comatcopy_k_cnc_SKYLAKEX, comatcopy_k_ctc_SKYLAKEX, comatcopy_k_rnc_SKYLAKEX, comatcopy_k_rtc_SKYLAKEX,
#endif
#if BUILD_COMPLEX16 == 1
  zomatcopy_k_cn_SKYLAKEX, zomatcopy_k_ct_SKYLAKEX, zomatcopy_k_rn_SKYLAKEX, zomatcopy_k_rt_SKYLAKEX,
  zomatcopy_k_cnc_SKYLAKEX, zomatcopy_k_ctc_SKYLAKEX, zomatcopy_k_rnc_SKYLAKEX, zomatcopy_k_rtc_SKYLAKEX,
#endif

#if BUILD_SINGLE == 1
  simatcopy_k_cn_SKYLAKEX, simatcopy_k_ct_SKYLAKEX, simatcopy_k_rn_SKYLAKEX, simatcopy_k_rt_SKYLAKEX,
#endif
#if BUILD_DOUBLE== 1
  dimatcopy_k_cn_SKYLAKEX, dimatcopy_k_ct_SKYLAKEX, dimatcopy_k_rn_SKYLAKEX, dimatcopy_k_rt_SKYLAKEX,
#endif
#if BUILD_COMPLEX== 1
  cimatcopy_k_cn_SKYLAKEX, cimatcopy_k_ct_SKYLAKEX, cimatcopy_k_rn_SKYLAKEX, cimatcopy_k_rt_SKYLAKEX,
  cimatcopy_k_cnc_SKYLAKEX, cimatcopy_k_ctc_SKYLAKEX, cimatcopy_k_rnc_SKYLAKEX, cimatcopy_k_rtc_SKYLAKEX,
#endif
#if BUILD_COMPLEX16==1
  zimatcopy_k_cn_SKYLAKEX, zimatcopy_k_ct_SKYLAKEX, zimatcopy_k_rn_SKYLAKEX, zimatcopy_k_rt_SKYLAKEX,
  zimatcopy_k_cnc_SKYLAKEX, zimatcopy_k_ctc_SKYLAKEX, zimatcopy_k_rnc_SKYLAKEX, zimatcopy_k_rtc_SKYLAKEX,
#endif

#if BUILD_SINGLE == 1
  sgeadd_k_SKYLAKEX,
#endif
#if BUILD_DOUBLE==1
  dgeadd_k_SKYLAKEX,
#endif
#if BUILD_COMPLEX==1
  cgeadd_k_SKYLAKEX,
#endif
#if BUILD_COMPLEX16==1
  zgeadd_k_SKYLAKEX,
#endif
};

#if (ARCH_ARM64)
static void init_parameter(void) {
#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
#if BUILD_SINGLE == 1 || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if BUILD_DOUBLE== 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX== 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
#if BUILD_SINGLE == 1 || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
#endif
#if BUILD_DOUBLE==1  || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif

}
#else // (ARCH_ARM64)
#if defined(ARCH_MIPS64)
static void init_parameter(void) {
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;

  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = 640;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if defined(USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif
}
#else // (ARCH_MIPS64)
#if (ARCH_LOONGARCH64)
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else // (ARCH_LOONGARCH64)
#if (ARCH_POWER)
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //POWER

#if (ARCH_ZARCH)
static void init_parameter(void) {
#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
	TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
	TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
	TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
	TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
	TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
	TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
	TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
	TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
	TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
	TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
	TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
	TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //ZARCH

#ifdef ARCH_X86
static int get_l2_size_old(void){
  int i, eax, ebx, ecx, edx, cpuid_level;
  int info[15];

  cpuid(2, &eax, &ebx, &ecx, &edx);

  info[ 0] = BITMASK(eax,  8, 0xff);
  info[ 1] = BITMASK(eax, 16, 0xff);
  info[ 2] = BITMASK(eax, 24, 0xff);

  info[ 3] = BITMASK(ebx,  0, 0xff);
  info[ 4] = BITMASK(ebx,  8, 0xff);
  info[ 5] = BITMASK(ebx, 16, 0xff);
  info[ 6] = BITMASK(ebx, 24, 0xff);

  info[ 7] = BITMASK(ecx,  0, 0xff);
  info[ 8] = BITMASK(ecx,  8, 0xff);
  info[ 9] = BITMASK(ecx, 16, 0xff);
  info[10] = BITMASK(ecx, 24, 0xff);

  info[11] = BITMASK(edx,  0, 0xff);
  info[12] = BITMASK(edx,  8, 0xff);
  info[13] = BITMASK(edx, 16, 0xff);
  info[14] = BITMASK(edx, 24, 0xff);

  for (i = 0; i < 15; i++){

    switch (info[i]){

      /* This table is from http://www.sandpile.org/ia32/cpuid.htm */

    case 0x1a :
      return 96;

    case 0x39 :
    case 0x3b :
    case 0x41 :
    case 0x79 :
    case 0x81 :
      return 128;

    case 0x3a :
      return 192;

    case 0x21 :
    case 0x3c :
    case 0x42 :
    case 0x7a :
    case 0x7e :
    case 0x82 :
      return 256;

    case 0x3d :
      return 384;

    case 0x3e :
    case 0x43 :
    case 0x7b :
    case 0x7f :
    case 0x83 :
    case 0x86 :
      return 512;

    case 0x44 :
    case 0x78 :
    case 0x7c :
    case 0x84 :
    case 0x87 :
      return 1024;

    case 0x45 :
    case 0x7d :
    case 0x85 :
      return 2048;

    case 0x48 :
      return 3184;

    case 0x49 :
      return 4096;

    case 0x4e :
      return 6144;
    }
  }
//  return 0;
fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
return 256;
}
#endif

static __inline__ int get_l2_size(void){

  int eax, ebx, ecx, edx, l2;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  l2 = BITMASK(ecx, 16, 0xffff);

#ifndef ARCH_X86
  if (l2 <= 0) {
     fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
     return 256;
  }
  return l2;

#else

  if (l2 > 0) return l2;

  return get_l2_size_old();
#endif
}

static __inline__ int get_l3_size(void){

  int eax, ebx, ecx, edx;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  return BITMASK(edx, 18, 0x3fff) * 512;
}


static void init_parameter(void) {

  int l2 = get_l2_size();

  (void) l2; /* dirty trick to suppress unused variable warning for targets */
             /* where the GEMM unrolling parameters do not depend on l2 */
  
#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if BUILD_COMPLEX == 1
#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = SGEMM_DEFAULT_Q;
#endif
#endif

#if BUILD_COMPLEX16 == 1
#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = DGEMM_DEFAULT_Q;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm3m_q = QGEMM_DEFAULT_Q;
#endif

#if defined(CORE_KATMAI)  || defined(CORE_COPPERMINE) || defined(CORE_BANIAS) || defined(CORE_YONAH) || defined(CORE_ATHLON)

#ifdef DEBUG
  fprintf(stderr, "Katmai, Coppermine, Banias, Athlon\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  64 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  16 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  16 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   8 * (l2 >> 7);
#endif
#endif

#ifdef CORE_NORTHWOOD

#ifdef DEBUG
  fprintf(stderr, "Northwood\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  96 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  24 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  24 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  12 * (l2 >> 7);
#endif
#endif

#ifdef ATOM

#ifdef DEBUG
  fprintf(stderr, "Atom\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 256;
#endif
#if BUILD_DOUBLE ==1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = 128;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = 128;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  64;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  64;
  TABLE_NAME.xgemm_p =  32;
#endif
#endif

#ifdef CORE_PRESCOTT

#ifdef DEBUG
  fprintf(stderr, "Prescott\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE ==1  || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm_p =  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   7 * (l2 >> 7);
#endif
#endif

#ifdef CORE2

#ifdef DEBUG
  fprintf(stderr, "Core2\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  92 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE==1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  46 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  46 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  23 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  92 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  46 * (l2 >> 9) + 4;
#endif
#endif

#ifdef PENRYN

#ifdef DEBUG
  fprintf(stderr, "Penryn\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif

#ifdef DUNNINGTON

#ifdef DEBUG
  fprintf(stderr, "Dunnington\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE ==1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif


#ifdef NEHALEM

#ifdef DEBUG
  fprintf(stderr, "Nehalem\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef SANDYBRIDGE

#ifdef DEBUG
  fprintf(stderr, "Sandybridge\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef HASWELL

#ifdef DEBUG
  fprintf(stderr, "Haswell\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#if defined(SKYLAKEX) || defined(COOPERLAKE) || defined(SAPPHIRERAPIDS)

#ifdef DEBUG
  fprintf(stderr, "SkylakeX\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef OPTERON

#ifdef DEBUG
  fprintf(stderr, "Opteron\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 224 +  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p =  56 +  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  56 +  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  28 +   7 * (l2 >> 7);
#endif
#endif

#ifdef BARCELONA

#ifdef DEBUG
  fprintf(stderr, "Barcelona\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BOBCAT

#ifdef DEBUG
  fprintf(stderr, "Bobcate\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BULLDOZER

#ifdef DEBUG
  fprintf(stderr, "Bulldozer\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef EXCAVATOR

#ifdef DEBUG
  fprintf(stderr, "Excavator\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef PILEDRIVER

#ifdef DEBUG
  fprintf(stderr, "Piledriver\n");
#endif

#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef STEAMROLLER

#ifdef DEBUG
  fprintf(stderr, "Steamroller\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef ZEN

#ifdef DEBUG
  fprintf(stderr, "Zen\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef NANO

#ifdef DEBUG
  fprintf(stderr, "NANO\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX==1)
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX16==1)
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif


#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif

#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
#endif


#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_p = ((TABLE_NAME.sgemm_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_p = ((TABLE_NAME.dgemm_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = ((TABLE_NAME.cgemm_p + CGEMM_DEFAULT_UNROLL_M - 1)/CGEMM_DEFAULT_UNROLL_M) * CGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ((TABLE_NAME.zgemm_p + ZGEMM_DEFAULT_UNROLL_M - 1)/ZGEMM_DEFAULT_UNROLL_M) * ZGEMM_DEFAULT_UNROLL_M;
#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + CGEMM3M_DEFAULT_UNROLL_M - 1)/CGEMM3M_DEFAULT_UNROLL_M) * CGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + ZGEMM3M_DEFAULT_UNROLL_M - 1)/ZGEMM3M_DEFAULT_UNROLL_M) * ZGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#ifdef QUAD_PRECISION
  TABLE_NAME.qgemm_p = ((TABLE_NAME.qgemm_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm_p = ((TABLE_NAME.xgemm_p + XGEMM_DEFAULT_UNROLL_M - 1)/XGEMM_DEFAULT_UNROLL_M) * XGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm3m_p = ((TABLE_NAME.xgemm3m_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
#endif

#ifdef DEBUG
  fprintf(stderr, "L2 = %8d DGEMM_P  .. %d\n", l2, TABLE_NAME.dgemm_p);
#endif

#if BUILD_BFLOAT16==1
  TABLE_NAME.sbgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.sbgemm_p * TABLE_NAME.sbgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.sbgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_SINGLE==1
  TABLE_NAME.sgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.sgemm_p * TABLE_NAME.sgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.sgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.dgemm_p * TABLE_NAME.dgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.dgemm_q *  8) - 15) & ~15);
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.qgemm_p * TABLE_NAME.qgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.qgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX ==1 
  TABLE_NAME.cgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm_p * TABLE_NAME.cgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 ==1
  TABLE_NAME.zgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm_p * TABLE_NAME.zgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm3m_p * TABLE_NAME.cgemm3m_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm3m_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm3m_p * TABLE_NAME.zgemm3m_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm3m_q * 16) - 15) & ~15);
#endif



#ifdef EXPRECISION
  TABLE_NAME.xgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm_p * TABLE_NAME.xgemm_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm_q * 32) - 15) & ~15);

  TABLE_NAME.xgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm3m_p * TABLE_NAME.xgemm3m_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm3m_q * 32) - 15) & ~15);

#endif



}
#endif //POWER
#endif //ZARCH
#endif //(ARCH_LOONGARCH64)
#endif //(ARCH_MIPS64)
#endif //(ARCH_ARM64)
