; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=armv7 -mattr=+neon %s -o - | FileCheck %s --check-prefix=ARMV7
; RUN: llc -mtriple=armv7 -mattr=+fp-armv8 %s -o - | FileCheck %s --check-prefix=ARMV8
; RUN: llc -mtriple=armv8.2a -mattr=+fp-armv8 %s -o - | FileCheck %s --check-prefix=ARMV8
; RUN: llc -mtriple=armv8.1m-none-none-eabi -mattr=+mve.fp,+fp64 %s -o - | FileCheck %s --check-prefix=ARMV8M

declare float @llvm.minnum.f32(float, float)
declare float @llvm.maxnum.f32(float, float)
declare double @llvm.minnum.f64(double, double)
declare double @llvm.maxnum.f64(double, double)
declare <4 x float> @llvm.minnum.v4f32(<4 x float>, <4 x float>)
declare <4 x float> @llvm.maxnum.v4f32(<4 x float>, <4 x float>)
declare <2 x double> @llvm.minnum.v2f64(<2 x double>, <2 x double>)
declare <2 x double> @llvm.maxnum.v2f64(<2 x double>, <2 x double>)

define float @fminnum32_intrinsic(float %x, float %y) {
; ARMV7-LABEL: fminnum32_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    vmov s0, r1
; ARMV7-NEXT:    vmov s2, r0
; ARMV7-NEXT:    vcmp.f32 s2, s0
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmovlt.f32 s0, s2
; ARMV7-NEXT:    vmov r0, s0
; ARMV7-NEXT:    bx lr
;
; ARMV8-LABEL: fminnum32_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    vmov s0, r1
; ARMV8-NEXT:    vmov s2, r0
; ARMV8-NEXT:    vminnm.f32 s0, s2, s0
; ARMV8-NEXT:    vmov r0, s0
; ARMV8-NEXT:    bx lr
;
; ARMV8M-LABEL: fminnum32_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    vmov s0, r1
; ARMV8M-NEXT:    vmov s2, r0
; ARMV8M-NEXT:    vminnm.f32 s0, s2, s0
; ARMV8M-NEXT:    vmov r0, s0
; ARMV8M-NEXT:    bx lr
  %a = call nnan float @llvm.minnum.f32(float %x, float %y)
  ret float %a
}

define float @fminnum32_nsz_intrinsic(float %x, float %y) {
; ARMV7-LABEL: fminnum32_nsz_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    vmov s0, r1
; ARMV7-NEXT:    vmov s2, r0
; ARMV7-NEXT:    vmin.f32 d0, d1, d0
; ARMV7-NEXT:    vmov r0, s0
; ARMV7-NEXT:    bx lr
;
; ARMV8-LABEL: fminnum32_nsz_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    vmov s0, r1
; ARMV8-NEXT:    vmov s2, r0
; ARMV8-NEXT:    vminnm.f32 s0, s2, s0
; ARMV8-NEXT:    vmov r0, s0
; ARMV8-NEXT:    bx lr
;
; ARMV8M-LABEL: fminnum32_nsz_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    vmov s0, r1
; ARMV8M-NEXT:    vmov s2, r0
; ARMV8M-NEXT:    vminnm.f32 s0, s2, s0
; ARMV8M-NEXT:    vmov r0, s0
; ARMV8M-NEXT:    bx lr
  %a = call nnan nsz float @llvm.minnum.f32(float %x, float %y)
  ret float %a
}

define float @fminnum32_non_zero_intrinsic(float %x) {
; ARMV7-LABEL: fminnum32_non_zero_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    vmov.f32 s0, #-1.000000e+00
; ARMV7-NEXT:    vmov s2, r0
; ARMV7-NEXT:    vmin.f32 d0, d1, d0
; ARMV7-NEXT:    vmov r0, s0
; ARMV7-NEXT:    bx lr
;
; ARMV8-LABEL: fminnum32_non_zero_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    vmov.f32 s0, #-1.000000e+00
; ARMV8-NEXT:    vmov s2, r0
; ARMV8-NEXT:    vminnm.f32 s0, s2, s0
; ARMV8-NEXT:    vmov r0, s0
; ARMV8-NEXT:    bx lr
;
; ARMV8M-LABEL: fminnum32_non_zero_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    vmov.f32 s0, #-1.000000e+00
; ARMV8M-NEXT:    vmov s2, r0
; ARMV8M-NEXT:    vminnm.f32 s0, s2, s0
; ARMV8M-NEXT:    vmov r0, s0
; ARMV8M-NEXT:    bx lr
  %a = call nnan float @llvm.minnum.f32(float %x, float -1.0)
  ret float %a
}

define float @fmaxnum32_intrinsic(float %x, float %y) {
; ARMV7-LABEL: fmaxnum32_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    vmov s0, r1
; ARMV7-NEXT:    vmov s2, r0
; ARMV7-NEXT:    vcmp.f32 s2, s0
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmovgt.f32 s0, s2
; ARMV7-NEXT:    vmov r0, s0
; ARMV7-NEXT:    bx lr
;
; ARMV8-LABEL: fmaxnum32_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    vmov s0, r1
; ARMV8-NEXT:    vmov s2, r0
; ARMV8-NEXT:    vmaxnm.f32 s0, s2, s0
; ARMV8-NEXT:    vmov r0, s0
; ARMV8-NEXT:    bx lr
;
; ARMV8M-LABEL: fmaxnum32_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    vmov s0, r1
; ARMV8M-NEXT:    vmov s2, r0
; ARMV8M-NEXT:    vmaxnm.f32 s0, s2, s0
; ARMV8M-NEXT:    vmov r0, s0
; ARMV8M-NEXT:    bx lr
  %a = call nnan float @llvm.maxnum.f32(float %x, float %y)
  ret float %a
}

define float @fmaxnum32_nsz_intrinsic(float %x, float %y) {
; ARMV7-LABEL: fmaxnum32_nsz_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    vmov s0, r1
; ARMV7-NEXT:    vmov s2, r0
; ARMV7-NEXT:    vmax.f32 d0, d1, d0
; ARMV7-NEXT:    vmov r0, s0
; ARMV7-NEXT:    bx lr
;
; ARMV8-LABEL: fmaxnum32_nsz_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    vmov s0, r1
; ARMV8-NEXT:    vmov s2, r0
; ARMV8-NEXT:    vmaxnm.f32 s0, s2, s0
; ARMV8-NEXT:    vmov r0, s0
; ARMV8-NEXT:    bx lr
;
; ARMV8M-LABEL: fmaxnum32_nsz_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    vmov s0, r1
; ARMV8M-NEXT:    vmov s2, r0
; ARMV8M-NEXT:    vmaxnm.f32 s0, s2, s0
; ARMV8M-NEXT:    vmov r0, s0
; ARMV8M-NEXT:    bx lr
  %a = call nnan nsz float @llvm.maxnum.f32(float %x, float %y)
  ret float %a
}

define float @fmaxnum32_zero_intrinsic(float %x) {
; ARMV7-LABEL: fmaxnum32_zero_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    vmov s0, r0
; ARMV7-NEXT:    vldr s2, .LCPI5_0
; ARMV7-NEXT:    vcmp.f32 s0, #0
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmovgt.f32 s2, s0
; ARMV7-NEXT:    vmov r0, s2
; ARMV7-NEXT:    bx lr
; ARMV7-NEXT:    .p2align 2
; ARMV7-NEXT:  @ %bb.1:
; ARMV7-NEXT:  .LCPI5_0:
; ARMV7-NEXT:    .long 0x00000000 @ float 0
;
; ARMV8-LABEL: fmaxnum32_zero_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    vldr s0, .LCPI5_0
; ARMV8-NEXT:    vmov s2, r0
; ARMV8-NEXT:    vmaxnm.f32 s0, s2, s0
; ARMV8-NEXT:    vmov r0, s0
; ARMV8-NEXT:    bx lr
; ARMV8-NEXT:    .p2align 2
; ARMV8-NEXT:  @ %bb.1:
; ARMV8-NEXT:  .LCPI5_0:
; ARMV8-NEXT:    .long 0x00000000 @ float 0
;
; ARMV8M-LABEL: fmaxnum32_zero_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    vldr s0, .LCPI5_0
; ARMV8M-NEXT:    vmov s2, r0
; ARMV8M-NEXT:    vmaxnm.f32 s0, s2, s0
; ARMV8M-NEXT:    vmov r0, s0
; ARMV8M-NEXT:    bx lr
; ARMV8M-NEXT:    .p2align 2
; ARMV8M-NEXT:  @ %bb.1:
; ARMV8M-NEXT:  .LCPI5_0:
; ARMV8M-NEXT:    .long 0x00000000 @ float 0
  %a = call nnan float @llvm.maxnum.f32(float %x, float 0.0)
  ret float %a
}

define float @fmaxnum32_non_zero_intrinsic(float %x) {
; ARMV7-LABEL: fmaxnum32_non_zero_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    vmov.f32 s0, #1.000000e+00
; ARMV7-NEXT:    vmov s2, r0
; ARMV7-NEXT:    vmax.f32 d0, d1, d0
; ARMV7-NEXT:    vmov r0, s0
; ARMV7-NEXT:    bx lr
;
; ARMV8-LABEL: fmaxnum32_non_zero_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    vmov.f32 s0, #1.000000e+00
; ARMV8-NEXT:    vmov s2, r0
; ARMV8-NEXT:    vmaxnm.f32 s0, s2, s0
; ARMV8-NEXT:    vmov r0, s0
; ARMV8-NEXT:    bx lr
;
; ARMV8M-LABEL: fmaxnum32_non_zero_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    vmov.f32 s0, #1.000000e+00
; ARMV8M-NEXT:    vmov s2, r0
; ARMV8M-NEXT:    vmaxnm.f32 s0, s2, s0
; ARMV8M-NEXT:    vmov r0, s0
; ARMV8M-NEXT:    bx lr
  %a = call nnan float @llvm.maxnum.f32(float %x, float 1.0)
  ret float %a
}

define double @fminnum64_intrinsic(double %x, double %y) {
; ARMV7-LABEL: fminnum64_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    vmov d16, r2, r3
; ARMV7-NEXT:    vmov d17, r0, r1
; ARMV7-NEXT:    vcmp.f64 d17, d16
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmovlt.f64 d16, d17
; ARMV7-NEXT:    vmov r0, r1, d16
; ARMV7-NEXT:    bx lr
;
; ARMV8-LABEL: fminnum64_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    vmov d16, r2, r3
; ARMV8-NEXT:    vmov d17, r0, r1
; ARMV8-NEXT:    vminnm.f64 d16, d17, d16
; ARMV8-NEXT:    vmov r0, r1, d16
; ARMV8-NEXT:    bx lr
;
; ARMV8M-LABEL: fminnum64_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    vmov d0, r2, r3
; ARMV8M-NEXT:    vmov d1, r0, r1
; ARMV8M-NEXT:    vminnm.f64 d0, d1, d0
; ARMV8M-NEXT:    vmov r0, r1, d0
; ARMV8M-NEXT:    bx lr
  %a = call nnan double @llvm.minnum.f64(double %x, double %y)
  ret double %a
}

define double @fminnum64_nsz_intrinsic(double %x, double %y) {
; ARMV7-LABEL: fminnum64_nsz_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    vmov d16, r2, r3
; ARMV7-NEXT:    vmov d17, r0, r1
; ARMV7-NEXT:    vcmp.f64 d17, d16
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmovlt.f64 d16, d17
; ARMV7-NEXT:    vmov r0, r1, d16
; ARMV7-NEXT:    bx lr
;
; ARMV8-LABEL: fminnum64_nsz_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    vmov d16, r2, r3
; ARMV8-NEXT:    vmov d17, r0, r1
; ARMV8-NEXT:    vminnm.f64 d16, d17, d16
; ARMV8-NEXT:    vmov r0, r1, d16
; ARMV8-NEXT:    bx lr
;
; ARMV8M-LABEL: fminnum64_nsz_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    vmov d0, r2, r3
; ARMV8M-NEXT:    vmov d1, r0, r1
; ARMV8M-NEXT:    vminnm.f64 d0, d1, d0
; ARMV8M-NEXT:    vmov r0, r1, d0
; ARMV8M-NEXT:    bx lr
  %a = call nnan nsz double @llvm.minnum.f64(double %x, double %y)
  ret double %a
}

define double @fminnum64_zero_intrinsic(double %x) {
; ARMV7-LABEL: fminnum64_zero_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    vldr d16, .LCPI9_0
; ARMV7-NEXT:    vmov d17, r0, r1
; ARMV7-NEXT:    vcmp.f64 d17, d16
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmovlt.f64 d16, d17
; ARMV7-NEXT:    vmov r0, r1, d16
; ARMV7-NEXT:    bx lr
; ARMV7-NEXT:    .p2align 3
; ARMV7-NEXT:  @ %bb.1:
; ARMV7-NEXT:  .LCPI9_0:
; ARMV7-NEXT:    .long 0 @ double -0
; ARMV7-NEXT:    .long 2147483648
;
; ARMV8-LABEL: fminnum64_zero_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    vldr d16, .LCPI9_0
; ARMV8-NEXT:    vmov d17, r0, r1
; ARMV8-NEXT:    vminnm.f64 d16, d17, d16
; ARMV8-NEXT:    vmov r0, r1, d16
; ARMV8-NEXT:    bx lr
; ARMV8-NEXT:    .p2align 3
; ARMV8-NEXT:  @ %bb.1:
; ARMV8-NEXT:  .LCPI9_0:
; ARMV8-NEXT:    .long 0 @ double -0
; ARMV8-NEXT:    .long 2147483648
;
; ARMV8M-LABEL: fminnum64_zero_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    vldr d0, .LCPI9_0
; ARMV8M-NEXT:    vmov d1, r0, r1
; ARMV8M-NEXT:    vminnm.f64 d0, d1, d0
; ARMV8M-NEXT:    vmov r0, r1, d0
; ARMV8M-NEXT:    bx lr
; ARMV8M-NEXT:    .p2align 3
; ARMV8M-NEXT:  @ %bb.1:
; ARMV8M-NEXT:  .LCPI9_0:
; ARMV8M-NEXT:    .long 0 @ double -0
; ARMV8M-NEXT:    .long 2147483648
  %a = call nnan double @llvm.minnum.f64(double %x, double -0.0)
  ret double %a
}

define double @fminnum64_non_zero_intrinsic(double %x) {
; ARMV7-LABEL: fminnum64_non_zero_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    vmov.f64 d16, #-1.000000e+00
; ARMV7-NEXT:    vmov d17, r0, r1
; ARMV7-NEXT:    vcmp.f64 d17, d16
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmovlt.f64 d16, d17
; ARMV7-NEXT:    vmov r0, r1, d16
; ARMV7-NEXT:    bx lr
;
; ARMV8-LABEL: fminnum64_non_zero_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    vmov.f64 d16, #-1.000000e+00
; ARMV8-NEXT:    vmov d17, r0, r1
; ARMV8-NEXT:    vminnm.f64 d16, d17, d16
; ARMV8-NEXT:    vmov r0, r1, d16
; ARMV8-NEXT:    bx lr
;
; ARMV8M-LABEL: fminnum64_non_zero_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    vmov.f64 d0, #-1.000000e+00
; ARMV8M-NEXT:    vmov d1, r0, r1
; ARMV8M-NEXT:    vminnm.f64 d0, d1, d0
; ARMV8M-NEXT:    vmov r0, r1, d0
; ARMV8M-NEXT:    bx lr
  %a = call nnan double @llvm.minnum.f64(double %x, double -1.0)
  ret double %a
}

define double@fmaxnum64_intrinsic(double %x, double %y) {
; ARMV7-LABEL: fmaxnum64_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    vmov d16, r2, r3
; ARMV7-NEXT:    vmov d17, r0, r1
; ARMV7-NEXT:    vcmp.f64 d17, d16
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmovgt.f64 d16, d17
; ARMV7-NEXT:    vmov r0, r1, d16
; ARMV7-NEXT:    bx lr
;
; ARMV8-LABEL: fmaxnum64_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    vmov d16, r2, r3
; ARMV8-NEXT:    vmov d17, r0, r1
; ARMV8-NEXT:    vmaxnm.f64 d16, d17, d16
; ARMV8-NEXT:    vmov r0, r1, d16
; ARMV8-NEXT:    bx lr
;
; ARMV8M-LABEL: fmaxnum64_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    vmov d0, r2, r3
; ARMV8M-NEXT:    vmov d1, r0, r1
; ARMV8M-NEXT:    vmaxnm.f64 d0, d1, d0
; ARMV8M-NEXT:    vmov r0, r1, d0
; ARMV8M-NEXT:    bx lr
  %a = call nnan double @llvm.maxnum.f64(double %x, double %y)
  ret double %a
}

define double@fmaxnum64_nsz_intrinsic(double %x, double %y) {
; ARMV7-LABEL: fmaxnum64_nsz_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    vmov d16, r2, r3
; ARMV7-NEXT:    vmov d17, r0, r1
; ARMV7-NEXT:    vcmp.f64 d17, d16
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmovgt.f64 d16, d17
; ARMV7-NEXT:    vmov r0, r1, d16
; ARMV7-NEXT:    bx lr
;
; ARMV8-LABEL: fmaxnum64_nsz_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    vmov d16, r2, r3
; ARMV8-NEXT:    vmov d17, r0, r1
; ARMV8-NEXT:    vmaxnm.f64 d16, d17, d16
; ARMV8-NEXT:    vmov r0, r1, d16
; ARMV8-NEXT:    bx lr
;
; ARMV8M-LABEL: fmaxnum64_nsz_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    vmov d0, r2, r3
; ARMV8M-NEXT:    vmov d1, r0, r1
; ARMV8M-NEXT:    vmaxnm.f64 d0, d1, d0
; ARMV8M-NEXT:    vmov r0, r1, d0
; ARMV8M-NEXT:    bx lr
  %a = call nnan nsz double @llvm.maxnum.f64(double %x, double %y)
  ret double %a
}

define double @fmaxnum64_zero_intrinsic(double %x) {
; ARMV7-LABEL: fmaxnum64_zero_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    vmov d16, r0, r1
; ARMV7-NEXT:    vcmp.f64 d16, #0
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmov.i32 d17, #0x0
; ARMV7-NEXT:    vmovgt.f64 d17, d16
; ARMV7-NEXT:    vmov r0, r1, d17
; ARMV7-NEXT:    bx lr
;
; ARMV8-LABEL: fmaxnum64_zero_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    vmov.i32 d16, #0x0
; ARMV8-NEXT:    vmov d17, r0, r1
; ARMV8-NEXT:    vmaxnm.f64 d16, d17, d16
; ARMV8-NEXT:    vmov r0, r1, d16
; ARMV8-NEXT:    bx lr
;
; ARMV8M-LABEL: fmaxnum64_zero_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    vldr d0, .LCPI13_0
; ARMV8M-NEXT:    vmov d1, r0, r1
; ARMV8M-NEXT:    vmaxnm.f64 d0, d1, d0
; ARMV8M-NEXT:    vmov r0, r1, d0
; ARMV8M-NEXT:    bx lr
; ARMV8M-NEXT:    .p2align 3
; ARMV8M-NEXT:  @ %bb.1:
; ARMV8M-NEXT:  .LCPI13_0:
; ARMV8M-NEXT:    .long 0 @ double 0
; ARMV8M-NEXT:    .long 0
  %a = call nnan double @llvm.maxnum.f64(double %x, double 0.0)
  ret double %a
}

define double @fmaxnum64_non_zero_intrinsic(double %x) {
; ARMV7-LABEL: fmaxnum64_non_zero_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    vmov.f64 d16, #1.000000e+00
; ARMV7-NEXT:    vmov d17, r0, r1
; ARMV7-NEXT:    vcmp.f64 d17, d16
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmovgt.f64 d16, d17
; ARMV7-NEXT:    vmov r0, r1, d16
; ARMV7-NEXT:    bx lr
;
; ARMV8-LABEL: fmaxnum64_non_zero_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    vmov.f64 d16, #1.000000e+00
; ARMV8-NEXT:    vmov d17, r0, r1
; ARMV8-NEXT:    vmaxnm.f64 d16, d17, d16
; ARMV8-NEXT:    vmov r0, r1, d16
; ARMV8-NEXT:    bx lr
;
; ARMV8M-LABEL: fmaxnum64_non_zero_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    vmov.f64 d0, #1.000000e+00
; ARMV8M-NEXT:    vmov d1, r0, r1
; ARMV8M-NEXT:    vmaxnm.f64 d0, d1, d0
; ARMV8M-NEXT:    vmov r0, r1, d0
; ARMV8M-NEXT:    bx lr
  %a = call nnan double @llvm.maxnum.f64(double %x, double 1.0)
  ret double %a
}

define <4 x float> @fminnumv432_intrinsic(<4 x float> %x, <4 x float> %y) {
; ARMV7-LABEL: fminnumv432_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    mov r12, sp
; ARMV7-NEXT:    vld1.64 {d0, d1}, [r12]
; ARMV7-NEXT:    vmov d3, r2, r3
; ARMV7-NEXT:    vmov d2, r0, r1
; ARMV7-NEXT:    vcmp.f32 s6, s2
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vcmp.f32 s7, s3
; ARMV7-NEXT:    vmovlt.f32 s2, s6
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vcmp.f32 s5, s1
; ARMV7-NEXT:    vmovlt.f32 s3, s7
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vcmp.f32 s4, s0
; ARMV7-NEXT:    vmovlt.f32 s1, s5
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmovlt.f32 s0, s4
; ARMV7-NEXT:    vmov r2, r3, d1
; ARMV7-NEXT:    vmov r0, r1, d0
; ARMV7-NEXT:    bx lr
;
; ARMV8-LABEL: fminnumv432_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    vmov d17, r2, r3
; ARMV8-NEXT:    vmov d16, r0, r1
; ARMV8-NEXT:    mov r0, sp
; ARMV8-NEXT:    vld1.64 {d18, d19}, [r0]
; ARMV8-NEXT:    vminnm.f32 q8, q8, q9
; ARMV8-NEXT:    vmov r0, r1, d16
; ARMV8-NEXT:    vmov r2, r3, d17
; ARMV8-NEXT:    bx lr
;
; ARMV8M-LABEL: fminnumv432_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    vmov d0, r0, r1
; ARMV8M-NEXT:    mov r0, sp
; ARMV8M-NEXT:    vldrw.u32 q1, [r0]
; ARMV8M-NEXT:    vmov d1, r2, r3
; ARMV8M-NEXT:    vminnm.f32 q0, q0, q1
; ARMV8M-NEXT:    vmov r0, r1, d0
; ARMV8M-NEXT:    vmov r2, r3, d1
; ARMV8M-NEXT:    bx lr
  %a = call nnan <4 x float> @llvm.minnum.v4f32(<4 x float> %x, <4 x float> %y)
  ret <4 x float> %a
}

define <4 x float> @fminnumv432_nsz_intrinsic(<4 x float> %x, <4 x float> %y) {
; ARMV7-LABEL: fminnumv432_nsz_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    vmov d17, r2, r3
; ARMV7-NEXT:    vmov d16, r0, r1
; ARMV7-NEXT:    mov r0, sp
; ARMV7-NEXT:    vld1.64 {d18, d19}, [r0]
; ARMV7-NEXT:    vmin.f32 q8, q8, q9
; ARMV7-NEXT:    vmov r0, r1, d16
; ARMV7-NEXT:    vmov r2, r3, d17
; ARMV7-NEXT:    bx lr
;
; ARMV8-LABEL: fminnumv432_nsz_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    vmov d17, r2, r3
; ARMV8-NEXT:    vmov d16, r0, r1
; ARMV8-NEXT:    mov r0, sp
; ARMV8-NEXT:    vld1.64 {d18, d19}, [r0]
; ARMV8-NEXT:    vminnm.f32 q8, q8, q9
; ARMV8-NEXT:    vmov r0, r1, d16
; ARMV8-NEXT:    vmov r2, r3, d17
; ARMV8-NEXT:    bx lr
;
; ARMV8M-LABEL: fminnumv432_nsz_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    vmov d0, r0, r1
; ARMV8M-NEXT:    mov r0, sp
; ARMV8M-NEXT:    vldrw.u32 q1, [r0]
; ARMV8M-NEXT:    vmov d1, r2, r3
; ARMV8M-NEXT:    vminnm.f32 q0, q0, q1
; ARMV8M-NEXT:    vmov r0, r1, d0
; ARMV8M-NEXT:    vmov r2, r3, d1
; ARMV8M-NEXT:    bx lr
  %a = call nnan nsz <4 x float> @llvm.minnum.v4f32(<4 x float> %x, <4 x float> %y)
  ret <4 x float> %a
}

define <4 x float> @fminnumv432_non_zero_intrinsic(<4 x float> %x) {
; ARMV7-LABEL: fminnumv432_non_zero_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    vmov d19, r2, r3
; ARMV7-NEXT:    vmov.f32 q8, #-1.000000e+00
; ARMV7-NEXT:    vmov d18, r0, r1
; ARMV7-NEXT:    vmin.f32 q8, q9, q8
; ARMV7-NEXT:    vmov r0, r1, d16
; ARMV7-NEXT:    vmov r2, r3, d17
; ARMV7-NEXT:    bx lr
;
; ARMV8-LABEL: fminnumv432_non_zero_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    vmov d17, r2, r3
; ARMV8-NEXT:    vmov d16, r0, r1
; ARMV8-NEXT:    vmov.f32 q9, #-1.000000e+00
; ARMV8-NEXT:    vminnm.f32 q8, q8, q9
; ARMV8-NEXT:    vmov r0, r1, d16
; ARMV8-NEXT:    vmov r2, r3, d17
; ARMV8-NEXT:    bx lr
;
; ARMV8M-LABEL: fminnumv432_non_zero_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    vmov d1, r2, r3
; ARMV8M-NEXT:    vmov.f32 q1, #-1.000000e+00
; ARMV8M-NEXT:    vmov d0, r0, r1
; ARMV8M-NEXT:    vminnm.f32 q0, q0, q1
; ARMV8M-NEXT:    vmov r0, r1, d0
; ARMV8M-NEXT:    vmov r2, r3, d1
; ARMV8M-NEXT:    bx lr
  %a = call nnan <4 x float> @llvm.minnum.v4f32(<4 x float> %x, <4 x float><float -1.0, float -1.0, float -1.0, float -1.0>)
  ret <4 x float> %a
}

define <4 x float> @fminnumv432_one_zero_intrinsic(<4 x float> %x) {
; ARMV7-LABEL: fminnumv432_one_zero_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    vmov d1, r2, r3
; ARMV7-NEXT:    vldr s4, .LCPI18_0
; ARMV7-NEXT:    vmov d0, r0, r1
; ARMV7-NEXT:    vmov.f32 s6, #-1.000000e+00
; ARMV7-NEXT:    vcmp.f32 s1, #0
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmov.f32 s8, s3
; ARMV7-NEXT:    vmin.f32 d7, d1, d3
; ARMV7-NEXT:    vmin.f32 d6, d0, d3
; ARMV7-NEXT:    vmin.f32 d4, d4, d3
; ARMV7-NEXT:    vmovlt.f32 s4, s1
; ARMV7-NEXT:    vmov.f32 s13, s4
; ARMV7-NEXT:    vmov.f32 s15, s8
; ARMV7-NEXT:    vmov r0, r1, d6
; ARMV7-NEXT:    vmov r2, r3, d7
; ARMV7-NEXT:    bx lr
; ARMV7-NEXT:    .p2align 2
; ARMV7-NEXT:  @ %bb.1:
; ARMV7-NEXT:  .LCPI18_0:
; ARMV7-NEXT:    .long 0x00000000 @ float 0
;
; ARMV8-LABEL: fminnumv432_one_zero_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    vmov d17, r2, r3
; ARMV8-NEXT:    vmov d16, r0, r1
; ARMV8-NEXT:    adr r0, .LCPI18_0
; ARMV8-NEXT:    vld1.64 {d18, d19}, [r0:128]
; ARMV8-NEXT:    vminnm.f32 q8, q8, q9
; ARMV8-NEXT:    vmov r0, r1, d16
; ARMV8-NEXT:    vmov r2, r3, d17
; ARMV8-NEXT:    bx lr
; ARMV8-NEXT:    .p2align 4
; ARMV8-NEXT:  @ %bb.1:
; ARMV8-NEXT:  .LCPI18_0:
; ARMV8-NEXT:    .long 0xbf800000 @ float -1
; ARMV8-NEXT:    .long 0x00000000 @ float 0
; ARMV8-NEXT:    .long 0xbf800000 @ float -1
; ARMV8-NEXT:    .long 0xbf800000 @ float -1
;
; ARMV8M-LABEL: fminnumv432_one_zero_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    vmov d0, r0, r1
; ARMV8M-NEXT:    adr r0, .LCPI18_0
; ARMV8M-NEXT:    vldrw.u32 q1, [r0]
; ARMV8M-NEXT:    vmov d1, r2, r3
; ARMV8M-NEXT:    vminnm.f32 q0, q0, q1
; ARMV8M-NEXT:    vmov r0, r1, d0
; ARMV8M-NEXT:    vmov r2, r3, d1
; ARMV8M-NEXT:    bx lr
; ARMV8M-NEXT:    .p2align 4
; ARMV8M-NEXT:  @ %bb.1:
; ARMV8M-NEXT:  .LCPI18_0:
; ARMV8M-NEXT:    .long 0xbf800000 @ float -1
; ARMV8M-NEXT:    .long 0x00000000 @ float 0
; ARMV8M-NEXT:    .long 0xbf800000 @ float -1
; ARMV8M-NEXT:    .long 0xbf800000 @ float -1
  %a = call nnan <4 x float> @llvm.minnum.v4f32(<4 x float> %x, <4 x float><float -1.0, float 0.0, float -1.0, float -1.0>)
  ret <4 x float> %a
}

define <4 x float> @fmaxnumv432_intrinsic(<4 x float> %x, <4 x float> %y) {
; ARMV7-LABEL: fmaxnumv432_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    mov r12, sp
; ARMV7-NEXT:    vld1.64 {d0, d1}, [r12]
; ARMV7-NEXT:    vmov d3, r2, r3
; ARMV7-NEXT:    vmov d2, r0, r1
; ARMV7-NEXT:    vcmp.f32 s6, s2
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vcmp.f32 s7, s3
; ARMV7-NEXT:    vmovgt.f32 s2, s6
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vcmp.f32 s5, s1
; ARMV7-NEXT:    vmovgt.f32 s3, s7
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vcmp.f32 s4, s0
; ARMV7-NEXT:    vmovgt.f32 s1, s5
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmovgt.f32 s0, s4
; ARMV7-NEXT:    vmov r2, r3, d1
; ARMV7-NEXT:    vmov r0, r1, d0
; ARMV7-NEXT:    bx lr
;
; ARMV8-LABEL: fmaxnumv432_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    vmov d17, r2, r3
; ARMV8-NEXT:    vmov d16, r0, r1
; ARMV8-NEXT:    mov r0, sp
; ARMV8-NEXT:    vld1.64 {d18, d19}, [r0]
; ARMV8-NEXT:    vmaxnm.f32 q8, q8, q9
; ARMV8-NEXT:    vmov r0, r1, d16
; ARMV8-NEXT:    vmov r2, r3, d17
; ARMV8-NEXT:    bx lr
;
; ARMV8M-LABEL: fmaxnumv432_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    vmov d0, r0, r1
; ARMV8M-NEXT:    mov r0, sp
; ARMV8M-NEXT:    vldrw.u32 q1, [r0]
; ARMV8M-NEXT:    vmov d1, r2, r3
; ARMV8M-NEXT:    vmaxnm.f32 q0, q0, q1
; ARMV8M-NEXT:    vmov r0, r1, d0
; ARMV8M-NEXT:    vmov r2, r3, d1
; ARMV8M-NEXT:    bx lr
  %a = call nnan <4 x float> @llvm.maxnum.v4f32(<4 x float> %x, <4 x float> %y)
  ret <4 x float> %a
}

define <4 x float> @fmaxnumv432_nsz_intrinsic(<4 x float> %x, <4 x float> %y) {
; ARMV7-LABEL: fmaxnumv432_nsz_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    vmov d17, r2, r3
; ARMV7-NEXT:    vmov d16, r0, r1
; ARMV7-NEXT:    mov r0, sp
; ARMV7-NEXT:    vld1.64 {d18, d19}, [r0]
; ARMV7-NEXT:    vmax.f32 q8, q8, q9
; ARMV7-NEXT:    vmov r0, r1, d16
; ARMV7-NEXT:    vmov r2, r3, d17
; ARMV7-NEXT:    bx lr
;
; ARMV8-LABEL: fmaxnumv432_nsz_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    vmov d17, r2, r3
; ARMV8-NEXT:    vmov d16, r0, r1
; ARMV8-NEXT:    mov r0, sp
; ARMV8-NEXT:    vld1.64 {d18, d19}, [r0]
; ARMV8-NEXT:    vmaxnm.f32 q8, q8, q9
; ARMV8-NEXT:    vmov r0, r1, d16
; ARMV8-NEXT:    vmov r2, r3, d17
; ARMV8-NEXT:    bx lr
;
; ARMV8M-LABEL: fmaxnumv432_nsz_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    vmov d0, r0, r1
; ARMV8M-NEXT:    mov r0, sp
; ARMV8M-NEXT:    vldrw.u32 q1, [r0]
; ARMV8M-NEXT:    vmov d1, r2, r3
; ARMV8M-NEXT:    vmaxnm.f32 q0, q0, q1
; ARMV8M-NEXT:    vmov r0, r1, d0
; ARMV8M-NEXT:    vmov r2, r3, d1
; ARMV8M-NEXT:    bx lr
  %a = call nnan nsz <4 x float> @llvm.maxnum.v4f32(<4 x float> %x, <4 x float> %y)
  ret <4 x float> %a
}

define <4 x float> @fmaxnumv432_zero_intrinsic(<4 x float> %x) {
; ARMV7-LABEL: fmaxnumv432_zero_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    vmov d3, r2, r3
; ARMV7-NEXT:    vldr s0, .LCPI21_0
; ARMV7-NEXT:    vmov d2, r0, r1
; ARMV7-NEXT:    vcmp.f32 s6, #0
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmov.f32 s2, s0
; ARMV7-NEXT:    vcmp.f32 s7, #0
; ARMV7-NEXT:    vmovgt.f32 s2, s6
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmov.f32 s3, s0
; ARMV7-NEXT:    vcmp.f32 s5, #0
; ARMV7-NEXT:    vmovgt.f32 s3, s7
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmov.f32 s1, s0
; ARMV7-NEXT:    vcmp.f32 s4, #0
; ARMV7-NEXT:    vmovgt.f32 s1, s5
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmovgt.f32 s0, s4
; ARMV7-NEXT:    vmov r2, r3, d1
; ARMV7-NEXT:    vmov r0, r1, d0
; ARMV7-NEXT:    bx lr
; ARMV7-NEXT:    .p2align 2
; ARMV7-NEXT:  @ %bb.1:
; ARMV7-NEXT:  .LCPI21_0:
; ARMV7-NEXT:    .long 0x00000000 @ float 0
;
; ARMV8-LABEL: fmaxnumv432_zero_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    vmov d17, r2, r3
; ARMV8-NEXT:    vmov d16, r0, r1
; ARMV8-NEXT:    vmov.i32 q9, #0x0
; ARMV8-NEXT:    vmaxnm.f32 q8, q8, q9
; ARMV8-NEXT:    vmov r0, r1, d16
; ARMV8-NEXT:    vmov r2, r3, d17
; ARMV8-NEXT:    bx lr
;
; ARMV8M-LABEL: fmaxnumv432_zero_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    vmov d1, r2, r3
; ARMV8M-NEXT:    vmov.i32 q1, #0x0
; ARMV8M-NEXT:    vmov d0, r0, r1
; ARMV8M-NEXT:    vmaxnm.f32 q0, q0, q1
; ARMV8M-NEXT:    vmov r0, r1, d0
; ARMV8M-NEXT:    vmov r2, r3, d1
; ARMV8M-NEXT:    bx lr
  %a = call nnan <4 x float> @llvm.maxnum.v4f32(<4 x float> %x, <4 x float><float 0.0, float 0.0, float 0.0, float 0.0>)
  ret <4 x float> %a
}

define <4 x float> @fmaxnumv432_minus_zero_intrinsic(<4 x float> %x) {
; ARMV7-LABEL: fmaxnumv432_minus_zero_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    vldr s0, .LCPI22_0
; ARMV7-NEXT:    vmov d3, r2, r3
; ARMV7-NEXT:    vmov d2, r0, r1
; ARMV7-NEXT:    vcmp.f32 s6, s0
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vcmp.f32 s7, s0
; ARMV7-NEXT:    vmov.f32 s2, s0
; ARMV7-NEXT:    vmovgt.f32 s2, s6
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vcmp.f32 s5, s0
; ARMV7-NEXT:    vmov.f32 s3, s0
; ARMV7-NEXT:    vmovgt.f32 s3, s7
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vcmp.f32 s4, s0
; ARMV7-NEXT:    vmov.f32 s1, s0
; ARMV7-NEXT:    vmovgt.f32 s1, s5
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmovgt.f32 s0, s4
; ARMV7-NEXT:    vmov r2, r3, d1
; ARMV7-NEXT:    vmov r0, r1, d0
; ARMV7-NEXT:    bx lr
; ARMV7-NEXT:    .p2align 2
; ARMV7-NEXT:  @ %bb.1:
; ARMV7-NEXT:  .LCPI22_0:
; ARMV7-NEXT:    .long 0x80000000 @ float -0
;
; ARMV8-LABEL: fmaxnumv432_minus_zero_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    vmov d17, r2, r3
; ARMV8-NEXT:    vmov d16, r0, r1
; ARMV8-NEXT:    vmov.i32 q9, #0x80000000
; ARMV8-NEXT:    vmaxnm.f32 q8, q8, q9
; ARMV8-NEXT:    vmov r0, r1, d16
; ARMV8-NEXT:    vmov r2, r3, d17
; ARMV8-NEXT:    bx lr
;
; ARMV8M-LABEL: fmaxnumv432_minus_zero_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    vmov d1, r2, r3
; ARMV8M-NEXT:    vmov.i32 q1, #0x80000000
; ARMV8M-NEXT:    vmov d0, r0, r1
; ARMV8M-NEXT:    vmaxnm.f32 q0, q0, q1
; ARMV8M-NEXT:    vmov r0, r1, d0
; ARMV8M-NEXT:    vmov r2, r3, d1
; ARMV8M-NEXT:    bx lr
  %a = call nnan <4 x float> @llvm.maxnum.v4f32(<4 x float> %x, <4 x float><float -0.0, float -0.0, float -0.0, float -0.0>)
  ret <4 x float> %a
}

define <4 x float> @fmaxnumv432_non_zero_intrinsic(<4 x float> %x) {
; ARMV7-LABEL: fmaxnumv432_non_zero_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    vmov d19, r2, r3
; ARMV7-NEXT:    vmov.f32 q8, #1.000000e+00
; ARMV7-NEXT:    vmov d18, r0, r1
; ARMV7-NEXT:    vmax.f32 q8, q9, q8
; ARMV7-NEXT:    vmov r0, r1, d16
; ARMV7-NEXT:    vmov r2, r3, d17
; ARMV7-NEXT:    bx lr
;
; ARMV8-LABEL: fmaxnumv432_non_zero_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    vmov d17, r2, r3
; ARMV8-NEXT:    vmov d16, r0, r1
; ARMV8-NEXT:    vmov.f32 q9, #1.000000e+00
; ARMV8-NEXT:    vmaxnm.f32 q8, q8, q9
; ARMV8-NEXT:    vmov r0, r1, d16
; ARMV8-NEXT:    vmov r2, r3, d17
; ARMV8-NEXT:    bx lr
;
; ARMV8M-LABEL: fmaxnumv432_non_zero_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    vmov d1, r2, r3
; ARMV8M-NEXT:    vmov.f32 q1, #1.000000e+00
; ARMV8M-NEXT:    vmov d0, r0, r1
; ARMV8M-NEXT:    vmaxnm.f32 q0, q0, q1
; ARMV8M-NEXT:    vmov r0, r1, d0
; ARMV8M-NEXT:    vmov r2, r3, d1
; ARMV8M-NEXT:    bx lr
  %a = call nnan <4 x float> @llvm.maxnum.v4f32(<4 x float> %x, <4 x float><float 1.0, float 1.0, float 1.0, float 1.0>)
  ret <4 x float> %a
}

define <2 x double> @fminnumv264_intrinsic(<2 x double> %x, <2 x double> %y) {
; ARMV7-LABEL: fminnumv264_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    mov r12, sp
; ARMV7-NEXT:    vld1.64 {d16, d17}, [r12]
; ARMV7-NEXT:    vmov d18, r0, r1
; ARMV7-NEXT:    vcmp.f64 d18, d16
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmov d19, r2, r3
; ARMV7-NEXT:    vcmp.f64 d19, d17
; ARMV7-NEXT:    vmovlt.f64 d16, d18
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmov r0, r1, d16
; ARMV7-NEXT:    vmovlt.f64 d17, d19
; ARMV7-NEXT:    vmov r2, r3, d17
; ARMV7-NEXT:    bx lr
;
; ARMV8-LABEL: fminnumv264_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    mov r12, sp
; ARMV8-NEXT:    vld1.64 {d16, d17}, [r12]
; ARMV8-NEXT:    vmov d19, r0, r1
; ARMV8-NEXT:    vmov d18, r2, r3
; ARMV8-NEXT:    vminnm.f64 d19, d19, d16
; ARMV8-NEXT:    vminnm.f64 d16, d18, d17
; ARMV8-NEXT:    vmov r0, r1, d19
; ARMV8-NEXT:    vmov r2, r3, d16
; ARMV8-NEXT:    bx lr
;
; ARMV8M-LABEL: fminnumv264_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    mov r12, sp
; ARMV8M-NEXT:    vmov d0, r0, r1
; ARMV8M-NEXT:    vldrw.u32 q1, [r12]
; ARMV8M-NEXT:    vmov d1, r2, r3
; ARMV8M-NEXT:    vcmp.f64 d2, d0
; ARMV8M-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV8M-NEXT:    vcmp.f64 d3, d1
; ARMV8M-NEXT:    vselgt.f64 d0, d0, d2
; ARMV8M-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV8M-NEXT:    vmov r0, r1, d0
; ARMV8M-NEXT:    vselgt.f64 d0, d1, d3
; ARMV8M-NEXT:    vmov r2, r3, d0
; ARMV8M-NEXT:    bx lr
  %a = call nnan <2 x double> @llvm.minnum.v2f64(<2 x double> %x, <2 x double> %y)
  ret <2 x double> %a
}

define <2 x double> @fminnumv264_nsz_intrinsic(<2 x double> %x, <2 x double> %y) {
; ARMV7-LABEL: fminnumv264_nsz_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    mov r12, sp
; ARMV7-NEXT:    vld1.64 {d16, d17}, [r12]
; ARMV7-NEXT:    vmov d18, r0, r1
; ARMV7-NEXT:    vcmp.f64 d18, d16
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmov d19, r2, r3
; ARMV7-NEXT:    vcmp.f64 d19, d17
; ARMV7-NEXT:    vmovlt.f64 d16, d18
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmov r0, r1, d16
; ARMV7-NEXT:    vmovlt.f64 d17, d19
; ARMV7-NEXT:    vmov r2, r3, d17
; ARMV7-NEXT:    bx lr
;
; ARMV8-LABEL: fminnumv264_nsz_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    mov r12, sp
; ARMV8-NEXT:    vld1.64 {d16, d17}, [r12]
; ARMV8-NEXT:    vmov d19, r0, r1
; ARMV8-NEXT:    vmov d18, r2, r3
; ARMV8-NEXT:    vminnm.f64 d19, d19, d16
; ARMV8-NEXT:    vminnm.f64 d16, d18, d17
; ARMV8-NEXT:    vmov r0, r1, d19
; ARMV8-NEXT:    vmov r2, r3, d16
; ARMV8-NEXT:    bx lr
;
; ARMV8M-LABEL: fminnumv264_nsz_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    mov r12, sp
; ARMV8M-NEXT:    vmov d0, r0, r1
; ARMV8M-NEXT:    vldrw.u32 q1, [r12]
; ARMV8M-NEXT:    vmov d1, r2, r3
; ARMV8M-NEXT:    vcmp.f64 d2, d0
; ARMV8M-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV8M-NEXT:    vcmp.f64 d3, d1
; ARMV8M-NEXT:    vselgt.f64 d0, d0, d2
; ARMV8M-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV8M-NEXT:    vmov r0, r1, d0
; ARMV8M-NEXT:    vselgt.f64 d0, d1, d3
; ARMV8M-NEXT:    vmov r2, r3, d0
; ARMV8M-NEXT:    bx lr
  %a = call nnan nsz <2 x double> @llvm.minnum.v2f64(<2 x double> %x, <2 x double> %y)
  ret <2 x double> %a
}

define <2 x double> @fminnumv264_non_zero_intrinsic(<2 x double> %x) {
; ARMV7-LABEL: fminnumv264_non_zero_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    vmov.f64 d16, #1.000000e+00
; ARMV7-NEXT:    vmov d17, r0, r1
; ARMV7-NEXT:    vcmp.f64 d17, d16
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmov d18, r2, r3
; ARMV7-NEXT:    vcmp.f64 d18, d16
; ARMV7-NEXT:    vmov.f64 d19, d16
; ARMV7-NEXT:    vmovlt.f64 d19, d17
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmov r0, r1, d19
; ARMV7-NEXT:    vmovlt.f64 d16, d18
; ARMV7-NEXT:    vmov r2, r3, d16
; ARMV7-NEXT:    bx lr
;
; ARMV8-LABEL: fminnumv264_non_zero_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    vmov.f64 d16, #1.000000e+00
; ARMV8-NEXT:    vmov d18, r0, r1
; ARMV8-NEXT:    vmov d17, r2, r3
; ARMV8-NEXT:    vminnm.f64 d18, d18, d16
; ARMV8-NEXT:    vminnm.f64 d16, d17, d16
; ARMV8-NEXT:    vmov r0, r1, d18
; ARMV8-NEXT:    vmov r2, r3, d16
; ARMV8-NEXT:    bx lr
;
; ARMV8M-LABEL: fminnumv264_non_zero_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    vmov d1, r0, r1
; ARMV8M-NEXT:    vmov.f64 d0, #1.000000e+00
; ARMV8M-NEXT:    vcmp.f64 d0, d1
; ARMV8M-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV8M-NEXT:    vmov d2, r2, r3
; ARMV8M-NEXT:    vcmp.f64 d0, d2
; ARMV8M-NEXT:    vselgt.f64 d1, d1, d0
; ARMV8M-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV8M-NEXT:    vmov r0, r1, d1
; ARMV8M-NEXT:    vselgt.f64 d0, d2, d0
; ARMV8M-NEXT:    vmov r2, r3, d0
; ARMV8M-NEXT:    bx lr
  %a = call nnan <2 x double> @llvm.minnum.v2f64(<2 x double> %x, <2 x double><double 1.0, double 1.0>)
  ret <2 x double> %a
}

define <2 x double> @fminnumv264_one_zero_intrinsic(<2 x double> %x) {
; ARMV7-LABEL: fminnumv264_one_zero_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    vmov d18, r2, r3
; ARMV7-NEXT:    vcmp.f64 d18, #0
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmov d19, r0, r1
; ARMV7-NEXT:    vmov.f64 d16, #-1.000000e+00
; ARMV7-NEXT:    vcmp.f64 d19, d16
; ARMV7-NEXT:    vmov.i32 d17, #0x0
; ARMV7-NEXT:    vmovlt.f64 d17, d18
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmov r2, r3, d17
; ARMV7-NEXT:    vmovlt.f64 d16, d19
; ARMV7-NEXT:    vmov r0, r1, d16
; ARMV7-NEXT:    bx lr
;
; ARMV8-LABEL: fminnumv264_one_zero_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    vmov.f64 d16, #-1.000000e+00
; ARMV8-NEXT:    vmov d18, r0, r1
; ARMV8-NEXT:    vmov.i32 d17, #0x0
; ARMV8-NEXT:    vminnm.f64 d16, d18, d16
; ARMV8-NEXT:    vmov d19, r2, r3
; ARMV8-NEXT:    vminnm.f64 d17, d19, d17
; ARMV8-NEXT:    vmov r0, r1, d16
; ARMV8-NEXT:    vmov r2, r3, d17
; ARMV8-NEXT:    bx lr
;
; ARMV8M-LABEL: fminnumv264_one_zero_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    vmov d1, r2, r3
; ARMV8M-NEXT:    vldr d0, .LCPI27_0
; ARMV8M-NEXT:    vcmp.f64 d1, #0
; ARMV8M-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV8M-NEXT:    vmov d2, r0, r1
; ARMV8M-NEXT:    vmov.f64 d3, #-1.000000e+00
; ARMV8M-NEXT:    vcmp.f64 d3, d2
; ARMV8M-NEXT:    vmovlt.f64 d0, d1
; ARMV8M-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV8M-NEXT:    vmov r2, r3, d0
; ARMV8M-NEXT:    vselgt.f64 d1, d2, d3
; ARMV8M-NEXT:    vmov r0, r1, d1
; ARMV8M-NEXT:    bx lr
; ARMV8M-NEXT:    .p2align 3
; ARMV8M-NEXT:  @ %bb.1:
; ARMV8M-NEXT:  .LCPI27_0:
; ARMV8M-NEXT:    .long 0 @ double 0
; ARMV8M-NEXT:    .long 0
  %a = call nnan <2 x double> @llvm.minnum.v2f64(<2 x double> %x, <2 x double><double -1.0, double 0.0>)
  ret <2 x double> %a
}

define <2 x double> @fmaxnumv264_intrinsic(<2 x double> %x, <2 x double> %y) {
; ARMV7-LABEL: fmaxnumv264_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    mov r12, sp
; ARMV7-NEXT:    vld1.64 {d16, d17}, [r12]
; ARMV7-NEXT:    vmov d18, r0, r1
; ARMV7-NEXT:    vcmp.f64 d18, d16
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmov d19, r2, r3
; ARMV7-NEXT:    vcmp.f64 d19, d17
; ARMV7-NEXT:    vmovgt.f64 d16, d18
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmov r0, r1, d16
; ARMV7-NEXT:    vmovgt.f64 d17, d19
; ARMV7-NEXT:    vmov r2, r3, d17
; ARMV7-NEXT:    bx lr
;
; ARMV8-LABEL: fmaxnumv264_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    mov r12, sp
; ARMV8-NEXT:    vld1.64 {d16, d17}, [r12]
; ARMV8-NEXT:    vmov d19, r0, r1
; ARMV8-NEXT:    vmov d18, r2, r3
; ARMV8-NEXT:    vmaxnm.f64 d19, d19, d16
; ARMV8-NEXT:    vmaxnm.f64 d16, d18, d17
; ARMV8-NEXT:    vmov r0, r1, d19
; ARMV8-NEXT:    vmov r2, r3, d16
; ARMV8-NEXT:    bx lr
;
; ARMV8M-LABEL: fmaxnumv264_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    mov r12, sp
; ARMV8M-NEXT:    vmov d1, r0, r1
; ARMV8M-NEXT:    vldrw.u32 q1, [r12]
; ARMV8M-NEXT:    vmov d0, r2, r3
; ARMV8M-NEXT:    vcmp.f64 d1, d2
; ARMV8M-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV8M-NEXT:    vcmp.f64 d0, d3
; ARMV8M-NEXT:    vselgt.f64 d1, d1, d2
; ARMV8M-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV8M-NEXT:    vmov r0, r1, d1
; ARMV8M-NEXT:    vselgt.f64 d0, d0, d3
; ARMV8M-NEXT:    vmov r2, r3, d0
; ARMV8M-NEXT:    bx lr
  %a = call nnan <2 x double> @llvm.maxnum.v2f64(<2 x double> %x, <2 x double> %y)
  ret <2 x double> %a
}

define <2 x double> @fmaxnumv264_nsz_intrinsic(<2 x double> %x, <2 x double> %y) {
; ARMV7-LABEL: fmaxnumv264_nsz_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    mov r12, sp
; ARMV7-NEXT:    vld1.64 {d16, d17}, [r12]
; ARMV7-NEXT:    vmov d18, r0, r1
; ARMV7-NEXT:    vcmp.f64 d18, d16
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmov d19, r2, r3
; ARMV7-NEXT:    vcmp.f64 d19, d17
; ARMV7-NEXT:    vmovgt.f64 d16, d18
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmov r0, r1, d16
; ARMV7-NEXT:    vmovgt.f64 d17, d19
; ARMV7-NEXT:    vmov r2, r3, d17
; ARMV7-NEXT:    bx lr
;
; ARMV8-LABEL: fmaxnumv264_nsz_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    mov r12, sp
; ARMV8-NEXT:    vld1.64 {d16, d17}, [r12]
; ARMV8-NEXT:    vmov d19, r0, r1
; ARMV8-NEXT:    vmov d18, r2, r3
; ARMV8-NEXT:    vmaxnm.f64 d19, d19, d16
; ARMV8-NEXT:    vmaxnm.f64 d16, d18, d17
; ARMV8-NEXT:    vmov r0, r1, d19
; ARMV8-NEXT:    vmov r2, r3, d16
; ARMV8-NEXT:    bx lr
;
; ARMV8M-LABEL: fmaxnumv264_nsz_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    mov r12, sp
; ARMV8M-NEXT:    vmov d1, r0, r1
; ARMV8M-NEXT:    vldrw.u32 q1, [r12]
; ARMV8M-NEXT:    vmov d0, r2, r3
; ARMV8M-NEXT:    vcmp.f64 d1, d2
; ARMV8M-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV8M-NEXT:    vcmp.f64 d0, d3
; ARMV8M-NEXT:    vselgt.f64 d1, d1, d2
; ARMV8M-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV8M-NEXT:    vmov r0, r1, d1
; ARMV8M-NEXT:    vselgt.f64 d0, d0, d3
; ARMV8M-NEXT:    vmov r2, r3, d0
; ARMV8M-NEXT:    bx lr
  %a = call nnan nsz <2 x double> @llvm.maxnum.v2f64(<2 x double> %x, <2 x double> %y)
  ret <2 x double> %a
}

define <2 x double> @fmaxnumv264_zero_intrinsic(<2 x double> %x) {
; ARMV7-LABEL: fmaxnumv264_zero_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    vmov d18, r0, r1
; ARMV7-NEXT:    vldr d16, .LCPI30_0
; ARMV7-NEXT:    vcmp.f64 d18, #0
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmov d19, r2, r3
; ARMV7-NEXT:    vcmp.f64 d19, d16
; ARMV7-NEXT:    vmov.i32 d17, #0x0
; ARMV7-NEXT:    vmovgt.f64 d17, d18
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmov r0, r1, d17
; ARMV7-NEXT:    vmovgt.f64 d16, d19
; ARMV7-NEXT:    vmov r2, r3, d16
; ARMV7-NEXT:    bx lr
; ARMV7-NEXT:    .p2align 3
; ARMV7-NEXT:  @ %bb.1:
; ARMV7-NEXT:  .LCPI30_0:
; ARMV7-NEXT:    .long 0 @ double -0
; ARMV7-NEXT:    .long 2147483648
;
; ARMV8-LABEL: fmaxnumv264_zero_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    vldr d16, .LCPI30_0
; ARMV8-NEXT:    vmov d18, r2, r3
; ARMV8-NEXT:    vmov.i32 d17, #0x0
; ARMV8-NEXT:    vmov d19, r0, r1
; ARMV8-NEXT:    vmaxnm.f64 d16, d18, d16
; ARMV8-NEXT:    vmaxnm.f64 d17, d19, d17
; ARMV8-NEXT:    vmov r2, r3, d16
; ARMV8-NEXT:    vmov r0, r1, d17
; ARMV8-NEXT:    bx lr
; ARMV8-NEXT:    .p2align 3
; ARMV8-NEXT:  @ %bb.1:
; ARMV8-NEXT:  .LCPI30_0:
; ARMV8-NEXT:    .long 0 @ double -0
; ARMV8-NEXT:    .long 2147483648
;
; ARMV8M-LABEL: fmaxnumv264_zero_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    vmov d2, r0, r1
; ARMV8M-NEXT:    vldr d0, .LCPI30_0
; ARMV8M-NEXT:    vcmp.f64 d2, #0
; ARMV8M-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV8M-NEXT:    vmov d1, r2, r3
; ARMV8M-NEXT:    vcmp.f64 d1, d0
; ARMV8M-NEXT:    vldr d3, .LCPI30_1
; ARMV8M-NEXT:    vselgt.f64 d2, d2, d3
; ARMV8M-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV8M-NEXT:    vmov r0, r1, d2
; ARMV8M-NEXT:    vselgt.f64 d0, d1, d0
; ARMV8M-NEXT:    vmov r2, r3, d0
; ARMV8M-NEXT:    bx lr
; ARMV8M-NEXT:    .p2align 3
; ARMV8M-NEXT:  @ %bb.1:
; ARMV8M-NEXT:  .LCPI30_0:
; ARMV8M-NEXT:    .long 0 @ double -0
; ARMV8M-NEXT:    .long 2147483648
; ARMV8M-NEXT:  .LCPI30_1:
; ARMV8M-NEXT:    .long 0 @ double 0
; ARMV8M-NEXT:    .long 0
  %a = call nnan <2 x double> @llvm.maxnum.v2f64(<2 x double> %x, <2 x double><double 0.0, double -0.0>)
  ret <2 x double> %a
}

define <2 x double> @fmaxnumv264_minus_zero_intrinsic(<2 x double> %x) {
; ARMV7-LABEL: fmaxnumv264_minus_zero_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    vldr d16, .LCPI31_0
; ARMV7-NEXT:    vmov d17, r0, r1
; ARMV7-NEXT:    vmov d18, r2, r3
; ARMV7-NEXT:    vcmp.f64 d17, d16
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vcmp.f64 d18, d16
; ARMV7-NEXT:    vmov.f64 d19, d16
; ARMV7-NEXT:    vmovgt.f64 d19, d17
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmov r0, r1, d19
; ARMV7-NEXT:    vmovgt.f64 d16, d18
; ARMV7-NEXT:    vmov r2, r3, d16
; ARMV7-NEXT:    bx lr
; ARMV7-NEXT:    .p2align 3
; ARMV7-NEXT:  @ %bb.1:
; ARMV7-NEXT:  .LCPI31_0:
; ARMV7-NEXT:    .long 0 @ double -0
; ARMV7-NEXT:    .long 2147483648
;
; ARMV8-LABEL: fmaxnumv264_minus_zero_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    vldr d16, .LCPI31_0
; ARMV8-NEXT:    vmov d18, r0, r1
; ARMV8-NEXT:    vmov d17, r2, r3
; ARMV8-NEXT:    vmaxnm.f64 d18, d18, d16
; ARMV8-NEXT:    vmaxnm.f64 d16, d17, d16
; ARMV8-NEXT:    vmov r0, r1, d18
; ARMV8-NEXT:    vmov r2, r3, d16
; ARMV8-NEXT:    bx lr
; ARMV8-NEXT:    .p2align 3
; ARMV8-NEXT:  @ %bb.1:
; ARMV8-NEXT:  .LCPI31_0:
; ARMV8-NEXT:    .long 0 @ double -0
; ARMV8-NEXT:    .long 2147483648
;
; ARMV8M-LABEL: fmaxnumv264_minus_zero_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    vldr d0, .LCPI31_0
; ARMV8M-NEXT:    vmov d1, r0, r1
; ARMV8M-NEXT:    vmov d2, r2, r3
; ARMV8M-NEXT:    vcmp.f64 d1, d0
; ARMV8M-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV8M-NEXT:    vcmp.f64 d2, d0
; ARMV8M-NEXT:    vselgt.f64 d1, d1, d0
; ARMV8M-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV8M-NEXT:    vmov r0, r1, d1
; ARMV8M-NEXT:    vselgt.f64 d0, d2, d0
; ARMV8M-NEXT:    vmov r2, r3, d0
; ARMV8M-NEXT:    bx lr
; ARMV8M-NEXT:    .p2align 3
; ARMV8M-NEXT:  @ %bb.1:
; ARMV8M-NEXT:  .LCPI31_0:
; ARMV8M-NEXT:    .long 0 @ double -0
; ARMV8M-NEXT:    .long 2147483648
  %a = call nnan <2 x double> @llvm.maxnum.v2f64(<2 x double> %x, <2 x double><double -0.0, double -0.0>)
  ret <2 x double> %a
}

define <2 x double> @fmaxnumv264_non_zero_intrinsic(<2 x double> %x) {
; ARMV7-LABEL: fmaxnumv264_non_zero_intrinsic:
; ARMV7:       @ %bb.0:
; ARMV7-NEXT:    vmov.f64 d16, #1.000000e+00
; ARMV7-NEXT:    vmov d17, r0, r1
; ARMV7-NEXT:    vcmp.f64 d17, d16
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmov d18, r2, r3
; ARMV7-NEXT:    vcmp.f64 d18, d16
; ARMV7-NEXT:    vmov.f64 d19, d16
; ARMV7-NEXT:    vmovgt.f64 d19, d17
; ARMV7-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV7-NEXT:    vmov r0, r1, d19
; ARMV7-NEXT:    vmovgt.f64 d16, d18
; ARMV7-NEXT:    vmov r2, r3, d16
; ARMV7-NEXT:    bx lr
;
; ARMV8-LABEL: fmaxnumv264_non_zero_intrinsic:
; ARMV8:       @ %bb.0:
; ARMV8-NEXT:    vmov.f64 d16, #1.000000e+00
; ARMV8-NEXT:    vmov d18, r0, r1
; ARMV8-NEXT:    vmov d17, r2, r3
; ARMV8-NEXT:    vmaxnm.f64 d18, d18, d16
; ARMV8-NEXT:    vmaxnm.f64 d16, d17, d16
; ARMV8-NEXT:    vmov r0, r1, d18
; ARMV8-NEXT:    vmov r2, r3, d16
; ARMV8-NEXT:    bx lr
;
; ARMV8M-LABEL: fmaxnumv264_non_zero_intrinsic:
; ARMV8M:       @ %bb.0:
; ARMV8M-NEXT:    vmov.f64 d0, #1.000000e+00
; ARMV8M-NEXT:    vmov d1, r0, r1
; ARMV8M-NEXT:    vcmp.f64 d1, d0
; ARMV8M-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV8M-NEXT:    vmov d2, r2, r3
; ARMV8M-NEXT:    vcmp.f64 d2, d0
; ARMV8M-NEXT:    vselgt.f64 d1, d1, d0
; ARMV8M-NEXT:    vmrs APSR_nzcv, fpscr
; ARMV8M-NEXT:    vmov r0, r1, d1
; ARMV8M-NEXT:    vselgt.f64 d0, d2, d0
; ARMV8M-NEXT:    vmov r2, r3, d0
; ARMV8M-NEXT:    bx lr
  %a = call nnan <2 x double> @llvm.maxnum.v2f64(<2 x double> %x, <2 x double><double 1.0, double 1.0>)
  ret <2 x double> %a
}

define void @pr65820(ptr %y, <4 x float> %splat) {
; ARMV7-LABEL: pr65820:
; ARMV7:       @ %bb.0: @ %entry
; ARMV7-NEXT:    vmov d16, r2, r3
; ARMV7-NEXT:    vdup.32 q8, d16[0]
; ARMV7-NEXT:    vcgt.f32 q9, q8, #0
; ARMV7-NEXT:    vand q8, q9, q8
; ARMV7-NEXT:    vst1.32 {d16, d17}, [r0]
; ARMV7-NEXT:    bx lr
;
; ARMV8-LABEL: pr65820:
; ARMV8:       @ %bb.0: @ %entry
; ARMV8-NEXT:    vmov d16, r2, r3
; ARMV8-NEXT:    vmov.i32 q9, #0x0
; ARMV8-NEXT:    vdup.32 q8, d16[0]
; ARMV8-NEXT:    vmaxnm.f32 q8, q8, q9
; ARMV8-NEXT:    vst1.32 {d16, d17}, [r0]
; ARMV8-NEXT:    bx lr
;
; ARMV8M-LABEL: pr65820:
; ARMV8M:       @ %bb.0: @ %entry
; ARMV8M-NEXT:    vmov d0, r2, r3
; ARMV8M-NEXT:    vmov r1, s0
; ARMV8M-NEXT:    vmov.i32 q0, #0x0
; ARMV8M-NEXT:    vdup.32 q1, r1
; ARMV8M-NEXT:    vmaxnm.f32 q0, q1, q0
; ARMV8M-NEXT:    vstrw.32 q0, [r0]
; ARMV8M-NEXT:    bx lr
entry:
  %broadcast.splat = shufflevector <4 x float> %splat, <4 x float> zeroinitializer, <4 x i32> zeroinitializer
  %0 = fcmp ogt <4 x float> %broadcast.splat, zeroinitializer
  %1 = select <4 x i1> %0, <4 x float> %broadcast.splat, <4 x float> zeroinitializer
  store <4 x float> %1, ptr %y, align 4
  ret void
}
