---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, symboles, caractères, tilde, accents, 
              lettres accentuées, caractères accentués
---

# Comment obtenir un tilde ?

Le symbole du [tilde](wpfr:Tilde), `~`, est pour LaTeX un caractère interprété 
comme une [espace insécable](/3_composition/texte/mots/inserer_une_espace_insecable). 
Plusieurs solutions sont ainsi possibles pour afficher dans un texte ce `~` :

- en mode texte : les commandes `\textasciitilde` (recommandé), `\string~` ou `\~{}` ;
- en mode mathématique : la commande `\sim`.

S'il s'agit d'écrire l'adresse d'une page web (une URL), 
mieux vaut alors utiliser la commande `\url` de l'extension <ctanpkg:url>. 
Voir la question "[](/3_composition/texte/mots/mettre_en_forme_des_url_et_des_adresses_electroniques)".

Pour obtenir le tilde comme accentuation d'une `⟨lettre⟩`, il faut utiliser :

- en mode texte : `\~{⟨lettre⟩}` ;
- en mode mathématique : `\tilde{⟨lettre⟩}`.

Voici un exemple de ces commandes :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Quelques variations sur le même thème : \textasciitilde, \string~, 
\~{}, $\sim$.

Et quelques accents : \~{a} et $\tilde{a}$.
\end{document}
```