---
myst:
  html_meta:
    keywords: LaTeX, composition, flottants, positionnement, gauche, droite
---

# Comment placer des figures face à face en recto-verso ?

## Avec l'extension <ctanpkg:dpfloat>

L'extension <ctanpkg:dpfloat> permet de s'assurer qu'un flottant sera placé 
sur une page "de gauche", c'est-à-dire une page de numéro pair, 
ou sur une page "de droite".

L'exemple fournit dans la [documentation](texdoc:dpfloat) de l'extension 
est le suivant :

```
\documentclass[french, twoside]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{mwe}            % Pour inclure des images factices
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{dpfloat}

\begin{document}
Voici notre exemple (dans les pages suivantes).

\begin{figure}[p]% sera sur une page de gauche
  \begin{leftfullpage}
    \centering
    \includegraphics[width=.5\linewidth]{example-image-a}
    \caption{Notre figure sur la page de gauche}
  \end{leftfullpage}
\end{figure}
  
\begin{figure}[p]% sera sur une page de droite
  \begin{fullpage}
    \centering
    \includegraphics[width=.5\linewidth]{example-image-b}
  \caption{Notre figure sur la page de droite}
  \end{fullpage}

\end{figure}
\end{document}
```

L'environnement `leftfullpage` indiquera à LaTeX que, s'il se trouve 
sur une page impaire, il doit repousser le flottant à la page suivante.