/* Preferences.c generated by valac 0.36.6, the Vala compiler
 * generated from Preferences.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2017 Jens Georg <mail@jensge.org>
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gobject/gvaluecollector.h>


#define TYPE_PREFERENCES_DIALOG (preferences_dialog_get_type ())
#define PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialog))
#define PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))
#define IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES_DIALOG))
#define IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES_DIALOG))
#define PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))

typedef struct _PreferencesDialog PreferencesDialog;
typedef struct _PreferencesDialogClass PreferencesDialogClass;
typedef struct _PreferencesDialogPrivate PreferencesDialogPrivate;

#define TYPE_SORTED_LIST (sorted_list_get_type ())
#define SORTED_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SORTED_LIST, SortedList))
#define SORTED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SORTED_LIST, SortedListClass))
#define IS_SORTED_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SORTED_LIST))
#define IS_SORTED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SORTED_LIST))
#define SORTED_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SORTED_LIST, SortedListClass))

typedef struct _SortedList SortedList;
typedef struct _SortedListClass SortedListClass;

#define PREFERENCES_DIALOG_TYPE_PATH_FORMAT (preferences_dialog_path_format_get_type ())
#define PREFERENCES_DIALOG_PATH_FORMAT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PREFERENCES_DIALOG_TYPE_PATH_FORMAT, PreferencesDialogPathFormat))
#define PREFERENCES_DIALOG_PATH_FORMAT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PREFERENCES_DIALOG_TYPE_PATH_FORMAT, PreferencesDialogPathFormatClass))
#define PREFERENCES_DIALOG_IS_PATH_FORMAT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PREFERENCES_DIALOG_TYPE_PATH_FORMAT))
#define PREFERENCES_DIALOG_IS_PATH_FORMAT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PREFERENCES_DIALOG_TYPE_PATH_FORMAT))
#define PREFERENCES_DIALOG_PATH_FORMAT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PREFERENCES_DIALOG_TYPE_PATH_FORMAT, PreferencesDialogPathFormatClass))

typedef struct _PreferencesDialogPathFormat PreferencesDialogPathFormat;
typedef struct _PreferencesDialogPathFormatClass PreferencesDialogPathFormatClass;

#define PLUGINS_TYPE_MANIFEST_WIDGET_MEDIATOR (plugins_manifest_widget_mediator_get_type ())
#define PLUGINS_MANIFEST_WIDGET_MEDIATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PLUGINS_TYPE_MANIFEST_WIDGET_MEDIATOR, PluginsManifestWidgetMediator))
#define PLUGINS_MANIFEST_WIDGET_MEDIATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PLUGINS_TYPE_MANIFEST_WIDGET_MEDIATOR, PluginsManifestWidgetMediatorClass))
#define PLUGINS_IS_MANIFEST_WIDGET_MEDIATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PLUGINS_TYPE_MANIFEST_WIDGET_MEDIATOR))
#define PLUGINS_IS_MANIFEST_WIDGET_MEDIATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PLUGINS_TYPE_MANIFEST_WIDGET_MEDIATOR))
#define PLUGINS_MANIFEST_WIDGET_MEDIATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PLUGINS_TYPE_MANIFEST_WIDGET_MEDIATOR, PluginsManifestWidgetMediatorClass))

typedef struct _PluginsManifestWidgetMediator PluginsManifestWidgetMediator;
typedef struct _PluginsManifestWidgetMediatorClass PluginsManifestWidgetMediatorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;

#define TYPE_RAW_DEVELOPER (raw_developer_get_type ())

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PreferencesDialogPathFormatPrivate PreferencesDialogPathFormatPrivate;
#define _preferences_dialog_path_format_unref0(var) ((var == NULL) ? NULL : (var = (preferences_dialog_path_format_unref (var), NULL)))
typedef struct _PreferencesDialogParamSpecPathFormat PreferencesDialogParamSpecPathFormat;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PreferencesDialog {
	GtkDialog parent_instance;
	PreferencesDialogPrivate * priv;
};

struct _PreferencesDialogClass {
	GtkDialogClass parent_class;
};

struct _PreferencesDialogPrivate {
	GtkAdjustment* bg_color_adjustment;
	GtkScale* bg_color_slider;
	GtkComboBox* photo_editor_combo;
	GtkComboBox* raw_editor_combo;
	SortedList* external_raw_apps;
	SortedList* external_photo_apps;
	GtkFileChooserButton* library_dir_button;
	GtkComboBoxText* dir_pattern_combo;
	GtkEntry* dir_pattern_entry;
	GtkLabel* dir_pattern_example;
	gboolean allow_closing;
	gchar* lib_dir;
	GeeArrayList* path_formats;
	GDateTime* example_date;
	GtkCheckButton* lowercase;
	PluginsManifestWidgetMediator* plugins_mediator;
	GtkComboBoxText* default_raw_developer_combo;
	GtkCheckButton* autoimport;
	GtkCheckButton* write_metadata;
	GtkLabel* pattern_help;
	GtkNotebook* preferences_notebook;
	GtkRadioButton* transparent_checker_radio;
	GtkRadioButton* transparent_solid_radio;
	GtkColorButton* transparent_solid_color;
	GtkRadioButton* transparent_none_radio;
};

typedef enum  {
	RAW_DEVELOPER_SHOTWELL = 0,
	RAW_DEVELOPER_CAMERA,
	RAW_DEVELOPER_EMBEDDED
} RawDeveloper;

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

struct _PreferencesDialogPathFormat {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PreferencesDialogPathFormatPrivate * priv;
	gchar* name;
	gchar* pattern;
};

struct _PreferencesDialogPathFormatClass {
	GTypeClass parent_class;
	void (*finalize) (PreferencesDialogPathFormat *self);
};

struct _PreferencesDialogParamSpecPathFormat {
	GParamSpec parent_instance;
};


static gpointer preferences_dialog_parent_class = NULL;
static PreferencesDialog* preferences_dialog_preferences_dialog;
static PreferencesDialog* preferences_dialog_preferences_dialog = NULL;
static gpointer preferences_dialog_path_format_parent_class = NULL;

GType preferences_dialog_get_type (void) G_GNUC_CONST;
GType sorted_list_get_type (void) G_GNUC_CONST;
static gpointer preferences_dialog_path_format_ref (gpointer instance);
static void preferences_dialog_path_format_unref (gpointer instance);
static GParamSpec* preferences_dialog_param_spec_path_format (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void preferences_dialog_value_set_path_format (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void preferences_dialog_value_take_path_format (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer preferences_dialog_value_get_path_format (const GValue* value) G_GNUC_UNUSED;
static GType preferences_dialog_path_format_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType plugins_manifest_widget_mediator_get_type (void) G_GNUC_CONST;
#define PREFERENCES_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PREFERENCES_DIALOG, PreferencesDialogPrivate))
enum  {
	PREFERENCES_DIALOG_DUMMY_PROPERTY
};
PluginsManifestWidgetMediator* plugins_manifest_widget_mediator_new (void);
PluginsManifestWidgetMediator* plugins_manifest_widget_mediator_construct (GType object_type);
static PreferencesDialog* preferences_dialog_new (void);
static PreferencesDialog* preferences_dialog_construct (GType object_type);
gint resources_use_header_bar (void);
GType page_window_get_type (void) G_GNUC_CONST;
GType app_window_get_type (void) G_GNUC_CONST;
AppWindow* app_window_get_instance (void);
static gboolean preferences_dialog_on_delete (PreferencesDialog* self);
static gboolean _preferences_dialog_on_delete_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void preferences_dialog_on_close (PreferencesDialog* self);
static void _preferences_dialog_on_close_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
GType configuration_facade_get_type (void) G_GNUC_CONST;
GType config_facade_get_type (void) G_GNUC_CONST;
ConfigFacade* config_facade_get_instance (void);
void config_facade_get_bg_color (ConfigFacade* self, GdkRGBA* result);
static void preferences_dialog_on_value_changed (PreferencesDialog* self);
static void _preferences_dialog_on_value_changed_gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self);
static gboolean preferences_dialog_on_bg_color_reset (PreferencesDialog* self, GdkEventButton* event);
static gboolean _preferences_dialog_on_bg_color_reset_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void preferences_dialog_on_radio_changed (PreferencesDialog* self);
static void _preferences_dialog_on_radio_changed_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
gchar* configuration_facade_get_transparent_background_color (ConfigurationFacade* self);
static void preferences_dialog_on_color_changed (PreferencesDialog* self);
static void _preferences_dialog_on_color_changed_gtk_color_button_color_set (GtkColorButton* _sender, gpointer self);
gchar* configuration_facade_get_transparent_background_type (ConfigurationFacade* self);
gchar* resources_get_help_path (void);
#define RESOURCES_DIR_PATTERN_URI_SYSWIDE "help:shotwell/other-files"
static gboolean preferences_dialog_on_local_pattern_help (PreferencesDialog* self, const gchar* ignore);
static gboolean _preferences_dialog_on_local_pattern_help_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self);
static void preferences_dialog_add_to_dir_formats (PreferencesDialog* self, const gchar* name, const gchar* pattern);
static void preferences_dialog_on_dir_pattern_combo_changed (PreferencesDialog* self);
static void _preferences_dialog_on_dir_pattern_combo_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void preferences_dialog_on_dir_pattern_entry_changed (PreferencesDialog* self);
static void _preferences_dialog_on_dir_pattern_entry_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void preferences_dialog_on_lowercase_toggled (PreferencesDialog* self);
static void _preferences_dialog_on_lowercase_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
void preferences_dialog_populate_preference_options (PreferencesDialog* self);
static void preferences_dialog_on_photo_editor_changed (PreferencesDialog* self);
static void _preferences_dialog_on_photo_editor_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void preferences_dialog_on_raw_editor_changed (PreferencesDialog* self);
static void _preferences_dialog_on_raw_editor_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
gboolean configuration_facade_get_auto_import_from_library (ConfigurationFacade* self);
gboolean configuration_facade_get_commit_metadata_to_masters (ConfigurationFacade* self);
GType raw_developer_get_type (void) G_GNUC_CONST;
gchar* raw_developer_get_label (RawDeveloper self);
static void preferences_dialog_set_raw_developer_combo (PreferencesDialog* self, RawDeveloper d);
RawDeveloper configuration_facade_get_default_raw_developer (ConfigurationFacade* self);
static void preferences_dialog_on_default_raw_developer_changed (PreferencesDialog* self);
static void _preferences_dialog_on_default_raw_developer_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void preferences_dialog_populate_app_combo_box (PreferencesDialog* self, GtkComboBox* combo_box, gchar** mime_types, int mime_types_length1, const gchar* current_app_executable, SortedList* * external_apps);
gchar** photo_file_format_get_editable_mime_types (int* result_length1);
gchar* configuration_facade_get_external_photo_app (ConfigurationFacade* self);
GType photo_file_format_get_type (void) G_GNUC_CONST;
gchar** photo_file_format_get_mime_types (PhotoFileFormat self, int* result_length1);
gchar* configuration_facade_get_external_raw_app (ConfigurationFacade* self);
static void preferences_dialog_setup_dir_pattern (PreferencesDialog* self, GtkComboBox* combo_box, GtkEntry* entry);
gboolean configuration_facade_get_use_lowercase_filenames (ConfigurationFacade* self);
void configuration_facade_set_transparent_background_type (ConfigurationFacade* self, const gchar* type);
void configuration_facade_set_transparent_background_color (ConfigurationFacade* self, const gchar* color_name);
void resources_launch_help (GdkScreen* screen, const gchar* anchor, GError** error);
SortedList* desktop_integration_get_apps_for_mime_types (gchar** mime_types, int mime_types_length1);
GdkPixbuf* scale_pixbuf (GdkPixbuf* pixbuf, gint scale, GdkInterpType interp, gboolean scale_up);
#define RESOURCES_DEFAULT_ICON_SCALE 24
gint sorted_list_index_of (SortedList* self, gconstpointer search);
gchar* configuration_facade_get_directory_pattern (ConfigurationFacade* self);
gchar* configuration_facade_get_directory_pattern_custom (ConfigurationFacade* self);
gboolean is_string_empty (const gchar* s);
void preferences_dialog_show_preferences (void);
GFile* app_dirs_get_import_dir (void);
static void preferences_dialog_commit_on_close (PreferencesDialog* self);
void config_facade_commit_bg_color (ConfigFacade* self);
void configuration_facade_set_auto_import_from_library (ConfigurationFacade* self, gboolean auto_import);
void configuration_facade_set_commit_metadata_to_masters (ConfigurationFacade* self, gboolean commit_metadata);
void app_dirs_set_import_dir (const gchar* path);
void configuration_facade_set_directory_pattern_custom (ConfigurationFacade* self, const gchar* s);
void configuration_facade_set_directory_pattern (ConfigurationFacade* self, const gchar* s);
static gboolean preferences_dialog_get_allow_closing (PreferencesDialog* self);
static void preferences_dialog_set_background_color (PreferencesDialog* self, gdouble bg_color_value);
gboolean has_only_key_modifier (GdkModifierType field, GdkModifierType mask);
void parse_color (const gchar* spec, GdkRGBA* result);
#define CONFIG_FACADE_DEFAULT_BG_COLOR "#444"
static void preferences_dialog_set_allow_closing (PreferencesDialog* self, gboolean allow);
void config_facade_set_bg_color (ConfigFacade* self, GdkRGBA* color);
static void preferences_dialog_to_grayscale (PreferencesDialog* self, gdouble color_value, GdkRGBA* result);
gpointer sorted_list_get_at (SortedList* self, gint index);
void configuration_facade_set_external_photo_app (ConfigurationFacade* self, const gchar* external_photo_app);
gchar* desktop_integration_get_app_open_command (GAppInfo* app_info);
void configuration_facade_set_external_raw_app (ConfigurationFacade* self, const gchar* external_raw_app);
static RawDeveloper preferences_dialog_raw_developer_from_combo (PreferencesDialog* self);
void configuration_facade_set_default_raw_developer (ConfigurationFacade* self, RawDeveloper d);
static void preferences_dialog_on_current_folder_changed (PreferencesDialog* self);
static gboolean preferences_dialog_real_map_event (GtkWidget* base, GdkEventAny* event);
static void _preferences_dialog_on_current_folder_changed_gtk_file_chooser_current_folder_changed (GtkFileChooser* _sender, gpointer self);
static PreferencesDialogPathFormat* preferences_dialog_path_format_new (const gchar* name, const gchar* pattern);
static PreferencesDialogPathFormat* preferences_dialog_path_format_construct (GType object_type, const gchar* name, const gchar* pattern);
void configuration_facade_set_use_lowercase_filenames (ConfigurationFacade* self, gboolean b);
enum  {
	PREFERENCES_DIALOG_PATH_FORMAT_DUMMY_PROPERTY
};
static void preferences_dialog_path_format_finalize (PreferencesDialogPathFormat * obj);
static void preferences_dialog_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gboolean _preferences_dialog_on_delete_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = preferences_dialog_on_delete ((PreferencesDialog*) self);
#line 72 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return result;
#line 324 "Preferences.c"
}


static void _preferences_dialog_on_close_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 73 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_on_close ((PreferencesDialog*) self);
#line 331 "Preferences.c"
}


static void _preferences_dialog_on_value_changed_gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self) {
#line 77 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_on_value_changed ((PreferencesDialog*) self);
#line 338 "Preferences.c"
}


static gboolean _preferences_dialog_on_bg_color_reset_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = preferences_dialog_on_bg_color_reset ((PreferencesDialog*) self, event);
#line 79 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return result;
#line 347 "Preferences.c"
}


static void _preferences_dialog_on_radio_changed_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
#line 81 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_on_radio_changed ((PreferencesDialog*) self);
#line 354 "Preferences.c"
}


static void _preferences_dialog_on_color_changed_gtk_color_button_color_set (GtkColorButton* _sender, gpointer self) {
#line 92 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_on_color_changed ((PreferencesDialog*) self);
#line 361 "Preferences.c"
}


static gboolean _preferences_dialog_on_local_pattern_help_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self) {
	gboolean result;
	result = preferences_dialog_on_local_pattern_help ((PreferencesDialog*) self, uri);
#line 120 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return result;
#line 370 "Preferences.c"
}


static void _preferences_dialog_on_dir_pattern_combo_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 131 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_on_dir_pattern_combo_changed ((PreferencesDialog*) self);
#line 377 "Preferences.c"
}


static void _preferences_dialog_on_dir_pattern_entry_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
#line 132 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_on_dir_pattern_entry_changed ((PreferencesDialog*) self);
#line 384 "Preferences.c"
}


static void _preferences_dialog_on_lowercase_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
#line 134 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_on_lowercase_toggled ((PreferencesDialog*) self);
#line 391 "Preferences.c"
}


static void _preferences_dialog_on_photo_editor_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 140 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_on_photo_editor_changed ((PreferencesDialog*) self);
#line 398 "Preferences.c"
}


static void _preferences_dialog_on_raw_editor_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 141 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_on_raw_editor_changed ((PreferencesDialog*) self);
#line 405 "Preferences.c"
}


static void _preferences_dialog_on_default_raw_developer_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 150 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_on_default_raw_developer_changed ((PreferencesDialog*) self);
#line 412 "Preferences.c"
}


static PreferencesDialog* preferences_dialog_construct (GType object_type) {
	PreferencesDialog * self = NULL;
	gint _tmp0_;
	AppWindow* _tmp1_;
	AppWindow* _tmp2_;
	GdkWindow* _tmp3_;
	AppWindow* _tmp4_;
	AppWindow* _tmp5_;
	GtkAdjustment* _tmp6_;
	GtkAdjustment* _tmp7_;
	gdouble _tmp8_;
	ConfigFacade* _tmp9_;
	ConfigFacade* _tmp10_;
	GdkRGBA _tmp11_ = {0};
	gdouble _tmp12_;
	GtkAdjustment* _tmp13_;
	GtkScale* _tmp14_;
	GtkRadioButton* _tmp15_;
	GtkRadioButton* _tmp16_;
	GtkRadioButton* _tmp17_;
	GtkRadioButton* _tmp18_;
	GtkColorButton* _tmp19_;
	GdkRGBA color = {0};
	ConfigFacade* _tmp20_;
	ConfigFacade* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GtkColorButton* _tmp24_;
	GdkRGBA _tmp25_;
	GtkColorButton* _tmp26_;
	ConfigFacade* _tmp27_;
	ConfigFacade* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	GQuark _tmp33_ = 0U;
#line 94 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	static GQuark _tmp32_label0 = 0;
#line 94 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	static GQuark _tmp32_label1 = 0;
#line 456 "Preferences.c"
	gchar* help_path = NULL;
	gchar* _tmp37_;
	const gchar* _tmp38_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	GtkComboBoxText* _tmp56_;
	GtkEntry* _tmp57_;
	GtkCheckButton* _tmp58_;
	GtkNotebook* _tmp59_;
	GtkWidget* _tmp60_;
	PluginsManifestWidgetMediator* _tmp61_;
	GtkComboBox* _tmp62_;
	GtkComboBox* _tmp63_;
	GtkCheckButton* _tmp64_;
	ConfigFacade* _tmp65_;
	ConfigFacade* _tmp66_;
	gboolean _tmp67_;
	GtkCheckButton* _tmp68_;
	ConfigFacade* _tmp69_;
	ConfigFacade* _tmp70_;
	gboolean _tmp71_;
	GtkComboBoxText* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	GtkComboBoxText* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	ConfigFacade* _tmp78_;
	ConfigFacade* _tmp79_;
	RawDeveloper _tmp80_;
	GtkComboBoxText* _tmp81_;
#line 68 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = resources_use_header_bar ();
#line 68 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self = (PreferencesDialog*) g_object_new (object_type, "use-header-bar", _tmp0_, NULL);
#line 70 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = app_window_get_instance ();
#line 70 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = _tmp1_;
#line 70 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3_ = gtk_widget_get_parent_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget));
#line 70 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_set_parent_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp3_);
#line 70 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp2_);
#line 71 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp4_ = app_window_get_instance ();
#line 71 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp5_ = _tmp4_;
#line 71 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_window_get_type (), GtkWindow));
#line 71 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp5_);
#line 72 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "delete-event", (GCallback) _preferences_dialog_on_delete_gtk_widget_delete_event, self, 0);
#line 73 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), "response", (GCallback) _preferences_dialog_on_close_gtk_dialog_response, self, 0);
#line 75 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp6_ = self->priv->bg_color_adjustment;
#line 75 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp7_ = self->priv->bg_color_adjustment;
#line 75 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp8_ = gtk_adjustment_get_upper (_tmp7_);
#line 75 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp9_ = config_facade_get_instance ();
#line 75 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp10_ = _tmp9_;
#line 75 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	config_facade_get_bg_color (_tmp10_, &_tmp11_);
#line 75 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp12_ = _tmp11_.red;
#line 75 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_adjustment_set_value (_tmp6_, _tmp8_ - (_tmp12_ * 65535.0));
#line 75 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp10_);
#line 77 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp13_ = self->priv->bg_color_adjustment;
#line 77 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_connect_object (_tmp13_, "value-changed", (GCallback) _preferences_dialog_on_value_changed_gtk_adjustment_value_changed, self, 0);
#line 79 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp14_ = self->priv->bg_color_slider;
#line 79 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget), "button-press-event", (GCallback) _preferences_dialog_on_bg_color_reset_gtk_widget_button_press_event, self, 0);
#line 81 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp15_ = self->priv->transparent_checker_radio;
#line 81 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_toggle_button_get_type (), GtkToggleButton), "toggled", (GCallback) _preferences_dialog_on_radio_changed_gtk_toggle_button_toggled, self, 0);
#line 82 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp16_ = self->priv->transparent_solid_radio;
#line 82 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_toggle_button_get_type (), GtkToggleButton), "toggled", (GCallback) _preferences_dialog_on_radio_changed_gtk_toggle_button_toggled, self, 0);
#line 83 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp17_ = self->priv->transparent_none_radio;
#line 83 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_toggle_button_get_type (), GtkToggleButton), "toggled", (GCallback) _preferences_dialog_on_radio_changed_gtk_toggle_button_toggled, self, 0);
#line 85 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp18_ = self->priv->transparent_solid_radio;
#line 85 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp19_ = self->priv->transparent_solid_color;
#line 85 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_object_bind_property_with_closures (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, G_TYPE_OBJECT, GObject), "active", G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, G_TYPE_OBJECT, GObject), "sensitive", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 89 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	memset (&color, 0, sizeof (GdkRGBA));
#line 90 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp20_ = config_facade_get_instance ();
#line 90 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp21_ = _tmp20_;
#line 90 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp22_ = configuration_facade_get_transparent_background_color (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 90 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp23_ = _tmp22_;
#line 90 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gdk_rgba_parse (&color, _tmp23_);
#line 90 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (_tmp23_);
#line 90 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp21_);
#line 91 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp24_ = self->priv->transparent_solid_color;
#line 91 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp25_ = color;
#line 91 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_color_chooser_set_rgba (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, GTK_TYPE_COLOR_CHOOSER) ? ((GtkColorChooser*) _tmp24_) : NULL, &_tmp25_);
#line 92 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp26_ = self->priv->transparent_solid_color;
#line 92 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_connect_object (_tmp26_, "color-set", (GCallback) _preferences_dialog_on_color_changed_gtk_color_button_color_set, self, 0);
#line 94 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp27_ = config_facade_get_instance ();
#line 94 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp28_ = _tmp27_;
#line 94 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp29_ = configuration_facade_get_transparent_background_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 94 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp30_ = _tmp29_;
#line 94 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp28_);
#line 94 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp31_ = _tmp30_;
#line 94 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp33_ = (NULL == _tmp31_) ? 0 : g_quark_from_string (_tmp31_);
#line 94 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_free (_tmp31_);
#line 94 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (_tmp33_ == ((0 != _tmp32_label0) ? _tmp32_label0 : (_tmp32_label0 = g_quark_from_static_string ("checkered")))) {
#line 94 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		switch (0) {
#line 608 "Preferences.c"
			default:
			{
				GtkRadioButton* _tmp34_;
#line 96 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp34_ = self->priv->transparent_checker_radio;
#line 96 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
#line 97 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				break;
#line 618 "Preferences.c"
			}
		}
	} else if (_tmp33_ == ((0 != _tmp32_label1) ? _tmp32_label1 : (_tmp32_label1 = g_quark_from_static_string ("solid")))) {
#line 94 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		switch (0) {
#line 624 "Preferences.c"
			default:
			{
				GtkRadioButton* _tmp35_;
#line 99 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp35_ = self->priv->transparent_solid_radio;
#line 99 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
#line 100 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				break;
#line 634 "Preferences.c"
			}
		}
	} else {
#line 94 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		switch (0) {
#line 640 "Preferences.c"
			default:
			{
				GtkRadioButton* _tmp36_;
#line 102 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp36_ = self->priv->transparent_none_radio;
#line 102 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
#line 103 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				break;
#line 650 "Preferences.c"
			}
		}
	}
#line 111 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp37_ = resources_get_help_path ();
#line 111 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	help_path = _tmp37_;
#line 113 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp38_ = help_path;
#line 113 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (_tmp38_ == NULL) {
#line 662 "Preferences.c"
		GtkLabel* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
#line 115 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp39_ = self->priv->pattern_help;
#line 115 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp40_ = g_strconcat ("<a href=\"" RESOURCES_DIR_PATTERN_URI_SYSWIDE "\">", _ ("(Help)"), NULL);
#line 115 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp41_ = _tmp40_;
#line 115 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp42_ = g_strconcat (_tmp41_, "</a>", NULL);
#line 115 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp43_ = _tmp42_;
#line 115 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_label_set_markup (_tmp39_, _tmp43_);
#line 115 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_free0 (_tmp43_);
#line 115 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_free0 (_tmp41_);
#line 684 "Preferences.c"
	} else {
		GtkLabel* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		GtkLabel* _tmp49_;
#line 119 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp44_ = self->priv->pattern_help;
#line 119 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp45_ = g_strconcat ("<a href=\"dummy:\">", _ ("(Help)"), NULL);
#line 119 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp46_ = _tmp45_;
#line 119 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp47_ = g_strconcat (_tmp46_, "</a>", NULL);
#line 119 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp48_ = _tmp47_;
#line 119 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_label_set_markup (_tmp44_, _tmp48_);
#line 119 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_free0 (_tmp48_);
#line 119 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_free0 (_tmp46_);
#line 120 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp49_ = self->priv->pattern_help;
#line 120 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		g_signal_connect_object (_tmp49_, "activate-link", (GCallback) _preferences_dialog_on_local_pattern_help_gtk_label_activate_link, self, 0);
#line 712 "Preferences.c"
	}
#line 123 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp50_ = g_strdup_printf (_ ("Year%sMonth%sDay"), G_DIR_SEPARATOR_S, G_DIR_SEPARATOR_S);
#line 123 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp51_ = _tmp50_;
#line 123 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_add_to_dir_formats (self, _tmp51_, "%Y" G_DIR_SEPARATOR_S "%m" G_DIR_SEPARATOR_S "%d");
#line 123 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (_tmp51_);
#line 125 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp52_ = g_strdup_printf (_ ("Year%sMonth"), G_DIR_SEPARATOR_S);
#line 125 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp53_ = _tmp52_;
#line 125 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_add_to_dir_formats (self, _tmp53_, "%Y" G_DIR_SEPARATOR_S "%m");
#line 125 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (_tmp53_);
#line 127 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp54_ = g_strdup_printf (_ ("Year%sMonth-Day"), G_DIR_SEPARATOR_S);
#line 127 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp55_ = _tmp54_;
#line 127 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_add_to_dir_formats (self, _tmp55_, "%Y" G_DIR_SEPARATOR_S "%m-%d");
#line 127 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (_tmp55_);
#line 129 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_add_to_dir_formats (self, _ ("Year-Month-Day"), "%Y-%m-%d");
#line 130 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_add_to_dir_formats (self, _ ("Custom"), NULL);
#line 131 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp56_ = self->priv->dir_pattern_combo;
#line 131 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, gtk_combo_box_get_type (), GtkComboBox), "changed", (GCallback) _preferences_dialog_on_dir_pattern_combo_changed_gtk_combo_box_changed, self, 0);
#line 132 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp57_ = self->priv->dir_pattern_entry;
#line 132 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, GTK_TYPE_EDITABLE, GtkEditable), "changed", (GCallback) _preferences_dialog_on_dir_pattern_entry_changed_gtk_editable_changed, self, 0);
#line 134 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp58_ = self->priv->lowercase;
#line 134 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, gtk_toggle_button_get_type (), GtkToggleButton), "toggled", (GCallback) _preferences_dialog_on_lowercase_toggled_gtk_toggle_button_toggled, self, 0);
#line 136 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp59_ = self->priv->preferences_notebook;
#line 136 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp60_ = gtk_notebook_get_nth_page (_tmp59_, 2);
#line 136 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp61_ = self->priv->plugins_mediator;
#line 136 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_container_add (G_TYPE_CHECK_INSTANCE_TYPE (_tmp60_, gtk_container_get_type ()) ? ((GtkContainer*) _tmp60_) : NULL, G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, gtk_widget_get_type (), GtkWidget));
#line 138 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_populate_preference_options (self);
#line 140 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp62_ = self->priv->photo_editor_combo;
#line 140 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_connect_object (_tmp62_, "changed", (GCallback) _preferences_dialog_on_photo_editor_changed_gtk_combo_box_changed, self, 0);
#line 141 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp63_ = self->priv->raw_editor_combo;
#line 141 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_connect_object (_tmp63_, "changed", (GCallback) _preferences_dialog_on_raw_editor_changed_gtk_combo_box_changed, self, 0);
#line 143 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp64_ = self->priv->autoimport;
#line 143 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp65_ = config_facade_get_instance ();
#line 143 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp66_ = _tmp65_;
#line 143 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp67_ = configuration_facade_get_auto_import_from_library (G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 143 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, gtk_toggle_button_get_type (), GtkToggleButton), _tmp67_);
#line 143 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp66_);
#line 145 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp68_ = self->priv->write_metadata;
#line 145 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp69_ = config_facade_get_instance ();
#line 145 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp70_ = _tmp69_;
#line 145 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp71_ = configuration_facade_get_commit_metadata_to_masters (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 145 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, gtk_toggle_button_get_type (), GtkToggleButton), _tmp71_);
#line 145 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp70_);
#line 147 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp72_ = self->priv->default_raw_developer_combo;
#line 147 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp73_ = raw_developer_get_label (RAW_DEVELOPER_CAMERA);
#line 147 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp74_ = _tmp73_;
#line 147 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_combo_box_text_append_text (_tmp72_, _tmp74_);
#line 147 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (_tmp74_);
#line 148 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp75_ = self->priv->default_raw_developer_combo;
#line 148 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp76_ = raw_developer_get_label (RAW_DEVELOPER_SHOTWELL);
#line 148 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp77_ = _tmp76_;
#line 148 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_combo_box_text_append_text (_tmp75_, _tmp77_);
#line 148 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (_tmp77_);
#line 149 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp78_ = config_facade_get_instance ();
#line 149 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp79_ = _tmp78_;
#line 149 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp80_ = configuration_facade_get_default_raw_developer (G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 149 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_set_raw_developer_combo (self, _tmp80_);
#line 149 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp79_);
#line 150 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp81_ = self->priv->default_raw_developer_combo;
#line 150 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, gtk_combo_box_get_type (), GtkComboBox), "changed", (GCallback) _preferences_dialog_on_default_raw_developer_changed_gtk_combo_box_changed, self, 0);
#line 67 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (help_path);
#line 67 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return self;
#line 834 "Preferences.c"
}


static PreferencesDialog* preferences_dialog_new (void) {
#line 67 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return preferences_dialog_construct (TYPE_PREFERENCES_DIALOG);
#line 841 "Preferences.c"
}


void preferences_dialog_populate_preference_options (PreferencesDialog* self) {
	GtkComboBox* _tmp0_;
	gint _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	ConfigFacade* _tmp4_;
	ConfigFacade* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	SortedList* _tmp8_ = NULL;
	GtkComboBox* _tmp9_;
	gint _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	ConfigFacade* _tmp13_;
	ConfigFacade* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	SortedList* _tmp17_ = NULL;
	GtkComboBoxText* _tmp18_;
	GtkEntry* _tmp19_;
	GtkCheckButton* _tmp20_;
	ConfigFacade* _tmp21_;
	ConfigFacade* _tmp22_;
	gboolean _tmp23_;
#line 153 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 154 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = self->priv->photo_editor_combo;
#line 154 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = photo_file_format_get_editable_mime_types (&_tmp1_);
#line 154 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3_ = _tmp2_;
#line 154 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3__length1 = _tmp1_;
#line 154 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp4_ = config_facade_get_instance ();
#line 154 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp5_ = _tmp4_;
#line 154 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp6_ = configuration_facade_get_external_photo_app (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 154 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp7_ = _tmp6_;
#line 154 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_populate_app_combo_box (self, _tmp0_, _tmp3_, _tmp1_, _tmp7_, &_tmp8_);
#line 154 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->external_photo_apps);
#line 154 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self->priv->external_photo_apps = _tmp8_;
#line 154 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (_tmp7_);
#line 154 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp5_);
#line 154 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
#line 157 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp9_ = self->priv->raw_editor_combo;
#line 157 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp11_ = photo_file_format_get_mime_types (PHOTO_FILE_FORMAT_RAW, &_tmp10_);
#line 157 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp12_ = _tmp11_;
#line 157 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp12__length1 = _tmp10_;
#line 157 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp13_ = config_facade_get_instance ();
#line 157 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp14_ = _tmp13_;
#line 157 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp15_ = configuration_facade_get_external_raw_app (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 157 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp16_ = _tmp15_;
#line 157 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_populate_app_combo_box (self, _tmp9_, _tmp12_, _tmp10_, _tmp16_, &_tmp17_);
#line 157 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->external_raw_apps);
#line 157 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self->priv->external_raw_apps = _tmp17_;
#line 157 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (_tmp16_);
#line 157 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp14_);
#line 157 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_free), NULL);
#line 160 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp18_ = self->priv->dir_pattern_combo;
#line 160 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp19_ = self->priv->dir_pattern_entry;
#line 160 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_setup_dir_pattern (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_combo_box_get_type (), GtkComboBox), _tmp19_);
#line 162 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp20_ = self->priv->lowercase;
#line 162 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp21_ = config_facade_get_instance ();
#line 162 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp22_ = _tmp21_;
#line 162 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp23_ = configuration_facade_get_use_lowercase_filenames (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 162 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_toggle_button_get_type (), GtkToggleButton), _tmp23_);
#line 162 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp22_);
#line 948 "Preferences.c"
}


static void preferences_dialog_on_radio_changed (PreferencesDialog* self) {
	ConfigFacade* config = NULL;
	ConfigFacade* _tmp0_;
	GtkRadioButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
#line 165 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 166 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = config_facade_get_instance ();
#line 166 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	config = _tmp0_;
#line 168 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = self->priv->transparent_checker_radio;
#line 168 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 168 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3_ = _tmp2_;
#line 168 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (_tmp3_) {
#line 972 "Preferences.c"
		ConfigFacade* _tmp4_;
#line 169 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp4_ = config;
#line 169 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		configuration_facade_set_transparent_background_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), "checkered");
#line 978 "Preferences.c"
	} else {
		GtkRadioButton* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
#line 170 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp5_ = self->priv->transparent_solid_radio;
#line 170 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp6_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 170 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp7_ = _tmp6_;
#line 170 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		if (_tmp7_) {
#line 991 "Preferences.c"
			ConfigFacade* _tmp8_;
#line 171 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp8_ = config;
#line 171 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			configuration_facade_set_transparent_background_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), "solid");
#line 997 "Preferences.c"
		} else {
			ConfigFacade* _tmp9_;
#line 173 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp9_ = config;
#line 173 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			configuration_facade_set_transparent_background_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), "none");
#line 1004 "Preferences.c"
		}
	}
#line 165 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (config);
#line 1009 "Preferences.c"
}


static void preferences_dialog_on_color_changed (PreferencesDialog* self) {
	gchar* color = NULL;
	GtkColorButton* _tmp0_;
	GdkRGBA _tmp1_ = {0};
	GdkRGBA _tmp2_;
	gchar* _tmp3_;
	ConfigFacade* _tmp4_;
	ConfigFacade* _tmp5_;
#line 177 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 178 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = self->priv->transparent_solid_color;
#line 178 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_color_chooser_get_rgba (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GTK_TYPE_COLOR_CHOOSER) ? ((GtkColorChooser*) _tmp0_) : NULL, &_tmp1_);
#line 178 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = _tmp1_;
#line 178 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3_ = gdk_rgba_to_string (&_tmp2_);
#line 178 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	color = _tmp3_;
#line 179 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp4_ = config_facade_get_instance ();
#line 179 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp5_ = _tmp4_;
#line 179 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	configuration_facade_set_transparent_background_color (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), color);
#line 179 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp5_);
#line 177 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (color);
#line 1043 "Preferences.c"
}


static gboolean preferences_dialog_on_local_pattern_help (PreferencesDialog* self, const gchar* ignore) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 184 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_val_if_fail (IS_PREFERENCES_DIALOG (self), FALSE);
#line 184 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_val_if_fail (ignore != NULL, FALSE);
#line 1054 "Preferences.c"
	{
		AppWindow* _tmp0_;
		AppWindow* _tmp1_;
		GdkScreen* _tmp2_;
#line 186 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp0_ = app_window_get_instance ();
#line 186 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp1_ = _tmp0_;
#line 186 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp2_ = gtk_window_get_screen (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow));
#line 186 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		resources_launch_help (_tmp2_, "other-files.page", &_inner_error_);
#line 186 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_object_unref0 (_tmp1_);
#line 186 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1071 "Preferences.c"
			goto __catch22_g_error;
		}
	}
	goto __finally22;
	__catch22_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
#line 185 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		e = _inner_error_;
#line 185 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_inner_error_ = NULL;
#line 188 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp3_ = e;
#line 188 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp4_ = _tmp3_->message;
#line 188 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		g_message ("Preferences.vala:188: Unable to launch help: %s", _tmp4_);
#line 185 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_error_free0 (e);
#line 1093 "Preferences.c"
	}
	__finally22:
#line 185 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1098 "Preferences.c"
		gboolean _tmp5_ = FALSE;
#line 185 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 185 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		g_clear_error (&_inner_error_);
#line 185 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		return _tmp5_;
#line 1106 "Preferences.c"
	}
#line 190 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	result = TRUE;
#line 190 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return result;
#line 1112 "Preferences.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 220 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return self ? g_object_ref (self) : NULL;
#line 1119 "Preferences.c"
}


static void preferences_dialog_populate_app_combo_box (PreferencesDialog* self, GtkComboBox* combo_box, gchar** mime_types, int mime_types_length1, const gchar* current_app_executable, SortedList* * external_apps) {
	SortedList* _vala_external_apps = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	SortedList* _tmp2_;
	SortedList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GtkCellRendererPixbuf* pixbuf_renderer = NULL;
	GtkCellRendererPixbuf* _tmp6_;
	GtkCellRendererText* text_renderer = NULL;
	GtkCellRendererText* _tmp7_;
	GtkComboBox* _tmp8_;
	GtkComboBox* _tmp9_;
	GtkCellRendererPixbuf* _tmp10_;
	GtkComboBox* _tmp11_;
	GtkCellRendererText* _tmp12_;
	GtkComboBox* _tmp13_;
	GtkCellRendererPixbuf* _tmp14_;
	GtkComboBox* _tmp15_;
	GtkCellRendererText* _tmp16_;
	GtkListStore* combo_store = NULL;
	GtkListStore* _tmp17_;
	GtkTreeIter iter = {0};
	gint current_app = 0;
	GtkComboBox* _tmp67_;
	GtkListStore* _tmp68_;
	gint _tmp69_;
	GError * _inner_error_ = NULL;
#line 193 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 193 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (GTK_IS_COMBO_BOX (combo_box));
#line 193 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (current_app_executable != NULL);
#line 196 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = mime_types;
#line 196 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0__length1 = mime_types_length1;
#line 196 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_vala_assert (_tmp0__length1 != 0, "mime_types.length != 0");
#line 197 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = mime_types;
#line 197 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1__length1 = mime_types_length1;
#line 197 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = desktop_integration_get_apps_for_mime_types (_tmp1_, _tmp1__length1);
#line 197 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_vala_external_apps);
#line 197 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_vala_external_apps = _tmp2_;
#line 199 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3_ = _vala_external_apps;
#line 199 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp4_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
#line 199 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp5_ = _tmp4_;
#line 199 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (_tmp5_ == 0) {
#line 200 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		if (external_apps) {
#line 200 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			*external_apps = _vala_external_apps;
#line 1188 "Preferences.c"
		} else {
#line 200 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_g_object_unref0 (_vala_external_apps);
#line 1192 "Preferences.c"
		}
#line 200 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		return;
#line 1196 "Preferences.c"
	}
#line 203 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp6_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
#line 203 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_object_ref_sink (_tmp6_);
#line 203 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	pixbuf_renderer = _tmp6_;
#line 204 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp7_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 204 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_object_ref_sink (_tmp7_);
#line 204 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	text_renderer = _tmp7_;
#line 205 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp8_ = combo_box;
#line 205 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_cell_layout_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GTK_TYPE_CELL_LAYOUT, GtkCellLayout));
#line 206 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp9_ = combo_box;
#line 206 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp10_ = pixbuf_renderer;
#line 206 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_cell_layout_pack_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GTK_TYPE_CELL_LAYOUT, GtkCellLayout), G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_cell_renderer_get_type (), GtkCellRenderer), FALSE);
#line 207 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp11_ = combo_box;
#line 207 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp12_ = text_renderer;
#line 207 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_cell_layout_pack_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GTK_TYPE_CELL_LAYOUT, GtkCellLayout), G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_cell_renderer_get_type (), GtkCellRenderer), FALSE);
#line 208 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp13_ = combo_box;
#line 208 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp14_ = pixbuf_renderer;
#line 208 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_cell_layout_add_attribute (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GTK_TYPE_CELL_LAYOUT, GtkCellLayout), G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_cell_renderer_get_type (), GtkCellRenderer), "pixbuf", 0);
#line 209 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp15_ = combo_box;
#line 209 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp16_ = text_renderer;
#line 209 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_cell_layout_add_attribute (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GTK_TYPE_CELL_LAYOUT, GtkCellLayout), G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_cell_renderer_get_type (), GtkCellRenderer), "text", 1);
#line 212 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp17_ = gtk_list_store_new (2, gdk_pixbuf_get_type (), G_TYPE_STRING, -1);
#line 212 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	combo_store = _tmp17_;
#line 215 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	current_app = -1;
#line 1244 "Preferences.c"
	{
		GeeIterator* _app_it = NULL;
		SortedList* _tmp18_;
		GeeIterator* _tmp19_;
#line 217 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp18_ = _vala_external_apps;
#line 217 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp19_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ITERABLE, GeeIterable));
#line 217 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_app_it = _tmp19_;
#line 217 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		while (TRUE) {
#line 1257 "Preferences.c"
			GeeIterator* _tmp20_;
			gboolean _tmp21_;
			GAppInfo* app = NULL;
			GeeIterator* _tmp22_;
			gpointer _tmp23_;
			GtkListStore* _tmp24_;
			GtkTreeIter _tmp25_ = {0};
			GIcon* app_icon = NULL;
			GAppInfo* _tmp26_;
			GIcon* _tmp27_;
			GIcon* _tmp28_;
			GtkListStore* _tmp56_;
			GtkTreeIter _tmp57_;
			GAppInfo* _tmp58_;
			const gchar* _tmp59_;
			GValue _tmp60_ = {0};
			GAppInfo* _tmp61_;
			const gchar* _tmp62_;
			const gchar* _tmp63_;
#line 217 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp20_ = _app_it;
#line 217 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp21_ = gee_iterator_next (_tmp20_);
#line 217 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			if (!_tmp21_) {
#line 217 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				break;
#line 1285 "Preferences.c"
			}
#line 217 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp22_ = _app_it;
#line 217 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp23_ = gee_iterator_get (_tmp22_);
#line 217 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			app = (GAppInfo*) _tmp23_;
#line 218 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp24_ = combo_store;
#line 218 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			gtk_list_store_append (_tmp24_, &_tmp25_);
#line 218 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			iter = _tmp25_;
#line 220 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp26_ = app;
#line 220 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp27_ = g_app_info_get_icon (_tmp26_);
#line 220 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp28_ = _g_object_ref0 (_tmp27_);
#line 220 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			app_icon = _tmp28_;
#line 1307 "Preferences.c"
			{
				GIcon* _tmp29_;
#line 222 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp29_ = app_icon;
#line 222 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, g_file_icon_get_type ())) {
#line 1314 "Preferences.c"
					GdkPixbuf* _tmp30_ = NULL;
					GIcon* _tmp31_;
					GFile* _tmp32_;
					gchar* _tmp33_;
					gchar* _tmp34_;
					GdkPixbuf* _tmp35_;
					GdkPixbuf* _tmp36_;
					GtkListStore* _tmp37_;
					GtkTreeIter _tmp38_;
					GdkPixbuf* _tmp39_;
					GValue _tmp40_ = {0};
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					_tmp31_ = app_icon;
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					_tmp32_ = g_file_icon_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, g_file_icon_get_type (), GFileIcon));
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					_tmp33_ = g_file_get_path (_tmp32_);
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					_tmp34_ = _tmp33_;
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					_tmp35_ = gdk_pixbuf_new_from_file (_tmp34_, &_inner_error_);
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					_tmp36_ = _tmp35_;
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					_g_free0 (_tmp34_);
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					_tmp30_ = _tmp36_;
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1344 "Preferences.c"
						goto __catch23_g_error;
					}
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					_tmp37_ = combo_store;
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					_tmp38_ = iter;
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					_tmp39_ = scale_pixbuf (_tmp30_, RESOURCES_DEFAULT_ICON_SCALE, GDK_INTERP_BILINEAR, FALSE);
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					g_value_init (&_tmp40_, gdk_pixbuf_get_type ());
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					g_value_take_object (&_tmp40_, _tmp39_);
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					gtk_list_store_set_value (_tmp37_, &_tmp38_, 0, &_tmp40_);
#line 223 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					G_IS_VALUE (&_tmp40_) ? (g_value_unset (&_tmp40_), NULL) : NULL;
#line 222 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					_g_object_unref0 (_tmp30_);
#line 1363 "Preferences.c"
				} else {
					GIcon* _tmp41_;
#line 226 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					_tmp41_ = app_icon;
#line 226 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, g_themed_icon_get_type ())) {
#line 1370 "Preferences.c"
						GdkPixbuf* icon_pixbuf = NULL;
						GtkIconTheme* _tmp42_;
						GIcon* _tmp43_;
						gchar** _tmp44_;
						gchar** _tmp45_;
						const gchar* _tmp46_;
						GdkPixbuf* _tmp47_;
						GtkListStore* _tmp48_;
						GtkTreeIter _tmp49_;
						GdkPixbuf* _tmp50_;
						GValue _tmp51_ = {0};
#line 227 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
						_tmp42_ = gtk_icon_theme_get_default ();
#line 227 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
						_tmp43_ = app_icon;
#line 227 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
						_tmp45_ = _tmp44_ = g_themed_icon_get_names (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, g_themed_icon_get_type (), GThemedIcon));
#line 227 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
						_tmp46_ = _tmp45_[0];
#line 227 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
						_tmp47_ = gtk_icon_theme_load_icon (_tmp42_, _tmp46_, RESOURCES_DEFAULT_ICON_SCALE, GTK_ICON_LOOKUP_FORCE_SIZE, &_inner_error_);
#line 227 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
						icon_pixbuf = _tmp47_;
#line 227 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1396 "Preferences.c"
							goto __catch23_g_error;
						}
#line 231 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
						_tmp48_ = combo_store;
#line 231 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
						_tmp49_ = iter;
#line 231 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
						_tmp50_ = icon_pixbuf;
#line 231 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
						g_value_init (&_tmp51_, gdk_pixbuf_get_type ());
#line 231 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
						g_value_set_object (&_tmp51_, _tmp50_);
#line 231 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
						gtk_list_store_set_value (_tmp48_, &_tmp49_, 0, &_tmp51_);
#line 231 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
						G_IS_VALUE (&_tmp51_) ? (g_value_unset (&_tmp51_), NULL) : NULL;
#line 226 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
						_g_object_unref0 (icon_pixbuf);
#line 1415 "Preferences.c"
					}
				}
			}
			goto __finally23;
			__catch23_g_error:
			{
				GError* _error_ = NULL;
				GError* _tmp52_;
				const gchar* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
#line 221 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_error_ = _inner_error_;
#line 221 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_inner_error_ = NULL;
#line 234 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp52_ = _error_;
#line 234 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp53_ = _tmp52_->message;
#line 234 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp54_ = g_strconcat ("Error loading icon pixbuf: ", _tmp53_, NULL);
#line 234 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp55_ = _tmp54_;
#line 234 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				g_warning ("Preferences.vala:234: %s", _tmp55_);
#line 234 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_g_free0 (_tmp55_);
#line 221 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_g_error_free0 (_error_);
#line 1445 "Preferences.c"
			}
			__finally23:
#line 221 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 221 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_g_object_unref0 (app_icon);
#line 221 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_g_object_unref0 (app);
#line 221 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_g_object_unref0 (_app_it);
#line 221 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_g_object_unref0 (combo_store);
#line 221 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_g_object_unref0 (text_renderer);
#line 221 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_g_object_unref0 (pixbuf_renderer);
#line 221 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 221 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				g_clear_error (&_inner_error_);
#line 221 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				return;
#line 1468 "Preferences.c"
			}
#line 237 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp56_ = combo_store;
#line 237 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp57_ = iter;
#line 237 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp58_ = app;
#line 237 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp59_ = g_app_info_get_name (_tmp58_);
#line 237 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			g_value_init (&_tmp60_, G_TYPE_STRING);
#line 237 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			g_value_set_string (&_tmp60_, _tmp59_);
#line 237 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			gtk_list_store_set_value (_tmp56_, &_tmp57_, 1, &_tmp60_);
#line 237 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			G_IS_VALUE (&_tmp60_) ? (g_value_unset (&_tmp60_), NULL) : NULL;
#line 239 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp61_ = app;
#line 239 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp62_ = g_app_info_get_commandline (_tmp61_);
#line 239 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp63_ = current_app_executable;
#line 239 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			if (g_strcmp0 (_tmp62_, _tmp63_) == 0) {
#line 1494 "Preferences.c"
				SortedList* _tmp64_;
				GAppInfo* _tmp65_;
				gint _tmp66_;
#line 240 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp64_ = _vala_external_apps;
#line 240 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp65_ = app;
#line 240 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp66_ = sorted_list_index_of (_tmp64_, _tmp65_);
#line 240 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				current_app = _tmp66_;
#line 1506 "Preferences.c"
			}
#line 217 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_g_object_unref0 (app_icon);
#line 217 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_g_object_unref0 (app);
#line 1512 "Preferences.c"
		}
#line 217 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_object_unref0 (_app_it);
#line 1516 "Preferences.c"
	}
#line 245 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp67_ = combo_box;
#line 245 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp68_ = combo_store;
#line 245 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_combo_box_set_model (_tmp67_, G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, GTK_TYPE_TREE_MODEL, GtkTreeModel));
#line 247 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp69_ = current_app;
#line 247 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (_tmp69_ != -1) {
#line 1528 "Preferences.c"
		GtkComboBox* _tmp70_;
		gint _tmp71_;
#line 248 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp70_ = combo_box;
#line 248 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp71_ = current_app;
#line 248 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_combo_box_set_active (_tmp70_, _tmp71_);
#line 1537 "Preferences.c"
	}
#line 193 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (combo_store);
#line 193 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (text_renderer);
#line 193 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (pixbuf_renderer);
#line 193 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (external_apps) {
#line 193 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		*external_apps = _vala_external_apps;
#line 1549 "Preferences.c"
	} else {
#line 193 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_object_unref0 (_vala_external_apps);
#line 1553 "Preferences.c"
	}
}


static void preferences_dialog_setup_dir_pattern (PreferencesDialog* self, GtkComboBox* combo_box, GtkEntry* entry) {
	gchar* pattern = NULL;
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean found = FALSE;
	const gchar* _tmp4_;
	gboolean _tmp32_;
#line 251 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 251 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (GTK_IS_COMBO_BOX (combo_box));
#line 251 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (GTK_IS_ENTRY (entry));
#line 252 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = config_facade_get_instance ();
#line 252 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = _tmp0_;
#line 252 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = configuration_facade_get_directory_pattern (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 252 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3_ = _tmp2_;
#line 252 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp1_);
#line 252 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	pattern = _tmp3_;
#line 253 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	found = FALSE;
#line 254 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp4_ = pattern;
#line 254 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (NULL != _tmp4_) {
#line 1591 "Preferences.c"
		gint i = 0;
#line 256 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		i = 0;
#line 1595 "Preferences.c"
		{
			GeeArrayList* _pf_list = NULL;
			GeeArrayList* _tmp5_;
			GeeArrayList* _tmp6_;
			gint _pf_size = 0;
			GeeArrayList* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _pf_index = 0;
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp5_ = self->priv->path_formats;
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp6_ = _g_object_ref0 (_tmp5_);
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_pf_list = _tmp6_;
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp7_ = _pf_list;
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp8_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp9_ = _tmp8_;
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_pf_size = _tmp9_;
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_pf_index = -1;
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			while (TRUE) {
#line 1623 "Preferences.c"
				gint _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				PreferencesDialogPathFormat* pf = NULL;
				GeeArrayList* _tmp13_;
				gint _tmp14_;
				gpointer _tmp15_;
				PreferencesDialogPathFormat* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				gint _tmp21_;
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp10_ = _pf_index;
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_pf_index = _tmp10_ + 1;
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp11_ = _pf_index;
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp12_ = _pf_size;
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				if (!(_tmp11_ < _tmp12_)) {
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					break;
#line 1647 "Preferences.c"
				}
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp13_ = _pf_list;
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp14_ = _pf_index;
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp15_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp14_);
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				pf = (PreferencesDialogPathFormat*) _tmp15_;
#line 258 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp16_ = pf;
#line 258 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp17_ = _tmp16_->pattern;
#line 258 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp18_ = pattern;
#line 258 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				if (g_strcmp0 (_tmp17_, _tmp18_) == 0) {
#line 1665 "Preferences.c"
					GtkComboBox* _tmp19_;
					gint _tmp20_;
#line 259 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					_tmp19_ = combo_box;
#line 259 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					_tmp20_ = i;
#line 259 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					gtk_combo_box_set_active (_tmp19_, _tmp20_);
#line 260 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					found = TRUE;
#line 261 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					_preferences_dialog_path_format_unref0 (pf);
#line 261 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
					break;
#line 1680 "Preferences.c"
				}
#line 263 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_tmp21_ = i;
#line 263 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				i = _tmp21_ + 1;
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
				_preferences_dialog_path_format_unref0 (pf);
#line 1688 "Preferences.c"
			}
#line 257 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_g_object_unref0 (_pf_list);
#line 1692 "Preferences.c"
		}
	} else {
		gchar* s = NULL;
		ConfigFacade* _tmp22_;
		ConfigFacade* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		const gchar* _tmp26_;
		gboolean _tmp27_;
#line 267 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp22_ = config_facade_get_instance ();
#line 267 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp23_ = _tmp22_;
#line 267 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp24_ = configuration_facade_get_directory_pattern_custom (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 267 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp25_ = _tmp24_;
#line 267 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_object_unref0 (_tmp23_);
#line 267 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		s = _tmp25_;
#line 268 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp26_ = s;
#line 268 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp27_ = is_string_empty (_tmp26_);
#line 268 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		if (!_tmp27_) {
#line 1720 "Preferences.c"
			GtkComboBox* _tmp28_;
			GeeArrayList* _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
#line 269 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp28_ = combo_box;
#line 269 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp29_ = self->priv->path_formats;
#line 269 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp30_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 269 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp31_ = _tmp30_;
#line 269 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			gtk_combo_box_set_active (_tmp28_, _tmp31_ - 1);
#line 270 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			found = TRUE;
#line 1737 "Preferences.c"
		}
#line 254 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_free0 (s);
#line 1741 "Preferences.c"
	}
#line 274 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp32_ = found;
#line 274 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (!_tmp32_) {
#line 1747 "Preferences.c"
		GtkComboBox* _tmp33_;
#line 275 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp33_ = combo_box;
#line 275 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_combo_box_set_active (_tmp33_, 0);
#line 1753 "Preferences.c"
	}
#line 278 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_on_dir_pattern_combo_changed (self);
#line 251 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (pattern);
#line 1759 "Preferences.c"
}


void preferences_dialog_show_preferences (void) {
	PreferencesDialog* _tmp0_;
	PreferencesDialog* _tmp2_;
	PreferencesDialog* _tmp3_;
	PreferencesDialog* _tmp4_;
	GtkFileChooserButton* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	PreferencesDialog* _tmp10_;
#line 282 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = preferences_dialog_preferences_dialog;
#line 282 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (_tmp0_ == NULL) {
#line 1778 "Preferences.c"
		PreferencesDialog* _tmp1_;
#line 283 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp1_ = preferences_dialog_new ();
#line 283 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		g_object_ref_sink (_tmp1_);
#line 283 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_object_unref0 (preferences_dialog_preferences_dialog);
#line 283 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		preferences_dialog_preferences_dialog = _tmp1_;
#line 1788 "Preferences.c"
	}
#line 285 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = preferences_dialog_preferences_dialog;
#line 285 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_populate_preference_options (_tmp2_);
#line 286 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3_ = preferences_dialog_preferences_dialog;
#line 286 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget));
#line 287 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp4_ = preferences_dialog_preferences_dialog;
#line 287 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp5_ = _tmp4_->priv->library_dir_button;
#line 287 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp6_ = app_dirs_get_import_dir ();
#line 287 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp7_ = _tmp6_;
#line 287 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp8_ = g_file_get_path (_tmp7_);
#line 287 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp9_ = _tmp8_;
#line 287 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_file_chooser_set_current_folder (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GTK_TYPE_FILE_CHOOSER, GtkFileChooser), _tmp9_);
#line 287 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (_tmp9_);
#line 287 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp7_);
#line 291 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp10_ = preferences_dialog_preferences_dialog;
#line 291 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_window_present (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_window_get_type (), GtkWindow));
#line 1820 "Preferences.c"
}


static void preferences_dialog_commit_on_close (PreferencesDialog* self) {
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	ConfigFacade* _tmp2_;
	ConfigFacade* _tmp3_;
	GtkCheckButton* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	ConfigFacade* _tmp7_;
	ConfigFacade* _tmp8_;
	GtkCheckButton* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	const gchar* _tmp12_;
	PreferencesDialogPathFormat* pf = NULL;
	GeeArrayList* _tmp14_;
	GtkComboBoxText* _tmp15_;
	gint _tmp16_;
	gpointer _tmp17_;
	PreferencesDialogPathFormat* _tmp18_;
	const gchar* _tmp19_;
#line 296 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 297 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = config_facade_get_instance ();
#line 297 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = _tmp0_;
#line 297 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	config_facade_commit_bg_color (_tmp1_);
#line 297 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp1_);
#line 298 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = config_facade_get_instance ();
#line 298 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3_ = _tmp2_;
#line 298 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp4_ = self->priv->autoimport;
#line 298 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp5_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 298 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp6_ = _tmp5_;
#line 298 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	configuration_facade_set_auto_import_from_library (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp6_);
#line 298 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp3_);
#line 299 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp7_ = config_facade_get_instance ();
#line 299 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp8_ = _tmp7_;
#line 299 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp9_ = self->priv->write_metadata;
#line 299 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp10_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 299 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp11_ = _tmp10_;
#line 299 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	configuration_facade_set_commit_metadata_to_masters (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp11_);
#line 299 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp8_);
#line 301 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp12_ = self->priv->lib_dir;
#line 301 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (_tmp12_ != NULL) {
#line 1887 "Preferences.c"
		const gchar* _tmp13_;
#line 302 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp13_ = self->priv->lib_dir;
#line 302 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		app_dirs_set_import_dir (_tmp13_);
#line 1893 "Preferences.c"
	}
#line 304 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp14_ = self->priv->path_formats;
#line 304 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp15_ = self->priv->dir_pattern_combo;
#line 304 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp16_ = gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_combo_box_get_type (), GtkComboBox));
#line 304 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp17_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp16_);
#line 304 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	pf = (PreferencesDialogPathFormat*) _tmp17_;
#line 305 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp18_ = pf;
#line 305 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp19_ = _tmp18_->pattern;
#line 305 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (NULL == _tmp19_) {
#line 1911 "Preferences.c"
		ConfigFacade* _tmp20_;
		ConfigFacade* _tmp21_;
		GtkEntry* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		ConfigFacade* _tmp25_;
		ConfigFacade* _tmp26_;
#line 306 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp20_ = config_facade_get_instance ();
#line 306 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp21_ = _tmp20_;
#line 306 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp22_ = self->priv->dir_pattern_entry;
#line 306 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp23_ = gtk_entry_get_text (_tmp22_);
#line 306 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp24_ = _tmp23_;
#line 306 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		configuration_facade_set_directory_pattern_custom (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp24_);
#line 306 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_object_unref0 (_tmp21_);
#line 307 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp25_ = config_facade_get_instance ();
#line 307 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp26_ = _tmp25_;
#line 307 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		configuration_facade_set_directory_pattern (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), NULL);
#line 307 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_object_unref0 (_tmp26_);
#line 1941 "Preferences.c"
	} else {
		ConfigFacade* _tmp27_;
		ConfigFacade* _tmp28_;
		PreferencesDialogPathFormat* _tmp29_;
		const gchar* _tmp30_;
#line 309 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp27_ = config_facade_get_instance ();
#line 309 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp28_ = _tmp27_;
#line 309 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp29_ = pf;
#line 309 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp30_ = _tmp29_->pattern;
#line 309 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		configuration_facade_set_directory_pattern (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp30_);
#line 309 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_object_unref0 (_tmp28_);
#line 1959 "Preferences.c"
	}
#line 296 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_preferences_dialog_path_format_unref0 (pf);
#line 1963 "Preferences.c"
}


static gboolean preferences_dialog_on_delete (PreferencesDialog* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
#line 313 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_val_if_fail (IS_PREFERENCES_DIALOG (self), FALSE);
#line 314 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = preferences_dialog_get_allow_closing (self);
#line 314 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (!_tmp0_) {
#line 315 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		result = TRUE;
#line 315 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		return result;
#line 1981 "Preferences.c"
	}
#line 317 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_commit_on_close (self);
#line 318 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = gtk_widget_hide_on_delete (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 318 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	result = _tmp1_;
#line 318 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return result;
#line 1991 "Preferences.c"
}


static void preferences_dialog_on_close (PreferencesDialog* self) {
	gboolean _tmp0_;
#line 321 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 322 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = preferences_dialog_get_allow_closing (self);
#line 322 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (!_tmp0_) {
#line 323 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		return;
#line 2005 "Preferences.c"
	}
#line 325 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 326 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_commit_on_close (self);
#line 2011 "Preferences.c"
}


static void preferences_dialog_on_value_changed (PreferencesDialog* self) {
	GtkAdjustment* _tmp0_;
	gdouble _tmp1_;
	GtkAdjustment* _tmp2_;
	gdouble _tmp3_;
#line 329 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 330 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = self->priv->bg_color_adjustment;
#line 330 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = gtk_adjustment_get_upper (_tmp0_);
#line 330 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = self->priv->bg_color_adjustment;
#line 330 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3_ = gtk_adjustment_get_value (_tmp2_);
#line 330 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_set_background_color (self, ((gdouble) (_tmp1_ - _tmp3_)) / 65535.0);
#line 2032 "Preferences.c"
}


static gboolean preferences_dialog_on_bg_color_reset (PreferencesDialog* self, GdkEventButton* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GdkEventButton* _tmp2_;
	guint _tmp3_;
#line 334 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_val_if_fail (IS_PREFERENCES_DIALOG (self), FALSE);
#line 334 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 335 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = event;
#line 335 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3_ = _tmp2_->button;
#line 335 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (_tmp3_ == ((guint) 1)) {
#line 2052 "Preferences.c"
		GdkEventButton* _tmp4_;
		GdkEventType _tmp5_;
#line 335 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp4_ = event;
#line 335 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp5_ = _tmp4_->type;
#line 335 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp1_ = _tmp5_ == GDK_BUTTON_PRESS;
#line 2061 "Preferences.c"
	} else {
#line 335 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp1_ = FALSE;
#line 2065 "Preferences.c"
	}
#line 335 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (_tmp1_) {
#line 2069 "Preferences.c"
		GdkEventButton* _tmp6_;
		GdkModifierType _tmp7_;
		gboolean _tmp8_;
#line 336 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp6_ = event;
#line 336 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp7_ = _tmp6_->state;
#line 336 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp8_ = has_only_key_modifier (_tmp7_, GDK_CONTROL_MASK);
#line 336 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp0_ = _tmp8_;
#line 2081 "Preferences.c"
	} else {
#line 335 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp0_ = FALSE;
#line 2085 "Preferences.c"
	}
#line 335 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (_tmp0_) {
#line 2089 "Preferences.c"
		GtkScale* _tmp9_;
		GtkAdjustment* _tmp10_;
		gdouble _tmp11_;
		GdkRGBA _tmp12_ = {0};
		gdouble _tmp13_;
#line 338 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp9_ = self->priv->bg_color_slider;
#line 338 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp10_ = self->priv->bg_color_adjustment;
#line 338 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp11_ = gtk_adjustment_get_upper (_tmp10_);
#line 338 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		parse_color (CONFIG_FACADE_DEFAULT_BG_COLOR, &_tmp12_);
#line 338 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp13_ = _tmp12_.red;
#line 338 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_range_set_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_range_get_type (), GtkRange), _tmp11_ - (_tmp13_ * 65536.0f));
#line 340 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		preferences_dialog_on_value_changed (self);
#line 342 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		result = TRUE;
#line 342 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		return result;
#line 2113 "Preferences.c"
	}
#line 345 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	result = FALSE;
#line 345 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return result;
#line 2119 "Preferences.c"
}


static void preferences_dialog_on_dir_pattern_combo_changed (PreferencesDialog* self) {
	PreferencesDialogPathFormat* pf = NULL;
	GeeArrayList* _tmp0_;
	GtkComboBoxText* _tmp1_;
	gint _tmp2_;
	gpointer _tmp3_;
	PreferencesDialogPathFormat* _tmp4_;
	const gchar* _tmp5_;
#line 348 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 349 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = self->priv->path_formats;
#line 349 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = self->priv->dir_pattern_combo;
#line 349 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_combo_box_get_type (), GtkComboBox));
#line 349 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp2_);
#line 349 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	pf = (PreferencesDialogPathFormat*) _tmp3_;
#line 350 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp4_ = pf;
#line 350 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp5_ = _tmp4_->pattern;
#line 350 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (NULL == _tmp5_) {
#line 2149 "Preferences.c"
		gchar* dir_pattern = NULL;
		ConfigFacade* _tmp6_;
		ConfigFacade* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		gboolean _tmp11_;
		GtkEntry* _tmp13_;
		const gchar* _tmp14_;
		GtkEntry* _tmp15_;
		GtkEntry* _tmp16_;
#line 352 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp6_ = config_facade_get_instance ();
#line 352 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp7_ = _tmp6_;
#line 352 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp8_ = configuration_facade_get_directory_pattern_custom (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 352 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp9_ = _tmp8_;
#line 352 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_object_unref0 (_tmp7_);
#line 352 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		dir_pattern = _tmp9_;
#line 353 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp10_ = dir_pattern;
#line 353 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp11_ = is_string_empty (_tmp10_);
#line 353 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		if (_tmp11_) {
#line 2179 "Preferences.c"
			gchar* _tmp12_;
#line 354 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_tmp12_ = g_strdup ("");
#line 354 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			_g_free0 (dir_pattern);
#line 354 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			dir_pattern = _tmp12_;
#line 2187 "Preferences.c"
		}
#line 355 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp13_ = self->priv->dir_pattern_entry;
#line 355 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp14_ = dir_pattern;
#line 355 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_entry_set_text (_tmp13_, _tmp14_);
#line 356 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp15_ = self->priv->dir_pattern_entry;
#line 356 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		g_object_set (_tmp15_, "editable", TRUE, NULL);
#line 357 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp16_ = self->priv->dir_pattern_entry;
#line 357 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget), TRUE);
#line 350 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_g_free0 (dir_pattern);
#line 2205 "Preferences.c"
	} else {
		GtkEntry* _tmp17_;
		PreferencesDialogPathFormat* _tmp18_;
		const gchar* _tmp19_;
		GtkEntry* _tmp20_;
		GtkEntry* _tmp21_;
#line 359 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp17_ = self->priv->dir_pattern_entry;
#line 359 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp18_ = pf;
#line 359 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp19_ = _tmp18_->pattern;
#line 359 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_entry_set_text (_tmp17_, _tmp19_);
#line 360 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp20_ = self->priv->dir_pattern_entry;
#line 360 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		g_object_set (_tmp20_, "editable", FALSE, NULL);
#line 361 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp21_ = self->priv->dir_pattern_entry;
#line 361 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 2228 "Preferences.c"
	}
#line 348 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_preferences_dialog_path_format_unref0 (pf);
#line 2232 "Preferences.c"
}


static void preferences_dialog_on_dir_pattern_entry_changed (PreferencesDialog* self) {
	gchar* example = NULL;
	GDateTime* _tmp0_;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	gboolean _tmp7_;
#line 365 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 366 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = self->priv->example_date;
#line 366 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = self->priv->dir_pattern_entry;
#line 366 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = gtk_entry_get_text (_tmp1_);
#line 366 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3_ = _tmp2_;
#line 366 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp4_ = g_date_time_format (_tmp0_, _tmp3_);
#line 366 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	example = _tmp4_;
#line 367 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp6_ = example;
#line 367 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp7_ = is_string_empty (_tmp6_);
#line 367 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (_tmp7_) {
#line 2266 "Preferences.c"
		GtkEntry* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gboolean _tmp11_;
#line 367 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp8_ = self->priv->dir_pattern_entry;
#line 367 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp9_ = gtk_entry_get_text (_tmp8_);
#line 367 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp10_ = _tmp9_;
#line 367 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp11_ = is_string_empty (_tmp10_);
#line 367 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp5_ = !_tmp11_;
#line 2281 "Preferences.c"
	} else {
#line 367 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp5_ = FALSE;
#line 2285 "Preferences.c"
	}
#line 367 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (_tmp5_) {
#line 2289 "Preferences.c"
		GtkLabel* _tmp12_;
		GtkEntry* _tmp13_;
		GtkEntry* _tmp14_;
#line 369 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp12_ = self->priv->dir_pattern_example;
#line 369 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_label_set_text (_tmp12_, _ ("Invalid pattern"));
#line 370 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp13_ = self->priv->dir_pattern_entry;
#line 370 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_entry_set_icon_from_icon_name (_tmp13_, GTK_ENTRY_ICON_SECONDARY, "dialog-error");
#line 371 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp14_ = self->priv->dir_pattern_entry;
#line 371 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_entry_set_icon_activatable (_tmp14_, GTK_ENTRY_ICON_SECONDARY, FALSE);
#line 372 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		preferences_dialog_set_allow_closing (self, FALSE);
#line 2307 "Preferences.c"
	} else {
		GtkLabel* _tmp15_;
		const gchar* _tmp16_;
		GtkEntry* _tmp17_;
#line 375 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp15_ = self->priv->dir_pattern_example;
#line 375 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp16_ = example;
#line 375 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_label_set_text (_tmp15_, _tmp16_);
#line 376 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp17_ = self->priv->dir_pattern_entry;
#line 376 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_entry_set_icon_from_icon_name (_tmp17_, GTK_ENTRY_ICON_SECONDARY, NULL);
#line 377 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		preferences_dialog_set_allow_closing (self, TRUE);
#line 2324 "Preferences.c"
	}
#line 365 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (example);
#line 2328 "Preferences.c"
}


static void preferences_dialog_set_allow_closing (PreferencesDialog* self, gboolean allow) {
	gboolean _tmp0_;
	gboolean _tmp1_;
#line 381 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 382 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = allow;
#line 382 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_window_set_deletable (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp0_);
#line 383 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = allow;
#line 383 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self->priv->allow_closing = _tmp1_;
#line 2345 "Preferences.c"
}


static gboolean preferences_dialog_get_allow_closing (PreferencesDialog* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 386 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_val_if_fail (IS_PREFERENCES_DIALOG (self), FALSE);
#line 387 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = self->priv->allow_closing;
#line 387 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	result = _tmp0_;
#line 387 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return result;
#line 2360 "Preferences.c"
}


static void preferences_dialog_set_background_color (PreferencesDialog* self, gdouble bg_color_value) {
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	gdouble _tmp2_;
	GdkRGBA _tmp3_ = {0};
#line 390 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 391 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = config_facade_get_instance ();
#line 391 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = _tmp0_;
#line 391 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = bg_color_value;
#line 391 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_to_grayscale (self, _tmp2_, &_tmp3_);
#line 391 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	config_facade_set_bg_color (_tmp1_, &_tmp3_);
#line 391 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp1_);
#line 2383 "Preferences.c"
}


static void preferences_dialog_to_grayscale (PreferencesDialog* self, gdouble color_value, GdkRGBA* result) {
	GdkRGBA color = {0};
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
#line 394 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 395 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	memset (&color, 0, sizeof (GdkRGBA));
#line 397 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = color_value;
#line 397 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	color.red = _tmp0_;
#line 398 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = color_value;
#line 398 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	color.green = _tmp1_;
#line 399 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = color_value;
#line 399 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	color.blue = _tmp2_;
#line 400 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	color.alpha = 1.0;
#line 402 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	*result = color;
#line 402 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return;
#line 2414 "Preferences.c"
}


static void preferences_dialog_on_photo_editor_changed (PreferencesDialog* self) {
	gint _tmp0_ = 0;
	GtkComboBox* _tmp1_;
	gint _tmp2_;
	SortedList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint photo_app_choice_index = 0;
	GAppInfo* app = NULL;
	SortedList* _tmp11_;
	gpointer _tmp12_;
	ConfigFacade* _tmp13_;
	ConfigFacade* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
#line 405 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 406 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = self->priv->photo_editor_combo;
#line 406 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = gtk_combo_box_get_active (_tmp1_);
#line 406 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3_ = self->priv->external_photo_apps;
#line 406 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp4_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
#line 406 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp5_ = _tmp4_;
#line 406 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (_tmp2_ < _tmp5_) {
#line 2449 "Preferences.c"
		GtkComboBox* _tmp6_;
		gint _tmp7_;
#line 407 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp6_ = self->priv->photo_editor_combo;
#line 407 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp7_ = gtk_combo_box_get_active (_tmp6_);
#line 407 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp0_ = _tmp7_;
#line 2458 "Preferences.c"
	} else {
		SortedList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
#line 407 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp8_ = self->priv->external_photo_apps;
#line 407 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp9_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_COLLECTION, GeeCollection));
#line 407 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp10_ = _tmp9_;
#line 407 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp0_ = _tmp10_;
#line 2471 "Preferences.c"
	}
#line 406 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	photo_app_choice_index = _tmp0_;
#line 409 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp11_ = self->priv->external_photo_apps;
#line 409 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp12_ = sorted_list_get_at (_tmp11_, photo_app_choice_index);
#line 409 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	app = (GAppInfo*) _tmp12_;
#line 411 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp13_ = config_facade_get_instance ();
#line 411 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp14_ = _tmp13_;
#line 411 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp15_ = desktop_integration_get_app_open_command (app);
#line 411 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp16_ = _tmp15_;
#line 411 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	configuration_facade_set_external_photo_app (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp16_);
#line 411 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (_tmp16_);
#line 411 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp14_);
#line 413 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp17_ = desktop_integration_get_app_open_command (app);
#line 413 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp18_ = _tmp17_;
#line 413 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_debug ("Preferences.vala:413: setting external photo editor to: %s", _tmp18_);
#line 413 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (_tmp18_);
#line 405 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (app);
#line 2505 "Preferences.c"
}


static void preferences_dialog_on_raw_editor_changed (PreferencesDialog* self) {
	gint _tmp0_ = 0;
	GtkComboBox* _tmp1_;
	gint _tmp2_;
	SortedList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint raw_app_choice_index = 0;
	GAppInfo* app = NULL;
	SortedList* _tmp11_;
	gpointer _tmp12_;
	ConfigFacade* _tmp13_;
	ConfigFacade* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
#line 416 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 417 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = self->priv->raw_editor_combo;
#line 417 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = gtk_combo_box_get_active (_tmp1_);
#line 417 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3_ = self->priv->external_raw_apps;
#line 417 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp4_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
#line 417 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp5_ = _tmp4_;
#line 417 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (_tmp2_ < _tmp5_) {
#line 2538 "Preferences.c"
		GtkComboBox* _tmp6_;
		gint _tmp7_;
#line 418 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp6_ = self->priv->raw_editor_combo;
#line 418 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp7_ = gtk_combo_box_get_active (_tmp6_);
#line 418 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp0_ = _tmp7_;
#line 2547 "Preferences.c"
	} else {
		SortedList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
#line 418 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp8_ = self->priv->external_raw_apps;
#line 418 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp9_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_COLLECTION, GeeCollection));
#line 418 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp10_ = _tmp9_;
#line 418 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp0_ = _tmp10_;
#line 2560 "Preferences.c"
	}
#line 417 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	raw_app_choice_index = _tmp0_;
#line 420 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp11_ = self->priv->external_raw_apps;
#line 420 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp12_ = sorted_list_get_at (_tmp11_, raw_app_choice_index);
#line 420 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	app = (GAppInfo*) _tmp12_;
#line 422 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp13_ = config_facade_get_instance ();
#line 422 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp14_ = _tmp13_;
#line 422 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp15_ = g_app_info_get_commandline (app);
#line 422 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	configuration_facade_set_external_raw_app (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp15_);
#line 422 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp14_);
#line 424 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp16_ = g_app_info_get_commandline (app);
#line 424 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_debug ("Preferences.vala:424: setting external raw editor to: %s", _tmp16_);
#line 416 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (app);
#line 2586 "Preferences.c"
}


static RawDeveloper preferences_dialog_raw_developer_from_combo (PreferencesDialog* self) {
	RawDeveloper result = 0;
	GtkComboBoxText* _tmp0_;
	gint _tmp1_;
#line 427 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_val_if_fail (IS_PREFERENCES_DIALOG (self), 0);
#line 428 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = self->priv->default_raw_developer_combo;
#line 428 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_combo_box_get_type (), GtkComboBox));
#line 428 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (_tmp1_ == 0) {
#line 429 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		result = RAW_DEVELOPER_CAMERA;
#line 429 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		return result;
#line 2606 "Preferences.c"
	}
#line 430 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	result = RAW_DEVELOPER_SHOTWELL;
#line 430 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return result;
#line 2612 "Preferences.c"
}


static void preferences_dialog_set_raw_developer_combo (PreferencesDialog* self, RawDeveloper d) {
	RawDeveloper _tmp0_;
#line 433 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 434 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = d;
#line 434 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (_tmp0_ == RAW_DEVELOPER_CAMERA) {
#line 2624 "Preferences.c"
		GtkComboBoxText* _tmp1_;
#line 435 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp1_ = self->priv->default_raw_developer_combo;
#line 435 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_combo_box_get_type (), GtkComboBox), 0);
#line 2630 "Preferences.c"
	} else {
		GtkComboBoxText* _tmp2_;
#line 437 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		_tmp2_ = self->priv->default_raw_developer_combo;
#line 437 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_combo_box_get_type (), GtkComboBox), 1);
#line 2637 "Preferences.c"
	}
}


static void preferences_dialog_on_default_raw_developer_changed (PreferencesDialog* self) {
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	RawDeveloper _tmp2_;
#line 440 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 441 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = config_facade_get_instance ();
#line 441 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = _tmp0_;
#line 441 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = preferences_dialog_raw_developer_from_combo (self);
#line 441 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	configuration_facade_set_default_raw_developer (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp2_);
#line 441 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp1_);
#line 2658 "Preferences.c"
}


static void preferences_dialog_on_current_folder_changed (PreferencesDialog* self) {
	GtkFileChooserButton* _tmp0_;
	gchar* _tmp1_;
#line 444 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 445 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = self->priv->library_dir_button;
#line 445 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = gtk_file_chooser_get_filename (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GTK_TYPE_FILE_CHOOSER, GtkFileChooser));
#line 445 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (self->priv->lib_dir);
#line 445 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self->priv->lib_dir = _tmp1_;
#line 2675 "Preferences.c"
}


static void _preferences_dialog_on_current_folder_changed_gtk_file_chooser_current_folder_changed (GtkFileChooser* _sender, gpointer self) {
#line 454 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_on_current_folder_changed ((PreferencesDialog*) self);
#line 2682 "Preferences.c"
}


static gboolean preferences_dialog_real_map_event (GtkWidget* base, GdkEventAny* event) {
	PreferencesDialog * self;
	gboolean result = FALSE;
	gboolean _result_ = FALSE;
	GdkEventAny* _tmp0_;
	gboolean _tmp1_;
	GtkFileChooserButton* _tmp2_;
#line 448 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PREFERENCES_DIALOG, PreferencesDialog);
#line 448 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 449 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = event;
#line 449 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = GTK_WIDGET_CLASS (preferences_dialog_parent_class)->map_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), gtk_widget_get_type (), GtkWidget), _tmp0_);
#line 449 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_result_ = _tmp1_;
#line 454 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = self->priv->library_dir_button;
#line 454 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GTK_TYPE_FILE_CHOOSER, GtkFileChooser), "current-folder-changed", (GCallback) _preferences_dialog_on_current_folder_changed_gtk_file_chooser_current_folder_changed, self, 0);
#line 456 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	result = _result_;
#line 456 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return result;
#line 2711 "Preferences.c"
}


static void preferences_dialog_add_to_dir_formats (PreferencesDialog* self, const gchar* name, const gchar* pattern) {
	PreferencesDialogPathFormat* pf = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	PreferencesDialogPathFormat* _tmp2_;
	GeeArrayList* _tmp3_;
	GtkComboBoxText* _tmp4_;
	const gchar* _tmp5_;
#line 459 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 459 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (name != NULL);
#line 460 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = name;
#line 460 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = pattern;
#line 460 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = preferences_dialog_path_format_new (_tmp0_, _tmp1_);
#line 460 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	pf = _tmp2_;
#line 461 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3_ = self->priv->path_formats;
#line 461 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), pf);
#line 462 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp4_ = self->priv->dir_pattern_combo;
#line 462 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp5_ = name;
#line 462 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_combo_box_text_append_text (_tmp4_, _tmp5_);
#line 459 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_preferences_dialog_path_format_unref0 (pf);
#line 2747 "Preferences.c"
}


static void preferences_dialog_on_lowercase_toggled (PreferencesDialog* self) {
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	GtkCheckButton* _tmp2_;
	gboolean _tmp3_;
#line 465 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (IS_PREFERENCES_DIALOG (self));
#line 466 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = config_facade_get_instance ();
#line 466 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = _tmp0_;
#line 466 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = self->priv->lowercase;
#line 466 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 466 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	configuration_facade_set_use_lowercase_filenames (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp3_);
#line 466 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (_tmp1_);
#line 2770 "Preferences.c"
}


static PreferencesDialogPathFormat* preferences_dialog_path_format_construct (GType object_type, const gchar* name, const gchar* pattern) {
	PreferencesDialogPathFormat* self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
#line 11 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 11 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self = (PreferencesDialogPathFormat*) g_type_create_instance (object_type);
#line 12 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = name;
#line 12 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 12 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (self->name);
#line 12 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self->name = _tmp1_;
#line 13 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = pattern;
#line 13 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 13 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (self->pattern);
#line 13 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self->pattern = _tmp3_;
#line 11 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return self;
#line 2802 "Preferences.c"
}


static PreferencesDialogPathFormat* preferences_dialog_path_format_new (const gchar* name, const gchar* pattern) {
#line 11 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return preferences_dialog_path_format_construct (PREFERENCES_DIALOG_TYPE_PATH_FORMAT, name, pattern);
#line 2809 "Preferences.c"
}


static void preferences_dialog_value_path_format_init (GValue* value) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	value->data[0].v_pointer = NULL;
#line 2816 "Preferences.c"
}


static void preferences_dialog_value_path_format_free_value (GValue* value) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (value->data[0].v_pointer) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		preferences_dialog_path_format_unref (value->data[0].v_pointer);
#line 2825 "Preferences.c"
	}
}


static void preferences_dialog_value_path_format_copy_value (const GValue* src_value, GValue* dest_value) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (src_value->data[0].v_pointer) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		dest_value->data[0].v_pointer = preferences_dialog_path_format_ref (src_value->data[0].v_pointer);
#line 2835 "Preferences.c"
	} else {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2839 "Preferences.c"
	}
}


static gpointer preferences_dialog_value_path_format_peek_pointer (const GValue* value) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return value->data[0].v_pointer;
#line 2847 "Preferences.c"
}


static gchar* preferences_dialog_value_path_format_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (collect_values[0].v_pointer) {
#line 2854 "Preferences.c"
		PreferencesDialogPathFormat * object;
		object = collect_values[0].v_pointer;
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		if (object->parent_instance.g_class == NULL) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2861 "Preferences.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2865 "Preferences.c"
		}
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		value->data[0].v_pointer = preferences_dialog_path_format_ref (object);
#line 2869 "Preferences.c"
	} else {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		value->data[0].v_pointer = NULL;
#line 2873 "Preferences.c"
	}
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return NULL;
#line 2877 "Preferences.c"
}


static gchar* preferences_dialog_value_path_format_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PreferencesDialogPathFormat ** object_p;
	object_p = collect_values[0].v_pointer;
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (!object_p) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2888 "Preferences.c"
	}
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (!value->data[0].v_pointer) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		*object_p = NULL;
#line 2894 "Preferences.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		*object_p = value->data[0].v_pointer;
#line 2898 "Preferences.c"
	} else {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		*object_p = preferences_dialog_path_format_ref (value->data[0].v_pointer);
#line 2902 "Preferences.c"
	}
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return NULL;
#line 2906 "Preferences.c"
}


static GParamSpec* preferences_dialog_param_spec_path_format (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	PreferencesDialogParamSpecPathFormat* spec;
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_val_if_fail (g_type_is_a (object_type, PREFERENCES_DIALOG_TYPE_PATH_FORMAT), NULL);
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return G_PARAM_SPEC (spec);
#line 2920 "Preferences.c"
}


static gpointer preferences_dialog_value_get_path_format (const GValue* value) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PREFERENCES_DIALOG_TYPE_PATH_FORMAT), NULL);
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return value->data[0].v_pointer;
#line 2929 "Preferences.c"
}


static void preferences_dialog_value_set_path_format (GValue* value, gpointer v_object) {
	PreferencesDialogPathFormat * old;
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PREFERENCES_DIALOG_TYPE_PATH_FORMAT));
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	old = value->data[0].v_pointer;
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (v_object) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PREFERENCES_DIALOG_TYPE_PATH_FORMAT));
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		value->data[0].v_pointer = v_object;
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		preferences_dialog_path_format_ref (value->data[0].v_pointer);
#line 2949 "Preferences.c"
	} else {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		value->data[0].v_pointer = NULL;
#line 2953 "Preferences.c"
	}
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (old) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		preferences_dialog_path_format_unref (old);
#line 2959 "Preferences.c"
	}
}


static void preferences_dialog_value_take_path_format (GValue* value, gpointer v_object) {
	PreferencesDialogPathFormat * old;
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PREFERENCES_DIALOG_TYPE_PATH_FORMAT));
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	old = value->data[0].v_pointer;
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (v_object) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PREFERENCES_DIALOG_TYPE_PATH_FORMAT));
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		value->data[0].v_pointer = v_object;
#line 2978 "Preferences.c"
	} else {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		value->data[0].v_pointer = NULL;
#line 2982 "Preferences.c"
	}
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (old) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		preferences_dialog_path_format_unref (old);
#line 2988 "Preferences.c"
	}
}


static void preferences_dialog_path_format_class_init (PreferencesDialogPathFormatClass * klass) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_path_format_parent_class = g_type_class_peek_parent (klass);
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	((PreferencesDialogPathFormatClass *) klass)->finalize = preferences_dialog_path_format_finalize;
#line 2998 "Preferences.c"
}


static void preferences_dialog_path_format_instance_init (PreferencesDialogPathFormat * self) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self->ref_count = 1;
#line 3005 "Preferences.c"
}


static void preferences_dialog_path_format_finalize (PreferencesDialogPathFormat * obj) {
	PreferencesDialogPathFormat * self;
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PREFERENCES_DIALOG_TYPE_PATH_FORMAT, PreferencesDialogPathFormat);
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_signal_handlers_destroy (self);
#line 15 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (self->name);
#line 16 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (self->pattern);
#line 3019 "Preferences.c"
}


static GType preferences_dialog_path_format_get_type (void) {
	static volatile gsize preferences_dialog_path_format_type_id__volatile = 0;
	if (g_once_init_enter (&preferences_dialog_path_format_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { preferences_dialog_value_path_format_init, preferences_dialog_value_path_format_free_value, preferences_dialog_value_path_format_copy_value, preferences_dialog_value_path_format_peek_pointer, "p", preferences_dialog_value_path_format_collect_value, "p", preferences_dialog_value_path_format_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PreferencesDialogPathFormatClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) preferences_dialog_path_format_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PreferencesDialogPathFormat), 0, (GInstanceInitFunc) preferences_dialog_path_format_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType preferences_dialog_path_format_type_id;
		preferences_dialog_path_format_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PreferencesDialogPathFormat", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&preferences_dialog_path_format_type_id__volatile, preferences_dialog_path_format_type_id);
	}
	return preferences_dialog_path_format_type_id__volatile;
}


static gpointer preferences_dialog_path_format_ref (gpointer instance) {
	PreferencesDialogPathFormat * self;
	self = instance;
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_atomic_int_inc (&self->ref_count);
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	return instance;
#line 3044 "Preferences.c"
}


static void preferences_dialog_path_format_unref (gpointer instance) {
	PreferencesDialogPathFormat * self;
	self = instance;
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		PREFERENCES_DIALOG_PATH_FORMAT_GET_CLASS (self)->finalize (self);
#line 10 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3057 "Preferences.c"
	}
}


static void preferences_dialog_class_init (PreferencesDialogClass * klass) {
	gint PreferencesDialog_private_offset;
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	preferences_dialog_parent_class = g_type_class_peek_parent (klass);
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_type_class_add_private (klass, sizeof (PreferencesDialogPrivate));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	((GtkWidgetClass *) klass)->map_event = (gboolean (*) (GtkWidget *, GdkEventAny*)) preferences_dialog_real_map_event;
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	G_OBJECT_CLASS (klass)->finalize = preferences_dialog_finalize;
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	PreferencesDialog_private_offset = g_type_class_get_instance_private_offset (klass);
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Shotwell/ui/preferences_dialog.ui");
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "bg_color_adjustment", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, bg_color_adjustment));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "bg_color_slider", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, bg_color_slider));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "photo_editor_combo", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, photo_editor_combo));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "raw_editor_combo", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, raw_editor_combo));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "library_dir_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, library_dir_button));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "dir_pattern_combo", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, dir_pattern_combo));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "dir_pattern_entry", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, dir_pattern_entry));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "dir_pattern_example", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, dir_pattern_example));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "lowercase", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, lowercase));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "default_raw_developer_combo", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, default_raw_developer_combo));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "autoimport", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, autoimport));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "write_metadata", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, write_metadata));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "pattern_help", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, pattern_help));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "preferences_notebook", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, preferences_notebook));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "transparent_checker_radio", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, transparent_checker_radio));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "transparent_solid_radio", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, transparent_solid_radio));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "transparent_solid_color", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, transparent_solid_color));
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "transparent_none_radio", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, transparent_none_radio));
#line 3112 "Preferences.c"
}


static void preferences_dialog_instance_init (PreferencesDialog * self) {
	GeeArrayList* _tmp0_;
	GDateTime* _tmp1_;
	PluginsManifestWidgetMediator* _tmp2_;
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self->priv = PREFERENCES_DIALOG_GET_PRIVATE (self);
#line 39 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self->priv->allow_closing = FALSE;
#line 40 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self->priv->lib_dir = NULL;
#line 41 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp0_ = gee_array_list_new (PREFERENCES_DIALOG_TYPE_PATH_FORMAT, (GBoxedCopyFunc) preferences_dialog_path_format_ref, (GDestroyNotify) preferences_dialog_path_format_unref, NULL, NULL, NULL);
#line 41 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self->priv->path_formats = _tmp0_;
#line 42 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp1_ = g_date_time_new_local (2009, 3, 10, 18, 16, (gdouble) 11);
#line 42 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self->priv->example_date = _tmp1_;
#line 45 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_tmp2_ = plugins_manifest_widget_mediator_new ();
#line 45 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	g_object_ref_sink (_tmp2_);
#line 45 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self->priv->plugins_mediator = _tmp2_;
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 3142 "Preferences.c"
}


static void preferences_dialog_finalize (GObject * obj) {
	PreferencesDialog * self;
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PREFERENCES_DIALOG, PreferencesDialog);
#line 22 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->bg_color_adjustment);
#line 24 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->bg_color_slider);
#line 26 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->photo_editor_combo);
#line 28 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->raw_editor_combo);
#line 29 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->external_raw_apps);
#line 30 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->external_photo_apps);
#line 32 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->library_dir_button);
#line 34 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->dir_pattern_combo);
#line 36 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->dir_pattern_entry);
#line 38 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->dir_pattern_example);
#line 40 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_free0 (self->priv->lib_dir);
#line 41 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->path_formats);
#line 42 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_date_time_unref0 (self->priv->example_date);
#line 44 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->lowercase);
#line 45 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->plugins_mediator);
#line 47 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->default_raw_developer_combo);
#line 50 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->autoimport);
#line 52 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->write_metadata);
#line 54 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->pattern_help);
#line 56 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->preferences_notebook);
#line 59 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->transparent_checker_radio);
#line 61 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->transparent_solid_radio);
#line 63 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->transparent_solid_color);
#line 65 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	_g_object_unref0 (self->priv->transparent_none_radio);
#line 9 "/home/jens/Source/shotwell/src/dialogs/Preferences.vala"
	G_OBJECT_CLASS (preferences_dialog_parent_class)->finalize (obj);
#line 3200 "Preferences.c"
}


GType preferences_dialog_get_type (void) {
	static volatile gsize preferences_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&preferences_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PreferencesDialog), 0, (GInstanceInitFunc) preferences_dialog_instance_init, NULL };
		GType preferences_dialog_type_id;
		preferences_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "PreferencesDialog", &g_define_type_info, 0);
		g_once_init_leave (&preferences_dialog_type_id__volatile, preferences_dialog_type_id);
	}
	return preferences_dialog_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



