/* misc.c generated by valac 0.34.7, the Vala compiler
 * generated from misc.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>

#define _g_checksum_free0(var) ((var == NULL) ? NULL : (var = (g_checksum_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_PHOTO_ID (photo_id_get_type ())
typedef struct _PhotoID PhotoID;

#define TYPE_MEDIA_COLLECTION_REGISTRY (media_collection_registry_get_type ())
#define MEDIA_COLLECTION_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_COLLECTION_REGISTRY, MediaCollectionRegistry))
#define MEDIA_COLLECTION_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_COLLECTION_REGISTRY, MediaCollectionRegistryClass))
#define IS_MEDIA_COLLECTION_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_COLLECTION_REGISTRY))
#define IS_MEDIA_COLLECTION_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_COLLECTION_REGISTRY))
#define MEDIA_COLLECTION_REGISTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_COLLECTION_REGISTRY, MediaCollectionRegistryClass))

typedef struct _MediaCollectionRegistry MediaCollectionRegistry;
typedef struct _MediaCollectionRegistryClass MediaCollectionRegistryClass;
#define _media_collection_registry_unref0(var) ((var == NULL) ? NULL : (var = (media_collection_registry_unref (var), NULL)))

#define TYPE_ONE_SHOT_SCHEDULER (one_shot_scheduler_get_type ())
#define ONE_SHOT_SCHEDULER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ONE_SHOT_SCHEDULER, OneShotScheduler))
#define ONE_SHOT_SCHEDULER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ONE_SHOT_SCHEDULER, OneShotSchedulerClass))
#define IS_ONE_SHOT_SCHEDULER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ONE_SHOT_SCHEDULER))
#define IS_ONE_SHOT_SCHEDULER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ONE_SHOT_SCHEDULER))
#define ONE_SHOT_SCHEDULER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ONE_SHOT_SCHEDULER, OneShotSchedulerClass))

typedef struct _OneShotScheduler OneShotScheduler;
typedef struct _OneShotSchedulerClass OneShotSchedulerClass;
typedef struct _OneShotSchedulerPrivate OneShotSchedulerPrivate;
typedef struct _ParamSpecOneShotScheduler ParamSpecOneShotScheduler;

#define TYPE_OP_TIMER (op_timer_get_type ())
#define OP_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_OP_TIMER, OpTimer))
#define OP_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_OP_TIMER, OpTimerClass))
#define IS_OP_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_OP_TIMER))
#define IS_OP_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_OP_TIMER))
#define OP_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_OP_TIMER, OpTimerClass))

typedef struct _OpTimer OpTimer;
typedef struct _OpTimerClass OpTimerClass;
typedef struct _OpTimerPrivate OpTimerPrivate;
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
typedef struct _ParamSpecOpTimer ParamSpecOpTimer;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef gboolean (*ValueEqualFunc) (GValue* a, GValue* b, void* user_data);
struct _PhotoID {
	gint64 id;
};

typedef void (*OneShotCallback) (void* user_data);
struct _OneShotScheduler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	OneShotSchedulerPrivate * priv;
};

struct _OneShotSchedulerClass {
	GTypeClass parent_class;
	void (*finalize) (OneShotScheduler *self);
};

struct _OneShotSchedulerPrivate {
	gchar* name;
	OneShotCallback callback;
	gpointer callback_target;
	guint scheduled;
};

struct _ParamSpecOneShotScheduler {
	GParamSpec parent_instance;
};

struct _OpTimer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	OpTimerPrivate * priv;
};

struct _OpTimerClass {
	GTypeClass parent_class;
	void (*finalize) (OpTimer *self);
};

struct _OpTimerPrivate {
	gchar* name;
	GTimer* timer;
	glong count;
	gdouble elapsed;
	gdouble shortest;
	gdouble longest;
};

struct _ParamSpecOpTimer {
	GParamSpec parent_instance;
};


static gpointer one_shot_scheduler_parent_class = NULL;
static gpointer op_timer_parent_class = NULL;

guint int64_hash (gint64* n);
gboolean int64_equal (gint64* a, gint64* b);
gint int64_compare (gint64* a, gint64* b);
gint uint64_compare (guint64* a, guint64* b);
gboolean bool_value_equals (GValue* a, GValue* b);
gboolean int_value_equals (GValue* a, GValue* b);
gulong timeval_to_ms (GTimeVal* time_val);
gulong now_ms (void);
gulong now_sec (void);
time_t now_time_t (void);
gchar* md5_binary (guint8* buffer, gsize length);
gchar* md5_file (GFile* file, GError** error);
gboolean equal_sets (GeeSet* a, GeeSet* b);
GeeSet* intersection_of_sets (GeeSet* a, GeeSet* b, GeeSet* excluded);
GType data_object_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
GType photo_source_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
guchar* serialize_photo_ids (GeeCollection* photos, int* result_length1);
GType photo_id_get_type (void) G_GNUC_CONST;
PhotoID* photo_id_dup (const PhotoID* self);
void photo_id_free (PhotoID* self);
void photo_get_photo_id (Photo* self, PhotoID* result);
GeeList* unserialize_photo_ids (guchar* serialized, gint size);
void photo_id_init (PhotoID *self, gint64 id);
guchar* serialize_media_sources (GeeCollection* media, int* result_length1);
gchar* data_source_get_source_id (DataSource* self);
GeeList* unserialize_media_sources (guchar* serialized, gint size);
gpointer media_collection_registry_ref (gpointer instance);
void media_collection_registry_unref (gpointer instance);
GParamSpec* param_spec_media_collection_registry (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_media_collection_registry (GValue* value, gpointer v_object);
void value_take_media_collection_registry (GValue* value, gpointer v_object);
gpointer value_get_media_collection_registry (const GValue* value);
GType media_collection_registry_get_type (void) G_GNUC_CONST;
MediaCollectionRegistry* media_collection_registry_get_instance (void);
MediaSource* media_collection_registry_fetch_media (MediaCollectionRegistry* self, const gchar* source_id);
gchar* format_local_datespan (struct tm* from_date, struct tm* to_date);
gchar* resources_get_start_multiday_span_format_string (void);
gchar* resources_get_end_multiday_span_format_string (void);
gchar* resources_get_start_multimonth_span_format_string (void);
gchar* resources_get_end_multimonth_span_format_string (void);
gchar* resources_get_long_date_format_string (void);
gchar* string_strip_leading_zeroes (const gchar* str);
gchar* format_local_date (struct tm* date);
gpointer one_shot_scheduler_ref (gpointer instance);
void one_shot_scheduler_unref (gpointer instance);
GParamSpec* param_spec_one_shot_scheduler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_one_shot_scheduler (GValue* value, gpointer v_object);
void value_take_one_shot_scheduler (GValue* value, gpointer v_object);
gpointer value_get_one_shot_scheduler (const GValue* value);
GType one_shot_scheduler_get_type (void) G_GNUC_CONST;
#define ONE_SHOT_SCHEDULER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ONE_SHOT_SCHEDULER, OneShotSchedulerPrivate))
enum  {
	ONE_SHOT_SCHEDULER_DUMMY_PROPERTY
};
void one_shot_scheduler_cancel (OneShotScheduler* self);
OneShotScheduler* one_shot_scheduler_new (const gchar* name, OneShotCallback callback, void* callback_target);
OneShotScheduler* one_shot_scheduler_construct (GType object_type, const gchar* name, OneShotCallback callback, void* callback_target);
gboolean one_shot_scheduler_is_scheduled (OneShotScheduler* self);
void one_shot_scheduler_at_idle (OneShotScheduler* self);
void one_shot_scheduler_at_priority_idle (OneShotScheduler* self, gint priority);
static gboolean one_shot_scheduler_callback_wrapper (OneShotScheduler* self);
static gboolean _one_shot_scheduler_callback_wrapper_gsource_func (gpointer self);
void one_shot_scheduler_after_timeout (OneShotScheduler* self, guint msec, gboolean reschedule);
void one_shot_scheduler_priority_after_timeout (OneShotScheduler* self, gint priority, guint msec, gboolean reschedule);
static void one_shot_scheduler_finalize (OneShotScheduler* obj);
gpointer op_timer_ref (gpointer instance);
void op_timer_unref (gpointer instance);
GParamSpec* param_spec_op_timer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_op_timer (GValue* value, gpointer v_object);
void value_take_op_timer (GValue* value, gpointer v_object);
gpointer value_get_op_timer (const GValue* value);
GType op_timer_get_type (void) G_GNUC_CONST;
#define OP_TIMER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_OP_TIMER, OpTimerPrivate))
enum  {
	OP_TIMER_DUMMY_PROPERTY
};
OpTimer* op_timer_new (const gchar* name);
OpTimer* op_timer_construct (GType object_type, const gchar* name);
void op_timer_start (OpTimer* self);
void op_timer_stop (OpTimer* self);
gchar* op_timer_to_string (OpTimer* self);
static void op_timer_finalize (OpTimer* obj);
void suppress_warnings (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message);
gboolean is_twentyfour_hr_time_system (void);
gboolean is_string_empty (const gchar* s);


guint int64_hash (gint64* n) {
	guint result = 0U;
	guint8* u8 = NULL;
	gint64* _tmp0_ = NULL;
	guint hash = 0U;
#line 9 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = n;
#line 9 "/home/jens/Source/shotwell/src/util/misc.vala"
	u8 = (guint8*) _tmp0_;
#line 10 "/home/jens/Source/shotwell/src/util/misc.vala"
	hash = (guint) 0;
#line 289 "misc.c"
	{
		gint ctr = 0;
#line 11 "/home/jens/Source/shotwell/src/util/misc.vala"
		ctr = 0;
#line 294 "misc.c"
		{
			gboolean _tmp1_ = FALSE;
#line 11 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp1_ = TRUE;
#line 11 "/home/jens/Source/shotwell/src/util/misc.vala"
			while (TRUE) {
#line 301 "misc.c"
				gint _tmp3_ = 0;
				guint _tmp4_ = 0U;
				guint _tmp5_ = 0U;
				guint8* _tmp6_ = NULL;
#line 11 "/home/jens/Source/shotwell/src/util/misc.vala"
				if (!_tmp1_) {
#line 308 "misc.c"
					gint _tmp2_ = 0;
#line 11 "/home/jens/Source/shotwell/src/util/misc.vala"
					_tmp2_ = ctr;
#line 11 "/home/jens/Source/shotwell/src/util/misc.vala"
					ctr = _tmp2_ + 1;
#line 314 "misc.c"
				}
#line 11 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp1_ = FALSE;
#line 11 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp3_ = ctr;
#line 11 "/home/jens/Source/shotwell/src/util/misc.vala"
				if (!(((gulong) _tmp3_) < (sizeof (gint64) / sizeof (guint8)))) {
#line 11 "/home/jens/Source/shotwell/src/util/misc.vala"
					break;
#line 324 "misc.c"
				}
#line 12 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp4_ = hash;
#line 12 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp5_ = hash;
#line 12 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp6_ = u8;
#line 12 "/home/jens/Source/shotwell/src/util/misc.vala"
				u8 = _tmp6_ + 1;
#line 12 "/home/jens/Source/shotwell/src/util/misc.vala"
				hash = ((_tmp4_ << 4) ^ (_tmp5_ >> 28)) ^ (*_tmp6_);
#line 336 "misc.c"
			}
		}
	}
#line 15 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = hash;
#line 15 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 344 "misc.c"
}


gboolean int64_equal (gint64* a, gint64* b) {
	gboolean result = FALSE;
	gint64* bia = NULL;
	gint64* _tmp0_ = NULL;
	gint64* bib = NULL;
	gint64* _tmp1_ = NULL;
#line 19 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = a;
#line 19 "/home/jens/Source/shotwell/src/util/misc.vala"
	bia = (gint64*) _tmp0_;
#line 20 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = b;
#line 20 "/home/jens/Source/shotwell/src/util/misc.vala"
	bib = (gint64*) _tmp1_;
#line 22 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = (*bia) == (*bib);
#line 22 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 366 "misc.c"
}


gint int64_compare (gint64* a, gint64* b) {
	gint result = 0;
	gint64 diff = 0LL;
	gint64* _tmp0_ = NULL;
	gint64* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
#line 26 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = a;
#line 26 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = b;
#line 26 "/home/jens/Source/shotwell/src/util/misc.vala"
	diff = (*((gint64*) _tmp0_)) - (*((gint64*) _tmp1_));
#line 27 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp2_ = diff;
#line 27 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp2_ < ((gint64) 0)) {
#line 28 "/home/jens/Source/shotwell/src/util/misc.vala"
		result = -1;
#line 28 "/home/jens/Source/shotwell/src/util/misc.vala"
		return result;
#line 390 "misc.c"
	} else {
		gint64 _tmp3_ = 0LL;
#line 29 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp3_ = diff;
#line 29 "/home/jens/Source/shotwell/src/util/misc.vala"
		if (_tmp3_ > ((gint64) 0)) {
#line 30 "/home/jens/Source/shotwell/src/util/misc.vala"
			result = 1;
#line 30 "/home/jens/Source/shotwell/src/util/misc.vala"
			return result;
#line 401 "misc.c"
		} else {
#line 32 "/home/jens/Source/shotwell/src/util/misc.vala"
			result = 0;
#line 32 "/home/jens/Source/shotwell/src/util/misc.vala"
			return result;
#line 407 "misc.c"
		}
	}
}


gint uint64_compare (guint64* a, guint64* b) {
	gint result = 0;
	guint64 a64 = 0ULL;
	guint64* _tmp0_ = NULL;
	guint64 b64 = 0ULL;
	guint64* _tmp1_ = NULL;
	guint64 _tmp2_ = 0ULL;
	guint64 _tmp3_ = 0ULL;
#line 36 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = a;
#line 36 "/home/jens/Source/shotwell/src/util/misc.vala"
	a64 = *((guint64*) _tmp0_);
#line 37 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = b;
#line 37 "/home/jens/Source/shotwell/src/util/misc.vala"
	b64 = *((guint64*) _tmp1_);
#line 39 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp2_ = a64;
#line 39 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp3_ = b64;
#line 39 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp2_ < _tmp3_) {
#line 40 "/home/jens/Source/shotwell/src/util/misc.vala"
		result = -1;
#line 40 "/home/jens/Source/shotwell/src/util/misc.vala"
		return result;
#line 439 "misc.c"
	} else {
		guint64 _tmp4_ = 0ULL;
		guint64 _tmp5_ = 0ULL;
#line 41 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp4_ = a64;
#line 41 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp5_ = b64;
#line 41 "/home/jens/Source/shotwell/src/util/misc.vala"
		if (_tmp4_ > _tmp5_) {
#line 42 "/home/jens/Source/shotwell/src/util/misc.vala"
			result = 1;
#line 42 "/home/jens/Source/shotwell/src/util/misc.vala"
			return result;
#line 453 "misc.c"
		} else {
#line 44 "/home/jens/Source/shotwell/src/util/misc.vala"
			result = 0;
#line 44 "/home/jens/Source/shotwell/src/util/misc.vala"
			return result;
#line 459 "misc.c"
		}
	}
}


gboolean bool_value_equals (GValue* a, GValue* b) {
	gboolean result = FALSE;
	GValue _tmp0_ = {0};
	GValue _tmp1_ = {0};
#line 49 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (a != NULL, FALSE);
#line 49 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (b != NULL, FALSE);
#line 50 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = *a;
#line 50 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = *b;
#line 50 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = g_value_get_boolean (&_tmp0_) == g_value_get_boolean (&_tmp1_);
#line 50 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 481 "misc.c"
}


gboolean int_value_equals (GValue* a, GValue* b) {
	gboolean result = FALSE;
	GValue _tmp0_ = {0};
	GValue _tmp1_ = {0};
#line 53 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (a != NULL, FALSE);
#line 53 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (b != NULL, FALSE);
#line 54 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = *a;
#line 54 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = *b;
#line 54 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = g_value_get_int (&_tmp0_) == g_value_get_int (&_tmp1_);
#line 54 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 501 "misc.c"
}


gulong timeval_to_ms (GTimeVal* time_val) {
	gulong result = 0UL;
	GTimeVal _tmp0_ = {0};
	glong _tmp1_ = 0L;
	GTimeVal _tmp2_ = {0};
	glong _tmp3_ = 0L;
#line 57 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (time_val != NULL, 0UL);
#line 58 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = *time_val;
#line 58 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = _tmp0_.tv_sec;
#line 58 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp2_ = *time_val;
#line 58 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp3_ = _tmp2_.tv_usec;
#line 58 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = (((gulong) _tmp1_) * 1000) + (((gulong) _tmp3_) / 1000);
#line 58 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 525 "misc.c"
}


gulong now_ms (void) {
	gulong result = 0UL;
	GTimeVal _tmp0_ = {0};
	gulong _tmp1_ = 0UL;
#line 62 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_get_current_time (&_tmp0_);
#line 62 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = timeval_to_ms (&_tmp0_);
#line 62 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = _tmp1_;
#line 62 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 541 "misc.c"
}


gulong now_sec (void) {
	gulong result = 0UL;
	GTimeVal time_val = {0};
	GTimeVal _tmp0_ = {0};
	glong _tmp1_ = 0L;
#line 66 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_get_current_time (&time_val);
#line 68 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = time_val;
#line 68 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = _tmp0_.tv_sec;
#line 68 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = (gulong) _tmp1_;
#line 68 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 560 "misc.c"
}


inline time_t now_time_t (void) {
	time_t result = 0;
	gulong _tmp0_ = 0UL;
#line 72 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = now_sec ();
#line 72 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = (time_t) _tmp0_;
#line 72 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 573 "misc.c"
}


gchar* md5_binary (guint8* buffer, gsize length) {
	gchar* result = NULL;
	gsize _tmp0_ = 0UL;
	GChecksum* md5 = NULL;
	GChecksum* _tmp1_ = NULL;
	guint8* _tmp2_ = NULL;
	gsize _tmp3_ = 0UL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
#line 76 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = length;
#line 76 "/home/jens/Source/shotwell/src/util/misc.vala"
	_vala_assert (_tmp0_ != ((gsize) 0), "length != 0");
#line 78 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = g_checksum_new (G_CHECKSUM_MD5);
#line 78 "/home/jens/Source/shotwell/src/util/misc.vala"
	md5 = _tmp1_;
#line 79 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp2_ = buffer;
#line 79 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp3_ = length;
#line 79 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_checksum_update (md5, (guchar*) _tmp2_, _tmp3_);
#line 81 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp4_ = g_checksum_get_string (md5);
#line 81 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 81 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = _tmp5_;
#line 81 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_checksum_free0 (md5);
#line 81 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 610 "misc.c"
}


gchar* md5_file (GFile* file, GError** error) {
	gchar* result = NULL;
	GChecksum* md5 = NULL;
	GChecksum* _tmp0_ = NULL;
	guint8* buffer = NULL;
	guint8* _tmp1_ = NULL;
	gint buffer_length1 = 0;
	gint _buffer_size_ = 0;
	GFileInputStream* fins = NULL;
	GFile* _tmp2_ = NULL;
	GFileInputStream* _tmp3_ = NULL;
	GChecksum* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	GError * _inner_error_ = NULL;
#line 84 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 85 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = g_checksum_new (G_CHECKSUM_MD5);
#line 85 "/home/jens/Source/shotwell/src/util/misc.vala"
	md5 = _tmp0_;
#line 86 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = g_new0 (guint8, 64 * 1024);
#line 86 "/home/jens/Source/shotwell/src/util/misc.vala"
	buffer = _tmp1_;
#line 86 "/home/jens/Source/shotwell/src/util/misc.vala"
	buffer_length1 = 64 * 1024;
#line 86 "/home/jens/Source/shotwell/src/util/misc.vala"
	_buffer_size_ = buffer_length1;
#line 88 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp2_ = file;
#line 88 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp3_ = g_file_read (_tmp2_, NULL, &_inner_error_);
#line 88 "/home/jens/Source/shotwell/src/util/misc.vala"
	fins = _tmp3_;
#line 88 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 88 "/home/jens/Source/shotwell/src/util/misc.vala"
		g_propagate_error (error, _inner_error_);
#line 88 "/home/jens/Source/shotwell/src/util/misc.vala"
		buffer = (g_free (buffer), NULL);
#line 88 "/home/jens/Source/shotwell/src/util/misc.vala"
		_g_checksum_free0 (md5);
#line 88 "/home/jens/Source/shotwell/src/util/misc.vala"
		return NULL;
#line 659 "misc.c"
	}
	{
		gboolean _tmp4_ = FALSE;
#line 89 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp4_ = TRUE;
#line 89 "/home/jens/Source/shotwell/src/util/misc.vala"
		while (TRUE) {
#line 667 "misc.c"
			gsize bytes_read = 0UL;
			GFileInputStream* _tmp5_ = NULL;
			guint8* _tmp6_ = NULL;
			gint _tmp6__length1 = 0;
			gssize _tmp7_ = 0L;
			gsize _tmp8_ = 0UL;
			GChecksum* _tmp9_ = NULL;
			guint8* _tmp10_ = NULL;
			gint _tmp10__length1 = 0;
			gsize _tmp11_ = 0UL;
#line 89 "/home/jens/Source/shotwell/src/util/misc.vala"
			if (!_tmp4_) {
#line 680 "misc.c"
			}
#line 89 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp4_ = FALSE;
#line 90 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp5_ = fins;
#line 90 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp6_ = buffer;
#line 90 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp6__length1 = buffer_length1;
#line 90 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp7_ = g_input_stream_read (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_input_stream_get_type (), GInputStream), _tmp6_, (gsize) _tmp6__length1, NULL, &_inner_error_);
#line 90 "/home/jens/Source/shotwell/src/util/misc.vala"
			bytes_read = (gsize) _tmp7_;
#line 90 "/home/jens/Source/shotwell/src/util/misc.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 90 "/home/jens/Source/shotwell/src/util/misc.vala"
				g_propagate_error (error, _inner_error_);
#line 90 "/home/jens/Source/shotwell/src/util/misc.vala"
				_g_object_unref0 (fins);
#line 90 "/home/jens/Source/shotwell/src/util/misc.vala"
				buffer = (g_free (buffer), NULL);
#line 90 "/home/jens/Source/shotwell/src/util/misc.vala"
				_g_checksum_free0 (md5);
#line 90 "/home/jens/Source/shotwell/src/util/misc.vala"
				return NULL;
#line 706 "misc.c"
			}
#line 91 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp8_ = bytes_read;
#line 91 "/home/jens/Source/shotwell/src/util/misc.vala"
			if (_tmp8_ <= ((gsize) 0)) {
#line 92 "/home/jens/Source/shotwell/src/util/misc.vala"
				break;
#line 714 "misc.c"
			}
#line 94 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp9_ = md5;
#line 94 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp10_ = buffer;
#line 94 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp10__length1 = buffer_length1;
#line 94 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp11_ = bytes_read;
#line 94 "/home/jens/Source/shotwell/src/util/misc.vala"
			g_checksum_update (_tmp9_, (guchar*) _tmp10_, _tmp11_);
#line 726 "misc.c"
		}
	}
	{
		GFileInputStream* _tmp12_ = NULL;
#line 98 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp12_ = fins;
#line 98 "/home/jens/Source/shotwell/src/util/misc.vala"
		g_input_stream_close (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, g_input_stream_get_type (), GInputStream), NULL, &_inner_error_);
#line 98 "/home/jens/Source/shotwell/src/util/misc.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 737 "misc.c"
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* err = NULL;
		GFile* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		GError* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
#line 97 "/home/jens/Source/shotwell/src/util/misc.vala"
		err = _inner_error_;
#line 97 "/home/jens/Source/shotwell/src/util/misc.vala"
		_inner_error_ = NULL;
#line 100 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp13_ = file;
#line 100 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp14_ = g_file_get_path (_tmp13_);
#line 100 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp15_ = _tmp14_;
#line 100 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp16_ = err;
#line 100 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp17_ = _tmp16_->message;
#line 100 "/home/jens/Source/shotwell/src/util/misc.vala"
		g_warning ("misc.vala:100: Unable to close MD5 input stream for %s: %s", _tmp15_, _tmp17_);
#line 100 "/home/jens/Source/shotwell/src/util/misc.vala"
		_g_free0 (_tmp15_);
#line 97 "/home/jens/Source/shotwell/src/util/misc.vala"
		_g_error_free0 (err);
#line 770 "misc.c"
	}
	__finally5:
#line 97 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 97 "/home/jens/Source/shotwell/src/util/misc.vala"
		g_propagate_error (error, _inner_error_);
#line 97 "/home/jens/Source/shotwell/src/util/misc.vala"
		_g_object_unref0 (fins);
#line 97 "/home/jens/Source/shotwell/src/util/misc.vala"
		buffer = (g_free (buffer), NULL);
#line 97 "/home/jens/Source/shotwell/src/util/misc.vala"
		_g_checksum_free0 (md5);
#line 97 "/home/jens/Source/shotwell/src/util/misc.vala"
		return NULL;
#line 785 "misc.c"
	}
#line 103 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp18_ = md5;
#line 103 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp19_ = g_checksum_get_string (_tmp18_);
#line 103 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp20_ = g_strdup (_tmp19_);
#line 103 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = _tmp20_;
#line 103 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_object_unref0 (fins);
#line 103 "/home/jens/Source/shotwell/src/util/misc.vala"
	buffer = (g_free (buffer), NULL);
#line 103 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_checksum_free0 (md5);
#line 103 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 803 "misc.c"
}


gboolean equal_sets (GeeSet* a, GeeSet* b) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GeeSet* _tmp2_ = NULL;
	gboolean _tmp7_ = FALSE;
	GeeSet* _tmp8_ = NULL;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	GeeSet* _tmp16_ = NULL;
	gboolean _tmp21_ = FALSE;
	GeeSet* _tmp22_ = NULL;
	GeeSet* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	GeeSet* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
#line 107 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail ((a == NULL) || GEE_IS_SET (a), FALSE);
#line 107 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail ((b == NULL) || GEE_IS_SET (b), FALSE);
#line 108 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp2_ = a;
#line 108 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp2_ != NULL) {
#line 833 "misc.c"
		GeeSet* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
#line 108 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp3_ = a;
#line 108 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp4_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
#line 108 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp5_ = _tmp4_;
#line 108 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp1_ = _tmp5_ == 0;
#line 845 "misc.c"
	} else {
#line 108 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp1_ = FALSE;
#line 849 "misc.c"
	}
#line 108 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp1_) {
#line 853 "misc.c"
		GeeSet* _tmp6_ = NULL;
#line 108 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp6_ = b;
#line 108 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp0_ = _tmp6_ == NULL;
#line 859 "misc.c"
	} else {
#line 108 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp0_ = FALSE;
#line 863 "misc.c"
	}
#line 108 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp0_) {
#line 109 "/home/jens/Source/shotwell/src/util/misc.vala"
		result = TRUE;
#line 109 "/home/jens/Source/shotwell/src/util/misc.vala"
		return result;
#line 871 "misc.c"
	}
#line 111 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp8_ = a;
#line 111 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp8_ == NULL) {
#line 877 "misc.c"
		gboolean _tmp9_ = FALSE;
		GeeSet* _tmp10_ = NULL;
#line 111 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp10_ = b;
#line 111 "/home/jens/Source/shotwell/src/util/misc.vala"
		if (_tmp10_ != NULL) {
#line 884 "misc.c"
			GeeSet* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
#line 111 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp11_ = b;
#line 111 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp12_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_COLLECTION, GeeCollection));
#line 111 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp13_ = _tmp12_;
#line 111 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp9_ = _tmp13_ == 0;
#line 896 "misc.c"
		} else {
#line 111 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp9_ = FALSE;
#line 900 "misc.c"
		}
#line 111 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp7_ = _tmp9_;
#line 904 "misc.c"
	} else {
#line 111 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp7_ = FALSE;
#line 908 "misc.c"
	}
#line 111 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp7_) {
#line 112 "/home/jens/Source/shotwell/src/util/misc.vala"
		result = TRUE;
#line 112 "/home/jens/Source/shotwell/src/util/misc.vala"
		return result;
#line 916 "misc.c"
	}
#line 114 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp16_ = a;
#line 114 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp16_ == NULL) {
#line 922 "misc.c"
		GeeSet* _tmp17_ = NULL;
#line 114 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp17_ = b;
#line 114 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp15_ = _tmp17_ != NULL;
#line 928 "misc.c"
	} else {
#line 114 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp15_ = FALSE;
#line 932 "misc.c"
	}
#line 114 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp15_) {
#line 114 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp14_ = TRUE;
#line 938 "misc.c"
	} else {
		gboolean _tmp18_ = FALSE;
		GeeSet* _tmp19_ = NULL;
#line 114 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp19_ = a;
#line 114 "/home/jens/Source/shotwell/src/util/misc.vala"
		if (_tmp19_ != NULL) {
#line 946 "misc.c"
			GeeSet* _tmp20_ = NULL;
#line 114 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp20_ = b;
#line 114 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp18_ = _tmp20_ == NULL;
#line 952 "misc.c"
		} else {
#line 114 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp18_ = FALSE;
#line 956 "misc.c"
		}
#line 114 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp14_ = _tmp18_;
#line 960 "misc.c"
	}
#line 114 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp14_) {
#line 115 "/home/jens/Source/shotwell/src/util/misc.vala"
		result = FALSE;
#line 115 "/home/jens/Source/shotwell/src/util/misc.vala"
		return result;
#line 968 "misc.c"
	}
#line 117 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp22_ = a;
#line 117 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp22_ == NULL) {
#line 974 "misc.c"
		GeeSet* _tmp23_ = NULL;
#line 117 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp23_ = b;
#line 117 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp21_ = _tmp23_ == NULL;
#line 980 "misc.c"
	} else {
#line 117 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp21_ = FALSE;
#line 984 "misc.c"
	}
#line 117 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp21_) {
#line 118 "/home/jens/Source/shotwell/src/util/misc.vala"
		result = TRUE;
#line 118 "/home/jens/Source/shotwell/src/util/misc.vala"
		return result;
#line 992 "misc.c"
	}
#line 120 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp24_ = a;
#line 120 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp25_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_COLLECTION, GeeCollection));
#line 120 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp26_ = _tmp25_;
#line 120 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp27_ = b;
#line 120 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp28_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_COLLECTION, GeeCollection));
#line 120 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp29_ = _tmp28_;
#line 120 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp26_ != _tmp29_) {
#line 121 "/home/jens/Source/shotwell/src/util/misc.vala"
		result = FALSE;
#line 121 "/home/jens/Source/shotwell/src/util/misc.vala"
		return result;
#line 1012 "misc.c"
	}
	{
		GeeIterator* _element_it = NULL;
		GeeSet* _tmp30_ = NULL;
		GeeIterator* _tmp31_ = NULL;
#line 125 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp30_ = a;
#line 125 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp31_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEE_TYPE_ITERABLE, GeeIterable));
#line 125 "/home/jens/Source/shotwell/src/util/misc.vala"
		_element_it = _tmp31_;
#line 125 "/home/jens/Source/shotwell/src/util/misc.vala"
		while (TRUE) {
#line 1026 "misc.c"
			GeeIterator* _tmp32_ = NULL;
			gboolean _tmp33_ = FALSE;
			gchar* element = NULL;
			GeeIterator* _tmp34_ = NULL;
			gpointer _tmp35_ = NULL;
			GeeSet* _tmp36_ = NULL;
			const gchar* _tmp37_ = NULL;
			gboolean _tmp38_ = FALSE;
#line 125 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp32_ = _element_it;
#line 125 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp33_ = gee_iterator_next (_tmp32_);
#line 125 "/home/jens/Source/shotwell/src/util/misc.vala"
			if (!_tmp33_) {
#line 125 "/home/jens/Source/shotwell/src/util/misc.vala"
				break;
#line 1043 "misc.c"
			}
#line 125 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp34_ = _element_it;
#line 125 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp35_ = gee_iterator_get (_tmp34_);
#line 125 "/home/jens/Source/shotwell/src/util/misc.vala"
			element = (gchar*) _tmp35_;
#line 126 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp36_ = b;
#line 126 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp37_ = element;
#line 126 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp38_ = gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, GEE_TYPE_COLLECTION, GeeCollection), _tmp37_);
#line 126 "/home/jens/Source/shotwell/src/util/misc.vala"
			if (!_tmp38_) {
#line 127 "/home/jens/Source/shotwell/src/util/misc.vala"
				result = FALSE;
#line 127 "/home/jens/Source/shotwell/src/util/misc.vala"
				_g_free0 (element);
#line 127 "/home/jens/Source/shotwell/src/util/misc.vala"
				_g_object_unref0 (_element_it);
#line 127 "/home/jens/Source/shotwell/src/util/misc.vala"
				return result;
#line 1067 "misc.c"
			}
#line 125 "/home/jens/Source/shotwell/src/util/misc.vala"
			_g_free0 (element);
#line 1071 "misc.c"
		}
#line 125 "/home/jens/Source/shotwell/src/util/misc.vala"
		_g_object_unref0 (_element_it);
#line 1075 "misc.c"
	}
#line 130 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = TRUE;
#line 130 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 1081 "misc.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 166 "/home/jens/Source/shotwell/src/util/misc.vala"
	return self ? g_object_ref (self) : NULL;
#line 1088 "misc.c"
}


GeeSet* intersection_of_sets (GeeSet* a, GeeSet* b, GeeSet* excluded) {
	GeeSet* result = NULL;
	gboolean _tmp0_ = FALSE;
	GeeSet* _tmp1_ = NULL;
	gboolean _tmp6_ = FALSE;
	GeeSet* _tmp7_ = NULL;
	GeeSet* intersection = NULL;
	GeeHashSet* _tmp12_ = NULL;
	GeeSet* _tmp41_ = NULL;
	GeeSet* _tmp42_ = NULL;
	gint _tmp43_ = 0;
	gint _tmp44_ = 0;
	GeeSet* _tmp46_ = NULL;
#line 134 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail ((a == NULL) || GEE_IS_SET (a), NULL);
#line 134 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail ((b == NULL) || GEE_IS_SET (b), NULL);
#line 134 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail ((excluded == NULL) || GEE_IS_SET (excluded), NULL);
#line 136 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = a;
#line 136 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp1_ != NULL) {
#line 1115 "misc.c"
		GeeSet* _tmp2_ = NULL;
#line 136 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp2_ = b;
#line 136 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp0_ = _tmp2_ == NULL;
#line 1121 "misc.c"
	} else {
#line 136 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp0_ = FALSE;
#line 1125 "misc.c"
	}
#line 136 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp0_) {
#line 1129 "misc.c"
		GeeSet* _tmp3_ = NULL;
#line 137 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp3_ = excluded;
#line 137 "/home/jens/Source/shotwell/src/util/misc.vala"
		if (_tmp3_ != NULL) {
#line 1135 "misc.c"
			GeeSet* _tmp4_ = NULL;
			GeeSet* _tmp5_ = NULL;
#line 138 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp4_ = excluded;
#line 138 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp5_ = a;
#line 138 "/home/jens/Source/shotwell/src/util/misc.vala"
			gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1144 "misc.c"
		}
#line 140 "/home/jens/Source/shotwell/src/util/misc.vala"
		result = NULL;
#line 140 "/home/jens/Source/shotwell/src/util/misc.vala"
		return result;
#line 1150 "misc.c"
	}
#line 143 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp7_ = a;
#line 143 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp7_ == NULL) {
#line 1156 "misc.c"
		GeeSet* _tmp8_ = NULL;
#line 143 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp8_ = b;
#line 143 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp6_ = _tmp8_ != NULL;
#line 1162 "misc.c"
	} else {
#line 143 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp6_ = FALSE;
#line 1166 "misc.c"
	}
#line 143 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp6_) {
#line 1170 "misc.c"
		GeeSet* _tmp9_ = NULL;
#line 144 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp9_ = excluded;
#line 144 "/home/jens/Source/shotwell/src/util/misc.vala"
		if (_tmp9_ != NULL) {
#line 1176 "misc.c"
			GeeSet* _tmp10_ = NULL;
			GeeSet* _tmp11_ = NULL;
#line 145 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp10_ = excluded;
#line 145 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp11_ = b;
#line 145 "/home/jens/Source/shotwell/src/util/misc.vala"
			gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1185 "misc.c"
		}
#line 147 "/home/jens/Source/shotwell/src/util/misc.vala"
		result = NULL;
#line 147 "/home/jens/Source/shotwell/src/util/misc.vala"
		return result;
#line 1191 "misc.c"
	}
#line 150 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp12_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 150 "/home/jens/Source/shotwell/src/util/misc.vala"
	intersection = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_SET, GeeSet);
#line 1197 "misc.c"
	{
		GeeIterator* _element_it = NULL;
		GeeSet* _tmp13_ = NULL;
		GeeIterator* _tmp14_ = NULL;
#line 152 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp13_ = a;
#line 152 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp14_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ITERABLE, GeeIterable));
#line 152 "/home/jens/Source/shotwell/src/util/misc.vala"
		_element_it = _tmp14_;
#line 152 "/home/jens/Source/shotwell/src/util/misc.vala"
		while (TRUE) {
#line 1210 "misc.c"
			GeeIterator* _tmp15_ = NULL;
			gboolean _tmp16_ = FALSE;
			gchar* element = NULL;
			GeeIterator* _tmp17_ = NULL;
			gpointer _tmp18_ = NULL;
			GeeSet* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			gboolean _tmp21_ = FALSE;
#line 152 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp15_ = _element_it;
#line 152 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp16_ = gee_iterator_next (_tmp15_);
#line 152 "/home/jens/Source/shotwell/src/util/misc.vala"
			if (!_tmp16_) {
#line 152 "/home/jens/Source/shotwell/src/util/misc.vala"
				break;
#line 1227 "misc.c"
			}
#line 152 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp17_ = _element_it;
#line 152 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp18_ = gee_iterator_get (_tmp17_);
#line 152 "/home/jens/Source/shotwell/src/util/misc.vala"
			element = (gchar*) _tmp18_;
#line 153 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp19_ = b;
#line 153 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp20_ = element;
#line 153 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp21_ = gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_COLLECTION, GeeCollection), _tmp20_);
#line 153 "/home/jens/Source/shotwell/src/util/misc.vala"
			if (_tmp21_) {
#line 1243 "misc.c"
				GeeSet* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
#line 154 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp22_ = intersection;
#line 154 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp23_ = element;
#line 154 "/home/jens/Source/shotwell/src/util/misc.vala"
				gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_COLLECTION, GeeCollection), _tmp23_);
#line 1252 "misc.c"
			} else {
				GeeSet* _tmp24_ = NULL;
#line 155 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp24_ = excluded;
#line 155 "/home/jens/Source/shotwell/src/util/misc.vala"
				if (_tmp24_ != NULL) {
#line 1259 "misc.c"
					GeeSet* _tmp25_ = NULL;
					const gchar* _tmp26_ = NULL;
#line 156 "/home/jens/Source/shotwell/src/util/misc.vala"
					_tmp25_ = excluded;
#line 156 "/home/jens/Source/shotwell/src/util/misc.vala"
					_tmp26_ = element;
#line 156 "/home/jens/Source/shotwell/src/util/misc.vala"
					gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_COLLECTION, GeeCollection), _tmp26_);
#line 1268 "misc.c"
				}
			}
#line 152 "/home/jens/Source/shotwell/src/util/misc.vala"
			_g_free0 (element);
#line 1273 "misc.c"
		}
#line 152 "/home/jens/Source/shotwell/src/util/misc.vala"
		_g_object_unref0 (_element_it);
#line 1277 "misc.c"
	}
	{
		GeeIterator* _element_it = NULL;
		GeeSet* _tmp27_ = NULL;
		GeeIterator* _tmp28_ = NULL;
#line 159 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp27_ = b;
#line 159 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp28_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_ITERABLE, GeeIterable));
#line 159 "/home/jens/Source/shotwell/src/util/misc.vala"
		_element_it = _tmp28_;
#line 159 "/home/jens/Source/shotwell/src/util/misc.vala"
		while (TRUE) {
#line 1291 "misc.c"
			GeeIterator* _tmp29_ = NULL;
			gboolean _tmp30_ = FALSE;
			gchar* element = NULL;
			GeeIterator* _tmp31_ = NULL;
			gpointer _tmp32_ = NULL;
			GeeSet* _tmp33_ = NULL;
			const gchar* _tmp34_ = NULL;
			gboolean _tmp35_ = FALSE;
#line 159 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp29_ = _element_it;
#line 159 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp30_ = gee_iterator_next (_tmp29_);
#line 159 "/home/jens/Source/shotwell/src/util/misc.vala"
			if (!_tmp30_) {
#line 159 "/home/jens/Source/shotwell/src/util/misc.vala"
				break;
#line 1308 "misc.c"
			}
#line 159 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp31_ = _element_it;
#line 159 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp32_ = gee_iterator_get (_tmp31_);
#line 159 "/home/jens/Source/shotwell/src/util/misc.vala"
			element = (gchar*) _tmp32_;
#line 160 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp33_ = a;
#line 160 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp34_ = element;
#line 160 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp35_ = gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, GEE_TYPE_COLLECTION, GeeCollection), _tmp34_);
#line 160 "/home/jens/Source/shotwell/src/util/misc.vala"
			if (_tmp35_) {
#line 1324 "misc.c"
				GeeSet* _tmp36_ = NULL;
				const gchar* _tmp37_ = NULL;
#line 161 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp36_ = intersection;
#line 161 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp37_ = element;
#line 161 "/home/jens/Source/shotwell/src/util/misc.vala"
				gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, GEE_TYPE_COLLECTION, GeeCollection), _tmp37_);
#line 1333 "misc.c"
			} else {
				GeeSet* _tmp38_ = NULL;
#line 162 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp38_ = excluded;
#line 162 "/home/jens/Source/shotwell/src/util/misc.vala"
				if (_tmp38_ != NULL) {
#line 1340 "misc.c"
					GeeSet* _tmp39_ = NULL;
					const gchar* _tmp40_ = NULL;
#line 163 "/home/jens/Source/shotwell/src/util/misc.vala"
					_tmp39_ = excluded;
#line 163 "/home/jens/Source/shotwell/src/util/misc.vala"
					_tmp40_ = element;
#line 163 "/home/jens/Source/shotwell/src/util/misc.vala"
					gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, GEE_TYPE_COLLECTION, GeeCollection), _tmp40_);
#line 1349 "misc.c"
				}
			}
#line 159 "/home/jens/Source/shotwell/src/util/misc.vala"
			_g_free0 (element);
#line 1354 "misc.c"
		}
#line 159 "/home/jens/Source/shotwell/src/util/misc.vala"
		_g_object_unref0 (_element_it);
#line 1358 "misc.c"
	}
#line 166 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp42_ = intersection;
#line 166 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp43_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, GEE_TYPE_COLLECTION, GeeCollection));
#line 166 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp44_ = _tmp43_;
#line 166 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp44_ > 0) {
#line 1368 "misc.c"
		GeeSet* _tmp45_ = NULL;
#line 166 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp45_ = intersection;
#line 166 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp41_ = _tmp45_;
#line 1374 "misc.c"
	} else {
#line 166 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp41_ = NULL;
#line 1378 "misc.c"
	}
#line 166 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp46_ = _g_object_ref0 (_tmp41_);
#line 166 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = _tmp46_;
#line 166 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_object_unref0 (intersection);
#line 166 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 1388 "misc.c"
}


guchar* serialize_photo_ids (GeeCollection* photos, int* result_length1) {
	guchar* result = NULL;
	gint64* ids = NULL;
	GeeCollection* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint64* _tmp3_ = NULL;
	gint ids_length1 = 0;
	gint _ids_size_ = 0;
	gint ctr = 0;
	gsize bytes = 0UL;
	GeeCollection* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	guchar* serialized = NULL;
	guchar* _tmp19_ = NULL;
	gint serialized_length1 = 0;
	gint _serialized_size_ = 0;
	gint64* _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	guchar* _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
#line 169 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (photos), NULL);
#line 170 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = photos;
#line 170 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 170 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp2_ = _tmp1_;
#line 170 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp3_ = g_new0 (gint64, _tmp2_);
#line 170 "/home/jens/Source/shotwell/src/util/misc.vala"
	ids = _tmp3_;
#line 170 "/home/jens/Source/shotwell/src/util/misc.vala"
	ids_length1 = _tmp2_;
#line 170 "/home/jens/Source/shotwell/src/util/misc.vala"
	_ids_size_ = ids_length1;
#line 171 "/home/jens/Source/shotwell/src/util/misc.vala"
	ctr = 0;
#line 1432 "misc.c"
	{
		GeeIterator* _photo_it = NULL;
		GeeCollection* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 172 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp4_ = photos;
#line 172 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp5_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ITERABLE, GeeIterable));
#line 172 "/home/jens/Source/shotwell/src/util/misc.vala"
		_photo_it = _tmp5_;
#line 172 "/home/jens/Source/shotwell/src/util/misc.vala"
		while (TRUE) {
#line 1445 "misc.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			Photo* photo = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			gint64* _tmp10_ = NULL;
			gint _tmp10__length1 = 0;
			gint _tmp11_ = 0;
			Photo* _tmp12_ = NULL;
			PhotoID _tmp13_ = {0};
			gint64 _tmp14_ = 0LL;
			gint64 _tmp15_ = 0LL;
#line 172 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp6_ = _photo_it;
#line 172 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 172 "/home/jens/Source/shotwell/src/util/misc.vala"
			if (!_tmp7_) {
#line 172 "/home/jens/Source/shotwell/src/util/misc.vala"
				break;
#line 1466 "misc.c"
			}
#line 172 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp8_ = _photo_it;
#line 172 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 172 "/home/jens/Source/shotwell/src/util/misc.vala"
			photo = (Photo*) _tmp9_;
#line 173 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp10_ = ids;
#line 173 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp10__length1 = ids_length1;
#line 173 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp11_ = ctr;
#line 173 "/home/jens/Source/shotwell/src/util/misc.vala"
			ctr = _tmp11_ + 1;
#line 173 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp12_ = photo;
#line 173 "/home/jens/Source/shotwell/src/util/misc.vala"
			photo_get_photo_id (_tmp12_, &_tmp13_);
#line 173 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp14_ = _tmp13_.id;
#line 173 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp10_[_tmp11_] = _tmp14_;
#line 173 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp15_ = _tmp10_[_tmp11_];
#line 172 "/home/jens/Source/shotwell/src/util/misc.vala"
			_g_object_unref0 (photo);
#line 1494 "misc.c"
		}
#line 172 "/home/jens/Source/shotwell/src/util/misc.vala"
		_g_object_unref0 (_photo_it);
#line 1498 "misc.c"
	}
#line 175 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp16_ = photos;
#line 175 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp17_ = gee_collection_get_size (_tmp16_);
#line 175 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp18_ = _tmp17_;
#line 175 "/home/jens/Source/shotwell/src/util/misc.vala"
	bytes = (gsize) (_tmp18_ * sizeof (gint64));
#line 176 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp19_ = g_new0 (guchar, bytes);
#line 176 "/home/jens/Source/shotwell/src/util/misc.vala"
	serialized = _tmp19_;
#line 176 "/home/jens/Source/shotwell/src/util/misc.vala"
	serialized_length1 = bytes;
#line 176 "/home/jens/Source/shotwell/src/util/misc.vala"
	_serialized_size_ = serialized_length1;
#line 177 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp20_ = ids;
#line 177 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp20__length1 = ids_length1;
#line 177 "/home/jens/Source/shotwell/src/util/misc.vala"
	memcpy (serialized, _tmp20_, bytes);
#line 179 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp21_ = serialized;
#line 179 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp21__length1 = serialized_length1;
#line 179 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (result_length1) {
#line 179 "/home/jens/Source/shotwell/src/util/misc.vala"
		*result_length1 = _tmp21__length1;
#line 1530 "misc.c"
	}
#line 179 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = _tmp21_;
#line 179 "/home/jens/Source/shotwell/src/util/misc.vala"
	ids = (g_free (ids), NULL);
#line 179 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 1538 "misc.c"
}


GeeList* unserialize_photo_ids (guchar* serialized, gint size) {
	GeeList* result = NULL;
	gsize count = 0UL;
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gsize _tmp2_ = 0UL;
	gint64* ids = NULL;
	gsize _tmp4_ = 0UL;
	gint64* _tmp5_ = NULL;
	gint ids_length1 = 0;
	gint _ids_size_ = 0;
	gint64* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	guchar* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp9_ = NULL;
	gint64* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
#line 183 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = size;
#line 183 "/home/jens/Source/shotwell/src/util/misc.vala"
	count = (gsize) (_tmp0_ / sizeof (gint64));
#line 184 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp2_ = count;
#line 184 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp2_ <= ((gsize) 0)) {
#line 184 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp1_ = TRUE;
#line 1571 "misc.c"
	} else {
		guchar* _tmp3_ = NULL;
#line 184 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp3_ = serialized;
#line 184 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp1_ = _tmp3_ == NULL;
#line 1578 "misc.c"
	}
#line 184 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp1_) {
#line 185 "/home/jens/Source/shotwell/src/util/misc.vala"
		result = NULL;
#line 185 "/home/jens/Source/shotwell/src/util/misc.vala"
		return result;
#line 1586 "misc.c"
	}
#line 187 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp4_ = count;
#line 187 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp5_ = g_new0 (gint64, _tmp4_);
#line 187 "/home/jens/Source/shotwell/src/util/misc.vala"
	ids = _tmp5_;
#line 187 "/home/jens/Source/shotwell/src/util/misc.vala"
	ids_length1 = _tmp4_;
#line 187 "/home/jens/Source/shotwell/src/util/misc.vala"
	_ids_size_ = ids_length1;
#line 188 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp6_ = ids;
#line 188 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp6__length1 = ids_length1;
#line 188 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp7_ = serialized;
#line 188 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp8_ = size;
#line 188 "/home/jens/Source/shotwell/src/util/misc.vala"
	memcpy (_tmp6_, _tmp7_, (gsize) _tmp8_);
#line 190 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp9_ = gee_array_list_new (TYPE_PHOTO_ID, (GBoxedCopyFunc) photo_id_dup, (GDestroyNotify) photo_id_free, NULL, NULL, NULL);
#line 190 "/home/jens/Source/shotwell/src/util/misc.vala"
	list = _tmp9_;
#line 191 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp10_ = ids;
#line 191 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp10__length1 = ids_length1;
#line 1616 "misc.c"
	{
		gint64* id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
#line 191 "/home/jens/Source/shotwell/src/util/misc.vala"
		id_collection = _tmp10_;
#line 191 "/home/jens/Source/shotwell/src/util/misc.vala"
		id_collection_length1 = _tmp10__length1;
#line 191 "/home/jens/Source/shotwell/src/util/misc.vala"
		for (id_it = 0; id_it < _tmp10__length1; id_it = id_it + 1) {
#line 1628 "misc.c"
			gint64 id = 0LL;
#line 191 "/home/jens/Source/shotwell/src/util/misc.vala"
			id = id_collection[id_it];
#line 1632 "misc.c"
			{
				GeeArrayList* _tmp11_ = NULL;
				gint64 _tmp12_ = 0LL;
				PhotoID _tmp13_ = {0};
#line 192 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp11_ = list;
#line 192 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp12_ = id;
#line 192 "/home/jens/Source/shotwell/src/util/misc.vala"
				photo_id_init (&_tmp13_, _tmp12_);
#line 192 "/home/jens/Source/shotwell/src/util/misc.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), &_tmp13_);
#line 1645 "misc.c"
			}
		}
	}
#line 194 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (list, GEE_TYPE_LIST, GeeList);
#line 194 "/home/jens/Source/shotwell/src/util/misc.vala"
	ids = (g_free (ids), NULL);
#line 194 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 1655 "misc.c"
}


guchar* serialize_media_sources (GeeCollection* media, int* result_length1) {
	guchar* result = NULL;
	GdkAtom* atoms = NULL;
	GeeCollection* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GdkAtom* _tmp3_ = NULL;
	gint atoms_length1 = 0;
	gint _atoms_size_ = 0;
	gint ctr = 0;
	gsize bytes = 0UL;
	GeeCollection* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	guchar* serialized = NULL;
	guchar* _tmp20_ = NULL;
	gint serialized_length1 = 0;
	gint _serialized_size_ = 0;
	GdkAtom* _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	guchar* _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
#line 197 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (media), NULL);
#line 198 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = media;
#line 198 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 198 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp2_ = _tmp1_;
#line 198 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp3_ = g_new0 (GdkAtom, _tmp2_);
#line 198 "/home/jens/Source/shotwell/src/util/misc.vala"
	atoms = _tmp3_;
#line 198 "/home/jens/Source/shotwell/src/util/misc.vala"
	atoms_length1 = _tmp2_;
#line 198 "/home/jens/Source/shotwell/src/util/misc.vala"
	_atoms_size_ = atoms_length1;
#line 199 "/home/jens/Source/shotwell/src/util/misc.vala"
	ctr = 0;
#line 1699 "misc.c"
	{
		GeeIterator* _current_media_it = NULL;
		GeeCollection* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 200 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp4_ = media;
#line 200 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp5_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ITERABLE, GeeIterable));
#line 200 "/home/jens/Source/shotwell/src/util/misc.vala"
		_current_media_it = _tmp5_;
#line 200 "/home/jens/Source/shotwell/src/util/misc.vala"
		while (TRUE) {
#line 1712 "misc.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			MediaSource* current_media = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			GdkAtom* _tmp10_ = NULL;
			gint _tmp10__length1 = 0;
			gint _tmp11_ = 0;
			MediaSource* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			GdkAtom _tmp15_ = 0U;
			GdkAtom _tmp16_ = 0U;
#line 200 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp6_ = _current_media_it;
#line 200 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 200 "/home/jens/Source/shotwell/src/util/misc.vala"
			if (!_tmp7_) {
#line 200 "/home/jens/Source/shotwell/src/util/misc.vala"
				break;
#line 1734 "misc.c"
			}
#line 200 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp8_ = _current_media_it;
#line 200 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 200 "/home/jens/Source/shotwell/src/util/misc.vala"
			current_media = (MediaSource*) _tmp9_;
#line 201 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp10_ = atoms;
#line 201 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp10__length1 = atoms_length1;
#line 201 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp11_ = ctr;
#line 201 "/home/jens/Source/shotwell/src/util/misc.vala"
			ctr = _tmp11_ + 1;
#line 201 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp12_ = current_media;
#line 201 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp13_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_DATA_SOURCE, DataSource));
#line 201 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp14_ = _tmp13_;
#line 201 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp15_ = gdk_atom_intern (_tmp14_, FALSE);
#line 201 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp10_[_tmp11_] = _tmp15_;
#line 201 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp16_ = _tmp10_[_tmp11_];
#line 201 "/home/jens/Source/shotwell/src/util/misc.vala"
			_g_free0 (_tmp14_);
#line 200 "/home/jens/Source/shotwell/src/util/misc.vala"
			_g_object_unref0 (current_media);
#line 1766 "misc.c"
		}
#line 200 "/home/jens/Source/shotwell/src/util/misc.vala"
		_g_object_unref0 (_current_media_it);
#line 1770 "misc.c"
	}
#line 203 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp17_ = media;
#line 203 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp18_ = gee_collection_get_size (_tmp17_);
#line 203 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp19_ = _tmp18_;
#line 203 "/home/jens/Source/shotwell/src/util/misc.vala"
	bytes = (gsize) (_tmp19_ * sizeof (GdkAtom));
#line 204 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp20_ = g_new0 (guchar, bytes);
#line 204 "/home/jens/Source/shotwell/src/util/misc.vala"
	serialized = _tmp20_;
#line 204 "/home/jens/Source/shotwell/src/util/misc.vala"
	serialized_length1 = bytes;
#line 204 "/home/jens/Source/shotwell/src/util/misc.vala"
	_serialized_size_ = serialized_length1;
#line 205 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp21_ = atoms;
#line 205 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp21__length1 = atoms_length1;
#line 205 "/home/jens/Source/shotwell/src/util/misc.vala"
	memcpy (serialized, _tmp21_, bytes);
#line 207 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp22_ = serialized;
#line 207 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp22__length1 = serialized_length1;
#line 207 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (result_length1) {
#line 207 "/home/jens/Source/shotwell/src/util/misc.vala"
		*result_length1 = _tmp22__length1;
#line 1802 "misc.c"
	}
#line 207 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = _tmp22_;
#line 207 "/home/jens/Source/shotwell/src/util/misc.vala"
	atoms = (g_free (atoms), NULL);
#line 207 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 1810 "misc.c"
}


GeeList* unserialize_media_sources (guchar* serialized, gint size) {
	GeeList* result = NULL;
	gsize count = 0UL;
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gsize _tmp2_ = 0UL;
	GdkAtom* atoms = NULL;
	gsize _tmp4_ = 0UL;
	GdkAtom* _tmp5_ = NULL;
	gint atoms_length1 = 0;
	gint _atoms_size_ = 0;
	GdkAtom* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	guchar* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp9_ = NULL;
	GdkAtom* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
#line 211 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = size;
#line 211 "/home/jens/Source/shotwell/src/util/misc.vala"
	count = (gsize) (_tmp0_ / sizeof (GdkAtom));
#line 212 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp2_ = count;
#line 212 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp2_ <= ((gsize) 0)) {
#line 212 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp1_ = TRUE;
#line 1843 "misc.c"
	} else {
		guchar* _tmp3_ = NULL;
#line 212 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp3_ = serialized;
#line 212 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp1_ = _tmp3_ == NULL;
#line 1850 "misc.c"
	}
#line 212 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp1_) {
#line 213 "/home/jens/Source/shotwell/src/util/misc.vala"
		result = NULL;
#line 213 "/home/jens/Source/shotwell/src/util/misc.vala"
		return result;
#line 1858 "misc.c"
	}
#line 215 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp4_ = count;
#line 215 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp5_ = g_new0 (GdkAtom, _tmp4_);
#line 215 "/home/jens/Source/shotwell/src/util/misc.vala"
	atoms = _tmp5_;
#line 215 "/home/jens/Source/shotwell/src/util/misc.vala"
	atoms_length1 = _tmp4_;
#line 215 "/home/jens/Source/shotwell/src/util/misc.vala"
	_atoms_size_ = atoms_length1;
#line 216 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp6_ = atoms;
#line 216 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp6__length1 = atoms_length1;
#line 216 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp7_ = serialized;
#line 216 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp8_ = size;
#line 216 "/home/jens/Source/shotwell/src/util/misc.vala"
	memcpy (_tmp6_, _tmp7_, (gsize) _tmp8_);
#line 218 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp9_ = gee_array_list_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 218 "/home/jens/Source/shotwell/src/util/misc.vala"
	list = _tmp9_;
#line 219 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp10_ = atoms;
#line 219 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp10__length1 = atoms_length1;
#line 1888 "misc.c"
	{
		GdkAtom* current_atom_collection = NULL;
		gint current_atom_collection_length1 = 0;
		gint _current_atom_collection_size_ = 0;
		gint current_atom_it = 0;
#line 219 "/home/jens/Source/shotwell/src/util/misc.vala"
		current_atom_collection = _tmp10_;
#line 219 "/home/jens/Source/shotwell/src/util/misc.vala"
		current_atom_collection_length1 = _tmp10__length1;
#line 219 "/home/jens/Source/shotwell/src/util/misc.vala"
		for (current_atom_it = 0; current_atom_it < _tmp10__length1; current_atom_it = current_atom_it + 1) {
#line 1900 "misc.c"
			GdkAtom current_atom = 0U;
#line 219 "/home/jens/Source/shotwell/src/util/misc.vala"
			current_atom = current_atom_collection[current_atom_it];
#line 1904 "misc.c"
			{
				MediaSource* media = NULL;
				MediaCollectionRegistry* _tmp11_ = NULL;
				MediaCollectionRegistry* _tmp12_ = NULL;
				GdkAtom _tmp13_ = 0U;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				MediaSource* _tmp16_ = NULL;
				MediaSource* _tmp17_ = NULL;
				MediaSource* _tmp18_ = NULL;
				GeeArrayList* _tmp19_ = NULL;
				MediaSource* _tmp20_ = NULL;
#line 220 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp11_ = media_collection_registry_get_instance ();
#line 220 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp12_ = _tmp11_;
#line 220 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp13_ = current_atom;
#line 220 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp14_ = gdk_atom_name (_tmp13_);
#line 220 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp15_ = _tmp14_;
#line 220 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp16_ = media_collection_registry_fetch_media (_tmp12_, _tmp15_);
#line 220 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp17_ = _tmp16_;
#line 220 "/home/jens/Source/shotwell/src/util/misc.vala"
				_g_free0 (_tmp15_);
#line 220 "/home/jens/Source/shotwell/src/util/misc.vala"
				_media_collection_registry_unref0 (_tmp12_);
#line 220 "/home/jens/Source/shotwell/src/util/misc.vala"
				media = _tmp17_;
#line 221 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp18_ = media;
#line 221 "/home/jens/Source/shotwell/src/util/misc.vala"
				_vala_assert (_tmp18_ != NULL, "media != null");
#line 222 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp19_ = list;
#line 222 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp20_ = media;
#line 222 "/home/jens/Source/shotwell/src/util/misc.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp20_);
#line 219 "/home/jens/Source/shotwell/src/util/misc.vala"
				_g_object_unref0 (media);
#line 1949 "misc.c"
			}
		}
	}
#line 225 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (list, GEE_TYPE_LIST, GeeList);
#line 225 "/home/jens/Source/shotwell/src/util/misc.vala"
	atoms = (g_free (atoms), NULL);
#line 225 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 1959 "misc.c"
}


static gchar* g_time_format (struct tm *self, const gchar* format) {
	gchar* result = NULL;
	gchar* buffer = NULL;
	gchar* _tmp0_ = NULL;
	gint buffer_length1 = 0;
	gint _buffer_size_ = 0;
	gchar* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar* _tmp4_ = NULL;
#line 2758 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (format != NULL, NULL);
#line 2759 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 64);
#line 2759 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	buffer = _tmp0_;
#line 2759 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	buffer_length1 = 64;
#line 2759 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_buffer_size_ = buffer_length1;
#line 2760 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = buffer;
#line 2760 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1__length1 = buffer_length1;
#line 2760 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = format;
#line 2760 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	strftime (_tmp1_, _tmp1__length1, _tmp2_, &(*self));
#line 2761 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3_ = buffer;
#line 2761 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3__length1 = buffer_length1;
#line 2761 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp4_ = g_strdup ((const gchar*) _tmp3_);
#line 2761 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 2761 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	buffer = (g_free (buffer), NULL);
#line 2761 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 2005 "misc.c"
}


gchar* format_local_datespan (struct tm* from_date, struct tm* to_date) {
	gchar* result = NULL;
	gchar* from_format = NULL;
	gchar* to_format = NULL;
	struct tm _tmp0_ = {0};
	gint _tmp1_ = 0;
	struct tm _tmp2_ = {0};
	gint _tmp3_ = 0;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
#line 228 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (from_date != NULL, NULL);
#line 228 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (to_date != NULL, NULL);
#line 233 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = *from_date;
#line 233 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = _tmp0_.tm_year;
#line 233 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp2_ = *to_date;
#line 233 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp3_ = _tmp2_.tm_year;
#line 233 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp1_ == _tmp3_) {
#line 2041 "misc.c"
		gboolean _tmp4_ = FALSE;
		struct tm _tmp5_ = {0};
		gint _tmp6_ = 0;
		struct tm _tmp7_ = {0};
		gint _tmp8_ = 0;
#line 235 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp5_ = *from_date;
#line 235 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp6_ = _tmp5_.tm_mon;
#line 235 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp7_ = *to_date;
#line 235 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp8_ = _tmp7_.tm_mon;
#line 235 "/home/jens/Source/shotwell/src/util/misc.vala"
		if (_tmp6_ == _tmp8_) {
#line 2057 "misc.c"
			struct tm _tmp9_ = {0};
			gint _tmp10_ = 0;
			struct tm _tmp11_ = {0};
			gint _tmp12_ = 0;
#line 235 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp9_ = *from_date;
#line 235 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp10_ = _tmp9_.tm_mday;
#line 235 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp11_ = *to_date;
#line 235 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp12_ = _tmp11_.tm_mday;
#line 235 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp4_ = _tmp10_ == (_tmp12_ - 1);
#line 2072 "misc.c"
		} else {
#line 235 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp4_ = FALSE;
#line 2076 "misc.c"
		}
#line 235 "/home/jens/Source/shotwell/src/util/misc.vala"
		if (_tmp4_) {
#line 2080 "misc.c"
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
#line 237 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp13_ = resources_get_start_multiday_span_format_string ();
#line 237 "/home/jens/Source/shotwell/src/util/misc.vala"
			_g_free0 (from_format);
#line 237 "/home/jens/Source/shotwell/src/util/misc.vala"
			from_format = _tmp13_;
#line 238 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp14_ = resources_get_end_multiday_span_format_string ();
#line 238 "/home/jens/Source/shotwell/src/util/misc.vala"
			_g_free0 (to_format);
#line 238 "/home/jens/Source/shotwell/src/util/misc.vala"
			to_format = _tmp14_;
#line 2095 "misc.c"
		} else {
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
#line 242 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp15_ = resources_get_start_multimonth_span_format_string ();
#line 242 "/home/jens/Source/shotwell/src/util/misc.vala"
			_g_free0 (from_format);
#line 242 "/home/jens/Source/shotwell/src/util/misc.vala"
			from_format = _tmp15_;
#line 243 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp16_ = resources_get_end_multimonth_span_format_string ();
#line 243 "/home/jens/Source/shotwell/src/util/misc.vala"
			_g_free0 (to_format);
#line 243 "/home/jens/Source/shotwell/src/util/misc.vala"
			to_format = _tmp16_;
#line 2111 "misc.c"
		}
	} else {
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
#line 248 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp17_ = resources_get_long_date_format_string ();
#line 248 "/home/jens/Source/shotwell/src/util/misc.vala"
		_g_free0 (from_format);
#line 248 "/home/jens/Source/shotwell/src/util/misc.vala"
		from_format = _tmp17_;
#line 249 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp18_ = resources_get_long_date_format_string ();
#line 249 "/home/jens/Source/shotwell/src/util/misc.vala"
		_g_free0 (to_format);
#line 249 "/home/jens/Source/shotwell/src/util/misc.vala"
		to_format = _tmp18_;
#line 2128 "misc.c"
	}
#line 252 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp19_ = from_format;
#line 252 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp20_ = g_time_format (from_date, _tmp19_);
#line 252 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp21_ = _tmp20_;
#line 252 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp22_ = to_format;
#line 252 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp23_ = g_time_format (to_date, _tmp22_);
#line 252 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp24_ = _tmp23_;
#line 252 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp25_ = g_strdup_printf ("%s - %s", _tmp21_, _tmp24_);
#line 252 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp26_ = _tmp25_;
#line 252 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp27_ = string_strip_leading_zeroes (_tmp26_);
#line 252 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp28_ = _tmp27_;
#line 252 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_free0 (_tmp26_);
#line 252 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_free0 (_tmp24_);
#line 252 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_free0 (_tmp21_);
#line 252 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = _tmp28_;
#line 252 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_free0 (to_format);
#line 252 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_free0 (from_format);
#line 252 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 2164 "misc.c"
}


gchar* format_local_date (struct tm* date) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
#line 256 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (date != NULL, NULL);
#line 257 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = resources_get_long_date_format_string ();
#line 257 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = _tmp0_;
#line 257 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp2_ = g_time_format (date, _tmp1_);
#line 257 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp3_ = _tmp2_;
#line 257 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp4_ = string_strip_leading_zeroes (_tmp3_);
#line 257 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp5_ = _tmp4_;
#line 257 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_free0 (_tmp3_);
#line 257 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_free0 (_tmp1_);
#line 257 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = _tmp5_;
#line 257 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 2198 "misc.c"
}


OneShotScheduler* one_shot_scheduler_construct (GType object_type, const gchar* name, OneShotCallback callback, void* callback_target) {
	OneShotScheduler* self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	OneShotCallback _tmp2_ = NULL;
	void* _tmp2__target = NULL;
#line 267 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 267 "/home/jens/Source/shotwell/src/util/misc.vala"
	self = (OneShotScheduler*) g_type_create_instance (object_type);
#line 268 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = name;
#line 268 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 268 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_free0 (self->priv->name);
#line 268 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv->name = _tmp1_;
#line 269 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp2_ = callback;
#line 269 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp2__target = callback_target;
#line 269 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv->callback = _tmp2_;
#line 269 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv->callback_target = _tmp2__target;
#line 267 "/home/jens/Source/shotwell/src/util/misc.vala"
	return self;
#line 2230 "misc.c"
}


OneShotScheduler* one_shot_scheduler_new (const gchar* name, OneShotCallback callback, void* callback_target) {
#line 267 "/home/jens/Source/shotwell/src/util/misc.vala"
	return one_shot_scheduler_construct (TYPE_ONE_SHOT_SCHEDULER, name, callback, callback_target);
#line 2237 "misc.c"
}


gboolean one_shot_scheduler_is_scheduled (OneShotScheduler* self) {
	gboolean result = FALSE;
	guint _tmp0_ = 0U;
#line 280 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (IS_ONE_SHOT_SCHEDULER (self), FALSE);
#line 281 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = self->priv->scheduled;
#line 281 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = _tmp0_ != ((guint) 0);
#line 281 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 2252 "misc.c"
}


void one_shot_scheduler_at_idle (OneShotScheduler* self) {
#line 284 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_if_fail (IS_ONE_SHOT_SCHEDULER (self));
#line 285 "/home/jens/Source/shotwell/src/util/misc.vala"
	one_shot_scheduler_at_priority_idle (self, G_PRIORITY_DEFAULT_IDLE);
#line 2261 "misc.c"
}


static gboolean _one_shot_scheduler_callback_wrapper_gsource_func (gpointer self) {
	gboolean result;
	result = one_shot_scheduler_callback_wrapper ((OneShotScheduler*) self);
#line 290 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 2270 "misc.c"
}


void one_shot_scheduler_at_priority_idle (OneShotScheduler* self, gint priority) {
	guint _tmp0_ = 0U;
#line 288 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_if_fail (IS_ONE_SHOT_SCHEDULER (self));
#line 289 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = self->priv->scheduled;
#line 289 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp0_ == ((guint) 0)) {
#line 2282 "misc.c"
		gint _tmp1_ = 0;
		guint _tmp2_ = 0U;
#line 290 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp1_ = priority;
#line 290 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp2_ = g_idle_add_full (_tmp1_, _one_shot_scheduler_callback_wrapper_gsource_func, one_shot_scheduler_ref (self), one_shot_scheduler_unref);
#line 290 "/home/jens/Source/shotwell/src/util/misc.vala"
		self->priv->scheduled = _tmp2_;
#line 2291 "misc.c"
	}
}


void one_shot_scheduler_after_timeout (OneShotScheduler* self, guint msec, gboolean reschedule) {
	guint _tmp0_ = 0U;
	gboolean _tmp1_ = FALSE;
#line 293 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_if_fail (IS_ONE_SHOT_SCHEDULER (self));
#line 294 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = msec;
#line 294 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = reschedule;
#line 294 "/home/jens/Source/shotwell/src/util/misc.vala"
	one_shot_scheduler_priority_after_timeout (self, G_PRIORITY_DEFAULT, _tmp0_, _tmp1_);
#line 2307 "misc.c"
}


void one_shot_scheduler_priority_after_timeout (OneShotScheduler* self, gint priority, guint msec, gboolean reschedule) {
	gboolean _tmp0_ = FALSE;
	guint _tmp1_ = 0U;
	guint _tmp3_ = 0U;
	gint _tmp5_ = 0;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
#line 297 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_if_fail (IS_ONE_SHOT_SCHEDULER (self));
#line 298 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = self->priv->scheduled;
#line 298 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp1_ != ((guint) 0)) {
#line 2324 "misc.c"
		gboolean _tmp2_ = FALSE;
#line 298 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp2_ = reschedule;
#line 298 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp0_ = !_tmp2_;
#line 2330 "misc.c"
	} else {
#line 298 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp0_ = FALSE;
#line 2334 "misc.c"
	}
#line 298 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp0_) {
#line 299 "/home/jens/Source/shotwell/src/util/misc.vala"
		return;
#line 2340 "misc.c"
	}
#line 301 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp3_ = self->priv->scheduled;
#line 301 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp3_ != ((guint) 0)) {
#line 2346 "misc.c"
		guint _tmp4_ = 0U;
#line 302 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp4_ = self->priv->scheduled;
#line 302 "/home/jens/Source/shotwell/src/util/misc.vala"
		g_source_remove (_tmp4_);
#line 2352 "misc.c"
	}
#line 304 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp5_ = priority;
#line 304 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp6_ = msec;
#line 304 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp7_ = g_timeout_add_full (_tmp5_, _tmp6_, _one_shot_scheduler_callback_wrapper_gsource_func, one_shot_scheduler_ref (self), one_shot_scheduler_unref);
#line 304 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv->scheduled = _tmp7_;
#line 2362 "misc.c"
}


void one_shot_scheduler_cancel (OneShotScheduler* self) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
#line 307 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_if_fail (IS_ONE_SHOT_SCHEDULER (self));
#line 308 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = self->priv->scheduled;
#line 308 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp0_ == ((guint) 0)) {
#line 309 "/home/jens/Source/shotwell/src/util/misc.vala"
		return;
#line 2377 "misc.c"
	}
#line 311 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = self->priv->scheduled;
#line 311 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_source_remove (_tmp1_);
#line 312 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv->scheduled = (guint) 0;
#line 2385 "misc.c"
}


static gboolean one_shot_scheduler_callback_wrapper (OneShotScheduler* self) {
	gboolean result = FALSE;
	OneShotCallback _tmp0_ = NULL;
	void* _tmp0__target = NULL;
#line 315 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (IS_ONE_SHOT_SCHEDULER (self), FALSE);
#line 316 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv->scheduled = (guint) 0;
#line 317 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = self->priv->callback;
#line 317 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0__target = self->priv->callback_target;
#line 317 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ (_tmp0__target);
#line 319 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = FALSE;
#line 319 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 2407 "misc.c"
}


static void value_one_shot_scheduler_init (GValue* value) {
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	value->data[0].v_pointer = NULL;
#line 2414 "misc.c"
}


static void value_one_shot_scheduler_free_value (GValue* value) {
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (value->data[0].v_pointer) {
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
		one_shot_scheduler_unref (value->data[0].v_pointer);
#line 2423 "misc.c"
	}
}


static void value_one_shot_scheduler_copy_value (const GValue* src_value, GValue* dest_value) {
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (src_value->data[0].v_pointer) {
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
		dest_value->data[0].v_pointer = one_shot_scheduler_ref (src_value->data[0].v_pointer);
#line 2433 "misc.c"
	} else {
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2437 "misc.c"
	}
}


static gpointer value_one_shot_scheduler_peek_pointer (const GValue* value) {
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	return value->data[0].v_pointer;
#line 2445 "misc.c"
}


static gchar* value_one_shot_scheduler_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (collect_values[0].v_pointer) {
#line 2452 "misc.c"
		OneShotScheduler* object;
		object = collect_values[0].v_pointer;
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
		if (object->parent_instance.g_class == NULL) {
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2459 "misc.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2463 "misc.c"
		}
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
		value->data[0].v_pointer = one_shot_scheduler_ref (object);
#line 2467 "misc.c"
	} else {
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
		value->data[0].v_pointer = NULL;
#line 2471 "misc.c"
	}
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	return NULL;
#line 2475 "misc.c"
}


static gchar* value_one_shot_scheduler_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	OneShotScheduler** object_p;
	object_p = collect_values[0].v_pointer;
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (!object_p) {
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2486 "misc.c"
	}
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (!value->data[0].v_pointer) {
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
		*object_p = NULL;
#line 2492 "misc.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
		*object_p = value->data[0].v_pointer;
#line 2496 "misc.c"
	} else {
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
		*object_p = one_shot_scheduler_ref (value->data[0].v_pointer);
#line 2500 "misc.c"
	}
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	return NULL;
#line 2504 "misc.c"
}


GParamSpec* param_spec_one_shot_scheduler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecOneShotScheduler* spec;
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ONE_SHOT_SCHEDULER), NULL);
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	return G_PARAM_SPEC (spec);
#line 2518 "misc.c"
}


gpointer value_get_one_shot_scheduler (const GValue* value) {
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ONE_SHOT_SCHEDULER), NULL);
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	return value->data[0].v_pointer;
#line 2527 "misc.c"
}


void value_set_one_shot_scheduler (GValue* value, gpointer v_object) {
	OneShotScheduler* old;
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ONE_SHOT_SCHEDULER));
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	old = value->data[0].v_pointer;
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (v_object) {
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ONE_SHOT_SCHEDULER));
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
		value->data[0].v_pointer = v_object;
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
		one_shot_scheduler_ref (value->data[0].v_pointer);
#line 2547 "misc.c"
	} else {
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
		value->data[0].v_pointer = NULL;
#line 2551 "misc.c"
	}
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (old) {
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
		one_shot_scheduler_unref (old);
#line 2557 "misc.c"
	}
}


void value_take_one_shot_scheduler (GValue* value, gpointer v_object) {
	OneShotScheduler* old;
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ONE_SHOT_SCHEDULER));
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	old = value->data[0].v_pointer;
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (v_object) {
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ONE_SHOT_SCHEDULER));
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
		value->data[0].v_pointer = v_object;
#line 2576 "misc.c"
	} else {
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
		value->data[0].v_pointer = NULL;
#line 2580 "misc.c"
	}
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (old) {
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
		one_shot_scheduler_unref (old);
#line 2586 "misc.c"
	}
}


static void one_shot_scheduler_class_init (OneShotSchedulerClass * klass) {
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	one_shot_scheduler_parent_class = g_type_class_peek_parent (klass);
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	((OneShotSchedulerClass *) klass)->finalize = one_shot_scheduler_finalize;
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_type_class_add_private (klass, sizeof (OneShotSchedulerPrivate));
#line 2598 "misc.c"
}


static void one_shot_scheduler_instance_init (OneShotScheduler * self) {
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv = ONE_SHOT_SCHEDULER_GET_PRIVATE (self);
#line 265 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv->scheduled = (guint) 0;
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->ref_count = 1;
#line 2609 "misc.c"
}


static void one_shot_scheduler_finalize (OneShotScheduler* obj) {
	OneShotScheduler * self;
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ONE_SHOT_SCHEDULER, OneShotScheduler);
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_signal_handlers_destroy (self);
#line 277 "/home/jens/Source/shotwell/src/util/misc.vala"
	one_shot_scheduler_cancel (self);
#line 263 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_free0 (self->priv->name);
#line 2623 "misc.c"
}


GType one_shot_scheduler_get_type (void) {
	static volatile gsize one_shot_scheduler_type_id__volatile = 0;
	if (g_once_init_enter (&one_shot_scheduler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_one_shot_scheduler_init, value_one_shot_scheduler_free_value, value_one_shot_scheduler_copy_value, value_one_shot_scheduler_peek_pointer, "p", value_one_shot_scheduler_collect_value, "p", value_one_shot_scheduler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (OneShotSchedulerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) one_shot_scheduler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (OneShotScheduler), 0, (GInstanceInitFunc) one_shot_scheduler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType one_shot_scheduler_type_id;
		one_shot_scheduler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "OneShotScheduler", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&one_shot_scheduler_type_id__volatile, one_shot_scheduler_type_id);
	}
	return one_shot_scheduler_type_id__volatile;
}


gpointer one_shot_scheduler_ref (gpointer instance) {
	OneShotScheduler* self;
	self = instance;
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_atomic_int_inc (&self->ref_count);
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	return instance;
#line 2648 "misc.c"
}


void one_shot_scheduler_unref (gpointer instance) {
	OneShotScheduler* self;
	self = instance;
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
		ONE_SHOT_SCHEDULER_GET_CLASS (self)->finalize (self);
#line 262 "/home/jens/Source/shotwell/src/util/misc.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2661 "misc.c"
	}
}


OpTimer* op_timer_construct (GType object_type, const gchar* name) {
	OpTimer* self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 331 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 331 "/home/jens/Source/shotwell/src/util/misc.vala"
	self = (OpTimer*) g_type_create_instance (object_type);
#line 332 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = name;
#line 332 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 332 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_free0 (self->priv->name);
#line 332 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv->name = _tmp1_;
#line 331 "/home/jens/Source/shotwell/src/util/misc.vala"
	return self;
#line 2684 "misc.c"
}


OpTimer* op_timer_new (const gchar* name) {
#line 331 "/home/jens/Source/shotwell/src/util/misc.vala"
	return op_timer_construct (TYPE_OP_TIMER, name);
#line 2691 "misc.c"
}


void op_timer_start (OpTimer* self) {
	GTimer* _tmp0_ = NULL;
#line 335 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_if_fail (IS_OP_TIMER (self));
#line 336 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = self->priv->timer;
#line 336 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_timer_start (_tmp0_);
#line 2703 "misc.c"
}


void op_timer_stop (OpTimer* self) {
	gdouble time = 0.0;
	GTimer* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	glong _tmp10_ = 0L;
#line 339 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_if_fail (IS_OP_TIMER (self));
#line 340 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = self->priv->timer;
#line 340 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = g_timer_elapsed (_tmp0_, NULL);
#line 340 "/home/jens/Source/shotwell/src/util/misc.vala"
	time = _tmp1_;
#line 342 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp2_ = self->priv->elapsed;
#line 342 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp3_ = time;
#line 342 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv->elapsed = _tmp2_ + _tmp3_;
#line 344 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp4_ = time;
#line 344 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp5_ = self->priv->shortest;
#line 344 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp4_ < _tmp5_) {
#line 2738 "misc.c"
		gdouble _tmp6_ = 0.0;
#line 345 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp6_ = time;
#line 345 "/home/jens/Source/shotwell/src/util/misc.vala"
		self->priv->shortest = _tmp6_;
#line 2744 "misc.c"
	}
#line 347 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp7_ = time;
#line 347 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp8_ = self->priv->longest;
#line 347 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp7_ > _tmp8_) {
#line 2752 "misc.c"
		gdouble _tmp9_ = 0.0;
#line 348 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp9_ = time;
#line 348 "/home/jens/Source/shotwell/src/util/misc.vala"
		self->priv->longest = _tmp9_;
#line 2758 "misc.c"
	}
#line 350 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp10_ = self->priv->count;
#line 350 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv->count = _tmp10_ + 1;
#line 2764 "misc.c"
}


gchar* op_timer_to_string (OpTimer* self) {
	gchar* result = NULL;
	glong _tmp0_ = 0L;
#line 353 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (IS_OP_TIMER (self), NULL);
#line 354 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = self->priv->count;
#line 354 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp0_ > ((glong) 0)) {
#line 2777 "misc.c"
		const gchar* _tmp1_ = NULL;
		glong _tmp2_ = 0L;
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
		gdouble _tmp5_ = 0.0;
		glong _tmp6_ = 0L;
		gdouble _tmp7_ = 0.0;
		gchar* _tmp8_ = NULL;
#line 355 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp1_ = self->priv->name;
#line 355 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp2_ = self->priv->count;
#line 355 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp3_ = self->priv->elapsed;
#line 355 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp4_ = self->priv->shortest;
#line 355 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp5_ = self->priv->elapsed;
#line 355 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp6_ = self->priv->count;
#line 355 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp7_ = self->priv->longest;
#line 355 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp8_ = g_strdup_printf ("%s: count=%ld elapsed=%.03lfs min/avg/max=%.03lf/%.03lf/%.03lf", _tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_ / ((gdouble) _tmp6_), _tmp7_);
#line 355 "/home/jens/Source/shotwell/src/util/misc.vala"
		result = _tmp8_;
#line 355 "/home/jens/Source/shotwell/src/util/misc.vala"
		return result;
#line 2806 "misc.c"
	} else {
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
#line 358 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp9_ = self->priv->name;
#line 358 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp10_ = g_strdup_printf ("%s: no operations", _tmp9_);
#line 358 "/home/jens/Source/shotwell/src/util/misc.vala"
		result = _tmp10_;
#line 358 "/home/jens/Source/shotwell/src/util/misc.vala"
		return result;
#line 2818 "misc.c"
	}
}


static void value_op_timer_init (GValue* value) {
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	value->data[0].v_pointer = NULL;
#line 2826 "misc.c"
}


static void value_op_timer_free_value (GValue* value) {
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (value->data[0].v_pointer) {
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
		op_timer_unref (value->data[0].v_pointer);
#line 2835 "misc.c"
	}
}


static void value_op_timer_copy_value (const GValue* src_value, GValue* dest_value) {
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (src_value->data[0].v_pointer) {
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
		dest_value->data[0].v_pointer = op_timer_ref (src_value->data[0].v_pointer);
#line 2845 "misc.c"
	} else {
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2849 "misc.c"
	}
}


static gpointer value_op_timer_peek_pointer (const GValue* value) {
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	return value->data[0].v_pointer;
#line 2857 "misc.c"
}


static gchar* value_op_timer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (collect_values[0].v_pointer) {
#line 2864 "misc.c"
		OpTimer* object;
		object = collect_values[0].v_pointer;
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
		if (object->parent_instance.g_class == NULL) {
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2871 "misc.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2875 "misc.c"
		}
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
		value->data[0].v_pointer = op_timer_ref (object);
#line 2879 "misc.c"
	} else {
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
		value->data[0].v_pointer = NULL;
#line 2883 "misc.c"
	}
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	return NULL;
#line 2887 "misc.c"
}


static gchar* value_op_timer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	OpTimer** object_p;
	object_p = collect_values[0].v_pointer;
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (!object_p) {
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2898 "misc.c"
	}
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (!value->data[0].v_pointer) {
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
		*object_p = NULL;
#line 2904 "misc.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
		*object_p = value->data[0].v_pointer;
#line 2908 "misc.c"
	} else {
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
		*object_p = op_timer_ref (value->data[0].v_pointer);
#line 2912 "misc.c"
	}
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	return NULL;
#line 2916 "misc.c"
}


GParamSpec* param_spec_op_timer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecOpTimer* spec;
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_OP_TIMER), NULL);
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	return G_PARAM_SPEC (spec);
#line 2930 "misc.c"
}


gpointer value_get_op_timer (const GValue* value) {
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_OP_TIMER), NULL);
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	return value->data[0].v_pointer;
#line 2939 "misc.c"
}


void value_set_op_timer (GValue* value, gpointer v_object) {
	OpTimer* old;
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_OP_TIMER));
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	old = value->data[0].v_pointer;
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (v_object) {
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_OP_TIMER));
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
		value->data[0].v_pointer = v_object;
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
		op_timer_ref (value->data[0].v_pointer);
#line 2959 "misc.c"
	} else {
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
		value->data[0].v_pointer = NULL;
#line 2963 "misc.c"
	}
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (old) {
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
		op_timer_unref (old);
#line 2969 "misc.c"
	}
}


void value_take_op_timer (GValue* value, gpointer v_object) {
	OpTimer* old;
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_OP_TIMER));
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	old = value->data[0].v_pointer;
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (v_object) {
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_OP_TIMER));
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
		value->data[0].v_pointer = v_object;
#line 2988 "misc.c"
	} else {
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
		value->data[0].v_pointer = NULL;
#line 2992 "misc.c"
	}
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (old) {
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
		op_timer_unref (old);
#line 2998 "misc.c"
	}
}


static void op_timer_class_init (OpTimerClass * klass) {
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	op_timer_parent_class = g_type_class_peek_parent (klass);
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	((OpTimerClass *) klass)->finalize = op_timer_finalize;
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_type_class_add_private (klass, sizeof (OpTimerPrivate));
#line 3010 "misc.c"
}


static void op_timer_instance_init (OpTimer * self) {
	GTimer* _tmp0_ = NULL;
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv = OP_TIMER_GET_PRIVATE (self);
#line 325 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = g_timer_new ();
#line 325 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv->timer = _tmp0_;
#line 326 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv->count = (glong) 0;
#line 327 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv->elapsed = (gdouble) 0;
#line 328 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv->shortest = DBL_MAX;
#line 329 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv->longest = DBL_MIN;
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->ref_count = 1;
#line 3032 "misc.c"
}


static void op_timer_finalize (OpTimer* obj) {
	OpTimer * self;
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_OP_TIMER, OpTimer);
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_signal_handlers_destroy (self);
#line 324 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_free0 (self->priv->name);
#line 325 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_timer_destroy0 (self->priv->timer);
#line 3046 "misc.c"
}


GType op_timer_get_type (void) {
	static volatile gsize op_timer_type_id__volatile = 0;
	if (g_once_init_enter (&op_timer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_op_timer_init, value_op_timer_free_value, value_op_timer_copy_value, value_op_timer_peek_pointer, "p", value_op_timer_collect_value, "p", value_op_timer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (OpTimerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) op_timer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (OpTimer), 0, (GInstanceInitFunc) op_timer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType op_timer_type_id;
		op_timer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "OpTimer", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&op_timer_type_id__volatile, op_timer_type_id);
	}
	return op_timer_type_id__volatile;
}


gpointer op_timer_ref (gpointer instance) {
	OpTimer* self;
	self = instance;
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_atomic_int_inc (&self->ref_count);
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	return instance;
#line 3071 "misc.c"
}


void op_timer_unref (gpointer instance) {
	OpTimer* self;
	self = instance;
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
		OP_TIMER_GET_CLASS (self)->finalize (self);
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3084 "misc.c"
	}
}


void suppress_warnings (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message) {
#line 369 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_if_fail (message != NULL);
#line 3092 "misc.c"
}


static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
#line 2750 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	localtime_r (&time, &_tmp0_);
#line 2750 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 2751 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	*result = _result_;
#line 2751 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return;
#line 3107 "misc.c"
}


gboolean is_twentyfour_hr_time_system (void) {
	gboolean result = FALSE;
	struct tm _tmp0_ = {0};
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
#line 375 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_time_local ((time_t) 0, &_tmp0_);
#line 375 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = g_time_format (&_tmp0_, "%p");
#line 375 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp2_ = _tmp1_;
#line 375 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp3_ = is_string_empty (_tmp2_);
#line 375 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp4_ = _tmp3_;
#line 375 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_free0 (_tmp2_);
#line 375 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = _tmp4_;
#line 375 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 3134 "misc.c"
}



