/* MediaMonitor.c generated by valac 0.34.7, the Vala compiler
 * generated from MediaMonitor.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define TYPE_MONITORABLE_UPDATES (monitorable_updates_get_type ())
#define MONITORABLE_UPDATES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITORABLE_UPDATES, MonitorableUpdates))
#define MONITORABLE_UPDATES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MONITORABLE_UPDATES, MonitorableUpdatesClass))
#define IS_MONITORABLE_UPDATES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITORABLE_UPDATES))
#define IS_MONITORABLE_UPDATES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MONITORABLE_UPDATES))
#define MONITORABLE_UPDATES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MONITORABLE_UPDATES, MonitorableUpdatesClass))

typedef struct _MonitorableUpdates MonitorableUpdates;
typedef struct _MonitorableUpdatesClass MonitorableUpdatesClass;
typedef struct _MonitorableUpdatesPrivate MonitorableUpdatesPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_MONITORABLE (monitorable_get_type ())
#define MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITORABLE, Monitorable))
#define IS_MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITORABLE))
#define MONITORABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MONITORABLE, MonitorableIface))

typedef struct _Monitorable Monitorable;
typedef struct _MonitorableIface MonitorableIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecMonitorableUpdates ParamSpecMonitorableUpdates;

#define TYPE_MEDIA_MONITOR (media_monitor_get_type ())
#define MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_MONITOR, MediaMonitor))
#define MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_MONITOR, MediaMonitorClass))
#define IS_MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_MONITOR))
#define IS_MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_MONITOR))
#define MEDIA_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_MONITOR, MediaMonitorClass))

typedef struct _MediaMonitor MediaMonitor;
typedef struct _MediaMonitorClass MediaMonitorClass;
typedef struct _MediaMonitorPrivate MediaMonitorPrivate;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_MEDIA_SOURCE_COLLECTION (media_source_collection_get_type ())
#define MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection))
#define MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))
#define IS_MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_COLLECTION))
#define IS_MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_COLLECTION))
#define MEDIA_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))

typedef struct _MediaSourceCollection MediaSourceCollection;
typedef struct _MediaSourceCollectionClass MediaSourceCollectionClass;

#define MEDIA_MONITOR_TYPE_DISCOVERED_FILE (media_monitor_discovered_file_get_type ())

#define TYPE_TRANSACTION_CONTROLLER (transaction_controller_get_type ())
#define TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionController))
#define TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))
#define IS_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSACTION_CONTROLLER))
#define IS_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSACTION_CONTROLLER))
#define TRANSACTION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))

typedef struct _TransactionController TransactionController;
typedef struct _TransactionControllerClass TransactionControllerClass;
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _monitorable_updates_unref0(var) ((var == NULL) ? NULL : (var = (monitorable_updates_unref (var), NULL)))

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_LIBRARY_PHOTO (library_photo_get_type ())
#define LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO, LibraryPhoto))
#define LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))
#define IS_LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO))
#define IS_LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO))
#define LIBRARY_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))

typedef struct _LibraryPhoto LibraryPhoto;
typedef struct _LibraryPhotoClass LibraryPhotoClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _transaction_controller_unref0(var) ((var == NULL) ? NULL : (var = (transaction_controller_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

struct _MonitorableIface {
	GTypeInterface parent_iface;
	gboolean (*is_offline) (Monitorable* self);
	void (*mark_online) (Monitorable* self);
	void (*mark_offline) (Monitorable* self);
	void (*set_master_file) (Monitorable* self, GFile* file);
	void (*set_master_timestamp) (Monitorable* self, GFileInfo* info);
};

struct _MonitorableUpdates {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MonitorableUpdatesPrivate * priv;
	Monitorable* monitorable;
};

struct _MonitorableUpdatesClass {
	GTypeClass parent_class;
	void (*finalize) (MonitorableUpdates *self);
	gboolean (*is_in_alteration) (MonitorableUpdates* self);
	void (*set_master_file) (MonitorableUpdates* self, GFile* file);
	void (*set_master_file_info_altered) (MonitorableUpdates* self, gboolean altered);
	void (*set_master_file_info) (MonitorableUpdates* self, GFileInfo* info);
	void (*set_master_in_alteration) (MonitorableUpdates* self, gboolean in_alteration);
	void (*set_master_alterations_complete) (MonitorableUpdates* self, GFileInfo* info);
	void (*mark_offline) (MonitorableUpdates* self);
	void (*mark_online) (MonitorableUpdates* self);
	void (*reset_online_offline) (MonitorableUpdates* self);
	gboolean (*is_all_updated) (MonitorableUpdates* self);
};

struct _MonitorableUpdatesPrivate {
	GFile* master_file;
	gboolean master_file_info_altered;
	GFileInfo* master_file_info;
	gboolean master_in_alteration;
	gboolean online;
	gboolean offline;
};

struct _ParamSpecMonitorableUpdates {
	GParamSpec parent_instance;
};

typedef enum  {
	MEDIA_MONITOR_DISCOVERED_FILE_REPRESENTED,
	MEDIA_MONITOR_DISCOVERED_FILE_IGNORE,
	MEDIA_MONITOR_DISCOVERED_FILE_UNKNOWN
} MediaMonitorDiscoveredFile;

struct _MediaMonitor {
	GObject parent_instance;
	MediaMonitorPrivate * priv;
};

struct _MediaMonitorClass {
	GObjectClass parent_class;
	MediaSourceCollection* (*get_media_source_collection) (MediaMonitor* self);
	void (*close) (MediaMonitor* self);
	gchar* (*to_string) (MediaMonitor* self);
	MonitorableUpdates* (*create_updates) (MediaMonitor* self, Monitorable* monitorable);
	void (*on_media_source_destroyed) (MediaMonitor* self, DataSource* source);
	void (*notify_discovery_started) (MediaMonitor* self);
	MediaMonitorDiscoveredFile (*notify_file_discovered) (MediaMonitor* self, GFile* file, GFileInfo* info, Monitorable** monitorable);
	GeeCollection* (*candidates_for_unknown_file) (MediaMonitor* self, GFile* file, GFileInfo* info, MediaMonitorDiscoveredFile* _result_);
	GFile** (*get_auxilliary_backing_files) (MediaMonitor* self, Monitorable* monitorable, int* result_length1);
	void (*update_backing_file_info) (MediaMonitor* self, Monitorable* monitorable, GFile* file, GFileInfo* info);
	void (*notify_discovery_completing) (MediaMonitor* self);
	gboolean (*is_file_represented) (MediaMonitor* self, GFile* file);
	gboolean (*notify_file_created) (MediaMonitor* self, GFile* file, GFileInfo* info);
	gboolean (*notify_file_moved) (MediaMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info);
	gboolean (*notify_file_altered) (MediaMonitor* self, GFile* file);
	gboolean (*notify_file_attributes_altered) (MediaMonitor* self, GFile* file);
	gboolean (*notify_file_alteration_completed) (MediaMonitor* self, GFile* file, GFileInfo* info);
	gboolean (*notify_file_deleted) (MediaMonitor* self, GFile* file);
	void (*process_updates) (MediaMonitor* self, GeeCollection* all_updates, TransactionController* controller, gint* op_count, GError** error);
};

struct _MediaMonitorPrivate {
	MediaSourceCollection* sources;
	GCancellable* cancellable;
	GeeHashMap* pending_updates;
	guint pending_updates_timer_id;
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()

static gpointer monitorable_updates_parent_class = NULL;
static gpointer media_monitor_parent_class = NULL;

gpointer monitorable_updates_ref (gpointer instance);
void monitorable_updates_unref (gpointer instance);
GParamSpec* param_spec_monitorable_updates (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_monitorable_updates (GValue* value, gpointer v_object);
void value_take_monitorable_updates (GValue* value, gpointer v_object);
gpointer value_get_monitorable_updates (const GValue* value);
GType monitorable_updates_get_type (void) G_GNUC_CONST;
GType data_object_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
GType monitorable_get_type (void) G_GNUC_CONST;
#define MONITORABLE_UPDATES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MONITORABLE_UPDATES, MonitorableUpdatesPrivate))
enum  {
	MONITORABLE_UPDATES_DUMMY_PROPERTY
};
MonitorableUpdates* monitorable_updates_new (Monitorable* monitorable);
MonitorableUpdates* monitorable_updates_construct (GType object_type, Monitorable* monitorable);
GFile* monitorable_updates_get_master_file (MonitorableUpdates* self);
GFileInfo* monitorable_updates_get_master_file_info (MonitorableUpdates* self);
gboolean monitorable_updates_is_in_alteration (MonitorableUpdates* self);
static gboolean monitorable_updates_real_is_in_alteration (MonitorableUpdates* self);
gboolean monitorable_updates_is_set_offline (MonitorableUpdates* self);
gboolean monitorable_updates_is_set_online (MonitorableUpdates* self);
void monitorable_updates_set_master_file (MonitorableUpdates* self, GFile* file);
static void monitorable_updates_real_set_master_file (MonitorableUpdates* self, GFile* file);
void monitorable_updates_mark_online (MonitorableUpdates* self);
void monitorable_updates_set_master_file_info_altered (MonitorableUpdates* self, gboolean altered);
static void monitorable_updates_real_set_master_file_info_altered (MonitorableUpdates* self, gboolean altered);
void monitorable_updates_set_master_file_info (MonitorableUpdates* self, GFileInfo* info);
static void monitorable_updates_real_set_master_file_info (MonitorableUpdates* self, GFileInfo* info);
void monitorable_updates_set_master_in_alteration (MonitorableUpdates* self, gboolean in_alteration);
static void monitorable_updates_real_set_master_in_alteration (MonitorableUpdates* self, gboolean in_alteration);
void monitorable_updates_set_master_alterations_complete (MonitorableUpdates* self, GFileInfo* info);
static void monitorable_updates_real_set_master_alterations_complete (MonitorableUpdates* self, GFileInfo* info);
void monitorable_updates_mark_offline (MonitorableUpdates* self);
static void monitorable_updates_real_mark_offline (MonitorableUpdates* self);
static void monitorable_updates_real_mark_online (MonitorableUpdates* self);
void monitorable_updates_reset_online_offline (MonitorableUpdates* self);
static void monitorable_updates_real_reset_online_offline (MonitorableUpdates* self);
gboolean monitorable_updates_is_all_updated (MonitorableUpdates* self);
static gboolean monitorable_updates_real_is_all_updated (MonitorableUpdates* self);
static void monitorable_updates_finalize (MonitorableUpdates* obj);
GType media_monitor_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_collection (GValue* value, gpointer v_object);
void value_take_data_collection (GValue* value, gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
GType database_source_collection_get_type (void) G_GNUC_CONST;
GType media_source_collection_get_type (void) G_GNUC_CONST;
GType media_monitor_discovered_file_get_type (void) G_GNUC_CONST;
gpointer transaction_controller_ref (gpointer instance);
void transaction_controller_unref (gpointer instance);
GParamSpec* param_spec_transaction_controller (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_transaction_controller (GValue* value, gpointer v_object);
void value_take_transaction_controller (GValue* value, gpointer v_object);
gpointer value_get_transaction_controller (const GValue* value);
GType transaction_controller_get_type (void) G_GNUC_CONST;
#define MEDIA_MONITOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MEDIA_MONITOR, MediaMonitorPrivate))
enum  {
	MEDIA_MONITOR_DUMMY_PROPERTY
};
void media_monitor_on_media_source_destroyed (MediaMonitor* self, DataSource* source);
static void _media_monitor_on_media_source_destroyed_source_collection_item_destroyed (SourceCollection* _sender, DataSource* source, gpointer self);
static void _media_monitor_on_media_source_destroyed_source_collection_unlinked_destroyed (SourceCollection* _sender, DataSource* source, gpointer self);
#define MEDIA_MONITOR_MAX_OPERATIONS_PER_CYCLE 100
#define MEDIA_MONITOR_FLUSH_PENDING_UPDATES_MSEC 500
MediaMonitor* media_monitor_construct (GType object_type, MediaSourceCollection* sources, GCancellable* cancellable);
static gboolean media_monitor_on_flush_pending_updates (MediaMonitor* self);
static gboolean _media_monitor_on_flush_pending_updates_gsource_func (gpointer self);
MediaSourceCollection* media_monitor_get_media_source_collection (MediaMonitor* self);
static MediaSourceCollection* media_monitor_real_get_media_source_collection (MediaMonitor* self);
void media_monitor_close (MediaMonitor* self);
static void media_monitor_real_close (MediaMonitor* self);
gchar* media_monitor_to_string (MediaMonitor* self);
static gchar* media_monitor_real_to_string (MediaMonitor* self);
gchar* data_collection_to_string (DataCollection* self);
MonitorableUpdates* media_monitor_create_updates (MediaMonitor* self, Monitorable* monitorable);
static MonitorableUpdates* media_monitor_real_create_updates (MediaMonitor* self, Monitorable* monitorable);
static void media_monitor_real_on_media_source_destroyed (MediaMonitor* self, DataSource* source);
void media_monitor_remove_updates (MediaMonitor* self, Monitorable* monitorable);
void media_monitor_notify_discovery_started (MediaMonitor* self);
static void media_monitor_real_notify_discovery_started (MediaMonitor* self);
MediaMonitorDiscoveredFile media_monitor_notify_file_discovered (MediaMonitor* self, GFile* file, GFileInfo* info, Monitorable** monitorable);
static MediaMonitorDiscoveredFile media_monitor_real_notify_file_discovered (MediaMonitor* self, GFile* file, GFileInfo* info, Monitorable** monitorable);
GeeCollection* media_monitor_candidates_for_unknown_file (MediaMonitor* self, GFile* file, GFileInfo* info, MediaMonitorDiscoveredFile* _result_);
static GeeCollection* media_monitor_real_candidates_for_unknown_file (MediaMonitor* self, GFile* file, GFileInfo* info, MediaMonitorDiscoveredFile* _result_);
GFile** media_monitor_get_auxilliary_backing_files (MediaMonitor* self, Monitorable* monitorable, int* result_length1);
static GFile** media_monitor_real_get_auxilliary_backing_files (MediaMonitor* self, Monitorable* monitorable, int* result_length1);
void media_monitor_update_backing_file_info (MediaMonitor* self, Monitorable* monitorable, GFile* file, GFileInfo* info);
static void media_monitor_real_update_backing_file_info (MediaMonitor* self, Monitorable* monitorable, GFile* file, GFileInfo* info);
void media_monitor_notify_discovery_completing (MediaMonitor* self);
static void media_monitor_real_notify_discovery_completing (MediaMonitor* self);
gboolean media_monitor_is_file_represented (MediaMonitor* self, GFile* file);
static gboolean media_monitor_real_is_file_represented (MediaMonitor* self, GFile* file);
gboolean media_monitor_notify_file_created (MediaMonitor* self, GFile* file, GFileInfo* info);
static gboolean media_monitor_real_notify_file_created (MediaMonitor* self, GFile* file, GFileInfo* info);
gboolean media_monitor_notify_file_moved (MediaMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info);
static gboolean media_monitor_real_notify_file_moved (MediaMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info);
gboolean media_monitor_notify_file_altered (MediaMonitor* self, GFile* file);
static gboolean media_monitor_real_notify_file_altered (MediaMonitor* self, GFile* file);
gboolean media_monitor_notify_file_attributes_altered (MediaMonitor* self, GFile* file);
static gboolean media_monitor_real_notify_file_attributes_altered (MediaMonitor* self, GFile* file);
gboolean media_monitor_notify_file_alteration_completed (MediaMonitor* self, GFile* file, GFileInfo* info);
static gboolean media_monitor_real_notify_file_alteration_completed (MediaMonitor* self, GFile* file, GFileInfo* info);
gboolean media_monitor_notify_file_deleted (MediaMonitor* self, GFile* file);
static gboolean media_monitor_real_notify_file_deleted (MediaMonitor* self, GFile* file);
void media_monitor_mdbg (const gchar* msg);
gboolean media_monitor_has_pending_updates (MediaMonitor* self);
GeeCollection* media_monitor_get_monitorables (MediaMonitor* self);
MonitorableUpdates* media_monitor_fetch_updates (MediaMonitor* self, Monitorable* monitorable);
MonitorableUpdates* media_monitor_get_existing_updates (MediaMonitor* self, Monitorable* monitorable);
gboolean media_monitor_is_online (MediaMonitor* self, Monitorable* monitorable);
gboolean monitorable_is_offline (Monitorable* self);
gboolean media_monitor_is_offline (MediaMonitor* self, Monitorable* monitorable);
GFile* media_monitor_get_master_file (MediaMonitor* self, Monitorable* monitorable);
GFile* media_source_get_master_file (MediaSource* self);
void media_monitor_update_master_file (MediaMonitor* self, Monitorable* monitorable, GFile* file);
void media_monitor_update_master_file_info_altered (MediaMonitor* self, Monitorable* monitorable);
void media_monitor_update_master_file_in_alteration (MediaMonitor* self, Monitorable* monitorable, gboolean in_alteration);
void media_monitor_update_master_file_alterations_completed (MediaMonitor* self, Monitorable* monitorable, GFileInfo* info);
void media_monitor_update_online (MediaMonitor* self, Monitorable* monitorable);
void media_monitor_update_offline (MediaMonitor* self, Monitorable* monitorable);
void media_monitor_process_updates (MediaMonitor* self, GeeCollection* all_updates, TransactionController* controller, gint* op_count, GError** error);
static void media_monitor_real_process_updates (MediaMonitor* self, GeeCollection* all_updates, TransactionController* controller, gint* op_count, GError** error);
GType photo_source_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
GType library_photo_get_type (void) G_GNUC_CONST;
void monitorable_set_many_master_file (GeeMap* map, TransactionController* controller, GError** error);
void monitorable_set_many_master_timestamp (GeeMap* map, TransactionController* controller, GError** error);
void monitorable_mark_many_online_offline (GeeCollection* online, GeeCollection* offline, TransactionController* controller, GError** error);
TransactionController* media_source_collection_get_transaction_controller (MediaSourceCollection* self);
void transaction_controller_begin (TransactionController* self);
void transaction_controller_commit (TransactionController* self);
GQuark database_error_quark (void);
void app_window_database_error (GError* err);
void app_window_panic (const gchar* msg);
static void media_monitor_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
#line 18 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return self ? g_object_ref (self) : NULL;
#line 428 "MediaMonitor.c"
}


MonitorableUpdates* monitorable_updates_construct (GType object_type, Monitorable* monitorable) {
	MonitorableUpdates* self = NULL;
	Monitorable* _tmp0_ = NULL;
	Monitorable* _tmp1_ = NULL;
#line 17 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MONITORABLE (monitorable), NULL);
#line 17 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self = (MonitorableUpdates*) g_type_create_instance (object_type);
#line 18 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = monitorable;
#line 18 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 18 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_g_object_unref0 (self->monitorable);
#line 18 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self->monitorable = _tmp1_;
#line 17 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return self;
#line 450 "MediaMonitor.c"
}


MonitorableUpdates* monitorable_updates_new (Monitorable* monitorable) {
#line 17 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return monitorable_updates_construct (TYPE_MONITORABLE_UPDATES, monitorable);
#line 457 "MediaMonitor.c"
}


GFile* monitorable_updates_get_master_file (MonitorableUpdates* self) {
	GFile* result = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
#line 21 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MONITORABLE_UPDATES (self), NULL);
#line 22 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = self->priv->master_file;
#line 22 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 22 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	result = _tmp1_;
#line 22 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return result;
#line 475 "MediaMonitor.c"
}


GFileInfo* monitorable_updates_get_master_file_info (MonitorableUpdates* self) {
	GFileInfo* result = NULL;
	GFileInfo* _tmp0_ = NULL;
	GFileInfo* _tmp1_ = NULL;
#line 25 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MONITORABLE_UPDATES (self), NULL);
#line 26 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = self->priv->master_file_info;
#line 26 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 26 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	result = _tmp1_;
#line 26 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return result;
#line 493 "MediaMonitor.c"
}


static gboolean monitorable_updates_real_is_in_alteration (MonitorableUpdates* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 30 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = self->priv->master_in_alteration;
#line 30 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	result = _tmp0_;
#line 30 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return result;
#line 506 "MediaMonitor.c"
}


gboolean monitorable_updates_is_in_alteration (MonitorableUpdates* self) {
#line 29 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MONITORABLE_UPDATES (self), FALSE);
#line 29 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return MONITORABLE_UPDATES_GET_CLASS (self)->is_in_alteration (self);
#line 515 "MediaMonitor.c"
}


gboolean monitorable_updates_is_set_offline (MonitorableUpdates* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 33 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MONITORABLE_UPDATES (self), FALSE);
#line 34 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = self->priv->offline;
#line 34 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	result = _tmp0_;
#line 34 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return result;
#line 530 "MediaMonitor.c"
}


gboolean monitorable_updates_is_set_online (MonitorableUpdates* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 37 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MONITORABLE_UPDATES (self), FALSE);
#line 38 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = self->priv->online;
#line 38 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	result = _tmp0_;
#line 38 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return result;
#line 545 "MediaMonitor.c"
}


static void monitorable_updates_real_set_master_file (MonitorableUpdates* self, GFile* file) {
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
#line 41 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail ((file == NULL) || G_IS_FILE (file));
#line 42 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = file;
#line 42 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 42 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_g_object_unref0 (self->priv->master_file);
#line 42 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self->priv->master_file = _tmp1_;
#line 44 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp2_ = file;
#line 44 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (_tmp2_ != NULL) {
#line 45 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		monitorable_updates_mark_online (self);
#line 569 "MediaMonitor.c"
	}
}


void monitorable_updates_set_master_file (MonitorableUpdates* self, GFile* file) {
#line 41 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (IS_MONITORABLE_UPDATES (self));
#line 41 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	MONITORABLE_UPDATES_GET_CLASS (self)->set_master_file (self, file);
#line 579 "MediaMonitor.c"
}


static void monitorable_updates_real_set_master_file_info_altered (MonitorableUpdates* self, gboolean altered) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 49 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = altered;
#line 49 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self->priv->master_file_info_altered = _tmp0_;
#line 51 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp1_ = altered;
#line 51 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (_tmp1_) {
#line 52 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		monitorable_updates_mark_online (self);
#line 596 "MediaMonitor.c"
	}
}


void monitorable_updates_set_master_file_info_altered (MonitorableUpdates* self, gboolean altered) {
#line 48 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (IS_MONITORABLE_UPDATES (self));
#line 48 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	MONITORABLE_UPDATES_GET_CLASS (self)->set_master_file_info_altered (self, altered);
#line 606 "MediaMonitor.c"
}


static void monitorable_updates_real_set_master_file_info (MonitorableUpdates* self, GFileInfo* info) {
	GFileInfo* _tmp0_ = NULL;
	GFileInfo* _tmp1_ = NULL;
	GFileInfo* _tmp2_ = NULL;
#line 55 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail ((info == NULL) || G_IS_FILE_INFO (info));
#line 56 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = info;
#line 56 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 56 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_g_object_unref0 (self->priv->master_file_info);
#line 56 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self->priv->master_file_info = _tmp1_;
#line 58 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp2_ = self->priv->master_file_info;
#line 58 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (_tmp2_ == NULL) {
#line 59 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		monitorable_updates_set_master_file_info_altered (self, FALSE);
#line 630 "MediaMonitor.c"
	}
}


void monitorable_updates_set_master_file_info (MonitorableUpdates* self, GFileInfo* info) {
#line 55 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (IS_MONITORABLE_UPDATES (self));
#line 55 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	MONITORABLE_UPDATES_GET_CLASS (self)->set_master_file_info (self, info);
#line 640 "MediaMonitor.c"
}


static void monitorable_updates_real_set_master_in_alteration (MonitorableUpdates* self, gboolean in_alteration) {
	gboolean _tmp0_ = FALSE;
#line 63 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = in_alteration;
#line 63 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self->priv->master_in_alteration = _tmp0_;
#line 650 "MediaMonitor.c"
}


void monitorable_updates_set_master_in_alteration (MonitorableUpdates* self, gboolean in_alteration) {
#line 62 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (IS_MONITORABLE_UPDATES (self));
#line 62 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	MONITORABLE_UPDATES_GET_CLASS (self)->set_master_in_alteration (self, in_alteration);
#line 659 "MediaMonitor.c"
}


static void monitorable_updates_real_set_master_alterations_complete (MonitorableUpdates* self, GFileInfo* info) {
	GFileInfo* _tmp0_ = NULL;
#line 66 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 67 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	monitorable_updates_set_master_in_alteration (self, FALSE);
#line 68 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = info;
#line 68 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	monitorable_updates_set_master_file_info (self, _tmp0_);
#line 69 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	monitorable_updates_mark_online (self);
#line 675 "MediaMonitor.c"
}


void monitorable_updates_set_master_alterations_complete (MonitorableUpdates* self, GFileInfo* info) {
#line 66 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (IS_MONITORABLE_UPDATES (self));
#line 66 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	MONITORABLE_UPDATES_GET_CLASS (self)->set_master_alterations_complete (self, info);
#line 684 "MediaMonitor.c"
}


static void monitorable_updates_real_mark_offline (MonitorableUpdates* self) {
#line 73 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self->priv->online = FALSE;
#line 74 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self->priv->offline = TRUE;
#line 76 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self->priv->master_file_info_altered = FALSE;
#line 77 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_g_object_unref0 (self->priv->master_file_info);
#line 77 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self->priv->master_file_info = NULL;
#line 78 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self->priv->master_in_alteration = FALSE;
#line 701 "MediaMonitor.c"
}


void monitorable_updates_mark_offline (MonitorableUpdates* self) {
#line 72 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (IS_MONITORABLE_UPDATES (self));
#line 72 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	MONITORABLE_UPDATES_GET_CLASS (self)->mark_offline (self);
#line 710 "MediaMonitor.c"
}


static void monitorable_updates_real_mark_online (MonitorableUpdates* self) {
#line 82 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self->priv->online = TRUE;
#line 83 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self->priv->offline = FALSE;
#line 719 "MediaMonitor.c"
}


void monitorable_updates_mark_online (MonitorableUpdates* self) {
#line 81 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (IS_MONITORABLE_UPDATES (self));
#line 81 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	MONITORABLE_UPDATES_GET_CLASS (self)->mark_online (self);
#line 728 "MediaMonitor.c"
}


static void monitorable_updates_real_reset_online_offline (MonitorableUpdates* self) {
#line 87 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self->priv->online = FALSE;
#line 88 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self->priv->offline = FALSE;
#line 737 "MediaMonitor.c"
}


void monitorable_updates_reset_online_offline (MonitorableUpdates* self) {
#line 86 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (IS_MONITORABLE_UPDATES (self));
#line 86 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	MONITORABLE_UPDATES_GET_CLASS (self)->reset_online_offline (self);
#line 746 "MediaMonitor.c"
}


static gboolean monitorable_updates_real_is_all_updated (MonitorableUpdates* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GFile* _tmp5_ = NULL;
#line 92 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp5_ = self->priv->master_file;
#line 92 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (_tmp5_ == NULL) {
#line 762 "MediaMonitor.c"
		gboolean _tmp6_ = FALSE;
#line 93 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp6_ = self->priv->master_file_info_altered;
#line 93 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp4_ = _tmp6_ == FALSE;
#line 768 "MediaMonitor.c"
	} else {
#line 92 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp4_ = FALSE;
#line 772 "MediaMonitor.c"
	}
#line 92 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (_tmp4_) {
#line 776 "MediaMonitor.c"
		GFileInfo* _tmp7_ = NULL;
#line 94 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp7_ = self->priv->master_file_info;
#line 94 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp3_ = _tmp7_ == NULL;
#line 782 "MediaMonitor.c"
	} else {
#line 92 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp3_ = FALSE;
#line 786 "MediaMonitor.c"
	}
#line 92 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (_tmp3_) {
#line 790 "MediaMonitor.c"
		gboolean _tmp8_ = FALSE;
#line 95 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp8_ = self->priv->master_in_alteration;
#line 95 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp2_ = _tmp8_ == FALSE;
#line 796 "MediaMonitor.c"
	} else {
#line 92 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp2_ = FALSE;
#line 800 "MediaMonitor.c"
	}
#line 92 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (_tmp2_) {
#line 804 "MediaMonitor.c"
		gboolean _tmp9_ = FALSE;
#line 96 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp9_ = self->priv->online;
#line 96 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp1_ = _tmp9_ == FALSE;
#line 810 "MediaMonitor.c"
	} else {
#line 92 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp1_ = FALSE;
#line 814 "MediaMonitor.c"
	}
#line 92 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (_tmp1_) {
#line 818 "MediaMonitor.c"
		gboolean _tmp10_ = FALSE;
#line 97 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp10_ = self->priv->offline;
#line 97 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp0_ = _tmp10_ == FALSE;
#line 824 "MediaMonitor.c"
	} else {
#line 92 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp0_ = FALSE;
#line 828 "MediaMonitor.c"
	}
#line 92 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	result = _tmp0_;
#line 92 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return result;
#line 834 "MediaMonitor.c"
}


gboolean monitorable_updates_is_all_updated (MonitorableUpdates* self) {
#line 91 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MONITORABLE_UPDATES (self), FALSE);
#line 91 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return MONITORABLE_UPDATES_GET_CLASS (self)->is_all_updated (self);
#line 843 "MediaMonitor.c"
}


static void value_monitorable_updates_init (GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	value->data[0].v_pointer = NULL;
#line 850 "MediaMonitor.c"
}


static void value_monitorable_updates_free_value (GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		monitorable_updates_unref (value->data[0].v_pointer);
#line 859 "MediaMonitor.c"
	}
}


static void value_monitorable_updates_copy_value (const GValue* src_value, GValue* dest_value) {
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (src_value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		dest_value->data[0].v_pointer = monitorable_updates_ref (src_value->data[0].v_pointer);
#line 869 "MediaMonitor.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		dest_value->data[0].v_pointer = NULL;
#line 873 "MediaMonitor.c"
	}
}


static gpointer value_monitorable_updates_peek_pointer (const GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return value->data[0].v_pointer;
#line 881 "MediaMonitor.c"
}


static gchar* value_monitorable_updates_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (collect_values[0].v_pointer) {
#line 888 "MediaMonitor.c"
		MonitorableUpdates* object;
		object = collect_values[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		if (object->parent_instance.g_class == NULL) {
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 895 "MediaMonitor.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 899 "MediaMonitor.c"
		}
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		value->data[0].v_pointer = monitorable_updates_ref (object);
#line 903 "MediaMonitor.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		value->data[0].v_pointer = NULL;
#line 907 "MediaMonitor.c"
	}
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return NULL;
#line 911 "MediaMonitor.c"
}


static gchar* value_monitorable_updates_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	MonitorableUpdates** object_p;
	object_p = collect_values[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (!object_p) {
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 922 "MediaMonitor.c"
	}
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (!value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		*object_p = NULL;
#line 928 "MediaMonitor.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		*object_p = value->data[0].v_pointer;
#line 932 "MediaMonitor.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		*object_p = monitorable_updates_ref (value->data[0].v_pointer);
#line 936 "MediaMonitor.c"
	}
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return NULL;
#line 940 "MediaMonitor.c"
}


GParamSpec* param_spec_monitorable_updates (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecMonitorableUpdates* spec;
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MONITORABLE_UPDATES), NULL);
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return G_PARAM_SPEC (spec);
#line 954 "MediaMonitor.c"
}


gpointer value_get_monitorable_updates (const GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MONITORABLE_UPDATES), NULL);
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return value->data[0].v_pointer;
#line 963 "MediaMonitor.c"
}


void value_set_monitorable_updates (GValue* value, gpointer v_object) {
	MonitorableUpdates* old;
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MONITORABLE_UPDATES));
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	old = value->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (v_object) {
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MONITORABLE_UPDATES));
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		value->data[0].v_pointer = v_object;
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		monitorable_updates_ref (value->data[0].v_pointer);
#line 983 "MediaMonitor.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		value->data[0].v_pointer = NULL;
#line 987 "MediaMonitor.c"
	}
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (old) {
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		monitorable_updates_unref (old);
#line 993 "MediaMonitor.c"
	}
}


void value_take_monitorable_updates (GValue* value, gpointer v_object) {
	MonitorableUpdates* old;
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MONITORABLE_UPDATES));
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	old = value->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (v_object) {
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MONITORABLE_UPDATES));
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		value->data[0].v_pointer = v_object;
#line 1012 "MediaMonitor.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		value->data[0].v_pointer = NULL;
#line 1016 "MediaMonitor.c"
	}
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (old) {
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		monitorable_updates_unref (old);
#line 1022 "MediaMonitor.c"
	}
}


static void monitorable_updates_class_init (MonitorableUpdatesClass * klass) {
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	monitorable_updates_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	((MonitorableUpdatesClass *) klass)->finalize = monitorable_updates_finalize;
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_type_class_add_private (klass, sizeof (MonitorableUpdatesPrivate));
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	((MonitorableUpdatesClass *) klass)->is_in_alteration = (gboolean (*)(MonitorableUpdates*)) monitorable_updates_real_is_in_alteration;
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	((MonitorableUpdatesClass *) klass)->set_master_file = (void (*)(MonitorableUpdates*, GFile*)) monitorable_updates_real_set_master_file;
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	((MonitorableUpdatesClass *) klass)->set_master_file_info_altered = (void (*)(MonitorableUpdates*, gboolean)) monitorable_updates_real_set_master_file_info_altered;
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	((MonitorableUpdatesClass *) klass)->set_master_file_info = (void (*)(MonitorableUpdates*, GFileInfo*)) monitorable_updates_real_set_master_file_info;
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	((MonitorableUpdatesClass *) klass)->set_master_in_alteration = (void (*)(MonitorableUpdates*, gboolean)) monitorable_updates_real_set_master_in_alteration;
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	((MonitorableUpdatesClass *) klass)->set_master_alterations_complete = (void (*)(MonitorableUpdates*, GFileInfo*)) monitorable_updates_real_set_master_alterations_complete;
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	((MonitorableUpdatesClass *) klass)->mark_offline = (void (*)(MonitorableUpdates*)) monitorable_updates_real_mark_offline;
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	((MonitorableUpdatesClass *) klass)->mark_online = (void (*)(MonitorableUpdates*)) monitorable_updates_real_mark_online;
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	((MonitorableUpdatesClass *) klass)->reset_online_offline = (void (*)(MonitorableUpdates*)) monitorable_updates_real_reset_online_offline;
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	((MonitorableUpdatesClass *) klass)->is_all_updated = (gboolean (*)(MonitorableUpdates*)) monitorable_updates_real_is_all_updated;
#line 1054 "MediaMonitor.c"
}


static void monitorable_updates_instance_init (MonitorableUpdates * self) {
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self->priv = MONITORABLE_UPDATES_GET_PRIVATE (self);
#line 10 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self->priv->master_file = NULL;
#line 11 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self->priv->master_file_info_altered = FALSE;
#line 12 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self->priv->master_file_info = NULL;
#line 13 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self->priv->master_in_alteration = FALSE;
#line 14 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self->priv->online = FALSE;
#line 15 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self->priv->offline = FALSE;
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self->ref_count = 1;
#line 1075 "MediaMonitor.c"
}


static void monitorable_updates_finalize (MonitorableUpdates* obj) {
	MonitorableUpdates * self;
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MONITORABLE_UPDATES, MonitorableUpdates);
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_signal_handlers_destroy (self);
#line 8 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_g_object_unref0 (self->monitorable);
#line 10 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_g_object_unref0 (self->priv->master_file);
#line 12 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_g_object_unref0 (self->priv->master_file_info);
#line 1091 "MediaMonitor.c"
}


GType monitorable_updates_get_type (void) {
	static volatile gsize monitorable_updates_type_id__volatile = 0;
	if (g_once_init_enter (&monitorable_updates_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_monitorable_updates_init, value_monitorable_updates_free_value, value_monitorable_updates_copy_value, value_monitorable_updates_peek_pointer, "p", value_monitorable_updates_collect_value, "p", value_monitorable_updates_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (MonitorableUpdatesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) monitorable_updates_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MonitorableUpdates), 0, (GInstanceInitFunc) monitorable_updates_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType monitorable_updates_type_id;
		monitorable_updates_type_id = g_type_register_fundamental (g_type_fundamental_next (), "MonitorableUpdates", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&monitorable_updates_type_id__volatile, monitorable_updates_type_id);
	}
	return monitorable_updates_type_id__volatile;
}


gpointer monitorable_updates_ref (gpointer instance) {
	MonitorableUpdates* self;
	self = instance;
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_atomic_int_inc (&self->ref_count);
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return instance;
#line 1116 "MediaMonitor.c"
}


void monitorable_updates_unref (gpointer instance) {
	MonitorableUpdates* self;
	self = instance;
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		MONITORABLE_UPDATES_GET_CLASS (self)->finalize (self);
#line 7 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1129 "MediaMonitor.c"
	}
}


static void _media_monitor_on_media_source_destroyed_source_collection_item_destroyed (SourceCollection* _sender, DataSource* source, gpointer self) {
#line 130 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	media_monitor_on_media_source_destroyed ((MediaMonitor*) self, source);
#line 1137 "MediaMonitor.c"
}


static void _media_monitor_on_media_source_destroyed_source_collection_unlinked_destroyed (SourceCollection* _sender, DataSource* source, gpointer self) {
#line 131 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	media_monitor_on_media_source_destroyed ((MediaMonitor*) self, source);
#line 1144 "MediaMonitor.c"
}


GType media_monitor_discovered_file_get_type (void) {
	static volatile gsize media_monitor_discovered_file_type_id__volatile = 0;
	if (g_once_init_enter (&media_monitor_discovered_file_type_id__volatile)) {
		static const GEnumValue values[] = {{MEDIA_MONITOR_DISCOVERED_FILE_REPRESENTED, "MEDIA_MONITOR_DISCOVERED_FILE_REPRESENTED", "represented"}, {MEDIA_MONITOR_DISCOVERED_FILE_IGNORE, "MEDIA_MONITOR_DISCOVERED_FILE_IGNORE", "ignore"}, {MEDIA_MONITOR_DISCOVERED_FILE_UNKNOWN, "MEDIA_MONITOR_DISCOVERED_FILE_UNKNOWN", "unknown"}, {0, NULL, NULL}};
		GType media_monitor_discovered_file_type_id;
		media_monitor_discovered_file_type_id = g_enum_register_static ("MediaMonitorDiscoveredFile", values);
		g_once_init_leave (&media_monitor_discovered_file_type_id__volatile, media_monitor_discovered_file_type_id);
	}
	return media_monitor_discovered_file_type_id__volatile;
}


static gpointer _data_collection_ref0 (gpointer self) {
#line 119 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return self ? data_collection_ref (self) : NULL;
#line 1163 "MediaMonitor.c"
}


static gboolean _media_monitor_on_flush_pending_updates_gsource_func (gpointer self) {
	gboolean result;
	result = media_monitor_on_flush_pending_updates ((MediaMonitor*) self);
#line 125 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return result;
#line 1172 "MediaMonitor.c"
}


MediaMonitor* media_monitor_construct (GType object_type, MediaSourceCollection* sources, GCancellable* cancellable) {
	MediaMonitor * self = NULL;
	MediaSourceCollection* _tmp0_ = NULL;
	MediaSourceCollection* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	MediaSourceCollection* _tmp4_ = NULL;
	MediaSourceCollection* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
#line 118 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE_COLLECTION (sources), NULL);
#line 118 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (G_IS_CANCELLABLE (cancellable), NULL);
#line 118 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self = (MediaMonitor*) g_object_new (object_type, NULL);
#line 119 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = sources;
#line 119 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp1_ = _data_collection_ref0 (_tmp0_);
#line 119 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_data_collection_unref0 (self->priv->sources);
#line 119 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self->priv->sources = _tmp1_;
#line 120 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp2_ = cancellable;
#line 120 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 120 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 120 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self->priv->cancellable = _tmp3_;
#line 122 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp4_ = sources;
#line 122 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_SOURCE_COLLECTION, SourceCollection), "item-destroyed", (GCallback) _media_monitor_on_media_source_destroyed_source_collection_item_destroyed, self, 0);
#line 123 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp5_ = sources;
#line 123 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_SOURCE_COLLECTION, SourceCollection), "unlinked-destroyed", (GCallback) _media_monitor_on_media_source_destroyed_source_collection_unlinked_destroyed, self, 0);
#line 125 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp6_ = g_timeout_add_full (G_PRIORITY_LOW, (guint) MEDIA_MONITOR_FLUSH_PENDING_UPDATES_MSEC, _media_monitor_on_flush_pending_updates_gsource_func, g_object_ref (self), g_object_unref);
#line 125 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self->priv->pending_updates_timer_id = _tmp6_;
#line 118 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return self;
#line 1221 "MediaMonitor.c"
}


static MediaSourceCollection* media_monitor_real_get_media_source_collection (MediaMonitor* self) {
#line 134 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_critical ("Type `%s' does not implement abstract method `media_monitor_get_media_source_collection'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 134 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return NULL;
#line 1230 "MediaMonitor.c"
}


MediaSourceCollection* media_monitor_get_media_source_collection (MediaMonitor* self) {
#line 134 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), NULL);
#line 134 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return MEDIA_MONITOR_GET_CLASS (self)->get_media_source_collection (self);
#line 1239 "MediaMonitor.c"
}


static void media_monitor_real_close (MediaMonitor* self) {
}


void media_monitor_close (MediaMonitor* self) {
#line 136 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (IS_MEDIA_MONITOR (self));
#line 136 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	MEDIA_MONITOR_GET_CLASS (self)->close (self);
#line 1252 "MediaMonitor.c"
}


static gchar* media_monitor_real_to_string (MediaMonitor* self) {
	gchar* result = NULL;
	MediaSourceCollection* _tmp0_ = NULL;
	MediaSourceCollection* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
#line 140 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = media_monitor_get_media_source_collection (self);
#line 140 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp1_ = _tmp0_;
#line 140 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp2_ = data_collection_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_COLLECTION, DataCollection));
#line 140 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp3_ = _tmp2_;
#line 140 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp4_ = g_strdup_printf ("MediaMonitor for %s", _tmp3_);
#line 140 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp5_ = _tmp4_;
#line 140 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_g_free0 (_tmp3_);
#line 140 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_data_collection_unref0 (_tmp1_);
#line 140 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	result = _tmp5_;
#line 140 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return result;
#line 1284 "MediaMonitor.c"
}


gchar* media_monitor_to_string (MediaMonitor* self) {
#line 139 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), NULL);
#line 139 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return MEDIA_MONITOR_GET_CLASS (self)->to_string (self);
#line 1293 "MediaMonitor.c"
}


static MonitorableUpdates* media_monitor_real_create_updates (MediaMonitor* self, Monitorable* monitorable) {
	MonitorableUpdates* result = NULL;
	Monitorable* _tmp0_ = NULL;
	MonitorableUpdates* _tmp1_ = NULL;
#line 143 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MONITORABLE (monitorable), NULL);
#line 144 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = monitorable;
#line 144 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp1_ = monitorable_updates_new (_tmp0_);
#line 144 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	result = _tmp1_;
#line 144 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return result;
#line 1311 "MediaMonitor.c"
}


MonitorableUpdates* media_monitor_create_updates (MediaMonitor* self, Monitorable* monitorable) {
#line 143 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), NULL);
#line 143 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return MEDIA_MONITOR_GET_CLASS (self)->create_updates (self, monitorable);
#line 1320 "MediaMonitor.c"
}


static void media_monitor_real_on_media_source_destroyed (MediaMonitor* self, DataSource* source) {
	DataSource* _tmp0_ = NULL;
#line 147 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (IS_DATA_SOURCE (source));
#line 148 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = source;
#line 148 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	media_monitor_remove_updates (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MONITORABLE, Monitorable));
#line 1332 "MediaMonitor.c"
}


void media_monitor_on_media_source_destroyed (MediaMonitor* self, DataSource* source) {
#line 147 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (IS_MEDIA_MONITOR (self));
#line 147 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	MEDIA_MONITOR_GET_CLASS (self)->on_media_source_destroyed (self, source);
#line 1341 "MediaMonitor.c"
}


static void media_monitor_real_notify_discovery_started (MediaMonitor* self) {
}


void media_monitor_notify_discovery_started (MediaMonitor* self) {
#line 155 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (IS_MEDIA_MONITOR (self));
#line 155 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	MEDIA_MONITOR_GET_CLASS (self)->notify_discovery_started (self);
#line 1354 "MediaMonitor.c"
}


static MediaMonitorDiscoveredFile media_monitor_real_notify_file_discovered (MediaMonitor* self, GFile* file, GFileInfo* info, Monitorable** monitorable) {
#line 160 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_critical ("Type `%s' does not implement abstract method `media_monitor_notify_file_discovered'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 160 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return 0;
#line 1363 "MediaMonitor.c"
}


MediaMonitorDiscoveredFile media_monitor_notify_file_discovered (MediaMonitor* self, GFile* file, GFileInfo* info, Monitorable** monitorable) {
#line 160 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), 0);
#line 160 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return MEDIA_MONITOR_GET_CLASS (self)->notify_file_discovered (self, file, info, monitorable);
#line 1372 "MediaMonitor.c"
}


static GeeCollection* media_monitor_real_candidates_for_unknown_file (MediaMonitor* self, GFile* file, GFileInfo* info, MediaMonitorDiscoveredFile* _result_) {
#line 169 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_critical ("Type `%s' does not implement abstract method `media_monitor_candidates_for_unknown_file'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 169 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return NULL;
#line 1381 "MediaMonitor.c"
}


GeeCollection* media_monitor_candidates_for_unknown_file (MediaMonitor* self, GFile* file, GFileInfo* info, MediaMonitorDiscoveredFile* _result_) {
#line 169 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), NULL);
#line 169 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return MEDIA_MONITOR_GET_CLASS (self)->candidates_for_unknown_file (self, file, info, _result_);
#line 1390 "MediaMonitor.c"
}


static GFile** media_monitor_real_get_auxilliary_backing_files (MediaMonitor* self, Monitorable* monitorable, int* result_length1) {
	GFile** result = NULL;
	GFile** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
#line 172 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MONITORABLE (monitorable), NULL);
#line 173 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = NULL;
#line 173 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0__length1 = 0;
#line 173 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (result_length1) {
#line 173 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		*result_length1 = _tmp0__length1;
#line 1408 "MediaMonitor.c"
	}
#line 173 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	result = _tmp0_;
#line 173 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return result;
#line 1414 "MediaMonitor.c"
}


GFile** media_monitor_get_auxilliary_backing_files (MediaMonitor* self, Monitorable* monitorable, int* result_length1) {
#line 172 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), NULL);
#line 172 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return MEDIA_MONITOR_GET_CLASS (self)->get_auxilliary_backing_files (self, monitorable, result_length1);
#line 1423 "MediaMonitor.c"
}


static void media_monitor_real_update_backing_file_info (MediaMonitor* self, Monitorable* monitorable, GFile* file, GFileInfo* info) {
#line 178 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (IS_MONITORABLE (monitorable));
#line 178 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 178 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail ((info == NULL) || G_IS_FILE_INFO (info));
#line 1434 "MediaMonitor.c"
}


void media_monitor_update_backing_file_info (MediaMonitor* self, Monitorable* monitorable, GFile* file, GFileInfo* info) {
#line 178 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (IS_MEDIA_MONITOR (self));
#line 178 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	MEDIA_MONITOR_GET_CLASS (self)->update_backing_file_info (self, monitorable, file, info);
#line 1443 "MediaMonitor.c"
}


static void media_monitor_real_notify_discovery_completing (MediaMonitor* self) {
}


void media_monitor_notify_discovery_completing (MediaMonitor* self) {
#line 182 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (IS_MEDIA_MONITOR (self));
#line 182 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	MEDIA_MONITOR_GET_CLASS (self)->notify_discovery_completing (self);
#line 1456 "MediaMonitor.c"
}


static gboolean media_monitor_real_is_file_represented (MediaMonitor* self, GFile* file) {
	gboolean _tmp0_ = FALSE;
#line 189 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_critical ("Type `%s' does not implement abstract method `media_monitor_is_file_represented'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 189 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return _tmp0_;
#line 1466 "MediaMonitor.c"
}


gboolean media_monitor_is_file_represented (MediaMonitor* self, GFile* file) {
#line 189 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), FALSE);
#line 189 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return MEDIA_MONITOR_GET_CLASS (self)->is_file_represented (self, file);
#line 1475 "MediaMonitor.c"
}


static gboolean media_monitor_real_notify_file_created (MediaMonitor* self, GFile* file, GFileInfo* info) {
	gboolean _tmp0_ = FALSE;
#line 191 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_critical ("Type `%s' does not implement abstract method `media_monitor_notify_file_created'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 191 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return _tmp0_;
#line 1485 "MediaMonitor.c"
}


gboolean media_monitor_notify_file_created (MediaMonitor* self, GFile* file, GFileInfo* info) {
#line 191 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), FALSE);
#line 191 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return MEDIA_MONITOR_GET_CLASS (self)->notify_file_created (self, file, info);
#line 1494 "MediaMonitor.c"
}


static gboolean media_monitor_real_notify_file_moved (MediaMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info) {
	gboolean _tmp0_ = FALSE;
#line 193 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_critical ("Type `%s' does not implement abstract method `media_monitor_notify_file_moved'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 193 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return _tmp0_;
#line 1504 "MediaMonitor.c"
}


gboolean media_monitor_notify_file_moved (MediaMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info) {
#line 193 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), FALSE);
#line 193 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return MEDIA_MONITOR_GET_CLASS (self)->notify_file_moved (self, old_file, new_file, new_file_info);
#line 1513 "MediaMonitor.c"
}


static gboolean media_monitor_real_notify_file_altered (MediaMonitor* self, GFile* file) {
	gboolean _tmp0_ = FALSE;
#line 195 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_critical ("Type `%s' does not implement abstract method `media_monitor_notify_file_altered'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 195 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return _tmp0_;
#line 1523 "MediaMonitor.c"
}


gboolean media_monitor_notify_file_altered (MediaMonitor* self, GFile* file) {
#line 195 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), FALSE);
#line 195 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return MEDIA_MONITOR_GET_CLASS (self)->notify_file_altered (self, file);
#line 1532 "MediaMonitor.c"
}


static gboolean media_monitor_real_notify_file_attributes_altered (MediaMonitor* self, GFile* file) {
	gboolean _tmp0_ = FALSE;
#line 197 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_critical ("Type `%s' does not implement abstract method `media_monitor_notify_file_attributes_altered'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 197 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return _tmp0_;
#line 1542 "MediaMonitor.c"
}


gboolean media_monitor_notify_file_attributes_altered (MediaMonitor* self, GFile* file) {
#line 197 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), FALSE);
#line 197 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return MEDIA_MONITOR_GET_CLASS (self)->notify_file_attributes_altered (self, file);
#line 1551 "MediaMonitor.c"
}


static gboolean media_monitor_real_notify_file_alteration_completed (MediaMonitor* self, GFile* file, GFileInfo* info) {
	gboolean _tmp0_ = FALSE;
#line 199 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_critical ("Type `%s' does not implement abstract method `media_monitor_notify_file_alteration_completed'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 199 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return _tmp0_;
#line 1561 "MediaMonitor.c"
}


gboolean media_monitor_notify_file_alteration_completed (MediaMonitor* self, GFile* file, GFileInfo* info) {
#line 199 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), FALSE);
#line 199 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return MEDIA_MONITOR_GET_CLASS (self)->notify_file_alteration_completed (self, file, info);
#line 1570 "MediaMonitor.c"
}


static gboolean media_monitor_real_notify_file_deleted (MediaMonitor* self, GFile* file) {
	gboolean _tmp0_ = FALSE;
#line 201 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_critical ("Type `%s' does not implement abstract method `media_monitor_notify_file_deleted'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 201 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return _tmp0_;
#line 1580 "MediaMonitor.c"
}


gboolean media_monitor_notify_file_deleted (MediaMonitor* self, GFile* file) {
#line 201 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), FALSE);
#line 201 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return MEDIA_MONITOR_GET_CLASS (self)->notify_file_deleted (self, file);
#line 1589 "MediaMonitor.c"
}


void media_monitor_mdbg (const gchar* msg) {
#line 203 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (msg != NULL);
#line 1596 "MediaMonitor.c"
}


gboolean media_monitor_has_pending_updates (MediaMonitor* self) {
	gboolean result = FALSE;
	GeeHashMap* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 209 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), FALSE);
#line 210 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = self->priv->pending_updates;
#line 210 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp1_ = gee_abstract_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 210 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp2_ = _tmp1_;
#line 210 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	result = _tmp2_ > 0;
#line 210 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return result;
#line 1617 "MediaMonitor.c"
}


GeeCollection* media_monitor_get_monitorables (MediaMonitor* self) {
	GeeCollection* result = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeSet* _tmp1_ = NULL;
	GeeSet* _tmp2_ = NULL;
#line 213 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), NULL);
#line 214 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = self->priv->pending_updates;
#line 214 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp1_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 214 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp2_ = _tmp1_;
#line 214 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
#line 214 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return result;
#line 1638 "MediaMonitor.c"
}


MonitorableUpdates* media_monitor_fetch_updates (MediaMonitor* self, Monitorable* monitorable) {
	MonitorableUpdates* result = NULL;
	MonitorableUpdates* updates = NULL;
	GeeHashMap* _tmp0_ = NULL;
	Monitorable* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	MonitorableUpdates* _tmp3_ = NULL;
	Monitorable* _tmp4_ = NULL;
	MonitorableUpdates* _tmp5_ = NULL;
	GeeHashMap* _tmp6_ = NULL;
	Monitorable* _tmp7_ = NULL;
	MonitorableUpdates* _tmp8_ = NULL;
#line 219 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), NULL);
#line 219 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MONITORABLE (monitorable), NULL);
#line 220 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = self->priv->pending_updates;
#line 220 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp1_ = monitorable;
#line 220 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_);
#line 220 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	updates = (MonitorableUpdates*) _tmp2_;
#line 221 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp3_ = updates;
#line 221 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (_tmp3_ != NULL) {
#line 222 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		result = updates;
#line 222 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		return result;
#line 1674 "MediaMonitor.c"
	}
#line 224 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp4_ = monitorable;
#line 224 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp5_ = media_monitor_create_updates (self, _tmp4_);
#line 224 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_monitorable_updates_unref0 (updates);
#line 224 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	updates = _tmp5_;
#line 225 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp6_ = self->priv->pending_updates;
#line 225 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp7_ = monitorable;
#line 225 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp8_ = updates;
#line 225 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp7_, _tmp8_);
#line 227 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	result = updates;
#line 227 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return result;
#line 1696 "MediaMonitor.c"
}


MonitorableUpdates* media_monitor_get_existing_updates (MediaMonitor* self, Monitorable* monitorable) {
	MonitorableUpdates* result = NULL;
	GeeHashMap* _tmp0_ = NULL;
	Monitorable* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
#line 230 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), NULL);
#line 230 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MONITORABLE (monitorable), NULL);
#line 231 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = self->priv->pending_updates;
#line 231 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp1_ = monitorable;
#line 231 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_);
#line 231 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	result = (MonitorableUpdates*) _tmp2_;
#line 231 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return result;
#line 1719 "MediaMonitor.c"
}


void media_monitor_remove_updates (MediaMonitor* self, Monitorable* monitorable) {
	GeeHashMap* _tmp0_ = NULL;
	Monitorable* _tmp1_ = NULL;
#line 234 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (IS_MEDIA_MONITOR (self));
#line 234 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (IS_MONITORABLE (monitorable));
#line 235 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = self->priv->pending_updates;
#line 235 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp1_ = monitorable;
#line 235 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_, NULL);
#line 1736 "MediaMonitor.c"
}


gboolean media_monitor_is_online (MediaMonitor* self, Monitorable* monitorable) {
	gboolean result = FALSE;
	MonitorableUpdates* updates = NULL;
	Monitorable* _tmp0_ = NULL;
	MonitorableUpdates* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	MonitorableUpdates* _tmp3_ = NULL;
#line 238 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), FALSE);
#line 238 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MONITORABLE (monitorable), FALSE);
#line 239 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = monitorable;
#line 239 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp1_ = media_monitor_get_existing_updates (self, _tmp0_);
#line 239 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	updates = _tmp1_;
#line 241 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp3_ = updates;
#line 241 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (_tmp3_ != NULL) {
#line 1761 "MediaMonitor.c"
		MonitorableUpdates* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 241 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp4_ = updates;
#line 241 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp5_ = monitorable_updates_is_set_online (_tmp4_);
#line 241 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp2_ = _tmp5_;
#line 1770 "MediaMonitor.c"
	} else {
		Monitorable* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
#line 241 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp6_ = monitorable;
#line 241 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp7_ = monitorable_is_offline (_tmp6_);
#line 241 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp2_ = !_tmp7_;
#line 1780 "MediaMonitor.c"
	}
#line 241 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	result = _tmp2_;
#line 241 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_monitorable_updates_unref0 (updates);
#line 241 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return result;
#line 1788 "MediaMonitor.c"
}


gboolean media_monitor_is_offline (MediaMonitor* self, Monitorable* monitorable) {
	gboolean result = FALSE;
	MonitorableUpdates* updates = NULL;
	Monitorable* _tmp0_ = NULL;
	MonitorableUpdates* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	MonitorableUpdates* _tmp3_ = NULL;
#line 244 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), FALSE);
#line 244 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MONITORABLE (monitorable), FALSE);
#line 245 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = monitorable;
#line 245 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp1_ = media_monitor_get_existing_updates (self, _tmp0_);
#line 245 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	updates = _tmp1_;
#line 247 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp3_ = updates;
#line 247 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (_tmp3_ != NULL) {
#line 1813 "MediaMonitor.c"
		MonitorableUpdates* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 247 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp4_ = updates;
#line 247 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp5_ = monitorable_updates_is_set_offline (_tmp4_);
#line 247 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp2_ = _tmp5_;
#line 1822 "MediaMonitor.c"
	} else {
		Monitorable* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
#line 247 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp6_ = monitorable;
#line 247 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp7_ = monitorable_is_offline (_tmp6_);
#line 247 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp2_ = _tmp7_;
#line 1832 "MediaMonitor.c"
	}
#line 247 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	result = _tmp2_;
#line 247 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_monitorable_updates_unref0 (updates);
#line 247 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return result;
#line 1840 "MediaMonitor.c"
}


GFile* media_monitor_get_master_file (MediaMonitor* self, Monitorable* monitorable) {
	GFile* result = NULL;
	MonitorableUpdates* updates = NULL;
	Monitorable* _tmp0_ = NULL;
	MonitorableUpdates* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	MonitorableUpdates* _tmp4_ = NULL;
#line 250 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), NULL);
#line 250 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MONITORABLE (monitorable), NULL);
#line 251 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = monitorable;
#line 251 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp1_ = media_monitor_get_existing_updates (self, _tmp0_);
#line 251 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	updates = _tmp1_;
#line 253 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp4_ = updates;
#line 253 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (_tmp4_ != NULL) {
#line 1866 "MediaMonitor.c"
		MonitorableUpdates* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
#line 253 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp5_ = updates;
#line 253 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp6_ = monitorable_updates_get_master_file (_tmp5_);
#line 253 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp7_ = _tmp6_;
#line 253 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp3_ = _tmp7_ != NULL;
#line 253 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_g_object_unref0 (_tmp7_);
#line 1880 "MediaMonitor.c"
	} else {
#line 253 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp3_ = FALSE;
#line 1884 "MediaMonitor.c"
	}
#line 253 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (_tmp3_) {
#line 1888 "MediaMonitor.c"
		MonitorableUpdates* _tmp8_ = NULL;
		GFile* _tmp9_ = NULL;
#line 253 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp8_ = updates;
#line 253 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp9_ = monitorable_updates_get_master_file (_tmp8_);
#line 253 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_g_object_unref0 (_tmp2_);
#line 253 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp2_ = _tmp9_;
#line 1899 "MediaMonitor.c"
	} else {
		Monitorable* _tmp10_ = NULL;
		GFile* _tmp11_ = NULL;
#line 254 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp10_ = monitorable;
#line 254 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp11_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_MEDIA_SOURCE, MediaSource));
#line 254 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_g_object_unref0 (_tmp2_);
#line 254 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp2_ = _tmp11_;
#line 1911 "MediaMonitor.c"
	}
#line 253 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	result = _tmp2_;
#line 253 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_monitorable_updates_unref0 (updates);
#line 253 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return result;
#line 1919 "MediaMonitor.c"
}


void media_monitor_update_master_file (MediaMonitor* self, Monitorable* monitorable, GFile* file) {
	Monitorable* _tmp0_ = NULL;
	MonitorableUpdates* _tmp1_ = NULL;
	MonitorableUpdates* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
#line 257 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (IS_MEDIA_MONITOR (self));
#line 257 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (IS_MONITORABLE (monitorable));
#line 257 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 258 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = monitorable;
#line 258 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp1_ = media_monitor_fetch_updates (self, _tmp0_);
#line 258 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp2_ = _tmp1_;
#line 258 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp3_ = file;
#line 258 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	monitorable_updates_set_master_file (_tmp2_, _tmp3_);
#line 258 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_monitorable_updates_unref0 (_tmp2_);
#line 1946 "MediaMonitor.c"
}


void media_monitor_update_master_file_info_altered (MediaMonitor* self, Monitorable* monitorable) {
	Monitorable* _tmp0_ = NULL;
	MonitorableUpdates* _tmp1_ = NULL;
	MonitorableUpdates* _tmp2_ = NULL;
#line 261 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (IS_MEDIA_MONITOR (self));
#line 261 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (IS_MONITORABLE (monitorable));
#line 262 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = monitorable;
#line 262 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp1_ = media_monitor_fetch_updates (self, _tmp0_);
#line 262 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp2_ = _tmp1_;
#line 262 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	monitorable_updates_set_master_file_info_altered (_tmp2_, TRUE);
#line 262 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_monitorable_updates_unref0 (_tmp2_);
#line 1968 "MediaMonitor.c"
}


void media_monitor_update_master_file_in_alteration (MediaMonitor* self, Monitorable* monitorable, gboolean in_alteration) {
	Monitorable* _tmp0_ = NULL;
	MonitorableUpdates* _tmp1_ = NULL;
	MonitorableUpdates* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 265 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (IS_MEDIA_MONITOR (self));
#line 265 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (IS_MONITORABLE (monitorable));
#line 266 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = monitorable;
#line 266 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp1_ = media_monitor_fetch_updates (self, _tmp0_);
#line 266 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp2_ = _tmp1_;
#line 266 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp3_ = in_alteration;
#line 266 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	monitorable_updates_set_master_in_alteration (_tmp2_, _tmp3_);
#line 266 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_monitorable_updates_unref0 (_tmp2_);
#line 1993 "MediaMonitor.c"
}


void media_monitor_update_master_file_alterations_completed (MediaMonitor* self, Monitorable* monitorable, GFileInfo* info) {
	Monitorable* _tmp0_ = NULL;
	MonitorableUpdates* _tmp1_ = NULL;
	MonitorableUpdates* _tmp2_ = NULL;
	GFileInfo* _tmp3_ = NULL;
#line 269 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (IS_MEDIA_MONITOR (self));
#line 269 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (IS_MONITORABLE (monitorable));
#line 269 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 270 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = monitorable;
#line 270 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp1_ = media_monitor_fetch_updates (self, _tmp0_);
#line 270 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp2_ = _tmp1_;
#line 270 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp3_ = info;
#line 270 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	monitorable_updates_set_master_alterations_complete (_tmp2_, _tmp3_);
#line 270 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_monitorable_updates_unref0 (_tmp2_);
#line 2020 "MediaMonitor.c"
}


void media_monitor_update_online (MediaMonitor* self, Monitorable* monitorable) {
	Monitorable* _tmp0_ = NULL;
	MonitorableUpdates* _tmp1_ = NULL;
	MonitorableUpdates* _tmp2_ = NULL;
#line 273 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (IS_MEDIA_MONITOR (self));
#line 273 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (IS_MONITORABLE (monitorable));
#line 274 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = monitorable;
#line 274 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp1_ = media_monitor_fetch_updates (self, _tmp0_);
#line 274 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp2_ = _tmp1_;
#line 274 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	monitorable_updates_mark_online (_tmp2_);
#line 274 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_monitorable_updates_unref0 (_tmp2_);
#line 2042 "MediaMonitor.c"
}


void media_monitor_update_offline (MediaMonitor* self, Monitorable* monitorable) {
	Monitorable* _tmp0_ = NULL;
	MonitorableUpdates* _tmp1_ = NULL;
	MonitorableUpdates* _tmp2_ = NULL;
#line 277 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (IS_MEDIA_MONITOR (self));
#line 277 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (IS_MONITORABLE (monitorable));
#line 278 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = monitorable;
#line 278 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp1_ = media_monitor_fetch_updates (self, _tmp0_);
#line 278 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp2_ = _tmp1_;
#line 278 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	monitorable_updates_mark_offline (_tmp2_);
#line 278 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_monitorable_updates_unref0 (_tmp2_);
#line 2064 "MediaMonitor.c"
}


static void media_monitor_real_process_updates (MediaMonitor* self, GeeCollection* all_updates, TransactionController* controller, gint* op_count, GError** error) {
	GeeMap* set_master_file = NULL;
	GeeMap* set_master_file_info = NULL;
	GeeArrayList* to_offline = NULL;
	GeeArrayList* to_online = NULL;
	GeeMap* _tmp53_ = NULL;
	GeeMap* _tmp63_ = NULL;
	gboolean _tmp73_ = FALSE;
	GeeArrayList* _tmp74_ = NULL;
	GError * _inner_error_ = NULL;
#line 285 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (GEE_IS_COLLECTION (all_updates));
#line 285 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (IS_TRANSACTION_CONTROLLER (controller));
#line 287 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	set_master_file = NULL;
#line 288 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	set_master_file_info = NULL;
#line 289 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	to_offline = NULL;
#line 290 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	to_online = NULL;
#line 2090 "MediaMonitor.c"
	{
		GeeIterator* _updates_it = NULL;
		GeeCollection* _tmp0_ = NULL;
		GeeIterator* _tmp1_ = NULL;
#line 292 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp0_ = all_updates;
#line 292 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERABLE, GeeIterable));
#line 292 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_updates_it = _tmp1_;
#line 292 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		while (TRUE) {
#line 2103 "MediaMonitor.c"
			GeeIterator* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			MonitorableUpdates* updates = NULL;
			GeeIterator* _tmp4_ = NULL;
			gpointer _tmp5_ = NULL;
			gint _tmp6_ = 0;
			MonitorableUpdates* _tmp7_ = NULL;
			GFile* _tmp8_ = NULL;
			GFile* _tmp9_ = NULL;
			gboolean _tmp10_ = FALSE;
			MonitorableUpdates* _tmp21_ = NULL;
			GFileInfo* _tmp22_ = NULL;
			GFileInfo* _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
			MonitorableUpdates* _tmp35_ = NULL;
			gboolean _tmp36_ = FALSE;
			MonitorableUpdates* _tmp44_ = NULL;
			gboolean _tmp45_ = FALSE;
#line 292 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp2_ = _updates_it;
#line 292 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 292 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			if (!_tmp3_) {
#line 292 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				break;
#line 2130 "MediaMonitor.c"
			}
#line 292 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp4_ = _updates_it;
#line 292 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 292 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			updates = (MonitorableUpdates*) _tmp5_;
#line 293 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp6_ = *op_count;
#line 293 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			if (_tmp6_ >= MEDIA_MONITOR_MAX_OPERATIONS_PER_CYCLE) {
#line 294 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_monitorable_updates_unref0 (updates);
#line 294 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				break;
#line 2146 "MediaMonitor.c"
			}
#line 296 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp7_ = updates;
#line 296 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp8_ = monitorable_updates_get_master_file (_tmp7_);
#line 296 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp9_ = _tmp8_;
#line 296 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp10_ = _tmp9_ != NULL;
#line 296 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_g_object_unref0 (_tmp9_);
#line 296 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			if (_tmp10_) {
#line 2160 "MediaMonitor.c"
				GeeMap* _tmp11_ = NULL;
				GeeMap* _tmp13_ = NULL;
				MonitorableUpdates* _tmp14_ = NULL;
				Monitorable* _tmp15_ = NULL;
				MonitorableUpdates* _tmp16_ = NULL;
				GFile* _tmp17_ = NULL;
				GFile* _tmp18_ = NULL;
				MonitorableUpdates* _tmp19_ = NULL;
				gint _tmp20_ = 0;
#line 297 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp11_ = set_master_file;
#line 297 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				if (_tmp11_ == NULL) {
#line 2174 "MediaMonitor.c"
					GeeHashMap* _tmp12_ = NULL;
#line 298 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
					_tmp12_ = gee_hash_map_new (TYPE_MONITORABLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 298 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
					_g_object_unref0 (set_master_file);
#line 298 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
					set_master_file = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_MAP, GeeMap);
#line 2182 "MediaMonitor.c"
				}
#line 300 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp13_ = set_master_file;
#line 300 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp14_ = updates;
#line 300 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp15_ = _tmp14_->monitorable;
#line 300 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp16_ = updates;
#line 300 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp17_ = monitorable_updates_get_master_file (_tmp16_);
#line 300 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp18_ = _tmp17_;
#line 300 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				gee_map_set (_tmp13_, _tmp15_, _tmp18_);
#line 300 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_g_object_unref0 (_tmp18_);
#line 301 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp19_ = updates;
#line 301 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				monitorable_updates_set_master_file (_tmp19_, NULL);
#line 302 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp20_ = *op_count;
#line 302 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				*op_count = _tmp20_ + 1;
#line 2208 "MediaMonitor.c"
			}
#line 305 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp21_ = updates;
#line 305 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp22_ = monitorable_updates_get_master_file_info (_tmp21_);
#line 305 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp23_ = _tmp22_;
#line 305 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp24_ = _tmp23_ != NULL;
#line 305 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_g_object_unref0 (_tmp23_);
#line 305 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			if (_tmp24_) {
#line 2222 "MediaMonitor.c"
				GeeMap* _tmp25_ = NULL;
				GeeMap* _tmp27_ = NULL;
				MonitorableUpdates* _tmp28_ = NULL;
				Monitorable* _tmp29_ = NULL;
				MonitorableUpdates* _tmp30_ = NULL;
				GFileInfo* _tmp31_ = NULL;
				GFileInfo* _tmp32_ = NULL;
				MonitorableUpdates* _tmp33_ = NULL;
				gint _tmp34_ = 0;
#line 306 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp25_ = set_master_file_info;
#line 306 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				if (_tmp25_ == NULL) {
#line 2236 "MediaMonitor.c"
					GeeHashMap* _tmp26_ = NULL;
#line 307 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
					_tmp26_ = gee_hash_map_new (TYPE_MONITORABLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, g_file_info_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 307 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
					_g_object_unref0 (set_master_file_info);
#line 307 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
					set_master_file_info = G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_MAP, GeeMap);
#line 2244 "MediaMonitor.c"
				}
#line 309 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp27_ = set_master_file_info;
#line 309 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp28_ = updates;
#line 309 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp29_ = _tmp28_->monitorable;
#line 309 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp30_ = updates;
#line 309 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp31_ = monitorable_updates_get_master_file_info (_tmp30_);
#line 309 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp32_ = _tmp31_;
#line 309 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				gee_map_set (_tmp27_, _tmp29_, _tmp32_);
#line 309 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_g_object_unref0 (_tmp32_);
#line 310 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp33_ = updates;
#line 310 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				monitorable_updates_set_master_file_info (_tmp33_, NULL);
#line 311 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp34_ = *op_count;
#line 311 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				*op_count = _tmp34_ + 1;
#line 2270 "MediaMonitor.c"
			}
#line 314 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp35_ = updates;
#line 314 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp36_ = monitorable_updates_is_set_offline (_tmp35_);
#line 314 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			if (_tmp36_) {
#line 2278 "MediaMonitor.c"
				GeeArrayList* _tmp37_ = NULL;
				GeeArrayList* _tmp39_ = NULL;
				MonitorableUpdates* _tmp40_ = NULL;
				Monitorable* _tmp41_ = NULL;
				MonitorableUpdates* _tmp42_ = NULL;
				gint _tmp43_ = 0;
#line 315 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp37_ = to_offline;
#line 315 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				if (_tmp37_ == NULL) {
#line 2289 "MediaMonitor.c"
					GeeArrayList* _tmp38_ = NULL;
#line 316 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
					_tmp38_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 316 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
					_g_object_unref0 (to_offline);
#line 316 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
					to_offline = _tmp38_;
#line 2297 "MediaMonitor.c"
				}
#line 318 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp39_ = to_offline;
#line 318 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp40_ = updates;
#line 318 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp41_ = _tmp40_->monitorable;
#line 318 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp41_);
#line 319 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp42_ = updates;
#line 319 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				monitorable_updates_reset_online_offline (_tmp42_);
#line 320 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp43_ = *op_count;
#line 320 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				*op_count = _tmp43_ + 1;
#line 2315 "MediaMonitor.c"
			}
#line 323 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp44_ = updates;
#line 323 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp45_ = monitorable_updates_is_set_online (_tmp44_);
#line 323 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			if (_tmp45_) {
#line 2323 "MediaMonitor.c"
				GeeArrayList* _tmp46_ = NULL;
				GeeArrayList* _tmp48_ = NULL;
				MonitorableUpdates* _tmp49_ = NULL;
				Monitorable* _tmp50_ = NULL;
				MonitorableUpdates* _tmp51_ = NULL;
				gint _tmp52_ = 0;
#line 324 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp46_ = to_online;
#line 324 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				if (_tmp46_ == NULL) {
#line 2334 "MediaMonitor.c"
					GeeArrayList* _tmp47_ = NULL;
#line 325 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
					_tmp47_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 325 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
					_g_object_unref0 (to_online);
#line 325 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
					to_online = _tmp47_;
#line 2342 "MediaMonitor.c"
				}
#line 327 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp48_ = to_online;
#line 327 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp49_ = updates;
#line 327 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp50_ = _tmp49_->monitorable;
#line 327 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp50_);
#line 328 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp51_ = updates;
#line 328 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				monitorable_updates_reset_online_offline (_tmp51_);
#line 329 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp52_ = *op_count;
#line 329 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				*op_count = _tmp52_ + 1;
#line 2360 "MediaMonitor.c"
			}
#line 292 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_monitorable_updates_unref0 (updates);
#line 2364 "MediaMonitor.c"
		}
#line 292 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_g_object_unref0 (_updates_it);
#line 2368 "MediaMonitor.c"
	}
#line 333 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp53_ = set_master_file;
#line 333 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (_tmp53_ != NULL) {
#line 2374 "MediaMonitor.c"
		GeeMap* _tmp54_ = NULL;
		gint _tmp55_ = 0;
		gint _tmp56_ = 0;
		gchar* _tmp57_ = NULL;
		gchar* _tmp58_ = NULL;
		gchar* _tmp59_ = NULL;
		gchar* _tmp60_ = NULL;
		GeeMap* _tmp61_ = NULL;
		TransactionController* _tmp62_ = NULL;
#line 334 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp54_ = set_master_file;
#line 334 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp55_ = gee_map_get_size (_tmp54_);
#line 334 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp56_ = _tmp55_;
#line 334 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp57_ = media_monitor_to_string (self);
#line 334 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp58_ = _tmp57_;
#line 334 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp59_ = g_strdup_printf ("Changing master file of %d objects in %s", _tmp56_, _tmp58_);
#line 334 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp60_ = _tmp59_;
#line 334 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		media_monitor_mdbg (_tmp60_);
#line 334 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_g_free0 (_tmp60_);
#line 334 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_g_free0 (_tmp58_);
#line 336 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp61_ = set_master_file;
#line 336 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp62_ = controller;
#line 336 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		monitorable_set_many_master_file (_tmp61_, _tmp62_, &_inner_error_);
#line 336 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 336 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			g_propagate_error (error, _inner_error_);
#line 336 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_g_object_unref0 (to_online);
#line 336 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_g_object_unref0 (to_offline);
#line 336 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_g_object_unref0 (set_master_file_info);
#line 336 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_g_object_unref0 (set_master_file);
#line 336 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			return;
#line 2424 "MediaMonitor.c"
		}
	}
#line 339 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp63_ = set_master_file_info;
#line 339 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (_tmp63_ != NULL) {
#line 2431 "MediaMonitor.c"
		GeeMap* _tmp64_ = NULL;
		gint _tmp65_ = 0;
		gint _tmp66_ = 0;
		gchar* _tmp67_ = NULL;
		gchar* _tmp68_ = NULL;
		gchar* _tmp69_ = NULL;
		gchar* _tmp70_ = NULL;
		GeeMap* _tmp71_ = NULL;
		TransactionController* _tmp72_ = NULL;
#line 340 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp64_ = set_master_file_info;
#line 340 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp65_ = gee_map_get_size (_tmp64_);
#line 340 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp66_ = _tmp65_;
#line 340 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp67_ = media_monitor_to_string (self);
#line 340 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp68_ = _tmp67_;
#line 340 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp69_ = g_strdup_printf ("Updating %d master files timestamps in %s", _tmp66_, _tmp68_);
#line 340 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp70_ = _tmp69_;
#line 340 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		media_monitor_mdbg (_tmp70_);
#line 340 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_g_free0 (_tmp70_);
#line 340 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_g_free0 (_tmp68_);
#line 343 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp71_ = set_master_file_info;
#line 343 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp72_ = controller;
#line 343 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		monitorable_set_many_master_timestamp (_tmp71_, _tmp72_, &_inner_error_);
#line 343 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 343 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			g_propagate_error (error, _inner_error_);
#line 343 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_g_object_unref0 (to_online);
#line 343 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_g_object_unref0 (to_offline);
#line 343 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_g_object_unref0 (set_master_file_info);
#line 343 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_g_object_unref0 (set_master_file);
#line 343 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			return;
#line 2481 "MediaMonitor.c"
		}
	}
#line 346 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp74_ = to_offline;
#line 346 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (_tmp74_ != NULL) {
#line 346 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp73_ = TRUE;
#line 2490 "MediaMonitor.c"
	} else {
		GeeArrayList* _tmp75_ = NULL;
#line 346 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp75_ = to_online;
#line 346 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp73_ = _tmp75_ != NULL;
#line 2497 "MediaMonitor.c"
	}
#line 346 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (_tmp73_) {
#line 2501 "MediaMonitor.c"
		gint _tmp76_ = 0;
		GeeArrayList* _tmp77_ = NULL;
		gint _tmp81_ = 0;
		GeeArrayList* _tmp82_ = NULL;
		gchar* _tmp86_ = NULL;
		gchar* _tmp87_ = NULL;
		gchar* _tmp88_ = NULL;
		gchar* _tmp89_ = NULL;
		GeeArrayList* _tmp90_ = NULL;
		GeeArrayList* _tmp91_ = NULL;
		TransactionController* _tmp92_ = NULL;
#line 348 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp77_ = to_online;
#line 348 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		if (_tmp77_ != NULL) {
#line 2517 "MediaMonitor.c"
			GeeArrayList* _tmp78_ = NULL;
			gint _tmp79_ = 0;
			gint _tmp80_ = 0;
#line 348 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp78_ = to_online;
#line 348 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp79_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 348 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp80_ = _tmp79_;
#line 348 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp76_ = _tmp80_;
#line 2529 "MediaMonitor.c"
		} else {
#line 348 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp76_ = 0;
#line 2533 "MediaMonitor.c"
		}
#line 349 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp82_ = to_offline;
#line 349 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		if (_tmp82_ != NULL) {
#line 2539 "MediaMonitor.c"
			GeeArrayList* _tmp83_ = NULL;
			gint _tmp84_ = 0;
			gint _tmp85_ = 0;
#line 349 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp83_ = to_offline;
#line 349 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp84_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 349 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp85_ = _tmp84_;
#line 349 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp81_ = _tmp85_;
#line 2551 "MediaMonitor.c"
		} else {
#line 349 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp81_ = 0;
#line 2555 "MediaMonitor.c"
		}
#line 347 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp86_ = media_monitor_to_string (self);
#line 347 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp87_ = _tmp86_;
#line 347 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp88_ = g_strdup_printf ("Marking %d online, %d offline in %s", _tmp76_, _tmp81_, _tmp87_);
#line 347 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp89_ = _tmp88_;
#line 347 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		media_monitor_mdbg (_tmp89_);
#line 347 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_g_free0 (_tmp89_);
#line 347 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_g_free0 (_tmp87_);
#line 352 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp90_ = to_online;
#line 352 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp91_ = to_offline;
#line 352 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp92_ = controller;
#line 352 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		monitorable_mark_many_online_offline (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, GEE_TYPE_COLLECTION, GeeCollection), _tmp92_, &_inner_error_);
#line 352 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 352 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			g_propagate_error (error, _inner_error_);
#line 352 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_g_object_unref0 (to_online);
#line 352 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_g_object_unref0 (to_offline);
#line 352 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_g_object_unref0 (set_master_file_info);
#line 352 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_g_object_unref0 (set_master_file);
#line 352 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			return;
#line 2593 "MediaMonitor.c"
		}
	}
#line 285 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_g_object_unref0 (to_online);
#line 285 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_g_object_unref0 (to_offline);
#line 285 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_g_object_unref0 (set_master_file_info);
#line 285 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_g_object_unref0 (set_master_file);
#line 2604 "MediaMonitor.c"
}


void media_monitor_process_updates (MediaMonitor* self, GeeCollection* all_updates, TransactionController* controller, gint* op_count, GError** error) {
#line 285 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_if_fail (IS_MEDIA_MONITOR (self));
#line 285 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	MEDIA_MONITOR_GET_CLASS (self)->process_updates (self, all_updates, controller, op_count, error);
#line 2613 "MediaMonitor.c"
}


static gpointer _transaction_controller_ref0 (gpointer self) {
#line 390 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return self ? transaction_controller_ref (self) : NULL;
#line 2620 "MediaMonitor.c"
}


static gboolean media_monitor_on_flush_pending_updates (MediaMonitor* self) {
	gboolean result = FALSE;
	GCancellable* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GeeHashMap* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GTimer* timer = NULL;
	GTimer* _tmp5_ = NULL;
	GeeArrayList* to_process = NULL;
	GeeArrayList* to_remove = NULL;
	gint op_count = 0;
	GeeArrayList* _tmp29_ = NULL;
	GeeArrayList* _tmp48_ = NULL;
	gdouble elapsed = 0.0;
	GTimer* _tmp61_ = NULL;
	gdouble _tmp62_ = 0.0;
	gboolean _tmp63_ = FALSE;
	gdouble _tmp64_ = 0.0;
	GError * _inner_error_ = NULL;
#line 356 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_return_val_if_fail (IS_MEDIA_MONITOR (self), FALSE);
#line 357 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = self->priv->cancellable;
#line 357 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp1_ = g_cancellable_is_cancelled (_tmp0_);
#line 357 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (_tmp1_) {
#line 358 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		result = FALSE;
#line 358 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		return result;
#line 2656 "MediaMonitor.c"
	}
#line 360 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp2_ = self->priv->pending_updates;
#line 360 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp3_ = gee_abstract_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 360 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp4_ = _tmp3_;
#line 360 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (_tmp4_ == 0) {
#line 361 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		result = TRUE;
#line 361 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		return result;
#line 2670 "MediaMonitor.c"
	}
#line 363 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp5_ = g_timer_new ();
#line 363 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	timer = _tmp5_;
#line 368 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	to_process = NULL;
#line 369 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	to_remove = NULL;
#line 2680 "MediaMonitor.c"
	{
		GeeIterator* _updates_it = NULL;
		GeeHashMap* _tmp6_ = NULL;
		GeeCollection* _tmp7_ = NULL;
		GeeCollection* _tmp8_ = NULL;
		GeeCollection* _tmp9_ = NULL;
		GeeIterator* _tmp10_ = NULL;
		GeeIterator* _tmp11_ = NULL;
#line 370 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp6_ = self->priv->pending_updates;
#line 370 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp7_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 370 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp8_ = _tmp7_;
#line 370 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp9_ = _tmp8_;
#line 370 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp10_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ITERABLE, GeeIterable));
#line 370 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp11_ = _tmp10_;
#line 370 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_g_object_unref0 (_tmp9_);
#line 370 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_updates_it = _tmp11_;
#line 370 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		while (TRUE) {
#line 2707 "MediaMonitor.c"
			GeeIterator* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
			MonitorableUpdates* updates = NULL;
			GeeIterator* _tmp14_ = NULL;
			gpointer _tmp15_ = NULL;
			MonitorableUpdates* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			MonitorableUpdates* _tmp18_ = NULL;
			gboolean _tmp19_ = FALSE;
			GeeArrayList* _tmp25_ = NULL;
			GeeArrayList* _tmp27_ = NULL;
			MonitorableUpdates* _tmp28_ = NULL;
#line 370 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp12_ = _updates_it;
#line 370 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp13_ = gee_iterator_next (_tmp12_);
#line 370 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			if (!_tmp13_) {
#line 370 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				break;
#line 2728 "MediaMonitor.c"
			}
#line 370 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp14_ = _updates_it;
#line 370 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp15_ = gee_iterator_get (_tmp14_);
#line 370 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			updates = (MonitorableUpdates*) _tmp15_;
#line 371 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp16_ = updates;
#line 371 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp17_ = monitorable_updates_is_in_alteration (_tmp16_);
#line 371 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			if (_tmp17_) {
#line 372 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_monitorable_updates_unref0 (updates);
#line 372 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				continue;
#line 2746 "MediaMonitor.c"
			}
#line 374 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp18_ = updates;
#line 374 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp19_ = monitorable_updates_is_all_updated (_tmp18_);
#line 374 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			if (_tmp19_) {
#line 2754 "MediaMonitor.c"
				GeeArrayList* _tmp20_ = NULL;
				GeeArrayList* _tmp22_ = NULL;
				MonitorableUpdates* _tmp23_ = NULL;
				Monitorable* _tmp24_ = NULL;
#line 375 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp20_ = to_remove;
#line 375 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				if (_tmp20_ == NULL) {
#line 2763 "MediaMonitor.c"
					GeeArrayList* _tmp21_ = NULL;
#line 376 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
					_tmp21_ = gee_array_list_new (TYPE_MONITORABLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 376 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
					_g_object_unref0 (to_remove);
#line 376 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
					to_remove = _tmp21_;
#line 2771 "MediaMonitor.c"
				}
#line 378 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp22_ = to_remove;
#line 378 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp23_ = updates;
#line 378 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp24_ = _tmp23_->monitorable;
#line 378 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp24_);
#line 379 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_monitorable_updates_unref0 (updates);
#line 379 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				continue;
#line 2785 "MediaMonitor.c"
			}
#line 382 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp25_ = to_process;
#line 382 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			if (_tmp25_ == NULL) {
#line 2791 "MediaMonitor.c"
				GeeArrayList* _tmp26_ = NULL;
#line 383 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp26_ = gee_array_list_new (TYPE_MONITORABLE_UPDATES, (GBoxedCopyFunc) monitorable_updates_ref, (GDestroyNotify) monitorable_updates_unref, NULL, NULL, NULL);
#line 383 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_g_object_unref0 (to_process);
#line 383 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				to_process = _tmp26_;
#line 2799 "MediaMonitor.c"
			}
#line 385 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp27_ = to_process;
#line 385 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp28_ = updates;
#line 385 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp28_);
#line 370 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_monitorable_updates_unref0 (updates);
#line 2809 "MediaMonitor.c"
		}
#line 370 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_g_object_unref0 (_updates_it);
#line 2813 "MediaMonitor.c"
	}
#line 388 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	op_count = 0;
#line 389 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp29_ = to_process;
#line 389 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (_tmp29_ != NULL) {
#line 2821 "MediaMonitor.c"
		TransactionController* controller = NULL;
		MediaSourceCollection* _tmp30_ = NULL;
		MediaSourceCollection* _tmp31_ = NULL;
		TransactionController* _tmp32_ = NULL;
		TransactionController* _tmp33_ = NULL;
		TransactionController* _tmp34_ = NULL;
		TransactionController* _tmp35_ = NULL;
#line 390 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp30_ = media_monitor_get_media_source_collection (self);
#line 390 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp31_ = _tmp30_;
#line 390 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp32_ = media_source_collection_get_transaction_controller (_tmp31_);
#line 390 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp33_ = _tmp32_;
#line 390 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp34_ = _transaction_controller_ref0 (_tmp33_);
#line 390 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp35_ = _tmp34_;
#line 390 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_data_collection_unref0 (_tmp31_);
#line 390 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		controller = _tmp35_;
#line 2845 "MediaMonitor.c"
		{
			TransactionController* _tmp36_ = NULL;
			GeeArrayList* _tmp37_ = NULL;
			TransactionController* _tmp38_ = NULL;
			TransactionController* _tmp39_ = NULL;
#line 393 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp36_ = controller;
#line 393 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			transaction_controller_begin (_tmp36_);
#line 394 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp37_ = to_process;
#line 394 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp38_ = controller;
#line 394 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			media_monitor_process_updates (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, GEE_TYPE_COLLECTION, GeeCollection), _tmp38_, &op_count, &_inner_error_);
#line 394 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2863 "MediaMonitor.c"
				goto __catch574_g_error;
			}
#line 395 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp39_ = controller;
#line 395 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			transaction_controller_commit (_tmp39_);
#line 2870 "MediaMonitor.c"
		}
		goto __finally574;
		__catch574_g_error:
		{
			GError* err = NULL;
			GError* _tmp40_ = NULL;
#line 392 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			err = _inner_error_;
#line 392 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_inner_error_ = NULL;
#line 397 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp40_ = err;
#line 397 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			if (_tmp40_->domain == DATABASE_ERROR) {
#line 2885 "MediaMonitor.c"
				GError* _tmp41_ = NULL;
#line 398 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp41_ = err;
#line 398 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				app_window_database_error ((GError*) _tmp41_);
#line 2891 "MediaMonitor.c"
			} else {
				const gchar* _tmp42_ = NULL;
				GError* _tmp43_ = NULL;
				const gchar* _tmp44_ = NULL;
				gchar* _tmp45_ = NULL;
				gchar* _tmp46_ = NULL;
#line 400 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp42_ = _ ("Unable to process monitoring updates: %s");
#line 400 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp43_ = err;
#line 400 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp44_ = _tmp43_->message;
#line 400 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp45_ = g_strdup_printf (_tmp42_, _tmp44_);
#line 400 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp46_ = _tmp45_;
#line 400 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				app_window_panic (_tmp46_);
#line 400 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_g_free0 (_tmp46_);
#line 2912 "MediaMonitor.c"
			}
#line 392 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_g_error_free0 (err);
#line 2916 "MediaMonitor.c"
		}
		__finally574:
#line 392 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2921 "MediaMonitor.c"
			gboolean _tmp47_ = FALSE;
#line 392 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_transaction_controller_unref0 (controller);
#line 392 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_g_object_unref0 (to_remove);
#line 392 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_g_object_unref0 (to_process);
#line 392 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_g_timer_destroy0 (timer);
#line 392 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 392 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			g_clear_error (&_inner_error_);
#line 392 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			return _tmp47_;
#line 2937 "MediaMonitor.c"
		}
#line 389 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_transaction_controller_unref0 (controller);
#line 2941 "MediaMonitor.c"
	}
#line 404 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp48_ = to_remove;
#line 404 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (_tmp48_ != NULL) {
#line 2947 "MediaMonitor.c"
		{
			GeeArrayList* _monitorable_list = NULL;
			GeeArrayList* _tmp49_ = NULL;
			GeeArrayList* _tmp50_ = NULL;
			gint _monitorable_size = 0;
			GeeArrayList* _tmp51_ = NULL;
			gint _tmp52_ = 0;
			gint _tmp53_ = 0;
			gint _monitorable_index = 0;
#line 405 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp49_ = to_remove;
#line 405 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp50_ = _g_object_ref0 (_tmp49_);
#line 405 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_monitorable_list = _tmp50_;
#line 405 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp51_ = _monitorable_list;
#line 405 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp52_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 405 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_tmp53_ = _tmp52_;
#line 405 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_monitorable_size = _tmp53_;
#line 405 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_monitorable_index = -1;
#line 405 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			while (TRUE) {
#line 2975 "MediaMonitor.c"
				gint _tmp54_ = 0;
				gint _tmp55_ = 0;
				gint _tmp56_ = 0;
				Monitorable* monitorable = NULL;
				GeeArrayList* _tmp57_ = NULL;
				gint _tmp58_ = 0;
				gpointer _tmp59_ = NULL;
				Monitorable* _tmp60_ = NULL;
#line 405 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp54_ = _monitorable_index;
#line 405 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_monitorable_index = _tmp54_ + 1;
#line 405 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp55_ = _monitorable_index;
#line 405 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp56_ = _monitorable_size;
#line 405 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				if (!(_tmp55_ < _tmp56_)) {
#line 405 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
					break;
#line 2996 "MediaMonitor.c"
				}
#line 405 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp57_ = _monitorable_list;
#line 405 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp58_ = _monitorable_index;
#line 405 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp59_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp58_);
#line 405 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				monitorable = (Monitorable*) _tmp59_;
#line 406 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_tmp60_ = monitorable;
#line 406 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				media_monitor_remove_updates (self, _tmp60_);
#line 405 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
				_g_object_unref0 (monitorable);
#line 3012 "MediaMonitor.c"
			}
#line 405 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
			_g_object_unref0 (_monitorable_list);
#line 3016 "MediaMonitor.c"
		}
	}
#line 409 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp61_ = timer;
#line 409 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp62_ = g_timer_elapsed (_tmp61_, NULL);
#line 409 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	elapsed = _tmp62_;
#line 410 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp64_ = elapsed;
#line 410 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (_tmp64_ > 0.01) {
#line 410 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp63_ = TRUE;
#line 3031 "MediaMonitor.c"
	} else {
		gint _tmp65_ = 0;
#line 410 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp65_ = op_count;
#line 410 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp63_ = _tmp65_ > 0;
#line 3038 "MediaMonitor.c"
	}
#line 410 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	if (_tmp63_) {
#line 3042 "MediaMonitor.c"
		gchar* _tmp66_ = NULL;
		gchar* _tmp67_ = NULL;
		gdouble _tmp68_ = 0.0;
		gint _tmp69_ = 0;
		gchar* _tmp70_ = NULL;
		gchar* _tmp71_ = NULL;
#line 411 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp66_ = media_monitor_to_string (self);
#line 411 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp67_ = _tmp66_;
#line 411 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp68_ = elapsed;
#line 411 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp69_ = op_count;
#line 411 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp70_ = g_strdup_printf ("Total pending queue time for %s: %lf (%d ops)", _tmp67_, _tmp68_, _tmp69_);
#line 411 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_tmp71_ = _tmp70_;
#line 411 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		media_monitor_mdbg (_tmp71_);
#line 411 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_g_free0 (_tmp71_);
#line 411 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
		_g_free0 (_tmp67_);
#line 3067 "MediaMonitor.c"
	}
#line 415 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	result = TRUE;
#line 415 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_g_object_unref0 (to_remove);
#line 415 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_g_object_unref0 (to_process);
#line 415 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_g_timer_destroy0 (timer);
#line 415 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	return result;
#line 3079 "MediaMonitor.c"
}


static void media_monitor_class_init (MediaMonitorClass * klass) {
#line 101 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	media_monitor_parent_class = g_type_class_peek_parent (klass);
#line 101 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_type_class_add_private (klass, sizeof (MediaMonitorPrivate));
#line 101 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	((MediaMonitorClass *) klass)->get_media_source_collection = (MediaSourceCollection* (*)(MediaMonitor*)) media_monitor_real_get_media_source_collection;
#line 101 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	((MediaMonitorClass *) klass)->close = (void (*)(MediaMonitor*)) media_monitor_real_close;
#line 101 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	((MediaMonitorClass *) klass)->to_string = (gchar* (*)(MediaMonitor*)) media_monitor_real_to_string;
#line 101 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	((MediaMonitorClass *) klass)->create_updates = (MonitorableUpdates* (*)(MediaMonitor*, Monitorable*)) media_monitor_real_create_updates;
#line 101 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	((MediaMonitorClass *) klass)->on_media_source_destroyed = (void (*)(MediaMonitor*, DataSource*)) media_monitor_real_on_media_source_destroyed;
#line 101 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	((MediaMonitorClass *) klass)->notify_discovery_started = (void (*)(MediaMonitor*)) media_monitor_real_notify_discovery_started;
#line 101 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	((MediaMonitorClass *) klass)->notify_file_discovered = (MediaMonitorDiscoveredFile (*)(MediaMonitor*, GFile*, GFileInfo*, Monitorable**)) media_monitor_real_notify_file_discovered;
#line 101 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	((MediaMonitorClass *) klass)->candidates_for_unknown_file = (GeeCollection* (*)(MediaMonitor*, GFile*, GFileInfo*, MediaMonitorDiscoveredFile*)) media_monitor_real_candidates_for_unknown_file;
#line 101 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	((MediaMonitorClass *) klass)->get_auxilliary_backing_files = (GFile** (*)(MediaMonitor*, Monitorable*, int*)) media_monitor_real_get_auxilliary_backing_files;
#line 101 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	((MediaMonitorClass *) klass)->update_backing_file_info = (void (*)(MediaMonitor*, Monitorable*, GFile*, GFileInfo*)) media_monitor_real_update_backing_file_info;
#line 101 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	((MediaMonitorClass *) klass)->notify_discovery_completing = (void (*)(MediaMonitor*)) media_monitor_real_notify_discovery_completing;
#line 101 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	((MediaMonitorClass *) klass)->is_file_represented = (gboolean (*)(MediaMonitor*, GFile*)) media_monitor_real_is_file_represented;
#line 101 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	((MediaMonitorClass *) klass)->notify_file_created = (gboolean (*)(MediaMonitor*, GFile*, GFileInfo*)) media_monitor_real_notify_file_created;
#line 101 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	((MediaMonitorClass *) klass)->notify_file_moved = (gboolean (*)(MediaMonitor*, GFile*, GFile*, GFileInfo*)) media_monitor_real_notify_file_moved;
#line 101 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	((MediaMonitorClass *) klass)->notify_file_altered = (gboolean (*)(MediaMonitor*, GFile*)) media_monitor_real_notify_file_altered;
#line 101 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	((MediaMonitorClass *) klass)->notify_file_attributes_altered = (gboolean (*)(MediaMonitor*, GFile*)) media_monitor_real_notify_file_attributes_altered;
#line 101 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	((MediaMonitorClass *) klass)->notify_file_alteration_completed = (gboolean (*)(MediaMonitor*, GFile*, GFileInfo*)) media_monitor_real_notify_file_alteration_completed;
#line 101 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	((MediaMonitorClass *) klass)->notify_file_deleted = (gboolean (*)(MediaMonitor*, GFile*)) media_monitor_real_notify_file_deleted;
#line 101 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	((MediaMonitorClass *) klass)->process_updates = (void (*)(MediaMonitor*, GeeCollection*, TransactionController*, gint*, GError**)) media_monitor_real_process_updates;
#line 101 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	G_OBJECT_CLASS (klass)->finalize = media_monitor_finalize;
#line 3128 "MediaMonitor.c"
}


static void media_monitor_instance_init (MediaMonitor * self) {
	GeeHashMap* _tmp0_ = NULL;
#line 101 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self->priv = MEDIA_MONITOR_GET_PRIVATE (self);
#line 114 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = gee_hash_map_new (TYPE_MONITORABLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_MONITORABLE_UPDATES, (GBoxedCopyFunc) monitorable_updates_ref, (GDestroyNotify) monitorable_updates_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 114 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self->priv->pending_updates = _tmp0_;
#line 116 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self->priv->pending_updates_timer_id = (guint) 0;
#line 3142 "MediaMonitor.c"
}


static void media_monitor_finalize (GObject* obj) {
	MediaMonitor * self;
	MediaSourceCollection* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	MediaSourceCollection* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
#line 101 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_MONITOR, MediaMonitor);
#line 130 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp0_ = self->priv->sources;
#line 130 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_signal_parse_name ("item-destroyed", TYPE_SOURCE_COLLECTION, &_tmp1_, NULL, FALSE);
#line 130 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_SOURCE_COLLECTION, SourceCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _media_monitor_on_media_source_destroyed_source_collection_item_destroyed, self);
#line 131 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_tmp2_ = self->priv->sources;
#line 131 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_signal_parse_name ("unlinked-destroyed", TYPE_SOURCE_COLLECTION, &_tmp3_, NULL, FALSE);
#line 131 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_SOURCE_COLLECTION, SourceCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _media_monitor_on_media_source_destroyed_source_collection_unlinked_destroyed, self);
#line 112 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_data_collection_unref0 (self->priv->sources);
#line 113 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 114 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	_g_object_unref0 (self->priv->pending_updates);
#line 101 "/home/jens/Source/shotwell/src/MediaMonitor.vala"
	G_OBJECT_CLASS (media_monitor_parent_class)->finalize (obj);
#line 3174 "MediaMonitor.c"
}


GType media_monitor_get_type (void) {
	static volatile gsize media_monitor_type_id__volatile = 0;
	if (g_once_init_enter (&media_monitor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaMonitor), 0, (GInstanceInitFunc) media_monitor_instance_init, NULL };
		GType media_monitor_type_id;
		media_monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "MediaMonitor", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&media_monitor_type_id__volatile, media_monitor_type_id);
	}
	return media_monitor_type_id__volatile;
}



