/* DesktopIntegration.c generated by valac 0.34.7, the Vala compiler
 * generated from DesktopIntegration.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_EXPORTER_UI (exporter_ui_get_type ())
#define EXPORTER_UI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORTER_UI, ExporterUI))
#define EXPORTER_UI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORTER_UI, ExporterUIClass))
#define IS_EXPORTER_UI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORTER_UI))
#define IS_EXPORTER_UI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORTER_UI))
#define EXPORTER_UI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORTER_UI, ExporterUIClass))

typedef struct _ExporterUI ExporterUI;
typedef struct _ExporterUIClass ExporterUIClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SORTED_LIST (sorted_list_get_type ())
#define SORTED_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SORTED_LIST, SortedList))
#define SORTED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SORTED_LIST, SortedListClass))
#define IS_SORTED_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SORTED_LIST))
#define IS_SORTED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SORTED_LIST))
#define SORTED_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SORTED_LIST, SortedListClass))

typedef struct _SortedList SortedList;
typedef struct _SortedListClass SortedListClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_EXPORT_DIALOG (export_dialog_get_type ())
#define EXPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT_DIALOG, ExportDialog))
#define EXPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT_DIALOG, ExportDialogClass))
#define IS_EXPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT_DIALOG))
#define IS_EXPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT_DIALOG))
#define EXPORT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT_DIALOG, ExportDialogClass))

typedef struct _ExportDialog ExportDialog;
typedef struct _ExportDialogClass ExportDialogClass;

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;

#define TYPE_VIDEO (video_get_type ())
#define VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO, Video))
#define VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO, VideoClass))
#define IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO))
#define IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO))
#define VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO, VideoClass))

typedef struct _Video Video;
typedef struct _VideoClass VideoClass;

#define TYPE_EXPORTER (exporter_get_type ())
#define EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORTER, Exporter))
#define EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORTER, ExporterClass))
#define IS_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORTER))
#define IS_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORTER))
#define EXPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORTER, ExporterClass))

typedef struct _Exporter Exporter;
typedef struct _ExporterClass ExporterClass;
#define _exporter_ui_unref0(var) ((var == NULL) ? NULL : (var = (exporter_ui_unref (var), NULL)))

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())

#define TYPE_EXPORT_FORMAT_PARAMETERS (export_format_parameters_get_type ())

#define TYPE_EXPORT_FORMAT_MODE (export_format_mode_get_type ())

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define JPEG_TYPE_QUALITY (jpeg_quality_get_type ())
typedef struct _ExportFormatParameters ExportFormatParameters;

#define TYPE_SCALING (scaling_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
typedef struct _Scaling Scaling;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;

#define DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER (desktop_integration_background_slideshow_xml_builder_get_type ())
#define DESKTOP_INTEGRATION_BACKGROUND_SLIDESHOW_XML_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER, DesktopIntegrationBackgroundSlideshowXMLBuilder))
#define DESKTOP_INTEGRATION_BACKGROUND_SLIDESHOW_XML_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER, DesktopIntegrationBackgroundSlideshowXMLBuilderClass))
#define DESKTOP_INTEGRATION_IS_BACKGROUND_SLIDESHOW_XML_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER))
#define DESKTOP_INTEGRATION_IS_BACKGROUND_SLIDESHOW_XML_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER))
#define DESKTOP_INTEGRATION_BACKGROUND_SLIDESHOW_XML_BUILDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER, DesktopIntegrationBackgroundSlideshowXMLBuilderClass))

typedef struct _DesktopIntegrationBackgroundSlideshowXMLBuilder DesktopIntegrationBackgroundSlideshowXMLBuilder;
typedef struct _DesktopIntegrationBackgroundSlideshowXMLBuilderClass DesktopIntegrationBackgroundSlideshowXMLBuilderClass;
typedef struct _DesktopIntegrationBackgroundSlideshowXMLBuilderPrivate DesktopIntegrationBackgroundSlideshowXMLBuilderPrivate;
typedef struct _DesktopIntegrationParamSpecBackgroundSlideshowXMLBuilder DesktopIntegrationParamSpecBackgroundSlideshowXMLBuilder;
#define _desktop_integration_background_slideshow_xml_builder_unref0(var) ((var == NULL) ? NULL : (var = (desktop_integration_background_slideshow_xml_builder_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef gint64 (*Comparator) (void* a, void* b, void* user_data);
typedef void (*ExporterCompletionCallback) (Exporter* exporter, gboolean is_cancelled, void* user_data);
typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

typedef enum  {
	EXPORT_FORMAT_MODE_UNMODIFIED,
	EXPORT_FORMAT_MODE_CURRENT,
	EXPORT_FORMAT_MODE_SPECIFIED,
	EXPORT_FORMAT_MODE_LAST
} ExportFormatMode;

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

typedef enum  {
	JPEG_QUALITY_LOW = 50,
	JPEG_QUALITY_MEDIUM = 75,
	JPEG_QUALITY_HIGH = 90,
	JPEG_QUALITY_MAXIMUM = 100
} JpegQuality;

struct _ExportFormatParameters {
	ExportFormatMode mode;
	PhotoFileFormat specified_format;
	JpegQuality quality;
	gboolean export_metadata;
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

struct _DesktopIntegrationBackgroundSlideshowXMLBuilder {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DesktopIntegrationBackgroundSlideshowXMLBuilderPrivate * priv;
};

struct _DesktopIntegrationBackgroundSlideshowXMLBuilderClass {
	GTypeClass parent_class;
	void (*finalize) (DesktopIntegrationBackgroundSlideshowXMLBuilder *self);
};

struct _DesktopIntegrationBackgroundSlideshowXMLBuilderPrivate {
	GFile* destination;
	gdouble duration;
	gdouble transition;
	GFile* tmp_file;
	GDataOutputStream* outs;
	GFile* first_file;
	GFile* last_file;
};

struct _DesktopIntegrationParamSpecBackgroundSlideshowXMLBuilder {
	GParamSpec parent_instance;
};

typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, void* user_data);

extern gint desktop_integration_init_count;
gint desktop_integration_init_count = 0;
extern gboolean desktop_integration_send_to_installed;
gboolean desktop_integration_send_to_installed = FALSE;
extern ExporterUI* desktop_integration_send_to_exporter;
ExporterUI* desktop_integration_send_to_exporter = NULL;
extern ExporterUI* desktop_integration_desktop_slideshow_exporter;
ExporterUI* desktop_integration_desktop_slideshow_exporter = NULL;
extern gdouble desktop_integration_desktop_slideshow_transition;
gdouble desktop_integration_desktop_slideshow_transition = 0.0;
extern gdouble desktop_integration_desktop_slideshow_duration;
gdouble desktop_integration_desktop_slideshow_duration = 0.0;
extern gboolean desktop_integration_set_desktop_background;
gboolean desktop_integration_set_desktop_background = FALSE;
extern gboolean desktop_integration_set_screensaver;
gboolean desktop_integration_set_screensaver = FALSE;
static gpointer desktop_integration_background_slideshow_xml_builder_parent_class = NULL;

#define DESKTOP_INTEGRATION_SENDTO_EXEC "nautilus-sendto"
#define DESKTOP_INTEGRATION_DESKTOP_SLIDESHOW_XML_FILENAME "wallpaper.xml"
gpointer exporter_ui_ref (gpointer instance);
void exporter_ui_unref (gpointer instance);
GParamSpec* param_spec_exporter_ui (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_exporter_ui (GValue* value, gpointer v_object);
void value_take_exporter_ui (GValue* value, gpointer v_object);
gpointer value_get_exporter_ui (const GValue* value);
GType exporter_ui_get_type (void) G_GNUC_CONST;
void desktop_integration_init (void);
void desktop_integration_terminate (void);
GAppInfo* desktop_integration_get_default_app_for_mime_types (gchar** mime_types, int mime_types_length1, GeeArrayList* preferred_apps);
GType sorted_list_get_type (void) G_GNUC_CONST;
SortedList* desktop_integration_get_apps_for_mime_types (gchar** mime_types, int mime_types_length1);
gint64 desktop_integration_app_info_comparator (void* a, void* b);
static gint64 _desktop_integration_app_info_comparator_comparator (void* a, void* b, gpointer self);
SortedList* sorted_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, Comparator cmp, void* cmp_target);
SortedList* sorted_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, Comparator cmp, void* cmp_target);
#define RESOURCES_APP_TITLE "Shotwell"
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
gchar* desktop_integration_get_app_open_command (GAppInfo* app_info);
gboolean desktop_integration_is_send_to_installed (void);
void desktop_integration_files_send_to (GFile** files, int files_length1);
GType page_window_get_type (void) G_GNUC_CONST;
GType app_window_get_type (void) G_GNUC_CONST;
AppWindow* app_window_get_instance (void);
void page_window_set_busy_cursor (PageWindow* self);
void page_window_set_normal_cursor (PageWindow* self);
void app_window_error_message (const gchar* message, GtkWindow* parent);
GType data_object_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
void desktop_integration_send_to (GeeCollection* media);
GType export_dialog_get_type (void) G_GNUC_CONST;
ExportDialog* export_dialog_new (const gchar* title);
ExportDialog* export_dialog_construct (GType object_type, const gchar* title);
gboolean media_source_collection_has_video (GeeCollection* media);
gboolean media_source_collection_has_photo (GeeCollection* media);
GType video_source_get_type (void) G_GNUC_CONST;
GType video_get_type (void) G_GNUC_CONST;
GType exporter_get_type (void) G_GNUC_CONST;
ExporterUI* video_export_many (GeeCollection* videos, ExporterCompletionCallback done, void* done_target, gboolean export_in_place);
void desktop_integration_on_send_to_export_completed (Exporter* exporter, gboolean is_cancelled);
static void _desktop_integration_on_send_to_export_completed_exporter_completion_callback (Exporter* exporter, gboolean is_cancelled, gpointer self);
GType scale_constraint_get_type (void) G_GNUC_CONST;
GType export_format_parameters_get_type (void) G_GNUC_CONST;
GType export_format_mode_get_type (void) G_GNUC_CONST;
GType photo_file_format_get_type (void) G_GNUC_CONST;
GType jpeg_quality_get_type (void) G_GNUC_CONST;
ExportFormatParameters* export_format_parameters_dup (const ExportFormatParameters* self);
void export_format_parameters_free (ExportFormatParameters* self);
void export_format_parameters_current (ExportFormatParameters* result);
gboolean export_dialog_execute (ExportDialog* self, gint* scale, ScaleConstraint* constraint, ExportFormatParameters* parameters);
GType scaling_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
Scaling* scaling_dup (const Scaling* self);
void scaling_free (Scaling* self);
void scaling_for_constraint (ScaleConstraint constraint, gint scale, gboolean scale_up, Scaling* result);
Exporter* exporter_new_for_temp_file (GeeCollection* to_export, Scaling* scaling, ExportFormatParameters* export_params);
Exporter* exporter_construct_for_temp_file (GType object_type, GeeCollection* to_export, Scaling* scaling, ExportFormatParameters* export_params);
ExporterUI* exporter_ui_new (Exporter* exporter);
ExporterUI* exporter_ui_construct (GType object_type, Exporter* exporter);
void exporter_ui_export (ExporterUI* self, ExporterCompletionCallback completion_callback, void* completion_callback_target);
GFile** exporter_get_exported_files (Exporter* self, int* result_length1);
GType photo_source_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
void desktop_integration_set_background (Photo* photo, gboolean desktop, gboolean screensaver);
PhotoFileFormat photo_get_best_export_file_format (Photo* self);
GFile* app_dirs_get_data_subdir (const gchar* name, const gchar* subname);
gchar* photo_file_format_get_default_basename (PhotoFileFormat self, const gchar* name);
GType configuration_facade_get_type (void) G_GNUC_CONST;
GType config_facade_get_type (void) G_GNUC_CONST;
ConfigFacade* config_facade_get_instance (void);
gchar* configuration_facade_get_desktop_background (ConfigurationFacade* self);
void photo_export (Photo* self, GFile* dest_file, Scaling* scaling, JpegQuality quality, PhotoFileFormat export_format, gboolean direct_copy_unmodified, gboolean export_metadata, GError** error);
void scaling_for_original (Scaling* result);
void configuration_facade_set_desktop_background (ConfigurationFacade* self, const gchar* filename);
void configuration_facade_set_screensaver (ConfigurationFacade* self, const gchar* filename);
gpointer desktop_integration_background_slideshow_xml_builder_ref (gpointer instance);
void desktop_integration_background_slideshow_xml_builder_unref (gpointer instance);
GParamSpec* desktop_integration_param_spec_background_slideshow_xml_builder (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void desktop_integration_value_set_background_slideshow_xml_builder (GValue* value, gpointer v_object);
void desktop_integration_value_take_background_slideshow_xml_builder (GValue* value, gpointer v_object);
gpointer desktop_integration_value_get_background_slideshow_xml_builder (const GValue* value);
GType desktop_integration_background_slideshow_xml_builder_get_type (void) G_GNUC_CONST;
#define DESKTOP_INTEGRATION_BACKGROUND_SLIDESHOW_XML_BUILDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER, DesktopIntegrationBackgroundSlideshowXMLBuilderPrivate))
enum  {
	DESKTOP_INTEGRATION_BACKGROUND_SLIDESHOW_XML_BUILDER_DUMMY_PROPERTY
};
DesktopIntegrationBackgroundSlideshowXMLBuilder* desktop_integration_background_slideshow_xml_builder_new (GFile* destination, gdouble duration, gdouble transition);
DesktopIntegrationBackgroundSlideshowXMLBuilder* desktop_integration_background_slideshow_xml_builder_construct (GType object_type, GFile* destination, gdouble duration, gdouble transition);
void desktop_integration_background_slideshow_xml_builder_open (DesktopIntegrationBackgroundSlideshowXMLBuilder* self, GError** error);
static void desktop_integration_background_slideshow_xml_builder_write_transition (DesktopIntegrationBackgroundSlideshowXMLBuilder* self, GFile* from, GFile* to, GError** error);
static void desktop_integration_background_slideshow_xml_builder_write_static (DesktopIntegrationBackgroundSlideshowXMLBuilder* self, GFile* file, GError** error);
void desktop_integration_background_slideshow_xml_builder_add_photo (DesktopIntegrationBackgroundSlideshowXMLBuilder* self, GFile* file, GError** error);
GFile* desktop_integration_background_slideshow_xml_builder_close (DesktopIntegrationBackgroundSlideshowXMLBuilder* self, GError** error);
static void desktop_integration_background_slideshow_xml_builder_finalize (DesktopIntegrationBackgroundSlideshowXMLBuilder* obj);
void desktop_integration_set_background_slideshow (GeeCollection* photos, gdouble duration, gdouble transition, gboolean desktop_background, gboolean screensaver);
void delete_all_files (GFile* dir, GeeSet* exceptions, ProgressMonitor monitor, void* monitor_target, guint64 file_count, GCancellable* cancellable, GError** error);
void scaling_to_fill_screen (GtkWindow* window, Scaling* result);
Exporter* exporter_new (GeeCollection* to_export, GFile* dir, Scaling* scaling, ExportFormatParameters* export_params, gboolean auto_replace_all);
Exporter* exporter_construct (GType object_type, GeeCollection* to_export, GFile* dir, Scaling* scaling, ExportFormatParameters* export_params, gboolean auto_replace_all);
void desktop_integration_on_desktop_slideshow_exported (Exporter* exporter, gboolean is_cancelled);
static void _desktop_integration_on_desktop_slideshow_exported_exporter_completion_callback (Exporter* exporter, gboolean is_cancelled, gpointer self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


void desktop_integration_init (void) {
	gint _tmp0_ = 0;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 23 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = desktop_integration_init_count;
#line 23 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	desktop_integration_init_count = _tmp0_ + 1;
#line 23 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp0_ != 0) {
#line 24 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 445 "DesktopIntegration.c"
	}
#line 26 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1_ = g_find_program_in_path (DESKTOP_INTEGRATION_SENDTO_EXEC);
#line 26 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp2_ = _tmp1_;
#line 26 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	desktop_integration_send_to_installed = _tmp2_ != NULL;
#line 26 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp2_);
#line 455 "DesktopIntegration.c"
}


void desktop_integration_terminate (void) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 30 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = desktop_integration_init_count;
#line 30 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	desktop_integration_init_count = _tmp0_ - 1;
#line 30 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1_ = desktop_integration_init_count;
#line 30 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp1_ == 0) {
#line 31 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 472 "DesktopIntegration.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return self ? g_object_ref (self) : NULL;
#line 480 "DesktopIntegration.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1376 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1376 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 500 "DesktopIntegration.c"
}


GAppInfo* desktop_integration_get_default_app_for_mime_types (gchar** mime_types, int mime_types_length1, GeeArrayList* preferred_apps) {
	GAppInfo* result = NULL;
	SortedList* external_apps = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	SortedList* _tmp1_ = NULL;
#line 34 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_val_if_fail (GEE_IS_ARRAY_LIST (preferred_apps), NULL);
#line 36 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = mime_types;
#line 36 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0__length1 = mime_types_length1;
#line 36 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1_ = desktop_integration_get_apps_for_mime_types (_tmp0_, _tmp0__length1);
#line 36 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	external_apps = _tmp1_;
#line 520 "DesktopIntegration.c"
	{
		GeeArrayList* _preferred_app_list = NULL;
		GeeArrayList* _tmp2_ = NULL;
		GeeArrayList* _tmp3_ = NULL;
		gint _preferred_app_size = 0;
		GeeArrayList* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _preferred_app_index = 0;
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp2_ = preferred_apps;
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp3_ = _g_object_ref0 (_tmp2_);
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_preferred_app_list = _tmp3_;
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp4_ = _preferred_app_list;
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp5_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp6_ = _tmp5_;
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_preferred_app_size = _tmp6_;
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_preferred_app_index = -1;
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		while (TRUE) {
#line 548 "DesktopIntegration.c"
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gchar* preferred_app = NULL;
			GeeArrayList* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			gpointer _tmp12_ = NULL;
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			_tmp7_ = _preferred_app_index;
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			_preferred_app_index = _tmp7_ + 1;
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			_tmp8_ = _preferred_app_index;
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			_tmp9_ = _preferred_app_size;
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			if (!(_tmp8_ < _tmp9_)) {
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				break;
#line 568 "DesktopIntegration.c"
			}
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			_tmp10_ = _preferred_app_list;
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			_tmp11_ = _preferred_app_index;
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			_tmp12_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp11_);
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			preferred_app = (gchar*) _tmp12_;
#line 578 "DesktopIntegration.c"
			{
				GeeIterator* _external_app_it = NULL;
				SortedList* _tmp13_ = NULL;
				GeeIterator* _tmp14_ = NULL;
#line 39 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp13_ = external_apps;
#line 39 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp14_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ITERABLE, GeeIterable));
#line 39 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_external_app_it = _tmp14_;
#line 39 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				while (TRUE) {
#line 591 "DesktopIntegration.c"
					GeeIterator* _tmp15_ = NULL;
					gboolean _tmp16_ = FALSE;
					GAppInfo* external_app = NULL;
					GeeIterator* _tmp17_ = NULL;
					gpointer _tmp18_ = NULL;
					GAppInfo* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
					const gchar* _tmp21_ = NULL;
					gboolean _tmp22_ = FALSE;
#line 39 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					_tmp15_ = _external_app_it;
#line 39 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					_tmp16_ = gee_iterator_next (_tmp15_);
#line 39 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					if (!_tmp16_) {
#line 39 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
						break;
#line 609 "DesktopIntegration.c"
					}
#line 39 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					_tmp17_ = _external_app_it;
#line 39 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					_tmp18_ = gee_iterator_get (_tmp17_);
#line 39 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					external_app = (GAppInfo*) _tmp18_;
#line 40 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					_tmp19_ = external_app;
#line 40 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					_tmp20_ = g_app_info_get_name (_tmp19_);
#line 40 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					_tmp21_ = preferred_app;
#line 40 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					_tmp22_ = string_contains (_tmp20_, _tmp21_);
#line 40 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					if (_tmp22_) {
#line 41 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
						result = external_app;
#line 41 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
						_g_object_unref0 (_external_app_it);
#line 41 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
						_g_free0 (preferred_app);
#line 41 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
						_g_object_unref0 (_preferred_app_list);
#line 41 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
						_g_object_unref0 (external_apps);
#line 41 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
						return result;
#line 639 "DesktopIntegration.c"
					}
#line 39 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					_g_object_unref0 (external_app);
#line 643 "DesktopIntegration.c"
				}
#line 39 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_g_object_unref0 (_external_app_it);
#line 647 "DesktopIntegration.c"
			}
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			_g_free0 (preferred_app);
#line 651 "DesktopIntegration.c"
		}
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (_preferred_app_list);
#line 655 "DesktopIntegration.c"
	}
#line 45 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	result = NULL;
#line 45 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (external_apps);
#line 45 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return result;
#line 663 "DesktopIntegration.c"
}


gint64 desktop_integration_app_info_comparator (void* a, void* b) {
	gint64 result = 0LL;
	void* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	void* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint64 _tmp9_ = 0LL;
#line 50 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = a;
#line 50 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1_ = g_app_info_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_app_info_get_type (), GAppInfo));
#line 50 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp2_ = g_utf8_strdown (_tmp1_, (gssize) -1);
#line 50 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp3_ = _tmp2_;
#line 50 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp4_ = b;
#line 50 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp5_ = g_app_info_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_app_info_get_type (), GAppInfo));
#line 50 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp6_ = g_utf8_strdown (_tmp5_, (gssize) -1);
#line 50 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp7_ = _tmp6_;
#line 50 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp8_ = g_utf8_collate (_tmp3_, _tmp7_);
#line 50 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp9_ = (gint64) _tmp8_;
#line 50 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp7_);
#line 50 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp3_);
#line 50 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	result = _tmp9_;
#line 50 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return result;
#line 707 "DesktopIntegration.c"
}


static gint64 _desktop_integration_app_info_comparator_comparator (void* a, void* b, gpointer self) {
	gint64 result;
	result = desktop_integration_app_info_comparator (a, b);
#line 54 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return result;
#line 716 "DesktopIntegration.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 66 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 723 "DesktopIntegration.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 66 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 66 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_list_free (self);
#line 732 "DesktopIntegration.c"
}


SortedList* desktop_integration_get_apps_for_mime_types (gchar** mime_types, int mime_types_length1) {
	SortedList* result = NULL;
	SortedList* external_apps = NULL;
	SortedList* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
#line 54 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = sorted_list_new (g_app_info_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _desktop_integration_app_info_comparator_comparator, NULL);
#line 54 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	external_apps = _tmp0_;
#line 56 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1_ = mime_types;
#line 56 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1__length1 = mime_types_length1;
#line 56 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp1__length1 == 0) {
#line 57 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		result = external_apps;
#line 57 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return result;
#line 758 "DesktopIntegration.c"
	}
#line 61 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp2_ = mime_types;
#line 61 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp2__length1 = mime_types_length1;
#line 764 "DesktopIntegration.c"
	{
		gchar** mime_type_collection = NULL;
		gint mime_type_collection_length1 = 0;
		gint _mime_type_collection_size_ = 0;
		gint mime_type_it = 0;
#line 61 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		mime_type_collection = _tmp2_;
#line 61 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		mime_type_collection_length1 = _tmp2__length1;
#line 61 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		for (mime_type_it = 0; mime_type_it < _tmp2__length1; mime_type_it = mime_type_it + 1) {
#line 776 "DesktopIntegration.c"
			gchar* _tmp3_ = NULL;
			gchar* mime_type = NULL;
#line 61 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			_tmp3_ = g_strdup (mime_type_collection[mime_type_it]);
#line 61 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			mime_type = _tmp3_;
#line 783 "DesktopIntegration.c"
			{
				gchar* content_type = NULL;
				const gchar* _tmp4_ = NULL;
				gchar* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
				GList* _tmp8_ = NULL;
#line 62 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp4_ = mime_type;
#line 62 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp5_ = g_content_type_from_mime_type (_tmp4_);
#line 62 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				content_type = _tmp5_;
#line 63 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp6_ = content_type;
#line 63 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				if (_tmp6_ == NULL) {
#line 64 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					_g_free0 (content_type);
#line 64 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					_g_free0 (mime_type);
#line 64 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					break;
#line 807 "DesktopIntegration.c"
				}
#line 66 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp7_ = content_type;
#line 66 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp8_ = g_app_info_get_all_for_type (_tmp7_);
#line 813 "DesktopIntegration.c"
				{
					GList* external_app_collection = NULL;
					GList* external_app_it = NULL;
#line 66 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					external_app_collection = _tmp8_;
#line 66 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					for (external_app_it = external_app_collection; external_app_it != NULL; external_app_it = external_app_it->next) {
#line 821 "DesktopIntegration.c"
						GAppInfo* _tmp9_ = NULL;
						GAppInfo* external_app = NULL;
#line 66 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
						_tmp9_ = _g_object_ref0 ((GAppInfo*) external_app_it->data);
#line 66 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
						external_app = _tmp9_;
#line 828 "DesktopIntegration.c"
						{
							gboolean already_contains = FALSE;
							gboolean _tmp20_ = FALSE;
							gboolean _tmp21_ = FALSE;
#line 68 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
							already_contains = FALSE;
#line 835 "DesktopIntegration.c"
							{
								GeeIterator* _app_it = NULL;
								SortedList* _tmp10_ = NULL;
								GeeIterator* _tmp11_ = NULL;
#line 70 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
								_tmp10_ = external_apps;
#line 70 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
								_tmp11_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ITERABLE, GeeIterable));
#line 70 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
								_app_it = _tmp11_;
#line 70 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
								while (TRUE) {
#line 848 "DesktopIntegration.c"
									GeeIterator* _tmp12_ = NULL;
									gboolean _tmp13_ = FALSE;
									GAppInfo* app = NULL;
									GeeIterator* _tmp14_ = NULL;
									gpointer _tmp15_ = NULL;
									GAppInfo* _tmp16_ = NULL;
									const gchar* _tmp17_ = NULL;
									GAppInfo* _tmp18_ = NULL;
									const gchar* _tmp19_ = NULL;
#line 70 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
									_tmp12_ = _app_it;
#line 70 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
									_tmp13_ = gee_iterator_next (_tmp12_);
#line 70 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
									if (!_tmp13_) {
#line 70 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
										break;
#line 866 "DesktopIntegration.c"
									}
#line 70 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
									_tmp14_ = _app_it;
#line 70 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
									_tmp15_ = gee_iterator_get (_tmp14_);
#line 70 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
									app = (GAppInfo*) _tmp15_;
#line 71 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
									_tmp16_ = app;
#line 71 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
									_tmp17_ = g_app_info_get_name (_tmp16_);
#line 71 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
									_tmp18_ = external_app;
#line 71 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
									_tmp19_ = g_app_info_get_name (_tmp18_);
#line 71 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
									if (g_strcmp0 (_tmp17_, _tmp19_) == 0) {
#line 72 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
										already_contains = TRUE;
#line 73 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
										_g_object_unref0 (app);
#line 73 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
										break;
#line 890 "DesktopIntegration.c"
									}
#line 70 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
									_g_object_unref0 (app);
#line 894 "DesktopIntegration.c"
								}
#line 70 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
								_g_object_unref0 (_app_it);
#line 898 "DesktopIntegration.c"
							}
#line 78 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
							_tmp21_ = already_contains;
#line 78 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
							if (!_tmp21_) {
#line 904 "DesktopIntegration.c"
								GAppInfo* _tmp22_ = NULL;
								const gchar* _tmp23_ = NULL;
								gboolean _tmp24_ = FALSE;
#line 78 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
								_tmp22_ = external_app;
#line 78 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
								_tmp23_ = g_app_info_get_name (_tmp22_);
#line 78 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
								_tmp24_ = string_contains (_tmp23_, RESOURCES_APP_TITLE);
#line 78 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
								_tmp20_ = !_tmp24_;
#line 916 "DesktopIntegration.c"
							} else {
#line 78 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
								_tmp20_ = FALSE;
#line 920 "DesktopIntegration.c"
							}
#line 78 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
							if (_tmp20_) {
#line 924 "DesktopIntegration.c"
								SortedList* _tmp25_ = NULL;
								GAppInfo* _tmp26_ = NULL;
#line 79 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
								_tmp25_ = external_apps;
#line 79 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
								_tmp26_ = external_app;
#line 79 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
								gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_COLLECTION, GeeCollection), _tmp26_);
#line 933 "DesktopIntegration.c"
							}
#line 66 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
							_g_object_unref0 (external_app);
#line 937 "DesktopIntegration.c"
						}
					}
#line 66 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					__g_list_free__g_object_unref0_0 (external_app_collection);
#line 942 "DesktopIntegration.c"
				}
#line 61 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_g_free0 (content_type);
#line 61 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_g_free0 (mime_type);
#line 948 "DesktopIntegration.c"
			}
		}
	}
#line 83 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	result = external_apps;
#line 83 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return result;
#line 956 "DesktopIntegration.c"
}


gchar* desktop_integration_get_app_open_command (GAppInfo* app_info) {
	gchar* result = NULL;
	gchar* str = NULL;
	GAppInfo* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp8_ = NULL;
#line 86 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_val_if_fail (G_IS_APP_INFO (app_info), NULL);
#line 87 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = app_info;
#line 87 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1_ = g_app_info_get_commandline (_tmp0_);
#line 87 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 87 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	str = _tmp2_;
#line 89 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp4_ = str;
#line 89 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp4_ != NULL) {
#line 983 "DesktopIntegration.c"
		const gchar* _tmp5_ = NULL;
#line 89 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp5_ = str;
#line 89 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp3_ = _tmp5_;
#line 989 "DesktopIntegration.c"
	} else {
		GAppInfo* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 89 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp6_ = app_info;
#line 89 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp7_ = g_app_info_get_executable (_tmp6_);
#line 89 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp3_ = _tmp7_;
#line 999 "DesktopIntegration.c"
	}
#line 89 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp8_ = g_strdup (_tmp3_);
#line 89 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	result = _tmp8_;
#line 89 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (str);
#line 89 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return result;
#line 1009 "DesktopIntegration.c"
}


gboolean desktop_integration_is_send_to_installed (void) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 93 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = desktop_integration_send_to_installed;
#line 93 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	result = _tmp0_;
#line 93 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return result;
#line 1022 "DesktopIntegration.c"
}


void desktop_integration_files_send_to (GFile** files, int files_length1) {
	GFile** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** argv = NULL;
	GFile** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint argv_length1 = 0;
	gint _argv_size_ = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 97 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = files;
#line 97 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0__length1 = files_length1;
#line 97 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp0__length1 == 0) {
#line 98 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 1048 "DesktopIntegration.c"
	}
#line 100 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1_ = files;
#line 100 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1__length1 = files_length1;
#line 100 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp2_ = g_new0 (gchar*, (_tmp1__length1 + 1) + 1);
#line 100 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	argv = _tmp2_;
#line 100 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	argv_length1 = _tmp1__length1 + 1;
#line 100 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_argv_size_ = argv_length1;
#line 101 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp3_ = argv;
#line 101 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp3__length1 = argv_length1;
#line 101 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp4_ = g_strdup (DESKTOP_INTEGRATION_SENDTO_EXEC);
#line 101 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp3_[0]);
#line 101 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp3_[0] = _tmp4_;
#line 101 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp5_ = _tmp3_[0];
#line 1074 "DesktopIntegration.c"
	{
		gint ctr = 0;
#line 103 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		ctr = 0;
#line 1079 "DesktopIntegration.c"
		{
			gboolean _tmp6_ = FALSE;
#line 103 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			_tmp6_ = TRUE;
#line 103 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			while (TRUE) {
#line 1086 "DesktopIntegration.c"
				gint _tmp8_ = 0;
				GFile** _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				gchar** _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				gint _tmp11_ = 0;
				GFile** _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				gint _tmp13_ = 0;
				GFile* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
#line 103 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				if (!_tmp6_) {
#line 1101 "DesktopIntegration.c"
					gint _tmp7_ = 0;
#line 103 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					_tmp7_ = ctr;
#line 103 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					ctr = _tmp7_ + 1;
#line 1107 "DesktopIntegration.c"
				}
#line 103 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp6_ = FALSE;
#line 103 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp8_ = ctr;
#line 103 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp9_ = files;
#line 103 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp9__length1 = files_length1;
#line 103 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				if (!(_tmp8_ < _tmp9__length1)) {
#line 103 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					break;
#line 1121 "DesktopIntegration.c"
				}
#line 104 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp10_ = argv;
#line 104 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp10__length1 = argv_length1;
#line 104 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp11_ = ctr;
#line 104 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp12_ = files;
#line 104 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp12__length1 = files_length1;
#line 104 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp13_ = ctr;
#line 104 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp14_ = _tmp12_[_tmp13_];
#line 104 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp15_ = g_file_get_path (_tmp14_);
#line 104 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_g_free0 (_tmp10_[_tmp11_ + 1]);
#line 104 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp10_[_tmp11_ + 1] = _tmp15_;
#line 104 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp16_ = _tmp10_[_tmp11_ + 1];
#line 1145 "DesktopIntegration.c"
			}
		}
	}
	{
		AppWindow* _tmp17_ = NULL;
		AppWindow* _tmp18_ = NULL;
		GPid child_pid = 0;
		gchar** _tmp19_ = NULL;
		gint _tmp19__length1 = 0;
		GPid _tmp20_ = 0;
		AppWindow* _tmp21_ = NULL;
		AppWindow* _tmp22_ = NULL;
#line 107 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp17_ = app_window_get_instance ();
#line 107 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp18_ = _tmp17_;
#line 107 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		page_window_set_busy_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, TYPE_PAGE_WINDOW, PageWindow));
#line 107 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (_tmp18_);
#line 110 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp19_ = argv;
#line 110 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp19__length1 = argv_length1;
#line 110 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_spawn_async ("/", _tmp19_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp20_, &_inner_error_);
#line 110 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		child_pid = _tmp20_;
#line 110 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1176 "DesktopIntegration.c"
			goto __catch557_g_error;
		}
#line 118 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp21_ = app_window_get_instance ();
#line 118 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp22_ = _tmp21_;
#line 118 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		page_window_set_normal_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, TYPE_PAGE_WINDOW, PageWindow));
#line 118 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (_tmp22_);
#line 1187 "DesktopIntegration.c"
	}
	goto __finally557;
	__catch557_g_error:
	{
		GError* err = NULL;
		AppWindow* _tmp23_ = NULL;
		AppWindow* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		GError* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
#line 106 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		err = _inner_error_;
#line 106 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_inner_error_ = NULL;
#line 120 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp23_ = app_window_get_instance ();
#line 120 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp24_ = _tmp23_;
#line 120 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		page_window_set_normal_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, TYPE_PAGE_WINDOW, PageWindow));
#line 120 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (_tmp24_);
#line 121 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp25_ = _ ("Unable to launch Nautilus Send-To: %s");
#line 121 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp26_ = err;
#line 121 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp27_ = _tmp26_->message;
#line 121 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp28_ = g_strdup_printf (_tmp25_, _tmp27_);
#line 121 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp29_ = _tmp28_;
#line 121 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		app_window_error_message (_tmp29_, NULL);
#line 121 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_free0 (_tmp29_);
#line 106 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_error_free0 (err);
#line 1228 "DesktopIntegration.c"
	}
	__finally557:
#line 106 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 106 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 106 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 106 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_clear_error (&_inner_error_);
#line 106 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 1241 "DesktopIntegration.c"
	}
#line 96 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 1245 "DesktopIntegration.c"
}


static void _desktop_integration_on_send_to_export_completed_exporter_completion_callback (Exporter* exporter, gboolean is_cancelled, gpointer self) {
#line 135 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	desktop_integration_on_send_to_export_completed (exporter, is_cancelled);
#line 1252 "DesktopIntegration.c"
}


void desktop_integration_send_to (GeeCollection* media) {
	gboolean _tmp0_ = FALSE;
	GeeCollection* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	ExportDialog* dialog = NULL;
	const gchar* _tmp5_ = NULL;
	ExportDialog* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GeeCollection* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	gint scale = 0;
	ScaleConstraint constraint = 0;
	ExportFormatParameters export_params = {0};
	ExportFormatParameters _tmp14_ = {0};
	ExportDialog* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	ScaleConstraint _tmp17_ = 0;
	gboolean _tmp18_ = FALSE;
	GeeCollection* _tmp19_ = NULL;
	ScaleConstraint _tmp20_ = 0;
	gint _tmp21_ = 0;
	Scaling _tmp22_ = {0};
	ExportFormatParameters _tmp23_ = {0};
	Exporter* _tmp24_ = NULL;
	Exporter* _tmp25_ = NULL;
	ExporterUI* _tmp26_ = NULL;
	ExporterUI* _tmp27_ = NULL;
#line 125 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_if_fail (GEE_IS_COLLECTION (media));
#line 126 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1_ = media;
#line 126 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp2_ = gee_collection_get_size (_tmp1_);
#line 126 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp3_ = _tmp2_;
#line 126 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp3_ == 0) {
#line 126 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp0_ = TRUE;
#line 1296 "DesktopIntegration.c"
	} else {
		ExporterUI* _tmp4_ = NULL;
#line 126 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp4_ = desktop_integration_send_to_exporter;
#line 126 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp0_ = _tmp4_ != NULL;
#line 1303 "DesktopIntegration.c"
	}
#line 126 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp0_) {
#line 127 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 1309 "DesktopIntegration.c"
	}
#line 129 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp5_ = _ ("Send To");
#line 129 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp6_ = export_dialog_new (_tmp5_);
#line 129 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_object_ref_sink (_tmp6_);
#line 129 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	dialog = _tmp6_;
#line 134 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp8_ = media;
#line 134 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp9_ = media_source_collection_has_video (_tmp8_);
#line 134 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp9_) {
#line 1325 "DesktopIntegration.c"
		GeeCollection* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
#line 134 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp10_ = media;
#line 134 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp11_ = media_source_collection_has_photo (_tmp10_);
#line 134 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp7_ = !_tmp11_;
#line 1334 "DesktopIntegration.c"
	} else {
#line 134 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp7_ = FALSE;
#line 1338 "DesktopIntegration.c"
	}
#line 134 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp7_) {
#line 1342 "DesktopIntegration.c"
		GeeCollection* _tmp12_ = NULL;
		ExporterUI* _tmp13_ = NULL;
#line 135 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp12_ = media;
#line 135 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp13_ = video_export_many (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_COLLECTION, GeeCollection), _desktop_integration_on_send_to_export_completed_exporter_completion_callback, NULL, TRUE);
#line 135 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_exporter_ui_unref0 (desktop_integration_send_to_exporter);
#line 135 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		desktop_integration_send_to_exporter = _tmp13_;
#line 137 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (dialog);
#line 137 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 1357 "DesktopIntegration.c"
	}
#line 142 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	export_format_parameters_current (&_tmp14_);
#line 142 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	export_params = _tmp14_;
#line 143 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp15_ = dialog;
#line 143 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp18_ = export_dialog_execute (_tmp15_, &_tmp16_, &_tmp17_, &export_params);
#line 143 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	scale = _tmp16_;
#line 143 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	constraint = _tmp17_;
#line 143 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (!_tmp18_) {
#line 144 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (dialog);
#line 144 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 1377 "DesktopIntegration.c"
	}
#line 146 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp19_ = media;
#line 146 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp20_ = constraint;
#line 146 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp21_ = scale;
#line 146 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	scaling_for_constraint (_tmp20_, _tmp21_, FALSE, &_tmp22_);
#line 146 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp23_ = export_params;
#line 146 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp24_ = exporter_new_for_temp_file (_tmp19_, &_tmp22_, &_tmp23_);
#line 146 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp25_ = _tmp24_;
#line 146 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp26_ = exporter_ui_new (_tmp25_);
#line 146 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_exporter_ui_unref0 (desktop_integration_send_to_exporter);
#line 146 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	desktop_integration_send_to_exporter = _tmp26_;
#line 146 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (_tmp25_);
#line 148 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp27_ = desktop_integration_send_to_exporter;
#line 148 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	exporter_ui_export (_tmp27_, _desktop_integration_on_send_to_export_completed_exporter_completion_callback, NULL);
#line 125 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (dialog);
#line 1407 "DesktopIntegration.c"
}


void desktop_integration_on_send_to_export_completed (Exporter* exporter, gboolean is_cancelled) {
	gboolean _tmp0_ = FALSE;
#line 151 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_if_fail (IS_EXPORTER (exporter));
#line 152 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = is_cancelled;
#line 152 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (!_tmp0_) {
#line 1419 "DesktopIntegration.c"
		Exporter* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		GFile** _tmp3_ = NULL;
		GFile** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
#line 153 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp1_ = exporter;
#line 153 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp3_ = exporter_get_exported_files (_tmp1_, &_tmp2_);
#line 153 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp4_ = _tmp3_;
#line 153 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp4__length1 = _tmp2_;
#line 153 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		desktop_integration_files_send_to (_tmp4_, _tmp2_);
#line 153 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_object_unref), NULL);
#line 1437 "DesktopIntegration.c"
	}
#line 155 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_exporter_ui_unref0 (desktop_integration_send_to_exporter);
#line 155 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	desktop_integration_send_to_exporter = NULL;
#line 1443 "DesktopIntegration.c"
}


void desktop_integration_set_background (Photo* photo, gboolean desktop, gboolean screensaver) {
	PhotoFileFormat file_format = 0;
	Photo* _tmp0_ = NULL;
	PhotoFileFormat _tmp1_ = 0;
	GFile* save_as = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	PhotoFileFormat _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GFile* _tmp7_ = NULL;
	GFile* _tmp8_ = NULL;
	ConfigFacade* _tmp9_ = NULL;
	ConfigFacade* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	GFile* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp41_ = FALSE;
	GFile* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	GError * _inner_error_ = NULL;
#line 158 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_if_fail (IS_PHOTO (photo));
#line 161 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = photo;
#line 161 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1_ = photo_get_best_export_file_format (_tmp0_);
#line 161 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	file_format = _tmp1_;
#line 163 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp2_ = app_dirs_get_data_subdir ("wallpaper", NULL);
#line 163 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp3_ = _tmp2_;
#line 163 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp4_ = file_format;
#line 163 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp5_ = photo_file_format_get_default_basename (_tmp4_, "wallpaper");
#line 163 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp6_ = _tmp5_;
#line 163 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp7_ = g_file_get_child (_tmp3_, _tmp6_);
#line 163 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp8_ = _tmp7_;
#line 163 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp6_);
#line 163 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (_tmp3_);
#line 163 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	save_as = _tmp8_;
#line 166 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp9_ = config_facade_get_instance ();
#line 166 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp10_ = _tmp9_;
#line 166 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp11_ = configuration_facade_get_desktop_background (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 166 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp12_ = _tmp11_;
#line 166 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp13_ = save_as;
#line 166 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp14_ = g_file_get_path (_tmp13_);
#line 166 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp15_ = _tmp14_;
#line 166 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp16_ = g_strcmp0 (_tmp12_, _tmp15_) == 0;
#line 166 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp15_);
#line 166 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp12_);
#line 166 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (_tmp10_);
#line 166 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp16_) {
#line 1525 "DesktopIntegration.c"
		GFile* _tmp17_ = NULL;
		GFile* _tmp18_ = NULL;
		PhotoFileFormat _tmp19_ = 0;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		GFile* _tmp22_ = NULL;
#line 167 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp17_ = app_dirs_get_data_subdir ("wallpaper", NULL);
#line 167 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp18_ = _tmp17_;
#line 167 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp19_ = file_format;
#line 167 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp20_ = photo_file_format_get_default_basename (_tmp19_, "wallpaper_alt");
#line 167 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp21_ = _tmp20_;
#line 167 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp22_ = g_file_get_child (_tmp18_, _tmp21_);
#line 167 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (save_as);
#line 167 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		save_as = _tmp22_;
#line 167 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_free0 (_tmp21_);
#line 167 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (_tmp18_);
#line 1552 "DesktopIntegration.c"
	}
	{
		Photo* _tmp23_ = NULL;
		GFile* _tmp24_ = NULL;
		Scaling _tmp25_ = {0};
		PhotoFileFormat _tmp26_ = 0;
#line 172 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp23_ = photo;
#line 172 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp24_ = save_as;
#line 172 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		scaling_for_original (&_tmp25_);
#line 172 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp26_ = file_format;
#line 172 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		photo_export (_tmp23_, _tmp24_, &_tmp25_, JPEG_QUALITY_HIGH, _tmp26_, FALSE, TRUE, &_inner_error_);
#line 172 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1571 "DesktopIntegration.c"
			goto __catch558_g_error;
		}
	}
	goto __finally558;
	__catch558_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp27_ = NULL;
		GFile* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		GError* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
#line 171 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		err = _inner_error_;
#line 171 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_inner_error_ = NULL;
#line 174 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp27_ = _ ("Unable to export background to %s: %s");
#line 174 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp28_ = save_as;
#line 174 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp29_ = g_file_get_path (_tmp28_);
#line 174 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp30_ = _tmp29_;
#line 174 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp31_ = err;
#line 174 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp32_ = _tmp31_->message;
#line 174 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp33_ = g_strdup_printf (_tmp27_, _tmp30_, _tmp32_);
#line 174 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp34_ = _tmp33_;
#line 174 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		app_window_error_message (_tmp34_, NULL);
#line 174 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_free0 (_tmp34_);
#line 174 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_free0 (_tmp30_);
#line 177 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_error_free0 (err);
#line 177 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (save_as);
#line 177 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 1619 "DesktopIntegration.c"
	}
	__finally558:
#line 171 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 171 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (save_as);
#line 171 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 171 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_clear_error (&_inner_error_);
#line 171 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 1632 "DesktopIntegration.c"
	}
#line 180 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp35_ = desktop;
#line 180 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp35_) {
#line 1638 "DesktopIntegration.c"
		ConfigFacade* _tmp36_ = NULL;
		ConfigFacade* _tmp37_ = NULL;
		GFile* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
#line 181 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp36_ = config_facade_get_instance ();
#line 181 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp37_ = _tmp36_;
#line 181 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp38_ = save_as;
#line 181 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp39_ = g_file_get_path (_tmp38_);
#line 181 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp40_ = _tmp39_;
#line 181 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		configuration_facade_set_desktop_background (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp40_);
#line 181 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_free0 (_tmp40_);
#line 181 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (_tmp37_);
#line 1660 "DesktopIntegration.c"
	}
#line 183 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp41_ = screensaver;
#line 183 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp41_) {
#line 1666 "DesktopIntegration.c"
		ConfigFacade* _tmp42_ = NULL;
		ConfigFacade* _tmp43_ = NULL;
		GFile* _tmp44_ = NULL;
		gchar* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
#line 184 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp42_ = config_facade_get_instance ();
#line 184 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp43_ = _tmp42_;
#line 184 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp44_ = save_as;
#line 184 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp45_ = g_file_get_path (_tmp44_);
#line 184 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp46_ = _tmp45_;
#line 184 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		configuration_facade_set_screensaver (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp46_);
#line 184 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_free0 (_tmp46_);
#line 184 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (_tmp43_);
#line 1688 "DesktopIntegration.c"
	}
#line 187 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp47_ = save_as;
#line 187 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp48_ = g_file_get_parse_name (_tmp47_);
#line 187 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp49_ = _tmp48_;
#line 187 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_chmod (_tmp49_, 0644);
#line 187 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp49_);
#line 158 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (save_as);
#line 1702 "DesktopIntegration.c"
}


DesktopIntegrationBackgroundSlideshowXMLBuilder* desktop_integration_background_slideshow_xml_builder_construct (GType object_type, GFile* destination, gdouble duration, gdouble transition) {
	DesktopIntegrationBackgroundSlideshowXMLBuilder* self = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	GFile* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GFile* _tmp12_ = NULL;
#line 202 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_val_if_fail (G_IS_FILE (destination), NULL);
#line 202 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	self = (DesktopIntegrationBackgroundSlideshowXMLBuilder*) g_type_create_instance (object_type);
#line 203 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = destination;
#line 203 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 203 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (self->priv->destination);
#line 203 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	self->priv->destination = _tmp1_;
#line 204 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp2_ = duration;
#line 204 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	self->priv->duration = _tmp2_;
#line 205 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp3_ = transition;
#line 205 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	self->priv->transition = _tmp3_;
#line 207 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp4_ = destination;
#line 207 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp5_ = g_file_get_parent (_tmp4_);
#line 207 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp6_ = _tmp5_;
#line 207 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp7_ = destination;
#line 207 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp8_ = g_file_get_basename (_tmp7_);
#line 207 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp9_ = _tmp8_;
#line 207 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp10_ = g_strconcat (_tmp9_, ".tmp", NULL);
#line 207 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp11_ = _tmp10_;
#line 207 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp12_ = g_file_get_child (_tmp6_, _tmp11_);
#line 207 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (self->priv->tmp_file);
#line 207 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	self->priv->tmp_file = _tmp12_;
#line 207 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp11_);
#line 207 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp9_);
#line 207 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (_tmp6_);
#line 202 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return self;
#line 1771 "DesktopIntegration.c"
}


DesktopIntegrationBackgroundSlideshowXMLBuilder* desktop_integration_background_slideshow_xml_builder_new (GFile* destination, gdouble duration, gdouble transition) {
#line 202 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return desktop_integration_background_slideshow_xml_builder_construct (DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER, destination, duration, transition);
#line 1778 "DesktopIntegration.c"
}


void desktop_integration_background_slideshow_xml_builder_open (DesktopIntegrationBackgroundSlideshowXMLBuilder* self, GError** error) {
	GFileOutputStream* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFileOutputStream* _tmp2_ = NULL;
	GDataOutputStream* _tmp3_ = NULL;
	GDataOutputStream* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 210 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_if_fail (DESKTOP_INTEGRATION_IS_BACKGROUND_SLIDESHOW_XML_BUILDER (self));
#line 211 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1_ = self->priv->tmp_file;
#line 211 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp2_ = g_file_replace (_tmp1_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
#line 211 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = _tmp2_;
#line 211 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 211 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_propagate_error (error, _inner_error_);
#line 211 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 1803 "DesktopIntegration.c"
	}
#line 211 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp3_ = g_data_output_stream_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_output_stream_get_type (), GOutputStream));
#line 211 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (self->priv->outs);
#line 211 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	self->priv->outs = _tmp3_;
#line 212 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp4_ = self->priv->outs;
#line 212 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_data_output_stream_put_string (_tmp4_, "<background>\n", NULL, &_inner_error_);
#line 212 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 212 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_propagate_error (error, _inner_error_);
#line 212 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (_tmp0_);
#line 212 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 1823 "DesktopIntegration.c"
	}
#line 210 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (_tmp0_);
#line 1827 "DesktopIntegration.c"
}


static void desktop_integration_background_slideshow_xml_builder_write_transition (DesktopIntegrationBackgroundSlideshowXMLBuilder* self, GFile* from, GFile* to, GError** error) {
	GDataOutputStream* _tmp0_ = NULL;
	GDataOutputStream* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GDataOutputStream* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GDataOutputStream* _tmp11_ = NULL;
	GFile* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	GDataOutputStream* _tmp17_ = NULL;
	GError * _inner_error_ = NULL;
#line 215 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_if_fail (DESKTOP_INTEGRATION_IS_BACKGROUND_SLIDESHOW_XML_BUILDER (self));
#line 215 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_if_fail (G_IS_FILE (from));
#line 215 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_if_fail (G_IS_FILE (to));
#line 216 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = self->priv->outs;
#line 216 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_data_output_stream_put_string (_tmp0_, "  <transition>\n", NULL, &_inner_error_);
#line 216 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 216 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_propagate_error (error, _inner_error_);
#line 216 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 1867 "DesktopIntegration.c"
	}
#line 217 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1_ = self->priv->outs;
#line 217 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp2_ = self->priv->transition;
#line 217 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp3_ = g_strdup_printf ("    <duration>%2.2f</duration>\n", _tmp2_);
#line 217 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp4_ = _tmp3_;
#line 217 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_data_output_stream_put_string (_tmp1_, _tmp4_, NULL, &_inner_error_);
#line 217 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp4_);
#line 217 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 217 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_propagate_error (error, _inner_error_);
#line 217 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 1887 "DesktopIntegration.c"
	}
#line 218 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp5_ = self->priv->outs;
#line 218 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp6_ = from;
#line 218 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp7_ = g_file_get_path (_tmp6_);
#line 218 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp8_ = _tmp7_;
#line 218 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp9_ = g_strdup_printf ("    <from>%s</from>\n", _tmp8_);
#line 218 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp10_ = _tmp9_;
#line 218 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_data_output_stream_put_string (_tmp5_, _tmp10_, NULL, &_inner_error_);
#line 218 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp10_);
#line 218 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp8_);
#line 218 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 218 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_propagate_error (error, _inner_error_);
#line 218 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 1913 "DesktopIntegration.c"
	}
#line 219 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp11_ = self->priv->outs;
#line 219 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp12_ = to;
#line 219 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp13_ = g_file_get_path (_tmp12_);
#line 219 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp14_ = _tmp13_;
#line 219 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp15_ = g_strdup_printf ("    <to>%s</to>\n", _tmp14_);
#line 219 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp16_ = _tmp15_;
#line 219 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_data_output_stream_put_string (_tmp11_, _tmp16_, NULL, &_inner_error_);
#line 219 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp16_);
#line 219 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp14_);
#line 219 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 219 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_propagate_error (error, _inner_error_);
#line 219 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 1939 "DesktopIntegration.c"
	}
#line 220 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp17_ = self->priv->outs;
#line 220 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_data_output_stream_put_string (_tmp17_, "  </transition>\n", NULL, &_inner_error_);
#line 220 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 220 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_propagate_error (error, _inner_error_);
#line 220 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 1951 "DesktopIntegration.c"
	}
}


static void desktop_integration_background_slideshow_xml_builder_write_static (DesktopIntegrationBackgroundSlideshowXMLBuilder* self, GFile* file, GError** error) {
	GDataOutputStream* _tmp0_ = NULL;
	GDataOutputStream* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GDataOutputStream* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GDataOutputStream* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
#line 223 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_if_fail (DESKTOP_INTEGRATION_IS_BACKGROUND_SLIDESHOW_XML_BUILDER (self));
#line 223 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 224 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = self->priv->outs;
#line 224 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_data_output_stream_put_string (_tmp0_, "  <static>\n", NULL, &_inner_error_);
#line 224 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 224 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_propagate_error (error, _inner_error_);
#line 224 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 1984 "DesktopIntegration.c"
	}
#line 225 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1_ = self->priv->outs;
#line 225 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp2_ = self->priv->duration;
#line 225 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp3_ = g_strdup_printf ("    <duration>%2.2f</duration>\n", _tmp2_);
#line 225 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp4_ = _tmp3_;
#line 225 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_data_output_stream_put_string (_tmp1_, _tmp4_, NULL, &_inner_error_);
#line 225 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp4_);
#line 225 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 225 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_propagate_error (error, _inner_error_);
#line 225 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 2004 "DesktopIntegration.c"
	}
#line 226 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp5_ = self->priv->outs;
#line 226 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp6_ = file;
#line 226 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp7_ = g_file_get_path (_tmp6_);
#line 226 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp8_ = _tmp7_;
#line 226 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp9_ = g_strdup_printf ("    <file>%s</file>\n", _tmp8_);
#line 226 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp10_ = _tmp9_;
#line 226 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_data_output_stream_put_string (_tmp5_, _tmp10_, NULL, &_inner_error_);
#line 226 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp10_);
#line 226 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp8_);
#line 226 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 226 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_propagate_error (error, _inner_error_);
#line 226 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 2030 "DesktopIntegration.c"
	}
#line 227 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp11_ = self->priv->outs;
#line 227 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_data_output_stream_put_string (_tmp11_, "  </static>\n", NULL, &_inner_error_);
#line 227 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 227 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_propagate_error (error, _inner_error_);
#line 227 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 2042 "DesktopIntegration.c"
	}
}


void desktop_integration_background_slideshow_xml_builder_add_photo (DesktopIntegrationBackgroundSlideshowXMLBuilder* self, GFile* file, GError** error) {
	GDataOutputStream* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp4_ = NULL;
	GFile* _tmp7_ = NULL;
	GFile* _tmp8_ = NULL;
	GFile* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
#line 230 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_if_fail (DESKTOP_INTEGRATION_IS_BACKGROUND_SLIDESHOW_XML_BUILDER (self));
#line 230 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 231 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = self->priv->outs;
#line 231 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_vala_assert (_tmp0_ != NULL, "outs != null");
#line 233 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1_ = self->priv->first_file;
#line 233 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp1_ == NULL) {
#line 2067 "DesktopIntegration.c"
		GFile* _tmp2_ = NULL;
		GFile* _tmp3_ = NULL;
#line 234 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp2_ = file;
#line 234 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp3_ = _g_object_ref0 (_tmp2_);
#line 234 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (self->priv->first_file);
#line 234 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		self->priv->first_file = _tmp3_;
#line 2078 "DesktopIntegration.c"
	}
#line 236 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp4_ = self->priv->last_file;
#line 236 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp4_ != NULL) {
#line 2084 "DesktopIntegration.c"
		GFile* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
#line 237 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp5_ = self->priv->last_file;
#line 237 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp6_ = file;
#line 237 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		desktop_integration_background_slideshow_xml_builder_write_transition (self, _tmp5_, _tmp6_, &_inner_error_);
#line 237 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 237 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			g_propagate_error (error, _inner_error_);
#line 237 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			return;
#line 2099 "DesktopIntegration.c"
		}
	}
#line 239 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp7_ = file;
#line 239 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	desktop_integration_background_slideshow_xml_builder_write_static (self, _tmp7_, &_inner_error_);
#line 239 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 239 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_propagate_error (error, _inner_error_);
#line 239 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 2112 "DesktopIntegration.c"
	}
#line 241 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp8_ = file;
#line 241 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 241 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (self->priv->last_file);
#line 241 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	self->priv->last_file = _tmp9_;
#line 2122 "DesktopIntegration.c"
}


GFile* desktop_integration_background_slideshow_xml_builder_close (DesktopIntegrationBackgroundSlideshowXMLBuilder* self, GError** error) {
	GFile* result = NULL;
	GDataOutputStream* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GFile* _tmp2_ = NULL;
	GDataOutputStream* _tmp6_ = NULL;
	GDataOutputStream* _tmp7_ = NULL;
	GFile* _tmp8_ = NULL;
	GFile* _tmp9_ = NULL;
	GFile* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	GFile* _tmp13_ = NULL;
	GFile* _tmp14_ = NULL;
	GError * _inner_error_ = NULL;
#line 244 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_val_if_fail (DESKTOP_INTEGRATION_IS_BACKGROUND_SLIDESHOW_XML_BUILDER (self), NULL);
#line 245 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = self->priv->outs;
#line 245 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp0_ == NULL) {
#line 246 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		result = NULL;
#line 246 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return result;
#line 2151 "DesktopIntegration.c"
	}
#line 249 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp2_ = self->priv->first_file;
#line 249 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp2_ != NULL) {
#line 2157 "DesktopIntegration.c"
		GFile* _tmp3_ = NULL;
#line 249 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp3_ = self->priv->last_file;
#line 249 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp1_ = _tmp3_ != NULL;
#line 2163 "DesktopIntegration.c"
	} else {
#line 249 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp1_ = FALSE;
#line 2167 "DesktopIntegration.c"
	}
#line 249 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp1_) {
#line 2171 "DesktopIntegration.c"
		GFile* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
#line 250 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp4_ = self->priv->last_file;
#line 250 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp5_ = self->priv->first_file;
#line 250 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		desktop_integration_background_slideshow_xml_builder_write_transition (self, _tmp4_, _tmp5_, &_inner_error_);
#line 250 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 250 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			g_propagate_error (error, _inner_error_);
#line 250 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			return NULL;
#line 2186 "DesktopIntegration.c"
		}
	}
#line 252 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp6_ = self->priv->outs;
#line 252 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_data_output_stream_put_string (_tmp6_, "</background>\n", NULL, &_inner_error_);
#line 252 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 252 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_propagate_error (error, _inner_error_);
#line 252 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return NULL;
#line 2199 "DesktopIntegration.c"
	}
#line 254 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp7_ = self->priv->outs;
#line 254 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_output_stream_close (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_output_stream_get_type (), GOutputStream), NULL, &_inner_error_);
#line 254 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 254 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_propagate_error (error, _inner_error_);
#line 254 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return NULL;
#line 2211 "DesktopIntegration.c"
	}
#line 255 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (self->priv->outs);
#line 255 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	self->priv->outs = NULL;
#line 258 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp8_ = self->priv->tmp_file;
#line 258 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp9_ = self->priv->destination;
#line 258 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_file_move (_tmp8_, _tmp9_, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error_);
#line 258 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 258 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_propagate_error (error, _inner_error_);
#line 258 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return NULL;
#line 2229 "DesktopIntegration.c"
	}
#line 259 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp10_ = self->priv->destination;
#line 259 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp11_ = g_file_get_parse_name (_tmp10_);
#line 259 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp12_ = _tmp11_;
#line 259 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_chmod (_tmp12_, 0644);
#line 259 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp12_);
#line 261 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp13_ = self->priv->destination;
#line 261 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp14_ = _g_object_ref0 (_tmp13_);
#line 261 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	result = _tmp14_;
#line 261 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return result;
#line 2249 "DesktopIntegration.c"
}


static void desktop_integration_value_background_slideshow_xml_builder_init (GValue* value) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	value->data[0].v_pointer = NULL;
#line 2256 "DesktopIntegration.c"
}


static void desktop_integration_value_background_slideshow_xml_builder_free_value (GValue* value) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (value->data[0].v_pointer) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		desktop_integration_background_slideshow_xml_builder_unref (value->data[0].v_pointer);
#line 2265 "DesktopIntegration.c"
	}
}


static void desktop_integration_value_background_slideshow_xml_builder_copy_value (const GValue* src_value, GValue* dest_value) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (src_value->data[0].v_pointer) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		dest_value->data[0].v_pointer = desktop_integration_background_slideshow_xml_builder_ref (src_value->data[0].v_pointer);
#line 2275 "DesktopIntegration.c"
	} else {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2279 "DesktopIntegration.c"
	}
}


static gpointer desktop_integration_value_background_slideshow_xml_builder_peek_pointer (const GValue* value) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return value->data[0].v_pointer;
#line 2287 "DesktopIntegration.c"
}


static gchar* desktop_integration_value_background_slideshow_xml_builder_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (collect_values[0].v_pointer) {
#line 2294 "DesktopIntegration.c"
		DesktopIntegrationBackgroundSlideshowXMLBuilder* object;
		object = collect_values[0].v_pointer;
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		if (object->parent_instance.g_class == NULL) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2301 "DesktopIntegration.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2305 "DesktopIntegration.c"
		}
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		value->data[0].v_pointer = desktop_integration_background_slideshow_xml_builder_ref (object);
#line 2309 "DesktopIntegration.c"
	} else {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		value->data[0].v_pointer = NULL;
#line 2313 "DesktopIntegration.c"
	}
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return NULL;
#line 2317 "DesktopIntegration.c"
}


static gchar* desktop_integration_value_background_slideshow_xml_builder_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DesktopIntegrationBackgroundSlideshowXMLBuilder** object_p;
	object_p = collect_values[0].v_pointer;
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (!object_p) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2328 "DesktopIntegration.c"
	}
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (!value->data[0].v_pointer) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		*object_p = NULL;
#line 2334 "DesktopIntegration.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		*object_p = value->data[0].v_pointer;
#line 2338 "DesktopIntegration.c"
	} else {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		*object_p = desktop_integration_background_slideshow_xml_builder_ref (value->data[0].v_pointer);
#line 2342 "DesktopIntegration.c"
	}
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return NULL;
#line 2346 "DesktopIntegration.c"
}


GParamSpec* desktop_integration_param_spec_background_slideshow_xml_builder (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	DesktopIntegrationParamSpecBackgroundSlideshowXMLBuilder* spec;
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_val_if_fail (g_type_is_a (object_type, DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER), NULL);
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return G_PARAM_SPEC (spec);
#line 2360 "DesktopIntegration.c"
}


gpointer desktop_integration_value_get_background_slideshow_xml_builder (const GValue* value) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER), NULL);
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return value->data[0].v_pointer;
#line 2369 "DesktopIntegration.c"
}


void desktop_integration_value_set_background_slideshow_xml_builder (GValue* value, gpointer v_object) {
	DesktopIntegrationBackgroundSlideshowXMLBuilder* old;
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER));
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	old = value->data[0].v_pointer;
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (v_object) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER));
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		value->data[0].v_pointer = v_object;
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		desktop_integration_background_slideshow_xml_builder_ref (value->data[0].v_pointer);
#line 2389 "DesktopIntegration.c"
	} else {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		value->data[0].v_pointer = NULL;
#line 2393 "DesktopIntegration.c"
	}
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (old) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		desktop_integration_background_slideshow_xml_builder_unref (old);
#line 2399 "DesktopIntegration.c"
	}
}


void desktop_integration_value_take_background_slideshow_xml_builder (GValue* value, gpointer v_object) {
	DesktopIntegrationBackgroundSlideshowXMLBuilder* old;
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER));
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	old = value->data[0].v_pointer;
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (v_object) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER));
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		value->data[0].v_pointer = v_object;
#line 2418 "DesktopIntegration.c"
	} else {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		value->data[0].v_pointer = NULL;
#line 2422 "DesktopIntegration.c"
	}
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (old) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		desktop_integration_background_slideshow_xml_builder_unref (old);
#line 2428 "DesktopIntegration.c"
	}
}


static void desktop_integration_background_slideshow_xml_builder_class_init (DesktopIntegrationBackgroundSlideshowXMLBuilderClass * klass) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	desktop_integration_background_slideshow_xml_builder_parent_class = g_type_class_peek_parent (klass);
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	((DesktopIntegrationBackgroundSlideshowXMLBuilderClass *) klass)->finalize = desktop_integration_background_slideshow_xml_builder_finalize;
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_type_class_add_private (klass, sizeof (DesktopIntegrationBackgroundSlideshowXMLBuilderPrivate));
#line 2440 "DesktopIntegration.c"
}


static void desktop_integration_background_slideshow_xml_builder_instance_init (DesktopIntegrationBackgroundSlideshowXMLBuilder * self) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	self->priv = DESKTOP_INTEGRATION_BACKGROUND_SLIDESHOW_XML_BUILDER_GET_PRIVATE (self);
#line 198 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	self->priv->outs = NULL;
#line 199 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	self->priv->first_file = NULL;
#line 200 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	self->priv->last_file = NULL;
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	self->ref_count = 1;
#line 2455 "DesktopIntegration.c"
}


static void desktop_integration_background_slideshow_xml_builder_finalize (DesktopIntegrationBackgroundSlideshowXMLBuilder* obj) {
	DesktopIntegrationBackgroundSlideshowXMLBuilder * self;
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER, DesktopIntegrationBackgroundSlideshowXMLBuilder);
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_signal_handlers_destroy (self);
#line 194 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (self->priv->destination);
#line 197 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (self->priv->tmp_file);
#line 198 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (self->priv->outs);
#line 199 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (self->priv->first_file);
#line 200 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (self->priv->last_file);
#line 2475 "DesktopIntegration.c"
}


GType desktop_integration_background_slideshow_xml_builder_get_type (void) {
	static volatile gsize desktop_integration_background_slideshow_xml_builder_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_integration_background_slideshow_xml_builder_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { desktop_integration_value_background_slideshow_xml_builder_init, desktop_integration_value_background_slideshow_xml_builder_free_value, desktop_integration_value_background_slideshow_xml_builder_copy_value, desktop_integration_value_background_slideshow_xml_builder_peek_pointer, "p", desktop_integration_value_background_slideshow_xml_builder_collect_value, "p", desktop_integration_value_background_slideshow_xml_builder_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DesktopIntegrationBackgroundSlideshowXMLBuilderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_integration_background_slideshow_xml_builder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopIntegrationBackgroundSlideshowXMLBuilder), 0, (GInstanceInitFunc) desktop_integration_background_slideshow_xml_builder_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType desktop_integration_background_slideshow_xml_builder_type_id;
		desktop_integration_background_slideshow_xml_builder_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DesktopIntegrationBackgroundSlideshowXMLBuilder", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&desktop_integration_background_slideshow_xml_builder_type_id__volatile, desktop_integration_background_slideshow_xml_builder_type_id);
	}
	return desktop_integration_background_slideshow_xml_builder_type_id__volatile;
}


gpointer desktop_integration_background_slideshow_xml_builder_ref (gpointer instance) {
	DesktopIntegrationBackgroundSlideshowXMLBuilder* self;
	self = instance;
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_atomic_int_inc (&self->ref_count);
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return instance;
#line 2500 "DesktopIntegration.c"
}


void desktop_integration_background_slideshow_xml_builder_unref (gpointer instance) {
	DesktopIntegrationBackgroundSlideshowXMLBuilder* self;
	self = instance;
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		DESKTOP_INTEGRATION_BACKGROUND_SLIDESHOW_XML_BUILDER_GET_CLASS (self)->finalize (self);
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2513 "DesktopIntegration.c"
	}
}


static void _desktop_integration_on_desktop_slideshow_exported_exporter_completion_callback (Exporter* exporter, gboolean is_cancelled, gpointer self) {
#line 290 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	desktop_integration_on_desktop_slideshow_exported (exporter, is_cancelled);
#line 2521 "DesktopIntegration.c"
}


void desktop_integration_set_background_slideshow (GeeCollection* photos, gdouble duration, gdouble transition, gboolean desktop_background, gboolean screensaver) {
	ExporterUI* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GFile* wallpaper_dir = NULL;
	GFile* _tmp3_ = NULL;
	GeeSet* exceptions = NULL;
	GeeHashSet* _tmp4_ = NULL;
	GeeSet* _tmp5_ = NULL;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	Exporter* exporter = NULL;
	GeeCollection* _tmp12_ = NULL;
	GFile* _tmp13_ = NULL;
	AppWindow* _tmp14_ = NULL;
	AppWindow* _tmp15_ = NULL;
	Scaling _tmp16_ = {0};
	ExportFormatParameters _tmp17_ = {0};
	Exporter* _tmp18_ = NULL;
	Exporter* _tmp19_ = NULL;
	Exporter* _tmp20_ = NULL;
	ExporterUI* _tmp21_ = NULL;
	ExporterUI* _tmp22_ = NULL;
	GError * _inner_error_ = NULL;
#line 265 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_if_fail (GEE_IS_COLLECTION (photos));
#line 267 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = desktop_integration_desktop_slideshow_exporter;
#line 267 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp0_ != NULL) {
#line 268 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 2557 "DesktopIntegration.c"
	}
#line 270 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1_ = desktop_background;
#line 270 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	desktop_integration_set_desktop_background = _tmp1_;
#line 271 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp2_ = screensaver;
#line 271 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	desktop_integration_set_screensaver = _tmp2_;
#line 273 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp3_ = app_dirs_get_data_subdir ("wallpaper", NULL);
#line 273 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	wallpaper_dir = _tmp3_;
#line 275 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp4_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 275 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	exceptions = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_SET, GeeSet);
#line 276 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp5_ = exceptions;
#line 276 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection), DESKTOP_INTEGRATION_DESKTOP_SLIDESHOW_XML_FILENAME);
#line 2579 "DesktopIntegration.c"
	{
		GFile* _tmp6_ = NULL;
		GeeSet* _tmp7_ = NULL;
#line 278 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp6_ = wallpaper_dir;
#line 278 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp7_ = exceptions;
#line 278 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		delete_all_files (_tmp6_, _tmp7_, NULL, NULL, (guint64) 0, NULL, &_inner_error_);
#line 278 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2591 "DesktopIntegration.c"
			goto __catch559_g_error;
		}
	}
	goto __finally559;
	__catch559_g_error:
	{
		GError* err = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 277 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		err = _inner_error_;
#line 277 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_inner_error_ = NULL;
#line 280 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp8_ = err;
#line 280 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp9_ = _tmp8_->message;
#line 280 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_warning ("DesktopIntegration.vala:280: Error attempting to clear wallpaper direc" \
"tory: %s", _tmp9_);
#line 277 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_error_free0 (err);
#line 2613 "DesktopIntegration.c"
	}
	__finally559:
#line 277 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 277 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (exceptions);
#line 277 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (wallpaper_dir);
#line 277 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 277 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_clear_error (&_inner_error_);
#line 277 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 2628 "DesktopIntegration.c"
	}
#line 283 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp10_ = duration;
#line 283 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	desktop_integration_desktop_slideshow_duration = _tmp10_;
#line 284 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp11_ = transition;
#line 284 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	desktop_integration_desktop_slideshow_transition = _tmp11_;
#line 286 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp12_ = photos;
#line 286 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp13_ = wallpaper_dir;
#line 286 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp14_ = app_window_get_instance ();
#line 286 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp15_ = _tmp14_;
#line 286 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	scaling_to_fill_screen (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_window_get_type (), GtkWindow), &_tmp16_);
#line 286 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	export_format_parameters_current (&_tmp17_);
#line 286 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp18_ = exporter_new (_tmp12_, _tmp13_, &_tmp16_, &_tmp17_, TRUE);
#line 286 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp19_ = _tmp18_;
#line 286 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (_tmp15_);
#line 286 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	exporter = _tmp19_;
#line 289 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp20_ = exporter;
#line 289 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp21_ = exporter_ui_new (_tmp20_);
#line 289 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_exporter_ui_unref0 (desktop_integration_desktop_slideshow_exporter);
#line 289 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	desktop_integration_desktop_slideshow_exporter = _tmp21_;
#line 290 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp22_ = desktop_integration_desktop_slideshow_exporter;
#line 290 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	exporter_ui_export (_tmp22_, _desktop_integration_on_desktop_slideshow_exported_exporter_completion_callback, NULL);
#line 265 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (exporter);
#line 265 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (exceptions);
#line 265 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (wallpaper_dir);
#line 2676 "DesktopIntegration.c"
}


void desktop_integration_on_desktop_slideshow_exported (Exporter* exporter, gboolean is_cancelled) {
	gboolean _tmp0_ = FALSE;
	GFile* xml_file = NULL;
	DesktopIntegrationBackgroundSlideshowXMLBuilder* xml_builder = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	DesktopIntegrationBackgroundSlideshowXMLBuilder* _tmp7_ = NULL;
	DesktopIntegrationBackgroundSlideshowXMLBuilder* _tmp8_ = NULL;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp31_ = FALSE;
	GError * _inner_error_ = NULL;
#line 293 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_if_fail (IS_EXPORTER (exporter));
#line 294 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_exporter_ui_unref0 (desktop_integration_desktop_slideshow_exporter);
#line 294 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	desktop_integration_desktop_slideshow_exporter = NULL;
#line 296 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = is_cancelled;
#line 296 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp0_) {
#line 297 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 2707 "DesktopIntegration.c"
	}
#line 299 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	xml_file = NULL;
#line 300 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1_ = app_dirs_get_data_subdir ("wallpaper", NULL);
#line 300 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp2_ = _tmp1_;
#line 300 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp3_ = g_file_get_child (_tmp2_, DESKTOP_INTEGRATION_DESKTOP_SLIDESHOW_XML_FILENAME);
#line 300 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp4_ = _tmp3_;
#line 300 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp5_ = desktop_integration_desktop_slideshow_duration;
#line 300 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp6_ = desktop_integration_desktop_slideshow_transition;
#line 300 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp7_ = desktop_integration_background_slideshow_xml_builder_new (_tmp4_, _tmp5_, _tmp6_);
#line 300 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp8_ = _tmp7_;
#line 300 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (_tmp4_);
#line 300 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (_tmp2_);
#line 300 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	xml_builder = _tmp8_;
#line 2733 "DesktopIntegration.c"
	{
		DesktopIntegrationBackgroundSlideshowXMLBuilder* _tmp9_ = NULL;
		Exporter* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		GFile** _tmp12_ = NULL;
		GFile* _tmp16_ = NULL;
		DesktopIntegrationBackgroundSlideshowXMLBuilder* _tmp17_ = NULL;
		GFile* _tmp18_ = NULL;
		GFile* _tmp19_ = NULL;
#line 304 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp9_ = xml_builder;
#line 304 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		desktop_integration_background_slideshow_xml_builder_open (_tmp9_, &_inner_error_);
#line 304 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2749 "DesktopIntegration.c"
			goto __catch560_g_error;
		}
#line 306 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp10_ = exporter;
#line 306 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp12_ = exporter_get_exported_files (_tmp10_, &_tmp11_);
#line 2756 "DesktopIntegration.c"
		{
			GFile** file_collection = NULL;
			gint file_collection_length1 = 0;
			gint _file_collection_size_ = 0;
			gint file_it = 0;
#line 306 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			file_collection = _tmp12_;
#line 306 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			file_collection_length1 = _tmp11_;
#line 306 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			for (file_it = 0; file_it < _tmp11_; file_it = file_it + 1) {
#line 2768 "DesktopIntegration.c"
				GFile* _tmp13_ = NULL;
				GFile* file = NULL;
#line 306 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp13_ = _g_object_ref0 (file_collection[file_it]);
#line 306 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				file = _tmp13_;
#line 2775 "DesktopIntegration.c"
				{
					DesktopIntegrationBackgroundSlideshowXMLBuilder* _tmp14_ = NULL;
					GFile* _tmp15_ = NULL;
#line 307 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					_tmp14_ = xml_builder;
#line 307 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					_tmp15_ = file;
#line 307 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					desktop_integration_background_slideshow_xml_builder_add_photo (_tmp14_, _tmp15_, &_inner_error_);
#line 307 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 307 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
						_g_object_unref0 (file);
#line 307 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
						file_collection = (_vala_array_free (file_collection, file_collection_length1, (GDestroyNotify) g_object_unref), NULL);
#line 2791 "DesktopIntegration.c"
						goto __catch560_g_error;
					}
#line 306 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					_g_object_unref0 (file);
#line 2796 "DesktopIntegration.c"
				}
			}
#line 306 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			file_collection = (_vala_array_free (file_collection, file_collection_length1, (GDestroyNotify) g_object_unref), NULL);
#line 2801 "DesktopIntegration.c"
		}
#line 309 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp17_ = xml_builder;
#line 309 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp18_ = desktop_integration_background_slideshow_xml_builder_close (_tmp17_, &_inner_error_);
#line 309 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp16_ = _tmp18_;
#line 309 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2811 "DesktopIntegration.c"
			goto __catch560_g_error;
		}
#line 309 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp19_ = _tmp16_;
#line 309 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp16_ = NULL;
#line 309 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (xml_file);
#line 309 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		xml_file = _tmp19_;
#line 303 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (_tmp16_);
#line 2824 "DesktopIntegration.c"
	}
	goto __finally560;
	__catch560_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp20_ = NULL;
		GError* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
#line 303 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		err = _inner_error_;
#line 303 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_inner_error_ = NULL;
#line 311 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp20_ = _ ("Unable to prepare desktop slideshow: %s");
#line 311 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp21_ = err;
#line 311 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp22_ = _tmp21_->message;
#line 311 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp23_ = g_strdup_printf (_tmp20_, _tmp22_);
#line 311 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp24_ = _tmp23_;
#line 311 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		app_window_error_message (_tmp24_, NULL);
#line 311 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_free0 (_tmp24_);
#line 314 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_error_free0 (err);
#line 314 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_desktop_integration_background_slideshow_xml_builder_unref0 (xml_builder);
#line 314 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (xml_file);
#line 314 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 2861 "DesktopIntegration.c"
	}
	__finally560:
#line 303 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 303 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_desktop_integration_background_slideshow_xml_builder_unref0 (xml_builder);
#line 303 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (xml_file);
#line 303 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 303 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_clear_error (&_inner_error_);
#line 303 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 2876 "DesktopIntegration.c"
	}
#line 317 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp25_ = desktop_integration_set_desktop_background;
#line 317 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp25_) {
#line 2882 "DesktopIntegration.c"
		ConfigFacade* _tmp26_ = NULL;
		ConfigFacade* _tmp27_ = NULL;
		GFile* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
#line 318 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp26_ = config_facade_get_instance ();
#line 318 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp27_ = _tmp26_;
#line 318 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp28_ = xml_file;
#line 318 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp29_ = g_file_get_path (_tmp28_);
#line 318 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp30_ = _tmp29_;
#line 318 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		configuration_facade_set_desktop_background (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp30_);
#line 318 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_free0 (_tmp30_);
#line 318 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (_tmp27_);
#line 2904 "DesktopIntegration.c"
	}
#line 320 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp31_ = desktop_integration_set_screensaver;
#line 320 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp31_) {
#line 2910 "DesktopIntegration.c"
		ConfigFacade* _tmp32_ = NULL;
		ConfigFacade* _tmp33_ = NULL;
		GFile* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
#line 321 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp32_ = config_facade_get_instance ();
#line 321 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp33_ = _tmp32_;
#line 321 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp34_ = xml_file;
#line 321 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp35_ = g_file_get_path (_tmp34_);
#line 321 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp36_ = _tmp35_;
#line 321 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		configuration_facade_set_screensaver (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp36_);
#line 321 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_free0 (_tmp36_);
#line 321 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (_tmp33_);
#line 2932 "DesktopIntegration.c"
	}
#line 293 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_desktop_integration_background_slideshow_xml_builder_unref0 (xml_builder);
#line 293 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (xml_file);
#line 2938 "DesktopIntegration.c"
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



