/* Semaphore.c generated by valac 0.32.1, the Vala compiler
 * generated from Semaphore.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/* Semaphores may be used to be notified when a job is completed.  This provides an alternate*/
/* mechanism (essentially, a blocking mechanism) to the system of callbacks that BackgroundJob*/
/* offers.  They can also be used for other job-dependent notification mechanisms.*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define TYPE_ABSTRACT_SEMAPHORE (abstract_semaphore_get_type ())
#define ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore))
#define ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))
#define IS_ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ABSTRACT_SEMAPHORE))
#define IS_ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ABSTRACT_SEMAPHORE))
#define ABSTRACT_SEMAPHORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))

typedef struct _AbstractSemaphore AbstractSemaphore;
typedef struct _AbstractSemaphoreClass AbstractSemaphoreClass;
typedef struct _AbstractSemaphorePrivate AbstractSemaphorePrivate;

#define ABSTRACT_SEMAPHORE_TYPE_NOTIFY_ACTION (abstract_semaphore_notify_action_get_type ())

#define ABSTRACT_SEMAPHORE_TYPE_WAIT_ACTION (abstract_semaphore_wait_action_get_type ())

#define ABSTRACT_SEMAPHORE_TYPE_TYPE (abstract_semaphore_type_get_type ())
typedef struct _ParamSpecAbstractSemaphore ParamSpecAbstractSemaphore;

#define TYPE_SEMAPHORE (semaphore_get_type ())
#define SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEMAPHORE, Semaphore))
#define SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEMAPHORE, SemaphoreClass))
#define IS_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEMAPHORE))
#define IS_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEMAPHORE))
#define SEMAPHORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEMAPHORE, SemaphoreClass))

typedef struct _Semaphore Semaphore;
typedef struct _SemaphoreClass SemaphoreClass;
typedef struct _SemaphorePrivate SemaphorePrivate;

#define TYPE_COUNTDOWN_SEMAPHORE (countdown_semaphore_get_type ())
#define COUNTDOWN_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COUNTDOWN_SEMAPHORE, CountdownSemaphore))
#define COUNTDOWN_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COUNTDOWN_SEMAPHORE, CountdownSemaphoreClass))
#define IS_COUNTDOWN_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COUNTDOWN_SEMAPHORE))
#define IS_COUNTDOWN_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COUNTDOWN_SEMAPHORE))
#define COUNTDOWN_SEMAPHORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COUNTDOWN_SEMAPHORE, CountdownSemaphoreClass))

typedef struct _CountdownSemaphore CountdownSemaphore;
typedef struct _CountdownSemaphoreClass CountdownSemaphoreClass;
typedef struct _CountdownSemaphorePrivate CountdownSemaphorePrivate;

#define TYPE_EVENT_SEMAPHORE (event_semaphore_get_type ())
#define EVENT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_SEMAPHORE, EventSemaphore))
#define EVENT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_SEMAPHORE, EventSemaphoreClass))
#define IS_EVENT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_SEMAPHORE))
#define IS_EVENT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_SEMAPHORE))
#define EVENT_SEMAPHORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_SEMAPHORE, EventSemaphoreClass))

typedef struct _EventSemaphore EventSemaphore;
typedef struct _EventSemaphoreClass EventSemaphoreClass;
typedef struct _EventSemaphorePrivate EventSemaphorePrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	ABSTRACT_SEMAPHORE_NOTIFY_ACTION_NONE,
	ABSTRACT_SEMAPHORE_NOTIFY_ACTION_SIGNAL
} AbstractSemaphoreNotifyAction;

typedef enum  {
	ABSTRACT_SEMAPHORE_WAIT_ACTION_SLEEP,
	ABSTRACT_SEMAPHORE_WAIT_ACTION_READY
} AbstractSemaphoreWaitAction;

struct _AbstractSemaphore {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AbstractSemaphorePrivate * priv;
};

struct _AbstractSemaphoreClass {
	GTypeClass parent_class;
	void (*finalize) (AbstractSemaphore *self);
	AbstractSemaphoreNotifyAction (*do_notify) (AbstractSemaphore* self);
	AbstractSemaphoreWaitAction (*do_wait) (AbstractSemaphore* self);
	gboolean (*do_reset) (AbstractSemaphore* self);
};

typedef enum  {
	ABSTRACT_SEMAPHORE_TYPE_SERIAL,
	ABSTRACT_SEMAPHORE_TYPE_BROADCAST
} AbstractSemaphoreType;

struct _AbstractSemaphorePrivate {
	AbstractSemaphoreType type;
	GMutex mutex;
	GCond monitor;
};

struct _ParamSpecAbstractSemaphore {
	GParamSpec parent_instance;
};

struct _Semaphore {
	AbstractSemaphore parent_instance;
	SemaphorePrivate * priv;
};

struct _SemaphoreClass {
	AbstractSemaphoreClass parent_class;
};

struct _SemaphorePrivate {
	gboolean passed;
};

struct _CountdownSemaphore {
	AbstractSemaphore parent_instance;
	CountdownSemaphorePrivate * priv;
};

struct _CountdownSemaphoreClass {
	AbstractSemaphoreClass parent_class;
};

struct _CountdownSemaphorePrivate {
	gint total;
	gint passed;
};

struct _EventSemaphore {
	AbstractSemaphore parent_instance;
	EventSemaphorePrivate * priv;
};

struct _EventSemaphoreClass {
	AbstractSemaphoreClass parent_class;
};

struct _EventSemaphorePrivate {
	gboolean fired;
};


static gpointer abstract_semaphore_parent_class = NULL;
static gpointer semaphore_parent_class = NULL;
static gpointer countdown_semaphore_parent_class = NULL;
static gpointer event_semaphore_parent_class = NULL;

gpointer abstract_semaphore_ref (gpointer instance);
void abstract_semaphore_unref (gpointer instance);
GParamSpec* param_spec_abstract_semaphore (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_abstract_semaphore (GValue* value, gpointer v_object);
void value_take_abstract_semaphore (GValue* value, gpointer v_object);
gpointer value_get_abstract_semaphore (const GValue* value);
GType abstract_semaphore_get_type (void) G_GNUC_CONST;
GType abstract_semaphore_notify_action_get_type (void) G_GNUC_CONST;
GType abstract_semaphore_wait_action_get_type (void) G_GNUC_CONST;
GType abstract_semaphore_type_get_type (void) G_GNUC_CONST;
#define ABSTRACT_SEMAPHORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphorePrivate))
enum  {
	ABSTRACT_SEMAPHORE_DUMMY_PROPERTY
};
AbstractSemaphore* abstract_semaphore_construct (GType object_type, AbstractSemaphoreType type);
static void abstract_semaphore_trigger (AbstractSemaphore* self);
void abstract_semaphore_notify (AbstractSemaphore* self);
AbstractSemaphoreNotifyAction abstract_semaphore_do_notify (AbstractSemaphore* self);
const gchar* abstract_semaphore_notify_action_to_string (AbstractSemaphoreNotifyAction self);
static AbstractSemaphoreNotifyAction abstract_semaphore_real_do_notify (AbstractSemaphore* self);
void abstract_semaphore_wait (AbstractSemaphore* self);
AbstractSemaphoreWaitAction abstract_semaphore_do_wait (AbstractSemaphore* self);
static AbstractSemaphoreWaitAction abstract_semaphore_real_do_wait (AbstractSemaphore* self);
gboolean abstract_semaphore_reset (AbstractSemaphore* self);
gboolean abstract_semaphore_do_reset (AbstractSemaphore* self);
static gboolean abstract_semaphore_real_do_reset (AbstractSemaphore* self);
static void abstract_semaphore_finalize (AbstractSemaphore* obj);
GType semaphore_get_type (void) G_GNUC_CONST;
#define SEMAPHORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SEMAPHORE, SemaphorePrivate))
enum  {
	SEMAPHORE_DUMMY_PROPERTY
};
Semaphore* semaphore_new (void);
Semaphore* semaphore_construct (GType object_type);
static AbstractSemaphoreNotifyAction semaphore_real_do_notify (AbstractSemaphore* base);
static AbstractSemaphoreWaitAction semaphore_real_do_wait (AbstractSemaphore* base);
static void semaphore_finalize (AbstractSemaphore* obj);
GType countdown_semaphore_get_type (void) G_GNUC_CONST;
#define COUNTDOWN_SEMAPHORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_COUNTDOWN_SEMAPHORE, CountdownSemaphorePrivate))
enum  {
	COUNTDOWN_SEMAPHORE_DUMMY_PROPERTY
};
CountdownSemaphore* countdown_semaphore_new (gint total);
CountdownSemaphore* countdown_semaphore_construct (GType object_type, gint total);
static AbstractSemaphoreNotifyAction countdown_semaphore_real_do_notify (AbstractSemaphore* base);
static AbstractSemaphoreWaitAction countdown_semaphore_real_do_wait (AbstractSemaphore* base);
static void countdown_semaphore_finalize (AbstractSemaphore* obj);
GType event_semaphore_get_type (void) G_GNUC_CONST;
#define EVENT_SEMAPHORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_EVENT_SEMAPHORE, EventSemaphorePrivate))
enum  {
	EVENT_SEMAPHORE_DUMMY_PROPERTY
};
EventSemaphore* event_semaphore_new (void);
EventSemaphore* event_semaphore_construct (GType object_type);
static AbstractSemaphoreNotifyAction event_semaphore_real_do_notify (AbstractSemaphore* base);
static AbstractSemaphoreWaitAction event_semaphore_real_do_wait (AbstractSemaphore* base);
static gboolean event_semaphore_real_do_reset (AbstractSemaphore* base);
static void event_semaphore_finalize (AbstractSemaphore* obj);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);


GType abstract_semaphore_type_get_type (void) {
	static volatile gsize abstract_semaphore_type_type_id__volatile = 0;
	if (g_once_init_enter (&abstract_semaphore_type_type_id__volatile)) {
		static const GEnumValue values[] = {{ABSTRACT_SEMAPHORE_TYPE_SERIAL, "ABSTRACT_SEMAPHORE_TYPE_SERIAL", "serial"}, {ABSTRACT_SEMAPHORE_TYPE_BROADCAST, "ABSTRACT_SEMAPHORE_TYPE_BROADCAST", "broadcast"}, {0, NULL, NULL}};
		GType abstract_semaphore_type_type_id;
		abstract_semaphore_type_type_id = g_enum_register_static ("AbstractSemaphoreType", values);
		g_once_init_leave (&abstract_semaphore_type_type_id__volatile, abstract_semaphore_type_type_id);
	}
	return abstract_semaphore_type_type_id__volatile;
}


GType abstract_semaphore_notify_action_get_type (void) {
	static volatile gsize abstract_semaphore_notify_action_type_id__volatile = 0;
	if (g_once_init_enter (&abstract_semaphore_notify_action_type_id__volatile)) {
		static const GEnumValue values[] = {{ABSTRACT_SEMAPHORE_NOTIFY_ACTION_NONE, "ABSTRACT_SEMAPHORE_NOTIFY_ACTION_NONE", "none"}, {ABSTRACT_SEMAPHORE_NOTIFY_ACTION_SIGNAL, "ABSTRACT_SEMAPHORE_NOTIFY_ACTION_SIGNAL", "signal"}, {0, NULL, NULL}};
		GType abstract_semaphore_notify_action_type_id;
		abstract_semaphore_notify_action_type_id = g_enum_register_static ("AbstractSemaphoreNotifyAction", values);
		g_once_init_leave (&abstract_semaphore_notify_action_type_id__volatile, abstract_semaphore_notify_action_type_id);
	}
	return abstract_semaphore_notify_action_type_id__volatile;
}


GType abstract_semaphore_wait_action_get_type (void) {
	static volatile gsize abstract_semaphore_wait_action_type_id__volatile = 0;
	if (g_once_init_enter (&abstract_semaphore_wait_action_type_id__volatile)) {
		static const GEnumValue values[] = {{ABSTRACT_SEMAPHORE_WAIT_ACTION_SLEEP, "ABSTRACT_SEMAPHORE_WAIT_ACTION_SLEEP", "sleep"}, {ABSTRACT_SEMAPHORE_WAIT_ACTION_READY, "ABSTRACT_SEMAPHORE_WAIT_ACTION_READY", "ready"}, {0, NULL, NULL}};
		GType abstract_semaphore_wait_action_type_id;
		abstract_semaphore_wait_action_type_id = g_enum_register_static ("AbstractSemaphoreWaitAction", values);
		g_once_init_leave (&abstract_semaphore_wait_action_type_id__volatile, abstract_semaphore_wait_action_type_id);
	}
	return abstract_semaphore_wait_action_type_id__volatile;
}


AbstractSemaphore* abstract_semaphore_construct (GType object_type, AbstractSemaphoreType type) {
	AbstractSemaphore* self = NULL;
	gboolean _tmp0_ = FALSE;
	AbstractSemaphoreType _tmp1_ = 0;
	AbstractSemaphoreType _tmp3_ = 0;
#line 30 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	self = (AbstractSemaphore*) g_type_create_instance (object_type);
#line 31 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	_tmp1_ = type;
#line 31 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	if (_tmp1_ == ABSTRACT_SEMAPHORE_TYPE_SERIAL) {
#line 31 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		_tmp0_ = TRUE;
#line 274 "Semaphore.c"
	} else {
		AbstractSemaphoreType _tmp2_ = 0;
#line 31 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		_tmp2_ = type;
#line 31 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		_tmp0_ = _tmp2_ == ABSTRACT_SEMAPHORE_TYPE_BROADCAST;
#line 281 "Semaphore.c"
	}
#line 31 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	_vala_assert (_tmp0_, "type == Type.SERIAL || type == Type.BROADCAST");
#line 33 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	_tmp3_ = type;
#line 33 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	self->priv->type = _tmp3_;
#line 30 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	return self;
#line 291 "Semaphore.c"
}


static void abstract_semaphore_trigger (AbstractSemaphore* self) {
	AbstractSemaphoreType _tmp0_ = 0;
#line 36 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	g_return_if_fail (IS_ABSTRACT_SEMAPHORE (self));
#line 37 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	_tmp0_ = self->priv->type;
#line 37 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	if (_tmp0_ == ABSTRACT_SEMAPHORE_TYPE_SERIAL) {
#line 38 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		g_cond_signal (&self->priv->monitor);
#line 305 "Semaphore.c"
	} else {
#line 40 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		g_cond_broadcast (&self->priv->monitor);
#line 309 "Semaphore.c"
	}
}


void abstract_semaphore_notify (AbstractSemaphore* self) {
	AbstractSemaphoreNotifyAction action = 0;
	AbstractSemaphoreNotifyAction _tmp0_ = 0;
	AbstractSemaphoreNotifyAction _tmp1_ = 0;
#line 43 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	g_return_if_fail (IS_ABSTRACT_SEMAPHORE (self));
#line 44 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	g_mutex_lock (&self->priv->mutex);
#line 46 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	_tmp0_ = abstract_semaphore_do_notify (self);
#line 46 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	action = _tmp0_;
#line 47 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	_tmp1_ = action;
#line 47 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	switch (_tmp1_) {
#line 47 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		case ABSTRACT_SEMAPHORE_NOTIFY_ACTION_NONE:
#line 332 "Semaphore.c"
		{
#line 50 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
			break;
#line 336 "Semaphore.c"
		}
#line 47 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		case ABSTRACT_SEMAPHORE_NOTIFY_ACTION_SIGNAL:
#line 340 "Semaphore.c"
		{
#line 53 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
			abstract_semaphore_trigger (self);
#line 54 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
			break;
#line 346 "Semaphore.c"
		}
		default:
		{
			AbstractSemaphoreNotifyAction _tmp2_ = 0;
			GEnumValue* _tmp3_;
#line 57 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
			_tmp2_ = action;
#line 57 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
			_tmp3_ = g_enum_get_value (g_type_class_ref (ABSTRACT_SEMAPHORE_TYPE_NOTIFY_ACTION), _tmp2_);
#line 57 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
			g_error ("Semaphore.vala:57: Unknown semaphore action: %s", (_tmp3_ != NULL) ? _tmp3_->value_name : NULL);
#line 358 "Semaphore.c"
		}
	}
#line 60 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	g_mutex_unlock (&self->priv->mutex);
#line 363 "Semaphore.c"
}


static AbstractSemaphoreNotifyAction abstract_semaphore_real_do_notify (AbstractSemaphore* self) {
#line 64 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	g_critical ("Type `%s' does not implement abstract method `abstract_semaphore_do_notify'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 64 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	return 0;
#line 372 "Semaphore.c"
}


AbstractSemaphoreNotifyAction abstract_semaphore_do_notify (AbstractSemaphore* self) {
#line 64 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	g_return_val_if_fail (IS_ABSTRACT_SEMAPHORE (self), 0);
#line 64 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	return ABSTRACT_SEMAPHORE_GET_CLASS (self)->do_notify (self);
#line 381 "Semaphore.c"
}


void abstract_semaphore_wait (AbstractSemaphore* self) {
#line 66 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	g_return_if_fail (IS_ABSTRACT_SEMAPHORE (self));
#line 67 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	g_mutex_lock (&self->priv->mutex);
#line 69 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	while (TRUE) {
#line 392 "Semaphore.c"
		AbstractSemaphoreWaitAction _tmp0_ = 0;
#line 69 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		_tmp0_ = abstract_semaphore_do_wait (self);
#line 69 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		if (!(_tmp0_ == ABSTRACT_SEMAPHORE_WAIT_ACTION_SLEEP)) {
#line 69 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
			break;
#line 400 "Semaphore.c"
		}
#line 70 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		g_cond_wait (&self->priv->monitor, &self->priv->mutex);
#line 404 "Semaphore.c"
	}
#line 72 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	g_mutex_unlock (&self->priv->mutex);
#line 408 "Semaphore.c"
}


static AbstractSemaphoreWaitAction abstract_semaphore_real_do_wait (AbstractSemaphore* self) {
#line 76 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	g_critical ("Type `%s' does not implement abstract method `abstract_semaphore_do_wait'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 76 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	return 0;
#line 417 "Semaphore.c"
}


AbstractSemaphoreWaitAction abstract_semaphore_do_wait (AbstractSemaphore* self) {
#line 76 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	g_return_val_if_fail (IS_ABSTRACT_SEMAPHORE (self), 0);
#line 76 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	return ABSTRACT_SEMAPHORE_GET_CLASS (self)->do_wait (self);
#line 426 "Semaphore.c"
}


gboolean abstract_semaphore_reset (AbstractSemaphore* self) {
	gboolean result = FALSE;
	gboolean is_reset = FALSE;
	gboolean _tmp0_ = FALSE;
#line 79 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	g_return_val_if_fail (IS_ABSTRACT_SEMAPHORE (self), FALSE);
#line 80 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	g_mutex_lock (&self->priv->mutex);
#line 81 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	_tmp0_ = abstract_semaphore_do_reset (self);
#line 81 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	is_reset = _tmp0_;
#line 82 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	g_mutex_unlock (&self->priv->mutex);
#line 84 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	result = is_reset;
#line 84 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	return result;
#line 448 "Semaphore.c"
}


static gboolean abstract_semaphore_real_do_reset (AbstractSemaphore* self) {
	gboolean result = FALSE;
#line 90 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	result = FALSE;
#line 90 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	return result;
#line 458 "Semaphore.c"
}


gboolean abstract_semaphore_do_reset (AbstractSemaphore* self) {
#line 89 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	g_return_val_if_fail (IS_ABSTRACT_SEMAPHORE (self), FALSE);
#line 89 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	return ABSTRACT_SEMAPHORE_GET_CLASS (self)->do_reset (self);
#line 467 "Semaphore.c"
}


static void value_abstract_semaphore_init (GValue* value) {
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	value->data[0].v_pointer = NULL;
#line 474 "Semaphore.c"
}


static void value_abstract_semaphore_free_value (GValue* value) {
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	if (value->data[0].v_pointer) {
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		abstract_semaphore_unref (value->data[0].v_pointer);
#line 483 "Semaphore.c"
	}
}


static void value_abstract_semaphore_copy_value (const GValue* src_value, GValue* dest_value) {
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	if (src_value->data[0].v_pointer) {
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		dest_value->data[0].v_pointer = abstract_semaphore_ref (src_value->data[0].v_pointer);
#line 493 "Semaphore.c"
	} else {
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		dest_value->data[0].v_pointer = NULL;
#line 497 "Semaphore.c"
	}
}


static gpointer value_abstract_semaphore_peek_pointer (const GValue* value) {
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	return value->data[0].v_pointer;
#line 505 "Semaphore.c"
}


static gchar* value_abstract_semaphore_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	if (collect_values[0].v_pointer) {
#line 512 "Semaphore.c"
		AbstractSemaphore* object;
		object = collect_values[0].v_pointer;
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		if (object->parent_instance.g_class == NULL) {
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 519 "Semaphore.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 523 "Semaphore.c"
		}
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		value->data[0].v_pointer = abstract_semaphore_ref (object);
#line 527 "Semaphore.c"
	} else {
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		value->data[0].v_pointer = NULL;
#line 531 "Semaphore.c"
	}
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	return NULL;
#line 535 "Semaphore.c"
}


static gchar* value_abstract_semaphore_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	AbstractSemaphore** object_p;
	object_p = collect_values[0].v_pointer;
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	if (!object_p) {
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 546 "Semaphore.c"
	}
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	if (!value->data[0].v_pointer) {
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		*object_p = NULL;
#line 552 "Semaphore.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		*object_p = value->data[0].v_pointer;
#line 556 "Semaphore.c"
	} else {
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		*object_p = abstract_semaphore_ref (value->data[0].v_pointer);
#line 560 "Semaphore.c"
	}
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	return NULL;
#line 564 "Semaphore.c"
}


GParamSpec* param_spec_abstract_semaphore (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecAbstractSemaphore* spec;
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ABSTRACT_SEMAPHORE), NULL);
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	return G_PARAM_SPEC (spec);
#line 578 "Semaphore.c"
}


gpointer value_get_abstract_semaphore (const GValue* value) {
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ABSTRACT_SEMAPHORE), NULL);
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	return value->data[0].v_pointer;
#line 587 "Semaphore.c"
}


void value_set_abstract_semaphore (GValue* value, gpointer v_object) {
	AbstractSemaphore* old;
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ABSTRACT_SEMAPHORE));
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	old = value->data[0].v_pointer;
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	if (v_object) {
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ABSTRACT_SEMAPHORE));
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		value->data[0].v_pointer = v_object;
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		abstract_semaphore_ref (value->data[0].v_pointer);
#line 607 "Semaphore.c"
	} else {
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		value->data[0].v_pointer = NULL;
#line 611 "Semaphore.c"
	}
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	if (old) {
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		abstract_semaphore_unref (old);
#line 617 "Semaphore.c"
	}
}


void value_take_abstract_semaphore (GValue* value, gpointer v_object) {
	AbstractSemaphore* old;
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ABSTRACT_SEMAPHORE));
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	old = value->data[0].v_pointer;
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	if (v_object) {
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ABSTRACT_SEMAPHORE));
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		value->data[0].v_pointer = v_object;
#line 636 "Semaphore.c"
	} else {
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		value->data[0].v_pointer = NULL;
#line 640 "Semaphore.c"
	}
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	if (old) {
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		abstract_semaphore_unref (old);
#line 646 "Semaphore.c"
	}
}


static void abstract_semaphore_class_init (AbstractSemaphoreClass * klass) {
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	abstract_semaphore_parent_class = g_type_class_peek_parent (klass);
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	((AbstractSemaphoreClass *) klass)->finalize = abstract_semaphore_finalize;
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	g_type_class_add_private (klass, sizeof (AbstractSemaphorePrivate));
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	((AbstractSemaphoreClass *) klass)->do_notify = abstract_semaphore_real_do_notify;
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	((AbstractSemaphoreClass *) klass)->do_wait = abstract_semaphore_real_do_wait;
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	((AbstractSemaphoreClass *) klass)->do_reset = abstract_semaphore_real_do_reset;
#line 664 "Semaphore.c"
}


static void abstract_semaphore_instance_init (AbstractSemaphore * self) {
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	self->priv = ABSTRACT_SEMAPHORE_GET_PRIVATE (self);
#line 27 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	g_mutex_init (&self->priv->mutex);
#line 28 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	g_cond_init (&self->priv->monitor);
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	self->ref_count = 1;
#line 677 "Semaphore.c"
}


static void abstract_semaphore_finalize (AbstractSemaphore* obj) {
	AbstractSemaphore * self;
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore);
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	g_signal_handlers_destroy (self);
#line 27 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	_vala_clear_GMutex (&self->priv->mutex);
#line 28 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	_vala_clear_GCond (&self->priv->monitor);
#line 691 "Semaphore.c"
}


GType abstract_semaphore_get_type (void) {
	static volatile gsize abstract_semaphore_type_id__volatile = 0;
	if (g_once_init_enter (&abstract_semaphore_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_abstract_semaphore_init, value_abstract_semaphore_free_value, value_abstract_semaphore_copy_value, value_abstract_semaphore_peek_pointer, "p", value_abstract_semaphore_collect_value, "p", value_abstract_semaphore_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AbstractSemaphoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) abstract_semaphore_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AbstractSemaphore), 0, (GInstanceInitFunc) abstract_semaphore_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType abstract_semaphore_type_id;
		abstract_semaphore_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AbstractSemaphore", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&abstract_semaphore_type_id__volatile, abstract_semaphore_type_id);
	}
	return abstract_semaphore_type_id__volatile;
}


gpointer abstract_semaphore_ref (gpointer instance) {
	AbstractSemaphore* self;
	self = instance;
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	g_atomic_int_inc (&self->ref_count);
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	return instance;
#line 716 "Semaphore.c"
}


void abstract_semaphore_unref (gpointer instance) {
	AbstractSemaphore* self;
	self = instance;
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		ABSTRACT_SEMAPHORE_GET_CLASS (self)->finalize (self);
#line 10 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 729 "Semaphore.c"
	}
}


Semaphore* semaphore_construct (GType object_type) {
	Semaphore* self = NULL;
#line 98 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	self = (Semaphore*) abstract_semaphore_construct (object_type, ABSTRACT_SEMAPHORE_TYPE_BROADCAST);
#line 97 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	return self;
#line 740 "Semaphore.c"
}


Semaphore* semaphore_new (void) {
#line 97 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	return semaphore_construct (TYPE_SEMAPHORE);
#line 747 "Semaphore.c"
}


static AbstractSemaphoreNotifyAction semaphore_real_do_notify (AbstractSemaphore* base) {
	Semaphore * self;
	AbstractSemaphoreNotifyAction result = 0;
	gboolean _tmp0_ = FALSE;
#line 101 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEMAPHORE, Semaphore);
#line 102 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	_tmp0_ = self->priv->passed;
#line 102 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	if (_tmp0_) {
#line 103 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		result = ABSTRACT_SEMAPHORE_NOTIFY_ACTION_NONE;
#line 103 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		return result;
#line 765 "Semaphore.c"
	}
#line 105 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	self->priv->passed = TRUE;
#line 107 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	result = ABSTRACT_SEMAPHORE_NOTIFY_ACTION_SIGNAL;
#line 107 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	return result;
#line 773 "Semaphore.c"
}


static AbstractSemaphoreWaitAction semaphore_real_do_wait (AbstractSemaphore* base) {
	Semaphore * self;
	AbstractSemaphoreWaitAction result = 0;
	AbstractSemaphoreWaitAction _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
#line 110 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEMAPHORE, Semaphore);
#line 111 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	_tmp1_ = self->priv->passed;
#line 111 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	if (_tmp1_) {
#line 111 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		_tmp0_ = ABSTRACT_SEMAPHORE_WAIT_ACTION_READY;
#line 790 "Semaphore.c"
	} else {
#line 111 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		_tmp0_ = ABSTRACT_SEMAPHORE_WAIT_ACTION_SLEEP;
#line 794 "Semaphore.c"
	}
#line 111 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	result = _tmp0_;
#line 111 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	return result;
#line 800 "Semaphore.c"
}


static void semaphore_class_init (SemaphoreClass * klass) {
#line 94 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	semaphore_parent_class = g_type_class_peek_parent (klass);
#line 94 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	((AbstractSemaphoreClass *) klass)->finalize = semaphore_finalize;
#line 94 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	g_type_class_add_private (klass, sizeof (SemaphorePrivate));
#line 94 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	((AbstractSemaphoreClass *) klass)->do_notify = semaphore_real_do_notify;
#line 94 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	((AbstractSemaphoreClass *) klass)->do_wait = semaphore_real_do_wait;
#line 815 "Semaphore.c"
}


static void semaphore_instance_init (Semaphore * self) {
#line 94 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	self->priv = SEMAPHORE_GET_PRIVATE (self);
#line 95 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	self->priv->passed = FALSE;
#line 824 "Semaphore.c"
}


static void semaphore_finalize (AbstractSemaphore* obj) {
	Semaphore * self;
#line 94 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEMAPHORE, Semaphore);
#line 94 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	ABSTRACT_SEMAPHORE_CLASS (semaphore_parent_class)->finalize (obj);
#line 834 "Semaphore.c"
}


GType semaphore_get_type (void) {
	static volatile gsize semaphore_type_id__volatile = 0;
	if (g_once_init_enter (&semaphore_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SemaphoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) semaphore_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Semaphore), 0, (GInstanceInitFunc) semaphore_instance_init, NULL };
		GType semaphore_type_id;
		semaphore_type_id = g_type_register_static (TYPE_ABSTRACT_SEMAPHORE, "Semaphore", &g_define_type_info, 0);
		g_once_init_leave (&semaphore_type_id__volatile, semaphore_type_id);
	}
	return semaphore_type_id__volatile;
}


CountdownSemaphore* countdown_semaphore_construct (GType object_type, gint total) {
	CountdownSemaphore* self = NULL;
	gint _tmp0_ = 0;
#line 120 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	self = (CountdownSemaphore*) abstract_semaphore_construct (object_type, ABSTRACT_SEMAPHORE_TYPE_BROADCAST);
#line 122 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	_tmp0_ = total;
#line 122 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	self->priv->total = _tmp0_;
#line 119 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	return self;
#line 861 "Semaphore.c"
}


CountdownSemaphore* countdown_semaphore_new (gint total) {
#line 119 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	return countdown_semaphore_construct (TYPE_COUNTDOWN_SEMAPHORE, total);
#line 868 "Semaphore.c"
}


static AbstractSemaphoreNotifyAction countdown_semaphore_real_do_notify (AbstractSemaphore* base) {
	CountdownSemaphore * self;
	AbstractSemaphoreNotifyAction result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	AbstractSemaphoreNotifyAction _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
#line 125 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COUNTDOWN_SEMAPHORE, CountdownSemaphore);
#line 126 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	_tmp0_ = self->priv->passed;
#line 126 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	_tmp1_ = self->priv->total;
#line 126 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	if (_tmp0_ >= _tmp1_) {
#line 889 "Semaphore.c"
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
#line 127 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		_tmp2_ = self->priv->passed;
#line 127 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		_tmp3_ = self->priv->total;
#line 127 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		g_critical ("Semaphore.vala:127: CountdownSemaphore overrun: %d/%d", _tmp2_ + 1, _tmp3_);
#line 898 "Semaphore.c"
	}
#line 129 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	_tmp5_ = self->priv->passed;
#line 129 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	self->priv->passed = _tmp5_ + 1;
#line 129 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	_tmp6_ = self->priv->passed;
#line 129 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	_tmp7_ = self->priv->total;
#line 129 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	if (_tmp6_ >= _tmp7_) {
#line 129 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		_tmp4_ = ABSTRACT_SEMAPHORE_NOTIFY_ACTION_SIGNAL;
#line 912 "Semaphore.c"
	} else {
#line 129 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		_tmp4_ = ABSTRACT_SEMAPHORE_NOTIFY_ACTION_NONE;
#line 916 "Semaphore.c"
	}
#line 129 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	result = _tmp4_;
#line 129 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	return result;
#line 922 "Semaphore.c"
}


static AbstractSemaphoreWaitAction countdown_semaphore_real_do_wait (AbstractSemaphore* base) {
	CountdownSemaphore * self;
	AbstractSemaphoreWaitAction result = 0;
	AbstractSemaphoreWaitAction _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 132 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COUNTDOWN_SEMAPHORE, CountdownSemaphore);
#line 133 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	_tmp1_ = self->priv->passed;
#line 133 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	_tmp2_ = self->priv->total;
#line 133 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	if (_tmp1_ < _tmp2_) {
#line 133 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		_tmp0_ = ABSTRACT_SEMAPHORE_WAIT_ACTION_SLEEP;
#line 942 "Semaphore.c"
	} else {
#line 133 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		_tmp0_ = ABSTRACT_SEMAPHORE_WAIT_ACTION_READY;
#line 946 "Semaphore.c"
	}
#line 133 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	result = _tmp0_;
#line 133 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	return result;
#line 952 "Semaphore.c"
}


static void countdown_semaphore_class_init (CountdownSemaphoreClass * klass) {
#line 115 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	countdown_semaphore_parent_class = g_type_class_peek_parent (klass);
#line 115 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	((AbstractSemaphoreClass *) klass)->finalize = countdown_semaphore_finalize;
#line 115 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	g_type_class_add_private (klass, sizeof (CountdownSemaphorePrivate));
#line 115 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	((AbstractSemaphoreClass *) klass)->do_notify = countdown_semaphore_real_do_notify;
#line 115 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	((AbstractSemaphoreClass *) klass)->do_wait = countdown_semaphore_real_do_wait;
#line 967 "Semaphore.c"
}


static void countdown_semaphore_instance_init (CountdownSemaphore * self) {
#line 115 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	self->priv = COUNTDOWN_SEMAPHORE_GET_PRIVATE (self);
#line 117 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	self->priv->passed = 0;
#line 976 "Semaphore.c"
}


static void countdown_semaphore_finalize (AbstractSemaphore* obj) {
	CountdownSemaphore * self;
#line 115 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COUNTDOWN_SEMAPHORE, CountdownSemaphore);
#line 115 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	ABSTRACT_SEMAPHORE_CLASS (countdown_semaphore_parent_class)->finalize (obj);
#line 986 "Semaphore.c"
}


GType countdown_semaphore_get_type (void) {
	static volatile gsize countdown_semaphore_type_id__volatile = 0;
	if (g_once_init_enter (&countdown_semaphore_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CountdownSemaphoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) countdown_semaphore_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CountdownSemaphore), 0, (GInstanceInitFunc) countdown_semaphore_instance_init, NULL };
		GType countdown_semaphore_type_id;
		countdown_semaphore_type_id = g_type_register_static (TYPE_ABSTRACT_SEMAPHORE, "CountdownSemaphore", &g_define_type_info, 0);
		g_once_init_leave (&countdown_semaphore_type_id__volatile, countdown_semaphore_type_id);
	}
	return countdown_semaphore_type_id__volatile;
}


EventSemaphore* event_semaphore_construct (GType object_type) {
	EventSemaphore* self = NULL;
#line 141 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	self = (EventSemaphore*) abstract_semaphore_construct (object_type, ABSTRACT_SEMAPHORE_TYPE_BROADCAST);
#line 140 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	return self;
#line 1008 "Semaphore.c"
}


EventSemaphore* event_semaphore_new (void) {
#line 140 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	return event_semaphore_construct (TYPE_EVENT_SEMAPHORE);
#line 1015 "Semaphore.c"
}


static AbstractSemaphoreNotifyAction event_semaphore_real_do_notify (AbstractSemaphore* base) {
	EventSemaphore * self;
	AbstractSemaphoreNotifyAction result = 0;
#line 144 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_SEMAPHORE, EventSemaphore);
#line 145 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	self->priv->fired = TRUE;
#line 147 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	result = ABSTRACT_SEMAPHORE_NOTIFY_ACTION_SIGNAL;
#line 147 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	return result;
#line 1030 "Semaphore.c"
}


static AbstractSemaphoreWaitAction event_semaphore_real_do_wait (AbstractSemaphore* base) {
	EventSemaphore * self;
	AbstractSemaphoreWaitAction result = 0;
	AbstractSemaphoreWaitAction _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
#line 150 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_SEMAPHORE, EventSemaphore);
#line 151 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	_tmp1_ = self->priv->fired;
#line 151 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	if (_tmp1_) {
#line 151 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		_tmp0_ = ABSTRACT_SEMAPHORE_WAIT_ACTION_READY;
#line 1047 "Semaphore.c"
	} else {
#line 151 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
		_tmp0_ = ABSTRACT_SEMAPHORE_WAIT_ACTION_SLEEP;
#line 1051 "Semaphore.c"
	}
#line 151 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	result = _tmp0_;
#line 151 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	return result;
#line 1057 "Semaphore.c"
}


static gboolean event_semaphore_real_do_reset (AbstractSemaphore* base) {
	EventSemaphore * self;
	gboolean result = FALSE;
#line 154 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_SEMAPHORE, EventSemaphore);
#line 155 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	self->priv->fired = FALSE;
#line 157 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	result = TRUE;
#line 157 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	return result;
#line 1072 "Semaphore.c"
}


static void event_semaphore_class_init (EventSemaphoreClass * klass) {
#line 137 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	event_semaphore_parent_class = g_type_class_peek_parent (klass);
#line 137 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	((AbstractSemaphoreClass *) klass)->finalize = event_semaphore_finalize;
#line 137 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	g_type_class_add_private (klass, sizeof (EventSemaphorePrivate));
#line 137 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	((AbstractSemaphoreClass *) klass)->do_notify = event_semaphore_real_do_notify;
#line 137 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	((AbstractSemaphoreClass *) klass)->do_wait = event_semaphore_real_do_wait;
#line 137 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	((AbstractSemaphoreClass *) klass)->do_reset = event_semaphore_real_do_reset;
#line 1089 "Semaphore.c"
}


static void event_semaphore_instance_init (EventSemaphore * self) {
#line 137 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	self->priv = EVENT_SEMAPHORE_GET_PRIVATE (self);
#line 138 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	self->priv->fired = FALSE;
#line 1098 "Semaphore.c"
}


static void event_semaphore_finalize (AbstractSemaphore* obj) {
	EventSemaphore * self;
#line 137 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EVENT_SEMAPHORE, EventSemaphore);
#line 137 "/home/jens/Source/shotwell/src/threads/Semaphore.vala"
	ABSTRACT_SEMAPHORE_CLASS (event_semaphore_parent_class)->finalize (obj);
#line 1108 "Semaphore.c"
}


GType event_semaphore_get_type (void) {
	static volatile gsize event_semaphore_type_id__volatile = 0;
	if (g_once_init_enter (&event_semaphore_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EventSemaphoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) event_semaphore_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EventSemaphore), 0, (GInstanceInitFunc) event_semaphore_instance_init, NULL };
		GType event_semaphore_type_id;
		event_semaphore_type_id = g_type_register_static (TYPE_ABSTRACT_SEMAPHORE, "EventSemaphore", &g_define_type_info, 0);
		g_once_init_leave (&event_semaphore_type_id__volatile, event_semaphore_type_id);
	}
	return event_semaphore_type_id__volatile;
}


static void _vala_clear_GMutex (GMutex * mutex) {
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}


static void _vala_clear_GRecMutex (GRecMutex * mutex) {
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}


static void _vala_clear_GRWLock (GRWLock * mutex) {
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}


static void _vala_clear_GCond (GCond * mutex) {
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}



