/* ChessEffect.c generated by valac 0.34.2, the Vala compiler
 * generated from ChessEffect.vala, do not modify */

/* Copyright 2013 Jens Bav
 * Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <shotwell-plugin-dev-1.0.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <gdk/gdk.h>


#define TYPE_SHOTWELL_TRANSITION_DESCRIPTOR (shotwell_transition_descriptor_get_type ())
#define SHOTWELL_TRANSITION_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, ShotwellTransitionDescriptor))
#define SHOTWELL_TRANSITION_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, ShotwellTransitionDescriptorClass))
#define IS_SHOTWELL_TRANSITION_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR))
#define IS_SHOTWELL_TRANSITION_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR))
#define SHOTWELL_TRANSITION_DESCRIPTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, ShotwellTransitionDescriptorClass))

typedef struct _ShotwellTransitionDescriptor ShotwellTransitionDescriptor;
typedef struct _ShotwellTransitionDescriptorClass ShotwellTransitionDescriptorClass;
typedef struct _ShotwellTransitionDescriptorPrivate ShotwellTransitionDescriptorPrivate;

#define TYPE_CHESS_EFFECT_DESCRIPTOR (chess_effect_descriptor_get_type ())
#define CHESS_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_EFFECT_DESCRIPTOR, ChessEffectDescriptor))
#define CHESS_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_EFFECT_DESCRIPTOR, ChessEffectDescriptorClass))
#define IS_CHESS_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_EFFECT_DESCRIPTOR))
#define IS_CHESS_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_EFFECT_DESCRIPTOR))
#define CHESS_EFFECT_DESCRIPTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_EFFECT_DESCRIPTOR, ChessEffectDescriptorClass))

typedef struct _ChessEffectDescriptor ChessEffectDescriptor;
typedef struct _ChessEffectDescriptorClass ChessEffectDescriptorClass;
typedef struct _ChessEffectDescriptorPrivate ChessEffectDescriptorPrivate;

#define TYPE_CHESS_EFFECT (chess_effect_get_type ())
#define CHESS_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_EFFECT, ChessEffect))
#define CHESS_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_EFFECT, ChessEffectClass))
#define IS_CHESS_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_EFFECT))
#define IS_CHESS_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_EFFECT))
#define CHESS_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_EFFECT, ChessEffectClass))

typedef struct _ChessEffect ChessEffect;
typedef struct _ChessEffectClass ChessEffectClass;
typedef struct _ChessEffectPrivate ChessEffectPrivate;

struct _ShotwellTransitionDescriptor {
	GObject parent_instance;
	ShotwellTransitionDescriptorPrivate * priv;
};

struct _ShotwellTransitionDescriptorClass {
	GObjectClass parent_class;
	const gchar* (*get_id) (ShotwellTransitionDescriptor* self);
	const gchar* (*get_pluggable_name) (ShotwellTransitionDescriptor* self);
	SpitTransitionsEffect* (*create) (ShotwellTransitionDescriptor* self, SpitHostInterface* host);
};

struct _ChessEffectDescriptor {
	ShotwellTransitionDescriptor parent_instance;
	ChessEffectDescriptorPrivate * priv;
};

struct _ChessEffectDescriptorClass {
	ShotwellTransitionDescriptorClass parent_class;
};

struct _ChessEffect {
	GObject parent_instance;
	ChessEffectPrivate * priv;
};

struct _ChessEffectClass {
	GObjectClass parent_class;
};

struct _ChessEffectPrivate {
	gdouble square_count_x;
	gdouble square_count_y;
};


static gpointer chess_effect_descriptor_parent_class = NULL;
static gpointer chess_effect_parent_class = NULL;
static SpitTransitionsEffectIface* chess_effect_spit_transitions_effect_parent_iface = NULL;

GType shotwell_transition_descriptor_get_type (void) G_GNUC_CONST;
GType chess_effect_descriptor_get_type (void) G_GNUC_CONST;
enum  {
	CHESS_EFFECT_DESCRIPTOR_DUMMY_PROPERTY
};
ChessEffectDescriptor* chess_effect_descriptor_new (GFile* resource_directory);
ChessEffectDescriptor* chess_effect_descriptor_construct (GType object_type, GFile* resource_directory);
ShotwellTransitionDescriptor* shotwell_transition_descriptor_construct (GType object_type, GFile* resource_directory);
static const gchar* chess_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base);
static const gchar* chess_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base);
static SpitTransitionsEffect* chess_effect_descriptor_real_create (ShotwellTransitionDescriptor* base, SpitHostInterface* host);
ChessEffect* chess_effect_new (void);
ChessEffect* chess_effect_construct (GType object_type);
GType chess_effect_get_type (void) G_GNUC_CONST;
#define CHESS_EFFECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_EFFECT, ChessEffectPrivate))
enum  {
	CHESS_EFFECT_DUMMY_PROPERTY
};
#define CHESS_EFFECT_DESIRED_FPS 25
#define CHESS_EFFECT_MIN_FPS 10
#define CHESS_EFFECT_SQUARE_SIZE 100
static void chess_effect_real_get_fps (SpitTransitionsEffect* base, gint* desired_fps, gint* min_fps);
static void chess_effect_real_start (SpitTransitionsEffect* base, SpitTransitionsVisuals* visuals, SpitTransitionsMotion* motion);
static gboolean chess_effect_real_needs_clear_background (SpitTransitionsEffect* base);
static void chess_effect_real_paint (SpitTransitionsEffect* base, SpitTransitionsVisuals* visuals, SpitTransitionsMotion* motion, cairo_t* ctx, gint width, gint height, gint frame_number);
static void chess_effect_real_advance (SpitTransitionsEffect* base, SpitTransitionsVisuals* visuals, SpitTransitionsMotion* motion, gint frame_number);
static void chess_effect_real_cancel (SpitTransitionsEffect* base);
static void chess_effect_finalize (GObject* obj);


ChessEffectDescriptor* chess_effect_descriptor_construct (GType object_type, GFile* resource_directory) {
	ChessEffectDescriptor * self = NULL;
	GFile* _tmp0_ = NULL;
#line 11 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	g_return_val_if_fail (G_IS_FILE (resource_directory), NULL);
#line 12 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_tmp0_ = resource_directory;
#line 12 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	self = (ChessEffectDescriptor*) shotwell_transition_descriptor_construct (object_type, _tmp0_);
#line 11 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	return self;
#line 139 "ChessEffect.c"
}


ChessEffectDescriptor* chess_effect_descriptor_new (GFile* resource_directory) {
#line 11 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	return chess_effect_descriptor_construct (TYPE_CHESS_EFFECT_DESCRIPTOR, resource_directory);
#line 146 "ChessEffect.c"
}


static const gchar* chess_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base) {
	ChessEffectDescriptor * self;
	const gchar* result = NULL;
#line 15 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHESS_EFFECT_DESCRIPTOR, ChessEffectDescriptor);
#line 16 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	result = "org.yorba.shotwell.transitions.chess";
#line 16 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	return result;
#line 159 "ChessEffect.c"
}


static const gchar* chess_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base) {
	ChessEffectDescriptor * self;
	const gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
#line 19 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHESS_EFFECT_DESCRIPTOR, ChessEffectDescriptor);
#line 20 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_tmp0_ = _ ("Chess");
#line 20 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	result = _tmp0_;
#line 20 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	return result;
#line 175 "ChessEffect.c"
}


static SpitTransitionsEffect* chess_effect_descriptor_real_create (ShotwellTransitionDescriptor* base, SpitHostInterface* host) {
	ChessEffectDescriptor * self;
	SpitTransitionsEffect* result = NULL;
	ChessEffect* _tmp0_ = NULL;
#line 23 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHESS_EFFECT_DESCRIPTOR, ChessEffectDescriptor);
#line 23 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	g_return_val_if_fail (SPIT_IS_HOST_INTERFACE (host), NULL);
#line 24 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_tmp0_ = chess_effect_new ();
#line 24 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SPIT_TRANSITIONS_TYPE_EFFECT, SpitTransitionsEffect);
#line 24 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	return result;
#line 193 "ChessEffect.c"
}


static void chess_effect_descriptor_class_init (ChessEffectDescriptorClass * klass) {
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	chess_effect_descriptor_parent_class = g_type_class_peek_parent (klass);
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	((ShotwellTransitionDescriptorClass *) klass)->get_id = chess_effect_descriptor_real_get_id;
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	((ShotwellTransitionDescriptorClass *) klass)->get_pluggable_name = chess_effect_descriptor_real_get_pluggable_name;
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	((ShotwellTransitionDescriptorClass *) klass)->create = chess_effect_descriptor_real_create;
#line 206 "ChessEffect.c"
}


static void chess_effect_descriptor_instance_init (ChessEffectDescriptor * self) {
}


GType chess_effect_descriptor_get_type (void) {
	static volatile gsize chess_effect_descriptor_type_id__volatile = 0;
	if (g_once_init_enter (&chess_effect_descriptor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessEffectDescriptorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_effect_descriptor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessEffectDescriptor), 0, (GInstanceInitFunc) chess_effect_descriptor_instance_init, NULL };
		GType chess_effect_descriptor_type_id;
		chess_effect_descriptor_type_id = g_type_register_static (TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, "ChessEffectDescriptor", &g_define_type_info, 0);
		g_once_init_leave (&chess_effect_descriptor_type_id__volatile, chess_effect_descriptor_type_id);
	}
	return chess_effect_descriptor_type_id__volatile;
}


ChessEffect* chess_effect_construct (GType object_type) {
	ChessEffect * self = NULL;
#line 35 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	self = (ChessEffect*) g_object_new (object_type, NULL);
#line 35 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	return self;
#line 232 "ChessEffect.c"
}


ChessEffect* chess_effect_new (void) {
#line 35 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	return chess_effect_construct (TYPE_CHESS_EFFECT);
#line 239 "ChessEffect.c"
}


static void chess_effect_real_get_fps (SpitTransitionsEffect* base, gint* desired_fps, gint* min_fps) {
	ChessEffect * self;
	gint _vala_desired_fps = 0;
	gint _vala_min_fps = 0;
#line 38 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHESS_EFFECT, ChessEffect);
#line 39 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_vala_desired_fps = CHESS_EFFECT_DESIRED_FPS;
#line 40 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_vala_min_fps = CHESS_EFFECT_MIN_FPS;
#line 38 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	if (desired_fps) {
#line 38 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		*desired_fps = _vala_desired_fps;
#line 257 "ChessEffect.c"
	}
#line 38 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	if (min_fps) {
#line 38 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		*min_fps = _vala_min_fps;
#line 263 "ChessEffect.c"
	}
}


static void chess_effect_real_start (SpitTransitionsEffect* base, SpitTransitionsVisuals* visuals, SpitTransitionsMotion* motion) {
	ChessEffect * self;
	SpitTransitionsVisuals* _tmp0_ = NULL;
	GdkRectangle _tmp1_ = {0};
	GdkRectangle _tmp2_ = {0};
	gint _tmp3_ = 0;
	SpitTransitionsVisuals* _tmp4_ = NULL;
	GdkRectangle _tmp5_ = {0};
	GdkRectangle _tmp6_ = {0};
	gint _tmp7_ = 0;
#line 43 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHESS_EFFECT, ChessEffect);
#line 43 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (visuals));
#line 43 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (motion));
#line 44 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_tmp0_ = visuals;
#line 44 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	spit_transitions_visuals_get_to_pos (_tmp0_, &_tmp1_);
#line 44 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_tmp2_ = _tmp1_;
#line 44 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_tmp3_ = _tmp2_.height;
#line 44 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	self->priv->square_count_y = (gdouble) ((_tmp3_ / CHESS_EFFECT_SQUARE_SIZE) + 2);
#line 45 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_tmp4_ = visuals;
#line 45 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	spit_transitions_visuals_get_to_pos (_tmp4_, &_tmp5_);
#line 45 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_tmp6_ = _tmp5_;
#line 45 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_tmp7_ = _tmp6_.width;
#line 45 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	self->priv->square_count_x = (gdouble) ((_tmp7_ / CHESS_EFFECT_SQUARE_SIZE) + 2);
#line 304 "ChessEffect.c"
}


static gboolean chess_effect_real_needs_clear_background (SpitTransitionsEffect* base) {
	ChessEffect * self;
	gboolean result = FALSE;
#line 48 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHESS_EFFECT, ChessEffect);
#line 49 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	result = TRUE;
#line 49 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	return result;
#line 317 "ChessEffect.c"
}


static void chess_effect_real_paint (SpitTransitionsEffect* base, SpitTransitionsVisuals* visuals, SpitTransitionsMotion* motion, cairo_t* ctx, gint width, gint height, gint frame_number) {
	ChessEffect * self;
	gdouble alpha = 0.0;
	SpitTransitionsMotion* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gdouble _tmp2_ = 0.0;
	gdouble size = 0.0;
	gdouble _tmp3_ = 0.0;
	SpitTransitionsVisuals* _tmp4_ = NULL;
	GdkPixbuf* _tmp5_ = NULL;
	GdkPixbuf* _tmp6_ = NULL;
	SpitTransitionsVisuals* _tmp21_ = NULL;
	GdkPixbuf* _tmp22_ = NULL;
	GdkPixbuf* _tmp23_ = NULL;
#line 52 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHESS_EFFECT, ChessEffect);
#line 52 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (visuals));
#line 52 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (motion));
#line 52 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	g_return_if_fail (ctx != NULL);
#line 54 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_tmp0_ = motion;
#line 54 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_tmp1_ = frame_number;
#line 54 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_tmp2_ = spit_transitions_motion_get_alpha (_tmp0_, _tmp1_);
#line 54 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	alpha = _tmp2_;
#line 55 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_tmp3_ = alpha;
#line 55 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	size = (2 * _tmp3_) * CHESS_EFFECT_SQUARE_SIZE;
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_tmp4_ = visuals;
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_tmp5_ = spit_transitions_visuals_get_from_pixbuf (_tmp4_);
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_tmp6_ = _tmp5_;
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	if (_tmp6_ != NULL) {
#line 363 "ChessEffect.c"
		cairo_t* _tmp7_ = NULL;
		SpitTransitionsVisuals* _tmp8_ = NULL;
		GdkPixbuf* _tmp9_ = NULL;
		GdkPixbuf* _tmp10_ = NULL;
		SpitTransitionsVisuals* _tmp11_ = NULL;
		GdkRectangle _tmp12_ = {0};
		GdkRectangle _tmp13_ = {0};
		gint _tmp14_ = 0;
		SpitTransitionsVisuals* _tmp15_ = NULL;
		GdkRectangle _tmp16_ = {0};
		GdkRectangle _tmp17_ = {0};
		gint _tmp18_ = 0;
		cairo_t* _tmp19_ = NULL;
		gdouble _tmp20_ = 0.0;
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp7_ = ctx;
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp8_ = visuals;
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp9_ = spit_transitions_visuals_get_from_pixbuf (_tmp8_);
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp10_ = _tmp9_;
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp11_ = visuals;
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		spit_transitions_visuals_get_from_pos (_tmp11_, &_tmp12_);
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp13_ = _tmp12_;
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp14_ = _tmp13_.x;
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp15_ = visuals;
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		spit_transitions_visuals_get_from_pos (_tmp15_, &_tmp16_);
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp17_ = _tmp16_;
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp18_ = _tmp17_.y;
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		gdk_cairo_set_source_pixbuf (_tmp7_, _tmp10_, (gdouble) _tmp14_, (gdouble) _tmp18_);
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp19_ = ctx;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp20_ = alpha;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		cairo_paint_with_alpha (_tmp19_, 1 - _tmp20_);
#line 410 "ChessEffect.c"
	}
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_tmp21_ = visuals;
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_tmp22_ = spit_transitions_visuals_get_to_pixbuf (_tmp21_);
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_tmp23_ = _tmp22_;
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	if (_tmp23_ != NULL) {
#line 420 "ChessEffect.c"
		cairo_t* _tmp24_ = NULL;
		SpitTransitionsVisuals* _tmp25_ = NULL;
		GdkPixbuf* _tmp26_ = NULL;
		GdkPixbuf* _tmp27_ = NULL;
		SpitTransitionsVisuals* _tmp28_ = NULL;
		GdkRectangle _tmp29_ = {0};
		GdkRectangle _tmp30_ = {0};
		gint _tmp31_ = 0;
		SpitTransitionsVisuals* _tmp32_ = NULL;
		GdkRectangle _tmp33_ = {0};
		GdkRectangle _tmp34_ = {0};
		gint _tmp35_ = 0;
		cairo_t* _tmp81_ = NULL;
		cairo_t* _tmp82_ = NULL;
		gdouble _tmp83_ = 0.0;
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp24_ = ctx;
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp25_ = visuals;
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp26_ = spit_transitions_visuals_get_to_pixbuf (_tmp25_);
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp27_ = _tmp26_;
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp28_ = visuals;
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		spit_transitions_visuals_get_to_pos (_tmp28_, &_tmp29_);
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp30_ = _tmp29_;
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp31_ = _tmp30_.x;
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp32_ = visuals;
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		spit_transitions_visuals_get_to_pos (_tmp32_, &_tmp33_);
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp34_ = _tmp33_;
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp35_ = _tmp34_.y;
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		gdk_cairo_set_source_pixbuf (_tmp24_, _tmp27_, (gdouble) _tmp31_, (gdouble) _tmp35_);
#line 462 "ChessEffect.c"
		{
			gdouble y = 0.0;
#line 64 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
			y = (gdouble) 0;
#line 467 "ChessEffect.c"
			{
				gboolean _tmp36_ = FALSE;
#line 64 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
				_tmp36_ = TRUE;
#line 64 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
				while (TRUE) {
#line 474 "ChessEffect.c"
					gdouble _tmp38_ = 0.0;
					gdouble _tmp39_ = 0.0;
#line 64 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
					if (!_tmp36_) {
#line 479 "ChessEffect.c"
						gdouble _tmp37_ = 0.0;
#line 64 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
						_tmp37_ = y;
#line 64 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
						y = _tmp37_ + 1;
#line 485 "ChessEffect.c"
					}
#line 64 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
					_tmp36_ = FALSE;
#line 64 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
					_tmp38_ = y;
#line 64 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
					_tmp39_ = self->priv->square_count_y;
#line 64 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
					if (!(_tmp38_ <= _tmp39_)) {
#line 64 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
						break;
#line 497 "ChessEffect.c"
					}
					{
						gdouble x = 0.0;
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
						x = (gdouble) 0;
#line 503 "ChessEffect.c"
						{
							gboolean _tmp40_ = FALSE;
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
							_tmp40_ = TRUE;
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
							while (TRUE) {
#line 510 "ChessEffect.c"
								gdouble _tmp42_ = 0.0;
								gdouble _tmp43_ = 0.0;
								gdouble _tmp44_ = 0.0;
								gdouble _tmp45_ = 0.0;
								gdouble _tmp46_ = 0.0;
								gdouble translation = 0.0;
								SpitTransitionsMotion* _tmp47_ = NULL;
								SpitTransitionsDirection _tmp48_ = 0;
								SpitTransitionsDirection _tmp49_ = 0;
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
								if (!_tmp40_) {
#line 522 "ChessEffect.c"
									gdouble _tmp41_ = 0.0;
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp41_ = x;
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									x = _tmp41_ + 1;
#line 528 "ChessEffect.c"
								}
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
								_tmp40_ = FALSE;
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
								_tmp42_ = x;
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
								_tmp43_ = self->priv->square_count_x;
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
								if (!(_tmp42_ <= _tmp43_)) {
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									break;
#line 540 "ChessEffect.c"
								}
#line 66 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
								_tmp45_ = x;
#line 66 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
								_tmp46_ = y;
#line 66 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
								if (fmod (_tmp45_ + _tmp46_, 2) == ((gdouble) 0)) {
#line 66 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp44_ = (-1.5) * CHESS_EFFECT_SQUARE_SIZE;
#line 550 "ChessEffect.c"
								} else {
#line 66 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp44_ = 1.5 * CHESS_EFFECT_SQUARE_SIZE;
#line 554 "ChessEffect.c"
								}
#line 66 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
								translation = _tmp44_;
#line 67 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
								_tmp47_ = motion;
#line 67 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
								_tmp48_ = spit_transitions_motion_get_direction (_tmp47_);
#line 67 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
								_tmp49_ = _tmp48_;
#line 67 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
								if (_tmp49_ == SPIT_TRANSITIONS_DIRECTION_FORWARD) {
#line 566 "ChessEffect.c"
									cairo_t* _tmp50_ = NULL;
									SpitTransitionsVisuals* _tmp51_ = NULL;
									GdkRectangle _tmp52_ = {0};
									GdkRectangle _tmp53_ = {0};
									gint _tmp54_ = 0;
									gdouble _tmp55_ = 0.0;
									gdouble _tmp56_ = 0.0;
									SpitTransitionsVisuals* _tmp57_ = NULL;
									GdkRectangle _tmp58_ = {0};
									GdkRectangle _tmp59_ = {0};
									gint _tmp60_ = 0;
									gdouble _tmp61_ = 0.0;
									gdouble _tmp62_ = 0.0;
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp50_ = ctx;
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp51_ = visuals;
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									spit_transitions_visuals_get_to_pos (_tmp51_, &_tmp52_);
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp53_ = _tmp52_;
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp54_ = _tmp53_.x;
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp55_ = translation;
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp56_ = x;
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp57_ = visuals;
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									spit_transitions_visuals_get_to_pos (_tmp57_, &_tmp58_);
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp59_ = _tmp58_;
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp60_ = _tmp59_.y;
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp61_ = y;
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp62_ = size;
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									cairo_rectangle (_tmp50_, (_tmp54_ + _tmp55_) + (_tmp56_ * CHESS_EFFECT_SQUARE_SIZE), _tmp60_ + (_tmp61_ * CHESS_EFFECT_SQUARE_SIZE), _tmp62_, (gdouble) CHESS_EFFECT_SQUARE_SIZE);
#line 608 "ChessEffect.c"
								} else {
									cairo_t* _tmp63_ = NULL;
									SpitTransitionsVisuals* _tmp64_ = NULL;
									GdkRectangle _tmp65_ = {0};
									GdkRectangle _tmp66_ = {0};
									gint _tmp67_ = 0;
									SpitTransitionsVisuals* _tmp68_ = NULL;
									GdkRectangle _tmp69_ = {0};
									GdkRectangle _tmp70_ = {0};
									gint _tmp71_ = 0;
									gdouble _tmp72_ = 0.0;
									gdouble _tmp73_ = 0.0;
									gdouble _tmp74_ = 0.0;
									SpitTransitionsVisuals* _tmp75_ = NULL;
									GdkRectangle _tmp76_ = {0};
									GdkRectangle _tmp77_ = {0};
									gint _tmp78_ = 0;
									gdouble _tmp79_ = 0.0;
									gdouble _tmp80_ = 0.0;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp63_ = ctx;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp64_ = visuals;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									spit_transitions_visuals_get_to_pos (_tmp64_, &_tmp65_);
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp66_ = _tmp65_;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp67_ = _tmp66_.x;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp68_ = visuals;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									spit_transitions_visuals_get_to_pos (_tmp68_, &_tmp69_);
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp70_ = _tmp69_;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp71_ = _tmp70_.width;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp72_ = translation;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp73_ = x;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp74_ = size;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp75_ = visuals;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									spit_transitions_visuals_get_to_pos (_tmp75_, &_tmp76_);
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp77_ = _tmp76_;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp78_ = _tmp77_.y;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp79_ = y;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp80_ = size;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									cairo_rectangle (_tmp63_, (((_tmp67_ + _tmp71_) + _tmp72_) - (_tmp73_ * CHESS_EFFECT_SQUARE_SIZE)) - _tmp74_, _tmp78_ + (_tmp79_ * CHESS_EFFECT_SQUARE_SIZE), _tmp80_, (gdouble) CHESS_EFFECT_SQUARE_SIZE);
#line 666 "ChessEffect.c"
								}
							}
						}
					}
				}
			}
		}
#line 78 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp81_ = ctx;
#line 78 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		cairo_clip (_tmp81_);
#line 79 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp82_ = ctx;
#line 79 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp83_ = alpha;
#line 79 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		cairo_paint_with_alpha (_tmp82_, _tmp83_);
#line 684 "ChessEffect.c"
	}
}


static void chess_effect_real_advance (SpitTransitionsEffect* base, SpitTransitionsVisuals* visuals, SpitTransitionsMotion* motion, gint frame_number) {
	ChessEffect * self;
#line 83 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHESS_EFFECT, ChessEffect);
#line 83 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (visuals));
#line 83 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (motion));
#line 697 "ChessEffect.c"
}


static void chess_effect_real_cancel (SpitTransitionsEffect* base) {
	ChessEffect * self;
#line 86 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHESS_EFFECT, ChessEffect);
#line 705 "ChessEffect.c"
}


static void chess_effect_class_init (ChessEffectClass * klass) {
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	chess_effect_parent_class = g_type_class_peek_parent (klass);
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	g_type_class_add_private (klass, sizeof (ChessEffectPrivate));
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	G_OBJECT_CLASS (klass)->finalize = chess_effect_finalize;
#line 716 "ChessEffect.c"
}


static void chess_effect_spit_transitions_effect_interface_init (SpitTransitionsEffectIface * iface) {
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	chess_effect_spit_transitions_effect_parent_iface = g_type_interface_peek_parent (iface);
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	iface->get_fps = (void (*)(SpitTransitionsEffect*, gint*, gint*)) chess_effect_real_get_fps;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	iface->start = (void (*)(SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*)) chess_effect_real_start;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	iface->needs_clear_background = (gboolean (*)(SpitTransitionsEffect*)) chess_effect_real_needs_clear_background;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	iface->paint = (void (*)(SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*, cairo_t*, gint, gint, gint)) chess_effect_real_paint;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	iface->advance = (void (*)(SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*, gint)) chess_effect_real_advance;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	iface->cancel = (void (*)(SpitTransitionsEffect*)) chess_effect_real_cancel;
#line 735 "ChessEffect.c"
}


static void chess_effect_instance_init (ChessEffect * self) {
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	self->priv = CHESS_EFFECT_GET_PRIVATE (self);
#line 742 "ChessEffect.c"
}


static void chess_effect_finalize (GObject* obj) {
	ChessEffect * self;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_EFFECT, ChessEffect);
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	G_OBJECT_CLASS (chess_effect_parent_class)->finalize (obj);
#line 752 "ChessEffect.c"
}


GType chess_effect_get_type (void) {
	static volatile gsize chess_effect_type_id__volatile = 0;
	if (g_once_init_enter (&chess_effect_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessEffectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_effect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessEffect), 0, (GInstanceInitFunc) chess_effect_instance_init, NULL };
		static const GInterfaceInfo spit_transitions_effect_info = { (GInterfaceInitFunc) chess_effect_spit_transitions_effect_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType chess_effect_type_id;
		chess_effect_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessEffect", &g_define_type_info, 0);
		g_type_add_interface_static (chess_effect_type_id, SPIT_TRANSITIONS_TYPE_EFFECT, &spit_transitions_effect_info);
		g_once_init_leave (&chess_effect_type_id__volatile, chess_effect_type_id);
	}
	return chess_effect_type_id__volatile;
}



