/* SpitInterfaces.c generated by valac 0.34.1, the Vala compiler
 * generated from SpitInterfaces.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>


#define SPIT_TYPE_ENTRY_POINT_PARAMS (spit_entry_point_params_get_type ())
typedef struct _SpitEntryPointParams SpitEntryPointParams;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SPIT_TYPE_MODULE (spit_module_get_type ())
#define SPIT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_TYPE_MODULE, SpitModule))
#define SPIT_IS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_TYPE_MODULE))
#define SPIT_MODULE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_TYPE_MODULE, SpitModuleIface))

typedef struct _SpitModule SpitModule;
typedef struct _SpitModuleIface SpitModuleIface;

#define SPIT_TYPE_PLUGGABLE (spit_pluggable_get_type ())
#define SPIT_PLUGGABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_TYPE_PLUGGABLE, SpitPluggable))
#define SPIT_IS_PLUGGABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_TYPE_PLUGGABLE))
#define SPIT_PLUGGABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_TYPE_PLUGGABLE, SpitPluggableIface))

typedef struct _SpitPluggable SpitPluggable;
typedef struct _SpitPluggableIface SpitPluggableIface;

#define SPIT_TYPE_PLUGGABLE_INFO (spit_pluggable_info_get_type ())
typedef struct _SpitPluggableInfo SpitPluggableInfo;
#define _g_free0(var) (var = (g_free (var), NULL))

#define SPIT_TYPE_HOST_INTERFACE (spit_host_interface_get_type ())
#define SPIT_HOST_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_TYPE_HOST_INTERFACE, SpitHostInterface))
#define SPIT_IS_HOST_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_TYPE_HOST_INTERFACE))
#define SPIT_HOST_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_TYPE_HOST_INTERFACE, SpitHostInterfaceIface))

typedef struct _SpitHostInterface SpitHostInterface;
typedef struct _SpitHostInterfaceIface SpitHostInterfaceIface;

struct _SpitEntryPointParams {
	gint host_min_spit_interface;
	gint host_max_spit_interface;
	gint module_spit_interface;
	GFile* module_file;
};

struct _SpitPluggableInfo {
	gchar* version;
	gchar* brief_description;
	gchar* authors;
	gchar* copyright;
	gchar* license;
	gboolean is_license_wordwrapped;
	gchar* website_url;
	gchar* website_name;
	gchar* translators;
	GdkPixbuf** icons;
	gint icons_length1;
};

struct _SpitPluggableIface {
	GTypeInterface parent_iface;
	gint (*get_pluggable_interface) (SpitPluggable* self, gint min_host_interface, gint max_host_interface);
	const gchar* (*get_id) (SpitPluggable* self);
	const gchar* (*get_pluggable_name) (SpitPluggable* self);
	void (*get_info) (SpitPluggable* self, SpitPluggableInfo* info);
	void (*activation) (SpitPluggable* self, gboolean enabled);
	void (*reserved0) (SpitPluggable* self);
	void (*reserved1) (SpitPluggable* self);
	void (*reserved2) (SpitPluggable* self);
	void (*reserved3) (SpitPluggable* self);
	void (*reserved4) (SpitPluggable* self);
	void (*reserved5) (SpitPluggable* self);
	void (*reserved6) (SpitPluggable* self);
	void (*reserved7) (SpitPluggable* self);
};

struct _SpitModuleIface {
	GTypeInterface parent_iface;
	const gchar* (*get_module_name) (SpitModule* self);
	const gchar* (*get_version) (SpitModule* self);
	const gchar* (*get_id) (SpitModule* self);
	SpitPluggable** (*get_pluggables) (SpitModule* self, int* result_length1);
	void (*reserved0) (SpitModule* self);
	void (*reserved1) (SpitModule* self);
	void (*reserved2) (SpitModule* self);
	void (*reserved3) (SpitModule* self);
	void (*reserved4) (SpitModule* self);
	void (*reserved5) (SpitModule* self);
	void (*reserved6) (SpitModule* self);
	void (*reserved7) (SpitModule* self);
};

typedef SpitModule* (*SpitEntryPoint) (SpitEntryPointParams* params);
struct _SpitHostInterfaceIface {
	GTypeInterface parent_iface;
	GFile* (*get_module_file) (SpitHostInterface* self);
	gboolean (*get_config_bool) (SpitHostInterface* self, const gchar* key, gboolean def);
	void (*set_config_bool) (SpitHostInterface* self, const gchar* key, gboolean val);
	gint (*get_config_int) (SpitHostInterface* self, const gchar* key, gint def);
	void (*set_config_int) (SpitHostInterface* self, const gchar* key, gint val);
	gchar* (*get_config_string) (SpitHostInterface* self, const gchar* key, const gchar* def);
	void (*set_config_string) (SpitHostInterface* self, const gchar* key, const gchar* val);
	gdouble (*get_config_double) (SpitHostInterface* self, const gchar* key, gdouble def);
	void (*set_config_double) (SpitHostInterface* self, const gchar* key, gdouble val);
	void (*unset_config_key) (SpitHostInterface* self, const gchar* key);
	void (*reserved0) (SpitHostInterface* self);
	void (*reserved1) (SpitHostInterface* self);
	void (*reserved2) (SpitHostInterface* self);
	void (*reserved3) (SpitHostInterface* self);
	void (*reserved4) (SpitHostInterface* self);
	void (*reserved5) (SpitHostInterface* self);
	void (*reserved6) (SpitHostInterface* self);
	void (*reserved7) (SpitHostInterface* self);
};



#define SPIT_UNSUPPORTED_INTERFACE -1
#define SPIT_CURRENT_INTERFACE 0
gint spit_negotiate_interfaces (gint min_host_interface, gint max_host_interface, gint plugin_interface);
GType spit_entry_point_params_get_type (void) G_GNUC_CONST;
SpitEntryPointParams* spit_entry_point_params_dup (const SpitEntryPointParams* self);
void spit_entry_point_params_free (SpitEntryPointParams* self);
void spit_entry_point_params_copy (const SpitEntryPointParams* self, SpitEntryPointParams* dest);
void spit_entry_point_params_destroy (SpitEntryPointParams* self);
GType spit_pluggable_info_get_type (void) G_GNUC_CONST;
SpitPluggableInfo* spit_pluggable_info_dup (const SpitPluggableInfo* self);
void spit_pluggable_info_free (SpitPluggableInfo* self);
void spit_pluggable_info_copy (const SpitPluggableInfo* self, SpitPluggableInfo* dest);
void spit_pluggable_info_destroy (SpitPluggableInfo* self);
GType spit_pluggable_get_type (void) G_GNUC_CONST;
GType spit_module_get_type (void) G_GNUC_CONST;
#define SPIT_ENTRY_POINT_NAME "spit_entry_point"
const gchar* spit_module_get_module_name (SpitModule* self);
const gchar* spit_module_get_version (SpitModule* self);
const gchar* spit_module_get_id (SpitModule* self);
SpitPluggable** spit_module_get_pluggables (SpitModule* self, int* result_length1);
void spit_module_reserved0 (SpitModule* self);
static void spit_module_real_reserved0 (SpitModule* self);
void spit_module_reserved1 (SpitModule* self);
static void spit_module_real_reserved1 (SpitModule* self);
void spit_module_reserved2 (SpitModule* self);
static void spit_module_real_reserved2 (SpitModule* self);
void spit_module_reserved3 (SpitModule* self);
static void spit_module_real_reserved3 (SpitModule* self);
void spit_module_reserved4 (SpitModule* self);
static void spit_module_real_reserved4 (SpitModule* self);
void spit_module_reserved5 (SpitModule* self);
static void spit_module_real_reserved5 (SpitModule* self);
void spit_module_reserved6 (SpitModule* self);
static void spit_module_real_reserved6 (SpitModule* self);
void spit_module_reserved7 (SpitModule* self);
static void spit_module_real_reserved7 (SpitModule* self);
static GdkPixbuf** _vala_array_dup1 (GdkPixbuf** self, int length);
gint spit_pluggable_get_pluggable_interface (SpitPluggable* self, gint min_host_interface, gint max_host_interface);
const gchar* spit_pluggable_get_id (SpitPluggable* self);
const gchar* spit_pluggable_get_pluggable_name (SpitPluggable* self);
void spit_pluggable_get_info (SpitPluggable* self, SpitPluggableInfo* info);
void spit_pluggable_activation (SpitPluggable* self, gboolean enabled);
void spit_pluggable_reserved0 (SpitPluggable* self);
static void spit_pluggable_real_reserved0 (SpitPluggable* self);
void spit_pluggable_reserved1 (SpitPluggable* self);
static void spit_pluggable_real_reserved1 (SpitPluggable* self);
void spit_pluggable_reserved2 (SpitPluggable* self);
static void spit_pluggable_real_reserved2 (SpitPluggable* self);
void spit_pluggable_reserved3 (SpitPluggable* self);
static void spit_pluggable_real_reserved3 (SpitPluggable* self);
void spit_pluggable_reserved4 (SpitPluggable* self);
static void spit_pluggable_real_reserved4 (SpitPluggable* self);
void spit_pluggable_reserved5 (SpitPluggable* self);
static void spit_pluggable_real_reserved5 (SpitPluggable* self);
void spit_pluggable_reserved6 (SpitPluggable* self);
static void spit_pluggable_real_reserved6 (SpitPluggable* self);
void spit_pluggable_reserved7 (SpitPluggable* self);
static void spit_pluggable_real_reserved7 (SpitPluggable* self);
GType spit_host_interface_get_type (void) G_GNUC_CONST;
GFile* spit_host_interface_get_module_file (SpitHostInterface* self);
gboolean spit_host_interface_get_config_bool (SpitHostInterface* self, const gchar* key, gboolean def);
void spit_host_interface_set_config_bool (SpitHostInterface* self, const gchar* key, gboolean val);
gint spit_host_interface_get_config_int (SpitHostInterface* self, const gchar* key, gint def);
void spit_host_interface_set_config_int (SpitHostInterface* self, const gchar* key, gint val);
gchar* spit_host_interface_get_config_string (SpitHostInterface* self, const gchar* key, const gchar* def);
void spit_host_interface_set_config_string (SpitHostInterface* self, const gchar* key, const gchar* val);
gdouble spit_host_interface_get_config_double (SpitHostInterface* self, const gchar* key, gdouble def);
void spit_host_interface_set_config_double (SpitHostInterface* self, const gchar* key, gdouble val);
void spit_host_interface_unset_config_key (SpitHostInterface* self, const gchar* key);
void spit_host_interface_reserved0 (SpitHostInterface* self);
static void spit_host_interface_real_reserved0 (SpitHostInterface* self);
void spit_host_interface_reserved1 (SpitHostInterface* self);
static void spit_host_interface_real_reserved1 (SpitHostInterface* self);
void spit_host_interface_reserved2 (SpitHostInterface* self);
static void spit_host_interface_real_reserved2 (SpitHostInterface* self);
void spit_host_interface_reserved3 (SpitHostInterface* self);
static void spit_host_interface_real_reserved3 (SpitHostInterface* self);
void spit_host_interface_reserved4 (SpitHostInterface* self);
static void spit_host_interface_real_reserved4 (SpitHostInterface* self);
void spit_host_interface_reserved5 (SpitHostInterface* self);
static void spit_host_interface_real_reserved5 (SpitHostInterface* self);
void spit_host_interface_reserved6 (SpitHostInterface* self);
static void spit_host_interface_real_reserved6 (SpitHostInterface* self);
void spit_host_interface_reserved7 (SpitHostInterface* self);
static void spit_host_interface_real_reserved7 (SpitHostInterface* self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
 * A utility function for checking host interfaces against one's own and returning the right value.
 *
 * Note that this only works if the caller operates on only one interface version (and cannot mutate
 * between multiple ones).
 *
 * @param min_host_interface The minimum supported host interface version.
 * @param max_host_interface The maximum supported host interface version.
 * @param plugin_interface The interface version supported by the Pluggable.
 * 
 * @return The plugin's interface version if supported, {@link UNSUPPORTED_INTERFACE} otherwise.
 */
gint spit_negotiate_interfaces (gint min_host_interface, gint max_host_interface, gint plugin_interface) {
	gint result = 0;
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 47 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_tmp2_ = min_host_interface;
#line 47 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_tmp3_ = plugin_interface;
#line 47 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	if (_tmp2_ > _tmp3_) {
#line 47 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		_tmp1_ = TRUE;
#line 247 "SpitInterfaces.c"
	} else {
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
#line 47 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		_tmp4_ = max_host_interface;
#line 47 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		_tmp5_ = plugin_interface;
#line 47 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		_tmp1_ = _tmp4_ < _tmp5_;
#line 257 "SpitInterfaces.c"
	}
#line 47 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	if (_tmp1_) {
#line 48 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		_tmp0_ = SPIT_UNSUPPORTED_INTERFACE;
#line 263 "SpitInterfaces.c"
	} else {
		gint _tmp6_ = 0;
#line 48 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		_tmp6_ = plugin_interface;
#line 48 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		_tmp0_ = _tmp6_;
#line 270 "SpitInterfaces.c"
	}
#line 47 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	result = _tmp0_;
#line 47 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	return result;
#line 276 "SpitInterfaces.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 62 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	return self ? g_object_ref (self) : NULL;
#line 283 "SpitInterfaces.c"
}


void spit_entry_point_params_copy (const SpitEntryPointParams* self, SpitEntryPointParams* dest) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
#line 62 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_tmp0_ = (*self).host_min_spit_interface;
#line 62 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	(*dest).host_min_spit_interface = _tmp0_;
#line 62 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_tmp1_ = (*self).host_max_spit_interface;
#line 62 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	(*dest).host_max_spit_interface = _tmp1_;
#line 62 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_tmp2_ = (*self).module_spit_interface;
#line 62 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	(*dest).module_spit_interface = _tmp2_;
#line 62 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_tmp3_ = (*self).module_file;
#line 62 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 62 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_g_object_unref0 ((*dest).module_file);
#line 62 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	(*dest).module_file = _tmp4_;
#line 313 "SpitInterfaces.c"
}


void spit_entry_point_params_destroy (SpitEntryPointParams* self) {
#line 79 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_g_object_unref0 ((*self).module_file);
#line 320 "SpitInterfaces.c"
}


SpitEntryPointParams* spit_entry_point_params_dup (const SpitEntryPointParams* self) {
	SpitEntryPointParams* dup;
#line 62 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	dup = g_new0 (SpitEntryPointParams, 1);
#line 62 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	spit_entry_point_params_copy (self, dup);
#line 62 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	return dup;
#line 332 "SpitInterfaces.c"
}


void spit_entry_point_params_free (SpitEntryPointParams* self) {
#line 62 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	spit_entry_point_params_destroy (self);
#line 62 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_free (self);
#line 341 "SpitInterfaces.c"
}


GType spit_entry_point_params_get_type (void) {
	static volatile gsize spit_entry_point_params_type_id__volatile = 0;
	if (g_once_init_enter (&spit_entry_point_params_type_id__volatile)) {
		GType spit_entry_point_params_type_id;
		spit_entry_point_params_type_id = g_boxed_type_register_static ("SpitEntryPointParams", (GBoxedCopyFunc) spit_entry_point_params_dup, (GBoxedFreeFunc) spit_entry_point_params_free);
		g_once_init_leave (&spit_entry_point_params_type_id__volatile, spit_entry_point_params_type_id);
	}
	return spit_entry_point_params_type_id__volatile;
}


/**
     * Returns a user-visible string describing the module.
     */
const gchar* spit_module_get_module_name (SpitModule* self) {
#line 117 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_val_if_fail (SPIT_IS_MODULE (self), NULL);
#line 117 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	return SPIT_MODULE_GET_INTERFACE (self)->get_module_name (self);
#line 364 "SpitInterfaces.c"
}


/**
     * Returns a user-visible string describing the module version.
     * 
     * Note that this may be programmatically interpreted at some point, so use a widespread 
     * versioning scheme.
     */
const gchar* spit_module_get_version (SpitModule* self) {
#line 125 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_val_if_fail (SPIT_IS_MODULE (self), NULL);
#line 125 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	return SPIT_MODULE_GET_INTERFACE (self)->get_version (self);
#line 379 "SpitInterfaces.c"
}


/**
     * Returns a unique identifier for this module.
     * 
     * This is used to differentiate between multiple
     * installed versions and to determine which one should be used (i.e. if a module is available
     * in a system directory and a user directory). This name is case-sensitive.
     * 
     * Best practice: use a reverse-DNS-order scheme, a la Java's packages
     * (i.e. "org.yorba.shotwell.frotz").
     */
const gchar* spit_module_get_id (SpitModule* self) {
#line 137 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_val_if_fail (SPIT_IS_MODULE (self), NULL);
#line 137 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	return SPIT_MODULE_GET_INTERFACE (self)->get_id (self);
#line 398 "SpitInterfaces.c"
}


/**
     * Returns an array of {@link Pluggable} that represent each plugin available in the module.
     *
     * May return NULL or an empty array.
     */
SpitPluggable** spit_module_get_pluggables (SpitModule* self, int* result_length1) {
#line 144 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_val_if_fail (SPIT_IS_MODULE (self), NULL);
#line 144 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	return SPIT_MODULE_GET_INTERFACE (self)->get_pluggables (self, result_length1);
#line 412 "SpitInterfaces.c"
}


static void spit_module_real_reserved0 (SpitModule* self) {
}


void spit_module_reserved0 (SpitModule* self) {
#line 149 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_if_fail (SPIT_IS_MODULE (self));
#line 149 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	SPIT_MODULE_GET_INTERFACE (self)->reserved0 (self);
#line 425 "SpitInterfaces.c"
}


static void spit_module_real_reserved1 (SpitModule* self) {
}


void spit_module_reserved1 (SpitModule* self) {
#line 150 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_if_fail (SPIT_IS_MODULE (self));
#line 150 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	SPIT_MODULE_GET_INTERFACE (self)->reserved1 (self);
#line 438 "SpitInterfaces.c"
}


static void spit_module_real_reserved2 (SpitModule* self) {
}


void spit_module_reserved2 (SpitModule* self) {
#line 151 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_if_fail (SPIT_IS_MODULE (self));
#line 151 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	SPIT_MODULE_GET_INTERFACE (self)->reserved2 (self);
#line 451 "SpitInterfaces.c"
}


static void spit_module_real_reserved3 (SpitModule* self) {
}


void spit_module_reserved3 (SpitModule* self) {
#line 152 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_if_fail (SPIT_IS_MODULE (self));
#line 152 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	SPIT_MODULE_GET_INTERFACE (self)->reserved3 (self);
#line 464 "SpitInterfaces.c"
}


static void spit_module_real_reserved4 (SpitModule* self) {
}


void spit_module_reserved4 (SpitModule* self) {
#line 153 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_if_fail (SPIT_IS_MODULE (self));
#line 153 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	SPIT_MODULE_GET_INTERFACE (self)->reserved4 (self);
#line 477 "SpitInterfaces.c"
}


static void spit_module_real_reserved5 (SpitModule* self) {
}


void spit_module_reserved5 (SpitModule* self) {
#line 154 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_if_fail (SPIT_IS_MODULE (self));
#line 154 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	SPIT_MODULE_GET_INTERFACE (self)->reserved5 (self);
#line 490 "SpitInterfaces.c"
}


static void spit_module_real_reserved6 (SpitModule* self) {
}


void spit_module_reserved6 (SpitModule* self) {
#line 155 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_if_fail (SPIT_IS_MODULE (self));
#line 155 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	SPIT_MODULE_GET_INTERFACE (self)->reserved6 (self);
#line 503 "SpitInterfaces.c"
}


static void spit_module_real_reserved7 (SpitModule* self) {
}


void spit_module_reserved7 (SpitModule* self) {
#line 156 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_if_fail (SPIT_IS_MODULE (self));
#line 156 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	SPIT_MODULE_GET_INTERFACE (self)->reserved7 (self);
#line 516 "SpitInterfaces.c"
}


static void spit_module_base_init (SpitModuleIface * iface) {
#line 113 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	static gboolean initialized = FALSE;
#line 113 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	if (!initialized) {
#line 113 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		initialized = TRUE;
#line 113 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		iface->reserved0 = spit_module_real_reserved0;
#line 113 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		iface->reserved1 = spit_module_real_reserved1;
#line 113 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		iface->reserved2 = spit_module_real_reserved2;
#line 113 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		iface->reserved3 = spit_module_real_reserved3;
#line 113 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		iface->reserved4 = spit_module_real_reserved4;
#line 113 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		iface->reserved5 = spit_module_real_reserved5;
#line 113 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		iface->reserved6 = spit_module_real_reserved6;
#line 113 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		iface->reserved7 = spit_module_real_reserved7;
#line 543 "SpitInterfaces.c"
	}
}


/**
 * A Module represents the resources of an entire dynamically-linked module (i.e. a .so/.la).
 *
 * A module holds zero or more Shotwell plugins ({@link Pluggable}). Once the module has been
 * loaded into process space this object is retrieved by Shotwell. All calls to the module and
 * its plugins are resolved through this interface.
 *
 * Note: The module is responsible for holding the reference to the Module object, of which there
 * should be only one in the library file. The module should implement a g_module_unload method
 * and drop the reference there.
 */
GType spit_module_get_type (void) {
	static volatile gsize spit_module_type_id__volatile = 0;
	if (g_once_init_enter (&spit_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpitModuleIface), (GBaseInitFunc) spit_module_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType spit_module_type_id;
		spit_module_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitModule", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (spit_module_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&spit_module_type_id__volatile, spit_module_type_id);
	}
	return spit_module_type_id__volatile;
}


static GdkPixbuf** _vala_array_dup1 (GdkPixbuf** self, int length) {
	GdkPixbuf** result;
	int i;
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	result = g_new0 (GdkPixbuf*, length + 1);
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	for (i = 0; i < length; i++) {
#line 579 "SpitInterfaces.c"
		GdkPixbuf* _tmp0_ = NULL;
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		_tmp0_ = _g_object_ref0 (self[i]);
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		result[i] = _tmp0_;
#line 585 "SpitInterfaces.c"
	}
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	return result;
#line 589 "SpitInterfaces.c"
}


void spit_pluggable_info_copy (const SpitPluggableInfo* self, SpitPluggableInfo* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	GdkPixbuf** _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	GdkPixbuf** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_tmp0_ = (*self).version;
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_g_free0 ((*dest).version);
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	(*dest).version = _tmp1_;
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_tmp2_ = (*self).brief_description;
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_g_free0 ((*dest).brief_description);
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	(*dest).brief_description = _tmp3_;
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_tmp4_ = (*self).authors;
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_g_free0 ((*dest).authors);
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	(*dest).authors = _tmp5_;
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_tmp6_ = (*self).copyright;
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_g_free0 ((*dest).copyright);
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	(*dest).copyright = _tmp7_;
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_tmp8_ = (*self).license;
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_tmp9_ = g_strdup (_tmp8_);
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_g_free0 ((*dest).license);
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	(*dest).license = _tmp9_;
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_tmp10_ = (*self).is_license_wordwrapped;
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	(*dest).is_license_wordwrapped = _tmp10_;
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_tmp11_ = (*self).website_url;
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_tmp12_ = g_strdup (_tmp11_);
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_g_free0 ((*dest).website_url);
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	(*dest).website_url = _tmp12_;
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_tmp13_ = (*self).website_name;
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_tmp14_ = g_strdup (_tmp13_);
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_g_free0 ((*dest).website_name);
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	(*dest).website_name = _tmp14_;
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_tmp15_ = (*self).translators;
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_tmp16_ = g_strdup (_tmp15_);
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_g_free0 ((*dest).translators);
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	(*dest).translators = _tmp16_;
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_tmp17_ = (*self).icons;
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_tmp17__length1 = (*self).icons_length1;
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_tmp18_ = (_tmp17_ != NULL) ? _vala_array_dup1 (_tmp17_, _tmp17__length1) : ((gpointer) _tmp17_);
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_tmp18__length1 = _tmp17__length1;
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	(*dest).icons = (_vala_array_free ((*dest).icons, (*dest).icons_length1, (GDestroyNotify) g_object_unref), NULL);
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	(*dest).icons = _tmp18_;
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	(*dest).icons_length1 = _tmp18__length1;
#line 697 "SpitInterfaces.c"
}


void spit_pluggable_info_destroy (SpitPluggableInfo* self) {
#line 163 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_g_free0 ((*self).version);
#line 164 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_g_free0 ((*self).brief_description);
#line 168 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_g_free0 ((*self).authors);
#line 169 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_g_free0 ((*self).copyright);
#line 170 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_g_free0 ((*self).license);
#line 172 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_g_free0 ((*self).website_url);
#line 173 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_g_free0 ((*self).website_name);
#line 174 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	_g_free0 ((*self).translators);
#line 179 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	(*self).icons = (_vala_array_free ((*self).icons, (*self).icons_length1, (GDestroyNotify) g_object_unref), NULL);
#line 720 "SpitInterfaces.c"
}


SpitPluggableInfo* spit_pluggable_info_dup (const SpitPluggableInfo* self) {
	SpitPluggableInfo* dup;
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	dup = g_new0 (SpitPluggableInfo, 1);
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	spit_pluggable_info_copy (self, dup);
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	return dup;
#line 732 "SpitInterfaces.c"
}


void spit_pluggable_info_free (SpitPluggableInfo* self) {
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	spit_pluggable_info_destroy (self);
#line 162 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_free (self);
#line 741 "SpitInterfaces.c"
}


GType spit_pluggable_info_get_type (void) {
	static volatile gsize spit_pluggable_info_type_id__volatile = 0;
	if (g_once_init_enter (&spit_pluggable_info_type_id__volatile)) {
		GType spit_pluggable_info_type_id;
		spit_pluggable_info_type_id = g_boxed_type_register_static ("SpitPluggableInfo", (GBoxedCopyFunc) spit_pluggable_info_dup, (GBoxedFreeFunc) spit_pluggable_info_free);
		g_once_init_leave (&spit_pluggable_info_type_id__volatile, spit_pluggable_info_type_id);
	}
	return spit_pluggable_info_type_id__volatile;
}


/**
     * Pluggable interface version negotiation.
     *
     * Like the {@link EntryPoint}, this mechanism allows for the host to negotiate with the Pluggable
     * for its interface version. If the pluggable does not support an interface between the
     * two ranges (inclusive), it should return {@link UNSUPPORTED_INTERFACE}.
     *
     * Note that this is ''not'' a negotiation of the SPIT interface versions (which is the
     * responsibility of {@link EntryPoint}. Rather, each extension point is expected to version
     * its own cluster of interfaces. It is that interface version that is being negotiated here.
     *
     * {@link negotiate_interfaces} can be used to implement this method.
     *
     * @param min_host_interface The host's minimum supported interface version number
     *        //for this Pluggable's intended extension point//.
     * @param max_host_interface The host's maximum supported interface version number
     *        //for this Pluggable's intended extension point//.
     *
     * @return The version number supported by the host and the Pluggable or
     *         {@link UNSUPPORTED_INTERFACE}.
     */
gint spit_pluggable_get_pluggable_interface (SpitPluggable* self, gint min_host_interface, gint max_host_interface) {
#line 210 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_val_if_fail (SPIT_IS_PLUGGABLE (self), 0);
#line 210 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	return SPIT_PLUGGABLE_GET_INTERFACE (self)->get_pluggable_interface (self, min_host_interface, max_host_interface);
#line 782 "SpitInterfaces.c"
}


/**
     * Returns a unique identifier for this Pluggable.
     *
     * Like {@link Module.get_id}, best practice is to use a reverse-DNS-order scheme to avoid 
     * conflicts.
     */
const gchar* spit_pluggable_get_id (SpitPluggable* self) {
#line 218 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_val_if_fail (SPIT_IS_PLUGGABLE (self), NULL);
#line 218 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	return SPIT_PLUGGABLE_GET_INTERFACE (self)->get_id (self);
#line 797 "SpitInterfaces.c"
}


/**
     * Returns a user-visible name for the Pluggable.
     */
const gchar* spit_pluggable_get_pluggable_name (SpitPluggable* self) {
#line 223 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_val_if_fail (SPIT_IS_PLUGGABLE (self), NULL);
#line 223 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	return SPIT_PLUGGABLE_GET_INTERFACE (self)->get_pluggable_name (self);
#line 809 "SpitInterfaces.c"
}


/**
     * Returns extra information about the Pluggable that is used to identify it to the user.
     */
void spit_pluggable_get_info (SpitPluggable* self, SpitPluggableInfo* info) {
#line 228 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_if_fail (SPIT_IS_PLUGGABLE (self));
#line 228 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	SPIT_PLUGGABLE_GET_INTERFACE (self)->get_info (self, info);
#line 821 "SpitInterfaces.c"
}


/**
     * Called when the Pluggable is enabled (activated) or disabled (deactivated).
     *
     * activation will be called at the start of the program if the user previously 
     * enabled/disabled it as well as during program execution if the user changes its state. Note 
     * that disabling a Pluggable does not require destroying existing resources or objects 
     * the Pluggable has previously handed off to the host.
     *
     * This is purely informational. The Pluggable should acquire any long-term resources
     * it may be holding onto here, or wait until an extension-specific call is made to it.
     *
     * @param enabled ``true`` if the Pluggable has been enabled, ``false`` otherwise.
     */
void spit_pluggable_activation (SpitPluggable* self, gboolean enabled) {
#line 243 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_if_fail (SPIT_IS_PLUGGABLE (self));
#line 243 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	SPIT_PLUGGABLE_GET_INTERFACE (self)->activation (self, enabled);
#line 843 "SpitInterfaces.c"
}


static void spit_pluggable_real_reserved0 (SpitPluggable* self) {
}


void spit_pluggable_reserved0 (SpitPluggable* self) {
#line 248 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_if_fail (SPIT_IS_PLUGGABLE (self));
#line 248 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	SPIT_PLUGGABLE_GET_INTERFACE (self)->reserved0 (self);
#line 856 "SpitInterfaces.c"
}


static void spit_pluggable_real_reserved1 (SpitPluggable* self) {
}


void spit_pluggable_reserved1 (SpitPluggable* self) {
#line 249 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_if_fail (SPIT_IS_PLUGGABLE (self));
#line 249 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	SPIT_PLUGGABLE_GET_INTERFACE (self)->reserved1 (self);
#line 869 "SpitInterfaces.c"
}


static void spit_pluggable_real_reserved2 (SpitPluggable* self) {
}


void spit_pluggable_reserved2 (SpitPluggable* self) {
#line 250 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_if_fail (SPIT_IS_PLUGGABLE (self));
#line 250 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	SPIT_PLUGGABLE_GET_INTERFACE (self)->reserved2 (self);
#line 882 "SpitInterfaces.c"
}


static void spit_pluggable_real_reserved3 (SpitPluggable* self) {
}


void spit_pluggable_reserved3 (SpitPluggable* self) {
#line 251 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_if_fail (SPIT_IS_PLUGGABLE (self));
#line 251 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	SPIT_PLUGGABLE_GET_INTERFACE (self)->reserved3 (self);
#line 895 "SpitInterfaces.c"
}


static void spit_pluggable_real_reserved4 (SpitPluggable* self) {
}


void spit_pluggable_reserved4 (SpitPluggable* self) {
#line 252 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_if_fail (SPIT_IS_PLUGGABLE (self));
#line 252 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	SPIT_PLUGGABLE_GET_INTERFACE (self)->reserved4 (self);
#line 908 "SpitInterfaces.c"
}


static void spit_pluggable_real_reserved5 (SpitPluggable* self) {
}


void spit_pluggable_reserved5 (SpitPluggable* self) {
#line 253 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_if_fail (SPIT_IS_PLUGGABLE (self));
#line 253 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	SPIT_PLUGGABLE_GET_INTERFACE (self)->reserved5 (self);
#line 921 "SpitInterfaces.c"
}


static void spit_pluggable_real_reserved6 (SpitPluggable* self) {
}


void spit_pluggable_reserved6 (SpitPluggable* self) {
#line 254 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_if_fail (SPIT_IS_PLUGGABLE (self));
#line 254 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	SPIT_PLUGGABLE_GET_INTERFACE (self)->reserved6 (self);
#line 934 "SpitInterfaces.c"
}


static void spit_pluggable_real_reserved7 (SpitPluggable* self) {
}


void spit_pluggable_reserved7 (SpitPluggable* self) {
#line 255 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_if_fail (SPIT_IS_PLUGGABLE (self));
#line 255 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	SPIT_PLUGGABLE_GET_INTERFACE (self)->reserved7 (self);
#line 947 "SpitInterfaces.c"
}


static void spit_pluggable_base_init (SpitPluggableIface * iface) {
#line 188 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	static gboolean initialized = FALSE;
#line 188 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	if (!initialized) {
#line 188 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		initialized = TRUE;
#line 188 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		iface->reserved0 = spit_pluggable_real_reserved0;
#line 188 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		iface->reserved1 = spit_pluggable_real_reserved1;
#line 188 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		iface->reserved2 = spit_pluggable_real_reserved2;
#line 188 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		iface->reserved3 = spit_pluggable_real_reserved3;
#line 188 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		iface->reserved4 = spit_pluggable_real_reserved4;
#line 188 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		iface->reserved5 = spit_pluggable_real_reserved5;
#line 188 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		iface->reserved6 = spit_pluggable_real_reserved6;
#line 188 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		iface->reserved7 = spit_pluggable_real_reserved7;
#line 974 "SpitInterfaces.c"
	}
}


/**
 * A generic interface to all Shotwell plugins.
 *
 * Each plugin in a module needs to implement this interface at a minimum. Extension
 * points may have (and probably will have) specific interface requirements as well.
 */
GType spit_pluggable_get_type (void) {
	static volatile gsize spit_pluggable_type_id__volatile = 0;
	if (g_once_init_enter (&spit_pluggable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpitPluggableIface), (GBaseInitFunc) spit_pluggable_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType spit_pluggable_type_id;
		spit_pluggable_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitPluggable", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (spit_pluggable_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&spit_pluggable_type_id__volatile, spit_pluggable_type_id);
	}
	return spit_pluggable_type_id__volatile;
}


/**
     * Returns a File object representing the library file (.so/la.) that the plugin was loaded
     * from.
     */
GFile* spit_host_interface_get_module_file (SpitHostInterface* self) {
#line 274 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_val_if_fail (SPIT_IS_HOST_INTERFACE (self), NULL);
#line 274 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	return SPIT_HOST_INTERFACE_GET_INTERFACE (self)->get_module_file (self);
#line 1007 "SpitInterfaces.c"
}


/**
     * Get a boolean from a persistent configuration store.
     *
     * @param key The name of the value to be retrieved.
     * @param def The default value (returned if the key has not been previously set).
     *
     * @return The value associated with key, def if not set.
     */
gboolean spit_host_interface_get_config_bool (SpitHostInterface* self, const gchar* key, gboolean def) {
#line 284 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_val_if_fail (SPIT_IS_HOST_INTERFACE (self), FALSE);
#line 284 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	return SPIT_HOST_INTERFACE_GET_INTERFACE (self)->get_config_bool (self, key, def);
#line 1024 "SpitInterfaces.c"
}


/**
     * Store a boolean in a persistent configuration store.
     *
     * @param key The name of the value to be stored.
     * @param val The value to be stored.
     */
void spit_host_interface_set_config_bool (SpitHostInterface* self, const gchar* key, gboolean val) {
#line 292 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_if_fail (SPIT_IS_HOST_INTERFACE (self));
#line 292 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	SPIT_HOST_INTERFACE_GET_INTERFACE (self)->set_config_bool (self, key, val);
#line 1039 "SpitInterfaces.c"
}


/**
     * Get an integer from a persistent configuration store.
     *
     * @param key The name of the value to be retrieved.
     * @param def The default value (returned if the key has not been previously set).
     *
     * @return The value associated with key, def if not set.
     */
gint spit_host_interface_get_config_int (SpitHostInterface* self, const gchar* key, gint def) {
#line 302 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_val_if_fail (SPIT_IS_HOST_INTERFACE (self), 0);
#line 302 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	return SPIT_HOST_INTERFACE_GET_INTERFACE (self)->get_config_int (self, key, def);
#line 1056 "SpitInterfaces.c"
}


/**
     * Store an integer in a persistent configuration store.
     *
     * @param key The name of the value to be stored.
     * @param val The value to be stored.
     */
void spit_host_interface_set_config_int (SpitHostInterface* self, const gchar* key, gint val) {
#line 310 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_if_fail (SPIT_IS_HOST_INTERFACE (self));
#line 310 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	SPIT_HOST_INTERFACE_GET_INTERFACE (self)->set_config_int (self, key, val);
#line 1071 "SpitInterfaces.c"
}


/**
     * Get a string from a persistent configuration store.
     *
     * @param key The name of the value to be retrieved.
     * @param def The default value (returned if the key has not been previously set).
     *
     * @return The value associated with key, def if not set.
     */
gchar* spit_host_interface_get_config_string (SpitHostInterface* self, const gchar* key, const gchar* def) {
#line 320 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_val_if_fail (SPIT_IS_HOST_INTERFACE (self), NULL);
#line 320 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	return SPIT_HOST_INTERFACE_GET_INTERFACE (self)->get_config_string (self, key, def);
#line 1088 "SpitInterfaces.c"
}


/**
     * Store a string in a persistent configuration store.
     *
     * @param key The name of the value to be stored.
     * @param val The value to be stored.
     */
void spit_host_interface_set_config_string (SpitHostInterface* self, const gchar* key, const gchar* val) {
#line 328 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_if_fail (SPIT_IS_HOST_INTERFACE (self));
#line 328 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	SPIT_HOST_INTERFACE_GET_INTERFACE (self)->set_config_string (self, key, val);
#line 1103 "SpitInterfaces.c"
}


/**
     * Get a double from a persistent configuration store.
     *
     * @param key The name of the value to be retrieved.
     * @param def The default value (returned if the key has not been previously set).
     *
     * @return The value associated with key, def if not set.
     */
gdouble spit_host_interface_get_config_double (SpitHostInterface* self, const gchar* key, gdouble def) {
#line 338 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_val_if_fail (SPIT_IS_HOST_INTERFACE (self), 0.0);
#line 338 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	return SPIT_HOST_INTERFACE_GET_INTERFACE (self)->get_config_double (self, key, def);
#line 1120 "SpitInterfaces.c"
}


/**
     * Store a double in a persistent configuration store.
     *
     * @param key The name of the value to be stored.
     * @param val The value to be stored.
     */
void spit_host_interface_set_config_double (SpitHostInterface* self, const gchar* key, gdouble val) {
#line 346 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_if_fail (SPIT_IS_HOST_INTERFACE (self));
#line 346 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	SPIT_HOST_INTERFACE_GET_INTERFACE (self)->set_config_double (self, key, val);
#line 1135 "SpitInterfaces.c"
}


/**
     * Delete the value from the persistent configuration store.
     */
void spit_host_interface_unset_config_key (SpitHostInterface* self, const gchar* key) {
#line 351 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_if_fail (SPIT_IS_HOST_INTERFACE (self));
#line 351 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	SPIT_HOST_INTERFACE_GET_INTERFACE (self)->unset_config_key (self, key);
#line 1147 "SpitInterfaces.c"
}


static void spit_host_interface_real_reserved0 (SpitHostInterface* self) {
}


void spit_host_interface_reserved0 (SpitHostInterface* self) {
#line 356 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_if_fail (SPIT_IS_HOST_INTERFACE (self));
#line 356 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	SPIT_HOST_INTERFACE_GET_INTERFACE (self)->reserved0 (self);
#line 1160 "SpitInterfaces.c"
}


static void spit_host_interface_real_reserved1 (SpitHostInterface* self) {
}


void spit_host_interface_reserved1 (SpitHostInterface* self) {
#line 357 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_if_fail (SPIT_IS_HOST_INTERFACE (self));
#line 357 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	SPIT_HOST_INTERFACE_GET_INTERFACE (self)->reserved1 (self);
#line 1173 "SpitInterfaces.c"
}


static void spit_host_interface_real_reserved2 (SpitHostInterface* self) {
}


void spit_host_interface_reserved2 (SpitHostInterface* self) {
#line 358 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_if_fail (SPIT_IS_HOST_INTERFACE (self));
#line 358 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	SPIT_HOST_INTERFACE_GET_INTERFACE (self)->reserved2 (self);
#line 1186 "SpitInterfaces.c"
}


static void spit_host_interface_real_reserved3 (SpitHostInterface* self) {
}


void spit_host_interface_reserved3 (SpitHostInterface* self) {
#line 359 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_if_fail (SPIT_IS_HOST_INTERFACE (self));
#line 359 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	SPIT_HOST_INTERFACE_GET_INTERFACE (self)->reserved3 (self);
#line 1199 "SpitInterfaces.c"
}


static void spit_host_interface_real_reserved4 (SpitHostInterface* self) {
}


void spit_host_interface_reserved4 (SpitHostInterface* self) {
#line 360 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_if_fail (SPIT_IS_HOST_INTERFACE (self));
#line 360 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	SPIT_HOST_INTERFACE_GET_INTERFACE (self)->reserved4 (self);
#line 1212 "SpitInterfaces.c"
}


static void spit_host_interface_real_reserved5 (SpitHostInterface* self) {
}


void spit_host_interface_reserved5 (SpitHostInterface* self) {
#line 361 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_if_fail (SPIT_IS_HOST_INTERFACE (self));
#line 361 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	SPIT_HOST_INTERFACE_GET_INTERFACE (self)->reserved5 (self);
#line 1225 "SpitInterfaces.c"
}


static void spit_host_interface_real_reserved6 (SpitHostInterface* self) {
}


void spit_host_interface_reserved6 (SpitHostInterface* self) {
#line 362 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_if_fail (SPIT_IS_HOST_INTERFACE (self));
#line 362 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	SPIT_HOST_INTERFACE_GET_INTERFACE (self)->reserved6 (self);
#line 1238 "SpitInterfaces.c"
}


static void spit_host_interface_real_reserved7 (SpitHostInterface* self) {
}


void spit_host_interface_reserved7 (SpitHostInterface* self) {
#line 363 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	g_return_if_fail (SPIT_IS_HOST_INTERFACE (self));
#line 363 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	SPIT_HOST_INTERFACE_GET_INTERFACE (self)->reserved7 (self);
#line 1251 "SpitInterfaces.c"
}


static void spit_host_interface_base_init (SpitHostInterfaceIface * iface) {
#line 269 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	static gboolean initialized = FALSE;
#line 269 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
	if (!initialized) {
#line 269 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		initialized = TRUE;
#line 269 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		iface->reserved0 = spit_host_interface_real_reserved0;
#line 269 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		iface->reserved1 = spit_host_interface_real_reserved1;
#line 269 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		iface->reserved2 = spit_host_interface_real_reserved2;
#line 269 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		iface->reserved3 = spit_host_interface_real_reserved3;
#line 269 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		iface->reserved4 = spit_host_interface_real_reserved4;
#line 269 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		iface->reserved5 = spit_host_interface_real_reserved5;
#line 269 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		iface->reserved6 = spit_host_interface_real_reserved6;
#line 269 "/home/jens/Source/shotwell/src/plugins/SpitInterfaces.vala"
		iface->reserved7 = spit_host_interface_real_reserved7;
#line 1278 "SpitInterfaces.c"
	}
}


/**
 * An interface to common services supplied by the host (Shotwell).
 *
 * Each {@link Pluggable} is offered a HostInterface for needs common to most plugins.
 * 
 * Note that
 * a HostInterface is not explicitly handed to the Pluggable through the SPIT interface, but is expected 
 * to be offered to the Pluggable through an interface applicable to the extension point. This 
 * also allows the extension point to extend HostInterface to offer other services applicable to the
 * type of plugin.
 */
GType spit_host_interface_get_type (void) {
	static volatile gsize spit_host_interface_type_id__volatile = 0;
	if (g_once_init_enter (&spit_host_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpitHostInterfaceIface), (GBaseInitFunc) spit_host_interface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType spit_host_interface_type_id;
		spit_host_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitHostInterface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (spit_host_interface_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&spit_host_interface_type_id__volatile, spit_host_interface_type_id);
	}
	return spit_host_interface_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



