/* TombstoneTable.c generated by valac 0.34.1, the Vala compiler
 * generated from TombstoneTable.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <sqlite3.h>
#include <gobject/gvaluecollector.h>


#define TYPE_TOMBSTONE_ID (tombstone_id_get_type ())
typedef struct _TombstoneID TombstoneID;

#define TYPE_TOMBSTONE_ROW (tombstone_row_get_type ())
#define TOMBSTONE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TOMBSTONE_ROW, TombstoneRow))
#define TOMBSTONE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TOMBSTONE_ROW, TombstoneRowClass))
#define IS_TOMBSTONE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TOMBSTONE_ROW))
#define IS_TOMBSTONE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TOMBSTONE_ROW))
#define TOMBSTONE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TOMBSTONE_ROW, TombstoneRowClass))

typedef struct _TombstoneRow TombstoneRow;
typedef struct _TombstoneRowClass TombstoneRowClass;
typedef struct _TombstoneRowPrivate TombstoneRowPrivate;

#define TOMBSTONE_TYPE_REASON (tombstone_reason_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecTombstoneRow ParamSpecTombstoneRow;

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;
typedef struct _DatabaseTablePrivate DatabaseTablePrivate;

#define TYPE_TOMBSTONE_TABLE (tombstone_table_get_type ())
#define TOMBSTONE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TOMBSTONE_TABLE, TombstoneTable))
#define TOMBSTONE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TOMBSTONE_TABLE, TombstoneTableClass))
#define IS_TOMBSTONE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TOMBSTONE_TABLE))
#define IS_TOMBSTONE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TOMBSTONE_TABLE))
#define TOMBSTONE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TOMBSTONE_TABLE, TombstoneTableClass))

typedef struct _TombstoneTable TombstoneTable;
typedef struct _TombstoneTableClass TombstoneTableClass;
typedef struct _TombstoneTablePrivate TombstoneTablePrivate;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _tombstone_row_unref0(var) ((var == NULL) ? NULL : (var = (tombstone_row_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TombstoneID {
	gint64 id;
};

typedef enum  {
	TOMBSTONE_REASON_REMOVED_BY_USER = 0,
	TOMBSTONE_REASON_AUTO_DETECTED_DUPLICATE = 1
} TombstoneReason;

struct _TombstoneRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TombstoneRowPrivate * priv;
	TombstoneID id;
	gchar* filepath;
	gint64 filesize;
	gchar* md5;
	time_t time_created;
	TombstoneReason reason;
};

struct _TombstoneRowClass {
	GTypeClass parent_class;
	void (*finalize) (TombstoneRow *self);
};

struct _ParamSpecTombstoneRow {
	GParamSpec parent_instance;
};

struct _DatabaseTable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DatabaseTablePrivate * priv;
	gchar* table_name;
};

struct _DatabaseTableClass {
	GTypeClass parent_class;
	void (*finalize) (DatabaseTable *self);
};

struct _TombstoneTable {
	DatabaseTable parent_instance;
	TombstoneTablePrivate * priv;
};

struct _TombstoneTableClass {
	DatabaseTableClass parent_class;
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()

static gpointer tombstone_row_parent_class = NULL;
static gpointer tombstone_table_parent_class = NULL;
static TombstoneTable* tombstone_table_instance;
static TombstoneTable* tombstone_table_instance = NULL;
extern sqlite3* database_table_db;

GType tombstone_id_get_type (void) G_GNUC_CONST;
TombstoneID* tombstone_id_dup (const TombstoneID* self);
void tombstone_id_free (TombstoneID* self);
#define TOMBSTONE_ID_INVALID ((gint64) -1)
void tombstone_id_init (TombstoneID *self, gint64 id);
gboolean tombstone_id_is_invalid (TombstoneID *self);
gboolean tombstone_id_is_valid (TombstoneID *self);
gpointer tombstone_row_ref (gpointer instance);
void tombstone_row_unref (gpointer instance);
GParamSpec* param_spec_tombstone_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_tombstone_row (GValue* value, gpointer v_object);
void value_take_tombstone_row (GValue* value, gpointer v_object);
gpointer value_get_tombstone_row (const GValue* value);
GType tombstone_row_get_type (void) G_GNUC_CONST;
GType tombstone_reason_get_type (void) G_GNUC_CONST;
enum  {
	TOMBSTONE_ROW_DUMMY_PROPERTY
};
TombstoneRow* tombstone_row_new (void);
TombstoneRow* tombstone_row_construct (GType object_type);
static void tombstone_row_finalize (TombstoneRow* obj);
gpointer database_table_ref (gpointer instance);
void database_table_unref (gpointer instance);
GParamSpec* param_spec_database_table (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_database_table (GValue* value, gpointer v_object);
void value_take_database_table (GValue* value, gpointer v_object);
gpointer value_get_database_table (const GValue* value);
GType database_table_get_type (void) G_GNUC_CONST;
GType tombstone_table_get_type (void) G_GNUC_CONST;
enum  {
	TOMBSTONE_TABLE_DUMMY_PROPERTY
};
static TombstoneTable* tombstone_table_new (void);
static TombstoneTable* tombstone_table_construct (GType object_type);
DatabaseTable* database_table_construct (GType object_type);
void database_table_set_table_name (DatabaseTable* self, const gchar* table_name);
void database_table_fatal (const gchar* op, gint res);
TombstoneTable* tombstone_table_get_instance (void);
GQuark database_error_quark (void);
TombstoneRow* tombstone_table_add (TombstoneTable* self, const gchar* filepath, gint64 filesize, const gchar* md5, TombstoneReason reason, GError** error);
gulong now_sec (void);
gint tombstone_reason_serialize (TombstoneReason self);
void database_table_throw_error (const gchar* method, gint res, GError** error);
TombstoneRow** tombstone_table_fetch_all (TombstoneTable* self, int* result_length1, GError** error);
gint database_table_get_row_count (DatabaseTable* self);
TombstoneReason tombstone_reason_unserialize (gint value);
void tombstone_table_update_file (TombstoneTable* self, TombstoneID* tombstone_id, const gchar* filepath, GError** error);
void database_table_update_text_by_id_2 (DatabaseTable* self, gint64 id, const gchar* column, const gchar* text, GError** error);
void tombstone_table_remove (TombstoneTable* self, TombstoneID* tombstone_id, GError** error);
void database_table_delete_by_id (DatabaseTable* self, gint64 id, GError** error);
static void tombstone_table_finalize (DatabaseTable* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


void tombstone_id_init (TombstoneID *self, gint64 id) {
	gint64 _tmp0_ = 0LL;
#line 12 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	memset (self, 0, sizeof (TombstoneID));
#line 13 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp0_ = id;
#line 13 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	(*self).id = _tmp0_;
#line 197 "TombstoneTable.c"
}


gboolean tombstone_id_is_invalid (TombstoneID *self) {
	gboolean result = FALSE;
	gint64 _tmp0_ = 0LL;
#line 17 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp0_ = (*self).id;
#line 17 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	result = _tmp0_ == TOMBSTONE_ID_INVALID;
#line 17 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	return result;
#line 210 "TombstoneTable.c"
}


gboolean tombstone_id_is_valid (TombstoneID *self) {
	gboolean result = FALSE;
	gint64 _tmp0_ = 0LL;
#line 21 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp0_ = (*self).id;
#line 21 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	result = _tmp0_ != TOMBSTONE_ID_INVALID;
#line 21 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	return result;
#line 223 "TombstoneTable.c"
}


TombstoneID* tombstone_id_dup (const TombstoneID* self) {
	TombstoneID* dup;
#line 7 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	dup = g_new0 (TombstoneID, 1);
#line 7 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	memcpy (dup, self, sizeof (TombstoneID));
#line 7 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	return dup;
#line 235 "TombstoneTable.c"
}


void tombstone_id_free (TombstoneID* self) {
#line 7 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	g_free (self);
#line 242 "TombstoneTable.c"
}


GType tombstone_id_get_type (void) {
	static volatile gsize tombstone_id_type_id__volatile = 0;
	if (g_once_init_enter (&tombstone_id_type_id__volatile)) {
		GType tombstone_id_type_id;
		tombstone_id_type_id = g_boxed_type_register_static ("TombstoneID", (GBoxedCopyFunc) tombstone_id_dup, (GBoxedFreeFunc) tombstone_id_free);
		g_once_init_leave (&tombstone_id_type_id__volatile, tombstone_id_type_id);
	}
	return tombstone_id_type_id__volatile;
}


TombstoneRow* tombstone_row_construct (GType object_type) {
	TombstoneRow* self = NULL;
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	self = (TombstoneRow*) g_type_create_instance (object_type);
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	return self;
#line 263 "TombstoneTable.c"
}


TombstoneRow* tombstone_row_new (void) {
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	return tombstone_row_construct (TYPE_TOMBSTONE_ROW);
#line 270 "TombstoneTable.c"
}


static void value_tombstone_row_init (GValue* value) {
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	value->data[0].v_pointer = NULL;
#line 277 "TombstoneTable.c"
}


static void value_tombstone_row_free_value (GValue* value) {
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	if (value->data[0].v_pointer) {
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		tombstone_row_unref (value->data[0].v_pointer);
#line 286 "TombstoneTable.c"
	}
}


static void value_tombstone_row_copy_value (const GValue* src_value, GValue* dest_value) {
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	if (src_value->data[0].v_pointer) {
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		dest_value->data[0].v_pointer = tombstone_row_ref (src_value->data[0].v_pointer);
#line 296 "TombstoneTable.c"
	} else {
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		dest_value->data[0].v_pointer = NULL;
#line 300 "TombstoneTable.c"
	}
}


static gpointer value_tombstone_row_peek_pointer (const GValue* value) {
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	return value->data[0].v_pointer;
#line 308 "TombstoneTable.c"
}


static gchar* value_tombstone_row_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	if (collect_values[0].v_pointer) {
#line 315 "TombstoneTable.c"
		TombstoneRow* object;
		object = collect_values[0].v_pointer;
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		if (object->parent_instance.g_class == NULL) {
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 322 "TombstoneTable.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 326 "TombstoneTable.c"
		}
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		value->data[0].v_pointer = tombstone_row_ref (object);
#line 330 "TombstoneTable.c"
	} else {
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		value->data[0].v_pointer = NULL;
#line 334 "TombstoneTable.c"
	}
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	return NULL;
#line 338 "TombstoneTable.c"
}


static gchar* value_tombstone_row_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TombstoneRow** object_p;
	object_p = collect_values[0].v_pointer;
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	if (!object_p) {
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 349 "TombstoneTable.c"
	}
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	if (!value->data[0].v_pointer) {
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		*object_p = NULL;
#line 355 "TombstoneTable.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		*object_p = value->data[0].v_pointer;
#line 359 "TombstoneTable.c"
	} else {
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		*object_p = tombstone_row_ref (value->data[0].v_pointer);
#line 363 "TombstoneTable.c"
	}
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	return NULL;
#line 367 "TombstoneTable.c"
}


GParamSpec* param_spec_tombstone_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecTombstoneRow* spec;
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TOMBSTONE_ROW), NULL);
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	return G_PARAM_SPEC (spec);
#line 381 "TombstoneTable.c"
}


gpointer value_get_tombstone_row (const GValue* value) {
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TOMBSTONE_ROW), NULL);
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	return value->data[0].v_pointer;
#line 390 "TombstoneTable.c"
}


void value_set_tombstone_row (GValue* value, gpointer v_object) {
	TombstoneRow* old;
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TOMBSTONE_ROW));
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	old = value->data[0].v_pointer;
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	if (v_object) {
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TOMBSTONE_ROW));
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		value->data[0].v_pointer = v_object;
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		tombstone_row_ref (value->data[0].v_pointer);
#line 410 "TombstoneTable.c"
	} else {
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		value->data[0].v_pointer = NULL;
#line 414 "TombstoneTable.c"
	}
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	if (old) {
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		tombstone_row_unref (old);
#line 420 "TombstoneTable.c"
	}
}


void value_take_tombstone_row (GValue* value, gpointer v_object) {
	TombstoneRow* old;
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TOMBSTONE_ROW));
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	old = value->data[0].v_pointer;
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	if (v_object) {
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TOMBSTONE_ROW));
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		value->data[0].v_pointer = v_object;
#line 439 "TombstoneTable.c"
	} else {
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		value->data[0].v_pointer = NULL;
#line 443 "TombstoneTable.c"
	}
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	if (old) {
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		tombstone_row_unref (old);
#line 449 "TombstoneTable.c"
	}
}


static void tombstone_row_class_init (TombstoneRowClass * klass) {
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	tombstone_row_parent_class = g_type_class_peek_parent (klass);
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	((TombstoneRowClass *) klass)->finalize = tombstone_row_finalize;
#line 459 "TombstoneTable.c"
}


static void tombstone_row_instance_init (TombstoneRow * self) {
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	self->ref_count = 1;
#line 466 "TombstoneTable.c"
}


static void tombstone_row_finalize (TombstoneRow* obj) {
	TombstoneRow * self;
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TOMBSTONE_ROW, TombstoneRow);
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	g_signal_handlers_destroy (self);
#line 27 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_g_free0 (self->filepath);
#line 29 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_g_free0 (self->md5);
#line 480 "TombstoneTable.c"
}


GType tombstone_row_get_type (void) {
	static volatile gsize tombstone_row_type_id__volatile = 0;
	if (g_once_init_enter (&tombstone_row_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_tombstone_row_init, value_tombstone_row_free_value, value_tombstone_row_copy_value, value_tombstone_row_peek_pointer, "p", value_tombstone_row_collect_value, "p", value_tombstone_row_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TombstoneRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tombstone_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TombstoneRow), 0, (GInstanceInitFunc) tombstone_row_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tombstone_row_type_id;
		tombstone_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TombstoneRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tombstone_row_type_id__volatile, tombstone_row_type_id);
	}
	return tombstone_row_type_id__volatile;
}


gpointer tombstone_row_ref (gpointer instance) {
	TombstoneRow* self;
	self = instance;
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	g_atomic_int_inc (&self->ref_count);
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	return instance;
#line 505 "TombstoneTable.c"
}


void tombstone_row_unref (gpointer instance) {
	TombstoneRow* self;
	self = instance;
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		TOMBSTONE_ROW_GET_CLASS (self)->finalize (self);
#line 25 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 518 "TombstoneTable.c"
	}
}


static TombstoneTable* tombstone_table_construct (GType object_type) {
	TombstoneTable* self = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
#line 37 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	self = (TombstoneTable*) database_table_construct (object_type);
#line 38 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	database_table_set_table_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), "TombstoneTable");
#line 41 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp0_ = database_table_db;
#line 41 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "CREATE TABLE IF NOT EXISTS " "TombstoneTable " "(" "id INTEGER PRIMARY KEY, " "filepath TEXT NOT NULL, " "filesize INTEGER, " "md5 TEXT, " "time_created INTEGER, " "reason INTEGER DEFAULT 0 " ")", -1, &_tmp1_, NULL);
#line 41 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_sqlite3_finalize0 (stmt);
#line 41 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	stmt = _tmp1_;
#line 41 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	res = _tmp2_;
#line 51 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp3_ = res;
#line 51 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 53 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp4_ = stmt;
#line 53 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp5_ = sqlite3_step (_tmp4_);
#line 53 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	res = _tmp5_;
#line 54 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp6_ = res;
#line 54 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	if (_tmp6_ != SQLITE_DONE) {
#line 562 "TombstoneTable.c"
		gint _tmp7_ = 0;
#line 55 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		_tmp7_ = res;
#line 55 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		database_table_fatal ("create TombstoneTable", _tmp7_);
#line 568 "TombstoneTable.c"
	}
#line 37 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_sqlite3_finalize0 (stmt);
#line 37 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	return self;
#line 574 "TombstoneTable.c"
}


static TombstoneTable* tombstone_table_new (void) {
#line 37 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	return tombstone_table_construct (TYPE_TOMBSTONE_TABLE);
#line 581 "TombstoneTable.c"
}


static gpointer _database_table_ref0 (gpointer self) {
#line 62 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	return self ? database_table_ref (self) : NULL;
#line 588 "TombstoneTable.c"
}


TombstoneTable* tombstone_table_get_instance (void) {
	TombstoneTable* result = NULL;
	TombstoneTable* _tmp0_ = NULL;
	TombstoneTable* _tmp2_ = NULL;
	TombstoneTable* _tmp3_ = NULL;
#line 59 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp0_ = tombstone_table_instance;
#line 59 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	if (_tmp0_ == NULL) {
#line 601 "TombstoneTable.c"
		TombstoneTable* _tmp1_ = NULL;
#line 60 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		_tmp1_ = tombstone_table_new ();
#line 60 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		_database_table_unref0 (tombstone_table_instance);
#line 60 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		tombstone_table_instance = _tmp1_;
#line 609 "TombstoneTable.c"
	}
#line 62 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp2_ = tombstone_table_instance;
#line 62 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp3_ = _database_table_ref0 (_tmp2_);
#line 62 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	result = _tmp3_;
#line 62 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	return result;
#line 619 "TombstoneTable.c"
}


TombstoneRow* tombstone_table_add (TombstoneTable* self, const gchar* filepath, gint64 filesize, const gchar* md5, TombstoneReason reason, GError** error) {
	TombstoneRow* result = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	time_t time_created = 0;
	gulong _tmp4_ = 0UL;
	sqlite3_stmt* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GDestroyNotify _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	sqlite3_stmt* _tmp11_ = NULL;
	gint64 _tmp12_ = 0LL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	sqlite3_stmt* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	GDestroyNotify _tmp18_ = NULL;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	sqlite3_stmt* _tmp21_ = NULL;
	time_t _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	sqlite3_stmt* _tmp25_ = NULL;
	TombstoneReason _tmp26_ = 0;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	sqlite3_stmt* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	TombstoneRow* row = NULL;
	TombstoneRow* _tmp34_ = NULL;
	TombstoneRow* _tmp35_ = NULL;
	sqlite3* _tmp36_ = NULL;
	gint64 _tmp37_ = 0LL;
	TombstoneRow* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	TombstoneRow* _tmp41_ = NULL;
	gint64 _tmp42_ = 0LL;
	TombstoneRow* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	TombstoneRow* _tmp46_ = NULL;
	time_t _tmp47_ = 0;
	TombstoneRow* _tmp48_ = NULL;
	TombstoneReason _tmp49_ = 0;
	GError * _inner_error_ = NULL;
#line 65 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	g_return_val_if_fail (IS_TOMBSTONE_TABLE (self), NULL);
#line 65 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	g_return_val_if_fail (filepath != NULL, NULL);
#line 68 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp0_ = database_table_db;
#line 68 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "INSERT INTO TombstoneTable " "(filepath, filesize, md5, time_created, reason) " "VALUES (?, ?, ?, ?, ?)", -1, &_tmp1_, NULL);
#line 68 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_sqlite3_finalize0 (stmt);
#line 68 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	stmt = _tmp1_;
#line 68 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	res = _tmp2_;
#line 72 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp3_ = res;
#line 72 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 74 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp4_ = now_sec ();
#line 74 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	time_created = (time_t) _tmp4_;
#line 76 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp5_ = stmt;
#line 76 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp6_ = filepath;
#line 76 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 76 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp8_ = g_free;
#line 76 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp9_ = sqlite3_bind_text (_tmp5_, 1, _tmp7_, -1, _tmp8_);
#line 76 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	res = _tmp9_;
#line 77 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp10_ = res;
#line 77 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_vala_assert (_tmp10_ == SQLITE_OK, "res == Sqlite.OK");
#line 78 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp11_ = stmt;
#line 78 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp12_ = filesize;
#line 78 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp13_ = sqlite3_bind_int64 (_tmp11_, 2, _tmp12_);
#line 78 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	res = _tmp13_;
#line 79 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp14_ = res;
#line 79 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_vala_assert (_tmp14_ == SQLITE_OK, "res == Sqlite.OK");
#line 80 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp15_ = stmt;
#line 80 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp16_ = md5;
#line 80 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp17_ = g_strdup (_tmp16_);
#line 80 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp18_ = g_free;
#line 80 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp19_ = sqlite3_bind_text (_tmp15_, 3, _tmp17_, -1, _tmp18_);
#line 80 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	res = _tmp19_;
#line 81 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp20_ = res;
#line 81 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_vala_assert (_tmp20_ == SQLITE_OK, "res == Sqlite.OK");
#line 82 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp21_ = stmt;
#line 82 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp22_ = time_created;
#line 82 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp23_ = sqlite3_bind_int64 (_tmp21_, 4, (gint64) _tmp22_);
#line 82 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	res = _tmp23_;
#line 83 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp24_ = res;
#line 83 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_vala_assert (_tmp24_ == SQLITE_OK, "res == Sqlite.OK");
#line 84 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp25_ = stmt;
#line 84 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp26_ = reason;
#line 84 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp27_ = tombstone_reason_serialize (_tmp26_);
#line 84 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp28_ = sqlite3_bind_int (_tmp25_, 5, _tmp27_);
#line 84 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	res = _tmp28_;
#line 85 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp29_ = res;
#line 85 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_vala_assert (_tmp29_ == SQLITE_OK, "res == Sqlite.OK");
#line 87 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp30_ = stmt;
#line 87 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp31_ = sqlite3_step (_tmp30_);
#line 87 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	res = _tmp31_;
#line 88 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp32_ = res;
#line 88 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	if (_tmp32_ != SQLITE_DONE) {
#line 781 "TombstoneTable.c"
		gint _tmp33_ = 0;
#line 89 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		_tmp33_ = res;
#line 89 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		database_table_throw_error ("TombstoneTable.add", _tmp33_, &_inner_error_);
#line 89 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 89 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 89 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
				g_propagate_error (error, _inner_error_);
#line 89 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
				_sqlite3_finalize0 (stmt);
#line 89 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
				return NULL;
#line 797 "TombstoneTable.c"
			} else {
#line 89 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
				_sqlite3_finalize0 (stmt);
#line 89 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 89 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
				g_clear_error (&_inner_error_);
#line 89 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
				return NULL;
#line 807 "TombstoneTable.c"
			}
		}
	}
#line 91 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp34_ = tombstone_row_new ();
#line 91 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	row = _tmp34_;
#line 92 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp35_ = row;
#line 92 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp36_ = database_table_db;
#line 92 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp37_ = sqlite3_last_insert_rowid (_tmp36_);
#line 92 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	tombstone_id_init (&_tmp35_->id, _tmp37_);
#line 93 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp38_ = row;
#line 93 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp39_ = filepath;
#line 93 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp40_ = g_strdup (_tmp39_);
#line 93 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_g_free0 (_tmp38_->filepath);
#line 93 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp38_->filepath = _tmp40_;
#line 94 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp41_ = row;
#line 94 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp42_ = filesize;
#line 94 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp41_->filesize = _tmp42_;
#line 95 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp43_ = row;
#line 95 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp44_ = md5;
#line 95 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp45_ = g_strdup (_tmp44_);
#line 95 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_g_free0 (_tmp43_->md5);
#line 95 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp43_->md5 = _tmp45_;
#line 96 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp46_ = row;
#line 96 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp47_ = time_created;
#line 96 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp46_->time_created = _tmp47_;
#line 97 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp48_ = row;
#line 97 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp49_ = reason;
#line 97 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp48_->reason = _tmp49_;
#line 99 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	result = row;
#line 99 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_sqlite3_finalize0 (stmt);
#line 99 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	return result;
#line 867 "TombstoneTable.c"
}


static gpointer _tombstone_row_ref0 (gpointer self) {
#line 130 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	return self ? tombstone_row_ref (self) : NULL;
#line 874 "TombstoneTable.c"
}


TombstoneRow** tombstone_table_fetch_all (TombstoneTable* self, int* result_length1, GError** error) {
	TombstoneRow** result = NULL;
	gint row_count = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp3_ = NULL;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	TombstoneRow** rows = NULL;
	gint _tmp7_ = 0;
	TombstoneRow** _tmp8_ = NULL;
	gint rows_length1 = 0;
	gint _rows_size_ = 0;
	gint index = 0;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	TombstoneRow** _tmp44_ = NULL;
	gint _tmp44__length1 = 0;
	GError * _inner_error_ = NULL;
#line 102 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	g_return_val_if_fail (IS_TOMBSTONE_TABLE (self), NULL);
#line 103 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp0_ = database_table_get_row_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable));
#line 103 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	row_count = _tmp0_;
#line 104 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp1_ = row_count;
#line 104 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	if (_tmp1_ == 0) {
#line 910 "TombstoneTable.c"
		TombstoneRow** _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
#line 105 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		_tmp2_ = NULL;
#line 105 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		_tmp2__length1 = 0;
#line 105 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		if (result_length1) {
#line 105 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			*result_length1 = _tmp2__length1;
#line 921 "TombstoneTable.c"
		}
#line 105 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		result = _tmp2_;
#line 105 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		return result;
#line 927 "TombstoneTable.c"
	}
#line 108 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp3_ = database_table_db;
#line 108 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp5_ = sqlite3_prepare_v2 (_tmp3_, "SELECT id, filepath, filesize, md5, time_created, reason " "FROM TombstoneTable", -1, &_tmp4_, NULL);
#line 108 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_sqlite3_finalize0 (stmt);
#line 108 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	stmt = _tmp4_;
#line 108 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	res = _tmp5_;
#line 110 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp6_ = res;
#line 110 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_vala_assert (_tmp6_ == SQLITE_OK, "res == Sqlite.OK");
#line 112 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp7_ = row_count;
#line 112 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp8_ = g_new0 (TombstoneRow*, _tmp7_ + 1);
#line 112 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	rows = _tmp8_;
#line 112 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	rows_length1 = _tmp7_;
#line 112 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_rows_size_ = rows_length1;
#line 114 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	index = 0;
#line 955 "TombstoneTable.c"
	{
		gboolean _tmp9_ = FALSE;
#line 115 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		_tmp9_ = TRUE;
#line 115 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		while (TRUE) {
#line 962 "TombstoneTable.c"
			sqlite3_stmt* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			TombstoneRow* row = NULL;
			TombstoneRow* _tmp15_ = NULL;
			TombstoneRow* _tmp16_ = NULL;
			sqlite3_stmt* _tmp17_ = NULL;
			gint64 _tmp18_ = 0LL;
			TombstoneRow* _tmp19_ = NULL;
			sqlite3_stmt* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			TombstoneRow* _tmp23_ = NULL;
			sqlite3_stmt* _tmp24_ = NULL;
			gint64 _tmp25_ = 0LL;
			TombstoneRow* _tmp26_ = NULL;
			sqlite3_stmt* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			gchar* _tmp29_ = NULL;
			TombstoneRow* _tmp30_ = NULL;
			sqlite3_stmt* _tmp31_ = NULL;
			gint64 _tmp32_ = 0LL;
			TombstoneRow* _tmp33_ = NULL;
			sqlite3_stmt* _tmp34_ = NULL;
			gint _tmp35_ = 0;
			TombstoneReason _tmp36_ = 0;
			TombstoneRow** _tmp37_ = NULL;
			gint _tmp37__length1 = 0;
			gint _tmp38_ = 0;
			TombstoneRow* _tmp39_ = NULL;
			TombstoneRow* _tmp40_ = NULL;
			TombstoneRow* _tmp41_ = NULL;
#line 115 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			if (!_tmp9_) {
#line 997 "TombstoneTable.c"
			}
#line 115 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp9_ = FALSE;
#line 116 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp10_ = stmt;
#line 116 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp11_ = sqlite3_step (_tmp10_);
#line 116 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			res = _tmp11_;
#line 117 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp12_ = res;
#line 117 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			if (_tmp12_ == SQLITE_DONE) {
#line 118 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
				break;
#line 1013 "TombstoneTable.c"
			} else {
				gint _tmp13_ = 0;
#line 119 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
				_tmp13_ = res;
#line 119 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
				if (_tmp13_ != SQLITE_ROW) {
#line 1020 "TombstoneTable.c"
					gint _tmp14_ = 0;
#line 120 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
					_tmp14_ = res;
#line 120 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
					database_table_throw_error ("TombstoneTable.fetch_all", _tmp14_, &_inner_error_);
#line 120 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 120 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
						if (_inner_error_->domain == DATABASE_ERROR) {
#line 120 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
							g_propagate_error (error, _inner_error_);
#line 120 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
							rows = (_vala_array_free (rows, rows_length1, (GDestroyNotify) tombstone_row_unref), NULL);
#line 120 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
							_sqlite3_finalize0 (stmt);
#line 120 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
							return NULL;
#line 1038 "TombstoneTable.c"
						} else {
#line 120 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
							rows = (_vala_array_free (rows, rows_length1, (GDestroyNotify) tombstone_row_unref), NULL);
#line 120 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
							_sqlite3_finalize0 (stmt);
#line 120 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 120 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
							g_clear_error (&_inner_error_);
#line 120 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
							return NULL;
#line 1050 "TombstoneTable.c"
						}
					}
				}
			}
#line 122 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp15_ = tombstone_row_new ();
#line 122 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			row = _tmp15_;
#line 123 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp16_ = row;
#line 123 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp17_ = stmt;
#line 123 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp18_ = sqlite3_column_int64 (_tmp17_, 0);
#line 123 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			tombstone_id_init (&_tmp16_->id, _tmp18_);
#line 124 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp19_ = row;
#line 124 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp20_ = stmt;
#line 124 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp21_ = sqlite3_column_text (_tmp20_, 1);
#line 124 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp22_ = g_strdup (_tmp21_);
#line 124 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_g_free0 (_tmp19_->filepath);
#line 124 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp19_->filepath = _tmp22_;
#line 125 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp23_ = row;
#line 125 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp24_ = stmt;
#line 125 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp25_ = sqlite3_column_int64 (_tmp24_, 2);
#line 125 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp23_->filesize = _tmp25_;
#line 126 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp26_ = row;
#line 126 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp27_ = stmt;
#line 126 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp28_ = sqlite3_column_text (_tmp27_, 3);
#line 126 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp29_ = g_strdup (_tmp28_);
#line 126 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_g_free0 (_tmp26_->md5);
#line 126 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp26_->md5 = _tmp29_;
#line 127 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp30_ = row;
#line 127 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp31_ = stmt;
#line 127 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp32_ = sqlite3_column_int64 (_tmp31_, 4);
#line 127 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp30_->time_created = (time_t) _tmp32_;
#line 128 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp33_ = row;
#line 128 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp34_ = stmt;
#line 128 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp35_ = sqlite3_column_int (_tmp34_, 5);
#line 128 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp36_ = tombstone_reason_unserialize (_tmp35_);
#line 128 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp33_->reason = _tmp36_;
#line 130 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp37_ = rows;
#line 130 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp37__length1 = rows_length1;
#line 130 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp38_ = index;
#line 130 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			index = _tmp38_ + 1;
#line 130 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp39_ = row;
#line 130 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp40_ = _tombstone_row_ref0 (_tmp39_);
#line 130 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tombstone_row_unref0 (_tmp37_[_tmp38_]);
#line 130 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp37_[_tmp38_] = _tmp40_;
#line 130 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tmp41_ = _tmp37_[_tmp38_];
#line 115 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			_tombstone_row_unref0 (row);
#line 1137 "TombstoneTable.c"
		}
	}
#line 133 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp42_ = index;
#line 133 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp43_ = row_count;
#line 133 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_vala_assert (_tmp42_ == _tmp43_, "index == row_count");
#line 135 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp44_ = rows;
#line 135 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp44__length1 = rows_length1;
#line 135 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	if (result_length1) {
#line 135 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		*result_length1 = _tmp44__length1;
#line 1154 "TombstoneTable.c"
	}
#line 135 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	result = _tmp44_;
#line 135 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_sqlite3_finalize0 (stmt);
#line 135 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	return result;
#line 1162 "TombstoneTable.c"
}


void tombstone_table_update_file (TombstoneTable* self, TombstoneID* tombstone_id, const gchar* filepath, GError** error) {
	TombstoneID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	const gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 138 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	g_return_if_fail (IS_TOMBSTONE_TABLE (self));
#line 138 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	g_return_if_fail (tombstone_id != NULL);
#line 138 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	g_return_if_fail (filepath != NULL);
#line 139 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp0_ = *tombstone_id;
#line 139 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp1_ = _tmp0_.id;
#line 139 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp2_ = filepath;
#line 139 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	database_table_update_text_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "filepath", _tmp2_, &_inner_error_);
#line 139 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 139 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 139 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			g_propagate_error (error, _inner_error_);
#line 139 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			return;
#line 1193 "TombstoneTable.c"
		} else {
#line 139 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 139 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			g_clear_error (&_inner_error_);
#line 139 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			return;
#line 1201 "TombstoneTable.c"
		}
	}
}


void tombstone_table_remove (TombstoneTable* self, TombstoneID* tombstone_id, GError** error) {
	TombstoneID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	GError * _inner_error_ = NULL;
#line 142 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	g_return_if_fail (IS_TOMBSTONE_TABLE (self));
#line 142 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	g_return_if_fail (tombstone_id != NULL);
#line 143 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp0_ = *tombstone_id;
#line 143 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	_tmp1_ = _tmp0_.id;
#line 143 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	database_table_delete_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, &_inner_error_);
#line 143 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 143 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 143 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			g_propagate_error (error, _inner_error_);
#line 143 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			return;
#line 1229 "TombstoneTable.c"
		} else {
#line 143 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 143 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			g_clear_error (&_inner_error_);
#line 143 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
			return;
#line 1237 "TombstoneTable.c"
		}
	}
}


static void tombstone_table_class_init (TombstoneTableClass * klass) {
#line 34 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	tombstone_table_parent_class = g_type_class_peek_parent (klass);
#line 34 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	((DatabaseTableClass *) klass)->finalize = tombstone_table_finalize;
#line 1248 "TombstoneTable.c"
}


static void tombstone_table_instance_init (TombstoneTable * self) {
}


static void tombstone_table_finalize (DatabaseTable* obj) {
	TombstoneTable * self;
#line 34 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TOMBSTONE_TABLE, TombstoneTable);
#line 34 "/home/jens/Source/shotwell/src/db/TombstoneTable.vala"
	DATABASE_TABLE_CLASS (tombstone_table_parent_class)->finalize (obj);
#line 1262 "TombstoneTable.c"
}


GType tombstone_table_get_type (void) {
	static volatile gsize tombstone_table_type_id__volatile = 0;
	if (g_once_init_enter (&tombstone_table_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TombstoneTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tombstone_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TombstoneTable), 0, (GInstanceInitFunc) tombstone_table_instance_init, NULL };
		GType tombstone_table_type_id;
		tombstone_table_type_id = g_type_register_static (TYPE_DATABASE_TABLE, "TombstoneTable", &g_define_type_info, 0);
		g_once_init_leave (&tombstone_table_type_id__volatile, tombstone_table_type_id);
	}
	return tombstone_table_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



