/* util.c generated by valac 0.34.1, the Vala compiler
 * generated from util.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/* SingletonCollection is a read-only collection designed to hold exactly one item in it.  This*/
/* is far more efficient than creating a dummy collection (such as ArrayList) merely to pass around*/
/* a single item, particularly for signals which require Iterables and Collections.*/
/**/
/* This collection cannot be used to store null.*/

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define TYPE_SINGLETON_COLLECTION (singleton_collection_get_type ())
#define SINGLETON_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SINGLETON_COLLECTION, SingletonCollection))
#define SINGLETON_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SINGLETON_COLLECTION, SingletonCollectionClass))
#define IS_SINGLETON_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SINGLETON_COLLECTION))
#define IS_SINGLETON_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SINGLETON_COLLECTION))
#define SINGLETON_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SINGLETON_COLLECTION, SingletonCollectionClass))

typedef struct _SingletonCollection SingletonCollection;
typedef struct _SingletonCollectionClass SingletonCollectionClass;
typedef struct _SingletonCollectionPrivate SingletonCollectionPrivate;
#define _g_destroy_func0(var) (((var == NULL) || (g_destroy_func == NULL)) ? NULL : (var = (g_destroy_func (var), NULL)))

#define SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR (singleton_collection_singleton_iterator_get_type ())
#define SINGLETON_COLLECTION_SINGLETON_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIterator))
#define SINGLETON_COLLECTION_SINGLETON_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIteratorClass))
#define SINGLETON_COLLECTION_IS_SINGLETON_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR))
#define SINGLETON_COLLECTION_IS_SINGLETON_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR))
#define SINGLETON_COLLECTION_SINGLETON_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIteratorClass))

typedef struct _SingletonCollectionSingletonIterator SingletonCollectionSingletonIterator;
typedef struct _SingletonCollectionSingletonIteratorClass SingletonCollectionSingletonIteratorClass;
typedef struct _SingletonCollectionSingletonIteratorPrivate SingletonCollectionSingletonIteratorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define MARKER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MARKER, MarkerIface))

typedef struct _Marker Marker;
typedef struct _MarkerIface MarkerIface;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_UNKNOWN_TOTAL_MONITOR (unknown_total_monitor_get_type ())
#define UNKNOWN_TOTAL_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNKNOWN_TOTAL_MONITOR, UnknownTotalMonitor))
#define UNKNOWN_TOTAL_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNKNOWN_TOTAL_MONITOR, UnknownTotalMonitorClass))
#define IS_UNKNOWN_TOTAL_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNKNOWN_TOTAL_MONITOR))
#define IS_UNKNOWN_TOTAL_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNKNOWN_TOTAL_MONITOR))
#define UNKNOWN_TOTAL_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNKNOWN_TOTAL_MONITOR, UnknownTotalMonitorClass))

typedef struct _UnknownTotalMonitor UnknownTotalMonitor;
typedef struct _UnknownTotalMonitorClass UnknownTotalMonitorClass;
typedef struct _UnknownTotalMonitorPrivate UnknownTotalMonitorPrivate;
typedef struct _ParamSpecUnknownTotalMonitor ParamSpecUnknownTotalMonitor;

#define TYPE_AGGREGATE_PROGRESS_MONITOR (aggregate_progress_monitor_get_type ())
#define AGGREGATE_PROGRESS_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AGGREGATE_PROGRESS_MONITOR, AggregateProgressMonitor))
#define AGGREGATE_PROGRESS_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AGGREGATE_PROGRESS_MONITOR, AggregateProgressMonitorClass))
#define IS_AGGREGATE_PROGRESS_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AGGREGATE_PROGRESS_MONITOR))
#define IS_AGGREGATE_PROGRESS_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AGGREGATE_PROGRESS_MONITOR))
#define AGGREGATE_PROGRESS_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AGGREGATE_PROGRESS_MONITOR, AggregateProgressMonitorClass))

typedef struct _AggregateProgressMonitor AggregateProgressMonitor;
typedef struct _AggregateProgressMonitorClass AggregateProgressMonitorClass;
typedef struct _AggregateProgressMonitorPrivate AggregateProgressMonitorPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecAggregateProgressMonitor ParamSpecAggregateProgressMonitor;

struct _SingletonCollection {
	GeeAbstractCollection parent_instance;
	SingletonCollectionPrivate * priv;
};

struct _SingletonCollectionClass {
	GeeAbstractCollectionClass parent_class;
};

struct _SingletonCollectionPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	gpointer object;
};

struct _SingletonCollectionSingletonIterator {
	GObject parent_instance;
	SingletonCollectionSingletonIteratorPrivate * priv;
};

struct _SingletonCollectionSingletonIteratorClass {
	GObjectClass parent_class;
};

struct _SingletonCollectionSingletonIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	SingletonCollection* c;
	gboolean done;
	gpointer current;
};

struct _MarkerIface {
	GTypeInterface parent_iface;
	void (*mark) (Marker* self, DataObject* object);
	void (*unmark) (Marker* self, DataObject* object);
	gboolean (*toggle) (Marker* self, DataObject* object);
	void (*mark_many) (Marker* self, GeeCollection* list);
	void (*unmark_many) (Marker* self, GeeCollection* list);
	void (*mark_all) (Marker* self);
	gint (*get_count) (Marker* self);
	GeeCollection* (*get_all) (Marker* self);
};

typedef gboolean (*MarkedAction) (DataObject* object, GObject* user, void* user_data);
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, void* user_data);
struct _UnknownTotalMonitor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UnknownTotalMonitorPrivate * priv;
};

struct _UnknownTotalMonitorClass {
	GTypeClass parent_class;
	void (*finalize) (UnknownTotalMonitor *self);
};

struct _UnknownTotalMonitorPrivate {
	guint64 total;
	ProgressMonitor wrapped_monitor;
	gpointer wrapped_monitor_target;
};

struct _ParamSpecUnknownTotalMonitor {
	GParamSpec parent_instance;
};

struct _AggregateProgressMonitor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AggregateProgressMonitorPrivate * priv;
};

struct _AggregateProgressMonitorClass {
	GTypeClass parent_class;
	void (*finalize) (AggregateProgressMonitor *self);
};

struct _AggregateProgressMonitorPrivate {
	guint64 grand_total;
	ProgressMonitor wrapped_monitor;
	gpointer wrapped_monitor_target;
	guint64 aggregate_count;
	guint64 last_count;
};

struct _ParamSpecAggregateProgressMonitor {
	GParamSpec parent_instance;
};


static gpointer singleton_collection_parent_class = NULL;
static gpointer singleton_collection_singleton_iterator_parent_class = NULL;
static GeeTraversableIface* singleton_collection_singleton_iterator_gee_traversable_parent_iface = NULL;
static GeeIteratorIface* singleton_collection_singleton_iterator_gee_iterator_parent_iface = NULL;
static gpointer unknown_total_monitor_parent_class = NULL;
static gpointer aggregate_progress_monitor_parent_class = NULL;

GType singleton_collection_get_type (void) G_GNUC_CONST;
#define SINGLETON_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SINGLETON_COLLECTION, SingletonCollectionPrivate))
enum  {
	SINGLETON_COLLECTION_DUMMY_PROPERTY,
	SINGLETON_COLLECTION_G_TYPE,
	SINGLETON_COLLECTION_G_DUP_FUNC,
	SINGLETON_COLLECTION_G_DESTROY_FUNC,
	SINGLETON_COLLECTION_READ_ONLY,
	SINGLETON_COLLECTION_SIZE
};
SingletonCollection* singleton_collection_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer object);
SingletonCollection* singleton_collection_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer object);
static gboolean singleton_collection_real_add (GeeAbstractCollection* base, gconstpointer object);
static void singleton_collection_real_clear (GeeAbstractCollection* base);
static gboolean singleton_collection_real_contains (GeeAbstractCollection* base, gconstpointer object);
static GeeIterator* singleton_collection_real_iterator (GeeAbstractCollection* base);
static SingletonCollectionSingletonIterator* singleton_collection_singleton_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, SingletonCollection* c);
static SingletonCollectionSingletonIterator* singleton_collection_singleton_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, SingletonCollection* c);
static GType singleton_collection_singleton_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean singleton_collection_real_remove (GeeAbstractCollection* base, gconstpointer item);
#define SINGLETON_COLLECTION_SINGLETON_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIteratorPrivate))
enum  {
	SINGLETON_COLLECTION_SINGLETON_ITERATOR_DUMMY_PROPERTY,
	SINGLETON_COLLECTION_SINGLETON_ITERATOR_G_TYPE,
	SINGLETON_COLLECTION_SINGLETON_ITERATOR_G_DUP_FUNC,
	SINGLETON_COLLECTION_SINGLETON_ITERATOR_G_DESTROY_FUNC,
	SINGLETON_COLLECTION_SINGLETON_ITERATOR_READ_ONLY,
	SINGLETON_COLLECTION_SINGLETON_ITERATOR_VALID
};
static gboolean singleton_collection_singleton_iterator_real_foreach (GeeTraversable* base, GeeForallFunc f, void* f_target);
static gpointer singleton_collection_singleton_iterator_real_get (GeeIterator* base);
static gboolean singleton_collection_singleton_iterator_real_has_next (GeeIterator* base);
static gboolean singleton_collection_singleton_iterator_real_next (GeeIterator* base);
static void singleton_collection_singleton_iterator_real_remove (GeeIterator* base);
static void singleton_collection_singleton_iterator_finalize (GObject* obj);
static void _vala_singleton_collection_singleton_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_singleton_collection_singleton_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void singleton_collection_finalize (GObject* obj);
static void _vala_singleton_collection_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_singleton_collection_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType data_object_get_type (void) G_GNUC_CONST;
GType marker_get_type (void) G_GNUC_CONST;
void marker_mark (Marker* self, DataObject* object);
void marker_unmark (Marker* self, DataObject* object);
gboolean marker_toggle (Marker* self, DataObject* object);
void marker_mark_many (Marker* self, GeeCollection* list);
void marker_unmark_many (Marker* self, GeeCollection* list);
void marker_mark_all (Marker* self);
gint marker_get_count (Marker* self);
GeeCollection* marker_get_all (Marker* self);
gpointer unknown_total_monitor_ref (gpointer instance);
void unknown_total_monitor_unref (gpointer instance);
GParamSpec* param_spec_unknown_total_monitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_unknown_total_monitor (GValue* value, gpointer v_object);
void value_take_unknown_total_monitor (GValue* value, gpointer v_object);
gpointer value_get_unknown_total_monitor (const GValue* value);
GType unknown_total_monitor_get_type (void) G_GNUC_CONST;
#define UNKNOWN_TOTAL_MONITOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_UNKNOWN_TOTAL_MONITOR, UnknownTotalMonitorPrivate))
enum  {
	UNKNOWN_TOTAL_MONITOR_DUMMY_PROPERTY
};
UnknownTotalMonitor* unknown_total_monitor_new (guint64 total, ProgressMonitor wrapped_monitor, void* wrapped_monitor_target);
UnknownTotalMonitor* unknown_total_monitor_construct (GType object_type, guint64 total, ProgressMonitor wrapped_monitor, void* wrapped_monitor_target);
gboolean unknown_total_monitor_monitor (UnknownTotalMonitor* self, guint64 count, guint64 total);
static void unknown_total_monitor_finalize (UnknownTotalMonitor* obj);
gpointer aggregate_progress_monitor_ref (gpointer instance);
void aggregate_progress_monitor_unref (gpointer instance);
GParamSpec* param_spec_aggregate_progress_monitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_aggregate_progress_monitor (GValue* value, gpointer v_object);
void value_take_aggregate_progress_monitor (GValue* value, gpointer v_object);
gpointer value_get_aggregate_progress_monitor (const GValue* value);
GType aggregate_progress_monitor_get_type (void) G_GNUC_CONST;
#define AGGREGATE_PROGRESS_MONITOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_AGGREGATE_PROGRESS_MONITOR, AggregateProgressMonitorPrivate))
enum  {
	AGGREGATE_PROGRESS_MONITOR_DUMMY_PROPERTY
};
AggregateProgressMonitor* aggregate_progress_monitor_new (guint64 grand_total, ProgressMonitor wrapped_monitor, void* wrapped_monitor_target);
AggregateProgressMonitor* aggregate_progress_monitor_construct (GType object_type, guint64 grand_total, ProgressMonitor wrapped_monitor, void* wrapped_monitor_target);
void aggregate_progress_monitor_next_step (AggregateProgressMonitor* self, const gchar* name);
gboolean aggregate_progress_monitor_monitor (AggregateProgressMonitor* self, guint64 count, guint64 total);
static void aggregate_progress_monitor_finalize (AggregateProgressMonitor* obj);
gboolean null_progress_monitor (guint64 count, guint64 total);
gdouble degrees_to_radians (gdouble theta);


SingletonCollection* singleton_collection_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer object) {
	SingletonCollection * self = NULL;
	gconstpointer _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
#line 65 "/home/jens/Source/shotwell/src/core/util.vala"
	self = (SingletonCollection*) gee_abstract_collection_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
#line 65 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->g_type = g_type;
#line 65 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->g_dup_func = g_dup_func;
#line 65 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 66 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0_ = object;
#line 66 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp1_ = ((_tmp0_ != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) _tmp0_) : ((gpointer) _tmp0_);
#line 66 "/home/jens/Source/shotwell/src/core/util.vala"
	_g_destroy_func0 (self->priv->object);
#line 66 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->object = _tmp1_;
#line 65 "/home/jens/Source/shotwell/src/core/util.vala"
	return self;
#line 300 "util.c"
}


SingletonCollection* singleton_collection_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer object) {
#line 65 "/home/jens/Source/shotwell/src/core/util.vala"
	return singleton_collection_construct (TYPE_SINGLETON_COLLECTION, g_type, g_dup_func, g_destroy_func, object);
#line 307 "util.c"
}


static gboolean singleton_collection_real_add (GeeAbstractCollection* base, gconstpointer object) {
	SingletonCollection * self;
	gboolean result = FALSE;
#line 73 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SINGLETON_COLLECTION, SingletonCollection);
#line 74 "/home/jens/Source/shotwell/src/core/util.vala"
	g_warning ("util.vala:74: Cannot add to SingletonCollection");
#line 76 "/home/jens/Source/shotwell/src/core/util.vala"
	result = FALSE;
#line 76 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 322 "util.c"
}


static void singleton_collection_real_clear (GeeAbstractCollection* base) {
	SingletonCollection * self;
#line 79 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SINGLETON_COLLECTION, SingletonCollection);
#line 80 "/home/jens/Source/shotwell/src/core/util.vala"
	((self->priv->object == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->object = (self->priv->g_destroy_func (self->priv->object), NULL));
#line 80 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->object = NULL;
#line 334 "util.c"
}


static gboolean singleton_collection_real_contains (GeeAbstractCollection* base, gconstpointer object) {
	SingletonCollection * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
#line 83 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SINGLETON_COLLECTION, SingletonCollection);
#line 84 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0_ = self->priv->object;
#line 84 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp1_ = object;
#line 84 "/home/jens/Source/shotwell/src/core/util.vala"
	result = _tmp0_ == _tmp1_;
#line 84 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 353 "util.c"
}


static GeeIterator* singleton_collection_real_iterator (GeeAbstractCollection* base) {
	SingletonCollection * self;
	GeeIterator* result = NULL;
	SingletonCollectionSingletonIterator* _tmp0_ = NULL;
#line 87 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SINGLETON_COLLECTION, SingletonCollection);
#line 88 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0_ = singleton_collection_singleton_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
#line 88 "/home/jens/Source/shotwell/src/core/util.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERATOR, GeeIterator);
#line 88 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 369 "util.c"
}


static gboolean singleton_collection_real_remove (GeeAbstractCollection* base, gconstpointer item) {
	SingletonCollection * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
#line 91 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SINGLETON_COLLECTION, SingletonCollection);
#line 92 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0_ = item;
#line 92 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp1_ = self->priv->object;
#line 92 "/home/jens/Source/shotwell/src/core/util.vala"
	if (_tmp0_ == _tmp1_) {
#line 93 "/home/jens/Source/shotwell/src/core/util.vala"
		((self->priv->object == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->object = (self->priv->g_destroy_func (self->priv->object), NULL));
#line 93 "/home/jens/Source/shotwell/src/core/util.vala"
		self->priv->object = NULL;
#line 95 "/home/jens/Source/shotwell/src/core/util.vala"
		result = TRUE;
#line 95 "/home/jens/Source/shotwell/src/core/util.vala"
		return result;
#line 394 "util.c"
	}
#line 98 "/home/jens/Source/shotwell/src/core/util.vala"
	result = FALSE;
#line 98 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 400 "util.c"
}


static gboolean singleton_collection_real_get_read_only (GeeAbstractCollection* base) {
	gboolean result;
	SingletonCollection* self;
#line 70 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SINGLETON_COLLECTION, SingletonCollection);
#line 70 "/home/jens/Source/shotwell/src/core/util.vala"
	result = FALSE;
#line 70 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 413 "util.c"
}


static gint singleton_collection_real_get_size (GeeAbstractCollection* base) {
	gint result;
	SingletonCollection* self;
	gint _tmp0_ = 0;
	gconstpointer _tmp1_ = NULL;
#line 102 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SINGLETON_COLLECTION, SingletonCollection);
#line 103 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp1_ = self->priv->object;
#line 103 "/home/jens/Source/shotwell/src/core/util.vala"
	if (_tmp1_ != NULL) {
#line 103 "/home/jens/Source/shotwell/src/core/util.vala"
		_tmp0_ = 1;
#line 430 "util.c"
	} else {
#line 103 "/home/jens/Source/shotwell/src/core/util.vala"
		_tmp0_ = 0;
#line 434 "util.c"
	}
#line 103 "/home/jens/Source/shotwell/src/core/util.vala"
	result = _tmp0_;
#line 103 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 440 "util.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 20 "/home/jens/Source/shotwell/src/core/util.vala"
	return self ? g_object_ref (self) : NULL;
#line 447 "util.c"
}


static SingletonCollectionSingletonIterator* singleton_collection_singleton_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, SingletonCollection* c) {
	SingletonCollectionSingletonIterator * self = NULL;
	SingletonCollection* _tmp0_ = NULL;
	SingletonCollection* _tmp1_ = NULL;
#line 19 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_val_if_fail (IS_SINGLETON_COLLECTION (c), NULL);
#line 19 "/home/jens/Source/shotwell/src/core/util.vala"
	self = (SingletonCollectionSingletonIterator*) g_object_new (object_type, NULL);
#line 19 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->g_type = g_type;
#line 19 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->g_dup_func = g_dup_func;
#line 19 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 20 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0_ = c;
#line 20 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 20 "/home/jens/Source/shotwell/src/core/util.vala"
	_g_object_unref0 (self->priv->c);
#line 20 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->c = _tmp1_;
#line 19 "/home/jens/Source/shotwell/src/core/util.vala"
	return self;
#line 475 "util.c"
}


static SingletonCollectionSingletonIterator* singleton_collection_singleton_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, SingletonCollection* c) {
#line 19 "/home/jens/Source/shotwell/src/core/util.vala"
	return singleton_collection_singleton_iterator_construct (SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, g_type, g_dup_func, g_destroy_func, c);
#line 482 "util.c"
}


static gboolean singleton_collection_singleton_iterator_real_foreach (GeeTraversable* base, GeeForallFunc f, void* f_target) {
	SingletonCollectionSingletonIterator * self;
	gboolean result = FALSE;
	GeeForallFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	SingletonCollection* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 31 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIterator);
#line 32 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0_ = f;
#line 32 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0__target = f_target;
#line 32 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp1_ = self->priv->c;
#line 32 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp2_ = _tmp1_->priv->object;
#line 32 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp3_ = ((_tmp2_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp2_) : ((gpointer) _tmp2_);
#line 32 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp4_ = _tmp0_ (_tmp3_, _tmp0__target);
#line 32 "/home/jens/Source/shotwell/src/core/util.vala"
	result = _tmp4_;
#line 32 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 513 "util.c"
}


static gpointer singleton_collection_singleton_iterator_real_get (GeeIterator* base) {
	SingletonCollectionSingletonIterator * self;
	gpointer result = NULL;
	gconstpointer _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
#line 35 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIterator);
#line 36 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0_ = self->priv->current;
#line 36 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp1_ = ((_tmp0_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp0_) : ((gpointer) _tmp0_);
#line 36 "/home/jens/Source/shotwell/src/core/util.vala"
	result = _tmp1_;
#line 36 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 532 "util.c"
}


static gboolean singleton_collection_singleton_iterator_real_has_next (GeeIterator* base) {
	SingletonCollectionSingletonIterator * self;
	gboolean result = FALSE;
#line 39 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIterator);
#line 40 "/home/jens/Source/shotwell/src/core/util.vala"
	result = FALSE;
#line 40 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 545 "util.c"
}


static gboolean singleton_collection_singleton_iterator_real_next (GeeIterator* base) {
	SingletonCollectionSingletonIterator * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	SingletonCollection* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
#line 43 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIterator);
#line 44 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0_ = self->priv->done;
#line 44 "/home/jens/Source/shotwell/src/core/util.vala"
	if (_tmp0_) {
#line 45 "/home/jens/Source/shotwell/src/core/util.vala"
		result = FALSE;
#line 45 "/home/jens/Source/shotwell/src/core/util.vala"
		return result;
#line 566 "util.c"
	}
#line 47 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->done = TRUE;
#line 48 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp1_ = self->priv->c;
#line 48 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp2_ = _tmp1_->priv->object;
#line 48 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp3_ = ((_tmp2_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp2_) : ((gpointer) _tmp2_);
#line 48 "/home/jens/Source/shotwell/src/core/util.vala"
	((self->priv->current == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->current = (self->priv->g_destroy_func (self->priv->current), NULL));
#line 48 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->current = _tmp3_;
#line 50 "/home/jens/Source/shotwell/src/core/util.vala"
	result = TRUE;
#line 50 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 584 "util.c"
}


static void singleton_collection_singleton_iterator_real_remove (GeeIterator* base) {
	SingletonCollectionSingletonIterator * self;
	gboolean _tmp0_ = FALSE;
#line 53 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIterator);
#line 54 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0_ = self->priv->done;
#line 54 "/home/jens/Source/shotwell/src/core/util.vala"
	if (!_tmp0_) {
#line 597 "util.c"
		SingletonCollection* _tmp1_ = NULL;
#line 55 "/home/jens/Source/shotwell/src/core/util.vala"
		_tmp1_ = self->priv->c;
#line 55 "/home/jens/Source/shotwell/src/core/util.vala"
		((_tmp1_->priv->object == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp1_->priv->object = (self->priv->g_destroy_func (_tmp1_->priv->object), NULL));
#line 55 "/home/jens/Source/shotwell/src/core/util.vala"
		_tmp1_->priv->object = NULL;
#line 56 "/home/jens/Source/shotwell/src/core/util.vala"
		((self->priv->current == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->current = (self->priv->g_destroy_func (self->priv->current), NULL));
#line 56 "/home/jens/Source/shotwell/src/core/util.vala"
		self->priv->current = NULL;
#line 609 "util.c"
	}
#line 59 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->done = TRUE;
#line 613 "util.c"
}


static gboolean singleton_collection_singleton_iterator_real_get_read_only (GeeIterator* base) {
	gboolean result;
	SingletonCollectionSingletonIterator* self;
	gboolean _tmp0_ = FALSE;
#line 24 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIterator);
#line 24 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0_ = self->priv->done;
#line 24 "/home/jens/Source/shotwell/src/core/util.vala"
	result = _tmp0_;
#line 24 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 629 "util.c"
}


static gboolean singleton_collection_singleton_iterator_real_get_valid (GeeIterator* base) {
	gboolean result;
	SingletonCollectionSingletonIterator* self;
	gboolean _tmp0_ = FALSE;
#line 28 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIterator);
#line 28 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0_ = self->priv->done;
#line 28 "/home/jens/Source/shotwell/src/core/util.vala"
	result = _tmp0_;
#line 28 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 645 "util.c"
}


static void singleton_collection_singleton_iterator_class_init (SingletonCollectionSingletonIteratorClass * klass) {
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	singleton_collection_singleton_iterator_parent_class = g_type_class_peek_parent (klass);
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	g_type_class_add_private (klass, sizeof (SingletonCollectionSingletonIteratorPrivate));
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_singleton_collection_singleton_iterator_get_property;
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_singleton_collection_singleton_iterator_set_property;
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	G_OBJECT_CLASS (klass)->finalize = singleton_collection_singleton_iterator_finalize;
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SINGLETON_COLLECTION_SINGLETON_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SINGLETON_COLLECTION_SINGLETON_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SINGLETON_COLLECTION_SINGLETON_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SINGLETON_COLLECTION_SINGLETON_ITERATOR_READ_ONLY, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SINGLETON_COLLECTION_SINGLETON_ITERATOR_VALID, g_param_spec_boolean ("valid", "valid", "valid", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 670 "util.c"
}


static GType singleton_collection_singleton_iterator_gee_traversable_get_g_type (SingletonCollectionSingletonIterator* self) {
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	return self->priv->g_type;
#line 677 "util.c"
}


static GBoxedCopyFunc singleton_collection_singleton_iterator_gee_traversable_get_g_dup_func (SingletonCollectionSingletonIterator* self) {
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	return self->priv->g_dup_func;
#line 684 "util.c"
}


static GDestroyNotify singleton_collection_singleton_iterator_gee_traversable_get_g_destroy_func (SingletonCollectionSingletonIterator* self) {
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	return self->priv->g_destroy_func;
#line 691 "util.c"
}


static void singleton_collection_singleton_iterator_gee_traversable_interface_init (GeeTraversableIface * iface) {
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	singleton_collection_singleton_iterator_gee_traversable_parent_iface = g_type_interface_peek_parent (iface);
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	iface->foreach = (gboolean (*)(GeeTraversable*, GeeForallFunc, void*)) singleton_collection_singleton_iterator_real_foreach;
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	iface->get_g_type = (GType(*)(GeeTraversable*)) singleton_collection_singleton_iterator_gee_traversable_get_g_type;
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	iface->get_g_dup_func = (GBoxedCopyFunc(*)(GeeTraversable*)) singleton_collection_singleton_iterator_gee_traversable_get_g_dup_func;
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	iface->get_g_destroy_func = (GDestroyNotify(*)(GeeTraversable*)) singleton_collection_singleton_iterator_gee_traversable_get_g_destroy_func;
#line 706 "util.c"
}


static void singleton_collection_singleton_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	singleton_collection_singleton_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	iface->get = (gpointer (*)(GeeIterator*)) singleton_collection_singleton_iterator_real_get;
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	iface->has_next = (gboolean (*)(GeeIterator*)) singleton_collection_singleton_iterator_real_has_next;
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	iface->next = (gboolean (*)(GeeIterator*)) singleton_collection_singleton_iterator_real_next;
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	iface->remove = (void (*)(GeeIterator*)) singleton_collection_singleton_iterator_real_remove;
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	iface->get_read_only = singleton_collection_singleton_iterator_real_get_read_only;
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	iface->get_valid = singleton_collection_singleton_iterator_real_get_valid;
#line 725 "util.c"
}


static void singleton_collection_singleton_iterator_instance_init (SingletonCollectionSingletonIterator * self) {
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv = SINGLETON_COLLECTION_SINGLETON_ITERATOR_GET_PRIVATE (self);
#line 16 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->done = FALSE;
#line 17 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->current = NULL;
#line 736 "util.c"
}


static void singleton_collection_singleton_iterator_finalize (GObject* obj) {
	SingletonCollectionSingletonIterator * self;
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIterator);
#line 15 "/home/jens/Source/shotwell/src/core/util.vala"
	_g_object_unref0 (self->priv->c);
#line 17 "/home/jens/Source/shotwell/src/core/util.vala"
	((self->priv->current == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->current = (self->priv->g_destroy_func (self->priv->current), NULL));
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	G_OBJECT_CLASS (singleton_collection_singleton_iterator_parent_class)->finalize (obj);
#line 750 "util.c"
}


static GType singleton_collection_singleton_iterator_get_type (void) {
	static volatile gsize singleton_collection_singleton_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&singleton_collection_singleton_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SingletonCollectionSingletonIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) singleton_collection_singleton_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SingletonCollectionSingletonIterator), 0, (GInstanceInitFunc) singleton_collection_singleton_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_traversable_info = { (GInterfaceInitFunc) singleton_collection_singleton_iterator_gee_traversable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) singleton_collection_singleton_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType singleton_collection_singleton_iterator_type_id;
		singleton_collection_singleton_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "SingletonCollectionSingletonIterator", &g_define_type_info, 0);
		g_type_add_interface_static (singleton_collection_singleton_iterator_type_id, GEE_TYPE_TRAVERSABLE, &gee_traversable_info);
		g_type_add_interface_static (singleton_collection_singleton_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
		g_once_init_leave (&singleton_collection_singleton_iterator_type_id__volatile, singleton_collection_singleton_iterator_type_id);
	}
	return singleton_collection_singleton_iterator_type_id__volatile;
}


static void _vala_singleton_collection_singleton_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SingletonCollectionSingletonIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIterator);
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	switch (property_id) {
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		case SINGLETON_COLLECTION_SINGLETON_ITERATOR_READ_ONLY:
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		g_value_set_boolean (value, gee_iterator_get_read_only (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_ITERATOR, GeeIterator)));
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		break;
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		case SINGLETON_COLLECTION_SINGLETON_ITERATOR_VALID:
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		g_value_set_boolean (value, gee_iterator_get_valid (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_ITERATOR, GeeIterator)));
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		break;
#line 787 "util.c"
		default:
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		break;
#line 793 "util.c"
	}
}


static void _vala_singleton_collection_singleton_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SingletonCollectionSingletonIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIterator);
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	switch (property_id) {
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		case SINGLETON_COLLECTION_SINGLETON_ITERATOR_G_TYPE:
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		self->priv->g_type = g_value_get_gtype (value);
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		break;
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		case SINGLETON_COLLECTION_SINGLETON_ITERATOR_G_DUP_FUNC:
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		self->priv->g_dup_func = g_value_get_pointer (value);
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		break;
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		case SINGLETON_COLLECTION_SINGLETON_ITERATOR_G_DESTROY_FUNC:
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		self->priv->g_destroy_func = g_value_get_pointer (value);
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		break;
#line 821 "util.c"
		default:
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		break;
#line 827 "util.c"
	}
}


static void singleton_collection_class_init (SingletonCollectionClass * klass) {
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	singleton_collection_parent_class = g_type_class_peek_parent (klass);
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	g_type_class_add_private (klass, sizeof (SingletonCollectionPrivate));
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	((GeeAbstractCollectionClass *) klass)->add = singleton_collection_real_add;
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	((GeeAbstractCollectionClass *) klass)->clear = singleton_collection_real_clear;
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	((GeeAbstractCollectionClass *) klass)->contains = singleton_collection_real_contains;
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	((GeeAbstractCollectionClass *) klass)->iterator = singleton_collection_real_iterator;
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	((GeeAbstractCollectionClass *) klass)->remove = singleton_collection_real_remove;
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_read_only = singleton_collection_real_get_read_only;
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = singleton_collection_real_get_size;
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_singleton_collection_get_property;
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_singleton_collection_set_property;
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	G_OBJECT_CLASS (klass)->finalize = singleton_collection_finalize;
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SINGLETON_COLLECTION_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SINGLETON_COLLECTION_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SINGLETON_COLLECTION_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SINGLETON_COLLECTION_READ_ONLY, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SINGLETON_COLLECTION_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 867 "util.c"
}


static void singleton_collection_instance_init (SingletonCollection * self) {
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv = SINGLETON_COLLECTION_GET_PRIVATE (self);
#line 874 "util.c"
}


static void singleton_collection_finalize (GObject* obj) {
	SingletonCollection * self;
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SINGLETON_COLLECTION, SingletonCollection);
#line 63 "/home/jens/Source/shotwell/src/core/util.vala"
	((self->priv->object == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->object = (self->priv->g_destroy_func (self->priv->object), NULL));
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	G_OBJECT_CLASS (singleton_collection_parent_class)->finalize (obj);
#line 886 "util.c"
}


GType singleton_collection_get_type (void) {
	static volatile gsize singleton_collection_type_id__volatile = 0;
	if (g_once_init_enter (&singleton_collection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SingletonCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) singleton_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SingletonCollection), 0, (GInstanceInitFunc) singleton_collection_instance_init, NULL };
		GType singleton_collection_type_id;
		singleton_collection_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_COLLECTION, "SingletonCollection", &g_define_type_info, 0);
		g_once_init_leave (&singleton_collection_type_id__volatile, singleton_collection_type_id);
	}
	return singleton_collection_type_id__volatile;
}


static void _vala_singleton_collection_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SingletonCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SINGLETON_COLLECTION, SingletonCollection);
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	switch (property_id) {
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		case SINGLETON_COLLECTION_READ_ONLY:
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		g_value_set_boolean (value, gee_abstract_collection_get_read_only (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection)));
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		break;
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		case SINGLETON_COLLECTION_SIZE:
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		g_value_set_int (value, gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection)));
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		break;
#line 919 "util.c"
		default:
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		break;
#line 925 "util.c"
	}
}


static void _vala_singleton_collection_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SingletonCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SINGLETON_COLLECTION, SingletonCollection);
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	switch (property_id) {
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		case SINGLETON_COLLECTION_G_TYPE:
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		self->priv->g_type = g_value_get_gtype (value);
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		break;
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		case SINGLETON_COLLECTION_G_DUP_FUNC:
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		self->priv->g_dup_func = g_value_get_pointer (value);
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		break;
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		case SINGLETON_COLLECTION_G_DESTROY_FUNC:
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		self->priv->g_destroy_func = g_value_get_pointer (value);
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		break;
#line 953 "util.c"
		default:
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		break;
#line 959 "util.c"
	}
}


void marker_mark (Marker* self, DataObject* object) {
#line 113 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_if_fail (IS_MARKER (self));
#line 113 "/home/jens/Source/shotwell/src/core/util.vala"
	MARKER_GET_INTERFACE (self)->mark (self, object);
#line 969 "util.c"
}


void marker_unmark (Marker* self, DataObject* object) {
#line 115 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_if_fail (IS_MARKER (self));
#line 115 "/home/jens/Source/shotwell/src/core/util.vala"
	MARKER_GET_INTERFACE (self)->unmark (self, object);
#line 978 "util.c"
}


gboolean marker_toggle (Marker* self, DataObject* object) {
#line 117 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_val_if_fail (IS_MARKER (self), FALSE);
#line 117 "/home/jens/Source/shotwell/src/core/util.vala"
	return MARKER_GET_INTERFACE (self)->toggle (self, object);
#line 987 "util.c"
}


void marker_mark_many (Marker* self, GeeCollection* list) {
#line 119 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_if_fail (IS_MARKER (self));
#line 119 "/home/jens/Source/shotwell/src/core/util.vala"
	MARKER_GET_INTERFACE (self)->mark_many (self, list);
#line 996 "util.c"
}


void marker_unmark_many (Marker* self, GeeCollection* list) {
#line 121 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_if_fail (IS_MARKER (self));
#line 121 "/home/jens/Source/shotwell/src/core/util.vala"
	MARKER_GET_INTERFACE (self)->unmark_many (self, list);
#line 1005 "util.c"
}


void marker_mark_all (Marker* self) {
#line 123 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_if_fail (IS_MARKER (self));
#line 123 "/home/jens/Source/shotwell/src/core/util.vala"
	MARKER_GET_INTERFACE (self)->mark_all (self);
#line 1014 "util.c"
}


gint marker_get_count (Marker* self) {
#line 127 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_val_if_fail (IS_MARKER (self), 0);
#line 127 "/home/jens/Source/shotwell/src/core/util.vala"
	return MARKER_GET_INTERFACE (self)->get_count (self);
#line 1023 "util.c"
}


GeeCollection* marker_get_all (Marker* self) {
#line 130 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_val_if_fail (IS_MARKER (self), NULL);
#line 130 "/home/jens/Source/shotwell/src/core/util.vala"
	return MARKER_GET_INTERFACE (self)->get_all (self);
#line 1032 "util.c"
}


static void marker_base_init (MarkerIface * iface) {
#line 112 "/home/jens/Source/shotwell/src/core/util.vala"
	static gboolean initialized = FALSE;
#line 112 "/home/jens/Source/shotwell/src/core/util.vala"
	if (!initialized) {
#line 112 "/home/jens/Source/shotwell/src/core/util.vala"
		initialized = TRUE;
#line 1043 "util.c"
	}
}


GType marker_get_type (void) {
	static volatile gsize marker_type_id__volatile = 0;
	if (g_once_init_enter (&marker_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MarkerIface), (GBaseInitFunc) marker_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType marker_type_id;
		marker_type_id = g_type_register_static (G_TYPE_INTERFACE, "Marker", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (marker_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&marker_type_id__volatile, marker_type_id);
	}
	return marker_type_id__volatile;
}


UnknownTotalMonitor* unknown_total_monitor_construct (GType object_type, guint64 total, ProgressMonitor wrapped_monitor, void* wrapped_monitor_target) {
	UnknownTotalMonitor* self = NULL;
	guint64 _tmp0_ = 0ULL;
	ProgressMonitor _tmp1_ = NULL;
	void* _tmp1__target = NULL;
#line 147 "/home/jens/Source/shotwell/src/core/util.vala"
	self = (UnknownTotalMonitor*) g_type_create_instance (object_type);
#line 148 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0_ = total;
#line 148 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->total = _tmp0_;
#line 149 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp1_ = wrapped_monitor;
#line 149 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp1__target = wrapped_monitor_target;
#line 149 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->wrapped_monitor = _tmp1_;
#line 149 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->wrapped_monitor_target = _tmp1__target;
#line 147 "/home/jens/Source/shotwell/src/core/util.vala"
	return self;
#line 1082 "util.c"
}


UnknownTotalMonitor* unknown_total_monitor_new (guint64 total, ProgressMonitor wrapped_monitor, void* wrapped_monitor_target) {
#line 147 "/home/jens/Source/shotwell/src/core/util.vala"
	return unknown_total_monitor_construct (TYPE_UNKNOWN_TOTAL_MONITOR, total, wrapped_monitor, wrapped_monitor_target);
#line 1089 "util.c"
}


gboolean unknown_total_monitor_monitor (UnknownTotalMonitor* self, guint64 count, guint64 total) {
	gboolean result = FALSE;
	ProgressMonitor _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	guint64 _tmp1_ = 0ULL;
	guint64 _tmp2_ = 0ULL;
	gboolean _tmp3_ = FALSE;
#line 152 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_val_if_fail (IS_UNKNOWN_TOTAL_MONITOR (self), FALSE);
#line 153 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0_ = self->priv->wrapped_monitor;
#line 153 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0__target = self->priv->wrapped_monitor_target;
#line 153 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp1_ = count;
#line 153 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp2_ = self->priv->total;
#line 153 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp3_ = _tmp0_ (_tmp1_, _tmp2_, TRUE, _tmp0__target);
#line 153 "/home/jens/Source/shotwell/src/core/util.vala"
	result = _tmp3_;
#line 153 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 1116 "util.c"
}


static void value_unknown_total_monitor_init (GValue* value) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	value->data[0].v_pointer = NULL;
#line 1123 "util.c"
}


static void value_unknown_total_monitor_free_value (GValue* value) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	if (value->data[0].v_pointer) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		unknown_total_monitor_unref (value->data[0].v_pointer);
#line 1132 "util.c"
	}
}


static void value_unknown_total_monitor_copy_value (const GValue* src_value, GValue* dest_value) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	if (src_value->data[0].v_pointer) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		dest_value->data[0].v_pointer = unknown_total_monitor_ref (src_value->data[0].v_pointer);
#line 1142 "util.c"
	} else {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1146 "util.c"
	}
}


static gpointer value_unknown_total_monitor_peek_pointer (const GValue* value) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	return value->data[0].v_pointer;
#line 1154 "util.c"
}


static gchar* value_unknown_total_monitor_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	if (collect_values[0].v_pointer) {
#line 1161 "util.c"
		UnknownTotalMonitor* object;
		object = collect_values[0].v_pointer;
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		if (object->parent_instance.g_class == NULL) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1168 "util.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1172 "util.c"
		}
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		value->data[0].v_pointer = unknown_total_monitor_ref (object);
#line 1176 "util.c"
	} else {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		value->data[0].v_pointer = NULL;
#line 1180 "util.c"
	}
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	return NULL;
#line 1184 "util.c"
}


static gchar* value_unknown_total_monitor_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	UnknownTotalMonitor** object_p;
	object_p = collect_values[0].v_pointer;
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	if (!object_p) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1195 "util.c"
	}
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	if (!value->data[0].v_pointer) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		*object_p = NULL;
#line 1201 "util.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		*object_p = value->data[0].v_pointer;
#line 1205 "util.c"
	} else {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		*object_p = unknown_total_monitor_ref (value->data[0].v_pointer);
#line 1209 "util.c"
	}
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	return NULL;
#line 1213 "util.c"
}


GParamSpec* param_spec_unknown_total_monitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecUnknownTotalMonitor* spec;
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_UNKNOWN_TOTAL_MONITOR), NULL);
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	return G_PARAM_SPEC (spec);
#line 1227 "util.c"
}


gpointer value_get_unknown_total_monitor (const GValue* value) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UNKNOWN_TOTAL_MONITOR), NULL);
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	return value->data[0].v_pointer;
#line 1236 "util.c"
}


void value_set_unknown_total_monitor (GValue* value, gpointer v_object) {
	UnknownTotalMonitor* old;
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UNKNOWN_TOTAL_MONITOR));
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	old = value->data[0].v_pointer;
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	if (v_object) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_UNKNOWN_TOTAL_MONITOR));
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		value->data[0].v_pointer = v_object;
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		unknown_total_monitor_ref (value->data[0].v_pointer);
#line 1256 "util.c"
	} else {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		value->data[0].v_pointer = NULL;
#line 1260 "util.c"
	}
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	if (old) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		unknown_total_monitor_unref (old);
#line 1266 "util.c"
	}
}


void value_take_unknown_total_monitor (GValue* value, gpointer v_object) {
	UnknownTotalMonitor* old;
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UNKNOWN_TOTAL_MONITOR));
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	old = value->data[0].v_pointer;
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	if (v_object) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_UNKNOWN_TOTAL_MONITOR));
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		value->data[0].v_pointer = v_object;
#line 1285 "util.c"
	} else {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		value->data[0].v_pointer = NULL;
#line 1289 "util.c"
	}
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	if (old) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		unknown_total_monitor_unref (old);
#line 1295 "util.c"
	}
}


static void unknown_total_monitor_class_init (UnknownTotalMonitorClass * klass) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	unknown_total_monitor_parent_class = g_type_class_peek_parent (klass);
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	((UnknownTotalMonitorClass *) klass)->finalize = unknown_total_monitor_finalize;
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	g_type_class_add_private (klass, sizeof (UnknownTotalMonitorPrivate));
#line 1307 "util.c"
}


static void unknown_total_monitor_instance_init (UnknownTotalMonitor * self) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv = UNKNOWN_TOTAL_MONITOR_GET_PRIVATE (self);
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	self->ref_count = 1;
#line 1316 "util.c"
}


static void unknown_total_monitor_finalize (UnknownTotalMonitor* obj) {
	UnknownTotalMonitor * self;
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UNKNOWN_TOTAL_MONITOR, UnknownTotalMonitor);
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	g_signal_handlers_destroy (self);
#line 1326 "util.c"
}


GType unknown_total_monitor_get_type (void) {
	static volatile gsize unknown_total_monitor_type_id__volatile = 0;
	if (g_once_init_enter (&unknown_total_monitor_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_unknown_total_monitor_init, value_unknown_total_monitor_free_value, value_unknown_total_monitor_copy_value, value_unknown_total_monitor_peek_pointer, "p", value_unknown_total_monitor_collect_value, "p", value_unknown_total_monitor_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UnknownTotalMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unknown_total_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnknownTotalMonitor), 0, (GInstanceInitFunc) unknown_total_monitor_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType unknown_total_monitor_type_id;
		unknown_total_monitor_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UnknownTotalMonitor", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&unknown_total_monitor_type_id__volatile, unknown_total_monitor_type_id);
	}
	return unknown_total_monitor_type_id__volatile;
}


gpointer unknown_total_monitor_ref (gpointer instance) {
	UnknownTotalMonitor* self;
	self = instance;
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	g_atomic_int_inc (&self->ref_count);
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	return instance;
#line 1351 "util.c"
}


void unknown_total_monitor_unref (gpointer instance) {
	UnknownTotalMonitor* self;
	self = instance;
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		UNKNOWN_TOTAL_MONITOR_GET_CLASS (self)->finalize (self);
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1364 "util.c"
	}
}


AggregateProgressMonitor* aggregate_progress_monitor_construct (GType object_type, guint64 grand_total, ProgressMonitor wrapped_monitor, void* wrapped_monitor_target) {
	AggregateProgressMonitor* self = NULL;
	guint64 _tmp0_ = 0ULL;
	ProgressMonitor _tmp1_ = NULL;
	void* _tmp1__target = NULL;
#line 165 "/home/jens/Source/shotwell/src/core/util.vala"
	self = (AggregateProgressMonitor*) g_type_create_instance (object_type);
#line 166 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0_ = grand_total;
#line 166 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->grand_total = _tmp0_;
#line 167 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp1_ = wrapped_monitor;
#line 167 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp1__target = wrapped_monitor_target;
#line 167 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->wrapped_monitor = _tmp1_;
#line 167 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->wrapped_monitor_target = _tmp1__target;
#line 165 "/home/jens/Source/shotwell/src/core/util.vala"
	return self;
#line 1390 "util.c"
}


AggregateProgressMonitor* aggregate_progress_monitor_new (guint64 grand_total, ProgressMonitor wrapped_monitor, void* wrapped_monitor_target) {
#line 165 "/home/jens/Source/shotwell/src/core/util.vala"
	return aggregate_progress_monitor_construct (TYPE_AGGREGATE_PROGRESS_MONITOR, grand_total, wrapped_monitor, wrapped_monitor_target);
#line 1397 "util.c"
}


void aggregate_progress_monitor_next_step (AggregateProgressMonitor* self, const gchar* name) {
	const gchar* _tmp0_ = NULL;
	guint64 _tmp1_ = 0ULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	guint64 _tmp4_ = 0ULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
#line 170 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_if_fail (IS_AGGREGATE_PROGRESS_MONITOR (self));
#line 170 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_if_fail (name != NULL);
#line 171 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0_ = name;
#line 171 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp1_ = self->priv->aggregate_count;
#line 171 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp2_ = g_strdup_printf ("%" G_GUINT64_FORMAT, _tmp1_);
#line 171 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp3_ = _tmp2_;
#line 171 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp4_ = self->priv->grand_total;
#line 171 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp5_ = g_strdup_printf ("%" G_GUINT64_FORMAT, _tmp4_);
#line 171 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp6_ = _tmp5_;
#line 171 "/home/jens/Source/shotwell/src/core/util.vala"
	g_debug ("util.vala:171: next step: %s (%s/%s)", _tmp0_, _tmp3_, _tmp6_);
#line 171 "/home/jens/Source/shotwell/src/core/util.vala"
	_g_free0 (_tmp6_);
#line 171 "/home/jens/Source/shotwell/src/core/util.vala"
	_g_free0 (_tmp3_);
#line 172 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->last_count = G_MAXUINT64;
#line 1435 "util.c"
}


gboolean aggregate_progress_monitor_monitor (AggregateProgressMonitor* self, guint64 count, guint64 total) {
	gboolean result = FALSE;
	guint64 _tmp0_ = 0ULL;
	guint64 _tmp1_ = 0ULL;
	guint64 _tmp5_ = 0ULL;
	guint64 _tmp6_ = 0ULL;
	guint64 _tmp7_ = 0ULL;
	guint64 _tmp9_ = 0ULL;
	ProgressMonitor _tmp10_ = NULL;
	void* _tmp10__target = NULL;
	guint64 _tmp11_ = 0ULL;
	guint64 _tmp12_ = 0ULL;
	gboolean _tmp13_ = FALSE;
#line 175 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_val_if_fail (IS_AGGREGATE_PROGRESS_MONITOR (self), FALSE);
#line 177 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp1_ = self->priv->last_count;
#line 177 "/home/jens/Source/shotwell/src/core/util.vala"
	if (_tmp1_ != G_MAXUINT64) {
#line 1458 "util.c"
		guint64 _tmp2_ = 0ULL;
		guint64 _tmp3_ = 0ULL;
#line 177 "/home/jens/Source/shotwell/src/core/util.vala"
		_tmp2_ = count;
#line 177 "/home/jens/Source/shotwell/src/core/util.vala"
		_tmp3_ = self->priv->last_count;
#line 177 "/home/jens/Source/shotwell/src/core/util.vala"
		_tmp0_ = _tmp2_ - _tmp3_;
#line 1467 "util.c"
	} else {
		guint64 _tmp4_ = 0ULL;
#line 177 "/home/jens/Source/shotwell/src/core/util.vala"
		_tmp4_ = count;
#line 177 "/home/jens/Source/shotwell/src/core/util.vala"
		_tmp0_ = _tmp4_;
#line 1474 "util.c"
	}
#line 177 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp5_ = self->priv->aggregate_count;
#line 177 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->aggregate_count = _tmp5_ + _tmp0_;
#line 178 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp6_ = self->priv->aggregate_count;
#line 178 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp7_ = self->priv->grand_total;
#line 178 "/home/jens/Source/shotwell/src/core/util.vala"
	if (_tmp6_ > _tmp7_) {
#line 1486 "util.c"
		guint64 _tmp8_ = 0ULL;
#line 179 "/home/jens/Source/shotwell/src/core/util.vala"
		_tmp8_ = self->priv->grand_total;
#line 179 "/home/jens/Source/shotwell/src/core/util.vala"
		self->priv->aggregate_count = _tmp8_;
#line 1492 "util.c"
	}
#line 182 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp9_ = count;
#line 182 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->last_count = _tmp9_;
#line 184 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp10_ = self->priv->wrapped_monitor;
#line 184 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp10__target = self->priv->wrapped_monitor_target;
#line 184 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp11_ = self->priv->aggregate_count;
#line 184 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp12_ = self->priv->grand_total;
#line 184 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp13_ = _tmp10_ (_tmp11_, _tmp12_, TRUE, _tmp10__target);
#line 184 "/home/jens/Source/shotwell/src/core/util.vala"
	result = _tmp13_;
#line 184 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 1512 "util.c"
}


static void value_aggregate_progress_monitor_init (GValue* value) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	value->data[0].v_pointer = NULL;
#line 1519 "util.c"
}


static void value_aggregate_progress_monitor_free_value (GValue* value) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	if (value->data[0].v_pointer) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		aggregate_progress_monitor_unref (value->data[0].v_pointer);
#line 1528 "util.c"
	}
}


static void value_aggregate_progress_monitor_copy_value (const GValue* src_value, GValue* dest_value) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	if (src_value->data[0].v_pointer) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		dest_value->data[0].v_pointer = aggregate_progress_monitor_ref (src_value->data[0].v_pointer);
#line 1538 "util.c"
	} else {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1542 "util.c"
	}
}


static gpointer value_aggregate_progress_monitor_peek_pointer (const GValue* value) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	return value->data[0].v_pointer;
#line 1550 "util.c"
}


static gchar* value_aggregate_progress_monitor_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	if (collect_values[0].v_pointer) {
#line 1557 "util.c"
		AggregateProgressMonitor* object;
		object = collect_values[0].v_pointer;
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		if (object->parent_instance.g_class == NULL) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1564 "util.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1568 "util.c"
		}
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		value->data[0].v_pointer = aggregate_progress_monitor_ref (object);
#line 1572 "util.c"
	} else {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		value->data[0].v_pointer = NULL;
#line 1576 "util.c"
	}
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	return NULL;
#line 1580 "util.c"
}


static gchar* value_aggregate_progress_monitor_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	AggregateProgressMonitor** object_p;
	object_p = collect_values[0].v_pointer;
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	if (!object_p) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1591 "util.c"
	}
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	if (!value->data[0].v_pointer) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		*object_p = NULL;
#line 1597 "util.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		*object_p = value->data[0].v_pointer;
#line 1601 "util.c"
	} else {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		*object_p = aggregate_progress_monitor_ref (value->data[0].v_pointer);
#line 1605 "util.c"
	}
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	return NULL;
#line 1609 "util.c"
}


GParamSpec* param_spec_aggregate_progress_monitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecAggregateProgressMonitor* spec;
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_AGGREGATE_PROGRESS_MONITOR), NULL);
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	return G_PARAM_SPEC (spec);
#line 1623 "util.c"
}


gpointer value_get_aggregate_progress_monitor (const GValue* value) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AGGREGATE_PROGRESS_MONITOR), NULL);
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	return value->data[0].v_pointer;
#line 1632 "util.c"
}


void value_set_aggregate_progress_monitor (GValue* value, gpointer v_object) {
	AggregateProgressMonitor* old;
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AGGREGATE_PROGRESS_MONITOR));
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	old = value->data[0].v_pointer;
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	if (v_object) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AGGREGATE_PROGRESS_MONITOR));
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		value->data[0].v_pointer = v_object;
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		aggregate_progress_monitor_ref (value->data[0].v_pointer);
#line 1652 "util.c"
	} else {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		value->data[0].v_pointer = NULL;
#line 1656 "util.c"
	}
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	if (old) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		aggregate_progress_monitor_unref (old);
#line 1662 "util.c"
	}
}


void value_take_aggregate_progress_monitor (GValue* value, gpointer v_object) {
	AggregateProgressMonitor* old;
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AGGREGATE_PROGRESS_MONITOR));
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	old = value->data[0].v_pointer;
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	if (v_object) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AGGREGATE_PROGRESS_MONITOR));
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		value->data[0].v_pointer = v_object;
#line 1681 "util.c"
	} else {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		value->data[0].v_pointer = NULL;
#line 1685 "util.c"
	}
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	if (old) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		aggregate_progress_monitor_unref (old);
#line 1691 "util.c"
	}
}


static void aggregate_progress_monitor_class_init (AggregateProgressMonitorClass * klass) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	aggregate_progress_monitor_parent_class = g_type_class_peek_parent (klass);
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	((AggregateProgressMonitorClass *) klass)->finalize = aggregate_progress_monitor_finalize;
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	g_type_class_add_private (klass, sizeof (AggregateProgressMonitorPrivate));
#line 1703 "util.c"
}


static void aggregate_progress_monitor_instance_init (AggregateProgressMonitor * self) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv = AGGREGATE_PROGRESS_MONITOR_GET_PRIVATE (self);
#line 162 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->aggregate_count = (guint64) 0;
#line 163 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->last_count = G_MAXUINT64;
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	self->ref_count = 1;
#line 1716 "util.c"
}


static void aggregate_progress_monitor_finalize (AggregateProgressMonitor* obj) {
	AggregateProgressMonitor * self;
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AGGREGATE_PROGRESS_MONITOR, AggregateProgressMonitor);
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	g_signal_handlers_destroy (self);
#line 1726 "util.c"
}


GType aggregate_progress_monitor_get_type (void) {
	static volatile gsize aggregate_progress_monitor_type_id__volatile = 0;
	if (g_once_init_enter (&aggregate_progress_monitor_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_aggregate_progress_monitor_init, value_aggregate_progress_monitor_free_value, value_aggregate_progress_monitor_copy_value, value_aggregate_progress_monitor_peek_pointer, "p", value_aggregate_progress_monitor_collect_value, "p", value_aggregate_progress_monitor_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AggregateProgressMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) aggregate_progress_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AggregateProgressMonitor), 0, (GInstanceInitFunc) aggregate_progress_monitor_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType aggregate_progress_monitor_type_id;
		aggregate_progress_monitor_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AggregateProgressMonitor", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&aggregate_progress_monitor_type_id__volatile, aggregate_progress_monitor_type_id);
	}
	return aggregate_progress_monitor_type_id__volatile;
}


gpointer aggregate_progress_monitor_ref (gpointer instance) {
	AggregateProgressMonitor* self;
	self = instance;
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	g_atomic_int_inc (&self->ref_count);
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	return instance;
#line 1751 "util.c"
}


void aggregate_progress_monitor_unref (gpointer instance) {
	AggregateProgressMonitor* self;
	self = instance;
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		AGGREGATE_PROGRESS_MONITOR_GET_CLASS (self)->finalize (self);
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1764 "util.c"
	}
}


gboolean null_progress_monitor (guint64 count, guint64 total) {
	gboolean result = FALSE;
#line 190 "/home/jens/Source/shotwell/src/core/util.vala"
	result = TRUE;
#line 190 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 1775 "util.c"
}


gdouble degrees_to_radians (gdouble theta) {
	gdouble result = 0.0;
	gdouble _tmp0_ = 0.0;
#line 195 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0_ = theta;
#line 195 "/home/jens/Source/shotwell/src/core/util.vala"
	result = _tmp0_ * (G_PI / 180.0);
#line 195 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 1788 "util.c"
}



