/* DataObject.c generated by valac 0.34.1, the Vala compiler
 * generated from DataObject.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/**/
/* DataObject*/
/**/
/* Object IDs are incremented for each DataObject, and therefore may be used to compare*/
/* creation order.  This behavior may be relied upon elsewhere.  Object IDs may be recycled when*/
/* DataObjects are reconstituted by a proxy.*/
/**/
/* Ordinal IDs are supplied by DataCollections to record the ordering of the object being added*/
/* to the collection.  This value is primarily only used by DataCollection, but may be used*/
/* elsewhere to resolve ordering questions (including stabilizing a sort).*/
/**/
/* Have to inherit from Object due to ContainerSource and this bug:*/
/* https://bugzilla.gnome.org/show_bug.cgi?id=615904*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataObjectPrivate {
	gint64 object_id;
	DataCollection* member_of;
	gint64 ordinal;
};

typedef gboolean (*ValueEqualFunc) (GValue* a, GValue* b, void* user_data);

static gpointer data_object_parent_class = NULL;
static gint64 data_object_object_id_generator;
static gint64 data_object_object_id_generator = (gint64) 0;

GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_alteration (GValue* value, gpointer v_object);
void value_take_alteration (GValue* value, gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_collection (GValue* value, gpointer v_object);
void value_take_data_collection (GValue* value, gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
#define DATA_OBJECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DATA_OBJECT, DataObjectPrivate))
enum  {
	DATA_OBJECT_DUMMY_PROPERTY
};
#define DATA_OBJECT_INVALID_OBJECT_ID ((gint64) -1)
#define DATA_COLLECTION_INVALID_OBJECT_ORDINAL ((gint64) -1)
DataObject* data_object_construct (GType object_type, gint64 object_id);
void data_object_notify_altered (DataObject* self, Alteration* alteration);
static void data_object_real_notify_altered (DataObject* self, Alteration* alteration);
void data_collection_internal_notify_altered (DataCollection* self, DataObject* object, Alteration* alteration);
void data_object_notify_membership_changed (DataObject* self, DataCollection* collection);
static void data_object_real_notify_membership_changed (DataObject* self, DataCollection* collection);
void data_object_notify_collection_property_set (DataObject* self, const gchar* name, GValue* old, GValue* val);
static void data_object_real_notify_collection_property_set (DataObject* self, const gchar* name, GValue* old, GValue* val);
void data_object_notify_collection_property_cleared (DataObject* self, const gchar* name);
static void data_object_real_notify_collection_property_cleared (DataObject* self, const gchar* name);
gchar* data_object_get_name (DataObject* self);
static gchar* data_object_real_get_name (DataObject* self);
gchar* data_object_to_string (DataObject* self);
static gchar* data_object_real_to_string (DataObject* self);
DataCollection* data_object_get_membership (DataObject* self);
gboolean data_object_has_membership (DataObject* self);
void data_object_internal_set_membership (DataObject* self, DataCollection* collection, gint64 ordinal);
void data_object_internal_set_ordinal (DataObject* self, gint64 ordinal);
void data_object_internal_clear_membership (DataObject* self);
gint64 data_object_internal_get_ordinal (DataObject* self);
gint64 data_object_get_object_id (DataObject* self);
void data_object_get_collection_property (DataObject* self, const gchar* name, GValue* def, GValue* result);
GValue* data_collection_get_property (DataCollection* self, const gchar* name);
static void _vala_GValue_free (GValue* self);
void data_object_set_collection_property (DataObject* self, const gchar* name, GValue* val, ValueEqualFunc value_equals, void* value_equals_target);
void data_collection_set_property (DataCollection* self, const gchar* name, GValue* val, ValueEqualFunc value_equals, void* value_equals_target);
void data_object_clear_collection_property (DataObject* self, const gchar* name);
void data_collection_clear_property (DataCollection* self, const gchar* name);
static void data_object_finalize (GObject* obj);


DataObject* data_object_construct (GType object_type, gint64 object_id) {
	DataObject * self = NULL;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_ = 0LL;
#line 38 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	self = (DataObject*) g_object_new (object_type, NULL);
#line 39 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	_tmp1_ = object_id;
#line 39 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	if (_tmp1_ == DATA_OBJECT_INVALID_OBJECT_ID) {
#line 156 "DataObject.c"
		gint64 _tmp2_ = 0LL;
#line 39 "/home/jens/Source/shotwell/src/core/DataObject.vala"
		_tmp2_ = data_object_object_id_generator;
#line 39 "/home/jens/Source/shotwell/src/core/DataObject.vala"
		data_object_object_id_generator = _tmp2_ + 1;
#line 39 "/home/jens/Source/shotwell/src/core/DataObject.vala"
		_tmp0_ = _tmp2_;
#line 164 "DataObject.c"
	} else {
		gint64 _tmp3_ = 0LL;
#line 39 "/home/jens/Source/shotwell/src/core/DataObject.vala"
		_tmp3_ = object_id;
#line 39 "/home/jens/Source/shotwell/src/core/DataObject.vala"
		_tmp0_ = _tmp3_;
#line 171 "DataObject.c"
	}
#line 39 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	self->priv->object_id = _tmp0_;
#line 38 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	return self;
#line 177 "DataObject.c"
}


static void data_object_real_notify_altered (DataObject* self, Alteration* alteration) {
	DataCollection* _tmp0_ = NULL;
#line 42 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	g_return_if_fail (IS_ALTERATION (alteration));
#line 43 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	_tmp0_ = self->priv->member_of;
#line 43 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	if (_tmp0_ != NULL) {
#line 189 "DataObject.c"
		DataCollection* _tmp1_ = NULL;
		Alteration* _tmp2_ = NULL;
#line 44 "/home/jens/Source/shotwell/src/core/DataObject.vala"
		_tmp1_ = self->priv->member_of;
#line 44 "/home/jens/Source/shotwell/src/core/DataObject.vala"
		_tmp2_ = alteration;
#line 44 "/home/jens/Source/shotwell/src/core/DataObject.vala"
		data_collection_internal_notify_altered (_tmp1_, self, _tmp2_);
#line 198 "DataObject.c"
	}
}


void data_object_notify_altered (DataObject* self, Alteration* alteration) {
#line 42 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	g_return_if_fail (IS_DATA_OBJECT (self));
#line 42 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	DATA_OBJECT_GET_CLASS (self)->notify_altered (self, alteration);
#line 208 "DataObject.c"
}


static void data_object_real_notify_membership_changed (DataObject* self, DataCollection* collection) {
#line 56 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	g_return_if_fail ((collection == NULL) || IS_DATA_COLLECTION (collection));
#line 215 "DataObject.c"
}


void data_object_notify_membership_changed (DataObject* self, DataCollection* collection) {
#line 56 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	g_return_if_fail (IS_DATA_OBJECT (self));
#line 56 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	DATA_OBJECT_GET_CLASS (self)->notify_membership_changed (self, collection);
#line 224 "DataObject.c"
}


static void data_object_real_notify_collection_property_set (DataObject* self, const gchar* name, GValue* old, GValue* val) {
#line 61 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	g_return_if_fail (name != NULL);
#line 61 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	g_return_if_fail (val != NULL);
#line 233 "DataObject.c"
}


void data_object_notify_collection_property_set (DataObject* self, const gchar* name, GValue* old, GValue* val) {
#line 61 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	g_return_if_fail (IS_DATA_OBJECT (self));
#line 61 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	DATA_OBJECT_GET_CLASS (self)->notify_collection_property_set (self, name, old, val);
#line 242 "DataObject.c"
}


static void data_object_real_notify_collection_property_cleared (DataObject* self, const gchar* name) {
#line 66 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	g_return_if_fail (name != NULL);
#line 249 "DataObject.c"
}


void data_object_notify_collection_property_cleared (DataObject* self, const gchar* name) {
#line 66 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	g_return_if_fail (IS_DATA_OBJECT (self));
#line 66 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	DATA_OBJECT_GET_CLASS (self)->notify_collection_property_cleared (self, name);
#line 258 "DataObject.c"
}


static gchar* data_object_real_get_name (DataObject* self) {
#line 69 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	g_critical ("Type `%s' does not implement abstract method `data_object_get_name'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 69 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	return NULL;
#line 267 "DataObject.c"
}


gchar* data_object_get_name (DataObject* self) {
#line 69 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (self), NULL);
#line 69 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	return DATA_OBJECT_GET_CLASS (self)->get_name (self);
#line 276 "DataObject.c"
}


static gchar* data_object_real_to_string (DataObject* self) {
#line 71 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	g_critical ("Type `%s' does not implement abstract method `data_object_to_string'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 71 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	return NULL;
#line 285 "DataObject.c"
}


gchar* data_object_to_string (DataObject* self) {
#line 71 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (self), NULL);
#line 71 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	return DATA_OBJECT_GET_CLASS (self)->to_string (self);
#line 294 "DataObject.c"
}


static gpointer _data_collection_ref0 (gpointer self) {
#line 74 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	return self ? data_collection_ref (self) : NULL;
#line 301 "DataObject.c"
}


DataCollection* data_object_get_membership (DataObject* self) {
	DataCollection* result = NULL;
	DataCollection* _tmp0_ = NULL;
	DataCollection* _tmp1_ = NULL;
#line 73 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (self), NULL);
#line 74 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	_tmp0_ = self->priv->member_of;
#line 74 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	_tmp1_ = _data_collection_ref0 (_tmp0_);
#line 74 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	result = _tmp1_;
#line 74 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	return result;
#line 319 "DataObject.c"
}


gboolean data_object_has_membership (DataObject* self) {
	gboolean result = FALSE;
	DataCollection* _tmp0_ = NULL;
#line 77 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (self), FALSE);
#line 78 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	_tmp0_ = self->priv->member_of;
#line 78 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	result = _tmp0_ != NULL;
#line 78 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	return result;
#line 334 "DataObject.c"
}


void data_object_internal_set_membership (DataObject* self, DataCollection* collection, gint64 ordinal) {
	DataCollection* _tmp0_ = NULL;
	DataCollection* _tmp1_ = NULL;
	DataCollection* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
#line 83 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	g_return_if_fail (IS_DATA_OBJECT (self));
#line 83 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	g_return_if_fail (IS_DATA_COLLECTION (collection));
#line 84 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	_tmp0_ = self->priv->member_of;
#line 84 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	_vala_assert (_tmp0_ == NULL, "member_of == null");
#line 86 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	_tmp1_ = collection;
#line 86 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	_tmp2_ = _data_collection_ref0 (_tmp1_);
#line 86 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	_data_collection_unref0 (self->priv->member_of);
#line 86 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	self->priv->member_of = _tmp2_;
#line 87 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	_tmp3_ = ordinal;
#line 87 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	self->priv->ordinal = _tmp3_;
#line 363 "DataObject.c"
}


void data_object_internal_set_ordinal (DataObject* self, gint64 ordinal) {
	DataCollection* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
#line 96 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	g_return_if_fail (IS_DATA_OBJECT (self));
#line 97 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	_tmp0_ = self->priv->member_of;
#line 97 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	_vala_assert (_tmp0_ == NULL, "member_of == null");
#line 99 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	_tmp1_ = ordinal;
#line 99 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	self->priv->ordinal = _tmp1_;
#line 380 "DataObject.c"
}


void data_object_internal_clear_membership (DataObject* self) {
#line 104 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	g_return_if_fail (IS_DATA_OBJECT (self));
#line 105 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	_data_collection_unref0 (self->priv->member_of);
#line 105 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	self->priv->member_of = NULL;
#line 106 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	self->priv->ordinal = DATA_COLLECTION_INVALID_OBJECT_ORDINAL;
#line 393 "DataObject.c"
}


inline gint64 data_object_internal_get_ordinal (DataObject* self) {
	gint64 result = 0LL;
	gint64 _tmp0_ = 0LL;
#line 110 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (self), 0LL);
#line 111 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	_tmp0_ = self->priv->ordinal;
#line 111 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	result = _tmp0_;
#line 111 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	return result;
#line 408 "DataObject.c"
}


inline gint64 data_object_get_object_id (DataObject* self) {
	gint64 result = 0LL;
	gint64 _tmp0_ = 0LL;
#line 114 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (self), 0LL);
#line 115 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	_tmp0_ = self->priv->object_id;
#line 115 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	result = _tmp0_;
#line 115 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	return result;
#line 423 "DataObject.c"
}


static void _vala_GValue_free (GValue* self) {
#line 124 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	g_value_unset (self);
#line 124 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	g_free (self);
#line 432 "DataObject.c"
}


void data_object_get_collection_property (DataObject* self, const gchar* name, GValue* def, GValue* result) {
	DataCollection* _tmp0_ = NULL;
	GValue* _result_ = NULL;
	DataCollection* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GValue* _tmp5_ = NULL;
	GValue* _tmp6_ = NULL;
	GValue* _tmp7_ = NULL;
	GValue _tmp10_ = {0};
#line 118 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	g_return_if_fail (IS_DATA_OBJECT (self));
#line 118 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	g_return_if_fail (name != NULL);
#line 119 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	_tmp0_ = self->priv->member_of;
#line 119 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	if (_tmp0_ == NULL) {
#line 453 "DataObject.c"
		GValue* _tmp1_ = NULL;
		GValue _tmp2_ = {0};
#line 120 "/home/jens/Source/shotwell/src/core/DataObject.vala"
		_tmp1_ = def;
#line 120 "/home/jens/Source/shotwell/src/core/DataObject.vala"
		if (G_IS_VALUE (_tmp1_)) {
#line 120 "/home/jens/Source/shotwell/src/core/DataObject.vala"
			g_value_init (&_tmp2_, G_VALUE_TYPE (_tmp1_));
#line 120 "/home/jens/Source/shotwell/src/core/DataObject.vala"
			g_value_copy (_tmp1_, &_tmp2_);
#line 464 "DataObject.c"
		} else {
#line 120 "/home/jens/Source/shotwell/src/core/DataObject.vala"
			_tmp2_ = *_tmp1_;
#line 468 "DataObject.c"
		}
#line 120 "/home/jens/Source/shotwell/src/core/DataObject.vala"
		*result = _tmp2_;
#line 120 "/home/jens/Source/shotwell/src/core/DataObject.vala"
		return;
#line 474 "DataObject.c"
	}
#line 122 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	_tmp3_ = self->priv->member_of;
#line 122 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	_tmp4_ = name;
#line 122 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	_tmp5_ = data_collection_get_property (_tmp3_, _tmp4_);
#line 122 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	_result_ = _tmp5_;
#line 124 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	_tmp7_ = _result_;
#line 124 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	if (_tmp7_ != NULL) {
#line 488 "DataObject.c"
		GValue* _tmp8_ = NULL;
#line 124 "/home/jens/Source/shotwell/src/core/DataObject.vala"
		_tmp8_ = _result_;
#line 124 "/home/jens/Source/shotwell/src/core/DataObject.vala"
		_tmp6_ = _tmp8_;
#line 494 "DataObject.c"
	} else {
		GValue* _tmp9_ = NULL;
#line 124 "/home/jens/Source/shotwell/src/core/DataObject.vala"
		_tmp9_ = def;
#line 124 "/home/jens/Source/shotwell/src/core/DataObject.vala"
		_tmp6_ = _tmp9_;
#line 501 "DataObject.c"
	}
#line 124 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	if (G_IS_VALUE (_tmp6_)) {
#line 124 "/home/jens/Source/shotwell/src/core/DataObject.vala"
		g_value_init (&_tmp10_, G_VALUE_TYPE (_tmp6_));
#line 124 "/home/jens/Source/shotwell/src/core/DataObject.vala"
		g_value_copy (_tmp6_, &_tmp10_);
#line 509 "DataObject.c"
	} else {
#line 124 "/home/jens/Source/shotwell/src/core/DataObject.vala"
		_tmp10_ = *_tmp6_;
#line 513 "DataObject.c"
	}
#line 124 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	*result = _tmp10_;
#line 124 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	__vala_GValue_free0 (_result_);
#line 124 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	return;
#line 521 "DataObject.c"
}


void data_object_set_collection_property (DataObject* self, const gchar* name, GValue* val, ValueEqualFunc value_equals, void* value_equals_target) {
	DataCollection* _tmp0_ = NULL;
#line 127 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	g_return_if_fail (IS_DATA_OBJECT (self));
#line 127 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	g_return_if_fail (name != NULL);
#line 127 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	g_return_if_fail (val != NULL);
#line 128 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	_tmp0_ = self->priv->member_of;
#line 128 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	if (_tmp0_ != NULL) {
#line 537 "DataObject.c"
		DataCollection* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		GValue _tmp3_ = {0};
		ValueEqualFunc _tmp4_ = NULL;
		void* _tmp4__target = NULL;
#line 129 "/home/jens/Source/shotwell/src/core/DataObject.vala"
		_tmp1_ = self->priv->member_of;
#line 129 "/home/jens/Source/shotwell/src/core/DataObject.vala"
		_tmp2_ = name;
#line 129 "/home/jens/Source/shotwell/src/core/DataObject.vala"
		_tmp3_ = *val;
#line 129 "/home/jens/Source/shotwell/src/core/DataObject.vala"
		_tmp4_ = value_equals;
#line 129 "/home/jens/Source/shotwell/src/core/DataObject.vala"
		_tmp4__target = value_equals_target;
#line 129 "/home/jens/Source/shotwell/src/core/DataObject.vala"
		data_collection_set_property (_tmp1_, _tmp2_, &_tmp3_, _tmp4_, _tmp4__target);
#line 555 "DataObject.c"
	}
}


void data_object_clear_collection_property (DataObject* self, const gchar* name) {
	DataCollection* _tmp0_ = NULL;
#line 132 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	g_return_if_fail (IS_DATA_OBJECT (self));
#line 132 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	g_return_if_fail (name != NULL);
#line 133 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	_tmp0_ = self->priv->member_of;
#line 133 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	if (_tmp0_ != NULL) {
#line 570 "DataObject.c"
		DataCollection* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 134 "/home/jens/Source/shotwell/src/core/DataObject.vala"
		_tmp1_ = self->priv->member_of;
#line 134 "/home/jens/Source/shotwell/src/core/DataObject.vala"
		_tmp2_ = name;
#line 134 "/home/jens/Source/shotwell/src/core/DataObject.vala"
		data_collection_clear_property (_tmp1_, _tmp2_);
#line 579 "DataObject.c"
	}
}


static void data_object_class_init (DataObjectClass * klass) {
#line 21 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	data_object_parent_class = g_type_class_peek_parent (klass);
#line 21 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	g_type_class_add_private (klass, sizeof (DataObjectPrivate));
#line 21 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	((DataObjectClass *) klass)->notify_altered = data_object_real_notify_altered;
#line 21 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	((DataObjectClass *) klass)->notify_membership_changed = data_object_real_notify_membership_changed;
#line 21 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	((DataObjectClass *) klass)->notify_collection_property_set = data_object_real_notify_collection_property_set;
#line 21 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	((DataObjectClass *) klass)->notify_collection_property_cleared = data_object_real_notify_collection_property_cleared;
#line 21 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	((DataObjectClass *) klass)->get_name = data_object_real_get_name;
#line 21 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	((DataObjectClass *) klass)->to_string = data_object_real_to_string;
#line 21 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	G_OBJECT_CLASS (klass)->finalize = data_object_finalize;
#line 603 "DataObject.c"
}


static void data_object_instance_init (DataObject * self) {
#line 21 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	self->priv = DATA_OBJECT_GET_PRIVATE (self);
#line 32 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	self->priv->object_id = DATA_OBJECT_INVALID_OBJECT_ID;
#line 33 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	self->priv->member_of = NULL;
#line 34 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	self->priv->ordinal = DATA_COLLECTION_INVALID_OBJECT_ORDINAL;
#line 616 "DataObject.c"
}


static void data_object_finalize (GObject* obj) {
	DataObject * self;
#line 21 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DATA_OBJECT, DataObject);
#line 33 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	_data_collection_unref0 (self->priv->member_of);
#line 21 "/home/jens/Source/shotwell/src/core/DataObject.vala"
	G_OBJECT_CLASS (data_object_parent_class)->finalize (obj);
#line 628 "DataObject.c"
}


GType data_object_get_type (void) {
	static volatile gsize data_object_type_id__volatile = 0;
	if (g_once_init_enter (&data_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DataObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) data_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DataObject), 0, (GInstanceInitFunc) data_object_instance_init, NULL };
		GType data_object_type_id;
		data_object_type_id = g_type_register_static (G_TYPE_OBJECT, "DataObject", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&data_object_type_id__volatile, data_object_type_id);
	}
	return data_object_type_id__volatile;
}



