/* Db.c generated by valac 0.32.1, the Vala compiler
 * generated from Db.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#define _g_free0(var) (var = (g_free (var), NULL))

#define DB_TYPE_VERIFY_RESULT (db_verify_result_get_type ())

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;

#define TYPE_VERSION_TABLE (version_table_get_type ())
#define VERSION_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VERSION_TABLE, VersionTable))
#define VERSION_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VERSION_TABLE, VersionTableClass))
#define IS_VERSION_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VERSION_TABLE))
#define IS_VERSION_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VERSION_TABLE))
#define VERSION_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VERSION_TABLE, VersionTableClass))

typedef struct _VersionTable VersionTable;
typedef struct _VersionTableClass VersionTableClass;
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))

#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;
#define _application_unref0(var) ((var == NULL) ? NULL : (var = (application_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	DB_VERIFY_RESULT_OK,
	DB_VERIFY_RESULT_FUTURE_VERSION,
	DB_VERIFY_RESULT_UPGRADE_ERROR,
	DB_VERIFY_RESULT_NO_UPGRADE_AVAILABLE
} DbVerifyResult;


extern gchar* db_filename;
gchar* db_filename = NULL;

#define DB_IN_MEMORY_NAME ":memory:"
void db_preconfigure (GFile* db_file);
void db_init (GError** error);
void database_table_init (const gchar* filename);
void db_terminate (void);
void database_table_terminate (void);
GType db_verify_result_get_type (void) G_GNUC_CONST;
DbVerifyResult db_verify_database (gchar** app_version, gint* schema_version);
gpointer database_table_ref (gpointer instance);
void database_table_unref (gpointer instance);
GParamSpec* param_spec_database_table (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_database_table (GValue* value, gpointer v_object);
void value_take_database_table (GValue* value, gpointer v_object);
gpointer value_get_database_table (const GValue* value);
GType database_table_get_type (void) G_GNUC_CONST;
GType version_table_get_type (void) G_GNUC_CONST;
VersionTable* version_table_get_instance (void);
gint version_table_get_version (VersionTable* self, gchar** app_version);
#define DATABASE_TABLE_SCHEMA_VERSION 20
#define RESOURCES_APP_VERSION _VERSION
void version_table_set_version (VersionTable* self, gint version, const gchar* app_version, const gchar* user_data);
DbVerifyResult db_upgrade_database (gint input_version);
gboolean database_table_has_column (const gchar* table_name, const gchar* column_name);
gboolean database_table_add_column (const gchar* table_name, const gchar* column_name, const gchar* column_constraints);
gboolean database_table_has_table (const gchar* table_name);
gboolean database_table_ensure_column (const gchar* table_name, const gchar* column_name, const gchar* column_constraints, const gchar* upgrade_msg);
void tag_table_upgrade_for_htags (void);
void gsettings_configuration_engine_run_gsettings_migrator (void);
gpointer application_ref (gpointer instance);
void application_unref (gpointer instance);
GParamSpec* param_spec_application (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_application (GValue* value, gpointer v_object);
void value_take_application (GValue* value, gpointer v_object);
gpointer value_get_application (const GValue* value);
GType application_get_type (void) G_GNUC_CONST;
Application* application_get_instance (void);
void application_set_raw_thumbs_fix_required (Application* self, gboolean should_fixup);
void version_table_update_version (VersionTable* self, gint version, const gchar* app_version);


void db_preconfigure (GFile* db_file) {
	gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gchar* _tmp5_ = NULL;
#line 14 "/home/jens/Source/shotwell/src/db/Db.vala"
	g_return_if_fail ((db_file == NULL) || G_IS_FILE (db_file));
#line 15 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp1_ = db_file;
#line 15 "/home/jens/Source/shotwell/src/db/Db.vala"
	if (_tmp1_ != NULL) {
#line 118 "Db.c"
		GFile* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 15 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp2_ = db_file;
#line 15 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp3_ = g_file_get_path (_tmp2_);
#line 15 "/home/jens/Source/shotwell/src/db/Db.vala"
		_g_free0 (_tmp0_);
#line 15 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp0_ = _tmp3_;
#line 129 "Db.c"
	} else {
		gchar* _tmp4_ = NULL;
#line 15 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp4_ = g_strdup (DB_IN_MEMORY_NAME);
#line 15 "/home/jens/Source/shotwell/src/db/Db.vala"
		_g_free0 (_tmp0_);
#line 15 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp0_ = _tmp4_;
#line 138 "Db.c"
	}
#line 15 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp5_ = g_strdup (_tmp0_);
#line 15 "/home/jens/Source/shotwell/src/db/Db.vala"
	_g_free0 (db_filename);
#line 15 "/home/jens/Source/shotwell/src/db/Db.vala"
	db_filename = _tmp5_;
#line 14 "/home/jens/Source/shotwell/src/db/Db.vala"
	_g_free0 (_tmp0_);
#line 148 "Db.c"
}


void db_init (GError** error) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 19 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp0_ = db_filename;
#line 19 "/home/jens/Source/shotwell/src/db/Db.vala"
	_vala_assert (_tmp0_ != NULL, "filename != null");
#line 21 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp1_ = db_filename;
#line 21 "/home/jens/Source/shotwell/src/db/Db.vala"
	database_table_init (_tmp1_);
#line 163 "Db.c"
}


void db_terminate (void) {
#line 25 "/home/jens/Source/shotwell/src/db/Db.vala"
	database_table_terminate ();
#line 170 "Db.c"
}


GType db_verify_result_get_type (void) {
	static volatile gsize db_verify_result_type_id__volatile = 0;
	if (g_once_init_enter (&db_verify_result_type_id__volatile)) {
		static const GEnumValue values[] = {{DB_VERIFY_RESULT_OK, "DB_VERIFY_RESULT_OK", "ok"}, {DB_VERIFY_RESULT_FUTURE_VERSION, "DB_VERIFY_RESULT_FUTURE_VERSION", "future-version"}, {DB_VERIFY_RESULT_UPGRADE_ERROR, "DB_VERIFY_RESULT_UPGRADE_ERROR", "upgrade-error"}, {DB_VERIFY_RESULT_NO_UPGRADE_AVAILABLE, "DB_VERIFY_RESULT_NO_UPGRADE_AVAILABLE", "no-upgrade-available"}, {0, NULL, NULL}};
		GType db_verify_result_type_id;
		db_verify_result_type_id = g_enum_register_static ("DbVerifyResult", values);
		g_once_init_leave (&db_verify_result_type_id__volatile, db_verify_result_type_id);
	}
	return db_verify_result_type_id__volatile;
}


DbVerifyResult db_verify_database (gchar** app_version, gint* schema_version) {
	gchar* _vala_app_version = NULL;
	gint _vala_schema_version = 0;
	DbVerifyResult result = 0;
	VersionTable* version_table = NULL;
	VersionTable* _tmp0_ = NULL;
	VersionTable* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp7_ = 0;
#line 36 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp0_ = version_table_get_instance ();
#line 36 "/home/jens/Source/shotwell/src/db/Db.vala"
	version_table = _tmp0_;
#line 37 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp1_ = version_table;
#line 37 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp3_ = version_table_get_version (_tmp1_, &_tmp2_);
#line 37 "/home/jens/Source/shotwell/src/db/Db.vala"
	_g_free0 (_vala_app_version);
#line 37 "/home/jens/Source/shotwell/src/db/Db.vala"
	_vala_app_version = _tmp2_;
#line 37 "/home/jens/Source/shotwell/src/db/Db.vala"
	_vala_schema_version = _tmp3_;
#line 39 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp4_ = _vala_schema_version;
#line 39 "/home/jens/Source/shotwell/src/db/Db.vala"
	if (_tmp4_ >= 0) {
#line 215 "Db.c"
		gint _tmp5_ = 0;
		const gchar* _tmp6_ = NULL;
#line 40 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp5_ = _vala_schema_version;
#line 40 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp6_ = _vala_app_version;
#line 40 "/home/jens/Source/shotwell/src/db/Db.vala"
		g_debug ("Db.vala:40: Database schema version %d created by app version %s", _tmp5_, _tmp6_);
#line 224 "Db.c"
	}
#line 42 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp7_ = _vala_schema_version;
#line 42 "/home/jens/Source/shotwell/src/db/Db.vala"
	if (_tmp7_ == -1) {
#line 230 "Db.c"
		VersionTable* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 44 "/home/jens/Source/shotwell/src/db/Db.vala"
		g_debug ("Db.vala:44: Creating database schema version %d for app version %s", DATABASE_TABLE_SCHEMA_VERSION, RESOURCES_APP_VERSION);
#line 46 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp8_ = version_table;
#line 46 "/home/jens/Source/shotwell/src/db/Db.vala"
		version_table_set_version (_tmp8_, DATABASE_TABLE_SCHEMA_VERSION, RESOURCES_APP_VERSION, NULL);
#line 47 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp9_ = g_strdup (RESOURCES_APP_VERSION);
#line 47 "/home/jens/Source/shotwell/src/db/Db.vala"
		_g_free0 (_vala_app_version);
#line 47 "/home/jens/Source/shotwell/src/db/Db.vala"
		_vala_app_version = _tmp9_;
#line 48 "/home/jens/Source/shotwell/src/db/Db.vala"
		_vala_schema_version = DATABASE_TABLE_SCHEMA_VERSION;
#line 247 "Db.c"
	} else {
		gint _tmp10_ = 0;
#line 49 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp10_ = _vala_schema_version;
#line 49 "/home/jens/Source/shotwell/src/db/Db.vala"
		if (_tmp10_ > DATABASE_TABLE_SCHEMA_VERSION) {
#line 51 "/home/jens/Source/shotwell/src/db/Db.vala"
			result = DB_VERIFY_RESULT_FUTURE_VERSION;
#line 51 "/home/jens/Source/shotwell/src/db/Db.vala"
			_database_table_unref0 (version_table);
#line 51 "/home/jens/Source/shotwell/src/db/Db.vala"
			if (app_version) {
#line 51 "/home/jens/Source/shotwell/src/db/Db.vala"
				*app_version = _vala_app_version;
#line 262 "Db.c"
			} else {
#line 51 "/home/jens/Source/shotwell/src/db/Db.vala"
				_g_free0 (_vala_app_version);
#line 266 "Db.c"
			}
#line 51 "/home/jens/Source/shotwell/src/db/Db.vala"
			if (schema_version) {
#line 51 "/home/jens/Source/shotwell/src/db/Db.vala"
				*schema_version = _vala_schema_version;
#line 272 "Db.c"
			}
#line 51 "/home/jens/Source/shotwell/src/db/Db.vala"
			return result;
#line 276 "Db.c"
		} else {
			gint _tmp11_ = 0;
#line 52 "/home/jens/Source/shotwell/src/db/Db.vala"
			_tmp11_ = _vala_schema_version;
#line 52 "/home/jens/Source/shotwell/src/db/Db.vala"
			if (_tmp11_ < DATABASE_TABLE_SCHEMA_VERSION) {
#line 283 "Db.c"
				DbVerifyResult _result_ = 0;
				gint _tmp12_ = 0;
				DbVerifyResult _tmp13_ = 0;
				DbVerifyResult _tmp14_ = 0;
#line 54 "/home/jens/Source/shotwell/src/db/Db.vala"
				_tmp12_ = _vala_schema_version;
#line 54 "/home/jens/Source/shotwell/src/db/Db.vala"
				_tmp13_ = db_upgrade_database (_tmp12_);
#line 54 "/home/jens/Source/shotwell/src/db/Db.vala"
				_result_ = _tmp13_;
#line 55 "/home/jens/Source/shotwell/src/db/Db.vala"
				_tmp14_ = _result_;
#line 55 "/home/jens/Source/shotwell/src/db/Db.vala"
				if (_tmp14_ != DB_VERIFY_RESULT_OK) {
#line 56 "/home/jens/Source/shotwell/src/db/Db.vala"
					result = _result_;
#line 56 "/home/jens/Source/shotwell/src/db/Db.vala"
					_database_table_unref0 (version_table);
#line 56 "/home/jens/Source/shotwell/src/db/Db.vala"
					if (app_version) {
#line 56 "/home/jens/Source/shotwell/src/db/Db.vala"
						*app_version = _vala_app_version;
#line 306 "Db.c"
					} else {
#line 56 "/home/jens/Source/shotwell/src/db/Db.vala"
						_g_free0 (_vala_app_version);
#line 310 "Db.c"
					}
#line 56 "/home/jens/Source/shotwell/src/db/Db.vala"
					if (schema_version) {
#line 56 "/home/jens/Source/shotwell/src/db/Db.vala"
						*schema_version = _vala_schema_version;
#line 316 "Db.c"
					}
#line 56 "/home/jens/Source/shotwell/src/db/Db.vala"
					return result;
#line 320 "Db.c"
				}
			}
		}
	}
#line 59 "/home/jens/Source/shotwell/src/db/Db.vala"
	result = DB_VERIFY_RESULT_OK;
#line 59 "/home/jens/Source/shotwell/src/db/Db.vala"
	_database_table_unref0 (version_table);
#line 59 "/home/jens/Source/shotwell/src/db/Db.vala"
	if (app_version) {
#line 59 "/home/jens/Source/shotwell/src/db/Db.vala"
		*app_version = _vala_app_version;
#line 333 "Db.c"
	} else {
#line 59 "/home/jens/Source/shotwell/src/db/Db.vala"
		_g_free0 (_vala_app_version);
#line 337 "Db.c"
	}
#line 59 "/home/jens/Source/shotwell/src/db/Db.vala"
	if (schema_version) {
#line 59 "/home/jens/Source/shotwell/src/db/Db.vala"
		*schema_version = _vala_schema_version;
#line 343 "Db.c"
	}
#line 59 "/home/jens/Source/shotwell/src/db/Db.vala"
	return result;
#line 347 "Db.c"
}


DbVerifyResult db_upgrade_database (gint input_version) {
	DbVerifyResult result = 0;
	gint _tmp0_ = 0;
	gint version = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp33_ = FALSE;
	gint _tmp35_ = 0;
	gint _tmp36_ = 0;
	gboolean _tmp37_ = FALSE;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp41_ = FALSE;
	gint _tmp43_ = 0;
	gint _tmp46_ = 0;
	VersionTable* _tmp47_ = NULL;
	VersionTable* _tmp48_ = NULL;
	gint _tmp49_ = 0;
	gint _tmp50_ = 0;
#line 63 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp0_ = input_version;
#line 63 "/home/jens/Source/shotwell/src/db/Db.vala"
	_vala_assert (_tmp0_ < DATABASE_TABLE_SCHEMA_VERSION, "input_version < DatabaseTable.SCHEMA_VERSION");
#line 65 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp1_ = input_version;
#line 65 "/home/jens/Source/shotwell/src/db/Db.vala"
	version = _tmp1_;
#line 68 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp2_ = version;
#line 68 "/home/jens/Source/shotwell/src/db/Db.vala"
	if (_tmp2_ == 1) {
#line 69 "/home/jens/Source/shotwell/src/db/Db.vala"
		result = DB_VERIFY_RESULT_NO_UPGRADE_AVAILABLE;
#line 69 "/home/jens/Source/shotwell/src/db/Db.vala"
		return result;
#line 401 "Db.c"
	}
#line 71 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp3_ = version;
#line 71 "/home/jens/Source/shotwell/src/db/Db.vala"
	g_message ("Db.vala:71: Upgrading database from schema version %d to %d", _tmp3_, DATABASE_TABLE_SCHEMA_VERSION);
#line 83 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp4_ = database_table_has_column ("PhotoTable", "flags");
#line 83 "/home/jens/Source/shotwell/src/db/Db.vala"
	if (!_tmp4_) {
#line 411 "Db.c"
		gboolean _tmp5_ = FALSE;
#line 84 "/home/jens/Source/shotwell/src/db/Db.vala"
		g_message ("Db.vala:84: upgrade_database: adding flags column to PhotoTable");
#line 85 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp5_ = database_table_add_column ("PhotoTable", "flags", "INTEGER DEFAULT 0");
#line 85 "/home/jens/Source/shotwell/src/db/Db.vala"
		if (!_tmp5_) {
#line 86 "/home/jens/Source/shotwell/src/db/Db.vala"
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
#line 86 "/home/jens/Source/shotwell/src/db/Db.vala"
			return result;
#line 423 "Db.c"
		}
	}
#line 89 "/home/jens/Source/shotwell/src/db/Db.vala"
	version = 3;
#line 100 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp6_ = database_table_has_column ("PhotoTable", "file_format");
#line 100 "/home/jens/Source/shotwell/src/db/Db.vala"
	if (!_tmp6_) {
#line 432 "Db.c"
		gboolean _tmp7_ = FALSE;
#line 101 "/home/jens/Source/shotwell/src/db/Db.vala"
		g_message ("Db.vala:101: upgrade_database: adding file_format column to PhotoTable");
#line 102 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp7_ = database_table_add_column ("PhotoTable", "file_format", "INTEGER DEFAULT 0");
#line 102 "/home/jens/Source/shotwell/src/db/Db.vala"
		if (!_tmp7_) {
#line 103 "/home/jens/Source/shotwell/src/db/Db.vala"
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
#line 103 "/home/jens/Source/shotwell/src/db/Db.vala"
			return result;
#line 444 "Db.c"
		}
	}
#line 106 "/home/jens/Source/shotwell/src/db/Db.vala"
	version = 4;
#line 113 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp8_ = database_table_has_column ("PhotoTable", "title");
#line 113 "/home/jens/Source/shotwell/src/db/Db.vala"
	if (!_tmp8_) {
#line 453 "Db.c"
		gboolean _tmp9_ = FALSE;
#line 114 "/home/jens/Source/shotwell/src/db/Db.vala"
		g_message ("Db.vala:114: upgrade_database: adding title column to PhotoTable");
#line 115 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp9_ = database_table_add_column ("PhotoTable", "title", "TEXT");
#line 115 "/home/jens/Source/shotwell/src/db/Db.vala"
		if (!_tmp9_) {
#line 116 "/home/jens/Source/shotwell/src/db/Db.vala"
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
#line 116 "/home/jens/Source/shotwell/src/db/Db.vala"
			return result;
#line 465 "Db.c"
		}
	}
#line 119 "/home/jens/Source/shotwell/src/db/Db.vala"
	version = 5;
#line 126 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp10_ = database_table_has_column ("PhotoTable", "backlinks");
#line 126 "/home/jens/Source/shotwell/src/db/Db.vala"
	if (!_tmp10_) {
#line 474 "Db.c"
		gboolean _tmp11_ = FALSE;
#line 127 "/home/jens/Source/shotwell/src/db/Db.vala"
		g_message ("Db.vala:127: upgrade_database: adding backlinks column to PhotoTable");
#line 128 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp11_ = database_table_add_column ("PhotoTable", "backlinks", "TEXT");
#line 128 "/home/jens/Source/shotwell/src/db/Db.vala"
		if (!_tmp11_) {
#line 129 "/home/jens/Source/shotwell/src/db/Db.vala"
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
#line 129 "/home/jens/Source/shotwell/src/db/Db.vala"
			return result;
#line 486 "Db.c"
		}
	}
#line 132 "/home/jens/Source/shotwell/src/db/Db.vala"
	version = 6;
#line 146 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp12_ = database_table_has_column ("PhotoTable", "time_reimported");
#line 146 "/home/jens/Source/shotwell/src/db/Db.vala"
	if (!_tmp12_) {
#line 495 "Db.c"
		gboolean _tmp13_ = FALSE;
#line 147 "/home/jens/Source/shotwell/src/db/Db.vala"
		g_message ("Db.vala:147: upgrade_database: adding time_reimported column to PhotoT" \
"able");
#line 148 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp13_ = database_table_add_column ("PhotoTable", "time_reimported", "INTEGER");
#line 148 "/home/jens/Source/shotwell/src/db/Db.vala"
		if (!_tmp13_) {
#line 149 "/home/jens/Source/shotwell/src/db/Db.vala"
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
#line 149 "/home/jens/Source/shotwell/src/db/Db.vala"
			return result;
#line 507 "Db.c"
		}
	}
#line 152 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp14_ = database_table_has_column ("PhotoTable", "editable_id");
#line 152 "/home/jens/Source/shotwell/src/db/Db.vala"
	if (!_tmp14_) {
#line 514 "Db.c"
		gboolean _tmp15_ = FALSE;
#line 153 "/home/jens/Source/shotwell/src/db/Db.vala"
		g_message ("Db.vala:153: upgrade_database: adding editable_id column to PhotoTable");
#line 154 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp15_ = database_table_add_column ("PhotoTable", "editable_id", "INTEGER DEFAULT -1");
#line 154 "/home/jens/Source/shotwell/src/db/Db.vala"
		if (!_tmp15_) {
#line 155 "/home/jens/Source/shotwell/src/db/Db.vala"
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
#line 155 "/home/jens/Source/shotwell/src/db/Db.vala"
			return result;
#line 526 "Db.c"
		}
	}
#line 158 "/home/jens/Source/shotwell/src/db/Db.vala"
	version = 7;
#line 170 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp16_ = database_table_has_column ("PhotoTable", "rating");
#line 170 "/home/jens/Source/shotwell/src/db/Db.vala"
	if (!_tmp16_) {
#line 535 "Db.c"
		gboolean _tmp17_ = FALSE;
#line 171 "/home/jens/Source/shotwell/src/db/Db.vala"
		g_message ("Db.vala:171: upgrade_database: adding rating column to PhotoTable");
#line 172 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp17_ = database_table_add_column ("PhotoTable", "rating", "INTEGER DEFAULT 0");
#line 172 "/home/jens/Source/shotwell/src/db/Db.vala"
		if (!_tmp17_) {
#line 173 "/home/jens/Source/shotwell/src/db/Db.vala"
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
#line 173 "/home/jens/Source/shotwell/src/db/Db.vala"
			return result;
#line 547 "Db.c"
		}
	}
#line 182 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp18_ = database_table_has_column ("PhotoTable", "metadata_dirty");
#line 182 "/home/jens/Source/shotwell/src/db/Db.vala"
	if (!_tmp18_) {
#line 554 "Db.c"
		gboolean _tmp19_ = FALSE;
#line 183 "/home/jens/Source/shotwell/src/db/Db.vala"
		g_message ("Db.vala:183: upgrade_database: adding metadata_dirty column to PhotoTa" \
"ble");
#line 184 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp19_ = database_table_add_column ("PhotoTable", "metadata_dirty", "INTEGER DEFAULT 1");
#line 184 "/home/jens/Source/shotwell/src/db/Db.vala"
		if (!_tmp19_) {
#line 185 "/home/jens/Source/shotwell/src/db/Db.vala"
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
#line 185 "/home/jens/Source/shotwell/src/db/Db.vala"
			return result;
#line 566 "Db.c"
		}
	}
#line 188 "/home/jens/Source/shotwell/src/db/Db.vala"
	version = 9;
#line 195 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp21_ = database_table_has_table ("VideoTable");
#line 195 "/home/jens/Source/shotwell/src/db/Db.vala"
	if (_tmp21_) {
#line 575 "Db.c"
		gboolean _tmp22_ = FALSE;
#line 195 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp22_ = database_table_has_column ("VideoTable", "flags");
#line 195 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp20_ = !_tmp22_;
#line 581 "Db.c"
	} else {
#line 195 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp20_ = FALSE;
#line 585 "Db.c"
	}
#line 195 "/home/jens/Source/shotwell/src/db/Db.vala"
	if (_tmp20_) {
#line 589 "Db.c"
		gboolean _tmp23_ = FALSE;
#line 196 "/home/jens/Source/shotwell/src/db/Db.vala"
		g_message ("Db.vala:196: upgrade_database: adding flags column to VideoTable");
#line 197 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp23_ = database_table_add_column ("VideoTable", "flags", "INTEGER DEFAULT 0");
#line 197 "/home/jens/Source/shotwell/src/db/Db.vala"
		if (!_tmp23_) {
#line 198 "/home/jens/Source/shotwell/src/db/Db.vala"
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
#line 198 "/home/jens/Source/shotwell/src/db/Db.vala"
			return result;
#line 601 "Db.c"
		}
	}
#line 201 "/home/jens/Source/shotwell/src/db/Db.vala"
	version = 10;
#line 208 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp24_ = database_table_has_column ("EventTable", "primary_source_id");
#line 208 "/home/jens/Source/shotwell/src/db/Db.vala"
	if (!_tmp24_) {
#line 610 "Db.c"
		gboolean _tmp25_ = FALSE;
#line 209 "/home/jens/Source/shotwell/src/db/Db.vala"
		g_message ("Db.vala:209: upgrade_database: adding primary_source_id column to Even" \
"tTable");
#line 210 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp25_ = database_table_add_column ("EventTable", "primary_source_id", "INTEGER DEFAULT 0");
#line 210 "/home/jens/Source/shotwell/src/db/Db.vala"
		if (!_tmp25_) {
#line 211 "/home/jens/Source/shotwell/src/db/Db.vala"
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
#line 211 "/home/jens/Source/shotwell/src/db/Db.vala"
			return result;
#line 622 "Db.c"
		}
	}
#line 214 "/home/jens/Source/shotwell/src/db/Db.vala"
	version = 11;
#line 221 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp26_ = database_table_ensure_column ("TombstoneTable", "reason", "INTEGER DEFAULT 0", "upgrade_database: adding reason column to TombstoneTable");
#line 221 "/home/jens/Source/shotwell/src/db/Db.vala"
	if (!_tmp26_) {
#line 223 "/home/jens/Source/shotwell/src/db/Db.vala"
		result = DB_VERIFY_RESULT_UPGRADE_ERROR;
#line 223 "/home/jens/Source/shotwell/src/db/Db.vala"
		return result;
#line 635 "Db.c"
	}
#line 226 "/home/jens/Source/shotwell/src/db/Db.vala"
	version = 12;
#line 233 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp27_ = database_table_has_column ("PhotoTable", "developer");
#line 233 "/home/jens/Source/shotwell/src/db/Db.vala"
	if (!_tmp27_) {
#line 643 "Db.c"
		gboolean _tmp28_ = FALSE;
#line 234 "/home/jens/Source/shotwell/src/db/Db.vala"
		g_message ("Db.vala:234: upgrade_database: adding developer column to PhotoTable");
#line 235 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp28_ = database_table_add_column ("PhotoTable", "developer", "TEXT");
#line 235 "/home/jens/Source/shotwell/src/db/Db.vala"
		if (!_tmp28_) {
#line 236 "/home/jens/Source/shotwell/src/db/Db.vala"
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
#line 236 "/home/jens/Source/shotwell/src/db/Db.vala"
			return result;
#line 655 "Db.c"
		}
	}
#line 239 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp29_ = database_table_has_column ("PhotoTable", "develop_shotwell_id");
#line 239 "/home/jens/Source/shotwell/src/db/Db.vala"
	if (!_tmp29_) {
#line 662 "Db.c"
		gboolean _tmp30_ = FALSE;
#line 240 "/home/jens/Source/shotwell/src/db/Db.vala"
		g_message ("Db.vala:240: upgrade_database: adding develop_shotwell_id column to Ph" \
"otoTable");
#line 241 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp30_ = database_table_add_column ("PhotoTable", "develop_shotwell_id", "INTEGER DEFAULT -1");
#line 241 "/home/jens/Source/shotwell/src/db/Db.vala"
		if (!_tmp30_) {
#line 242 "/home/jens/Source/shotwell/src/db/Db.vala"
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
#line 242 "/home/jens/Source/shotwell/src/db/Db.vala"
			return result;
#line 674 "Db.c"
		}
	}
#line 245 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp31_ = database_table_has_column ("PhotoTable", "develop_camera_id");
#line 245 "/home/jens/Source/shotwell/src/db/Db.vala"
	if (!_tmp31_) {
#line 681 "Db.c"
		gboolean _tmp32_ = FALSE;
#line 246 "/home/jens/Source/shotwell/src/db/Db.vala"
		g_message ("Db.vala:246: upgrade_database: adding develop_camera_id column to Phot" \
"oTable");
#line 247 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp32_ = database_table_add_column ("PhotoTable", "develop_camera_id", "INTEGER DEFAULT -1");
#line 247 "/home/jens/Source/shotwell/src/db/Db.vala"
		if (!_tmp32_) {
#line 248 "/home/jens/Source/shotwell/src/db/Db.vala"
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
#line 248 "/home/jens/Source/shotwell/src/db/Db.vala"
			return result;
#line 693 "Db.c"
		}
	}
#line 251 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp33_ = database_table_has_column ("PhotoTable", "develop_embedded_id");
#line 251 "/home/jens/Source/shotwell/src/db/Db.vala"
	if (!_tmp33_) {
#line 700 "Db.c"
		gboolean _tmp34_ = FALSE;
#line 252 "/home/jens/Source/shotwell/src/db/Db.vala"
		g_message ("Db.vala:252: upgrade_database: adding develop_embedded_id column to Ph" \
"otoTable");
#line 253 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp34_ = database_table_add_column ("PhotoTable", "develop_embedded_id", "INTEGER DEFAULT -1");
#line 253 "/home/jens/Source/shotwell/src/db/Db.vala"
		if (!_tmp34_) {
#line 254 "/home/jens/Source/shotwell/src/db/Db.vala"
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
#line 254 "/home/jens/Source/shotwell/src/db/Db.vala"
			return result;
#line 712 "Db.c"
		}
	}
#line 257 "/home/jens/Source/shotwell/src/db/Db.vala"
	version = 13;
#line 264 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp35_ = input_version;
#line 264 "/home/jens/Source/shotwell/src/db/Db.vala"
	if (_tmp35_ < 14) {
#line 265 "/home/jens/Source/shotwell/src/db/Db.vala"
		tag_table_upgrade_for_htags ();
#line 723 "Db.c"
	}
#line 267 "/home/jens/Source/shotwell/src/db/Db.vala"
	version = 14;
#line 279 "/home/jens/Source/shotwell/src/db/Db.vala"
	version = 15;
#line 289 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp36_ = input_version;
#line 289 "/home/jens/Source/shotwell/src/db/Db.vala"
	if (_tmp36_ < 16) {
#line 292 "/home/jens/Source/shotwell/src/db/Db.vala"
		gsettings_configuration_engine_run_gsettings_migrator ();
#line 735 "Db.c"
	}
#line 295 "/home/jens/Source/shotwell/src/db/Db.vala"
	version = 16;
#line 302 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp37_ = database_table_has_column ("PhotoTable", "comment");
#line 302 "/home/jens/Source/shotwell/src/db/Db.vala"
	if (!_tmp37_) {
#line 743 "Db.c"
		gboolean _tmp38_ = FALSE;
#line 303 "/home/jens/Source/shotwell/src/db/Db.vala"
		g_message ("Db.vala:303: upgrade_database: adding comment column to PhotoTable");
#line 304 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp38_ = database_table_add_column ("PhotoTable", "comment", "TEXT");
#line 304 "/home/jens/Source/shotwell/src/db/Db.vala"
		if (!_tmp38_) {
#line 305 "/home/jens/Source/shotwell/src/db/Db.vala"
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
#line 305 "/home/jens/Source/shotwell/src/db/Db.vala"
			return result;
#line 755 "Db.c"
		}
	}
#line 307 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp39_ = database_table_has_column ("VideoTable", "comment");
#line 307 "/home/jens/Source/shotwell/src/db/Db.vala"
	if (!_tmp39_) {
#line 762 "Db.c"
		gboolean _tmp40_ = FALSE;
#line 308 "/home/jens/Source/shotwell/src/db/Db.vala"
		g_message ("Db.vala:308: upgrade_database: adding comment column to VideoTable");
#line 309 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp40_ = database_table_add_column ("VideoTable", "comment", "TEXT");
#line 309 "/home/jens/Source/shotwell/src/db/Db.vala"
		if (!_tmp40_) {
#line 310 "/home/jens/Source/shotwell/src/db/Db.vala"
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
#line 310 "/home/jens/Source/shotwell/src/db/Db.vala"
			return result;
#line 774 "Db.c"
		}
	}
#line 313 "/home/jens/Source/shotwell/src/db/Db.vala"
	version = 17;
#line 320 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp41_ = database_table_has_column ("EventTable", "comment");
#line 320 "/home/jens/Source/shotwell/src/db/Db.vala"
	if (!_tmp41_) {
#line 783 "Db.c"
		gboolean _tmp42_ = FALSE;
#line 321 "/home/jens/Source/shotwell/src/db/Db.vala"
		g_message ("Db.vala:321: upgrade_database: adding comment column to EventTable");
#line 322 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp42_ = database_table_add_column ("EventTable", "comment", "TEXT");
#line 322 "/home/jens/Source/shotwell/src/db/Db.vala"
		if (!_tmp42_) {
#line 323 "/home/jens/Source/shotwell/src/db/Db.vala"
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
#line 323 "/home/jens/Source/shotwell/src/db/Db.vala"
			return result;
#line 795 "Db.c"
		}
	}
#line 326 "/home/jens/Source/shotwell/src/db/Db.vala"
	version = 18;
#line 337 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp43_ = input_version;
#line 337 "/home/jens/Source/shotwell/src/db/Db.vala"
	if (_tmp43_ < 19) {
#line 804 "Db.c"
		Application* _tmp44_ = NULL;
		Application* _tmp45_ = NULL;
#line 338 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp44_ = application_get_instance ();
#line 338 "/home/jens/Source/shotwell/src/db/Db.vala"
		_tmp45_ = _tmp44_;
#line 338 "/home/jens/Source/shotwell/src/db/Db.vala"
		application_set_raw_thumbs_fix_required (_tmp45_, TRUE);
#line 338 "/home/jens/Source/shotwell/src/db/Db.vala"
		_application_unref0 (_tmp45_);
#line 815 "Db.c"
	}
#line 341 "/home/jens/Source/shotwell/src/db/Db.vala"
	version = 19;
#line 351 "/home/jens/Source/shotwell/src/db/Db.vala"
	version = 20;
#line 357 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp46_ = version;
#line 357 "/home/jens/Source/shotwell/src/db/Db.vala"
	_vala_assert (_tmp46_ == DATABASE_TABLE_SCHEMA_VERSION, "version == DatabaseTable.SCHEMA_VERSION");
#line 358 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp47_ = version_table_get_instance ();
#line 358 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp48_ = _tmp47_;
#line 358 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp49_ = version;
#line 358 "/home/jens/Source/shotwell/src/db/Db.vala"
	version_table_update_version (_tmp48_, _tmp49_, RESOURCES_APP_VERSION);
#line 358 "/home/jens/Source/shotwell/src/db/Db.vala"
	_database_table_unref0 (_tmp48_);
#line 360 "/home/jens/Source/shotwell/src/db/Db.vala"
	_tmp50_ = version;
#line 360 "/home/jens/Source/shotwell/src/db/Db.vala"
	g_message ("Db.vala:360: Database upgrade to schema version %d successful", _tmp50_);
#line 362 "/home/jens/Source/shotwell/src/db/Db.vala"
	result = DB_VERIFY_RESULT_OK;
#line 362 "/home/jens/Source/shotwell/src/db/Db.vala"
	return result;
#line 843 "Db.c"
}



