/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.tester;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.wicket.markup.MarkupParser;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.util.diff.Diff;
import org.apache.wicket.util.diff.DifferentiationFailedException;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.string.StringList;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiffUtil {
    private static final Logger log = LoggerFactory.getLogger(DiffUtil.class);
    private static final String ENCODING = "UTF-8";

    public static void replaceExpectedResultFile(String document, Class<?> clazz, String file) throws IOException {
        Object filename = clazz.getPackage().getName();
        filename = ((String)filename).replace('.', '/');
        filename = (String)filename + "/" + file;
        try {
            URL url = clazz.getClassLoader().getResource((String)filename);
            filename = new File(url.toURI()).getAbsolutePath();
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
        filename = ((String)filename).replaceAll("([/\\\\])target\\1test-classes\\1", "$1src$1test$1java$1");
        PrintWriter out = new PrintWriter(new FileOutputStream((String)filename));
        out.print(document);
        out.close();
    }

    public static boolean validatePage(String document, Class<?> clazz, String file, boolean failWithAssert) throws IOException {
        Args.notNull(document, "document");
        Object filename = clazz.getPackage().getName();
        filename = ((String)filename).replace('.', '/');
        filename = (String)filename + "/" + file;
        InputStream in = clazz.getClassLoader().getResourceAsStream((String)filename);
        if (in == null) {
            throw new IOException("File not found: " + (String)filename);
        }
        String reference = Streams.readString(in, ENCODING);
        reference = reference.replaceAll("\n\r", "\n");
        reference = reference.replaceAll("\r\n", "\n");
        document = document.replaceAll("\n\r", "\n");
        boolean equals = DiffUtil.compareMarkup(document = document.replaceAll("\r\n", "\n"), reference);
        if (!equals) {
            if (Boolean.getBoolean("wicket.replace.expected.results")) {
                in.close();
                in = null;
                DiffUtil.replaceExpectedResultFile(document, clazz, file);
                return true;
            }
            log.error("File name: " + file);
            log.error("===================");
            log.error(reference);
            log.error("===================");
            log.error(document);
            log.error("===================");
            Object[] test1 = StringList.tokenize(reference, "\n").toArray();
            Object[] test2 = StringList.tokenize(document, "\n").toArray();
            Diff df = new Diff(test1);
            try {
                df.diff(test2);
            }
            catch (DifferentiationFailedException e) {
                throw new RuntimeException(e);
            }
            if (failWithAssert) {
                Assertions.assertEquals((Object)reference, (Object)document, (String)filename);
            }
        }
        return equals;
    }

    private static boolean compareMarkup(String a, String b) {
        try {
            MarkupStream amarkup = new MarkupStream(new MarkupParser(a).parse());
            MarkupStream bmarkup = new MarkupStream(new MarkupParser(b).parse());
            return amarkup.equalTo(bmarkup);
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
        }
        catch (ResourceStreamNotFoundException e) {
            log.error(e.getMessage(), e);
        }
        return false;
    }
}

