/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classpath;

import io.github.classgraph.ClassGraph;
import java.io.File;
import java.lang.reflect.Array;
import java.util.LinkedHashSet;
import java.util.Map;
import nonapi.io.github.classgraph.ScanSpec;
import nonapi.io.github.classgraph.classpath.SystemJarFinder;
import nonapi.io.github.classgraph.utils.FastPathResolver;
import nonapi.io.github.classgraph.utils.FileUtils;
import nonapi.io.github.classgraph.utils.JarUtils;
import nonapi.io.github.classgraph.utils.LogNode;

public class ClasspathOrder {
    private final ScanSpec scanSpec;
    private final LinkedHashSet<String> classpathOrder = new LinkedHashSet();
    private final Map<String, ClassLoader[]> classpathEltPathToClassLoaders;

    ClasspathOrder(Map<String, ClassLoader[]> classpathEltPathToClassLoaders, ScanSpec scanSpec) {
        this.classpathEltPathToClassLoaders = classpathEltPathToClassLoaders;
        this.scanSpec = scanSpec;
    }

    public LinkedHashSet<String> getOrder() {
        return this.classpathOrder;
    }

    private boolean filter(String classpathElementPath) {
        if (this.scanSpec.classpathElementFilters != null) {
            for (ClassGraph.ClasspathElementFilter filter : this.scanSpec.classpathElementFilters) {
                if (filter.includeClasspathElement(classpathElementPath)) continue;
                return false;
            }
        }
        return true;
    }

    boolean addSystemClasspathElement(String pathElement, ClassLoader[] classLoaders) {
        if (this.classpathOrder.add(pathElement)) {
            this.classpathEltPathToClassLoaders.put(pathElement, classLoaders);
            return true;
        }
        return false;
    }

    private boolean addClasspathElement(String pathElement, ClassLoader[] classLoaders) {
        if (SystemJarFinder.getJreLibOrExtJars().contains(pathElement) || pathElement.equals(SystemJarFinder.getJreRtJarPath())) {
            return false;
        }
        if (this.classpathOrder.add(pathElement)) {
            this.classpathEltPathToClassLoaders.put(pathElement, classLoaders);
            return true;
        }
        return false;
    }

    boolean addClasspathElement(String pathElement, ClassLoader[] classLoaders, ScanSpec scanSpec, LogNode log) {
        if (pathElement == null || pathElement.isEmpty()) {
            return false;
        }
        if (pathElement.endsWith("*")) {
            if (pathElement.length() == 1 || pathElement.length() > 2 && pathElement.charAt(pathElement.length() - 1) == '*' && (pathElement.charAt(pathElement.length() - 2) == File.separatorChar || File.separatorChar != '/' && pathElement.charAt(pathElement.length() - 2) == '/')) {
                String baseDirPath = pathElement.length() == 1 ? "" : pathElement.substring(0, pathElement.length() - 2);
                String baseDirPathResolved = FastPathResolver.resolve(FileUtils.CURR_DIR_PATH, baseDirPath);
                if (!this.filter(baseDirPath) || !baseDirPathResolved.equals(baseDirPath) && !this.filter(baseDirPathResolved)) {
                    if (log != null) {
                        log.log("Classpath element did not match filter criterion, skipping: " + pathElement);
                    }
                    return false;
                }
                File baseDir = new File(baseDirPathResolved);
                if (!baseDir.exists()) {
                    if (log != null) {
                        log.log("Directory does not exist for wildcard classpath element: " + pathElement);
                    }
                    return false;
                }
                if (!FileUtils.canRead(baseDir)) {
                    if (log != null) {
                        log.log("Cannot read directory for wildcard classpath element: " + pathElement);
                    }
                    return false;
                }
                if (!baseDir.isDirectory()) {
                    if (log != null) {
                        log.log("Wildcard is appended to something other than a directory: " + pathElement);
                    }
                    return false;
                }
                LogNode dirLog = log == null ? null : log.log("Adding classpath elements from wildcarded directory: " + pathElement);
                for (File fileInDir : baseDir.listFiles()) {
                    String name = fileInDir.getName();
                    if (name.equals(".") || name.equals("..")) continue;
                    String fileInDirPath = fileInDir.getPath();
                    String fileInDirPathResolved = FastPathResolver.resolve(FileUtils.CURR_DIR_PATH, fileInDirPath);
                    if (this.addClasspathElement(fileInDirPathResolved, classLoaders)) {
                        if (dirLog == null) continue;
                        dirLog.log("Found classpath element: " + fileInDirPath + (fileInDirPath.equals(fileInDirPathResolved) ? "" : " -> " + fileInDirPathResolved));
                        continue;
                    }
                    if (dirLog == null) continue;
                    dirLog.log("Ignoring duplicate classpath element: " + fileInDirPath + (fileInDirPath.equals(fileInDirPathResolved) ? "" : " -> " + fileInDirPathResolved));
                }
                return true;
            }
            if (log != null) {
                log.log("Wildcard classpath elements can only end with a leaf of \"*\", can't have a partial name and then a wildcard: " + pathElement);
            }
            return false;
        }
        String pathElementResolved = FastPathResolver.resolve(FileUtils.CURR_DIR_PATH, pathElement);
        if (!this.filter(pathElement) || !pathElementResolved.equals(pathElement) && !this.filter(pathElementResolved)) {
            if (log != null) {
                log.log("Classpath element did not match filter criterion, skipping: " + pathElement + (pathElement.equals(pathElementResolved) ? "" : " -> " + pathElementResolved));
            }
            return false;
        }
        if (this.addClasspathElement(pathElementResolved, classLoaders)) {
            if (log != null) {
                log.log("Found classpath element: " + pathElement + (pathElement.equals(pathElementResolved) ? "" : " -> " + pathElementResolved));
            }
            return true;
        }
        if (log != null) {
            log.log("Ignoring duplicate classpath element: " + pathElement + (pathElement.equals(pathElementResolved) ? "" : " -> " + pathElementResolved));
        }
        return false;
    }

    public boolean addClasspathElements(String pathStr, ClassLoader[] classLoaders, LogNode log) {
        if (pathStr == null || pathStr.isEmpty()) {
            return false;
        }
        String[] parts = JarUtils.smartPathSplit(pathStr);
        if (parts.length == 0) {
            return false;
        }
        for (String pathElement : parts) {
            this.addClasspathElement(pathElement, classLoaders, this.scanSpec, log);
        }
        return true;
    }

    public boolean addClasspathElement(String pathElement, ClassLoader classLoader, LogNode log) {
        return this.addClasspathElement(pathElement, new ClassLoader[]{classLoader}, this.scanSpec, log);
    }

    public boolean addClasspathElementObject(Object pathObject, ClassLoader classLoader, LogNode log) {
        boolean valid = false;
        if (pathObject != null) {
            if (pathObject instanceof String) {
                valid |= this.addClasspathElements((String)pathObject, classLoader, log);
            } else if (pathObject instanceof Iterable) {
                for (Object p : (Iterable)pathObject) {
                    if (p == null) continue;
                    valid |= this.addClasspathElements(p.toString(), classLoader, log);
                }
            } else {
                Class<?> valClass = pathObject.getClass();
                if (valClass.isArray()) {
                    int n = Array.getLength(pathObject);
                    for (int j = 0; j < n; ++j) {
                        Object elt = Array.get(pathObject, j);
                        if (elt == null) continue;
                        valid |= this.addClasspathElementObject(elt, classLoader, log);
                    }
                } else {
                    valid |= this.addClasspathElements(pathObject.toString(), classLoader, log);
                }
            }
        }
        return valid;
    }

    public boolean addClasspathElements(String pathStr, ClassLoader classLoader, LogNode log) {
        return this.addClasspathElements(pathStr, new ClassLoader[]{classLoader}, log);
    }

    public boolean addClasspathElements(ClasspathOrder subsequentOrder) {
        boolean added = false;
        for (String classpathElt : subsequentOrder.getOrder()) {
            added |= this.addClasspathElement(classpathElt, subsequentOrder.classpathEltPathToClassLoaders.get(classpathElt));
        }
        return added;
    }
}

