/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.io;

import aQute.lib.io.ByteBufferDataInput;
import aQute.lib.io.IO;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;

public class LimitedDataInput
implements DataInput {
    private final DataInput in;
    private int remaining;

    public static DataInput wrap(DataInput in, int size) {
        Objects.requireNonNull(in);
        if (size < 0) {
            throw new IllegalArgumentException("size must be non-negative");
        }
        if (in instanceof ByteBufferDataInput) {
            ByteBufferDataInput bbin = (ByteBufferDataInput)in;
            ByteBuffer slice = bbin.slice(size);
            return ByteBufferDataInput.wrap(slice);
        }
        return new LimitedDataInput(in, size);
    }

    private LimitedDataInput(DataInput in, int size) {
        this.in = in;
        this.remaining = size;
    }

    private void consume(int n) throws IOException {
        if (n - this.remaining > 0) {
            throw new EOFException("request to read more bytes than available");
        }
        this.remaining -= n;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.consume(b.length);
        this.in.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.consume(len);
        this.in.readFully(b, off, len);
    }

    private int ranged(int n) {
        if (n <= 0) {
            return 0;
        }
        return Math.min(n, this.remaining);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int limit = this.ranged(n);
        int skipped = this.in.skipBytes(limit);
        this.consume(skipped);
        return skipped;
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.consume(1);
        return this.in.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        this.consume(1);
        return this.in.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        this.consume(1);
        return this.in.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        this.consume(2);
        return this.in.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.consume(2);
        return this.in.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        this.consume(2);
        return this.in.readChar();
    }

    @Override
    public int readInt() throws IOException {
        this.consume(4);
        return this.in.readInt();
    }

    @Override
    public long readLong() throws IOException {
        this.consume(8);
        return this.in.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        this.consume(4);
        return this.in.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        this.consume(8);
        return this.in.readDouble();
    }

    @Override
    @Deprecated
    public String readLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        return IO.readUTF(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[remaining=");
        sb.append(this.remaining);
        sb.append("]");
        return sb.toString();
    }
}

