/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.commands;

import java.util.ArrayList;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.support.table.Row;
import org.apache.karaf.shell.support.table.ShellTable;
import org.apache.unomi.common.DataTable;

public abstract class ListCommandSupport
implements Action {
    @Option(name="--csv", description="Output table in CSV format", required=false, multiValued=false)
    boolean csv;

    protected abstract String[] getHeaders();

    protected abstract DataTable buildDataTable();

    public Object execute() throws Exception {
        DataTable dataTable = this.buildDataTable();
        String[] headers = this.getHeaders();
        if (this.csv) {
            System.out.println(dataTable.toCSV(headers));
            return null;
        }
        ShellTable shellTable = new ShellTable();
        for (String header : headers) {
            shellTable.column(header);
        }
        for (DataTable.Row dataTableRow : dataTable.getRows()) {
            ArrayList<Comparable> rowData = new ArrayList<Comparable>();
            for (int i = 0; i < dataTable.getMaxColumns(); ++i) {
                rowData.add(dataTableRow.getData(i));
            }
            Row row = shellTable.addRow();
            row.addContent(rowData);
        }
        shellTable.print(System.out);
        return null;
    }
}

