/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.event.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;

public class OsgiUtil {
    public static boolean toBoolean(Dictionary props, String key, boolean defaultValue) {
        Object propValue = OsgiUtil.toObject(props, key);
        if (propValue instanceof Boolean) {
            return (Boolean)propValue;
        }
        if (propValue != null) {
            return Boolean.valueOf(String.valueOf(propValue));
        }
        return defaultValue;
    }

    public static String toString(Dictionary props, String key, String defaultValue) {
        Object propValue = OsgiUtil.toObject(props, key);
        return propValue != null ? propValue.toString() : defaultValue;
    }

    public static int toInteger(Dictionary props, String key, int defaultValue) {
        Object propValue = OsgiUtil.toObject(props, key);
        if (propValue instanceof Integer) {
            return (Integer)propValue;
        }
        if (propValue != null) {
            try {
                return Integer.valueOf(String.valueOf(propValue));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static Object toObject(Dictionary props, String key) {
        if (props == null || key == null) {
            return null;
        }
        Object propValue = props.get(key);
        if (propValue == null) {
            return null;
        }
        if (propValue.getClass().isArray()) {
            Object[] prop = (Object[])propValue;
            return prop.length > 0 ? prop[0] : null;
        }
        if (propValue instanceof Collection) {
            Collection prop = (Collection)propValue;
            return prop.isEmpty() ? null : prop.iterator().next();
        }
        return propValue;
    }

    public static String[] toStringArray(Dictionary props, String key, String[] defaultArray) {
        if (props == null || key == null) {
            return defaultArray;
        }
        Object propValue = props.get(key);
        if (propValue == null) {
            return defaultArray;
        }
        if (propValue instanceof String) {
            return new String[]{(String)propValue};
        }
        if (propValue instanceof String[]) {
            return (String[])propValue;
        }
        if (propValue.getClass().isArray()) {
            Object[] valueArray = (Object[])propValue;
            ArrayList<String> values = new ArrayList<String>(valueArray.length);
            for (int i = 0; i < valueArray.length; ++i) {
                Object value = valueArray[i];
                if (value == null) continue;
                values.add(value.toString());
            }
            return values.toArray(new String[values.size()]);
        }
        if (propValue instanceof Collection) {
            Collection valueCollection = (Collection)propValue;
            ArrayList<String> valueList = new ArrayList<String>(valueCollection.size());
            for (Object value : valueCollection) {
                if (value == null) continue;
                valueList.add(value.toString());
            }
            return valueList.toArray(new String[valueList.size()]);
        }
        return defaultArray;
    }
}

