/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.kafka.common.KafkaException;

class JaasConfig
extends Configuration {
    private final String loginContextName;
    private final List<AppConfigurationEntry> configEntries;

    public JaasConfig(String loginContextName, String jaasConfigParams) {
        StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(jaasConfigParams));
        tokenizer.slashSlashComments(true);
        tokenizer.slashStarComments(true);
        tokenizer.wordChars(45, 45);
        tokenizer.wordChars(95, 95);
        tokenizer.wordChars(36, 36);
        try {
            this.configEntries = new ArrayList<AppConfigurationEntry>();
            while (tokenizer.nextToken() != -1) {
                this.configEntries.add(this.parseAppConfigurationEntry(tokenizer));
            }
            if (this.configEntries.isEmpty()) {
                throw new IllegalArgumentException("Login module not specified in JAAS config");
            }
            this.loginContextName = loginContextName;
        }
        catch (IOException e) {
            throw new KafkaException("Unexpected exception while parsing JAAS config");
        }
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        if (this.loginContextName.equals(name)) {
            return this.configEntries.toArray(new AppConfigurationEntry[0]);
        }
        return null;
    }

    private AppConfigurationEntry.LoginModuleControlFlag loginModuleControlFlag(String flag) {
        AppConfigurationEntry.LoginModuleControlFlag controlFlag;
        switch (flag.toUpperCase(Locale.ROOT)) {
            case "REQUIRED": {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
                break;
            }
            case "REQUISITE": {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
                break;
            }
            case "SUFFICIENT": {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
                break;
            }
            case "OPTIONAL": {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid login module control flag '" + flag + "' in JAAS config");
            }
        }
        return controlFlag;
    }

    private AppConfigurationEntry parseAppConfigurationEntry(StreamTokenizer tokenizer) throws IOException {
        String loginModule = tokenizer.sval;
        if (tokenizer.nextToken() == -1) {
            throw new IllegalArgumentException("Login module control flag not specified in JAAS config");
        }
        AppConfigurationEntry.LoginModuleControlFlag controlFlag = this.loginModuleControlFlag(tokenizer.sval);
        HashMap<String, String> options = new HashMap<String, String>();
        while (tokenizer.nextToken() != -1 && tokenizer.ttype != 59) {
            String key = tokenizer.sval;
            if (tokenizer.nextToken() != 61 || tokenizer.nextToken() == -1 || tokenizer.sval == null) {
                throw new IllegalArgumentException("Value not specified for key '" + key + "' in JAAS config");
            }
            String value = tokenizer.sval;
            options.put(key, value);
        }
        if (tokenizer.ttype != 59) {
            throw new IllegalArgumentException("JAAS config entry not terminated by semi-colon");
        }
        return new AppConfigurationEntry(loginModule, controlFlag, options);
    }
}

