/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.services.impl.rules;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.Metadata;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.actions.Action;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.query.Query;
import org.apache.unomi.api.rules.Rule;
import org.apache.unomi.api.rules.RuleStatistics;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.api.services.EventListenerService;
import org.apache.unomi.api.services.EventService;
import org.apache.unomi.api.services.RuleListenerService;
import org.apache.unomi.api.services.RulesService;
import org.apache.unomi.api.services.SchedulerService;
import org.apache.unomi.api.utils.ParserHelper;
import org.apache.unomi.persistence.spi.CustomObjectMapper;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.apache.unomi.services.actions.ActionExecutorDispatcher;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesServiceImpl
implements RulesService,
EventListenerService,
SynchronousBundleListener {
    public static final String TRACKED_PARAMETER = "trackedConditionParameters";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)RulesServiceImpl.class.getName());
    private BundleContext bundleContext;
    private PersistenceService persistenceService;
    private DefinitionsService definitionsService;
    private EventService eventService;
    private SchedulerService schedulerService;
    private ActionExecutorDispatcher actionExecutorDispatcher;
    private List<Rule> allRules;
    private final Set<String> invalidRulesId = new HashSet<String>();
    private final Map<String, RuleStatistics> allRuleStatistics = new ConcurrentHashMap<String, RuleStatistics>();
    private Integer rulesRefreshInterval = 1000;
    private Integer rulesStatisticsRefreshInterval = 10000;
    private final List<RuleListenerService> ruleListeners = new CopyOnWriteArrayList<RuleListenerService>();
    private Map<String, Set<Rule>> rulesByEventType = new HashMap<String, Set<Rule>>();
    private Boolean optimizedRulesActivated = true;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setDefinitionsService(DefinitionsService definitionsService) {
        this.definitionsService = definitionsService;
    }

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public void setActionExecutorDispatcher(ActionExecutorDispatcher actionExecutorDispatcher) {
        this.actionExecutorDispatcher = actionExecutorDispatcher;
    }

    public void setRulesRefreshInterval(Integer rulesRefreshInterval) {
        this.rulesRefreshInterval = rulesRefreshInterval;
    }

    public void setRulesStatisticsRefreshInterval(Integer rulesStatisticsRefreshInterval) {
        this.rulesStatisticsRefreshInterval = rulesStatisticsRefreshInterval;
    }

    public void setOptimizedRulesActivated(Boolean optimizedRulesActivated) {
        this.optimizedRulesActivated = optimizedRulesActivated;
    }

    public void postConstruct() {
        LOGGER.debug("postConstruct {{}}", (Object)this.bundleContext.getBundle());
        this.loadPredefinedRules(this.bundleContext);
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (bundle.getBundleContext() == null || bundle.getBundleId() == this.bundleContext.getBundle().getBundleId()) continue;
            this.loadPredefinedRules(bundle.getBundleContext());
        }
        this.bundleContext.addBundleListener((BundleListener)this);
        this.initializeTimers();
        LOGGER.info("Rule service initialized.");
    }

    public void preDestroy() {
        this.bundleContext.removeBundleListener((BundleListener)this);
        LOGGER.info("Rule service shutdown.");
    }

    private void processBundleStartup(BundleContext bundleContext) {
        if (bundleContext == null) {
            return;
        }
        this.loadPredefinedRules(bundleContext);
    }

    private void processBundleStop(BundleContext bundleContext) {
        if (bundleContext == null) {
            return;
        }
    }

    private void loadPredefinedRules(BundleContext bundleContext) {
        Enumeration predefinedRuleEntries = bundleContext.getBundle().findEntries("META-INF/cxs/rules", "*.json", true);
        if (predefinedRuleEntries == null) {
            return;
        }
        while (predefinedRuleEntries.hasMoreElements()) {
            URL predefinedRuleURL = (URL)predefinedRuleEntries.nextElement();
            LOGGER.debug("Found predefined rule at {}, loading... ", (Object)predefinedRuleURL);
            try {
                Rule rule = (Rule)CustomObjectMapper.getObjectMapper().readValue(predefinedRuleURL, Rule.class);
                this.setRule(rule);
                LOGGER.info("Predefined rule with id {} registered", (Object)rule.getMetadata().getId());
            }
            catch (IOException e) {
                LOGGER.error("Error while loading rule definition {}", (Object)predefinedRuleURL, (Object)e);
            }
        }
    }

    public Set<Rule> getMatchingRules(Event event) {
        LinkedHashSet<Rule> matchedRules = new LinkedHashSet<Rule>();
        Boolean hasEventAlreadyBeenRaised = null;
        Boolean hasEventAlreadyBeenRaisedForSession = null;
        Boolean hasEventAlreadyBeenRaisedForProfile = null;
        Set<Object> eventTypeRules = new HashSet<Rule>(this.allRules);
        if (this.optimizedRulesActivated.booleanValue()) {
            eventTypeRules = this.rulesByEventType.get(event.getEventType());
            if (eventTypeRules == null) {
                eventTypeRules = new HashSet();
            }
            eventTypeRules = new HashSet<Rule>(eventTypeRules);
            Set<Rule> allEventRules = this.rulesByEventType.get("*");
            if (allEventRules != null && !allEventRules.isEmpty()) {
                eventTypeRules.addAll(allEventRules);
            }
            if (eventTypeRules.isEmpty()) {
                return matchedRules;
            }
        }
        for (Rule rule : eventTypeRules) {
            Condition profileCondition;
            if (!rule.getMetadata().isEnabled()) continue;
            RuleStatistics ruleStatistics = this.getLocalRuleStatistics(rule);
            long ruleConditionStartTime = System.currentTimeMillis();
            String scope = rule.getMetadata().getScope();
            if (!scope.equals("systemscope") && !scope.equals(event.getScope())) continue;
            Condition eventCondition = this.definitionsService.extractConditionBySystemTag(rule.getCondition(), "eventCondition");
            if (eventCondition == null) {
                this.updateRuleStatistics(ruleStatistics, ruleConditionStartTime);
                continue;
            }
            this.fireEvaluate(rule, event);
            if (!this.persistenceService.testMatch(eventCondition, (Item)event)) {
                this.updateRuleStatistics(ruleStatistics, ruleConditionStartTime);
                continue;
            }
            Condition sourceCondition = this.definitionsService.extractConditionBySystemTag(rule.getCondition(), "sourceEventCondition");
            if (sourceCondition != null && !this.persistenceService.testMatch(sourceCondition, event.getSource())) {
                this.updateRuleStatistics(ruleStatistics, ruleConditionStartTime);
                continue;
            }
            if (rule.isRaiseEventOnlyOnce()) {
                if ((hasEventAlreadyBeenRaised = Boolean.valueOf(hasEventAlreadyBeenRaised != null ? hasEventAlreadyBeenRaised.booleanValue() : this.eventService.hasEventAlreadyBeenRaised(event))).booleanValue()) {
                    this.updateRuleStatistics(ruleStatistics, ruleConditionStartTime);
                    this.fireAlreadyRaised(RuleListenerService.AlreadyRaisedFor.EVENT, rule, event);
                    continue;
                }
            } else if (rule.isRaiseEventOnlyOnceForProfile()) {
                if ((hasEventAlreadyBeenRaisedForProfile = Boolean.valueOf(hasEventAlreadyBeenRaisedForProfile != null ? hasEventAlreadyBeenRaisedForProfile.booleanValue() : this.eventService.hasEventAlreadyBeenRaised(event, false))).booleanValue()) {
                    this.updateRuleStatistics(ruleStatistics, ruleConditionStartTime);
                    this.fireAlreadyRaised(RuleListenerService.AlreadyRaisedFor.PROFILE, rule, event);
                    continue;
                }
            } else if (rule.isRaiseEventOnlyOnceForSession() && (hasEventAlreadyBeenRaisedForSession = Boolean.valueOf(hasEventAlreadyBeenRaisedForSession != null ? hasEventAlreadyBeenRaisedForSession.booleanValue() : this.eventService.hasEventAlreadyBeenRaised(event, true))).booleanValue()) {
                this.updateRuleStatistics(ruleStatistics, ruleConditionStartTime);
                this.fireAlreadyRaised(RuleListenerService.AlreadyRaisedFor.SESSION, rule, event);
                continue;
            }
            if ((profileCondition = this.definitionsService.extractConditionBySystemTag(rule.getCondition(), "profileCondition")) != null && !this.persistenceService.testMatch(profileCondition, (Item)event.getProfile())) {
                this.updateRuleStatistics(ruleStatistics, ruleConditionStartTime);
                continue;
            }
            Condition sessionCondition = this.definitionsService.extractConditionBySystemTag(rule.getCondition(), "sessionCondition");
            if (sessionCondition != null && !this.persistenceService.testMatch(sessionCondition, (Item)event.getSession())) {
                this.updateRuleStatistics(ruleStatistics, ruleConditionStartTime);
                continue;
            }
            matchedRules.add(rule);
        }
        return matchedRules;
    }

    private RuleStatistics getLocalRuleStatistics(Rule rule) {
        RuleStatistics ruleStatistics = this.allRuleStatistics.get(rule.getItemId());
        if (ruleStatistics == null) {
            ruleStatistics = new RuleStatistics(rule.getItemId());
        }
        return ruleStatistics;
    }

    private void updateRuleStatistics(RuleStatistics ruleStatistics, long ruleConditionStartTime) {
        long totalRuleConditionTime = System.currentTimeMillis() - ruleConditionStartTime;
        ruleStatistics.setLocalConditionsTime(ruleStatistics.getLocalConditionsTime() + totalRuleConditionTime);
        this.allRuleStatistics.put(ruleStatistics.getItemId(), ruleStatistics);
    }

    public void refreshRules() {
        try {
            List<Rule> newAllRules = this.queryAllRules();
            this.rulesByEventType = this.getRulesByEventType(newAllRules);
            this.allRules = newAllRules;
        }
        catch (Throwable t) {
            LOGGER.error("Error loading rules from persistence back-end", t);
        }
    }

    public List<Rule> getAllRules() {
        return Collections.unmodifiableList(this.allRules);
    }

    private List<Rule> queryAllRules() {
        List rules = this.persistenceService.getAllItems(Rule.class, 0, -1, "priority").getList();
        for (Rule rule : rules) {
            boolean isValid = ParserHelper.resolveConditionType((DefinitionsService)this.definitionsService, (Condition)rule.getCondition(), (String)("rule " + rule.getItemId()));
            boolean bl = isValid = isValid && ParserHelper.resolveActionTypes((DefinitionsService)this.definitionsService, (Rule)rule, (boolean)this.invalidRulesId.contains(rule.getItemId()));
            if (!isValid) {
                this.invalidRulesId.add(rule.getItemId());
                continue;
            }
            this.invalidRulesId.remove(rule.getItemId());
        }
        return rules;
    }

    private Map<String, Set<Rule>> getRulesByEventType(List<Rule> rules) {
        HashMap<String, Set<Rule>> newRulesByEventType = new HashMap<String, Set<Rule>>();
        for (Rule rule : rules) {
            this.updateRulesByEventType(newRulesByEventType, rule);
        }
        return newRulesByEventType;
    }

    public boolean canHandle(Event event) {
        return true;
    }

    public int onEvent(Event event) {
        Set<Rule> rules = this.getMatchingRules(event);
        int changes = 0;
        for (Rule rule : rules) {
            LOGGER.debug("Fired rule {} for {} - {}", new Object[]{rule.getMetadata().getId(), event.getEventType(), event.getItemId()});
            this.fireExecuteActions(rule, event);
            long actionsStartTime = System.currentTimeMillis();
            for (Action action : rule.getActions()) {
                changes |= this.actionExecutorDispatcher.execute(action, event);
            }
            long totalActionsTime = System.currentTimeMillis() - actionsStartTime;
            Event ruleFired = new Event("ruleFired", event.getSession(), event.getProfile(), event.getScope(), (Item)event, (Item)rule, event.getTimeStamp());
            ruleFired.getAttributes().putAll(event.getAttributes());
            ruleFired.setPersistent(false);
            changes |= this.eventService.send(ruleFired);
            RuleStatistics ruleStatistics = this.getLocalRuleStatistics(rule);
            ruleStatistics.setLocalExecutionCount(ruleStatistics.getLocalExecutionCount() + 1L);
            ruleStatistics.setLocalActionsTime(ruleStatistics.getLocalActionsTime() + totalActionsTime);
            this.allRuleStatistics.put(ruleStatistics.getItemId(), ruleStatistics);
        }
        return changes;
    }

    public RuleStatistics getRuleStatistics(String ruleId) {
        if (this.allRuleStatistics.containsKey(ruleId)) {
            return this.allRuleStatistics.get(ruleId);
        }
        return (RuleStatistics)this.persistenceService.load(ruleId, RuleStatistics.class);
    }

    public Map<String, RuleStatistics> getAllRuleStatistics() {
        return this.allRuleStatistics;
    }

    public void resetAllRuleStatistics() {
        Condition matchAllCondition = new Condition(this.definitionsService.getConditionType("matchAllCondition"));
        this.persistenceService.removeByQuery(matchAllCondition, RuleStatistics.class);
        this.allRuleStatistics.clear();
    }

    public Set<Metadata> getRuleMetadatas() {
        HashSet<Metadata> metadatas = new HashSet<Metadata>();
        for (Rule rule : this.allRules) {
            metadatas.add(rule.getMetadata());
        }
        return metadatas;
    }

    public PartialList<Metadata> getRuleMetadatas(Query query) {
        if (query.isForceRefresh()) {
            this.persistenceService.refreshIndex(Rule.class);
        }
        this.definitionsService.resolveConditionType(query.getCondition());
        LinkedList<Metadata> descriptions = new LinkedList<Metadata>();
        PartialList rules = this.persistenceService.query(query.getCondition(), query.getSortby(), Rule.class, query.getOffset(), query.getLimit());
        for (Rule definition : rules.getList()) {
            descriptions.add(definition.getMetadata());
        }
        return new PartialList(descriptions, rules.getOffset(), rules.getPageSize(), rules.getTotalSize(), rules.getTotalSizeRelation());
    }

    public PartialList<Rule> getRuleDetails(Query query) {
        if (query.isForceRefresh()) {
            this.persistenceService.refreshIndex(Rule.class);
        }
        this.definitionsService.resolveConditionType(query.getCondition());
        PartialList rules = this.persistenceService.query(query.getCondition(), query.getSortby(), Rule.class, query.getOffset(), query.getLimit());
        LinkedList details = new LinkedList();
        details.addAll(rules.getList());
        return new PartialList(details, rules.getOffset(), rules.getPageSize(), rules.getTotalSize(), rules.getTotalSizeRelation());
    }

    public Rule getRule(String ruleId) {
        Rule rule = (Rule)this.persistenceService.load(ruleId, Rule.class);
        if (rule != null) {
            ParserHelper.resolveConditionType((DefinitionsService)this.definitionsService, (Condition)rule.getCondition(), (String)("rule " + rule.getItemId()));
            ParserHelper.resolveActionTypes((DefinitionsService)this.definitionsService, (Rule)rule, (boolean)this.invalidRulesId.contains(rule.getItemId()));
        }
        return rule;
    }

    public void setRule(Rule rule) {
        Condition condition;
        if (rule.getMetadata().getScope() == null) {
            rule.getMetadata().setScope("systemscope");
        }
        if ((condition = rule.getCondition()) != null && rule.getMetadata().isEnabled() && !rule.getMetadata().isMissingPlugins()) {
            ParserHelper.resolveConditionType((DefinitionsService)this.definitionsService, (Condition)condition, (String)("rule " + rule.getItemId()));
            ParserHelper.resolveActionTypes((DefinitionsService)this.definitionsService, (Rule)rule, (boolean)this.invalidRulesId.contains(rule.getItemId()));
            this.definitionsService.extractConditionBySystemTag(condition, "eventCondition");
        }
        this.persistenceService.save((Item)rule);
    }

    public Set<Condition> getTrackedConditions(Item source) {
        HashSet<Condition> trackedConditions = new HashSet<Condition>();
        for (Rule r : this.allRules) {
            Condition ruleCondition;
            Condition trackedCondition;
            if (!r.getMetadata().isEnabled() || (trackedCondition = this.definitionsService.extractConditionBySystemTag(ruleCondition = r.getCondition(), "trackedCondition")) == null) continue;
            Condition evalCondition = this.definitionsService.extractConditionBySystemTag(ruleCondition, "sourceEventCondition");
            if (evalCondition != null) {
                if (!this.persistenceService.testMatch(evalCondition, source)) continue;
                trackedConditions.add(trackedCondition);
                continue;
            }
            if (trackedCondition.getConditionType() == null || trackedCondition.getConditionType().getParameters() == null || trackedCondition.getConditionType().getParameters().isEmpty()) continue;
            HashMap<String, Object> trackedParameters = new HashMap<String, Object>();
            trackedCondition.getConditionType().getParameters().forEach(parameter -> {
                try {
                    if (TRACKED_PARAMETER.equals(parameter.getId())) {
                        Arrays.stream(StringUtils.split((String)parameter.getDefaultValue(), (String)",")).forEach(trackedParameter -> {
                            String[] param = StringUtils.split((String)StringUtils.trim((String)trackedParameter), (String)":");
                            trackedParameters.put(StringUtils.trim((String)param[1]), trackedCondition.getParameter(StringUtils.trim((String)param[0])));
                        });
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Unable to parse tracked parameter from {} for condition type {}", parameter, (Object)trackedCondition.getConditionType().getItemId());
                }
            });
            if (!trackedParameters.isEmpty()) {
                evalCondition = new Condition(this.definitionsService.getConditionType("booleanCondition"));
                evalCondition.setParameter("operator", (Object)"and");
                ArrayList conditions = new ArrayList();
                trackedParameters.forEach((key, value) -> {
                    Condition propCondition = new Condition(this.definitionsService.getConditionType("eventPropertyCondition"));
                    propCondition.setParameter("comparisonOperator", (Object)"equals");
                    propCondition.setParameter("propertyName", key);
                    propCondition.setParameter("propertyValue", value);
                    conditions.add(propCondition);
                });
                evalCondition.setParameter("subConditions", conditions);
                if (!this.persistenceService.testMatch(evalCondition, source)) continue;
                trackedConditions.add(trackedCondition);
                continue;
            }
            trackedConditions.add(trackedCondition);
        }
        return trackedConditions;
    }

    public void removeRule(String ruleId) {
        this.persistenceService.remove(ruleId, Rule.class);
    }

    private void initializeTimers() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                RulesServiceImpl.this.refreshRules();
            }
        };
        this.schedulerService.getScheduleExecutorService().scheduleWithFixedDelay(task, 0L, this.rulesRefreshInterval.intValue(), TimeUnit.MILLISECONDS);
        TimerTask statisticsTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    RulesServiceImpl.this.syncRuleStatistics();
                }
                catch (Throwable t) {
                    LOGGER.error("Error synching rule statistics between memory and persistence back-end", t);
                }
            }
        };
        this.schedulerService.getScheduleExecutorService().scheduleWithFixedDelay(statisticsTask, 0L, this.rulesStatisticsRefreshInterval.intValue(), TimeUnit.MILLISECONDS);
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 2: {
                this.processBundleStartup(event.getBundle().getBundleContext());
                break;
            }
            case 256: {
                this.processBundleStop(event.getBundle().getBundleContext());
            }
        }
    }

    private void syncRuleStatistics() {
        List allPersistedRuleStatisticsList = this.persistenceService.getAllItems(RuleStatistics.class);
        HashMap<String, RuleStatistics> allPersistedRuleStatistics = new HashMap<String, RuleStatistics>();
        for (RuleStatistics ruleStatistics : allPersistedRuleStatisticsList) {
            allPersistedRuleStatistics.put(ruleStatistics.getItemId(), ruleStatistics);
        }
        for (RuleStatistics ruleStatistics : this.allRuleStatistics.values()) {
            boolean mustPersist = false;
            if (allPersistedRuleStatistics.containsKey(ruleStatistics.getItemId())) {
                RuleStatistics persistedRuleStatistics = (RuleStatistics)allPersistedRuleStatistics.get(ruleStatistics.getItemId());
                ruleStatistics.setExecutionCount(persistedRuleStatistics.getExecutionCount() + ruleStatistics.getLocalExecutionCount());
                if (ruleStatistics.getLocalExecutionCount() > 0L) {
                    ruleStatistics.setLocalExecutionCount(0L);
                    mustPersist = true;
                }
                ruleStatistics.setConditionsTime(persistedRuleStatistics.getConditionsTime() + ruleStatistics.getLocalConditionsTime());
                if (ruleStatistics.getLocalConditionsTime() > 0L) {
                    ruleStatistics.setLocalConditionsTime(0L);
                    mustPersist = true;
                }
                ruleStatistics.setActionsTime(persistedRuleStatistics.getActionsTime() + ruleStatistics.getLocalActionsTime());
                if (ruleStatistics.getLocalActionsTime() > 0L) {
                    ruleStatistics.setLocalActionsTime(0L);
                    mustPersist = true;
                }
                ruleStatistics.setLastSyncDate(new Date());
            } else {
                ruleStatistics.setExecutionCount(ruleStatistics.getExecutionCount() + ruleStatistics.getLocalExecutionCount());
                if (ruleStatistics.getLocalExecutionCount() > 0L) {
                    ruleStatistics.setLocalExecutionCount(0L);
                    mustPersist = true;
                }
                ruleStatistics.setConditionsTime(ruleStatistics.getConditionsTime() + ruleStatistics.getLocalConditionsTime());
                if (ruleStatistics.getLocalConditionsTime() > 0L) {
                    ruleStatistics.setLocalConditionsTime(0L);
                    mustPersist = true;
                }
                ruleStatistics.setActionsTime(ruleStatistics.getActionsTime() + ruleStatistics.getLocalActionsTime());
                if (ruleStatistics.getLocalActionsTime() > 0L) {
                    ruleStatistics.setLocalActionsTime(0L);
                    mustPersist = true;
                }
                ruleStatistics.setLastSyncDate(new Date());
            }
            this.allRuleStatistics.put(ruleStatistics.getItemId(), ruleStatistics);
            if (!mustPersist) continue;
            this.persistenceService.save((Item)ruleStatistics, null, Boolean.valueOf(true));
        }
        for (RuleStatistics ruleStatistics : allPersistedRuleStatistics.values()) {
            if (this.allRuleStatistics.containsKey(ruleStatistics.getItemId())) continue;
            this.allRuleStatistics.put(ruleStatistics.getItemId(), ruleStatistics);
        }
    }

    public void bind(ServiceReference<RuleListenerService> serviceReference) {
        RuleListenerService ruleListenerService = (RuleListenerService)this.bundleContext.getService(serviceReference);
        this.ruleListeners.add(ruleListenerService);
    }

    public void unbind(ServiceReference<RuleListenerService> serviceReference) {
        if (serviceReference != null) {
            RuleListenerService ruleListenerService = (RuleListenerService)this.bundleContext.getService(serviceReference);
            this.ruleListeners.remove(ruleListenerService);
        }
    }

    public void fireEvaluate(Rule rule, Event event) {
        for (RuleListenerService ruleListenerService : this.ruleListeners) {
            ruleListenerService.onEvaluate(rule, event);
        }
    }

    public void fireAlreadyRaised(RuleListenerService.AlreadyRaisedFor alreadyRaisedFor, Rule rule, Event event) {
        for (RuleListenerService ruleListenerService : this.ruleListeners) {
            ruleListenerService.onAlreadyRaised(alreadyRaisedFor, rule, event);
        }
    }

    public void fireExecuteActions(Rule rule, Event event) {
        for (RuleListenerService ruleListenerService : this.ruleListeners) {
            ruleListenerService.onExecuteActions(rule, event);
        }
    }

    private void updateRulesByEventType(Map<String, Set<Rule>> rulesByEventType, Rule rule) {
        Set eventTypeIds = ParserHelper.resolveConditionEventTypes((Condition)rule.getCondition());
        if (eventTypeIds.isEmpty()) {
            eventTypeIds.add("*");
        }
        for (String eventTypeId : eventTypeIds) {
            Set<Rule> rules = rulesByEventType.get(eventTypeId);
            if (rules == null) {
                rules = new HashSet<Rule>();
            }
            rules.add(rule);
            rulesByEventType.put(eventTypeId, rules);
        }
    }
}

