/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.groovy.actions.services.impl;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import groovy.util.GroovyScriptEngine;
import groovy.util.ResourceConnector;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.Metadata;
import org.apache.unomi.api.Parameter;
import org.apache.unomi.api.actions.ActionType;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.api.services.SchedulerService;
import org.apache.unomi.groovy.actions.GroovyAction;
import org.apache.unomi.groovy.actions.GroovyBundleResourceConnector;
import org.apache.unomi.groovy.actions.ScriptMetadata;
import org.apache.unomi.groovy.actions.annotations.Action;
import org.apache.unomi.groovy.actions.services.GroovyActionsService;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={GroovyActionsService.class}, configurationPid={"org.apache.unomi.groovy.actions"})
@Designate(ocd=GroovyActionsServiceConfig.class)
public class GroovyActionsServiceImpl
implements GroovyActionsService {
    private BundleContext bundleContext;
    private GroovyScriptEngine groovyScriptEngine;
    private CompilerConfiguration compilerConfiguration;
    private ScheduledFuture<?> scheduledFuture;
    private final Object compilationLock = new Object();
    private GroovyShell compilationShell;
    private volatile Map<String, ScriptMetadata> scriptMetadataCache = new ConcurrentHashMap<String, ScriptMetadata>();
    private final Map<String, Set<String>> loggedRefreshErrors = new ConcurrentHashMap<String, Set<String>>();
    private static final int MAX_LOGGED_ERRORS = 100;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)GroovyActionsServiceImpl.class.getName());
    private static final String BASE_SCRIPT_NAME = "BaseScript";
    private DefinitionsService definitionsService;
    private PersistenceService persistenceService;
    private SchedulerService schedulerService;
    private GroovyActionsServiceConfig config;

    @Reference
    public void setDefinitionsService(DefinitionsService definitionsService) {
        this.definitionsService = definitionsService;
    }

    @Reference
    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    @Reference
    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    @Activate
    public void start(GroovyActionsServiceConfig config, BundleContext bundleContext) {
        LOGGER.debug("postConstruct {}", (Object)bundleContext.getBundle());
        this.config = config;
        this.bundleContext = bundleContext;
        GroovyBundleResourceConnector bundleResourceConnector = new GroovyBundleResourceConnector(bundleContext);
        GroovyClassLoader groovyLoader = new GroovyClassLoader(((BundleWiring)bundleContext.getBundle().adapt(BundleWiring.class)).getClassLoader());
        this.groovyScriptEngine = new GroovyScriptEngine((ResourceConnector)bundleResourceConnector, (ClassLoader)groovyLoader);
        this.initializeGroovyCompiler();
        try {
            this.loadBaseScript();
        }
        catch (IOException e) {
            LOGGER.error("Failed to load base script", (Throwable)e);
        }
        this.preloadAllScripts();
        this.initializeTimers();
        LOGGER.info("Groovy action service initialized with {} scripts", (Object)this.scriptMetadataCache.size());
    }

    @Deactivate
    public void onDestroy() {
        LOGGER.debug("onDestroy Method called");
        if (this.scheduledFuture != null && !this.scheduledFuture.isCancelled()) {
            this.scheduledFuture.cancel(true);
        }
    }

    private void loadBaseScript() throws IOException {
        URL groovyBaseScriptURL = this.bundleContext.getBundle().getEntry("META-INF/base/BaseScript.groovy");
        if (groovyBaseScriptURL == null) {
            return;
        }
        LOGGER.debug("Found Groovy base script at {}, loading... ", (Object)groovyBaseScriptURL.getPath());
        GroovyCodeSource groovyCodeSource = new GroovyCodeSource(IOUtils.toString((InputStream)groovyBaseScriptURL.openStream(), (Charset)StandardCharsets.UTF_8), BASE_SCRIPT_NAME, "/groovy/script");
        this.groovyScriptEngine.getGroovyClassLoader().parseClass(groovyCodeSource, true);
    }

    private void initializeGroovyCompiler() {
        this.compilerConfiguration = new CompilerConfiguration();
        this.compilerConfiguration.addCompilationCustomizers(new CompilationCustomizer[]{this.createImportCustomizer()});
        this.compilerConfiguration.setScriptBaseClass(BASE_SCRIPT_NAME);
        this.groovyScriptEngine.setConfig(this.compilerConfiguration);
        this.compilationShell = new GroovyShell((ClassLoader)this.groovyScriptEngine.getGroovyClassLoader(), this.compilerConfiguration);
    }

    private void preloadAllScripts() {
        long startTime = System.currentTimeMillis();
        LOGGER.info("Pre-compiling all Groovy scripts at startup...");
        int successCount = 0;
        int failureCount = 0;
        long totalCompilationTime = 0L;
        for (GroovyAction groovyAction : this.persistenceService.getAllItems(GroovyAction.class)) {
            try {
                String actionName = groovyAction.getName();
                String scriptContent = groovyAction.getScript();
                long scriptStartTime = System.currentTimeMillis();
                ScriptMetadata metadata = this.compileAndCreateMetadata(actionName, scriptContent);
                long scriptCompilationTime = System.currentTimeMillis() - scriptStartTime;
                totalCompilationTime += scriptCompilationTime;
                this.scriptMetadataCache.put(actionName, metadata);
                ++successCount;
                LOGGER.debug("Pre-compiled script: {} ({}ms)", (Object)actionName, (Object)scriptCompilationTime);
            }
            catch (Exception e) {
                ++failureCount;
                LOGGER.error("Failed to pre-compile script: {}", (Object)groovyAction.getName(), (Object)e);
            }
        }
        long totalTime = System.currentTimeMillis() - startTime;
        LOGGER.info("Pre-compilation completed: {} scripts successfully compiled, {} failures. Total time: {}ms", new Object[]{successCount, failureCount, totalTime});
        LOGGER.debug("Pre-compilation metrics: Average per script: {}ms, Compilation overhead: {}ms", (Object)(successCount > 0 ? totalCompilationTime / (long)successCount : 0L), (Object)(totalTime - totalCompilationTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<? extends Script> compileScript(String actionName, String scriptContent) {
        GroovyCodeSource codeSource = this.buildClassScript(scriptContent, actionName);
        Object object = this.compilationLock;
        synchronized (object) {
            return this.compilationShell.parse(codeSource).getClass();
        }
    }

    private ImportCustomizer createImportCustomizer() {
        ImportCustomizer importCustomizer = new ImportCustomizer();
        importCustomizer.addImports(new String[]{"org.apache.unomi.api.services.EventService", "org.apache.unomi.groovy.actions.annotations.Action", "org.apache.unomi.groovy.actions.annotations.Parameter"});
        return importCustomizer;
    }

    private void validateNotEmpty(String value, String parameterName) {
        if (value == null || value.trim().isEmpty()) {
            throw new IllegalArgumentException(parameterName + " cannot be null or empty");
        }
    }

    private ScriptMetadata compileAndCreateMetadata(String actionName, String scriptContent) {
        long compilationStartTime = System.currentTimeMillis();
        Class<? extends Script> scriptClass = this.compileScript(actionName, scriptContent);
        long compilationTime = System.currentTimeMillis() - compilationStartTime;
        LOGGER.debug("Script {} compiled in {}ms", (Object)actionName, (Object)compilationTime);
        return new ScriptMetadata(actionName, scriptContent, scriptClass);
    }

    private Action getActionAnnotation(Class<? extends Script> scriptClass) {
        try {
            return scriptClass.getMethod("execute", new Class[0]).getAnnotation(Action.class);
        }
        catch (Exception e) {
            LOGGER.error("Failed to extract action annotation", (Throwable)e);
            return null;
        }
    }

    @Override
    public void save(String actionName, String groovyScript) {
        this.validateNotEmpty(actionName, "Action name");
        this.validateNotEmpty(groovyScript, "Groovy script");
        long startTime = System.currentTimeMillis();
        LOGGER.info("Saving script: {}", (Object)actionName);
        try {
            ScriptMetadata existingMetadata = this.scriptMetadataCache.get(actionName);
            if (existingMetadata != null && !existingMetadata.hasChanged(groovyScript)) {
                LOGGER.info("Script {} unchanged, skipping recompilation ({}ms)", (Object)actionName, (Object)(System.currentTimeMillis() - startTime));
                return;
            }
            long compilationStartTime = System.currentTimeMillis();
            ScriptMetadata metadata = this.compileAndCreateMetadata(actionName, groovyScript);
            long compilationTime = System.currentTimeMillis() - compilationStartTime;
            Action actionAnnotation = this.getActionAnnotation(metadata.getCompiledClass());
            if (actionAnnotation != null) {
                this.saveActionType(actionAnnotation);
            }
            this.saveScript(actionName, groovyScript);
            this.scriptMetadataCache.put(actionName, metadata);
            long totalTime = System.currentTimeMillis() - startTime;
            LOGGER.info("Script {} saved and compiled successfully (total: {}ms, compilation: {}ms)", new Object[]{actionName, totalTime, compilationTime});
        }
        catch (Exception e) {
            long totalTime = System.currentTimeMillis() - startTime;
            LOGGER.error("Failed to save script: {} ({}ms)", new Object[]{actionName, totalTime, e});
            throw new RuntimeException("Failed to save script: " + actionName, e);
        }
    }

    private void saveActionType(Action action) {
        Metadata metadata = new Metadata(null, action.id(), action.name().isEmpty() ? action.id() : action.name(), action.description());
        metadata.setHidden(action.hidden());
        metadata.setReadOnly(true);
        metadata.setSystemTags(new HashSet<String>(Arrays.asList(action.systemTags())));
        ActionType actionType = new ActionType(metadata);
        actionType.setActionExecutor(action.actionExecutor());
        actionType.setParameters(Stream.of(action.parameters()).map(parameter -> new Parameter(parameter.id(), parameter.type(), parameter.multivalued())).collect(Collectors.toList()));
        this.definitionsService.setActionType(actionType);
    }

    @Override
    public void remove(String actionName) {
        Action actionAnnotation;
        this.validateNotEmpty(actionName, "Action name");
        LOGGER.info("Removing script: {}", (Object)actionName);
        ScriptMetadata removedMetadata = this.scriptMetadataCache.remove(actionName);
        this.persistenceService.remove(actionName, GroovyAction.class);
        this.loggedRefreshErrors.remove(actionName);
        if (removedMetadata != null && (actionAnnotation = this.getActionAnnotation(removedMetadata.getCompiledClass())) != null) {
            this.definitionsService.removeActionType(actionAnnotation.id());
        }
        LOGGER.info("Script {} removed successfully", (Object)actionName);
    }

    @Override
    public Class<? extends Script> getCompiledScript(String id) {
        this.validateNotEmpty(id, "Script ID");
        ScriptMetadata metadata = this.scriptMetadataCache.get(id);
        if (metadata == null) {
            LOGGER.warn("Script {} not found in cache", (Object)id);
            return null;
        }
        return metadata.getCompiledClass();
    }

    @Override
    public ScriptMetadata getScriptMetadata(String actionName) {
        this.validateNotEmpty(actionName, "Action name");
        return this.scriptMetadataCache.get(actionName);
    }

    private GroovyCodeSource buildClassScript(String groovyScript, String actionName) {
        return new GroovyCodeSource(groovyScript, actionName, "/groovy/script");
    }

    private void saveScript(String actionName, String script) {
        GroovyAction groovyScript = new GroovyAction(actionName, script);
        this.persistenceService.save((Item)groovyScript);
        LOGGER.info("The script {} has been persisted.", (Object)actionName);
    }

    private void refreshGroovyActions() {
        long startTime = System.currentTimeMillis();
        ConcurrentHashMap<String, ScriptMetadata> newMetadataCache = new ConcurrentHashMap<String, ScriptMetadata>();
        int unchangedCount = 0;
        int recompiledCount = 0;
        int errorCount = 0;
        int newErrorCount = 0;
        long totalCompilationTime = 0L;
        for (GroovyAction groovyAction : this.persistenceService.getAllItems(GroovyAction.class)) {
            String actionName = groovyAction.getName();
            String scriptContent = groovyAction.getScript();
            try {
                ScriptMetadata existingMetadata = this.scriptMetadataCache.get(actionName);
                if (existingMetadata != null && !existingMetadata.hasChanged(scriptContent)) {
                    newMetadataCache.put(actionName, existingMetadata);
                    ++unchangedCount;
                    LOGGER.debug("Script {} unchanged during refresh, keeping cached version", (Object)actionName);
                    continue;
                }
                if (recompiledCount == 0) {
                    LOGGER.info("Refreshing scripts from persistence layer...");
                }
                long compilationStartTime = System.currentTimeMillis();
                ScriptMetadata metadata = this.compileAndCreateMetadata(actionName, scriptContent);
                long compilationTime = System.currentTimeMillis() - compilationStartTime;
                totalCompilationTime += compilationTime;
                this.loggedRefreshErrors.remove(actionName);
                newMetadataCache.put(actionName, metadata);
                ++recompiledCount;
                LOGGER.info("Script {} recompiled during refresh ({}ms)", (Object)actionName, (Object)compilationTime);
            }
            catch (Exception e) {
                ScriptMetadata existingMetadata;
                if (newErrorCount == 0 && recompiledCount == 0) {
                    LOGGER.info("Refreshing scripts from persistence layer...");
                }
                ++errorCount;
                String errorMessage = e.getMessage();
                Set<String> scriptErrors = this.loggedRefreshErrors.get(actionName);
                if (scriptErrors == null || !scriptErrors.contains(errorMessage)) {
                    ++newErrorCount;
                    LOGGER.error("Failed to refresh script: {}", (Object)actionName, (Object)e);
                    if (scriptErrors == null && this.loggedRefreshErrors.size() >= 100) {
                        String firstKey = this.loggedRefreshErrors.keySet().iterator().next();
                        this.loggedRefreshErrors.remove(firstKey);
                    }
                    if (scriptErrors == null) {
                        scriptErrors = ConcurrentHashMap.newKeySet();
                        this.loggedRefreshErrors.put(actionName, scriptErrors);
                    }
                    scriptErrors.add(errorMessage);
                    LOGGER.warn("Keeping existing version of script {} due to compilation error", (Object)actionName);
                }
                if ((existingMetadata = this.scriptMetadataCache.get(actionName)) == null) continue;
                newMetadataCache.put(actionName, existingMetadata);
            }
        }
        this.scriptMetadataCache = newMetadataCache;
        if (recompiledCount > 0 || newErrorCount > 0) {
            long totalTime = System.currentTimeMillis() - startTime;
            LOGGER.info("Script refresh completed: {} unchanged, {} recompiled, {} errors. Total time: {}ms", new Object[]{unchangedCount, recompiledCount, errorCount, totalTime});
            LOGGER.debug("Refresh metrics: Recompilation time: {}ms, Cache update overhead: {}ms", (Object)totalCompilationTime, (Object)(totalTime - totalCompilationTime));
        } else {
            LOGGER.debug("Script refresh completed: {} scripts checked, no changes detected ({}ms)", (Object)unchangedCount, (Object)(System.currentTimeMillis() - startTime));
        }
    }

    private void initializeTimers() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                GroovyActionsServiceImpl.this.refreshGroovyActions();
            }
        };
        this.scheduledFuture = this.schedulerService.getScheduleExecutorService().scheduleWithFixedDelay(task, 0L, this.config.services_groovy_actions_refresh_interval(), TimeUnit.MILLISECONDS);
    }

    @ObjectClassDefinition(name="Groovy actions service config", description="The configuration for the Groovy actions service")
    public static @interface GroovyActionsServiceConfig {
        public int services_groovy_actions_refresh_interval() default 1000;
    }
}

