/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.util.htmlview;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.TypeOrFeature;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.internal.util.XMLUtils;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;

public class AnnotationViewGenerator {
    private TransformerFactory mTFactory;
    private Templates mStyleMapToCss;
    private Templates mStyleMapToLegend;
    private Templates mStyleMapToDocFrameXsl;
    private File mOutputDir;

    public AnnotationViewGenerator(File aOutputDir) {
        this.mOutputDir = aOutputDir;
        this.mTFactory = XMLUtils.createTransformerFactory();
        this.mStyleMapToCss = this.getTemplates("styleMapToCss.xsl");
        this.mStyleMapToLegend = this.getTemplates("styleMapToLegend.xsl");
        this.mStyleMapToDocFrameXsl = this.getTemplates("styleMapToDocFrameXsl.xsl");
    }

    private Templates getTemplates(String filename) {
        Templates templates;
        InputStream is = AnnotationViewGenerator.class.getResourceAsStream(filename);
        try {
            templates = this.mTFactory.newTemplates(new StreamSource(is));
        }
        catch (TransformerConfigurationException e) {
            throw new UIMARuntimeException((Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return templates;
    }

    private void writeToFile(String filename, File outputDir) {
        FileOutputStream os;
        File outFile = new File(outputDir, filename);
        try {
            os = new FileOutputStream(outFile);
        }
        catch (FileNotFoundException e) {
            throw new UIMARuntimeException((Throwable)e);
        }
        InputStream is = AnnotationViewGenerator.class.getResourceAsStream(filename);
        try {
            int numRead;
            byte[] buf = new byte[1024];
            while ((numRead = is.read(buf)) > 0) {
                ((OutputStream)os).write(buf, 0, numRead);
            }
        }
        catch (IOException e) {
            throw new UIMARuntimeException((Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
            try {
                ((OutputStream)os).close();
            }
            catch (IOException iOException) {}
        }
    }

    public void processStyleMap(File aStyleMap) throws TransformerException {
        this.writeToFile("annotations.xsl", this.mOutputDir);
        this.writeToFile("annotationViewer.js", this.mOutputDir);
        this.writeToFile("index.html", this.mOutputDir);
        Transformer cssTransformer = this.mStyleMapToCss.newTransformer();
        cssTransformer.transform(new StreamSource(aStyleMap), new StreamResult(new File(this.mOutputDir, "annotations.css").getAbsolutePath()));
        Transformer legendTransformer = this.mStyleMapToLegend.newTransformer();
        legendTransformer.transform(new StreamSource(aStyleMap), new StreamResult(new File(this.mOutputDir, "legend.html").getAbsolutePath()));
        Transformer docFrameXslTransformer = this.mStyleMapToDocFrameXsl.newTransformer();
        docFrameXslTransformer.transform(new StreamSource(aStyleMap), new StreamResult(new File(this.mOutputDir, "docFrame.xsl").getAbsolutePath()));
    }

    public void processDocument(File aInlineXmlDoc) throws TransformerException {
        Transformer docHtmlTransformer = this.mTFactory.newTransformer(new StreamSource(new File(this.mOutputDir, "docFrame.xsl")));
        docHtmlTransformer.transform(new StreamSource(aInlineXmlDoc), new StreamResult(new File(this.mOutputDir, "docView.html").getAbsolutePath()));
    }

    public static String autoGenerateStyleMap(AnalysisEngineMetaData aTaeMetaData) {
        String[] STYLES = new String[]{"color:black; background:lightblue;", "color:black; background:lightgreen;", "color:black; background:orange;", "color:black; background:yellow;", "color:black; background:pink;", "color:black; background:salmon;", "color:black; background:cyan;", "color:black; background:violet;", "color:black; background:tan;", "color:white; background:brown;", "color:white; background:blue;", "color:white; background:green;", "color:white; background:red;", "color:white; background:mediumpurple;"};
        ArrayList<String> outputTypes = new ArrayList<String>();
        Capability[] capabilities = aTaeMetaData.getCapabilities();
        for (int i = 0; i < capabilities.length; ++i) {
            TypeOrFeature[] outputs = capabilities[i].getOutputs();
            for (int j = 0; j < outputs.length; ++j) {
                if (!outputs[j].isType() || outputTypes.contains(outputs[j].getName())) continue;
                outputTypes.add(outputs[j].getName());
            }
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
        buf.append("<styleMap>\n");
        int i = 0;
        Iterator it = outputTypes.iterator();
        while (it.hasNext()) {
            String outputType;
            String label = outputType = (String)it.next();
            int lastDot = outputType.lastIndexOf(46);
            if (lastDot > -1) {
                label = outputType.substring(lastDot + 1);
            }
            buf.append("<rule>\n");
            buf.append("<pattern>");
            buf.append(outputType);
            buf.append("</pattern>\n");
            buf.append("<label>");
            buf.append(label);
            buf.append("</label>\n");
            buf.append("<style>");
            buf.append(STYLES[i % STYLES.length]);
            buf.append("</style>\n");
            buf.append("</rule>\n");
            ++i;
        }
        buf.append("</styleMap>\n");
        return buf.toString();
    }

    public static String autoGenerateStyleMap(TypeSystemDescription aTypeSystem) {
        String[] STYLES = new String[]{"color:black; background:lightblue;", "color:black; background:lightgreen;", "color:black; background:orange;", "color:black; background:yellow;", "color:black; background:pink;", "color:black; background:salmon;", "color:black; background:cyan;", "color:black; background:violet;", "color:black; background:tan;", "color:white; background:brown;", "color:white; background:blue;", "color:white; background:green;", "color:white; background:red;", "color:white; background:mediumpurple;"};
        TypeDescription[] types = aTypeSystem.getTypes();
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
        buf.append("<styleMap>\n");
        for (int i = 0; i < types.length; ++i) {
            String outputType;
            String label = outputType = types[i].getName();
            int lastDot = outputType.lastIndexOf(46);
            if (lastDot > -1) {
                label = outputType.substring(lastDot + 1);
            }
            buf.append("<rule>\n");
            buf.append("<pattern>");
            buf.append(outputType);
            buf.append("</pattern>\n");
            buf.append("<label>");
            buf.append(label);
            buf.append("</label>\n");
            buf.append("<style>");
            buf.append(STYLES[i % STYLES.length]);
            buf.append("</style>\n");
            buf.append("</rule>\n");
        }
        buf.append("</styleMap>\n");
        return buf.toString();
    }

    public void autoGenerateStyleMapFile(AnalysisEngine aAE, File aStyleMapFile) throws IOException {
        this.autoGenerateStyleMapFile(aAE.getAnalysisEngineMetaData(), aStyleMapFile);
    }

    public void autoGenerateStyleMapFile(AnalysisEngineMetaData aMetaData, File aStyleMapFile) throws IOException {
        String xmlStr = AnnotationViewGenerator.autoGenerateStyleMap(aMetaData);
        try (FileWriter out = new FileWriter(aStyleMapFile);){
            out.write(xmlStr);
        }
    }

    public void autoGenerateStyleMapFile(TypeSystemDescription aTypeSystem, File aStyleMapFile) throws IOException {
        String xmlStr = AnnotationViewGenerator.autoGenerateStyleMap(aTypeSystem);
        try (FileWriter out = new FileWriter(aStyleMapFile);){
            out.write(xmlStr);
        }
    }
}

