/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.schedule;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.modules.ScheduledJobLoader;
import org.apache.turbine.services.schedule.JobEntry;

public class WorkerThread
implements Runnable {
    private JobEntry je = null;
    private static final Logger log = LogManager.getLogger((String)"scheduler");

    public WorkerThread(JobEntry je) {
        this.je = je;
    }

    @Override
    public void run() {
        if (this.je == null || this.je.isActive()) {
            return;
        }
        try {
            if (!this.je.isActive()) {
                this.je.setActive(true);
                this.logStateChange("started");
                ScheduledJobLoader.getInstance().exec(this.je, this.je.getTask());
            }
        }
        catch (Exception e) {
            log.error("Error in WorkerThread for scheduled job #{}, task: {}", (Object)this.je.getJobId(), (Object)this.je.getTask(), (Object)e);
        }
        finally {
            if (this.je.isActive()) {
                this.je.setActive(false);
                this.logStateChange("completed");
            }
        }
    }

    private final void logStateChange(String state) {
        log.error("Scheduled job #{} {}, task: {}", (Object)this.je.getJobId(), (Object)state, (Object)this.je.getTask());
    }
}

