/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.profile;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.profile.FormatSpecificNameIdentifierGenerator;

public abstract class AbstractNameIdentifierGenerator<NameIdType extends SAMLObject>
extends AbstractIdentifiableInitializableComponent
implements FormatSpecificNameIdentifierGenerator<NameIdType>,
Predicate<ProfileRequestContext> {
    @Nonnull
    private Predicate<ProfileRequestContext> activationCondition = PredicateSupport.alwaysTrue();
    @Nullable
    private Function<ProfileRequestContext, String> defaultIdPNameQualifierLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, String> defaultSPNameQualifierLookupStrategy;
    private boolean omitQualifiers;
    @Nonnull
    @NotEmpty
    private String format = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
    @Nullable
    private String idpNameQualifier;
    @Nullable
    private String spNameQualifier;
    @Nullable
    private String spProvidedId;

    protected AbstractNameIdentifierGenerator() {
    }

    public void setActivationCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.checkSetterPreconditions();
        this.activationCondition = (Predicate)Constraint.isNotNull(condition, (String)"Predicate cannot be null");
    }

    @Nullable
    public Function<ProfileRequestContext, String> getDefaultIdPNameQualifierLookupStrategy() {
        return this.defaultIdPNameQualifierLookupStrategy;
    }

    public void setDefaultIdPNameQualifierLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.defaultIdPNameQualifierLookupStrategy = strategy;
    }

    @Nullable
    public Function<ProfileRequestContext, String> getDefaultSPNameQualifierLookupStrategy() {
        return this.defaultSPNameQualifierLookupStrategy;
    }

    public void setDefaultSPNameQualifierLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.defaultSPNameQualifierLookupStrategy = strategy;
    }

    public boolean isOmitQualifiers() {
        return this.omitQualifiers;
    }

    public void setOmitQualifiers(boolean flag) {
        this.checkSetterPreconditions();
        this.omitQualifiers = flag;
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getFormat() {
        return this.format;
    }

    public void setFormat(@Nonnull @NotEmpty String f) {
        this.checkSetterPreconditions();
        this.format = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)f), (String)"Format cannot be null or empty");
    }

    @Nullable
    public String getIdPNameQualifier() {
        return this.idpNameQualifier;
    }

    public void setIdPNameQualifier(@Nullable String qualifier) {
        this.checkSetterPreconditions();
        this.idpNameQualifier = StringSupport.trimOrNull((String)qualifier);
    }

    @Nullable
    public String getSPNameQualifier() {
        return this.spNameQualifier;
    }

    public void setSPNameQualifier(@Nullable String qualifier) {
        this.checkSetterPreconditions();
        this.spNameQualifier = StringSupport.trimOrNull((String)qualifier);
    }

    @Nullable
    public String getSPProvidedID() {
        return this.spProvidedId;
    }

    public void setSPProvidedId(@Nullable String id) {
        this.checkSetterPreconditions();
        this.spProvidedId = id;
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext input) {
        return this.activationCondition.test(input);
    }

    @Override
    @Nullable
    public NameIdType generate(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull @NotEmpty String theFormat) throws SAMLException {
        this.checkComponentActive();
        if (!Objects.equals(this.format, theFormat)) {
            throw new SAMLException("The format to generate does not match the value configured");
        }
        if (!this.test(profileRequestContext)) {
            return null;
        }
        return this.doGenerate(profileRequestContext);
    }

    @Nullable
    protected abstract NameIdType doGenerate(@Nonnull ProfileRequestContext var1) throws SAMLException;

    @Nullable
    protected String getIdentifier(@Nonnull ProfileRequestContext profileRequestContext) throws SAMLException {
        return null;
    }

    @Nullable
    protected String getEffectiveIdPNameQualifier(@Nonnull ProfileRequestContext profileRequestContext) {
        if (this.idpNameQualifier != null) {
            if (this.omitQualifiers) {
                Function<ProfileRequestContext, String> strategy = this.defaultIdPNameQualifierLookupStrategy;
                if (strategy == null || !Objects.equals(this.idpNameQualifier, strategy.apply(profileRequestContext))) {
                    return this.idpNameQualifier;
                }
                return null;
            }
            return this.idpNameQualifier;
        }
        if (!this.omitQualifiers && this.defaultIdPNameQualifierLookupStrategy != null) {
            return this.defaultIdPNameQualifierLookupStrategy.apply(profileRequestContext);
        }
        return null;
    }

    @Nullable
    protected String getEffectiveSPNameQualifier(@Nonnull ProfileRequestContext profileRequestContext) {
        if (this.spNameQualifier != null) {
            if (this.omitQualifiers) {
                Function<ProfileRequestContext, String> strategy = this.defaultSPNameQualifierLookupStrategy;
                if (strategy == null || !Objects.equals(this.spNameQualifier, strategy.apply(profileRequestContext))) {
                    return this.spNameQualifier;
                }
                return null;
            }
            return this.spNameQualifier;
        }
        if (!this.omitQualifiers && this.defaultSPNameQualifierLookupStrategy != null) {
            return this.defaultSPNameQualifierLookupStrategy.apply(profileRequestContext);
        }
        return null;
    }
}

