/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.meta;

import java.io.File;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.apache.openjpa.conf.SeqValue;
import org.apache.openjpa.kernel.Seq;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.conf.PluginValue;
import org.apache.openjpa.lib.meta.SourceTracker;
import org.apache.openjpa.lib.util.Closeable;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.StringUtil;
import org.apache.openjpa.lib.xml.Commentable;
import org.apache.openjpa.meta.MetaDataContext;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.util.MetaDataException;
import org.apache.openjpa.util.OpenJPAException;

public class SequenceMetaData
implements SourceTracker,
MetaDataContext,
Closeable,
Commentable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NAME_SYSTEM = "system";
    public static final String IMPL_NATIVE = "native";
    public static final String IMPL_TIME = "time";
    private static final String PROP_SEQUENCE = "Sequence";
    private static final String PROP_INITIAL_VALUE = "InitialValue";
    private static final String PROP_ALLOCATE = "Allocate";
    private static final String PROP_INCREMENT = "Increment";
    private static final String PROP_SCHEMA = "Schema";
    private static final String PROP_CATALOG = "Catalog";
    private static final Localizer _loc = Localizer.forPackage(SequenceMetaData.class);
    private MetaDataRepository _repos;
    private SequenceFactory _factory = null;
    private final String _name;
    private int _type = 0;
    private String _plugin = "native";
    private File _source = null;
    private Object _scope = null;
    private int _srcType = 0;
    private int _lineNum = 0;
    private int _colNum = 0;
    private String[] _comments = null;
    private String _sequence = null;
    private int _increment = -1;
    private int _allocate = -1;
    private int _initial = -1;
    private String _schema = null;
    private String _catalog = null;
    private transient Seq _instance = null;

    public SequenceMetaData(String name, MetaDataRepository repos) {
        this._name = name;
        this._repos = repos;
    }

    @Override
    public MetaDataRepository getRepository() {
        return this._repos;
    }

    public String getName() {
        return this._name;
    }

    @Override
    public File getSourceFile() {
        return this._source;
    }

    @Override
    public Object getSourceScope() {
        return this._scope;
    }

    @Override
    public int getSourceType() {
        return this._srcType;
    }

    public void setSource(File file, Object scope, int srcType) {
        this._source = file;
        this._scope = scope;
        this._srcType = srcType;
    }

    @Override
    public int getLineNumber() {
        return this._lineNum;
    }

    public void setLineNumber(int lineNum) {
        this._lineNum = lineNum;
    }

    @Override
    public int getColNumber() {
        return this._colNum;
    }

    public void setColNumber(int colNum) {
        this._colNum = colNum;
    }

    @Override
    public String getResourceName() {
        return this._name;
    }

    public int getType() {
        return this._type;
    }

    public void setType(int type) {
        this._type = type;
    }

    public String getSequence() {
        return this._sequence;
    }

    public void setSequence(String sequence) {
        this._sequence = sequence;
    }

    public int getIncrement() {
        return this._increment;
    }

    public void setIncrement(int increment) {
        this._increment = increment;
    }

    public int getAllocate() {
        return this._allocate;
    }

    public void setAllocate(int allocate) {
        this._allocate = allocate;
    }

    public int getInitialValue() {
        return this._initial;
    }

    public void setInitialValue(int initial) {
        this._initial = initial;
    }

    public String getSequencePlugin() {
        return this._plugin;
    }

    public void setSequencePlugin(String plugin) {
        this._plugin = plugin;
    }

    public SequenceFactory getSequenceFactory() {
        return this._factory;
    }

    public void setSequenceFactory(SequenceFactory factory) {
        this._factory = factory;
    }

    public synchronized Seq getInstance(ClassLoader envLoader) {
        if (this._instance == null) {
            this._instance = this.instantiate(envLoader);
        }
        return this._instance;
    }

    protected Seq instantiate(ClassLoader envLoader) {
        if (NAME_SYSTEM.equals(this._name)) {
            return this._repos.getConfiguration().getSequenceInstance();
        }
        try {
            Seq seq;
            PluginValue plugin = this.newPluginValue("sequence-plugin");
            plugin.setString(this._plugin);
            String clsName = plugin.getClassName();
            Class<?> cls = null;
            try {
                cls = Class.forName(clsName, true, AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(Seq.class)));
            }
            catch (ClassNotFoundException cnfe) {
                cls = Class.forName(clsName, true, envLoader);
            }
            StringBuilder props = new StringBuilder();
            if (plugin.getProperties() != null) {
                props.append(plugin.getProperties());
            }
            this.addStandardProperties(props);
            if (Seq.class.isAssignableFrom(cls)) {
                seq = (Seq)AccessController.doPrivileged(J2DoPrivHelper.newInstanceAction(cls));
                Configurations.configureInstance((Object)seq, (Configuration)this._repos.getConfiguration(), props.toString());
                if (this._type != 0) {
                    seq.setType(this._type);
                }
            } else if (this._factory != null) {
                seq = this._factory.toSequence(cls, props.toString());
            } else {
                throw new MetaDataException(_loc.get("not-seq-cls", this._name, cls));
            }
            return seq;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            if (e instanceof PrivilegedActionException) {
                e = ((PrivilegedActionException)e).getException();
            }
            throw new MetaDataException(_loc.get("cant-init-seq", this._name)).setCause(e);
        }
    }

    public void setSchema(String schema) {
        if (schema == null || "".equals(schema)) {
            String tmp = this.getRepository().getMetaDataFactory().getDefaults().getDefaultSchema();
            schema = tmp != null ? tmp : "";
        }
        this._schema = schema;
    }

    public String getSchema() {
        return this._schema;
    }

    public void setCatalog(String catalog) {
        this._catalog = catalog;
    }

    public String getCatalog() {
        return this._catalog;
    }

    protected PluginValue newPluginValue(String property) {
        return new SeqValue(property);
    }

    protected void addStandardProperties(StringBuilder props) {
        this.appendProperty(props, PROP_SEQUENCE, this.wrapValue(this._sequence));
        this.appendProperty(props, PROP_INITIAL_VALUE, this._initial);
        this.appendProperty(props, PROP_ALLOCATE, this._allocate);
        this.appendProperty(props, PROP_INCREMENT, this._increment);
        this.appendProperty(props, PROP_SCHEMA, this.wrapValue(this._schema));
        this.appendProperty(props, PROP_CATALOG, this.wrapValue(this._catalog));
    }

    protected String wrapValue(String value) {
        if (value != null) {
            return "\"" + value + "\"";
        }
        return value;
    }

    protected void appendProperty(StringBuilder props, String name, String val) {
        if (StringUtil.isEmpty(val)) {
            return;
        }
        if (props.length() > 0) {
            props.append(",");
        }
        props.append(name).append("=").append(val);
    }

    protected void appendProperty(StringBuilder props, String name, int val) {
        if (val == -1) {
            return;
        }
        if (props.length() > 0) {
            props.append(",");
        }
        props.append(name).append("=").append(val);
    }

    @Override
    public void close() {
        if (this._instance != null && !NAME_SYSTEM.equals(this._name)) {
            try {
                this._instance.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return this._name;
    }

    @Override
    public String[] getComments() {
        return this._comments == null ? EMPTY_COMMENTS : this._comments;
    }

    @Override
    public void setComments(String[] comments) {
        this._comments = comments;
    }

    public static interface SequenceFactory
    extends Serializable {
        public Seq toSequence(Class var1, String var2) throws Exception;
    }
}

