/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.services.executor;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class BatcheeThreadFactory
implements ThreadFactory {
    public static final ThreadFactory INSTANCE = new BatcheeThreadFactory();
    private static final ThreadGroup GROUP = System.getSecurityManager() != null ? System.getSecurityManager().getThreadGroup() : Thread.currentThread().getThreadGroup();
    private static final String PREFIX = "batchee-thread-";
    private static final AtomicInteger THREAD_NUMBER = new AtomicInteger(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Thread newThread(Runnable r) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(BatcheeThreadFactory.class.getClassLoader());
        try {
            Thread t = new Thread(GROUP, r, PREFIX + THREAD_NUMBER.getAndIncrement(), 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            Thread thread = t;
            return thread;
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
    }
}

