/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.opentelemetry.implementation.cdi;

import io.opentelemetry.instrumentation.annotations.WithSpan;
import io.smallrye.opentelemetry.implementation.cdi.OpenTelemetryProducer;
import io.smallrye.opentelemetry.implementation.cdi.WithSpanInterceptorBean;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.util.Nonbinding;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OpenTelemetryExtension
implements Extension {
    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        beforeBeanDiscovery.addInterceptorBinding((AnnotatedType)new WithSpanAnnotatedType((AnnotatedType<WithSpan>)beanManager.createAnnotatedType(WithSpan.class)));
        beforeBeanDiscovery.addAnnotatedType(OpenTelemetryProducer.class, OpenTelemetryProducer.class.getName());
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        afterBeanDiscovery.addBean((Bean)new WithSpanInterceptorBean(beanManager));
    }

    static class WithSpanAnnotatedType
    implements AnnotatedType<WithSpan> {
        private final AnnotatedType<WithSpan> delegate;
        private final Set<AnnotatedMethod<? super WithSpan>> methods;

        WithSpanAnnotatedType(AnnotatedType<WithSpan> delegate) {
            this.delegate = delegate;
            this.methods = new HashSet<AnnotatedMethod<? super WithSpan>>();
            for (final AnnotatedMethod method : delegate.getMethods()) {
                this.methods.add((AnnotatedMethod<? super WithSpan>)new AnnotatedMethod<WithSpan>(){
                    private final AnnotatedMethod<WithSpan> delegate;
                    private final Set<Annotation> annotations;
                    {
                        this.delegate = method;
                        this.annotations = Collections.singleton(Nonbinding.Literal.INSTANCE);
                    }

                    public Method getJavaMember() {
                        return this.delegate.getJavaMember();
                    }

                    public List<AnnotatedParameter<WithSpan>> getParameters() {
                        return this.delegate.getParameters();
                    }

                    public boolean isStatic() {
                        return this.delegate.isStatic();
                    }

                    public AnnotatedType<WithSpan> getDeclaringType() {
                        return this.delegate.getDeclaringType();
                    }

                    public Type getBaseType() {
                        return this.delegate.getBaseType();
                    }

                    public Set<Type> getTypeClosure() {
                        return this.delegate.getTypeClosure();
                    }

                    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
                        if (annotationType.equals(Nonbinding.class)) {
                            return (T)this.annotations.iterator().next();
                        }
                        return null;
                    }

                    public Set<Annotation> getAnnotations() {
                        return this.annotations;
                    }

                    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
                        return annotationType.equals(Nonbinding.class);
                    }
                });
            }
        }

        public Class<WithSpan> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        public Set<AnnotatedConstructor<WithSpan>> getConstructors() {
            return this.delegate.getConstructors();
        }

        public Set<AnnotatedMethod<? super WithSpan>> getMethods() {
            return this.methods;
        }

        public Set<AnnotatedField<? super WithSpan>> getFields() {
            return this.delegate.getFields();
        }

        public Type getBaseType() {
            return this.delegate.getBaseType();
        }

        public Set<Type> getTypeClosure() {
            return this.delegate.getTypeClosure();
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            return (T)this.delegate.getAnnotation(annotationType);
        }

        public Set<Annotation> getAnnotations() {
            return this.delegate.getAnnotations();
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.delegate.isAnnotationPresent(annotationType);
        }
    }
}

