/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.IO;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.ReadWriting;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Parameters;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.EmptyTraverser;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.io.GraphReader;
import org.apache.tinkerpop.gremlin.structure.io.GraphWriter;
import org.apache.tinkerpop.gremlin.structure.io.IoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.graphml.GraphMLReader;
import org.apache.tinkerpop.gremlin.structure.io.graphml.GraphMLWriter;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONMapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONReader;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONWriter;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoMapper;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoReader;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoWriter;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class IoStep<S>
extends AbstractStep<S, S>
implements ReadWriting {
    private Parameters parameters = new Parameters();
    private boolean first = true;
    private String file;
    private ReadWriting.Mode mode = ReadWriting.Mode.UNSET;

    public IoStep(Traversal.Admin traversal, String file) {
        super(traversal);
        if (null == file || file.isEmpty()) {
            throw new IllegalArgumentException("file cannot be null or empty");
        }
        this.file = file;
    }

    @Override
    public void setMode(ReadWriting.Mode mode) {
        this.mode = mode;
    }

    @Override
    public ReadWriting.Mode getMode() {
        return this.mode;
    }

    @Override
    public String getFile() {
        return this.file;
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public void configure(Object ... keyValues) {
        this.parameters.set(null, keyValues);
    }

    @Override
    protected Traverser.Admin<S> processNextStart() {
        if (this.mode == ReadWriting.Mode.UNSET) {
            throw new IllegalStateException("IO mode was not set to read() or write()");
        }
        if (!this.first) {
            throw FastNoSuchElementException.instance();
        }
        this.first = false;
        File file = new File(this.file);
        if (this.mode == ReadWriting.Mode.READING) {
            if (!file.exists()) {
                throw new IllegalStateException(this.file + " does not exist");
            }
            return this.read(file);
        }
        if (this.mode == ReadWriting.Mode.WRITING) {
            return this.write(file);
        }
        throw new IllegalStateException("Invalid ReadWriting.Mode configured in IoStep: " + this.mode.name());
    }

    protected Traverser.Admin<S> write(File file) {
        EmptyTraverser emptyTraverser;
        FileOutputStream stream = new FileOutputStream(file);
        try {
            Graph graph = this.traversal.getGraph().get();
            this.constructWriter().writeGraph(stream, graph);
            emptyTraverser = EmptyTraverser.instance();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((OutputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new IllegalStateException(String.format("Could not write file %s from graph", this.file), ioe);
            }
        }
        ((OutputStream)stream).close();
        return emptyTraverser;
    }

    protected Traverser.Admin<S> read(File file) {
        EmptyTraverser emptyTraverser;
        FileInputStream stream = new FileInputStream(file);
        try {
            Graph graph = this.traversal.getGraph().get();
            this.constructReader().readGraph(stream, graph);
            emptyTraverser = EmptyTraverser.instance();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new IllegalStateException(String.format("Could not read file %s into graph", this.file), ioe);
            }
        }
        ((InputStream)stream).close();
        return emptyTraverser;
    }

    private GraphReader constructReader() {
        String objectOrClass = this.parameters.get(IO.reader, this::detectFileType).get(0);
        if (objectOrClass instanceof GraphReader) {
            return (GraphReader)((Object)objectOrClass);
        }
        if (objectOrClass instanceof String) {
            if (objectOrClass.equals("graphson")) {
                GraphSONMapper.Builder builder = GraphSONMapper.build();
                this.detectRegistries().forEach(builder::addRegistry);
                return GraphSONReader.build().mapper(builder.create()).create();
            }
            if (objectOrClass.equals("gryo")) {
                GryoMapper.Builder builder = GryoMapper.build();
                this.detectRegistries().forEach(builder::addRegistry);
                return GryoReader.build().mapper(builder.create()).create();
            }
            if (objectOrClass.equals("graphml")) {
                return GraphMLReader.build().create();
            }
            try {
                Class<?> graphReaderClazz = Class.forName(objectOrClass);
                Method build = graphReaderClazz.getMethod("build", new Class[0]);
                GraphReader.ReaderBuilder builder = (GraphReader.ReaderBuilder)build.invoke(null, new Object[0]);
                return builder.create();
            }
            catch (Exception ex) {
                throw new IllegalStateException(String.format("Could not construct the specified GraphReader of %s", objectOrClass), ex);
            }
        }
        throw new IllegalStateException("GraphReader could not be determined");
    }

    private GraphWriter constructWriter() {
        String objectOrClass = this.parameters.get(IO.writer, this::detectFileType).get(0);
        if (objectOrClass instanceof GraphWriter) {
            return (GraphWriter)((Object)objectOrClass);
        }
        if (objectOrClass instanceof String) {
            if (objectOrClass.equals("graphson")) {
                GraphSONMapper.Builder builder = GraphSONMapper.build();
                this.detectRegistries().forEach(builder::addRegistry);
                return GraphSONWriter.build().mapper(builder.create()).create();
            }
            if (objectOrClass.equals("gryo")) {
                GryoMapper.Builder builder = GryoMapper.build();
                this.detectRegistries().forEach(builder::addRegistry);
                return GryoWriter.build().mapper(builder.create()).create();
            }
            if (objectOrClass.equals("graphml")) {
                return GraphMLWriter.build().create();
            }
            try {
                Class<?> graphWriterClazz = Class.forName(objectOrClass);
                Method build = graphWriterClazz.getMethod("build", new Class[0]);
                GraphWriter.WriterBuilder builder = (GraphWriter.WriterBuilder)build.invoke(null, new Object[0]);
                return builder.create();
            }
            catch (Exception ex) {
                throw new IllegalStateException(String.format("Could not construct the specified GraphWriter of %s", objectOrClass), ex);
            }
        }
        throw new IllegalStateException("GraphWriter could not be determined");
    }

    protected String detectFileType() {
        if (this.file.endsWith(".kryo")) {
            return "gryo";
        }
        if (this.file.endsWith(".json")) {
            return "graphson";
        }
        if (this.file.endsWith(".xml") || this.file.endsWith(".graphml")) {
            return "graphml";
        }
        throw new IllegalStateException("Could not detect the file format - specify the writer explicitly or rename file with a standard extension");
    }

    protected List<IoRegistry> detectRegistries() {
        List k = this.parameters.get(IO.registry, null);
        return k.stream().map(cn -> {
            try {
                if (cn instanceof IoRegistry) {
                    return (IoRegistry)cn;
                }
                Class<?> clazz = Class.forName(cn.toString());
                return (IoRegistry)clazz.getMethod("instance", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }).collect(Collectors.toList());
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode() ^ this.parameters.hashCode();
        return null != this.file ? hash ^ this.file.hashCode() : hash;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.file, this.parameters);
    }

    @Override
    public IoStep clone() {
        IoStep clone = (IoStep)super.clone();
        clone.parameters = this.parameters.clone();
        clone.file = this.file;
        clone.mode = this.mode;
        return clone;
    }
}

