/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.internal;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.internal.Strings;
import org.opengis.util.CodeList;

public final class CodeLists
implements CodeList.Filter {
    public static final String RESOURCES = "org.apache.sis.metadata.iso.CodeLists";
    private final String codename;
    private final boolean canCreate;

    private CodeLists(String codename, boolean canCreate) {
        this.codename = codename;
        this.canCreate = canCreate;
    }

    @Override
    public String codename() {
        return this.canCreate ? this.codename : null;
    }

    @Override
    public boolean accept(CodeList<?> code) {
        for (String candidate : code.names()) {
            if (!CodeLists.accept(candidate, this.codename)) continue;
            return true;
        }
        return false;
    }

    private static boolean accept(String candidate, String codename) {
        return CharSequences.equalsFiltered(candidate, codename, Characters.Filter.LETTERS_AND_DIGITS, true);
    }

    public static <T extends CodeList<T>> T forName(Class<T> codeType, String name, boolean canCreate) {
        if ((name = Strings.trimOrNull(name)) == null) {
            return null;
        }
        return CodeList.valueOf(codeType, new CodeLists(name, canCreate));
    }

    public static <T extends Enum<T>> T forName(Class<T> enumType, String name) {
        if ((name = Strings.trimOrNull(name)) != null) {
            try {
                return Enum.valueOf(enumType, name);
            }
            catch (IllegalArgumentException e) {
                Enum[] values = (Enum[])enumType.getEnumConstants();
                if (values == null) {
                    throw e;
                }
                for (Enum code : values) {
                    if (!CodeLists.accept(code.name(), name)) continue;
                    return (T)((Enum)enumType.cast(code));
                }
            }
        }
        return null;
    }

    public static <T extends CodeList<?>> T[] values(Class<T> codeType) {
        Object values;
        try {
            values = codeType.getMethod("values", null).invoke(null, (Object[])null);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new UndeclaredThrowableException(cause);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            values = Array.newInstance(codeType, 0);
        }
        return (CodeList[])values;
    }
}

