/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io;

import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sis.io.CompoundFormat;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.StringBuilders;
import org.apache.sis.util.resources.Errors;

public abstract class TabularFormat<T>
extends CompoundFormat<T> {
    private static final long serialVersionUID = -4556687020021477908L;
    protected String lineSeparator;
    protected String columnSeparator = " ";
    protected char fillCharacter = (char)32;
    protected String beforeFill = "";
    protected boolean omitTrailingNulls;
    private boolean isParsePatternDefined;
    private Pattern parsePattern;

    public TabularFormat(Locale locale, TimeZone timezone) {
        super(locale, timezone);
        this.lineSeparator = System.lineSeparator();
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String separator) {
        ArgumentChecks.ensureNonEmpty("separator", separator);
        this.lineSeparator = separator;
    }

    public String getColumnSeparatorPattern() {
        StringBuilder buffer = new StringBuilder(8);
        buffer.append(this.beforeFill).append('\uffff').append(this.columnSeparator);
        StringBuilders.replace(buffer, "\\", "\\\\");
        StringBuilders.replace(buffer, "?", "\\?");
        StringBuilders.replace(buffer, "[", "\\[");
        StringBuilders.replace(buffer, "]", "\\]");
        StringBuilders.replace(buffer, "/", "\\/");
        if (this.omitTrailingNulls) {
            buffer.insert(0, '?');
        }
        int insertAt = buffer.indexOf("\uffff");
        buffer.replace(insertAt, insertAt + 1, "[\uffff]").setCharAt(insertAt + 1, this.fillCharacter);
        if (this.isParsePatternDefined) {
            buffer.append('/').append(this.parsePattern.pattern());
        }
        return buffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setColumnSeparatorPattern(String pattern) throws IllegalArgumentException {
        ArgumentChecks.ensureNonEmpty("pattern", pattern);
        int length = pattern.length();
        StringBuilder buffer = new StringBuilder(length);
        boolean escape = false;
        boolean trim = false;
        String prefix = null;
        String regex = null;
        int separatorIndex = -1;
        block12: for (int i = 0; i < length; ++i) {
            char c = pattern.charAt(i);
            switch (c) {
                case '\uffff': {
                    prefix = null;
                    break block12;
                }
                case '\\': {
                    if (i == separatorIndex) continue block12;
                    if (escape) break;
                    escape = true;
                    continue block12;
                }
                case '?': {
                    if (i != 0) {
                        prefix = null;
                        break block12;
                    }
                    trim = true;
                    continue block12;
                }
                case '[': {
                    if (escape) break;
                    if (i == separatorIndex) continue block12;
                    if (separatorIndex >= 0) {
                        prefix = null;
                        break block12;
                    }
                    separatorIndex = i + 1;
                    continue block12;
                }
                case ']': {
                    if (escape) break;
                    switch (i - separatorIndex) {
                        case 0: {
                            continue block12;
                        }
                        case 1: {
                            prefix = buffer.toString();
                            buffer.setLength(0);
                            continue block12;
                        }
                        default: {
                            prefix = null;
                            break;
                        }
                    }
                    break block12;
                }
                case '/': {
                    if (escape) break;
                    regex = pattern.substring(i + 1);
                    break block12;
                }
            }
            if (i == separatorIndex) continue;
            buffer.append(c);
        }
        if (prefix == null) {
            throw new IllegalArgumentException(Errors.format((short)52, this.getValueType(), pattern));
        }
        if (regex != null) {
            this.parsePattern = Pattern.compile(regex);
            this.isParsePatternDefined = true;
        } else {
            this.parsePattern = null;
            this.isParsePatternDefined = false;
        }
        this.omitTrailingNulls = trim;
        this.beforeFill = prefix;
        this.columnSeparator = buffer.toString();
        this.fillCharacter = pattern.charAt(separatorIndex);
    }

    protected Matcher getColumnSeparatorMatcher(CharSequence text) {
        if (this.parsePattern == null) {
            StringBuilder pattern = new StringBuilder(this.beforeFill).append(this.fillCharacter);
            String tmp = pattern.toString();
            pattern.setLength(0);
            pattern.append(Pattern.quote(tmp)).append('*');
            tmp = this.columnSeparator;
            if (tmp.length() != 0) {
                pattern.append(Pattern.quote(tmp));
            }
            this.parsePattern = Pattern.compile(pattern.toString());
        }
        return this.parsePattern.matcher(text);
    }

    @Override
    public TabularFormat<T> clone() {
        return (TabularFormat)super.clone();
    }
}

