/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Date;
import org.apache.sis.filter.BinaryFunction;
import org.apache.sis.filter.ComparisonFilter;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.filter.Optimization;
import org.apache.sis.pending.geoapi.filter.TemporalOperatorName;
import org.apache.sis.pending.geoapi.temporal.Instant;
import org.apache.sis.pending.geoapi.temporal.Period;

abstract class TemporalFilter<T>
extends BinaryFunction<T, Object, Object>
implements Filter<T>,
Optimization.OnFilter<T> {
    private static final long serialVersionUID = 5392780837658687513L;

    TemporalFilter(Expression<T, ?> expression1, Expression<T, ?> expression2) {
        super(expression1, expression2);
    }

    private static java.time.Instant toInstant(Instant instant) {
        Date t;
        if (instant != null && (t = instant.getDate()) != null) {
            return t.toInstant();
        }
        return null;
    }

    private static boolean isBefore(Instant self, java.time.Instant other) {
        java.time.Instant t = TemporalFilter.toInstant(self);
        return t != null && t.isBefore(other);
    }

    private static boolean isAfter(Instant self, java.time.Instant other) {
        java.time.Instant t = TemporalFilter.toInstant(self);
        return t != null && t.isAfter(other);
    }

    private static boolean isEqual(Instant self, java.time.Instant other) {
        java.time.Instant t = TemporalFilter.toInstant(self);
        return t != null && t.equals(other);
    }

    private static boolean isBefore(Instant self, Instant other) {
        java.time.Instant o;
        java.time.Instant t = TemporalFilter.toInstant(self);
        return t != null && (o = TemporalFilter.toInstant(other)) != null && t.isBefore(o);
    }

    private static boolean isAfter(Instant self, Instant other) {
        java.time.Instant o;
        java.time.Instant t = TemporalFilter.toInstant(self);
        return t != null && (o = TemporalFilter.toInstant(other)) != null && t.isAfter(o);
    }

    private static boolean isEqual(Instant self, Instant other) {
        java.time.Instant t = TemporalFilter.toInstant(self);
        return t != null && t.equals(TemporalFilter.toInstant(other));
    }

    @Override
    public final boolean test(T candidate) {
        Object left = this.expression1.apply(candidate);
        if (left instanceof Period) {
            Object right = this.expression2.apply(candidate);
            if (right instanceof Period) {
                return this.evaluate((Period)left, (Period)right);
            }
            java.time.Instant t = ComparisonFilter.toInstant(right);
            if (t != null) {
                return this.evaluate((Period)left, t);
            }
        } else {
            java.time.Instant t2;
            java.time.Instant t = ComparisonFilter.toInstant(left);
            if (t != null && (t2 = ComparisonFilter.toInstant(this.expression2.apply(candidate))) != null) {
                return this.evaluate(t, t2);
            }
        }
        return false;
    }

    protected boolean evaluate(java.time.Instant self, java.time.Instant other) {
        return false;
    }

    protected boolean evaluate(Period self, java.time.Instant other) {
        return false;
    }

    protected boolean evaluate(Period self, Period other) {
        return false;
    }

    static final class AnyInteracts<T>
    extends TemporalFilter<T> {
        private static final long serialVersionUID = 5972351564286442392L;

        AnyInteracts(Expression<T, ?> expression1, Expression<T, ?> expression2) {
            super(expression1, expression2);
        }

        @Override
        public Filter<T> recreate(Expression<T, ?>[] effective) {
            return new AnyInteracts<T>(effective[0], effective[1]);
        }

        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.ANY_INTERACTS;
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            java.time.Instant otherBegin;
            java.time.Instant selfEnd;
            java.time.Instant otherEnd;
            java.time.Instant selfBegin = TemporalFilter.toInstant(self.getBeginning());
            return selfBegin != null && (otherEnd = TemporalFilter.toInstant(other.getEnding())) != null && selfBegin.isBefore(otherEnd) && (selfEnd = TemporalFilter.toInstant(self.getEnding())) != null && (otherBegin = TemporalFilter.toInstant(other.getBeginning())) != null && selfEnd.isAfter(otherBegin);
        }
    }

    static final class OverlappedBy<T>
    extends TemporalFilter<T> {
        private static final long serialVersionUID = 2228673820507226463L;

        OverlappedBy(Expression<T, ?> expression1, Expression<T, ?> expression2) {
            super(expression1, expression2);
        }

        @Override
        public Filter<T> recreate(Expression<T, ?>[] effective) {
            return new OverlappedBy<T>(effective[0], effective[1]);
        }

        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.OVERLAPPED_BY;
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            java.time.Instant otherEnd;
            java.time.Instant selfBegin = TemporalFilter.toInstant(self.getBeginning());
            return selfBegin != null && (otherEnd = TemporalFilter.toInstant(other.getEnding())) != null && selfBegin.isBefore(otherEnd) && TemporalFilter.isBefore(other.getBeginning(), selfBegin) && TemporalFilter.isAfter(self.getEnding(), otherEnd);
        }
    }

    static final class Overlaps<T>
    extends TemporalFilter<T> {
        private static final long serialVersionUID = 1517443045593389773L;

        Overlaps(Expression<T, ?> expression1, Expression<T, ?> expression2) {
            super(expression1, expression2);
        }

        @Override
        public Filter<T> recreate(Expression<T, ?>[] effective) {
            return new Overlaps<T>(effective[0], effective[1]);
        }

        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.OVERLAPS;
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            java.time.Instant otherBegin;
            java.time.Instant selfEnd = TemporalFilter.toInstant(self.getEnding());
            return selfEnd != null && (otherBegin = TemporalFilter.toInstant(other.getBeginning())) != null && selfEnd.isAfter(otherBegin) && TemporalFilter.isBefore(self.getBeginning(), otherBegin) && TemporalFilter.isAfter(other.getEnding(), selfEnd);
        }
    }

    static final class Contains<T>
    extends TemporalFilter<T> {
        private static final long serialVersionUID = 9107531246948034411L;

        Contains(Expression<T, ?> expression1, Expression<T, ?> expression2) {
            super(expression1, expression2);
        }

        @Override
        public Filter<T> recreate(Expression<T, ?>[] effective) {
            return new Contains<T>(effective[0], effective[1]);
        }

        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.CONTAINS;
        }

        @Override
        protected char symbol() {
            return '\u228b';
        }

        @Override
        public boolean evaluate(Period self, java.time.Instant other) {
            return TemporalFilter.isBefore(self.getBeginning(), other) && TemporalFilter.isAfter(self.getEnding(), other);
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return TemporalFilter.isBefore(self.getBeginning(), other.getBeginning()) && TemporalFilter.isAfter(self.getEnding(), other.getEnding());
        }
    }

    static final class During<T>
    extends TemporalFilter<T> {
        private static final long serialVersionUID = -4674319635076886196L;

        During(Expression<T, ?> expression1, Expression<T, ?> expression2) {
            super(expression1, expression2);
        }

        @Override
        public Filter<T> recreate(Expression<T, ?>[] effective) {
            return new During<T>(effective[0], effective[1]);
        }

        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.DURING;
        }

        @Override
        protected char symbol() {
            return '\u228a';
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return TemporalFilter.isAfter(self.getBeginning(), other.getBeginning()) && TemporalFilter.isBefore(self.getEnding(), other.getEnding());
        }
    }

    static final class MetBy<T>
    extends TemporalFilter<T> {
        private static final long serialVersionUID = 5358059498707330482L;

        MetBy(Expression<T, ?> expression1, Expression<T, ?> expression2) {
            super(expression1, expression2);
        }

        @Override
        public Filter<T> recreate(Expression<T, ?>[] effective) {
            return new MetBy<T>(effective[0], effective[1]);
        }

        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.MET_BY;
        }

        @Override
        public boolean evaluate(java.time.Instant self, java.time.Instant other) {
            return self.equals(other);
        }

        @Override
        public boolean evaluate(Period self, java.time.Instant other) {
            return TemporalFilter.isEqual(self.getBeginning(), other);
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return TemporalFilter.isEqual(self.getBeginning(), other.getEnding());
        }
    }

    static final class Meets<T>
    extends TemporalFilter<T> {
        private static final long serialVersionUID = -3534843269384858443L;

        Meets(Expression<T, ?> expression1, Expression<T, ?> expression2) {
            super(expression1, expression2);
        }

        @Override
        public Filter<T> recreate(Expression<T, ?>[] effective) {
            return new Meets<T>(effective[0], effective[1]);
        }

        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.MEETS;
        }

        @Override
        public boolean evaluate(java.time.Instant self, java.time.Instant other) {
            return self.equals(other);
        }

        @Override
        public boolean evaluate(Period self, java.time.Instant other) {
            return TemporalFilter.isEqual(self.getEnding(), other);
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return TemporalFilter.isEqual(self.getEnding(), other.getBeginning());
        }
    }

    static final class EndedBy<T>
    extends TemporalFilter<T> {
        private static final long serialVersionUID = 8586566103462153666L;

        EndedBy(Expression<T, ?> expression1, Expression<T, ?> expression2) {
            super(expression1, expression2);
        }

        @Override
        public Filter<T> recreate(Expression<T, ?>[] effective) {
            return new EndedBy<T>(effective[0], effective[1]);
        }

        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.ENDED_BY;
        }

        @Override
        public boolean evaluate(Period self, java.time.Instant other) {
            return TemporalFilter.isEqual(self.getEnding(), other);
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return TemporalFilter.isEqual(self.getEnding(), other.getEnding()) && TemporalFilter.isBefore(self.getBeginning(), other.getBeginning());
        }
    }

    static final class BegunBy<T>
    extends TemporalFilter<T> {
        private static final long serialVersionUID = -7212413827394364384L;

        BegunBy(Expression<T, ?> expression1, Expression<T, ?> expression2) {
            super(expression1, expression2);
        }

        @Override
        public Filter<T> recreate(Expression<T, ?>[] effective) {
            return new BegunBy<T>(effective[0], effective[1]);
        }

        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.BEGUN_BY;
        }

        @Override
        public boolean evaluate(Period self, java.time.Instant other) {
            return TemporalFilter.isEqual(self.getBeginning(), other);
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return TemporalFilter.isEqual(self.getBeginning(), other.getBeginning()) && TemporalFilter.isAfter(self.getEnding(), other.getEnding());
        }
    }

    static final class Ends<T>
    extends TemporalFilter<T> {
        private static final long serialVersionUID = -5508229966320563437L;

        Ends(Expression<T, ?> expression1, Expression<T, ?> expression2) {
            super(expression1, expression2);
        }

        @Override
        public Filter<T> recreate(Expression<T, ?>[] effective) {
            return new Ends<T>(effective[0], effective[1]);
        }

        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.ENDS;
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return TemporalFilter.isEqual(self.getEnding(), other.getEnding()) && TemporalFilter.isAfter(self.getBeginning(), other.getBeginning());
        }
    }

    static final class Begins<T>
    extends TemporalFilter<T> {
        private static final long serialVersionUID = -7880699329127762233L;

        Begins(Expression<T, ?> expression1, Expression<T, ?> expression2) {
            super(expression1, expression2);
        }

        @Override
        public Filter<T> recreate(Expression<T, ?>[] effective) {
            return new Begins<T>(effective[0], effective[1]);
        }

        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.BEGINS;
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return TemporalFilter.isEqual(self.getBeginning(), other.getBeginning()) && TemporalFilter.isBefore(self.getEnding(), other.getEnding());
        }
    }

    static final class After<T>
    extends TemporalFilter<T> {
        private static final long serialVersionUID = 5410476260417497682L;

        After(Expression<T, ?> expression1, Expression<T, ?> expression2) {
            super(expression1, expression2);
        }

        @Override
        public Filter<T> recreate(Expression<T, ?>[] effective) {
            return new After<T>(effective[0], effective[1]);
        }

        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.AFTER;
        }

        @Override
        protected char symbol() {
            return '>';
        }

        @Override
        protected boolean evaluate(java.time.Instant self, java.time.Instant other) {
            return self.isAfter(other);
        }

        @Override
        public boolean evaluate(Period self, java.time.Instant other) {
            return TemporalFilter.isAfter(self.getBeginning(), other);
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return TemporalFilter.isAfter(self.getBeginning(), other.getEnding());
        }
    }

    static final class Before<T>
    extends TemporalFilter<T> {
        private static final long serialVersionUID = -3422629447456003982L;

        Before(Expression<T, ?> expression1, Expression<T, ?> expression2) {
            super(expression1, expression2);
        }

        @Override
        public Filter<T> recreate(Expression<T, ?>[] effective) {
            return new Before<T>(effective[0], effective[1]);
        }

        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.BEFORE;
        }

        @Override
        protected char symbol() {
            return '<';
        }

        @Override
        protected boolean evaluate(java.time.Instant self, java.time.Instant other) {
            return self.isBefore(other);
        }

        @Override
        public boolean evaluate(Period self, java.time.Instant other) {
            return TemporalFilter.isBefore(self.getEnding(), other);
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return TemporalFilter.isBefore(self.getEnding(), other.getBeginning());
        }
    }

    static final class Equals<T>
    extends TemporalFilter<T> {
        private static final long serialVersionUID = -6060822291802339424L;

        Equals(Expression<T, ?> expression1, Expression<T, ?> expression2) {
            super(expression1, expression2);
        }

        @Override
        public Filter<T> recreate(Expression<T, ?>[] effective) {
            return new Equals<T>(effective[0], effective[1]);
        }

        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.EQUALS;
        }

        @Override
        protected char symbol() {
            return '=';
        }

        @Override
        protected boolean evaluate(java.time.Instant self, java.time.Instant other) {
            return self.equals(other);
        }

        @Override
        public boolean evaluate(Period self, java.time.Instant other) {
            return TemporalFilter.isEqual(self.getBeginning(), other) && TemporalFilter.isEqual(self.getEnding(), other);
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return TemporalFilter.isEqual(self.getBeginning(), other.getBeginning()) && TemporalFilter.isEqual(self.getEnding(), other.getEnding());
        }
    }
}

