/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import jakarta.ws.rs.ServiceUnavailableException;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.CompletionCallback;
import jakarta.ws.rs.container.ConnectionCallback;
import jakarta.ws.rs.container.TimeoutHandler;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.continuations.ContinuationCallback;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.message.Message;

public class AsyncResponseImpl
implements AsyncResponse,
ContinuationCallback {
    private Continuation cont;
    private Message inMessage;
    private TimeoutHandler timeoutHandler;
    private volatile boolean initialSuspend;
    private volatile boolean cancelled;
    private volatile boolean done;
    private volatile boolean resumedByApplication;
    private volatile Long pendingTimeout;
    private List<CompletionCallback> completionCallbacks = new LinkedList<CompletionCallback>();
    private List<ConnectionCallback> connectionCallbacks = new LinkedList<ConnectionCallback>();
    private Throwable unmappedThrowable;

    public AsyncResponseImpl(Message inMessage) {
        inMessage.put(AsyncResponse.class, this);
        inMessage.getExchange().put(ContinuationCallback.class, this);
        this.inMessage = inMessage;
        this.initContinuation();
    }

    @Override
    public boolean resume(Object response) {
        return this.doResume(response);
    }

    @Override
    public boolean resume(Throwable response) {
        return this.doResume(response);
    }

    private boolean isCancelledOrNotSuspended() {
        return this.isCancelled() || !this.isSuspended();
    }

    private boolean doResume(Object response) {
        if (this.isCancelledOrNotSuspended()) {
            return false;
        }
        return this.doResumeFinal(response);
    }

    private synchronized boolean doResumeFinal(Object response) {
        this.inMessage.getExchange().put(AsyncResponse.class, this);
        this.cont.setObject(response);
        this.resumedByApplication = true;
        if (!this.initialSuspend) {
            this.cont.resume();
        } else {
            this.initialSuspend = false;
        }
        return true;
    }

    @Override
    public boolean cancel() {
        return this.doCancel(null);
    }

    @Override
    public boolean cancel(int retryAfter) {
        return this.doCancel(Integer.toString(retryAfter));
    }

    @Override
    public boolean cancel(Date retryAfter) {
        return this.doCancel(HttpUtils.getHttpDateFormat().format(retryAfter));
    }

    private boolean doCancel(String retryAfterHeader) {
        if (this.cancelled) {
            return true;
        }
        if (!this.isSuspended()) {
            return false;
        }
        this.cancelled = true;
        Response.ResponseBuilder rb = Response.status(503);
        if (retryAfterHeader != null) {
            rb.header("Retry-After", retryAfterHeader);
        }
        this.doResumeFinal(rb.build());
        return this.cancelled;
    }

    @Override
    public boolean isSuspended() {
        if (this.cancelled || this.resumedByApplication) {
            return false;
        }
        return this.initialSuspend || this.cont.isPending();
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public synchronized boolean setTimeout(long time, TimeUnit unit) throws IllegalStateException {
        if (this.isCancelledOrNotSuspended()) {
            return false;
        }
        this.setAsyncResponseOnExchange();
        long timeout = TimeUnit.MILLISECONDS.convert(time, unit);
        this.initialSuspend = false;
        if (!this.cont.isPending()) {
            this.cont.suspend(timeout);
        } else {
            this.pendingTimeout = timeout;
            this.cont.resume();
        }
        return true;
    }

    private void setAsyncResponseOnExchange() {
        this.inMessage.getExchange().put(AsyncResponse.class, this);
    }

    @Override
    public void setTimeoutHandler(TimeoutHandler handler) {
        this.timeoutHandler = handler;
    }

    @Override
    public Collection<Class<?>> register(Class<?> callback) throws NullPointerException {
        return this.register(callback, new Class[0]).get(callback);
    }

    @Override
    public Map<Class<?>, Collection<Class<?>>> register(Class<?> callback, Class<?> ... callbacks) throws NullPointerException {
        try {
            Object[] extraCallbacks = new Object[callbacks.length];
            for (int i = 0; i < callbacks.length; ++i) {
                extraCallbacks[i] = callbacks[i].getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return this.register(callback.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), extraCallbacks);
        }
        catch (NullPointerException e) {
            throw e;
        }
        catch (Throwable t) {
            return Collections.emptyMap();
        }
    }

    @Override
    public Collection<Class<?>> register(Object callback) throws NullPointerException {
        return this.register(callback, new Object[0]).get(callback.getClass());
    }

    @Override
    public Map<Class<?>, Collection<Class<?>>> register(Object callback, Object ... callbacks) throws NullPointerException {
        HashMap map = new HashMap();
        Object[] allCallbacks = new Object[1 + callbacks.length];
        allCallbacks[0] = callback;
        System.arraycopy(callbacks, 0, allCallbacks, 1, callbacks.length);
        for (int i = 0; i < allCallbacks.length; ++i) {
            if (allCallbacks[i] == null) {
                throw new NullPointerException();
            }
            Class<?> callbackCls = allCallbacks[i].getClass();
            HashSet<Class> knownCallbacks = (HashSet<Class>)map.get(callbackCls);
            if (knownCallbacks == null) {
                knownCallbacks = new HashSet<Class>();
                map.put(callbackCls, knownCallbacks);
            }
            if (allCallbacks[i] instanceof CompletionCallback) {
                knownCallbacks.add(CompletionCallback.class);
                this.completionCallbacks.add((CompletionCallback)allCallbacks[i]);
                continue;
            }
            if (!(allCallbacks[i] instanceof ConnectionCallback)) continue;
            knownCallbacks.add(ConnectionCallback.class);
            this.connectionCallbacks.add((ConnectionCallback)allCallbacks[i]);
        }
        return map;
    }

    @Override
    public void onComplete() {
        this.done = true;
        this.updateCompletionCallbacks(this.unmappedThrowable);
    }

    @Override
    public void onError(Throwable error) {
        this.updateCompletionCallbacks(error);
    }

    private void updateCompletionCallbacks(Throwable error) {
        Throwable actualError = error instanceof Fault ? ((Fault)error).getCause() : error;
        for (CompletionCallback completionCallback : this.completionCallbacks) {
            completionCallback.onComplete(actualError);
        }
    }

    @Override
    public void onDisconnect() {
        for (ConnectionCallback connectionCallback : this.connectionCallbacks) {
            connectionCallback.onDisconnect(this);
        }
    }

    public synchronized boolean suspendContinuationIfNeeded() {
        if (!(this.resumedByApplication || this.isDone() || this.cont.isPending() || this.cont.isResumed())) {
            this.cont.suspend(0L);
            this.initialSuspend = false;
            return true;
        }
        return false;
    }

    public Object getResponseObject() {
        Object obj = this.cont.getObject();
        if (!(obj instanceof Response) && !(obj instanceof Throwable)) {
            obj = obj == null ? Response.noContent().build() : Response.ok().entity(obj).build();
        }
        return obj;
    }

    public boolean isResumedByApplication() {
        return this.resumedByApplication;
    }

    public synchronized void handleTimeout() {
        if (!this.resumedByApplication) {
            if (this.pendingTimeout != null) {
                this.setAsyncResponseOnExchange();
                this.cont.suspend(this.pendingTimeout);
                this.pendingTimeout = null;
            } else if (this.timeoutHandler != null) {
                this.timeoutHandler.handleTimeout(this);
            } else {
                this.cont.setObject(new ServiceUnavailableException());
            }
        }
    }

    private void initContinuation() {
        ContinuationProvider provider = (ContinuationProvider)this.inMessage.get(ContinuationProvider.class.getName());
        if (provider == null) {
            throw new IllegalArgumentException("Continuation not supported. Please ensure that all servlets and servlet filters support async operations");
        }
        this.cont = provider.getContinuation();
        this.initialSuspend = true;
    }

    public void prepareContinuation() {
        this.initContinuation();
    }

    public void setUnmappedThrowable(Throwable t) {
        this.unmappedThrowable = t;
    }

    public void reset() {
        this.cont.reset();
    }
}

