/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.fs;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.io.IOUtils;
import org.apache.tika.batch.BatchProcess;
import org.apache.tika.batch.ParallelFileProcessingResult;
import org.apache.tika.batch.builders.BatchProcessBuilder;
import org.apache.tika.batch.builders.CommandLineParserBuilder;
import org.apache.tika.io.TikaInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class FSBatchProcessCLI {
    private static final Logger LOG = LoggerFactory.getLogger(FSBatchProcessCLI.class);
    public static String FINISHED_STRING = "Main thread in TikaFSBatchCLI has finished processing.";
    private final Options options;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSBatchProcessCLI(String[] args) throws IOException {
        TikaInputStream configIs = null;
        try {
            configIs = this.getConfigInputStream(args, true);
            CommandLineParserBuilder builder = new CommandLineParserBuilder();
            this.options = builder.build(configIs);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(configIs);
            throw throwable;
        }
        IOUtils.closeQuietly(configIs);
    }

    public static void main(String[] args) throws Exception {
        try {
            FSBatchProcessCLI cli = new FSBatchProcessCLI(args);
            cli.execute(args);
        }
        catch (Throwable t) {
            t.printStackTrace();
            LOG.error(MarkerFactory.getMarker("FATAL"), "Fatal exception from FSBatchProcessCLI: {}", (Object)t.getMessage(), (Object)t);
            System.exit(254);
        }
    }

    public void usage() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("tika filesystem batch", this.options);
    }

    private TikaInputStream getConfigInputStream(String[] args, boolean logDefault) throws IOException {
        TikaInputStream is = null;
        Path batchConfigFile = this.getConfigFile(args);
        if (batchConfigFile != null) {
            is = TikaInputStream.get(batchConfigFile);
        } else {
            URL config;
            if (logDefault) {
                LOG.info("No config file set via -bc, relying on tika-app-batch-config.xml or default-tika-batch-config.xml");
            }
            is = (config = FSBatchProcessCLI.class.getResource("/tika-app-batch-config.xml")) != null ? TikaInputStream.get(FSBatchProcessCLI.class.getResourceAsStream("/tika-app-batch-config.xml")) : TikaInputStream.get(FSBatchProcessCLI.class.getResourceAsStream("default-tika-batch-config.xml"));
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String[] args) throws Exception {
        DefaultParser cliParser = new DefaultParser();
        CommandLine line = cliParser.parse(this.options, args);
        if (line.hasOption("help")) {
            this.usage();
            System.exit(254);
        }
        HashMap<String, String> mapArgs = new HashMap<String, String>();
        for (Option option : line.getOptions()) {
            String v = option.getValue();
            if (v == null || v.equals("")) {
                v = "true";
            }
            mapArgs.put(option.getOpt(), v);
        }
        BatchProcessBuilder b = new BatchProcessBuilder();
        TikaInputStream is = null;
        BatchProcess process = null;
        try {
            is = this.getConfigInputStream(args, false);
            process = b.build(is, mapArgs);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly(is);
        Thread mainThread = Thread.currentThread();
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future<ParallelFileProcessingResult> futureResult = executor.submit(process);
        ParallelFileProcessingResult result = futureResult.get();
        System.out.println(FINISHED_STRING);
        System.out.println("\n");
        System.out.println(result.toString());
        System.exit(result.getExitStatus());
    }

    private Path getConfigFile(String[] args) {
        Path configFile = null;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-bc") && !args[i].equals("-batch-config") || i >= args.length - 1) continue;
            configFile = Paths.get(args[i + 1], new String[0]);
        }
        return configFile;
    }
}

