/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiTermsEnum;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.ReaderSlice;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.TermsEnumIndex;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CompiledAutomaton;

public final class MultiTerms
extends Terms {
    private final Terms[] subs;
    private final ReaderSlice[] subSlices;
    private final boolean hasFreqs;
    private final boolean hasOffsets;
    private final boolean hasPositions;
    private final boolean hasPayloads;

    public MultiTerms(Terms[] subs, ReaderSlice[] subSlices) throws IOException {
        this.subs = subs;
        this.subSlices = subSlices;
        assert (subs.length > 0) : "inefficient: don't use MultiTerms over one sub";
        boolean _hasFreqs = true;
        boolean _hasOffsets = true;
        boolean _hasPositions = true;
        boolean _hasPayloads = false;
        for (int i = 0; i < subs.length; ++i) {
            _hasFreqs &= subs[i].hasFreqs();
            _hasOffsets &= subs[i].hasOffsets();
            _hasPositions &= subs[i].hasPositions();
            _hasPayloads |= subs[i].hasPayloads();
        }
        this.hasFreqs = _hasFreqs;
        this.hasOffsets = _hasOffsets;
        this.hasPositions = _hasPositions;
        this.hasPayloads = this.hasPositions && _hasPayloads;
    }

    public static Terms getTerms(IndexReader r, String field) throws IOException {
        List<LeafReaderContext> leaves = r.leaves();
        if (leaves.size() == 1) {
            return leaves.get(0).reader().terms(field);
        }
        ArrayList<Terms> termsPerLeaf = new ArrayList<Terms>(leaves.size());
        ArrayList<ReaderSlice> slicePerLeaf = new ArrayList<ReaderSlice>(leaves.size());
        for (int leafIdx = 0; leafIdx < leaves.size(); ++leafIdx) {
            LeafReaderContext ctx = leaves.get(leafIdx);
            Terms subTerms = ctx.reader().terms(field);
            if (subTerms == null) continue;
            termsPerLeaf.add(subTerms);
            slicePerLeaf.add(new ReaderSlice(ctx.docBase, r.maxDoc(), leafIdx));
        }
        if (termsPerLeaf.size() == 0) {
            return null;
        }
        return new MultiTerms(termsPerLeaf.toArray(EMPTY_ARRAY), slicePerLeaf.toArray(ReaderSlice.EMPTY_ARRAY));
    }

    public static PostingsEnum getTermPostingsEnum(IndexReader r, String field, BytesRef term) throws IOException {
        return MultiTerms.getTermPostingsEnum(r, field, term, 120);
    }

    public static PostingsEnum getTermPostingsEnum(IndexReader r, String field, BytesRef term, int flags) throws IOException {
        TermsEnum termsEnum;
        assert (field != null);
        assert (term != null);
        Terms terms = MultiTerms.getTerms(r, field);
        if (terms != null && (termsEnum = terms.iterator()).seekExact(term)) {
            return termsEnum.postings(null, flags);
        }
        return null;
    }

    public Terms[] getSubTerms() {
        return this.subs;
    }

    public ReaderSlice[] getSubSlices() {
        return this.subSlices;
    }

    @Override
    public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
        ArrayList<TermsEnumIndex> termsEnums = new ArrayList<TermsEnumIndex>();
        for (int i = 0; i < this.subs.length; ++i) {
            TermsEnum termsEnum = this.subs[i].intersect(compiled, startTerm);
            if (termsEnum == null) continue;
            termsEnums.add(new TermsEnumIndex(termsEnum, i));
        }
        if (termsEnums.size() > 0) {
            return new MultiTermsEnum(this.subSlices).reset(termsEnums.toArray(TermsEnumIndex.EMPTY_ARRAY));
        }
        return TermsEnum.EMPTY;
    }

    @Override
    public BytesRef getMin() throws IOException {
        BytesRef minTerm = null;
        for (Terms terms : this.subs) {
            BytesRef term = terms.getMin();
            if (minTerm != null && term.compareTo(minTerm) >= 0) continue;
            minTerm = term;
        }
        return minTerm;
    }

    @Override
    public BytesRef getMax() throws IOException {
        BytesRef maxTerm = null;
        for (Terms terms : this.subs) {
            BytesRef term = terms.getMax();
            if (maxTerm != null && term.compareTo(maxTerm) <= 0) continue;
            maxTerm = term;
        }
        return maxTerm;
    }

    @Override
    public TermsEnum iterator() throws IOException {
        ArrayList<TermsEnumIndex> termsEnums = new ArrayList<TermsEnumIndex>();
        for (int i = 0; i < this.subs.length; ++i) {
            TermsEnum termsEnum = this.subs[i].iterator();
            if (termsEnum == null) continue;
            termsEnums.add(new TermsEnumIndex(termsEnum, i));
        }
        if (termsEnums.size() > 0) {
            return new MultiTermsEnum(this.subSlices).reset(termsEnums.toArray(TermsEnumIndex.EMPTY_ARRAY));
        }
        return TermsEnum.EMPTY;
    }

    @Override
    public long size() {
        return -1L;
    }

    @Override
    public long getSumTotalTermFreq() throws IOException {
        long sum = 0L;
        for (Terms terms : this.subs) {
            long v = terms.getSumTotalTermFreq();
            assert (v != -1L);
            sum += v;
        }
        return sum;
    }

    @Override
    public long getSumDocFreq() throws IOException {
        long sum = 0L;
        for (Terms terms : this.subs) {
            long v = terms.getSumDocFreq();
            assert (v != -1L);
            sum += v;
        }
        return sum;
    }

    @Override
    public int getDocCount() throws IOException {
        int sum = 0;
        for (Terms terms : this.subs) {
            int v = terms.getDocCount();
            assert (v != -1);
            sum += v;
        }
        return sum;
    }

    @Override
    public boolean hasFreqs() {
        return this.hasFreqs;
    }

    @Override
    public boolean hasOffsets() {
        return this.hasOffsets;
    }

    @Override
    public boolean hasPositions() {
        return this.hasPositions;
    }

    @Override
    public boolean hasPayloads() {
        return this.hasPayloads;
    }
}

