/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.logging;

import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Vocabulary;

public final class PerformanceLevel
extends Level {
    private static final long serialVersionUID = -6547125008284983701L;
    public static final PerformanceLevel SLOWNESS = new PerformanceLevel("SLOWNESS", 267, 620, 1000000000L);
    public static final PerformanceLevel SLOWER = new PerformanceLevel("SLOWER", 268, 630, 10000000000L);
    private volatile long minDuration;
    private final short localization;

    private PerformanceLevel(String name, short key, int value, long duration) {
        super(name, value);
        this.localization = key;
        this.minDuration = duration;
    }

    public static Level forDuration(long duration, TimeUnit unit) {
        if ((duration = unit.toNanos(duration)) < PerformanceLevel.SLOWNESS.minDuration) {
            return Level.FINE;
        }
        return duration >= PerformanceLevel.SLOWER.minDuration ? SLOWER : SLOWNESS;
    }

    public long getMinDuration(TimeUnit unit) {
        return unit.convert(this.minDuration, TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinDuration(long duration, TimeUnit unit) throws IllegalArgumentException {
        ArgumentChecks.ensureStrictlyPositive("duration", duration);
        duration = unit.toNanos(duration);
        int value = this.intValue();
        Class<PerformanceLevel> clazz = PerformanceLevel.class;
        synchronized (PerformanceLevel.class) {
            if (value >= SLOWER.intValue() && duration < PerformanceLevel.SLOWNESS.minDuration) {
                PerformanceLevel.SLOWNESS.minDuration = duration;
            }
            this.minDuration = duration;
            if (value <= SLOWNESS.intValue() && duration > PerformanceLevel.SLOWER.minDuration) {
                PerformanceLevel.SLOWER.minDuration = duration;
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String getLocalizedName() {
        return Vocabulary.format(this.localization);
    }
}

