/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf.base;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.WKTFormat;
import org.apache.sis.io.wkt.Warnings;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.datum.BursaWolfParameters;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.referencing.operation.matrix.Matrix3;
import org.apache.sis.referencing.operation.provider.PseudoPlateCarree;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.referencing.util.AxisDirections;
import org.apache.sis.referencing.util.j2d.AffineTransform2D;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.netcdf.base.CRSMerger;
import org.apache.sis.storage.netcdf.base.Decoder;
import org.apache.sis.storage.netcdf.base.Dimension;
import org.apache.sis.storage.netcdf.base.NamedElement;
import org.apache.sis.storage.netcdf.base.Node;
import org.apache.sis.storage.netcdf.base.Variable;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class GridMapping {
    final CoordinateReferenceSystem crs;
    private final MathTransform gridToCRS;
    private final boolean isWKT;

    private GridMapping(CoordinateReferenceSystem crs, MathTransform gridToCRS, boolean isWKT) {
        this.crs = crs;
        this.gridToCRS = gridToCRS;
        this.isWKT = isWKT;
    }

    static GridMapping forVariable(Variable variable) {
        Map<Object, GridMapping> gridMapping = variable.decoder.gridMapping;
        for (String name : variable.decoder.convention().nameOfMappingNode(variable)) {
            GridMapping gm = gridMapping.get(name);
            if (gm != null) {
                return gm;
            }
            if (gridMapping.containsKey(name)) continue;
            Node mapping = variable.decoder.findNode(name);
            if (mapping != null) {
                gm = GridMapping.parse(mapping);
            }
            gridMapping.put(name, gm);
            if (gm == null) continue;
            return gm;
        }
        GridMapping gm = gridMapping.get(variable);
        if (gm == null) {
            String name;
            name = variable.getName();
            gm = gridMapping.get(name);
            if (gm == null && !gridMapping.containsKey(name)) {
                gm = GridMapping.parse(variable);
                gridMapping.put(name, gm);
            }
            if (gm == null) {
                gm = GridMapping.parseNonStandard(variable);
            }
            if (gm != null) {
                gridMapping.put(variable, gm);
            }
        }
        return gm;
    }

    private static GridMapping parse(Node mapping) {
        GridMapping gm = GridMapping.parseProjectionParameters(mapping);
        if (gm == null) {
            gm = GridMapping.parseGeoTransform(mapping);
        }
        return gm;
    }

    private static GridMapping parseProjectionParameters(Node node) {
        Map<String, Object> definition = node.decoder.convention().projection(node);
        if (definition != null) {
            try {
                SingleCRS crs;
                MathTransform baseToCRS;
                Object greenwichLongitude = definition.remove("longitude_of_prime_meridian");
                DefaultCoordinateOperationFactory opFactory = node.decoder.getCoordinateOperationFactory();
                OperationMethod method = opFactory.getOperationMethod((String)definition.remove("grid_mapping_name"));
                ParameterValueGroup parameters = method.getParameters().createValue();
                Iterator<Map.Entry<String, Object>> it = definition.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, Object> entry = it.next();
                    String name = entry.getKey();
                    Object value = entry.getValue();
                    try {
                        ParameterValue<?> parameter;
                        if (value instanceof Number || value instanceof double[] || value instanceof float[]) {
                            it.remove();
                            parameters.parameter(name).setValue(value);
                            continue;
                        }
                        if (!(value instanceof String) || name.endsWith("_name")) continue;
                        try {
                            parameter = parameters.parameter(name);
                        }
                        catch (IllegalArgumentException e) {
                            continue;
                        }
                        Class type = parameter.getDescriptor().getValueClass();
                        if (Numbers.isNumber(type)) {
                            it.remove();
                            parameter.setValue(Double.parseDouble((String)value));
                            continue;
                        }
                        if (!Numbers.isNumber(type.getComponentType())) continue;
                        it.remove();
                        parameter.setValue(GridMapping.parseDoubles((String)value), null);
                    }
                    catch (IllegalArgumentException ex) {
                        GridMapping.warning(node, ex, (short)20, node.decoder.getFilename(), node.getName(), name, value, ex.getLocalizedMessage());
                    }
                }
                GeographicCRS baseCRS = GridMapping.createBaseCRS(node.decoder, parameters, definition, greenwichLongitude);
                if (method instanceof PseudoPlateCarree) {
                    baseToCRS = MathTransforms.linear(new Matrix3(0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0));
                    crs = baseCRS;
                } else {
                    Map<String, Object> properties = GridMapping.properties(definition, "conversion_name", node.getName());
                    Conversion conversion = opFactory.createDefiningConversion(properties, method, parameters);
                    CartesianCS cs = node.decoder.getStandardProjectedCS();
                    properties = GridMapping.properties(definition, "projected_crs_name", conversion);
                    ProjectedCRS p = node.decoder.getCRSFactory().createProjectedCRS(properties, baseCRS, conversion, cs);
                    baseToCRS = p.getConversionFromBase().getMathTransform();
                    crs = p;
                }
                if (!definition.isEmpty()) {
                    GridMapping.warning(node, null, (short)25, node.decoder.getFilename(), String.join((CharSequence)", ", definition.keySet()));
                }
                MathTransform gridToCRS = node.decoder.convention().gridToCRS(node, baseToCRS);
                return new GridMapping(crs, gridToCRS, false);
            }
            catch (ClassCastException | IllegalArgumentException | TransformException | FactoryException e) {
                GridMapping.canNotCreate(node, (short)11, e);
            }
        }
        return null;
    }

    private static GeographicCRS createBaseCRS(Decoder decoder, ParameterValueGroup parameters, Map<String, Object> definition, Object greenwichLongitude) throws FactoryException {
        GeodeticDatum datum;
        Ellipsoid ellipsoid;
        PrimeMeridian meridian;
        DatumFactory datumFactory = decoder.getDatumFactory();
        CommonCRS defaultDefinitions = decoder.convention().defaultHorizontalCRS(false);
        boolean isSpecified = false;
        if (greenwichLongitude instanceof Number) {
            double longitude = ((Number)greenwichLongitude).doubleValue();
            Map<String, Object> properties = GridMapping.properties(definition, "prime_meridian_name", longitude == 0.0 ? "Greenwich" : null);
            meridian = datumFactory.createPrimeMeridian(properties, longitude, Units.DEGREE);
            isSpecified = true;
        } else {
            meridian = defaultDefinitions.primeMeridian();
        }
        try {
            double secondDefiningParameter;
            ParameterValue<?> p = parameters.parameter("semi_major");
            Unit<Length> axisUnit = p.getUnit().asType(Length.class);
            double semiMajor = p.doubleValue();
            boolean isIvfDefinitive = parameters.parameter("is_ivf_definitive").booleanValue();
            boolean isSphere = isIvfDefinitive ? (secondDefiningParameter = parameters.parameter("inverse_flattening").doubleValue()) == 0.0 || Double.isInfinite(secondDefiningParameter) : (secondDefiningParameter = parameters.parameter("semi_minor").doubleValue(axisUnit)) == semiMajor;
            Supplier<Object> fallback = () -> {
                Locale locale = decoder.listeners.getLocale();
                NumberFormat f = NumberFormat.getNumberInstance(locale);
                f.setMaximumFractionDigits(5);
                double km = axisUnit.getConverterTo(Units.KILOMETRE).convert(semiMajor);
                StringBuffer b = new StringBuffer().append(Vocabulary.getResources(locale).getString(isSphere ? (short)271 : (short)72)).append(isSphere ? " R=" : " a=");
                return f.format(km, b, new FieldPosition(0)).append(" km").toString();
            };
            Map<String, Object> properties = GridMapping.properties(definition, "reference_ellipsoid_name", fallback);
            ellipsoid = isIvfDefinitive ? datumFactory.createFlattenedSphere(properties, semiMajor, secondDefiningParameter, axisUnit) : datumFactory.createEllipsoid(properties, semiMajor, secondDefiningParameter, axisUnit);
            isSpecified = true;
        }
        catch (IllegalStateException | ParameterNotFoundException e) {
            ellipsoid = defaultDefinitions.ellipsoid();
        }
        Object bursaWolf = definition.remove("towgs84");
        if (isSpecified | bursaWolf != null) {
            Map<String, Object> properties = GridMapping.properties(definition, "horizontal_datum_name", ellipsoid);
            if (bursaWolf instanceof BursaWolfParameters) {
                properties = new HashMap<String, Object>(properties);
                properties.put("bursaWolf", bursaWolf);
                isSpecified = true;
            }
            datum = datumFactory.createGeodeticDatum(properties, ellipsoid, meridian);
        } else {
            datum = defaultDefinitions.datum();
        }
        if (isSpecified) {
            Map<String, Object> properties = GridMapping.properties(definition, "geographic_crs_name", datum);
            return decoder.getCRSFactory().createGeographicCRS(properties, datum, defaultDefinitions.geographic().getCoordinateSystem());
        }
        return defaultDefinitions.geographic();
    }

    private static Map<String, Object> properties(Map<String, Object> definition, String nameAttribute, Object fallback) {
        Object name = definition.remove(nameAttribute);
        if (name == null) {
            name = fallback == null ? Vocabulary.format((short)208) : (fallback instanceof IdentifiedObject ? ((IdentifiedObject)fallback).getName() : (fallback instanceof Supplier ? ((Supplier)fallback).get() : fallback.toString()));
        }
        return Map.of("name", name);
    }

    private static GridMapping parseGeoTransform(Node mapping) {
        String wkt = mapping.getAttributeAsString("spatial_ref");
        String gtr = mapping.getAttributeAsString("GeoTransform");
        if (wkt == null && gtr == null) {
            return null;
        }
        short message = 11;
        CoordinateReferenceSystem crs = null;
        AffineTransform2D gridToCRS = null;
        try {
            if (wkt != null) {
                crs = GridMapping.createFromWKT(mapping, wkt);
            }
            if (gtr != null) {
                message = 12;
                double[] c = GridMapping.parseDoubles(gtr);
                if (c.length == 6) {
                    gridToCRS = new AffineTransform2D(c[1], c[4], c[2], c[5], c[0], c[3]);
                } else {
                    GridMapping.canNotCreate(mapping, message, new DataStoreContentException(Errors.getResources(mapping.getLocale()).getString((short)133, 6, c.length)));
                }
            }
        }
        catch (NumberFormatException | ParseException e) {
            GridMapping.canNotCreate(mapping, message, e);
        }
        return new GridMapping(crs, gridToCRS, wkt != null);
    }

    private static double[] parseDoubles(String values) {
        return CharSequences.parseDoubles(values.replace(',', ' '), ' ');
    }

    private static GridMapping parseNonStandard(Node variable) {
        CoordinateReferenceSystem crs;
        boolean isWKT;
        String code = variable.getAttributeAsString("ESRI_pe_string");
        boolean bl = isWKT = code != null;
        if (!isWKT && (code = variable.getAttributeAsString("EPSG_code")) == null) {
            return null;
        }
        try {
            crs = isWKT ? GridMapping.createFromWKT(variable, code) : CRS.forCode("EPSG:" + code);
        }
        catch (ClassCastException | ParseException | FactoryException e) {
            GridMapping.canNotCreate(variable, (short)11, e);
            crs = null;
        }
        return new GridMapping(crs, null, isWKT);
    }

    private static CoordinateReferenceSystem createFromWKT(Node node, String wkt) throws ParseException {
        WKTFormat f = new WKTFormat(node.getLocale(), node.decoder.getTimeZone());
        f.setConvention(Convention.WKT1_COMMON_UNITS);
        CoordinateReferenceSystem crs = (CoordinateReferenceSystem)f.parseObject(wkt);
        Warnings warnings = f.getWarnings();
        if (warnings != null) {
            LogRecord record = new LogRecord(Level.WARNING, warnings.toString());
            record.setLoggerName("org.apache.sis.storage.netcdf");
            record.setSourceClassName(Variable.class.getCanonicalName());
            record.setSourceMethodName("getGridGeometry");
            node.decoder.listeners.warning(record);
        }
        return crs;
    }

    private static void canNotCreate(Node node, short key, Exception ex) {
        GridMapping.warning(node, ex, key, node.decoder.getFilename(), node.getName(), ex.getLocalizedMessage());
    }

    private static void warning(Node node, Exception ex, short key, Object ... arguments) {
        NamedElement.warning(node.decoder.listeners, Variable.class, "getGridGeometry", ex, null, key, arguments);
    }

    final GridGeometry createGridCRS(Variable variable) {
        List<Dimension> dimensions = variable.getGridDimensions();
        long[] upper = new long[dimensions.size()];
        for (int i = 0; i < upper.length; ++i) {
            int d = upper.length - 1 - i;
            upper[i] = dimensions.get(d).length();
        }
        return new GridGeometry(new GridExtent(null, null, upper, false), PixelInCell.CELL_CENTER, this.gridToCRS, this.crs);
    }

    final GridGeometry adaptGridCRS(Variable variable, GridGeometry implicit, PixelInCell anchor) {
        CoordinateReferenceSystem explicitCRS = this.crs;
        int firstAffectedCoordinate = 0;
        boolean isSameGrid = true;
        if (implicit.isDefined(1)) {
            CoordinateReferenceSystem implicitCRS = implicit.getCoordinateReferenceSystem();
            if (explicitCRS == null) {
                explicitCRS = implicitCRS;
            } else {
                CoordinateSystem cs = implicitCRS.getCoordinateSystem();
                firstAffectedCoordinate = AxisDirections.indexOfColinear(cs, explicitCRS.getCoordinateSystem());
                if (firstAffectedCoordinate < 0 && (firstAffectedCoordinate = AxisDirections.indexOfColinear(cs, (explicitCRS = AbstractCRS.castOrCopy(explicitCRS).forConvention(AxesConvention.RIGHT_HANDED)).getCoordinateSystem())) < 0) {
                    firstAffectedCoordinate = 0;
                    if (this.isWKT && this.crs != null) {
                        explicitCRS = this.crs;
                    }
                }
                try {
                    explicitCRS = new CRSMerger(variable.decoder).replaceComponent(implicitCRS, firstAffectedCoordinate, explicitCRS);
                }
                catch (FactoryException e) {
                    GridMapping.canNotCreate(variable, (short)11, e);
                    return null;
                }
                isSameGrid = implicitCRS.equals(explicitCRS);
                if (isSameGrid) {
                    explicitCRS = implicitCRS;
                }
            }
        }
        MathTransform explicitG2C = this.gridToCRS;
        if (implicit.isDefined(8)) {
            MathTransform implicitG2C = implicit.getGridToCRS(anchor);
            if (explicitG2C == null) {
                explicitG2C = implicitG2C;
            } else {
                try {
                    int upper;
                    int count = 0;
                    MathTransform[] components = new MathTransform[3];
                    TransformSeparator sep = new TransformSeparator(implicitG2C, variable.decoder.getMathTransformFactory());
                    if (firstAffectedCoordinate != 0) {
                        sep.addTargetDimensionRange(0, firstAffectedCoordinate);
                        components[count++] = sep.separate();
                        sep.clear();
                    }
                    components[count++] = explicitG2C;
                    int next = firstAffectedCoordinate + explicitG2C.getTargetDimensions();
                    if (next != (upper = implicitG2C.getTargetDimensions())) {
                        sep.addTargetDimensionRange(next, upper);
                        components[count++] = sep.separate();
                    }
                    if (implicitG2C.equals(explicitG2C = MathTransforms.compound(components = ArraysExt.resize(components, count)))) {
                        explicitG2C = implicitG2C;
                    } else {
                        isSameGrid = false;
                    }
                }
                catch (FactoryException e) {
                    GridMapping.canNotCreate(variable, (short)12, e);
                    return null;
                }
            }
        }
        if (isSameGrid) {
            return implicit;
        }
        return new GridGeometry(implicit.getExtent(), anchor, explicitG2C, explicitCRS);
    }
}

