/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.List;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.storage.CoverageQuery;
import org.apache.sis.storage.DataSet;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Query;
import org.apache.sis.storage.RasterLoadingStrategy;
import org.apache.sis.storage.UnsupportedQueryException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;

public interface GridCoverageResource
extends DataSet {
    public GridGeometry getGridGeometry() throws DataStoreException;

    public List<SampleDimension> getSampleDimensions() throws DataStoreException;

    default public List<double[]> getResolutions() throws DataStoreException {
        double[] resolution;
        GridGeometry gg = this.getGridGeometry();
        if (gg != null && gg.isDefined(16) && !ArraysExt.allEquals(resolution = gg.getResolution(false), Double.NaN)) {
            return List.of(resolution);
        }
        return List.of();
    }

    default public GridCoverageResource subset(Query query) throws UnsupportedQueryException, DataStoreException {
        ArgumentChecks.ensureNonNull("query", query);
        if (query instanceof CoverageQuery) {
            try {
                return ((CoverageQuery)query).execute(this);
            }
            catch (RuntimeException e) {
                throw new UnsupportedQueryException(e);
            }
        }
        throw new UnsupportedQueryException();
    }

    public GridCoverage read(GridGeometry var1, int ... var2) throws DataStoreException;

    default public RasterLoadingStrategy getLoadingStrategy() throws DataStoreException {
        return RasterLoadingStrategy.AT_READ_TIME;
    }

    default public boolean setLoadingStrategy(RasterLoadingStrategy strategy) throws DataStoreException {
        ArgumentChecks.ensureNonNull("strategy", (Object)strategy);
        return strategy == this.getLoadingStrategy();
    }
}

