/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.Map;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionVariant;
import org.apache.sis.referencing.operation.provider.MapProjection;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.util.Formulas;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.internal.DoubleDouble;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.referencing.operation.OperationMethod;

final class Initializer {
    final ContextualParameters context;
    final Parameters parameters;
    final DoubleDouble eccentricitySquared;
    final ProjectionVariant variant;

    Initializer(OperationMethod method, Parameters parameters, Map<NormalizedProjection.ParameterRole, ? extends ParameterDescriptor<? extends Number>> roles, ProjectionVariant variant) {
        ArgumentChecks.ensureNonNull("method", method);
        ArgumentChecks.ensureNonNull("parameters", parameters);
        ArgumentChecks.ensureNonNull("roles", roles);
        this.context = new ContextualParameters(method.getParameters(), 2, 2);
        this.parameters = parameters;
        this.variant = variant;
        ParameterDescriptor<? extends Number> semiMajor = roles.get((Object)NormalizedProjection.ParameterRole.SEMI_MAJOR);
        ParameterDescriptor<? extends Number> semiMinor = roles.get((Object)NormalizedProjection.ParameterRole.SEMI_MINOR);
        if (semiMajor == null) {
            semiMajor = MapProjection.SEMI_MAJOR;
        }
        if (semiMinor == null) {
            semiMinor = MapProjection.SEMI_MINOR;
        }
        double a = this.getAndStore(semiMajor);
        double b = this.getAndStore(semiMinor);
        double \u03bb0 = this.getAndStore(roles.get((Object)NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN));
        double fe = this.getAndStore(roles.get((Object)NormalizedProjection.ParameterRole.FALSE_EASTING)) - this.getAndStore(roles.get((Object)NormalizedProjection.ParameterRole.FALSE_WESTING));
        double fn = this.getAndStore(roles.get((Object)NormalizedProjection.ParameterRole.FALSE_NORTHING)) - this.getAndStore(roles.get((Object)NormalizedProjection.ParameterRole.FALSE_SOUTHING));
        DoubleDouble k = DoubleDouble.of(a, true);
        if (a == b) {
            this.eccentricitySquared = DoubleDouble.ZERO;
        } else if (variant != null && variant.useAuthalicRadius()) {
            k = DoubleDouble.of(Formulas.getAuthalicRadius(a, b), false);
            this.eccentricitySquared = DoubleDouble.ZERO;
        } else {
            boolean isIvfDefinitive;
            try {
                isIvfDefinitive = parameters.parameter("is_ivf_definitive").booleanValue();
            }
            catch (ParameterNotFoundException e) {
                isIvfDefinitive = false;
            }
            if (isIvfDefinitive) {
                DoubleDouble f = DoubleDouble.of(parameters.parameter("inverse_flattening").doubleValue(), true).inverse();
                this.eccentricitySquared = f.scalb(1).subtract(f.square());
            } else {
                this.eccentricitySquared = DoubleDouble.ONE.subtract(DoubleDouble.of(b, true).divide(k).square());
            }
            ParameterDescriptor<? extends Number> \u03c6r = roles.get((Object)NormalizedProjection.ParameterRole.LATITUDE_OF_CONFORMAL_SPHERE_RADIUS);
            if (\u03c6r != null) {
                k = this.r\u03bd2(Math.sin(Math.toRadians(parameters.doubleValue(\u03c6r))));
                k = DoubleDouble.of(b, true).divide(k);
            }
        }
        ParameterDescriptor<? extends Number> scaleFactor = roles.get((Object)NormalizedProjection.ParameterRole.SCALE_FACTOR);
        if (scaleFactor != null) {
            k = k.multiply(this.getAndStore(scaleFactor), true);
        }
        this.context.normalizeGeographicInputs(\u03bb0);
        MatrixSIS denormalize = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        denormalize.convertAfter(0, k, DoubleDouble.of(fe, true));
        denormalize.convertAfter(1, k, DoubleDouble.of(fn, true));
    }

    final double getAndStore(ParameterDescriptor<? extends Number> descriptor) {
        if (descriptor == null) {
            return 0.0;
        }
        double value = this.parameters.doubleValue(descriptor);
        Number defaultValue = descriptor.getDefaultValue();
        if (defaultValue == null || !defaultValue.equals(value)) {
            MapProjection.validate(descriptor, value);
            this.context.getOrCreate(descriptor).setValue(value);
        }
        return value;
    }

    final double getAndStore(ParameterDescriptor<Double> descriptor, double defaultValue) {
        Double value = this.parameters.getValue(descriptor);
        if (value == null) {
            return defaultValue;
        }
        MapProjection.validate(descriptor, value);
        this.context.getOrCreate(descriptor).setValue(value);
        return value;
    }

    final int getAndStore(ParameterDescriptor<Integer> descriptor, int defaultValue) {
        Integer value = this.parameters.getValue(descriptor);
        if (value == null) {
            return defaultValue;
        }
        this.context.getOrCreate(descriptor).setValue(value);
        return value;
    }

    final DoubleDouble axisLengthRatio() {
        return DoubleDouble.ONE.subtract(this.eccentricitySquared).sqrt();
    }

    final double authalicRadius() {
        return Formulas.getAuthalicRadius(1.0, this.axisLengthRatio().doubleValue());
    }

    final DoubleDouble r\u03bd2(double sin\u03c6) {
        return DoubleDouble.ONE.subtract(this.eccentricitySquared.multiply(DoubleDouble.product(sin\u03c6, sin\u03c6)));
    }

    final DoubleDouble radiusOfConformalSphere(double sin\u03c6) {
        return DoubleDouble.ONE.subtract(this.eccentricitySquared).sqrt().divide(this.r\u03bd2(sin\u03c6));
    }

    final double scaleAt\u03c6(double sin\u03c6, double cos\u03c6) {
        return DoubleDouble.of(cos\u03c6, false).divide(this.r\u03bd2(sin\u03c6).sqrt()).doubleValue();
    }
}

