/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.internal.ImplementationHelper;
import org.apache.sis.referencing.datum.AbstractDatum;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PixelInCell;

@XmlType(name="ImageDatumType")
@XmlRootElement(name="ImageDatum")
public class DefaultImageDatum
extends AbstractDatum
implements ImageDatum {
    private static final long serialVersionUID = -4304193511244150936L;
    private PixelInCell pixelInCell;

    public DefaultImageDatum(Map<String, ?> properties, PixelInCell pixelInCell) {
        super(properties);
        this.pixelInCell = pixelInCell;
        ArgumentChecks.ensureNonNull("pixelInCell", pixelInCell);
    }

    protected DefaultImageDatum(ImageDatum datum) {
        super(datum);
        this.pixelInCell = datum.getPixelInCell();
    }

    public static DefaultImageDatum castOrCopy(ImageDatum object) {
        return object == null || object instanceof DefaultImageDatum ? (DefaultImageDatum)object : new DefaultImageDatum(object);
    }

    public Class<? extends ImageDatum> getInterface() {
        return ImageDatum.class;
    }

    @Override
    @XmlElement(required=true)
    public PixelInCell getPixelInCell() {
        return this.pixelInCell;
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object, mode)) {
            return false;
        }
        switch (mode) {
            case STRICT: {
                return Objects.equals(this.pixelInCell, ((DefaultImageDatum)object).pixelInCell);
            }
        }
        return Objects.equals(this.getPixelInCell(), ((ImageDatum)object).getPixelInCell());
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hashCode(this.pixelInCell);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        Convention convention = formatter.getConvention();
        if (convention == Convention.INTERNAL) {
            formatter.append(this.getPixelInCell());
        } else if (convention.majorVersion() == 1) {
            formatter.setInvalidWKT(this, null);
        }
        return formatter.shortOrLong("IDatum", "ImageDatum");
    }

    private DefaultImageDatum() {
    }

    private void setPixelInCell(PixelInCell value) {
        if (this.pixelInCell == null) {
            this.pixelInCell = value;
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultImageDatum.class, "setPixelInCell", "pixelInCell");
        }
    }
}

