/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.MatrixParameters;
import org.apache.sis.parameter.MatrixParametersAlphaNum;
import org.apache.sis.parameter.TensorValues;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.Matrix;

public class TensorParameters<E>
implements Serializable {
    private static final long serialVersionUID = -7386537348359343836L;
    public static final TensorParameters<Double> ALPHANUM;
    public static final TensorParameters<Double> WKT1;
    static final int CACHE_SIZE = 5;
    private static final int CACHE_RANK = 3;
    private final Class<E> elementType;
    private final ParameterDescriptor<Integer>[] dimensions;
    private transient ParameterDescriptor<E>[] parameters;
    private transient E zero;
    private transient E one;
    protected final String prefix;
    protected final String separator;

    @SafeVarargs
    public TensorParameters(Class<E> elementType, String prefix, String separator, ParameterDescriptor<Integer> ... dimensions) {
        ArgumentChecks.ensureNonNull("elementType", elementType);
        ArgumentChecks.ensureNonNull("prefix", prefix);
        ArgumentChecks.ensureNonNull("separator", separator);
        ArgumentChecks.ensureNonEmpty("dimensions", dimensions);
        this.elementType = elementType;
        this.prefix = prefix;
        this.separator = separator;
        this.dimensions = new ParameterDescriptor[dimensions.length];
        for (int i = 0; i < dimensions.length; ++i) {
            this.dimensions[i] = dimensions[i];
            ArgumentChecks.ensureNonNullElement("dimensions", i, this.dimensions[i]);
        }
        this.parameters = this.createCache();
    }

    private <T> ParameterDescriptor<T>[] createCache() {
        if (Number.class.isAssignableFrom(this.elementType)) {
            try {
                this.one = Numbers.wrap(1L, this.elementType);
                this.zero = Numbers.wrap(0L, this.elementType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        int length = 1;
        int i = Math.min(this.rank(), 3);
        while (--i >= 0) {
            length *= 5;
        }
        return new ParameterDescriptor[length];
    }

    public final Class<E> getElementType() {
        return this.elementType;
    }

    public final int rank() {
        return this.dimensions.length;
    }

    private void verifyRank(int[] indices) {
        if (indices.length != this.rank()) {
            throw new IllegalArgumentException(Errors.format((short)133, this.rank(), indices.length));
        }
    }

    public final ParameterDescriptor<Integer> getDimensionDescriptor(int i) {
        return this.dimensions[i];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final ParameterDescriptor<E> getElementDescriptor(int ... indices) {
        ParameterDescriptor<E> param;
        ParameterDescriptor<E>[] parameterDescriptorArray;
        this.verifyRank(indices);
        int cacheIndex = TensorParameters.cacheIndex(indices);
        if (cacheIndex >= 0) {
            parameterDescriptorArray = this.parameters;
            // MONITORENTER : this.parameters
            param = this.parameters[cacheIndex];
            // MONITOREXIT : parameterDescriptorArray
            if (param != null) {
                return param;
            }
        }
        param = this.createElementDescriptor(indices);
        if (cacheIndex < 0) return param;
        parameterDescriptorArray = this.parameters;
        // MONITORENTER : this.parameters
        ParameterDescriptor<E> existing = this.parameters[cacheIndex];
        if (existing != null) {
            // MONITOREXIT : parameterDescriptorArray
            return existing;
        }
        this.parameters[cacheIndex] = param;
        // MONITOREXIT : parameterDescriptorArray
        return param;
    }

    private static int cacheIndex(int[] indices) {
        int cacheIndex = 0;
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            ArgumentChecks.ensurePositive("indices", index);
            if (i < 3) {
                if (index >= 0 && index < 5) {
                    cacheIndex = cacheIndex * 5 + index;
                    continue;
                }
            } else if (index == 0) continue;
            return -1;
        }
        return cacheIndex;
    }

    protected ParameterDescriptor<E> createElementDescriptor(int[] indices) throws IllegalArgumentException {
        Citation authority = this.dimensions[0].getName().getAuthority();
        String name = this.indicesToName(indices);
        return new DefaultParameterDescriptor<E>(Map.of("name", new NamedIdentifier(authority, name)), 0, 1, this.elementType, null, null, this.getDefaultValue(indices));
    }

    protected String indicesToName(int[] indices) throws IllegalArgumentException {
        this.verifyRank(indices);
        StringBuilder name = new StringBuilder();
        String s = this.prefix;
        for (int i : indices) {
            name.append(s).append(i);
            s = this.separator;
        }
        return name.toString();
    }

    protected int[] nameToIndices(String name) throws IllegalArgumentException {
        int s = this.prefix.length();
        if (!name.regionMatches(true, 0, this.prefix, 0, s)) {
            return null;
        }
        int[] indices = new int[this.rank()];
        int last = indices.length - 1;
        for (int i = 0; i < last; ++i) {
            int split = name.indexOf(this.separator, s);
            if (split < 0) {
                return null;
            }
            indices[i] = Integer.parseInt(name.substring(s, split));
            s = split + 1;
        }
        indices[last] = Integer.parseInt(name.substring(s));
        return indices;
    }

    protected E getDefaultValue(int[] indices) {
        for (int i = 1; i < indices.length; ++i) {
            if (indices[i] == indices[i - 1]) continue;
            return this.zero;
        }
        return this.one;
    }

    final ParameterDescriptor<?> descriptor(ParameterDescriptorGroup caller, String name, int[] actualSize) throws ParameterNotFoundException {
        IllegalArgumentException cause = null;
        int[] indices = null;
        try {
            indices = this.nameToIndices(name);
        }
        catch (IllegalArgumentException exception) {
            cause = exception;
        }
        if (indices != null && TensorParameters.isInBounds(indices, actualSize)) {
            return this.getElementDescriptor(indices);
        }
        for (ParameterDescriptor<Integer> param : this.dimensions) {
            if (!IdentifiedObjects.isHeuristicMatchForName(param, name)) continue;
            return param;
        }
        throw (ParameterNotFoundException)new ParameterNotFoundException(Resources.format((short)61, caller.getName(), name), name).initCause(cause);
    }

    static boolean isInBounds(int[] indices, int[] actualSize) {
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            if (index >= 0 && index < actualSize[i]) continue;
            return false;
        }
        return true;
    }

    private int numElements(int[] actualSize) {
        int n = 1;
        for (int s : actualSize) {
            ArgumentChecks.ensurePositive("actualSize", s);
            n *= s;
        }
        return n;
    }

    public ParameterDescriptor<?>[] getAllDescriptors(int ... actualSize) {
        this.verifyRank(actualSize);
        int numDimensions = actualSize.length;
        int numElements = this.numElements(actualSize);
        ParameterDescriptor[] parameters = new ParameterDescriptor[numDimensions + numElements];
        System.arraycopy(this.dimensions, 0, parameters, 0, numDimensions);
        int[] indices = new int[this.rank()];
        block0: for (int i = 0; i < numElements; ++i) {
            parameters[numDimensions + i] = this.getElementDescriptor(indices);
            int j = indices.length;
            while (--j >= 0) {
                int n = j;
                indices[n] = indices[n] + 1;
                if (indices[n] < actualSize[j]) continue block0;
                indices[j] = 0;
            }
        }
        return parameters;
    }

    public ParameterValueGroup createValueGroup(Map<String, ?> properties) {
        return new TensorValues(properties, this);
    }

    public ParameterValueGroup createValueGroup(Map<String, ?> properties, Matrix matrix) {
        if (this.rank() != 2) {
            throw new IllegalStateException();
        }
        ArgumentChecks.ensureNonNull("matrix", matrix);
        TensorValues values = new TensorValues(properties, this);
        values.setMatrix(matrix);
        return values;
    }

    public Matrix toMatrix(ParameterValueGroup parameters) throws InvalidParameterNameException {
        if (this.rank() != 2) {
            throw new IllegalStateException();
        }
        ArgumentChecks.ensureNonNull("parameters", parameters);
        if (parameters instanceof TensorValues) {
            return ((TensorValues)parameters).toMatrix();
        }
        ParameterValue<?> numRow = parameters.parameter(this.dimensions[0].getName().getCode());
        ParameterValue<?> numCol = parameters.parameter(this.dimensions[1].getName().getCode());
        MatrixSIS matrix = Matrices.createDiagonal(numRow.intValue(), numCol.intValue());
        List<GeneralParameterValue> values = parameters.values();
        if (values != null) {
            for (GeneralParameterValue param : values) {
                if (param == numRow || param == numCol) continue;
                String name = param.getDescriptor().getName().getCode();
                IllegalArgumentException cause = null;
                int[] indices = null;
                try {
                    indices = this.nameToIndices(name);
                }
                catch (IllegalArgumentException e) {
                    cause = e;
                }
                if (indices == null) {
                    throw (InvalidParameterNameException)new InvalidParameterNameException(Errors.format((short)140, name), name).initCause(cause);
                }
                matrix.setElement(indices[0], indices[1], ((ParameterValue)param).doubleValue());
            }
        }
        return matrix;
    }

    public int hashCode() {
        return Objects.hash(this.elementType, this.prefix, this.separator) ^ Arrays.hashCode(this.dimensions);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other.getClass() == this.getClass()) {
            TensorParameters that = (TensorParameters)other;
            return this.elementType.equals(that.elementType) && this.prefix.equals(that.prefix) && this.separator.equals(that.separator) && Arrays.equals(this.dimensions, that.dimensions);
        }
        return false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.parameters = this.createCache();
    }

    static {
        NumberRange<Integer> valueDomain = NumberRange.create(1, true, 50, true);
        Integer defaultSize = 3;
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        properties.put("authority", Citations.OGC);
        properties.put("code", "num_row");
        DefaultParameterDescriptor<Integer> numRow = new DefaultParameterDescriptor<Integer>(properties, 1, 1, Integer.class, valueDomain, null, defaultSize);
        properties.put("code", "num_col");
        DefaultParameterDescriptor<Integer> numCol = new DefaultParameterDescriptor<Integer>(properties, 1, 1, Integer.class, valueDomain, null, defaultSize);
        WKT1 = new MatrixParameters(numRow, numCol);
        numRow = new DefaultParameterDescriptor<Integer>(IdentifiedObjects.getProperties(numRow, new String[0]), 0, 1, Integer.class, valueDomain, null, defaultSize);
        numCol = new DefaultParameterDescriptor<Integer>(IdentifiedObjects.getProperties(numCol, new String[0]), 0, 1, Integer.class, valueDomain, null, defaultSize);
        ALPHANUM = new MatrixParametersAlphaNum(numRow, numCol);
    }
}

