/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Objects;
import org.apache.sis.coverage.grid.j2d.ColorModelFactory;
import org.apache.sis.coverage.grid.j2d.ImageUtilities;
import org.apache.sis.image.ResampledImage;
import org.apache.sis.image.SourceAlignedImage;
import org.apache.sis.image.Visualization;
import org.apache.sis.util.logging.Logging;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

final class MaskImage
extends SourceAlignedImage {
    private final MathTransform converter;

    MaskImage(ResampledImage image) {
        super(image, ColorModelFactory.createIndexColorModel(1, Math.max(0, ImageUtilities.getVisibleBand(image)), new int[]{0, -1}, true, 0));
        MathTransform converter = null;
        if (image.interpolation instanceof Visualization.InterpConvert) {
            try {
                converter = ((Visualization.InterpConvert)image.interpolation).converter.inverse();
            }
            catch (NoninvertibleTransformException e) {
                Logging.unexpectedException(ImageUtilities.LOGGER, ResampledImage.class, "getProperty", e);
            }
        }
        this.converter = converter;
    }

    @Override
    public Object getProperty(String key) {
        return POSITIONAL_PROPERTIES.contains(key) ? this.getSource().getProperty(key) : super.getProperty(key);
    }

    @Override
    public String[] getPropertyNames() {
        return MaskImage.filterPropertyNames(this.getSource().getPropertyNames(), POSITIONAL_PROPERTIES, null);
    }

    @Override
    protected Raster computeTile(int tileX, int tileY, WritableRaster tile) throws TransformException {
        Raster source = this.getSource().getTile(tileX, tileY);
        tile = this.createTile(tileX, tileY);
        int numBands = tile.getNumBands();
        int tileMinX = tile.getMinX();
        int tileMinY = tile.getMinY();
        int tileMaxY = Math.addExact(tileMinY, tile.getHeight());
        int tileWidth = tile.getWidth();
        float[] row = new float[Math.multiplyExact(tileWidth, numBands)];
        for (int y = tileMinY; y < tileMaxY; ++y) {
            source.getPixels(tileMinX, y, tileWidth, 1, row);
            if (this.converter != null) {
                this.converter.transform(row, 0, row, 0, tileWidth);
            }
            for (int i = 0; i < row.length; ++i) {
                if (!Float.isNaN(row[i])) continue;
                int x = i / numBands + tileMinX;
                tile.setSample(x, y, 0, 1);
            }
        }
        return tile;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 97 * Objects.hashCode(this.converter);
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            MaskImage other = (MaskImage)object;
            return Objects.equals(this.converter, other.converter);
        }
        return false;
    }
}

