/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.util;

import java.lang.reflect.InvocationTargetException;

public class ClassLoaderUtil {
    public static <T> T buildClass(Class<T> iface, String className) {
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        try {
            Class<?> clazz = loader.loadClass(className);
            if (iface.isAssignableFrom(clazz)) {
                return (T)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            throw new IllegalArgumentException(iface + " is not assignable from " + className);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

