/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.fs;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.tika.batch.OutputStreamFactory;
import org.apache.tika.batch.fs.FSProperties;
import org.apache.tika.batch.fs.FSUtil;
import org.apache.tika.metadata.Metadata;

public class FSOutputStreamFactory
implements OutputStreamFactory {
    private final FSUtil.HANDLE_EXISTING handleExisting;
    private final Path outputRoot;
    private final String suffix;
    private final COMPRESSION compression;

    public FSOutputStreamFactory(Path outputRoot, FSUtil.HANDLE_EXISTING handleExisting, COMPRESSION compression, String suffix) {
        this.handleExisting = handleExisting;
        this.outputRoot = outputRoot;
        this.suffix = suffix;
        this.compression = compression;
    }

    @Override
    public OutputStream getOutputStream(Metadata metadata) throws IOException {
        String initialRelativePath = metadata.get(FSProperties.FS_REL_PATH);
        Path outputPath = FSUtil.getOutputPath(this.outputRoot, initialRelativePath, this.handleExisting, this.suffix);
        if (outputPath == null) {
            return null;
        }
        if (!Files.isDirectory(outputPath.getParent(), new LinkOption[0])) {
            Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
            if (!Files.isDirectory(outputPath.getParent(), new LinkOption[0])) {
                throw new IOException("Couldn't create parent directory for:" + outputPath.toAbsolutePath());
            }
        }
        OutputStream os = Files.newOutputStream(outputPath, new OpenOption[0]);
        switch (this.compression) {
            case BZIP2: {
                os = new BZip2CompressorOutputStream(os);
                break;
            }
            case GZIP: {
                os = new GZIPOutputStream(os);
                break;
            }
            case ZIP: {
                os = new ZipArchiveOutputStream(os);
            }
        }
        return new BufferedOutputStream(os);
    }

    public static enum COMPRESSION {
        NONE,
        BZIP2,
        GZIP,
        ZIP;

    }
}

