/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import opennlp.tools.ml.model.Event;
import opennlp.tools.util.AbstractObjectStream;
import opennlp.tools.util.ObjectStream;

public class HashSumEventStream
extends AbstractObjectStream<Event> {
    private final MessageDigest digest;

    public HashSumEventStream(ObjectStream<Event> eventStream) {
        super(eventStream);
        try {
            this.digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Event read() throws IOException {
        Event event = (Event)super.read();
        if (event != null) {
            this.digest.update(event.toString().getBytes(StandardCharsets.UTF_8));
        }
        return event;
    }

    public BigInteger calculateHashSum() {
        return new BigInteger(1, this.digest.digest());
    }
}

