/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle;

import java.util.Arrays;
import java.util.Collection;
import org.apache.tez.runtime.library.common.CompositeInputAttemptIdentifier;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;

public class InputAttemptFetchFailure {
    private final InputAttemptIdentifier inputAttemptIdentifier;
    private final boolean isLocalFetch;
    private final boolean isDiskErrorAtSource;
    private Throwable cause = null;

    public InputAttemptFetchFailure(InputAttemptIdentifier inputAttemptIdentifier) {
        this(inputAttemptIdentifier, false, false);
    }

    public InputAttemptFetchFailure(InputAttemptIdentifier inputAttemptIdentifier, boolean isLocalFetch, boolean isDiskErrorAtSource) {
        this.inputAttemptIdentifier = inputAttemptIdentifier;
        this.isLocalFetch = isLocalFetch;
        this.isDiskErrorAtSource = isDiskErrorAtSource;
    }

    public InputAttemptIdentifier getInputAttemptIdentifier() {
        return this.inputAttemptIdentifier;
    }

    public boolean isLocalFetch() {
        return this.isLocalFetch;
    }

    public boolean isDiskErrorAtSource() {
        return this.isDiskErrorAtSource;
    }

    public static InputAttemptFetchFailure fromAttempt(InputAttemptIdentifier attempt) {
        return new InputAttemptFetchFailure(attempt, false, false);
    }

    public static InputAttemptFetchFailure fromLocalFetchFailure(InputAttemptIdentifier attempt) {
        return new InputAttemptFetchFailure(attempt, true, false);
    }

    public static InputAttemptFetchFailure fromDiskErrorAtSource(InputAttemptIdentifier attempt) {
        return new InputAttemptFetchFailure(attempt, false, true);
    }

    public static InputAttemptFetchFailure[] fromAttempts(Collection<InputAttemptIdentifier> values) {
        return (InputAttemptFetchFailure[])values.stream().map(identifier -> new InputAttemptFetchFailure((InputAttemptIdentifier)identifier, false, false)).toArray(InputAttemptFetchFailure[]::new);
    }

    public static InputAttemptFetchFailure[] fromAttempts(InputAttemptIdentifier[] values) {
        return (InputAttemptFetchFailure[])Arrays.asList(values).stream().map(identifier -> new InputAttemptFetchFailure((InputAttemptIdentifier)identifier, false, false)).toArray(InputAttemptFetchFailure[]::new);
    }

    public static InputAttemptFetchFailure[] fromAttemptsLocalFetchFailure(Collection<InputAttemptIdentifier> values) {
        return (InputAttemptFetchFailure[])values.stream().map(identifier -> new InputAttemptFetchFailure((InputAttemptIdentifier)identifier, true, false)).toArray(InputAttemptFetchFailure[]::new);
    }

    public static InputAttemptFetchFailure fromCompositeAttemptLocalFetchFailure(CompositeInputAttemptIdentifier compositeInputAttemptIdentifier) {
        return new InputAttemptFetchFailure(compositeInputAttemptIdentifier, true, false);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return this.inputAttemptIdentifier.equals(((InputAttemptFetchFailure)obj).inputAttemptIdentifier) && this.isLocalFetch == ((InputAttemptFetchFailure)obj).isLocalFetch && this.isDiskErrorAtSource == ((InputAttemptFetchFailure)obj).isDiskErrorAtSource;
    }

    public int hashCode() {
        return 31 * this.inputAttemptIdentifier.hashCode() + 31 * (this.isLocalFetch ? 0 : 1) + 31 * (this.isDiskErrorAtSource ? 0 : 1);
    }

    public String toString() {
        return String.format("%s, isLocalFetch: %s, isDiskErrorAtSource: %s", this.inputAttemptIdentifier.toString(), this.isLocalFetch, this.isDiskErrorAtSource);
    }

    public InputAttemptFetchFailure withCause(Throwable throwable) {
        this.cause = throwable;
        return this;
    }

    public Throwable getCause() {
        return this.cause;
    }
}

