/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.processor;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.tez.common.ProgressHelper;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.mapreduce.hadoop.mapred.MRCounters;
import org.apache.tez.mapreduce.hadoop.mapred.MRReporter;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.api.TaskContext;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class MRTaskReporter
extends StatusReporter
implements Reporter {
    private final TaskContext context;
    private final boolean isProcessorContext;
    private final MRReporter reporter;
    private InputSplit split = null;

    public MRTaskReporter(ProcessorContext context) {
        this.context = context;
        this.reporter = new MRReporter(context.getCounters());
        this.isProcessorContext = true;
    }

    public MRTaskReporter(OutputContext context) {
        this.context = context;
        this.reporter = new MRReporter(context.getCounters());
        this.isProcessorContext = false;
    }

    public MRTaskReporter(InputContext context) {
        this.context = context;
        this.reporter = new MRReporter(context.getCounters());
        this.isProcessorContext = false;
    }

    public void setProgress(float progress) {
        progress = ProgressHelper.processProgress((float)progress);
        this.reporter.setProgress(progress);
        if (this.isProcessorContext) {
            ((ProcessorContext)this.context).setProgress(progress);
        }
    }

    public void setStatus(String status) {
        this.reporter.setStatus(status);
    }

    public float getProgress() {
        return this.reporter.getProgress();
    }

    public void progress() {
        this.reporter.progress();
    }

    public Counters.Counter getCounter(String group, String name) {
        TezCounter counter = this.context.getCounters().findCounter(group, name);
        MRCounters.MRCounter mrCounter = null;
        if (counter != null) {
            mrCounter = new MRCounters.MRCounter(counter);
        }
        return mrCounter;
    }

    public Counters.Counter getCounter(Enum<?> name) {
        TezCounter counter = this.context.getCounters().findCounter(name);
        MRCounters.MRCounter mrCounter = null;
        if (counter != null) {
            mrCounter = new MRCounters.MRCounter(counter);
        }
        return mrCounter;
    }

    public void incrCounter(Enum<?> key, long amount) {
        this.reporter.incrCounter(key, amount);
    }

    public void incrCounter(String group, String counter, long amount) {
        this.reporter.incrCounter(group, counter, amount);
    }

    public void setInputSplit(InputSplit split) {
        this.split = split;
    }

    public InputSplit getInputSplit() throws UnsupportedOperationException {
        if (this.split == null) {
            throw new UnsupportedOperationException("Input only available on map");
        }
        return this.split;
    }
}

